-- Version vom 06.10.2023 12:30
-- gewählte Pakete: alle
-- gewählte Filter: 

BEGIN;

SET search_path = :"alkis_schema", :"postgis_schema", public;

CREATE TABLE ap_dateityp_3d (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ap_dateityp_3d IS 'Alias: "AP_DateiTyp_3D", UML-Typ: Enumeration';
INSERT INTO ap_dateityp_3d (wert,beschreibung,dokumentation) VALUES
('1000', 'CityGML', 'OGC-Standard'),
('2000', 'VRML', 'ISO-Standard'),
('3000', 'kml', 'OGC-Standard'),
('4000', 'X3D', 'ISO-Standard'),
('5000', 'COLLADA', ''),
('9990', 'unbekannt', '');
CREATE TABLE aa_advstandardmodell (
  wert character varying,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE aa_advstandardmodell IS 'Alias: "AA_AdVStandardModell", UML-Typ: Enumeration';
INSERT INTO aa_advstandardmodell (wert,beschreibung,dokumentation) VALUES
('BRM', 'Bodenrichtwertemodell', 'BRM beinhaltet die Wertermittlungsinformationen der Gutachterausschüsse für die Grundstückswerte der Bundesrepublik Deutschland.'),
('Basis-DLM', 'BasisLandschaftsModell', ''),
('DFGM', 'Festpunktmodell', ''),
('DHM', 'DigitalesHoehenmodell', ''),
('DKKM1000', 'KatasterkartenModell1000', ''),
('DKKM2000', 'KatasterkartenModell2000', ''),
('DKKM500', 'KatasterkartenModell500', ''),
('DKKM5000', 'KatasterkartenModell5000', ''),
('DLKM', 'LiegenschaftskatasterModell', ''),
('DLM1000', 'LandschaftsModell1000', ''),
('DLM250', 'LandschaftsModell250', ''),
('DLM50', 'LandschaftsModell50', ''),
('DTK10', 'TopographischeKarte10', ''),
('DTK100', 'TopographischeKarte100', ''),
('DTK1000', 'TopographischeKarte1000', ''),
('DTK25', 'TopographischeKarte25', ''),
('DTK250', 'TopographischeKarte250', ''),
('DTK50', 'TopographischeKarte50', ''),
('GVM', 'GeometrischesVerbesserungsModell', ''),
('GeoBasis-DE', 'LandbedeckungLandnutzung', 'GeoBasis-DE beinhaltet die Geobasisdaten der Landbedeckung (LB) und der Landnutzung (LN) der Bundesrepublik Deutschland.'),
('LoD1', 'LevelOfDetail1', ''),
('LoD2', 'LevelOfDetail2', ''),
('LoD3', 'LevelOfDetail3', '');
CREATE TABLE aa_themendimension (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE aa_themendimension IS 'Alias: "AA_Themendimension", UML-Typ: Enumeration';
INSERT INTO aa_themendimension (wert,beschreibung,dokumentation) VALUES
('1000', 'Punkt-Linien-Thema (Dimension 1)', ''),
('2000', 'Topologiethema (Dimension 2)', '');
CREATE TABLE nas_filter_capabilities (
  wert character varying,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE nas_filter_capabilities IS 'Alias: "NAS_Filter_Capabilities", UML-Typ: Enumeration';
INSERT INTO nas_filter_capabilities (wert,beschreibung,dokumentation) VALUES
('PropertyIsOfType', NULL, ''),
('transparentXlinks', NULL, ''),
('PropertyName', NULL, ''),
('multiplePropertyValues', NULL, ''),
('XlinkPropertyPath_leafOnly', NULL, '');
CREATE TABLE aa_nas_ausgabeform (
  wert character varying,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE aa_nas_ausgabeform IS 'Alias: "AA_NAS_Ausgabeform", UML-Typ: Enumeration';
INSERT INTO aa_nas_ausgabeform (wert,beschreibung,dokumentation) VALUES
('application/xml', NULL, ''),
('application/zip', NULL, ''),
('application/gzip', NULL, '');
CREATE TABLE operation (
  wert character varying,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE operation IS 'Alias: "Operation", UML-Typ: Enumeration';
INSERT INTO operation (wert,beschreibung,dokumentation) VALUES
('Insert', NULL, ''),
('Query', NULL, ''),
('Unlock', NULL, ''),
('Reserve', NULL, ''),
('Lock', NULL, ''),
('Replace', NULL, ''),
('Delete', NULL, '');
CREATE TABLE aa_art_themendefinition (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE aa_art_themendefinition IS 'Alias: "AA_Art_Themendefinition", UML-Typ: Enumeration';
INSERT INTO aa_art_themendefinition (wert,beschreibung,dokumentation) VALUES
('1000', 'alleObjekte', 'Diese Werteart bedeutet eine zwingende Themenbildung. Dabei sind alle in der Themendefinition genannten Objektarten Bestandteil des Themas und die Objektarten teilen sich stets die Geometrien.');
CREATE TABLE ap_horizontaleausrichtung (
  wert character varying,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ap_horizontaleausrichtung IS 'Alias: "AP_HorizontaleAusrichtung", UML-Typ: Enumeration';
INSERT INTO ap_horizontaleausrichtung (wert,beschreibung,dokumentation) VALUES
('linksbündig', NULL, 'Text linksbündig am Textpunkt bzw. am ersten Punkt der Linie.'),
('rechtsbündig', NULL, 'Text rechtsbündig am Textpunkt bzw. am letzten Punkt der Linie.'),
('zentrisch', NULL, 'Text zentriert am Textpunkt bzw. in der Mitte der Textstandlinie.');
CREATE TABLE ap_vertikaleausrichtung (
  wert character varying,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ap_vertikaleausrichtung IS 'Alias: "AP_VertikaleAusrichtung", UML-Typ: Enumeration';
INSERT INTO ap_vertikaleausrichtung (wert,beschreibung,dokumentation) VALUES
('Basis', NULL, 'Textgeometrie bezieht sich auf die Basis- bzw. Grundlinie der Buchstaben.'),
('Mitte', NULL, 'Textgeometrie bezieht sich auf die Mittellinie der Buchstaben.'),
('oben', NULL, 'Textgeometrie bezieht sich auf die Oberlinie der Großbuchstaben.');
CREATE TABLE ax_ergebnisderueberpruefung_bauwerkeeinrichtungenundsonsti (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_ergebnisderueberpruefung_bauwerkeeinrichtungenundsonsti IS 'Alias: "AX_ErgebnisDerUeberpruefung_BauwerkeEinrichtungenUndSonstigeAngaben", UML-Typ: Enumeration';
INSERT INTO ax_ergebnisderueberpruefung_bauwerkeeinrichtungenundsonsti (wert,beschreibung,dokumentation) VALUES
('1000', 'Fehlerkorrektur', 'Fehlerkorrektur beschreibt dass eine Anpassung durchgeführt wurde, obwohl in der Realwelt keine tatsächliche Änderung stattgefunden hat.'),
('2000', 'Bestätigung des Ist-Zustandes', 'Bestätigung des Ist-Zustandes beschreibt, dass das Objekt zum Zeitpunkt einer Überprüfung als zutreffend ermittelt wurde.'),
('3000', 'Erfassung eines neuen Objektes', 'Erfassung eines neuen Objektes beschreibt, dass eine tatsächliche Änderungen in der Realwelt zur Neubildung des Objektes geführt haben. Das bedeutet, dass eine fachliche Änderung auf Ebene der Objekt- und/oder Attributart stattfand.'),
('4000', 'Geometrieveränderung eines bestehenden Objektes', 'Geometrieveränderung eines bestehenden Objektes beschreibt eine Änderung der Umringsgeometrie in der Realwelt, ohne das eine fachliche Änderung auf Ebene der Objekt- oder Attributart stattfand.');
CREATE TABLE ax_datenerhebung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_datenerhebung IS 'Alias: "AX_Datenerhebung", UML-Typ: Enumeration';
INSERT INTO ax_datenerhebung (wert,beschreibung,dokumentation) VALUES
('1000', 'Aus Katastervermessung ermittelt', ''),
('1100', 'Aufgrund Anforderungen mit Netzanschluss ermittelt', ''),
('1200', 'Aufgrund Anforderungen mit Bezug zur Flurstücksgrenze ermittelt', ''),
('1900', 'Aus sonstiger Vermessung ermittelt', ''),
('2000', 'Aus Luftbildmessung oder Fernerkundungsdaten ermittelt', ''),
('4000', 'Aus Katasterunterlagen und Karten für graphische Zwecke ermittelt', ''),
('4100', 'Aus Katasterzahlen für graphische Zwecke ermittelt', ''),
('4200', 'Aus Katasterkarten digitalisiert', ''),
('4210', 'Aus Katasterkarten digitalisiert, Kartenmaßstab M größer gleich 1 zu 1000', ''),
('4220', 'Aus Katasterkarten digitalisiert, Kartenmaßstab 1 zu 1000 größer M größer gleich 1 zu 2000', ''),
('4230', 'Aus Katasterkarten digitalisiert, Kartenmaßstab 1 zu 2000 größer M größer gleich 1 zu 3000', ''),
('4240', 'Aus Katasterkarten digitalisiert, Kartenmaßstab 1 zu 3000 größer M größer gleich 1 zu 5000', ''),
('4250', 'Aus Katasterkarten digitalisiert, Kartenmaßstab 1 zu 5000 größer M', ''),
('4300', 'Aus sonstigen Unterlagen digitalisiert', ''),
('4310', 'Aus sonstigen Unterlagen digitalisiert, Kartenmaßstab M größer gleich 1 zu 1000', ''),
('4320', 'Aus sonstigen Unterlagen digitalisiert, Kartenmaßstab 1 zu 1000 größer M größer gleich 1 zu 2000', ''),
('4330', 'Aus sonstigen Unterlagen digitalisiert, Kartenmaßstab 1 zu 2000 größer M größer gleich 1 zu 3000', ''),
('4340', 'Aus sonstigen Unterlagen digitalisiert, Kartenmaßstab 1 zu 3000 größer M größer gleich 1 zu 5000', ''),
('4350', 'Aus sonstigen Unterlagen digitalisiert, Kartenmaßstab 1 zu 5000 größer M', ''),
('4360', 'Aus sonstigen Unterlagen digitalisiert, mit sonstigen geometrischen Bedingungen und bzw. oder Homogenisierung (M größer gleich 1 zu 1000)', ''),
('4370', 'Aus sonstigen Unterlagen digitalisiert, mit Berechnung oder Abstandsbedingung (M größer gleich 1 zu 1000)', ''),
('4380', 'Aus sonstigen Unterlagen digitalisiert, mit sonstigen geometrischen Bedingungen und bzw. oder Homogenisierung (M kleiner 1 zu 1000)', ''),
('4390', 'Aus sonstigen Unterlagen digitalisiert, mit Berechnung oder Abstandsbedingungen (M kleiner 1 zu 1000)', ''),
('9998', 'Nach Quellenlage nicht zu spezifizieren', ''),
('9999', 'Sonstiges', '');
CREATE TABLE ax_li_processstep_mitdatenerhebung_description (
  wert character varying,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_li_processstep_mitdatenerhebung_description IS 'Alias: "AX_LI_ProcessStep_MitDatenerhebung_Description", UML-Typ: Enumeration';
INSERT INTO ax_li_processstep_mitdatenerhebung_description (wert,beschreibung,dokumentation) VALUES
('Erhebung', NULL, '');
CREATE TABLE ax_art_gleis (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_art_gleis IS 'Alias: "AX_Art_Gleis", UML-Typ: Enumeration';
INSERT INTO ax_art_gleis (wert,beschreibung,dokumentation) VALUES
('1200', 'Drehscheibe', '');
CREATE TABLE ax_bahnkategorie_gleis (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_bahnkategorie_gleis IS 'Alias: "AX_Bahnkategorie_Gleis", UML-Typ: Enumeration';
INSERT INTO ax_bahnkategorie_gleis (wert,beschreibung,dokumentation) VALUES
('1100', 'Eisenbahn', 'Eisenbahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem im Nah- und Fernverkehr Personen befördert und/oder Güter transportiert werden.'),
('1101', 'Personenverkehr', 'Personenverkehr ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem im Nah- und Fernverkehr Personen transportiert werden.'),
('1102', 'Güterverkehr', 'Güterverkehr ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem im Nah- und Fernverkehr Güter transportiert werden.'),
('1103', 'Betriebsverkehr', 'Betriebsverkehr ist die Bezeichnung für ein Gleis, das aus innerbetrieblichen Gründen erforderlich ist.'),
('1104', 'S-Bahn', 'S-Bahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, der zur schnellen Personenbeförderung in Ballungsräumen dient und meist auf eigenen Gleisen verläuft.'),
('1200', 'Stadtbahn', 'Stadtbahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem eine elektrisch betriebene Schienenbahn zur Personenbeförderung im öffentlichen Nahverkehr fährt. Sie kann sowohl ober- als auch unterirdisch verlaufen.'),
('1201', 'Straßenbahn', 'Straßenbahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem eine elektrisch betriebene Schienenbahn zur Personenbeförderung fährt. Sie verläuft i. d. R. oberirdisch.'),
('1202', 'U-Bahn', 'U-Bahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem eine elektrisch betriebene Schienenbahn zur Personenbeförderung in Großstädten fährt. Sie verläuft i. d. R. unterirdisch.'),
('1300', 'Seilbahn, Bergbahn', 'Seilbahn, Bergbahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem eine Schienenbahn große Höhenunterschiede überwindet.'),
('1301', 'Zahnradbahn', 'Zahnradbahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem eine Schienenbahn mittels Zahnradantrieb große Höhenunterschiede in stark geneigtem Gelände überwindet.'),
('1302', 'Standseilbahn', 'Standseilbahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem eine Schienenbahn auf einer stark geneigten, meist kurzen und geraden Strecke verläuft. Mit Hilfe eines oder mehrerer Zugseile wird ein Schienenfahrzeug bergauf gezogen und gleichzeitig ein zweites bergab gelassen.'),
('1400', 'Museumsbahn', 'Museumsbahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem ausschließlich Touristen in alten, meist restaurierten Zügen befördert werden.'),
('1500', 'Bahn im Freizeitpark', 'Bahn im Freizeitpark ist die Bezeichnung für einen schienengebundenen Verkehrsweg innerhalb eines Freizeitparks.'),
('1600', 'Magnetschwebebahn', 'Magnetschwebebahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem räderlose Schienenfahrzeuge mit Hilfe von Magnetfeldern an oder auf einer Fahrschiene schwebend entlanggeführt werden.'),
('9999', 'Sonstiges', 'Sonstiges bedeutet, dass die Bahnkategorie bekannt, aber nicht in der Attributwertliste aufgeführt ist.');
CREATE TABLE ax_zustand_bauwerkimverkehrsbereich (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_bauwerkimverkehrsbereich IS 'Alias: "AX_Zustand_BauwerkImVerkehrsbereich", UML-Typ: Enumeration';
INSERT INTO ax_zustand_bauwerkimverkehrsbereich (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb, stillgelegt, verlassen', 'Außer Betrieb, stillgelegt, verlassen bedeutet, dass sich Bauwerk im Verkehrsbereich nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('4000', 'Im Bau', 'Im Bau bedeutet, dass sich überwiegende Teile von Bauwerk im Verkehrsbereich im Bau befinden.');
CREATE TABLE ax_zustand_bahnverkehrsanlage (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_bahnverkehrsanlage IS 'Alias: "AX_Zustand_Bahnverkehrsanlage", UML-Typ: Enumeration';
INSERT INTO ax_zustand_bahnverkehrsanlage (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb, stillgelegt, verlassen', 'Außer Betrieb, stillgelegt, verlassen bedeutet, dass sich die Bahnverkehrsanlage nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('4000', 'Im Bau', 'Im Bau bedeutet, dass sich überwiegende Teile der Bahnverkehrsanlage im Bau befinden.');
CREATE TABLE ax_lagezuroberflaeche_gleis (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_lagezuroberflaeche_gleis IS 'Alias: "AX_LageZurOberflaeche_Gleis", UML-Typ: Enumeration';
INSERT INTO ax_lagezuroberflaeche_gleis (wert,beschreibung,dokumentation) VALUES
('1200', 'Unter der Erdoberfläche', ''),
('1400', 'Aufgeständert', '');
CREATE TABLE ax_art_flugverkehrsanlage (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_art_flugverkehrsanlage IS 'Alias: "AX_Art_Flugverkehrsanlage", UML-Typ: Enumeration';
INSERT INTO ax_art_flugverkehrsanlage (wert,beschreibung,dokumentation) VALUES
('1310', 'Startbahn, Landebahn', 'Startbahn, Landebahn ist eine Fläche, auf der Flugzeuge starten bzw. landen.'),
('1320', 'Zurollbahn, Taxiway', 'Zurollbahn, Taxiway ist ein Verbindungsweg zwischen den Terminals bzw. dem Vorfeld und der Start- und/oder Landebahn.'),
('1330', 'Vorfeld', 'Vorfeld ist ein Bereich, in dem Flugzeuge abgefertigt und abgestellt werden.'),
('5521', 'Verkehrslandeplatz', 'Verkehrslandeplatz ist ein Flugplatz, der im Luftfahrthandbuch als Flugplatz, Landeplatz oder Verkehrslandeplatz ausgewiesen ist.'),
('5522', 'Sonderlandeplatz', 'Sonderlandeplatz ist ein Flugplatz, der im Luftfahrthandbuch oder in den Bescheiden der zuständigen Luftfahrtbehörden als Sonderlandeplatz ausgewiesen ist.'),
('5530', 'Hubschrauberlandeplatz', 'Hubschrauberlandeplatz ist ein Flugplatz, der im Luftfahrthandbuch, in der Luftfahrtkarte 1:500000 (ICAO) oder aufgrund von Ländervorschriften als solcher ausgewiesen ist.'),
('5550', 'Segelfluggelände', 'Segelfluggelände ist ein Flugplatz, der in der Luftfahrtkarte 1:500000 (ICAO) für den Segelflugsport ausgewiesen ist.'),
('5560', 'Wasserlandeplatz', 'Wasserlandeplatz ist ein Flugplatz, der im Luftfahrthandbuch als Sonderlandeplatz mit einem Start- und Landebahnoberflächentyp "Wasser" ausgewiesen ist.'),
('9998', 'Nach Quellenlage nicht zu spezifizieren', 'Nach Quellenlage nicht zu spezifizieren bedeutet, dass keine Aussage über die Werteart gemacht werden kann.');
CREATE TABLE ax_bahnhofskategorie_bahnverkehrsanlage (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_bahnhofskategorie_bahnverkehrsanlage IS 'Alias: "AX_Bahnhofskategorie_Bahnverkehrsanlage", UML-Typ: Enumeration';
INSERT INTO ax_bahnhofskategorie_bahnverkehrsanlage (wert,beschreibung,dokumentation) VALUES
('1010', 'Bahnhof', 'Bahnhof ist eine Anlage im Netz der Schienenbahnen und der Seilbahnen (Bahnkategorie Schwebebahn) zur Abwicklung des Personen- und Güterverkehrs entsprechend der Angaben des Betreibers.'),
('1020', 'Haltestelle', 'Haltestelle ist eine Anlage im Netz der Schienenbahnen und der Seilbahnen (Bahnkategorie Schwebebahn) zur Abwicklung des Personen- und Güterverkehrs entsprechend der Angaben des Betreibers.'),
('1030', 'Haltepunkt', 'Haltepunkt ist eine Anlage im Netz der Schienenbahnen und der Seilbahnen (Bahnkategorie Schwebebahn) zur Abwicklung des Personen- und Güterverkehrs entsprechend der Angaben des Betreibers.');
CREATE TABLE ax_bauwerksfunktion_bauwerkimgewaesserbereich (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_bauwerksfunktion_bauwerkimgewaesserbereich IS 'Alias: "AX_Bauwerksfunktion_BauwerkImGewaesserbereich", UML-Typ: Enumeration';
INSERT INTO ax_bauwerksfunktion_bauwerkimgewaesserbereich (wert,beschreibung,dokumentation) VALUES
('2010', 'Durchlass', 'Durchlass ist ein Bauwerk, in dem ein Gewässer unter einem auf der Erdoberfläche liegenden Hindernis (Verkehrsweg, Siedlungsfläche) hindurchgeführt wird oder unter der Erdoberfläche in freier Feldlage oder abgedeckt (verdolt) auf der Erdoberfläche verläuft.'),
('2011', 'Rohrdurchlass', 'Rohrdurchlass ist ein Bauwerk zur Unterführung eines Gewässers unter einem Verkehrsweg.'),
('2012', 'Düker', 'Düker ist ein Kreuzungsbauwerk, in dem ein Gewässer unter einem anderen Gewässer, einem Geländeeinschnitt oder einem tieferliegenden Hindernis unter Druck hindurchgeleitet wird.'),
('2013', 'Wassertunnel, Wasserstollen, Druckstollen', 'Wassertunnel, Wasserstollen, Druckstollen ist ein in einen Berg oder Hügel getriebener unterirdischer Tunnel (Stollen), durch den Wasser hindurchgeführt wird. Dabei fließt das Wasser in einem Wassertunnel bzw. Wasserstollen in Richtung des gebauten Gefälles. In einem Druckstollen, der als Wasserleitung genutzt wird, baut sich durch die vollständige Füllung des Stollens ein hydrostatischer Wasserdruck auf, so dass das Wasser auch ansteigende Abschnitte überwinden kann.'),
('2020', 'Rückhaltebecken', 'Rückhaltebecken ist ein natürliches oder künstlich angelegtes Becken, ggf. mit Bauwerken und Einrichtungen, zur vorübergehenden Speicherung großer Wassermengen.'),
('2030', 'Staumauer', 'Staumauer ist ein aus Mauerwerk oder Beton bestehendes Absperrbauwerk zur Erzeugung eines Staus.'),
('2040', 'Staudamm', 'Staudamm ist ein meist aus natürlichen Baustoffen, meist aufgeschüttetes Absperrbauwerk zur Erzeugung eines Staus.'),
('2050', 'Wehr', 'Wehr ist ein festes oder mit beweglichen Teilen ausgestattetes Bauwerk im Gewässerbereich zur Regulierung des Wasserabflusses.'),
('2060', 'Sicherheitstor', 'Sicherheitstor ist ein Bauwerk zum Abschließen von Kanalstrecken, um bei Schäden das Auslaufen der gesamten Kanalhaltung zu verhindern.'),
('2070', 'Siel', 'Siel ist ein Bauwerk mit Verschlusseinrichtung (gegen rückströmendes Wasser) zum Durchleiten eines oberirdischen Gewässers durch einen Deich.'),
('2080', 'Sperrwerk', 'Sperrwerk ist ein Bauwerk in einem Tideflussgewässer mit Verschlusseinrichtung zum Absperren bestimmter Tiden, vor allem zum Schutz gegen Sturmfluten auch bei Tidehäfen.'),
('2085', 'Verschlussbauwerk', 'Verschlussbauwerk ist ein Bauwerk mit einem Verschlussmechanismus zur Regulierung des Wasserablaufs bzw. zum Schutz vor Hochwasser.'),
('2090', 'Schöpfwerk', 'Schöpfwerk ist eine Anlage, in der Pumpen Wasser einem höher gelegenen Vorfluter zuführen, u. a. zur künstlichen Entwässerung von landwirtschaftlich genutzten Flächen und im Falle von Polder- und Mündungsschöpfwerken auch zur Sicherstellung des Hochwasser- oder Überschwemmungsschutzes.'),
('2110', 'Fischtreppe', 'Fischtreppeist eine Vorrichtung mit Stufen oder Wasserbecken für Fische, um Höhenunterschiede im Gewässer zu überwinden.'),
('2120', 'Pegel', 'Pegel ist eine Messeinrichtung zur Feststellung des Wasserstandes von Gewässern.'),
('2130', 'Uferbefestigung', 'Uferbefestigung ist eine Anlage zum Schutze des Ufers.'),
('2131', 'Wellenbrecher, Buhne', 'Wellenbrecher, Buhne ist ein ins Meer oder in den Fluss hinein angelegtes Bauwerk zum Uferschutz aus Buschwerk, Holz, Stein, Stahlbeton oder Asphalt.'),
('2132', 'Lahnung', 'Lahnung ist ein Bauwerk zum Küstenschutz und zur Landgewinnung zumeist im Wattenmeer. Es besteht aus doppelten Holzpflockreihen, mit dazwischen geschnürten Sträuchern, den sog. Faschinen. Bei ablaufendem Wasser sammeln sich hinter der Lahnung Sedimente und Schlick.'),
('2133', 'Hafendamm, Mole', 'Hafendamm, Mole ist ein in das Wasser vorgestreckter Steindamm, der eine Hafeneinfahrt begrenzt und das Hafenbecken vor Strömung und Wellenschlag schützt.'),
('2134', 'Höft', 'Höft ist eine vorspringende Ecke bei Kaimauern in einem Hafen.'),
('2135', 'Deckwerk', 'Deckwerk ist ein geböschter Uferschutz an Schardeichen (Deiche ohne Vorland).'),
('2136', 'Ufermauer, Kaimauer', 'Ufermauer, Kaimauer ist eine Mauer entlang der Uferlinie eines Gewässers zum Schutz des Ufers bzw. eine Uferbefestigung im Hafengelände zum Anlegen von Schiffen.'),
('9999', 'Sonstiges', 'Sonstiges bedeutet, dass die Bauwerksfunktion bekannt, aber nicht in der Attributwertliste aufgeführt ist.');
CREATE TABLE ax_bauwerksfunktion_bauwerkimverkehrsbereich (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_bauwerksfunktion_bauwerkimverkehrsbereich IS 'Alias: "AX_Bauwerksfunktion_BauwerkImVerkehrsbereich", UML-Typ: Enumeration';
INSERT INTO ax_bauwerksfunktion_bauwerkimverkehrsbereich (wert,beschreibung,dokumentation) VALUES
('1800', 'Brücke', 'Brücke ist ein Bauwerk , das einen Verkehrsweg, ein Gewässer oder einen Tierpfad (Grünbrücke) über ein natürliches oder künstliches Hindernis führt.'),
('1801', 'Mehrstöckige Brücke', 'Mehrstöckige Brücke ist eine Brücke, die mit Verkehrswegen in mehreren Etagen ausgestattet ist.'),
('1802', 'Bogenbrücke', 'Bogenbrücke ist eine Brücke, bei der das Tragwerk aus Bögen besteht.'),
('1803', 'Fachwerkbrücke', 'Fachwerkbrücke ist eine Brücke, bei der das Tragwerk aus starr zusammengesetzten Tragbalken (Holz oder Metall) besteht.'),
('1804', 'Hängebrücke', 'Hängebrücke ist eine Brücke, bei der das Tragwerk von Hängegurten (Kabel) an einem oder mehreren Pylonen gehalten wird.'),
('1805', 'Pontonbrücke', 'Pontonbrücke ist eine Behelfsbrücke, die sich aus kastenförmigen Schwimmkörpern zusammensetzt.'),
('1806', 'Drehbrücke', 'Drehbrücke ist eine Brücke, bei der sich das Tragwerk um einen senkrechten Zapfen (Königsstuhl) dreht.'),
('1807', 'Hebebrücke', 'Hebebrücke ist eine Brücke, bei der das Tragwerk an Seilen oder Ketten emporgehoben wird.'),
('1808', 'Zugbrücke', 'Zugbrücke ist eine Brücke, bei der das Tragwerk um eine waagerechte Achse hochgeklappt wird.'),
('1810', 'Landebrücke', ''),
('1820', 'Steg', 'Steg ist eine kleine Brücke einfacher Bauart.'),
('1830', 'Hochbahn, Hochstraße', 'Hochbahn, Hochstraße ist ein brückenartiges, aufgeständertes Verkehrsbauwerk.'),
('1840', 'Brückenpfeiler', ''),
('1845', 'Widerlager', ''),
('1850', 'Strompfeiler', ''),
('1870', 'Tunnel, Unterführung', 'Tunnel, Unterführung ist ein künstlich angelegtes unterirdisches Bauwerk, das im Verlauf von Verkehrswegen durch Bergmassive oder unter Flussläufen, Meerengen, städt. Bebauungen u. a. hindurchführt.'),
('1880', 'Schutzgalerie, Einhausung', 'Schutzgalerie, Einhausung ist eine bauliche Einrichtung an Verkehrswegen zum Schutz gegen Lawinen, Schneeverwehungen, Steinschlägen sowie zum Schutz gegen Emission. 
Schutzgalerien sind einseitige Überbauungen an Verkehrswegen, Einhausungen umschließen die Verkehrswege meist vollständig.'),
('1890', 'Schleusenkammer', 'Schleusenkammer ist eine Einrichtung zur Überführung von Wasserfahrzeugen zwischen Gewässern mit unterschiedlichen Wasserspiegelhöhen.'),
('1900', 'Durchfahrt', 'Durchfahrt ist eine Stelle, an der mit Fahrzeugen durch ein Bauwerk (z.B. ein Turm, eine Mauer) hindurch gefahren werden kann.'),
('1910', 'Anflugbefeuerung', ''),
('9999', 'Sonstiges', 'Sonstiges bedeutet, dass die Bauwerksfunktion bekannt, aber nicht in der Attributwertliste aufgeführt ist.');
CREATE TABLE ax_art_wegpfadsteig (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_art_wegpfadsteig IS 'Alias: "AX_Art_WegPfadSteig", UML-Typ: Enumeration';
INSERT INTO ax_art_wegpfadsteig (wert,beschreibung,dokumentation) VALUES
('1103', 'Fußweg', 'Fußweg ist ein Weg, der auf Grund seines Ausbauzustandes nur von Fußgängern zu begehen ist.'),
('1105', 'Karren- und Ziehweg', 'Karrenweg ist ein Weg im Gebirge, der meist sehr steil ist und nur mit einem Gespann befahren werden kann. Ziehweg ist ein Weg, der der Holzabfuhr im Gebirge dient.'),
('1106', 'Radweg', 'Radweg ist ein Weg, der als besonders gekennzeichneter und abgegrenzter Teil einer Straße oder mit selbständiger Linienführung für den Fahrradverkehr bestimmt ist'),
('1107', 'Reitweg', 'Reitweg ist ein besonders ausgebauter Weg, auf dem ausschließlich das Reiten zugelassen ist.'),
('1108', 'Wattenweg', ''),
('1109', '(Kletter-)Steig im Gebirge', '(Kletter-)Steig im Gebirge ist ein stellenweise mit Drahtseilen gesicherter Pfad, der zur Überwindung besonders steiler Stellen mit Leitern versehen sein kann.'),
('1110', 'Rad- und Fußweg', 'Rad- und Fußweg ist ein Weg, der als besonders gekennzeichneter und abgegrenzter Teil einer Straße oder mit selbständiger Linienführung ausschließlich für den Fahrrad- und Fußgängerverkehr bestimmt ist.'),
('1111', 'Skaterstrecke', 'Skaterstrecke ist ein für Skater besonders ausgebauter asphaltierter Weg.');
CREATE TABLE ax_verkehrsdienst_bahnverkehrsanlage (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_verkehrsdienst_bahnverkehrsanlage IS 'Alias: "AX_Verkehrsdienst_Bahnverkehrsanlage", UML-Typ: Enumeration';
INSERT INTO ax_verkehrsdienst_bahnverkehrsanlage (wert,beschreibung,dokumentation) VALUES
('1000', 'Fernverkehrshalt', 'Fernverkehrshalt bedeutet, dass an der Bahnverkehrsanlage von einem Eisenbahnverkehrsunternehmen ein planmäßiger Halt im nationalen oder internationalen Schienenpersonenfernverkehrsdienst erbracht wird.');
CREATE TABLE ax_oberflaechenmaterial_flugverkehrsanlage (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_oberflaechenmaterial_flugverkehrsanlage IS 'Alias: "AX_Oberflaechenmaterial_Flugverkehrsanlage", UML-Typ: Enumeration';
INSERT INTO ax_oberflaechenmaterial_flugverkehrsanlage (wert,beschreibung,dokumentation) VALUES
('1210', 'Gras, Rasen', 'Gras, Rasen bedeutet, dass die Oberfläche von Flugverkehrsanlage mit Gras bewachsen ist.'),
('1220', 'Beton', 'Beton bedeutet, dass die Oberfläche von Flugverkehrsanlage aus Beton besteht.'),
('1230', 'Bitumen, Asphalt', 'Bitumen, Asphalt bedeutet, dass die Oberfläche von Flugverkehrsanlage aus Bitumen bzw. Asphalt besteht.');
CREATE TABLE ax_zustand_bauwerkimgewaesserbereich (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_bauwerkimgewaesserbereich IS 'Alias: "AX_Zustand_BauwerkImGewaesserbereich", UML-Typ: Enumeration';
INSERT INTO ax_zustand_bauwerkimgewaesserbereich (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb, stillgelegt, verlassen', 'Außer Betrieb, stillgelegt, verlassen bedeutet, dass sich Bauwerk im Gewässerbereich nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('4000', 'Im Bau', 'Im Bau bedeutet, dass Bauwerk im Gewässerbereich noch nicht fertiggestellt ist.');
CREATE TABLE ax_bahnkategorie_seilbahnschwebebahn (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_bahnkategorie_seilbahnschwebebahn IS 'Alias: "AX_Bahnkategorie_SeilbahnSchwebebahn", UML-Typ: Enumeration';
INSERT INTO ax_bahnkategorie_seilbahnschwebebahn (wert,beschreibung,dokumentation) VALUES
('2100', 'Luftseilbahn, Großkabinenbahn', 'Luftseilbahn, Großkabinenbahn ist die Bezeichnung für eine Seilbahn, die Personen befördert und Güter transportiert. Die Kabinen und Transporteinrichtungen werden an einem Zugseil über ein Tragseil fortbewegt.'),
('2200', 'Kabinenbahn, Umlaufseilbahn', 'Kabinenbahn, Umlaufseilbahn ist die Bezeichnung für eine Seilbahn zur Beförderung von Personen und zum Transport von Gütern. Die Wagen oder Kabinen sind an einem umlaufenden Seil festgeklemmt.'),
('2300', 'Sessellift', 'Sessellift ist die Bezeichnung für eine Seilbahn zur Beförderung von Personen in Sitzen ohne Kabinenverkleidung.'),
('2400', 'Ski-, Schlepplift', 'Ski-, Schlepplift ist die Bezeichnung für eine Seilbahn, mit der Skifahrer stehend den Berg hinauf gezogen werden.'),
('2500', 'Schwebebahn', 'Schwebebahn ist die Bezeichnung für eine Bahn, bei der elektrisch angetriebene Fahrzeuge unter einer Fahrschiene hängen.'),
('2600', 'Materialseilbahn', 'Materialseilbahn ist die Bezeichnung für eine Seilbahn, die ausschließlich Güter transportiert.');
CREATE TABLE ax_art_einrichtungenfuerdenschiffsverkehr (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_art_einrichtungenfuerdenschiffsverkehr IS 'Alias: "AX_Art_EinrichtungenFuerDenSchiffsverkehr", UML-Typ: Enumeration';
INSERT INTO ax_art_einrichtungenfuerdenschiffsverkehr (wert,beschreibung,dokumentation) VALUES
('1410', 'Bake', 'Bake ist ein festgegründetes pfahl- oder gittermastartiges Schifffahrtszeichen mit Kennung durch Form oder Form und Farbe.'),
('1420', 'Leuchtfeuer', 'Leuchtfeuer sind Anlagen, die ein Feuer tragen, das über den ganzen Horizont oder in festgelegten Sektoren oder Richtungen gezeigt wird und die bei Tage als Körperzeichen dienen.'),
('1430', 'Kilometerstein', 'Kilometerstein ist ein Punkt mit einem festen Wert im Netz der Gewässer, der in der Örtlichkeit durch eine Markierung (z.B. Kilometerstein) repräsentiert wird.'),
('1440', 'Tafel an Gewässern', ''),
('1450', 'Pricke', ''),
('1460', 'Anleger', 'Anleger ist eine feste oder schwimmende Einrichtung zum Anlegen von Schiffen.'),
('1470', 'Wasserliegeplatz', 'Wasserliegeplatz bezeichnet eine wasserseitige Stelle außerhalb von Hafenbecken, an dem Wasserfahrzeuge vorübergehend oder dauerhaft verankert sind, mit dem Zweck des Güterumschlages (keine Boots-, Strand- oder Landliegeplätze).'),
('9999', 'Sonstiges', 'Sonstiges bedeutet, dass die Art bekannt, aber nicht in der Attributwertliste aufgeführt ist.');
CREATE TABLE ax_befestigung_wegpfadsteig (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_befestigung_wegpfadsteig IS 'Alias: "AX_Befestigung_WegPfadSteig", UML-Typ: Enumeration';
INSERT INTO ax_befestigung_wegpfadsteig (wert,beschreibung,dokumentation) VALUES
('1000', 'Befestigt', 'Befestigt bedeutet, dass Weg, Pfad, Steig mit einem festen Unterbau versehen und ganzjährig befahrbar bzw. begehbar ist.'),
('2000', 'Unbefestigt', 'Unbefestigt bedeutet, dass Weg, Pfad, Steig nicht mit einem festen Unterbau versehen und nicht ganzjährig befahrbar bzw. begehbar ist.');
CREATE TABLE ax_zustand_einrichtungenfuerdenschiffsverkehr (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_einrichtungenfuerdenschiffsverkehr IS 'Alias: "AX_Zustand_EinrichtungenFuerDenSchiffsverkehr", UML-Typ: Enumeration';
INSERT INTO ax_zustand_einrichtungenfuerdenschiffsverkehr (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb, stillgelegt, verlassen', 'Außer Betrieb, stillgelegt, verlassen bedeutet, dass sich die Einrichtung für den Schiffsverkehr nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.');
CREATE TABLE ax_art_strassenverkehrsanlage (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_art_strassenverkehrsanlage IS 'Alias: "AX_Art_Strassenverkehrsanlage", UML-Typ: Enumeration';
INSERT INTO ax_art_strassenverkehrsanlage (wert,beschreibung,dokumentation) VALUES
('1000', 'Fahrbahn', ''),
('1010', 'Fahrbahnbegrenzungslinie', ''),
('1011', 'Fahrbahnbegrenzungslinie, überdeckt', ''),
('2000', 'Furt', 'Furt ist eine zum Überqueren geeignete Stelle in einem Gewässer.'),
('3000', 'Autobahnknoten', 'Autobahnknoten ist ein höhengleicher oder höhenungleicher Knoten, der sich aus der verkehrlichen Verknüpfung zweier Autobahnen sowie an Anschlussstellen mit dem nachgeordneten Straßennetz ergibt.'),
('3001', 'Kreuz', 'Kreuz ist ein vierarmiger Knotenpunkt in mehreren Ebenen in dem sich zwei Autobahnen kreuzen.'),
('3002', 'Dreieck', 'Dreieck ist eine Einmündung einer Autobahn in eine durchgehende Autobahn.'),
('3003', 'Anschlussstelle, Anschluss', 'Anschlussstelle, Anschluss ist die verkehrliche Verknüpfung der Autobahn mit dem nachgeordneten Straßennetz.'),
('4000', 'Platz', 'Platz ist eine ebene, befestigte oder unbefestigte Fläche.'),
('5330', 'Raststätte, Autohof', 'Raststätte, Autohof ist eine Anlage an Verkehrsstraßen mit Bauwerken und Einrichtungen zur Versorgung und Erholung von Reisenden. Dazu gehören auch Autohöfe gemäß der Verwaltungsvorschriften zur Straßenverkehrsordnung (VwV-StVO).'),
('6000', 'Busbahnhof', 'Busbahnhof ist eine Verkehrsanlage, die als zentraler Verknüpfungspunkt verschiedener Buslinien dient.'),
('9999', 'Sonstiges', 'Sonstiges bedeutet, dass die Art bekannt, aber nicht in der Attributwertliste aufgeführt ist.');
CREATE TABLE ax_zustand_flugverkehrsanlage (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_flugverkehrsanlage IS 'Alias: "AX_Zustand_Flugverkehrsanlage", UML-Typ: Enumeration';
INSERT INTO ax_zustand_flugverkehrsanlage (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb, stillgelegt, verlassen', 'Außer Betrieb, stillgelegt, verlassen bedeutet, dass sich Flugverkehrsanlage nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('4000', 'Im Bau', 'Im Bau bedeutet, dass sich überwiegende Teile von Flugverkehrsanlage im Bau befinden.');
CREATE TABLE ax_bahnkategorie_bahnverkehrsanlage (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_bahnkategorie_bahnverkehrsanlage IS 'Alias: "AX_Bahnkategorie_Bahnverkehrsanlage", UML-Typ: Enumeration';
INSERT INTO ax_bahnkategorie_bahnverkehrsanlage (wert,beschreibung,dokumentation) VALUES
('1100', 'Eisenbahn', 'Eisenbahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem im Nah- und Fernverkehr Personen befördert und/oder Güter transportiert werden.'),
('1101', 'Personenverkehr', 'Personenverkehr ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem im Nah- und / oder Fernverkehr Personen transportiert werden bzw. ist die Bezeichnung für eine Bahnverkehrsanlage mit Personenverkehr.'),
('1102', 'Güterverkehr', 'Güterverkehr ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem im Nah- und / oder Fernverkehr Güter transportiert werden bzw. ist die Bezeichnung für eine Bahnverkehrsanlage mit Güterverkehr.'),
('1103', 'Betriebsverkehr', 'Betriebsverkehr ist die Bezeichnung für eine Bahnverkehrsanlage, die aus innerbetrieblichen Gründen erforderlich ist.'),
('1104', 'S-Bahn', 'S-Bahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, der zur schnellen Personenbeförderung in Ballungsräumen dient und meist auf eigenen Gleisen verläuft.'),
('1200', 'Stadtbahn', 'Stadtbahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem eine elektrisch betriebene Schienenbahn zur Personenbeförderung im öffentlichen Nahverkehr fährt. Sie kann sowohl ober- als auch unterirdisch verlaufen.'),
('1201', 'Straßenbahn', 'Straßenbahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem eine elektrisch betriebene Schienenbahn zur Personenbeförderung fährt. Sie verläuft i. d. R. oberirdisch.'),
('1202', 'U-Bahn', 'U-Bahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem eine elektrisch betriebene Schienenbahn zur Personenbeförderung in Großstädten fährt. Sie verläuft i. d. R. unterirdisch.'),
('1300', 'Seilbahn, Bergbahn', 'Seilbahn, Bergbahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem eine Schienenbahn große Höhenunterschiede überwindet.'),
('1301', 'Zahnradbahn', 'Zahnradbahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem eine Schienenbahn mittels Zahnradantrieb große Höhenunterschiede in stark geneigtem Gelände überwindet.'),
('1302', 'Standseilbahn', 'Standseilbahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem eine Schienenbahn auf einer stark geneigten, meist kurzen und geraden Strecke verläuft. Mit Hilfe eines oder mehrerer Zugseile wird ein Schienenfahrzeug bergauf gezogen und gleichzeitig ein zweites bergab gelassen.'),
('1400', 'Museumsbahn', 'Museumsbahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem ausschließlich Touristen in alten, meist restaurierten Zügen befördert werden.'),
('1500', 'Bahn im Freizeitpark', 'Bahn im Freizeitpark ist die Bezeichnung für einen schienengebundenen Verkehrsweg innerhalb eines Freizeitparks.'),
('1600', 'Magnetschwebebahn', 'Magnetschwebebahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem räderlose Schienenfahrzeuge mit Hilfe von Magnetfeldern an oder auf einer Fahrschiene schwebend entlanggeführt werden.'),
('9999', 'Sonstiges', 'Sonstiges bedeutet, dass die Bahnkategorie bekannt, aber nicht in der Attributwertliste aufgeführt ist.');
CREATE TABLE ax_markierung_wegpfadsteig (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_markierung_wegpfadsteig IS 'Alias: "AX_Markierung_WegPfadSteig", UML-Typ: Enumeration';
INSERT INTO ax_markierung_wegpfadsteig (wert,beschreibung,dokumentation) VALUES
('1401', 'Gekennzeichneter Wanderweg', 'Gekennzeichneter Wanderweg ist ein als Wanderweg eindeutig markierter Weg.'),
('1402', 'Gekennzeichneter Radwanderweg', 'Gekennzeichneter Radwanderweg ist ein als Radwanderweg eindeutig markierter Weg.'),
('1403', 'Gekennzeichnete Skaterstrecke', 'Gekennzeichnete Skaterstrecke ist ein als Skaterstrecke eindeutig markierter Weg.');
CREATE TABLE ax_artdergewaesserstationierungsachse (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_artdergewaesserstationierungsachse IS 'Alias: "AX_ArtDerGewaesserstationierungsachse", UML-Typ: Enumeration';
INSERT INTO ax_artdergewaesserstationierungsachse (wert,beschreibung,dokumentation) VALUES
('1000', 'Gewässerstationierungsachse der WSV', 'Gewässerstationierungsachse der WSV ist eine Gewässerachse, deren Geometrie unverändert aus den Unterlagen der Wasser- und Schifffahrtsverwaltung übernommen wurde.'),
('2000', 'Genäherte Mittellinie in Gewässern', 'Genäherte Mittellinie in Gewässern ist eine Gewässerachse, die den Spezifikationen der Richtlinie der Gebiets- und Gewässerverschlüsselung der Länderarbeitsgemeinschaft Wasser (LAWA) entspricht.'),
('3001', 'Fiktive Verbindung in Fließgewässern', 'Fiktive Verbindung in Fließgewässern ist eine Gewässerachse, die ein einmündendes Gewässer mit der Gewässerachse des aufnehmenden Fließgewässers verbindet.'),
('3002', 'Fiktive Verbindung in Seen und Teichen', 'Fiktive Verbindung in Seen und Teichen ist eine hydrologisch sinnvolle Verbindungslinie in stehenden Gewässern, die für den Aufbau eines geschlossenen topologischen Gewässernetzes benötigt wird.');
CREATE TABLE ax_art_schifffahrtsliniefaehrverkehr (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_art_schifffahrtsliniefaehrverkehr IS 'Alias: "AX_Art_SchifffahrtslinieFaehrverkehr", UML-Typ: Enumeration';
INSERT INTO ax_art_schifffahrtsliniefaehrverkehr (wert,beschreibung,dokumentation) VALUES
('1710', 'Autofährverkehr', 'Autofährverkehr ist ein in der Regel nach festem Fahrplan über Flüsse, Seen, Kanäle, Meerengen oder Meeresarme stattfindender Schiffsverkehr zwischen zwei Anlegestellen speziell für Fahrzeuge des Straßenverkehrs.'),
('1720', 'Eisenbahnfährverkehr', 'Eisenbahnfährverkehr ist ein in der Regel nach festem Fahrplan über Flüsse, Seen, Kanäle, Meerengen oder Meeresarme stattfindender Schiffsverkehr zwischen zwei Anlegestellen speziell für Fahrzeuge des Schienenverkehrs.'),
('1730', 'Personenfährverkehr', 'Personenfährverkehr ist ein in der Regel nach festem Fahrplan über Flüsse, Seen, Kanäle, Meerengen oder Meeresarme stattfindender Schiffsverkehr zwischen zwei Anlegestellen für Personenbeförderung.'),
('1740', 'Linienverkehr', 'Linienverkehr ist die auf einer festgelegten Route nach einem festen Fahrplan verkehrende Güter- und Personenschifffahrt.');
CREATE TABLE ax_schifffahrtskategorie_gewaesserstationierungsachse (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_schifffahrtskategorie_gewaesserstationierungsachse IS 'Alias: "AX_Schifffahrtskategorie_Gewaesserstationierungsachse", UML-Typ: Enumeration';
INSERT INTO ax_schifffahrtskategorie_gewaesserstationierungsachse (wert,beschreibung,dokumentation) VALUES
('1000', 'Binnenwasserstraße', 'Binnenwasserstraße ist ein oberirdisches Gewässer oder Küstengewässer, das gesetzlich für den Personen- und/oder Güterverkehr mit Schiffen bestimmt ist. Binnengewässer im Küstengebiet sind gegen das Küstengewässer gesetzlich abgegrenzt.'),
('2000', 'Seewasserstraße', 'Seewasserstraße ist ein als Wasserstraße gesetzlich festgelegter Teil eines Küstengewässers.'),
('3000', 'Landesgewässer mit Verkehrsordnung', 'Landesgewässer mit Verkehrsordnung ist eine Wasserstraße, die keine Binnenwasserstraße ist. Die Schiffbarkeit wird durch eine Landesverkehrsordnung geregelt.');
CREATE TABLE ax_artdesnullpunktes_nullpunkt (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_artdesnullpunktes_nullpunkt IS 'Alias: "AX_ArtDesNullpunktes_Nullpunkt", UML-Typ: Enumeration';
INSERT INTO ax_artdesnullpunktes_nullpunkt (wert,beschreibung,dokumentation) VALUES
('1000', 'Zentraler Nullpunkt', 'Zentraler Nullpunkt ist die Bezeichnung für einen i. d. R. mit O gekennzeichneten Nullpunkt in einem Netzknoten.'),
('2000', 'Nullpunkt', 'Nullpunkt ist der Anfangs- oder Endpunkt von einem Abschnitt oder Ast.'),
('3000', 'Fiktiver Nullpunkt', 'Fiktiver Nullpunkt ist ein Nullpunkt, der verhindert, dass zwei verschiedene Äste in einem Nullpunkt beginnen und in einem anderen Nullpunkt wieder zusammenlaufen.');
CREATE TABLE ax_hafenkategorie_hafen (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_hafenkategorie_hafen IS 'Alias: "AX_Hafenkategorie_Hafen", UML-Typ: Enumeration';
INSERT INTO ax_hafenkategorie_hafen (wert,beschreibung,dokumentation) VALUES
('1010', 'Containerhafen', 'Containerhafen ist ein Hafen mit speziellen Einrichtungen (z. B. Verladebrücken) für den Umschlag von genormten Containern.'),
('1020', 'Ölhafen', 'Ölhafen ist ein Hafen mit speziellen Einrichtungen (z. B. Tankanlagen) für den Umschlag von Rohöl und den daraus verarbeiteten Produkten.'),
('1030', 'Fischereihafen', 'Fischereihafen ist ein Hafen mit speziellen Einrichtungen (z. B. Kühlhäuser) für den Umschlag von frisch gefangenem Fisch.'),
('1040', 'Sporthafen, Yachthafen', 'Sporthafen, Yachthafen ist ein Hafen für Sport- und Freizeitschiffe.'),
('1050', 'Fährhafen', 'Fährhafen ist ein Hafen zum Anlegen von Fährschiffen.'),
('1060', 'Stückguthafen', 'Stückguthafen ist ein Hafen, in dem nur Stückgüter umgeschlagen werden.'),
('1070', 'Hafen für Massengüter', 'Hafen für Massengüter ist ein Hafen, in dem Massengüter umgeschlagen werden.');
CREATE TABLE ax_konstruktionsmerkmalbauart_schleuse (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_konstruktionsmerkmalbauart_schleuse IS 'Alias: "AX_KonstruktionsmerkmalBauart_Schleuse", UML-Typ: Enumeration';
INSERT INTO ax_konstruktionsmerkmalbauart_schleuse (wert,beschreibung,dokumentation) VALUES
('1010', 'Schiffshebewerk', 'Schiffshebewerk ist ein Bauwerk zum Überwinden einer Fallstufe (in Binnenwasserstraßen und Kanälen) mit Förderung der Schiffe in einem Trog.'),
('1020', 'Kammerschleuse', 'Kammerschleuse ist ein Bauwerk zum Überwinden einer Fallstufe, in dem durch Füllen oder Leeren der Schleusenkammer Schiffe gehoben oder gesenkt werden.');
CREATE TABLE ax_zustand_schleuse (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_schleuse IS 'Alias: "AX_Zustand_Schleuse", UML-Typ: Enumeration';
INSERT INTO ax_zustand_schleuse (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb, stillgelegt, verlassen', 'Außer Betrieb, stillgelegt, verlassen bedeutet, dass sich die Schleuse nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.');
CREATE TABLE ax_nutzung_hafen (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_nutzung_hafen IS 'Alias: "AX_Nutzung_Hafen", UML-Typ: Enumeration';
INSERT INTO ax_nutzung_hafen (wert,beschreibung,dokumentation) VALUES
('1000', 'Zivil', 'Zivil bedeutet, dass Hafen privaten oder öffentlichen Zwecken dient und nicht militärisch genutzt wird.'),
('2000', 'Militärisch', 'Militärisch bedeutet, dass Hafen nur von Streitkräften genutzt wird.'),
('3000', 'Teils zivil, teils militärisch', 'Teils zivil, teils militärisch bedeutet, dass Hafen sowohl zivil als auch militärisch genutzt wird.');
CREATE TABLE ax_funktion_polder (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_polder IS 'Alias: "AX_Funktion_Polder", UML-Typ: Enumeration';
INSERT INTO ax_funktion_polder (wert,beschreibung,dokumentation) VALUES
('7410', 'Gesteuert', 'Gesteuert bedeutet, dass Polder regelmäßig zu einem bestimmten festgelegten Zeitpunkt geflutet wird (z.B. bei einem ausgewählten Pegelstand).'),
('7420', 'Ungesteuert', 'Ungesteuert bedeutet, dass die eingedeichte Fläche ereignisabhängig geflutet wird.');
CREATE TABLE ax_funktion_untergeordnetesgewaesser (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_untergeordnetesgewaesser IS 'Alias: "AX_Funktion_UntergeordnetesGewaesser", UML-Typ: Enumeration';
INSERT INTO ax_funktion_untergeordnetesgewaesser (wert,beschreibung,dokumentation) VALUES
('1010', 'Graben', ''),
('1011', 'Grabenkante, rechts', ''),
('1012', 'Grabenkante, links', ''),
('1013', 'Grabenmitte', ''),
('1020', 'Fleet', ''),
('1030', 'Bach', ''),
('1040', 'Teich', '');
CREATE TABLE ax_art_gewaessermerkmal (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_art_gewaessermerkmal IS 'Alias: "AX_Art_Gewaessermerkmal", UML-Typ: Enumeration';
INSERT INTO ax_art_gewaessermerkmal (wert,beschreibung,dokumentation) VALUES
('1610', 'Quelle', 'Quelle ist eine natürliche, örtlich begrenzte Austrittsstelle von Wasser.'),
('1620', 'Wasserfall', 'Wasserfall ist ein senkrechter oder nahezu senkrechter Absturz eines Wasserlaufs, der über eine oder mehrere natürliche Stufen verlaufen kann.'),
('1630', 'Stromschnelle', 'Stromschnelle ist eine Flussstrecke mit höherer Strömungsgeschwindigkeit durch ein besonders starkes Gefälle sowie oft auch geringerer Wassertiefe.'),
('1640', 'Sandbank', 'Sandbank ist eine vegetationslose Sand- oder Kiesablagerung auf dem Meeresboden oder in Flüssen, die durch Brandung oder Strömung aufgebaut wird.'),
('1650', 'Watt', 'Watt ist ein aus Sand oder Schlick bestehender Boden an flachen Gezeitenküsten und Flüssen, der bei Ebbe ganz oder teilweise trocken fällt.'),
('1660', 'Priel', 'Priel ist eine natürliche Rinne im Watt, die auch bei Ebbe Wasser führt.'),
('1700', 'Bodden, Haff', 'Bodden, Haff ist ein vom offenen Meer durch Landzungen abgetrenntes Küstengewässer an der Ostsee.'),
('9999', 'Sonstiges', '');
CREATE TABLE ax_hydrologischesmerkmal_untergeordnetesgewaesser (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_hydrologischesmerkmal_untergeordnetesgewaesser IS 'Alias: "AX_HydrologischesMerkmal_UntergeordnetesGewaesser", UML-Typ: Enumeration';
INSERT INTO ax_hydrologischesmerkmal_untergeordnetesgewaesser (wert,beschreibung,dokumentation) VALUES
('2000', 'Nicht ständig Wasser führend', ''),
('3000', 'Trocken, versiegt', '');
CREATE TABLE ax_hydrologischesmerkmal_gewaessermerkmal (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_hydrologischesmerkmal_gewaessermerkmal IS 'Alias: "AX_HydrologischesMerkmal_Gewaessermerkmal", UML-Typ: Enumeration';
INSERT INTO ax_hydrologischesmerkmal_gewaessermerkmal (wert,beschreibung,dokumentation) VALUES
('2000', 'Nicht ständig Wasser führend', 'Nicht ständig Wasser führend heißt, dass die Quelle nicht ganzjährig Wasser führt.');
CREATE TABLE ax_lagezurerdoberflaeche_untergeordnetesgewaesser (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_lagezurerdoberflaeche_untergeordnetesgewaesser IS 'Alias: "AX_LageZurErdoberflaeche_UntergeordnetesGewaesser", UML-Typ: Enumeration';
INSERT INTO ax_lagezurerdoberflaeche_untergeordnetesgewaesser (wert,beschreibung,dokumentation) VALUES
('1800', 'Verrohrt, unterirdisch, bedeckt', ''),
('1810', 'Verdolt', '');
CREATE TABLE ax_artdespolders (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_artdespolders IS 'Alias: "AX_ArtDesPolders", UML-Typ: Enumeration';
INSERT INTO ax_artdespolders (wert,beschreibung,dokumentation) VALUES
('1000', 'Sommerpolder', 'Sommerpolder (auch Überlaufpolder) ist ein Polder, der durch einen Überlauf- oder Sommerdeich nur gegen niedrige Hochwasser geschützt ist. Der Deich ist so ausgelegt, dass er zeitweise überströmt werden kann.'),
('2000', 'Entlastungspolder', 'Entlastungspolder (auch Speicherpolder) ist ein Becken, das durch Zurückhalten von Wasser das Schöpfwerk, das Siel, den Vorfluter und/oder die Sperrwerksanlage entlastet.'),
('3000', 'Flutungspolder', 'Flutungspolder ist eine eingedeichte, meist landwirtschaftlich genutzte Fläche, die beim Eintreten eines kritischen Wasserstandes zur Entlastung der Deiche genutzt wird.');
CREATE TABLE ax_bewuchs_vegetationsmerkmal (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_bewuchs_vegetationsmerkmal IS 'Alias: "AX_Bewuchs_Vegetationsmerkmal", UML-Typ: Enumeration';
INSERT INTO ax_bewuchs_vegetationsmerkmal (wert,beschreibung,dokumentation) VALUES
('1011', 'Nadelbaum', 'Nadelbaum beschreibt die Zugehörigkeit eines einzeln stehenden Baumes zur Gruppe der Nadelhölzer.'),
('1012', 'Laubbaum', 'Laubbaum beschreibt die Zugehörigkeit eines einzeln stehenden Baumes zur Gruppe der Laubhölzer.'),
('1020', 'Baumbestand', 'Baumbestand beschreibt den Bewuchs einer Vegetationsfläche mit Bäumen.'),
('1021', 'Baumbestand, Laubholz', 'Baumbestand, Laubholz beschreibt den Bewuchs einer Vegetationsfläche mit Laubbäumen.'),
('1022', 'Baumbestand, Nadelholz', 'Baumbestand, Nadelholz beschreibt den Bewuchs einer Vegetationsfläche mit Nadelbäumen.'),
('1023', 'Baumbestand, Laub- und Nadelholz', 'Baumbestand, Laub- und Nadelholz beschreibt den Bewuchs einer Vegetationsfläche mit Laub- und Nadelbäumen.'),
('1100', 'Hecke', 'Hecke besteht aus einer Reihe dicht beieinander stehender, meist wildwachsender Sträucher.'),
('1101', 'Heckenkante, rechts', ''),
('1102', 'Heckenkante, links', ''),
('1103', 'Heckenmitte', ''),
('1210', 'Baumreihe, Laubholz', 'Laubholz beschreibt die Zugehörigkeit einer Baumreihe zur Gruppe der Laubhölzer.'),
('1220', 'Baumreihe, Nadelholz', 'Nadelholz beschreibt die Zugehörigkeit einer Baumreihe zur Gruppe der Nadelhölzer.'),
('1230', 'Baumreihe, Laub- und Nadelholz', 'Laub- und Nadelholz beschreibt den Bewuchs einer Baumreihe mit Laub- und Nadelbäumen.'),
('1250', 'Gehölz', 'Gehölz ist eine Fläche, die mit einzelnen Bäumen, Baumgruppen, Büschen, Hecken und Sträuchern bestockt ist.'),
('1260', 'Gebüsch', 'Gebüsch beschreibt den Bewuchs einer Vegetationsfläche mit Holzpflanzen, deren Sprossen sich nahe der Bodenoberfläche verzweigen.'),
('1300', 'Schneise', 'Schneise ist eine künstlich angelegte Waldeinteilungslinie zur dauerhaften Begrenzung forstlicher Wirtschaftsflächen (räumliche Ordnung), die in der Regel geradlinig verläuft.'),
('1400', 'Röhricht, Schilf', 'Röhricht, Schilf beschreibt den Bewuchs einer Vegetations- oder Wasserfläche mit Schilfrohr- und schilfrohrähnlichen Pflanzen.'),
('1500', 'Gras', 'Gras beschreibt den Bewuchs einer Vegetationsfläche mit schlanken, krautigen einkeimblättrigen Blütenpflanzen.'),
('1510', 'Rain', ''),
('1600', 'Zierfläche', ''),
('1700', 'Korbweide', ''),
('1800', 'Reet', 'Reet bezeichnet eine ständig oder zeitweise unter Wasser stehende und mit Reet bewachsene Fläche.'),
('1900', 'Streuobst', 'Streuobst beschreibt den Bewuchs einer Fläche mit Obstbäumen.');
CREATE TABLE ax_zustand_vegetationsmerkmal (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_vegetationsmerkmal IS 'Alias: "AX_Zustand_Vegetationsmerkmal", UML-Typ: Enumeration';
INSERT INTO ax_zustand_vegetationsmerkmal (wert,beschreibung,dokumentation) VALUES
('5000', 'Nass', 'Nass bezeichnet eine Vegetationsfläche, die aufgrund besonderer Bodenbeschaffenheit ganzjährig wassergesättigt ist, zeitweise auch unter Wasser stehen kann.'),
('6100', 'Waldverjüngungs-, Neuanpflanzungsfläche', 'Waldverjüngungs-, Neuanpflanzungsfläche bedeutet, dass sich der Wald durch Aufforstung, Naturverjüngung oder durch Anpflanzung neu bildet.');
CREATE TABLE ax_funktion_vegetationsmerkmal (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_vegetationsmerkmal IS 'Alias: "AX_Funktion_Vegetationsmerkmal", UML-Typ: Enumeration';
INSERT INTO ax_funktion_vegetationsmerkmal (wert,beschreibung,dokumentation) VALUES
('1000', 'Windschutz', '');
CREATE TABLE ax_produkt_transportanlage (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_produkt_transportanlage IS 'Alias: "AX_Produkt_Transportanlage", UML-Typ: Enumeration';
INSERT INTO ax_produkt_transportanlage (wert,beschreibung,dokumentation) VALUES
('1110', 'Erdöl', 'Erdöl ist ein flüssiges und brennbares Kohlenwasserstoffgemisch, das gefördert oder transportiert wird.'),
('1120', 'Gas', 'Gas ist eine gasförmige und brennbare Materie, die gefördert oder transportiert wird.'),
('1130', 'Wasser', 'Wasser ist die chemische Verbindung von Wasserstoff mit Sauerstoff, die gefördert oder transportiert wird.'),
('1131', 'Trinkwasser', 'Trinkwasser ist ein für den menschlichen Genuss und Gebrauch geeignetes Wasser, das transportiert wird.'),
('1132', 'Brauchwasser', 'Brauchwasser ist ein für technische u. a. Zwecke verwendetes Wasser, das transportiert wird.'),
('1133', 'Abwasser', 'Abwasser ist ein verunreinigtes Wasser aus Haushaltungen, Gewerbe- und Industriebetrieben sowie Niederschlagswasser, das transportiert wird.'),
('1140', 'Fernwärme', 'Fernwärme bezeichnet eine Wärmelieferung zur Heizung von Gebäuden mit Warmwasser.');
CREATE TABLE ax_speicherinhalt_vorratsbehaelterspeicherbauwerk (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_speicherinhalt_vorratsbehaelterspeicherbauwerk IS 'Alias: "AX_Speicherinhalt_VorratsbehaelterSpeicherbauwerk", UML-Typ: Enumeration';
INSERT INTO ax_speicherinhalt_vorratsbehaelterspeicherbauwerk (wert,beschreibung,dokumentation) VALUES
('1000', 'Erze', 'Erze bedeutet, dass die in der Natur vorkommenden, metallhaltigen Mineralien und Mineralgemische gelagert werden.'),
('1100', 'Treib- und Brennstoffe', 'Treib- und Brennstoffe bedeutet, dass die in der Natur vorkommenden brennbaren organischen und anorganischen Substanzen gelagert werden.'),
('1110', 'Erdöl', 'Erdöl ist ein flüssiges und brennbares Kohlenwasserstoffgemisch, das gelagert wird.'),
('1120', 'Gas', 'Gas ist eine gasförmige oder flüssige Substanz, die gespeichert wird.'),
('1130', 'Wasser', 'Wasser ist die chemische Verbindung von Sauerstoff und Wasserstoff, die gespeichert wird.'),
('1140', 'Gülle', 'Gülle ist ein Stoffgemisch, hauptsächlich aus Urin und Kot landwirtschaftlicher Nutztiere, das gelagert wird.'),
('1200', 'Baustoffe', 'Baustoffe sind sämtliche im Bauwesen verwendete Materialien, die gelagert werden.'),
('1300', 'Chemikalien', 'Chemikalien sind Werkstoffe organischen oder anorganischen Ursprungs, die gespeichert werden.'),
('1500', 'Lebensmittel', 'Lebensmittel sind alle Nahrungs- und Genussmittel für Menschen, die in Vorratsbehältern zwischengelagert werden.'),
('1501', 'Getreide', 'Getreide sind die trockenen Kornfrüchte (Weizen, Roggen, Gerste, Hafer), die in Vorratsbehältern zwischengelagert werden.'),
('1510', 'Futtermittel', 'Futtermittel sind die als Tiernahrung dienenden pflanzlichen oder tierischen Stoffe, die in Vorratsbehältern zwischengelagert werden.'),
('9999', 'Sonstiges', 'Sonstiges bedeutet, dass der Speicherinhalt bekannt, aber nicht in der Attributwertliste aufgeführt ist.');
CREATE TABLE ax_lagezurerdoberflaeche_transportanlage (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_lagezurerdoberflaeche_transportanlage IS 'Alias: "AX_LageZurErdoberflaeche_Transportanlage", UML-Typ: Enumeration';
INSERT INTO ax_lagezurerdoberflaeche_transportanlage (wert,beschreibung,dokumentation) VALUES
('1200', 'Unter der Erdoberfläche', 'Unter der Erdoberfläche bedeutet, dass sich die Transportanlage unter der Erdoberfläche befindet.'),
('1400', 'Aufgeständert', 'Aufgeständert bedeutet, dass eine Transportanlage durch Tragwerke (Stützen, Pfeiler) über das Niveau der Erdoberfläche geführt wird, um z.B. Hindernisse zu überwinden.'),
('1700', 'Unter der Wasseroberfläche', 'Unter der Wasseroberfläche bedeutet, dass sich eine Transportanlage unter der Wasseroberfläche befindet.');
CREATE TABLE ax_bauwerksfunktion_bauwerkoderanlagefuerindustrieundgewer (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_bauwerksfunktion_bauwerkoderanlagefuerindustrieundgewer IS 'Alias: "AX_Bauwerksfunktion_BauwerkOderAnlageFuerIndustrieUndGewerbe", UML-Typ: Enumeration';
INSERT INTO ax_bauwerksfunktion_bauwerkoderanlagefuerindustrieundgewer (wert,beschreibung,dokumentation) VALUES
('1210', 'Klärbecken', 'Klärbecken ist ein künstlich errichtetes Becken oder eine Geländevertiefung, in der Feststoffe aus einer Flüssigkeit ausgefällt werden.'),
('1215', 'Biogasanlage', 'Biogasanlage ist eine Anlage, in der aus Biomasse Gas, Strom oder/und Wärme erzeugt wird. Diese Anlage umfasst ebenfalls die zur Produktion erforderlichen Bauwerke (Fahrsilo, Fermenter, usw.).'),
('1220', 'Windrad', 'Windrad ist ein mit Flügeln besetztes Rad, das durch Wind in Rotation versetzt wird und mit Hilfe eines eingebauten Generators elektrische Energie erzeugt.'),
('1230', 'Solarzellen', 'Solarzellen sind Flächenelemente aus Halbleitern, die die Energie der Sonnenstrahlen in elektrische Energie umwandeln.'),
('1240', 'Wasserrad', 'Wasserrad ist ein mit Schaufeln oder Zellen besetztes Rad, das die Energie des strömenden Wassers zum Antrieb, besonders von Mühlen, ausnutzt oder zum Schöpfen von Wasser (Schöpfrad) genutzt wird.'),
('1250', 'Mast', 'Mast ist eine senkrecht stehende Konstruktion mit stützender oder tragender Funktion.'),
('1251', 'Freileitungsmast', 'Freileitungsmast ist ein Mast, an dem Hochspannungsleitungen befestigt sind.'),
('1260', 'Funkmast', 'Funkmast ist ein Mast mit Vorrichtungen zum Empfangen, Umformen und Weitersenden von elektromagnetischen Wellen.'),
('1270', 'Antenne', 'Antenne ist eine Vorrichtung zum Empfang oder zur Ausstrahlung elektromagnetischer Wellen.'),
('1275', 'Funknavigationsanlage', 'Funknavigationsanlage ist eine Vorrichtung zur Verkehrssicherung.'),
('1280', 'Radioteleskop', 'Radioteleskop ist ein Bauwerk mit einer Parabolantenne für den Empfang und/oder das Senden von elektromagnetischer Strahlung aus dem/in das Weltall.'),
('1290', 'Schornstein', 'Schornstein ist ein freistehend senkrecht hochgeführter Abzugskanal für die Rauchgase einer Feuerungsanlage oder für andere Abgase.'),
('1310', 'Stollenmundloch', 'Stollenmundloch ist der Eingang eines unterirdischen Gangs, der annähernd horizontal von der Erdoberfläche in das Gebirge führt.'),
('1320', 'Schachtöffnung', 'Schachtöffnung ist der Eingang auf der Erdoberfläche zu einem Schacht.'),
('1330', 'Kran', 'Kran ist eine Vorrichtung, die aus einer fahrbaren oder ortsfesten Konstruktion besteht und die zum Heben von Lasten benutzt wird.'),
('1331', 'Drehkran', ''),
('1332', 'Portalkran', ''),
('1333', 'Laufkran, Brückenlaufkran', ''),
('1340', 'Trockendock', 'Trockendock ist eine Anlage in Werften und Häfen, in der das Schiff zum Ausbessern aus dem Wasser genommen wird.'),
('1350', 'Hochofen', 'Hochofen ist ein hoher Schachtofen zum Schmelzen von Eisenerz.'),
('1360', 'Merkzeichen, Merkstein', ''),
('1370', 'Hydrant', ''),
('1371', 'Oberflurhydrant', ''),
('1372', 'Unterflurhydrant', ''),
('1380', 'Schieberkappe', ''),
('1390', 'Einsteigeschacht', ''),
('1400', 'Umformer', ''),
('1700', 'Bergbaubetrieb', 'Bergbaubetrieb ist eine Fläche, die für die Förderung des Abbaugutes unter Tage genutzt wird'),
('2530', 'Kraftwerk', 'Kraftwerk bezeichnet eine Fläche mit Bauwerken und sonstigen Einrichtungen zur Erzeugung von elektrischer Energie.'),
('9999', 'Sonstiges', 'Sonstiges bedeutet, dass die Bauwerkfunktion bekannt, aber nicht in der Attributwertliste aufgeführt ist.');
CREATE TABLE ax_bauwerksfunktion_vorratsbehaelterspeicherbauwerk (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_bauwerksfunktion_vorratsbehaelterspeicherbauwerk IS 'Alias: "AX_Bauwerksfunktion_VorratsbehaelterSpeicherbauwerk", UML-Typ: Enumeration';
INSERT INTO ax_bauwerksfunktion_vorratsbehaelterspeicherbauwerk (wert,beschreibung,dokumentation) VALUES
('1201', 'Silo', 'Silo ist ein Großraumbehälter zum Speichern von Schüttgütern (Getreide, Erz, Zement, Sand) oder Gärfutter (gehäckseltes Grüngut).'),
('1202', 'Fülltrichter', ''),
('1203', 'Bunker', 'Bunker ist ein Bauwerk, in dem Schüttgut gelagert wird.'),
('1204', 'Getreideheber', ''),
('1205', 'Tank', 'Tank ist ein Behälter, in dem Flüssigkeiten gelagert oder Gase gespeichert werden.'),
('1206', 'Gasometer', 'Gasometer ist ein volumenveränderbarer Niederdruckbehälter für Gas.'),
('9999', 'Sonstiges', 'Sonstiges bedeutet, dass die Bauwerkfunktion bekannt, aber in der Attributwertliste nicht aufgeführt ist.');
CREATE TABLE ax_art_einrichtunginoeffentlichenbereichen (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_art_einrichtunginoeffentlichenbereichen IS 'Alias: "AX_Art_EinrichtungInOeffentlichenBereichen", UML-Typ: Enumeration';
INSERT INTO ax_art_einrichtunginoeffentlichenbereichen (wert,beschreibung,dokumentation) VALUES
('1100', 'Kommunikationseinrichtung', ''),
('1110', 'Fernsprechhäuschen', ''),
('1120', 'Briefkasten', ''),
('1130', 'Notrufeinrichtung', ''),
('1140', 'Feuermelder', ''),
('1150', 'Polizeirufsäule', ''),
('1200', 'Kabelkasten, Schaltkasten', ''),
('1300', 'Verkehrszeichen', ''),
('1310', 'Verkehrsampel', ''),
('1320', 'Freistehende Hinweistafel, -zeichen', ''),
('1330', 'Wegweiser von besonderer Bedeutung', ''),
('1340', 'Freistehende Warntafel', ''),
('1350', 'Bushaltestelle', ''),
('1400', 'Markierungshinweise, -steine', ''),
('1410', 'Kilometerstein, -tafel', 'Kilometerstein, -tafel ist ein Punkt mit einem festen Wert im Netz der Autobahnen oder Schienenbahnen der in der Örtlichkeit durch eine Markierung (z. B. Kilometerstein) repräsentiert wird.'),
('1420', 'Ortsdurchfahrtsstein', ''),
('1430', 'Fischereigrenzstein', ''),
('1500', 'Bahnübergang, Schranke', ''),
('1510', 'Tor', ''),
('1600', 'Laterne, Kandelaber', ''),
('1610', 'Gaslaterne', ''),
('1620', 'Laterne, elektrisch', ''),
('1630', 'Gaskandelaber', ''),
('1640', 'Kandelaber, elektrisch', ''),
('1650', 'Hängende Lampe', ''),
('1700', 'Säule, Werbefläche', ''),
('1710', 'Leuchtsäule', ''),
('1910', 'Fahnenmast', ''),
('2100', 'Straßensinkkasten', ''),
('2200', 'Müllbox', ''),
('2300', 'Kehrichtgrube', ''),
('2400', 'Uhr', ''),
('2500', 'Richtscheinwerfer', ''),
('2600', 'Flutlichtmast', ''),
('9999', 'Sonstiges', 'Sonstiges bedeutet, dass die Art bekannt, aber in der Attributwertliste nicht aufgeführt ist.');
CREATE TABLE ax_art_heilquellegasquelle (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_art_heilquellegasquelle IS 'Alias: "AX_Art_HeilquelleGasquelle", UML-Typ: Enumeration';
INSERT INTO ax_art_heilquellegasquelle (wert,beschreibung,dokumentation) VALUES
('4010', 'Heilquelle', ''),
('4020', 'Gasquelle, Mofette', '');
CREATE TABLE ax_hydrologischesmerkmal_sonstigesbauwerkodersonstigeeinri (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_hydrologischesmerkmal_sonstigesbauwerkodersonstigeeinri IS 'Alias: "AX_HydrologischesMerkmal_SonstigesBauwerkOderSonstigeEinrichtung", UML-Typ: Enumeration';
INSERT INTO ax_hydrologischesmerkmal_sonstigesbauwerkodersonstigeeinri (wert,beschreibung,dokumentation) VALUES
('1000', 'Ständig Wasser führend', 'Ständig Wasser führend heißt, dass der Brunnen ganzjährig Wasser führt.'),
('2000', 'Nicht ständig Wasser führend', 'Nicht ständig Wasser führend heißt, dass der Brunnen nicht ganzjährig Wasser führt.'),
('3000', 'Trocken, versiegt', 'Trocken, versiegt heißt, dass der Brunnen ganzjährig kein Wasser führt.');
CREATE TABLE ax_bauwerksfunktion_bauwerkoderanlagefuersportfreizeitunde (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_bauwerksfunktion_bauwerkoderanlagefuersportfreizeitunde IS 'Alias: "AX_Bauwerksfunktion_BauwerkOderAnlageFuerSportFreizeitUndErholung", UML-Typ: Enumeration';
INSERT INTO ax_bauwerksfunktion_bauwerkoderanlagefuersportfreizeitunde (wert,beschreibung,dokumentation) VALUES
('1410', 'Spielfeld', 'Spielfeld ist eine abgegrenzte, markierte Fläche, auf der die Sportart unmittelbar ausgeübt wird, z.B. die einzelnen Fußballfelder (Hauptplatz und Trainingsplätze) einer größeren Anlage oder die Trainings-/Reitplätze i. V. m. Reitsport. Die zusammenhängenden Spielflächen innerhalb einer Tennisanlage werden zu einem Spielfeld zusammengefasst.'),
('1411', 'Hartplatz', ''),
('1412', 'Rasenplatz', ''),
('1420', 'Rennbahn, Laufbahn, Geläuf', 'Rennbahn, Laufbahn, Geläuf ist eine je nach Art des Rennens verschiedenartig gestaltete Strecke (oval, gerade, kurvig), auf der das Rennen stattfindet.'),
('1430', 'Zuschauertribüne', 'Zuschauertribüne ist ein großes Gerüst oder ein festes, meist überdachtes Bauwerk mit ansteigenden Sitz- oder Stehplatzreihen für Zuschauer.'),
('1431', 'Zuschauertribüne, überdacht', 'Zuschauertribüne, überdacht bedeutet, dass Zuschauertribüne mit einer Dachfläche ausgestattet ist.'),
('1432', 'Zuschauertribüne, nicht überdacht', 'Zuschauertribüne, nicht überdacht bedeutet, dass die Zuschauertribüne keine Dachfläche besitzt.'),
('1440', 'Stadion', 'Stadion ist ein Bauwerk mit Tribünen und entsprechenden Einrichtungen, das vorwiegend zur Ausübung von bestimmten Sportarten dient.'),
('1441', 'Stadion, überdacht', 'Stadion, überdacht ist ein Bauwerk mit Tribünen und entsprechenden Einrichtungen, das vorwiegend zur Ausübung von bestimmten Sportarten dient und ganz oder nahezu ganz überdacht ist.'),
('1442', 'Stadion, nicht überdacht', 'Stadion, nicht überdacht ist ein Bauwerk mit Tribünen und entsprechenden Einrichtungen, das vorwiegend zur Ausübung von bestimmten Sportarten dient, aber ohne Dachflächen ist.'),
('1450', 'Schwimmbecken', 'Schwimmbecken ist ein mit Wasser gefülltes Becken zum Schwimmen oder Baden.'),
('1460', 'Liegewiese', ''),
('1470', 'Sprungschanze (Anlauf)', 'Sprungschanze (Anlauf) ist eine Anlage zum Skispringen mit einer stark abschüssigen, in einem Absprungtisch endenden Bahn zum Anlauf nehmen.'),
('1480', 'Schießanlage', 'Schießanlage ist eine Anlage mit Schießbahnen für Schießübungen oder sportliche Wettbewerbe.'),
('1490', 'Gradierwerk', 'Gradierwerk ist ein mit Reisig bedecktes Gerüst, über das Sole rieselt, die durch erhöhte Verdunstung konzentriert wird.'),
('1510', 'Wildgehege', 'Wildgehege ist ein eingezäuntes Areal, in dem Wild waidgerecht betreut wird oder beobachtet werden kann.'),
('1610', 'Zoo', 'Zoo ist ein Gelände mit Tierschauhäusern und umzäunten Gehegen, auf dem Tiere gehalten und gezeigt werden.'),
('1620', 'Safaripark, Wildpark', 'Safaripark, Wildpark, ist ein Gelände mit umzäunten Gehegen, in denen Tiere im Freien gehalten und gezeigt werden.'),
('1630', 'Freizeitpark', 'Freizeitpark ist ein Gelände mit Karussells, Verkaufs- und Schaubuden und/oder Wildgattern, das der Freizeitgestaltung dient.'),
('1640', 'Freilichtbühne', 'Freilichtbühne ist ein Anlage mit Bühnen und Zuschauerbänken für Aufführungen im Freien.'),
('1650', 'Wassersportanlage', 'Wassersportanlage bezeichnet ein Areal welches beispielsweise zum Rudern, Segeln oder für Wasserski genutzt wird.'),
('9999', 'Sonstiges', 'Sonstiges bedeutet, dass die Bauwerkfunktion bekannt, aber in der Attributwertliste nicht aufgeführt ist.');
CREATE TABLE ax_schwerebezugssystem_schwere (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_schwerebezugssystem_schwere IS 'Alias: "AX_Schwerebezugssystem_Schwere", UML-Typ: Enumeration';
INSERT INTO ax_schwerebezugssystem_schwere (wert,beschreibung,dokumentation) VALUES
('1000', 'DHSN82', 'Schwerewert im System des DHSN82 (System der Landesvermessung)'),
('1100', 'DSGN62', 'Schwerewert im System des DSGN62 (auch als DSN62 bezeichnet)'),
('1200', 'SGN71', 'Schwerewert im System des SGN der DDR (auch als System 71 bezeichnet)'),
('1300', 'DHSN96', 'Schwerewert im System des DHSN96 (System der Landesvermessung)'),
('1400', 'DHSN2016', 'Schwerewert im System des DHSN2016 (System der Landesvermessung)'),
('4000', 'ISGN71', 'Schwerewert im System des ISGN71 (wissenschaftliches System)'),
('4010', 'DSGN76', 'Schwerewert im System des DSGN76 (wissenschaftliches System)'),
('4020', 'DSGN94', 'Schwerewert im System des DSGN94 (wissenschaftliches System)'),
('4030', 'DSGN2016', 'Schwerewert im System des DSGN2016 (wissenschaftliches System)'),
('6000', 'PSS09', 'Potsdamer Schweresystem 1909'),
('6100', 'SGRA43', 'Schweresystem der Geophysikalischen Reichsaufnahme 1934 - 1943');
CREATE TABLE ax_archaeologischertyp_historischesbauwerkoderhistorischee (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_archaeologischertyp_historischesbauwerkoderhistorischee IS 'Alias: "AX_ArchaeologischerTyp_HistorischesBauwerkOderHistorischeEinrichtung", UML-Typ: Enumeration';
INSERT INTO ax_archaeologischertyp_historischesbauwerkoderhistorischee (wert,beschreibung,dokumentation) VALUES
('1000', 'Grab', 'Grab ist eine künstlich geschaffene Bestattungsstätte unter, auf oder über der Erdoberfläche.'),
('1010', 'Großsteingrab (Dolmen, Hünenbett)', 'Großsteingrab (Dolmen, Hünenbett) ist ein Grab mit Steineinbau, d. h. es ist ein aus großen Steinen (z.B. Findlingen) errichteter Grabbau.'),
('1020', 'Grabhügel (Hügelgrab)', 'Grabhügel (Hügelgrab) ist ein meist runder oder ovaler Hügel, der über einer ur- oder frühgeschichtlichen Bestattung aus Erde aufgeschüttet oder aus Plaggen aufgeschichtet wurde.'),
('1100', 'Historische Wasserleitung', 'Historische Wasserleitung ist ein meist offenes System von Gräben, Kunstgräben und Kanälen, in dem Wasser transportiert wird.'),
('1110', 'Aquädukt', 'Aquädukt ist ein brückenartiges Steinbauwerk zur Überführung von Freispiegel-Wasserleitungen mit natürlichem Gefälle über Täler oder andere Bodenunebenheiten.'),
('1200', 'Befestigung (Wall, Graben)', 'Befestigung (Wall, Graben) ist ein aus Erde aufgeschütteter Grenz-, Schutz- oder Stadtwall. Zu der Befestigung (Wall) zählen auch Limes und Landwehr.'),
('1210', 'Wachturm (römisch), Warte', 'Wachtturm (römisch), Warte ist ein allein oder in Verbindung mit einem Befestigungssystem (Limes) stehender Beobachtungsturm.'),
('1300', 'Steinmal', 'Steinmal ist eine kultische oder rechtliche Kennzeichnung, bestehend aus einzelnen oder Gruppen von Steinen.'),
('1400', 'Befestigung (Burgruine)', 'Befestigung (Burgruine) ist eine künstliche Anlage zur Sicherung von Leben und Gut.'),
('1410', 'Burg (Fliehburg, Ringwall)', 'Burg (Fliehburg, Ringwall) ist eine ur- oder frühgeschichtliche runde, ovale oder an Gegebenheiten des Geländes (Böschungskanten) angepasste Befestigungsanlage, die aus einem Erdwall mit oder ohne Holzeinbauten besteht.'),
('1420', 'Schanze', 'Schanze ist eine mittelalterliche oder neuzeitliche, in der Regel geschlossene, quadratische, rechteckige oder sternförmige Wallanlage mit Außengraben.'),
('1430', 'Lager', 'Lager ist die Bezeichnung für ein befestigtes Truppenlager in der Römer- oder in der Neuzeit (z.B. bei Belagerungen im 30 jährigen Krieg).'),
('1500', 'Historische Mauer', 'Historische Mauer ist eine Mauer mit kulturgeschichtlicher Bedeutung.'),
('1510', 'Stadtmauer', ''),
('1520', 'Sonstige historische Mauer', ''),
('9999', 'Sonstiges', 'Sonstiges bedeutet, dass der archäologische Typ bekannt, aber nicht in der Attributwertliste aufgeführt ist');
CREATE TABLE ax_bauwerksfunktion_leitung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_bauwerksfunktion_leitung IS 'Alias: "AX_Bauwerksfunktion_Leitung", UML-Typ: Enumeration';
INSERT INTO ax_bauwerksfunktion_leitung (wert,beschreibung,dokumentation) VALUES
('1110', 'Freileitung', 'Freileitung ist eine aus einem oder mehreren Drähten oder Fasern hergestellte oberirdische Leitung zum Transport von elektrischer Energie und zur Übertragung von elektrischen Signalen.'),
('1111', 'Erdkabel', 'Erdkabel ist eine aus einem oder mehreren Drähten oder Fasern hergestellte unterirdische Leitung zum Transport von elektrischer Energie und/oder zur Übertragung von elektrischen Signalen.');
CREATE TABLE ax_sportart_bauwerkoderanlagefuersportfreizeitunderholung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_sportart_bauwerkoderanlagefuersportfreizeitunderholung IS 'Alias: "AX_Sportart_BauwerkOderAnlageFuerSportFreizeitUndErholung", UML-Typ: Enumeration';
INSERT INTO ax_sportart_bauwerkoderanlagefuersportfreizeitunderholung (wert,beschreibung,dokumentation) VALUES
('1010', 'Ballsport', 'Ballsport bedeutet, dass ein Spielfeld oder Stadion zur Ausübung des Ballsports genutzt wird.'),
('1011', 'Fußball', 'Fußball bedeutet, dass ein Spielfeld oder Stadion zum Fußball spielen genutzt wird.'),
('1020', 'Leichtathletik', 'Leichtathletik bedeutet, dass ein Spielfeld oder Stadion zur Ausübung verschiedener Leichtathletikdisziplinen genutzt wird.'),
('1030', 'Tennis', 'Tennis bedeutet, dass ein Spielfeld oder Stadion zum Tennis spielen genutzt wird.'),
('1040', 'Reiten', 'Reiten bedeutet, dass ein Stadion, ein Spielfeld oder eine Rennbahn zur Ausübung des Reitsports genutzt wird.'),
('1050', 'Schwimmen', 'Schwimmen bedeutet, dass ein Stadion zum Schwimmen genutzt wird.'),
('1060', 'Ski', 'Ski bedeutet, dass ein Stadion zur Ausübung des Skisports genutzt wird.'),
('1070', 'Eissport, Rollschuhlaufen', 'Eissport, Rollschuhlaufen bedeutet, dass ein Bauwerk oder eine Anlage zur Ausübung des Eis- oder des Rollschuhsports genutzt wird.'),
('1071', 'Eislauf, Eishockey', 'Eislauf, Eishockey bedeutet, dass ein Bauwerk oder eine Anlage zur Ausübung des Eissports genutzt wird.'),
('1072', 'Rollschuhlaufen', 'Rollschuhlaufen bedeutet, dass ein Bauwerk oder eine Anlage zur Ausübung des Rollschuhsports genutzt wird.'),
('1080', 'Skating', 'Skating bedeutet, dass eine Laufbahn zum Skaten genutzt wird.'),
('1090', 'Motorrennsport', 'Motorrennsport bedeutet, dass eine Rennbahn zur Ausübung des Motorrennsports genutzt wird.'),
('1100', 'Radsport', 'Radsport bedeutet, dass ein Stadion oder eine Rennbahn zur Ausübung des Radsports genutzt wird.'),
('1110', 'Pferderennsport', 'Pferderennsport bedeutet, dass eine Rennbahn zur Ausübung des Pferderennsports genutzt wird.'),
('1115', 'Hunderennsport', 'Hunderennsport bedeutet, dass eine Rennbahn zur Ausübung des Hunderennsports genutzt wird.'),
('1120', 'Hundesport', 'Hundesport sind Sportanlagen für Hunde, die dem Training, Ausbildung, aber auch dem Wettkampf (keine Hunderennen!) dienen.');
CREATE TABLE ax_bauwerksfunktion_transportanlage (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_bauwerksfunktion_transportanlage IS 'Alias: "AX_Bauwerksfunktion_Transportanlage", UML-Typ: Enumeration';
INSERT INTO ax_bauwerksfunktion_transportanlage (wert,beschreibung,dokumentation) VALUES
('1101', 'Rohrleitung, Pipeline', 'Rohrleitung, Pipeline ist ein langgestreckter Hohlkörper zum Transport von Flüssigkeiten und Gasen.'),
('1102', 'Förderband, Bandstraße', 'Förderband, Bandstraße ist ein mechanisch bewegtes Band zum Transport von Gütern.'),
('1103', 'Pumpe', 'Pumpe ist eine Vorrichtung zum Injizieren, An- oder Absaugen von Flüssigkeiten oder von Gasen. Pumpen dienen auch zur Entwässerung größerer Landstriche. Als Pumpe werden auch die Verdichtungsstationen für Gase erfasst.');
CREATE TABLE ax_funktion_bauwerk (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_bauwerk IS 'Alias: "AX_Funktion_Bauwerk", UML-Typ: Enumeration';
INSERT INTO ax_funktion_bauwerk (wert,beschreibung,dokumentation) VALUES
('1000', 'Hochwasser-, Sturmflutschutz', 'Hochwasser-, Sturmflutschutz bedeutet, dass das Bauwerk dem Schutz vor Hochwasser bzw. Sturmflut dient.'),
('2000', 'Lärmschutz', 'Lärmschutz bedeutet, dass das Bauwerk dem Schutz vor Lärmemissionen dient.');
CREATE TABLE ax_hydrologischesmerkmal_heilquellegasquelle (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_hydrologischesmerkmal_heilquellegasquelle IS 'Alias: "AX_HydrologischesMerkmal_HeilquelleGasquelle", UML-Typ: Enumeration';
INSERT INTO ax_hydrologischesmerkmal_heilquellegasquelle (wert,beschreibung,dokumentation) VALUES
('4000', 'Ständig schüttend', ''),
('5000', 'Nicht ständig schüttend', '');
CREATE TABLE ax_art_bauwerkspunkt (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_art_bauwerkspunkt IS 'Alias: "AX_Art_Bauwerkspunkt", UML-Typ: Enumeration';
INSERT INTO ax_art_bauwerkspunkt (wert,beschreibung,dokumentation) VALUES
('1100', 'First', ''),
('1200', 'Traufe', ''),
('2100', 'Eingang', '');
CREATE TABLE ax_zustand_turm (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_turm IS 'Alias: "AX_Zustand_Turm", UML-Typ: Enumeration';
INSERT INTO ax_zustand_turm (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb, stillgelegt, verlassen', 'Außer Betrieb, stillgelegt, verlassen bedeutet, dass sich der Turm nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('2200', 'Verfallen, zerstört', 'Verfallen, zerstört bedeutet, dass sich der ursprüngliche Zustand des Turmes durch menschliche oder zeitliche Einwirkungen so verändert hat, dass eine Nutzung nicht mehr möglich ist.');
CREATE TABLE ax_zustand_bauwerkoderanlagefuersportfreizeitunderholung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_bauwerkoderanlagefuersportfreizeitunderholung IS 'Alias: "AX_Zustand_BauwerkOderAnlageFuerSportFreizeitUndErholung", UML-Typ: Enumeration';
INSERT INTO ax_zustand_bauwerkoderanlagefuersportfreizeitunderholung (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb, stillgelegt, verlassen', 'Außer Betrieb, stillgelegt, verlassen bedeutet, dass sich das Bauwerk oder die Anlage nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.');
CREATE TABLE ax_bauwerksfunktion_turm (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_bauwerksfunktion_turm IS 'Alias: "AX_Bauwerksfunktion_Turm", UML-Typ: Enumeration';
INSERT INTO ax_bauwerksfunktion_turm (wert,beschreibung,dokumentation) VALUES
('1001', 'Wasserturm', 'Wasserturm ist ein hochgelegenes Bauwerk mit einem Behälter, in dem Wasser für die Wasserversorgung und Konstanthaltung des Wasserdruckes gespeichert wird.'),
('1002', 'Kirchturm, Glockenturm', 'Kirchturm, Glockenturm ist ein freistehender Turm, der die Glockenstube mit den Glocken aufnimmt.'),
('1003', 'Aussichtsturm', 'Aussichtsturm ist ein Bauwerk, das der Fernsicht dient.'),
('1004', 'Kontrollturm', 'Kontrollturm (Tower) ist ein Bauwerk auf dem Fluggelände, in dem die für die Lenkung und Überwachung des Flugverkehrs erforderlichen Anlagen und Einrichtungen untergebracht sind.'),
('1005', 'Kühlturm', 'Kühlturm ist eine turmartige Kühlanlage (Nass- oder Trockenkühlturm), in der erwärmtes Kühlwasser insbesondere von Kraftwerken rückgekühlt wird.'),
('1006', 'Leuchtturm', 'Leuchtturm ist ein als Schifffahrtszeichen errichteter hoher Turm.'),
('1007', 'Feuerwachturm', 'Feuerwachturm ist ein Turm, der zum Erkennen von Gefahren (Feuer) dient.'),
('1008', 'Sende-, Funkturm, Fernmeldeturm', 'Sende-, Funkturm, Fernmeldeturm’ ist ein Bauwerk, ausgerüstet mit Sende - und Empfangsantennen zum Übertragen und Empfangen von Nachrichten aller Arten von Telekommunikation.'),
('1009', 'Stadt-, Torturm', 'Stadtturm ist ein historischer Turm, der das Stadtbild prägt. Torturm ist der auf einem Tor stehende Turm, wobei das Tor allein stehen oder in eine Befestigungsanlage eingebunden sein kann.'),
('1010', 'Förderturm', 'Förderturm ist ein Turm über einem Schacht. An Förderseile, die über Seilscheiben im Turm geführt werden, werden Lasten in den Schacht gesenkt oder aus dem Schacht gehoben.'),
('1011', 'Bohrturm', 'Bohrturm ist ein zur Gewinnung von Erdöl, Erdgas oder Sole verwendetes, meist aus einer Stahlkonstruktion bestehendes Gerüst, in dem das Bohrgestänge aufgehängt ist.'),
('1012', 'Schloss-, Burgturm', 'Schloss-, Burgturm ist ein Turm innerhalb einer Schloss- bzw. einer Burganlage, auch Bergfried genannt.'),
('9998', 'Nach Quellenlage nicht zu spezifizieren', 'Nach Quellenlage nicht zu spezifizieren bedeutet, dass zum Zeitpunkt der Erhebung keine Funktion zuweisbar war.'),
('9999', 'Sonstiges', 'Sonstiges bedeutet, dass die Funktion bekannt, aber nicht in der Attributwertliste aufgeführt ist.');
CREATE TABLE ax_bauwerksfunktion_sonstigesbauwerkodersonstigeeinrichtun (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_bauwerksfunktion_sonstigesbauwerkodersonstigeeinrichtun IS 'Alias: "AX_Bauwerksfunktion_SonstigesBauwerkOderSonstigeEinrichtung", UML-Typ: Enumeration';
INSERT INTO ax_bauwerksfunktion_sonstigesbauwerkodersonstigeeinrichtun (wert,beschreibung,dokumentation) VALUES
('1610', 'Überdachung', 'Überdachungen sind i. d. R. an allen Seiten offen. Eine geschlossene Seite kann über eine besondere Gebäudelinie mit der Werteart Geschlossene Seite einer Überdachung nachgewiesen werden.'),
('1611', 'Carport', 'Carports sind i. d. R. an allen Seiten offen. Eine geschlossene Seite kann über eine besondere Gebäudelinie mit der Werteart Geschlossene Seite einer Überdachung nachgewiesen werden.'),
('1620', 'Treppe', 'Treppe ist ein stufenförmiges Bauwerk zur Überwindung von Höhenunterschieden.'),
('1621', 'Freitreppe', ''),
('1622', 'Rolltreppe', ''),
('1630', 'Treppenunterkante', ''),
('1640', 'Kellereingang', 'Kellereingang ist der Eingang zu einem unterirdischen Vorratsraum außerhalb von Gebäuden.'),
('1641', 'Kellereingang, offen', 'Kellereingang, offen ist der offene Eingang zu einem unterirdischen Vorratsraum außerhalb von Gebäuden.'),
('1642', 'Kellereingang, geschlossen', 'Kellereingang, geschlossen ist der geschlossene Eingang zu einem unterirdischen Vorratsraum außerhalb von Gebäuden.'),
('1650', 'Rampe', ''),
('1670', 'Terrasse', 'Es werden nur unterkellerte Terrassen erfasst.'),
('1700', 'Mauer', 'Mauer ist ein freistehendes, langgestrecktes Bauwerk, das aus Natur- bzw. Kunststeinen oder anderen Materialien besteht.'),
('1701', 'Mauerkante, rechts', ''),
('1702', 'Mauerkante, links', ''),
('1703', 'Mauermitte', ''),
('1720', 'Stützmauer', 'Stützmauer ist eine zum Stützen von Erdreich dienende Mauer.'),
('1721', 'Stützmauer, rechts', ''),
('1722', 'Stützmauer, links', ''),
('1723', 'Stützmauermitte', ''),
('1740', 'Zaun', 'Zaun ist eine Abgrenzung oder Einfriedung aus Holz- oder Metallstäben oder aus Draht bzw. Drahtgeflecht.'),
('1750', 'Gedenkstätte, Denkmal, Denkstein, Standbild', 'Gedenkstätte, Denkmal, Denkstein, Standbild ist ein zum Gedenken errichtete Anlage oder Bauwerk an eine Person, ein Ereignis oder eine plastische Darstellung.'),
('1760', 'Bildstock, Wegekreuz, Gipfelkreuz', 'Bildstock, Wegekreuz, Gipfelkreuz ist ein frei stehendes Mal aus Holz oder Stein, das in einem tabernakelartigen Aufbau ein Kruzifix oder eine Heiligendarstellung enthält und als Andachtsbild, als Erinnerung an Verstorbene oder als Sühnemal errichtet wurde; ist ein errichtetes Kreuz z.B. an Wegen; ist ein Kreuz auf dem Gipfel eines Berges.'),
('1761', 'Bildstock', ''),
('1762', 'Wegekreuz', ''),
('1763', 'Gipfelkreuz', ''),
('1770', 'Meilenstein, historischer Grenzstein', 'Meilenstein, historischer Grenzstein sind Steine von kulturgeschichtlicher Bedeutung, die am Rande von Verkehrswegen aufgestellt sind und Entfernungen in unterschiedlichen Maßeinheiten (z. B. Meilen, Kilometer oder Stunden) angeben oder als Grenzsteine vergangene Eigentumsverhältnisse dokumentieren.'),
('1780', 'Brunnen', 'Brunnen ist eine Anlage zur Gewinnung von Grundwasser bzw. ein architektonisch ausgestaltetes Bauwerk mit Becken zum Auffangen von Wasser.'),
('1781', 'Brunnen (Trinkwasserversorgung)', 'Brunnen (Trinkwasserversorgung) bedeutet, dass in dem Brunnen ausschließlich Trinkwasser gewonnen wird.'),
('1782', 'Springbrunnen, Zierbrunnen', ''),
('1783', 'Ziehbrunnen', ''),
('1790', 'Spundwand', 'Spundwand ist ein Sicherungsbauwerk (wasserdichte Wand) aus miteinander verbundenen schmalen, langen Holz-, Stahl- oder Stahlbetonbohlen zum Schutz gegen das Außenwasser. Die Bohlen werden horizontal hinter Pfählen (Bohlwand) oder vertikal als Spundwand eingebaut und meist rückwärtig verankert.'),
('1791', 'Höckerlinie', 'Höckerlinie bezeichnet die ehemalige Panzersperre Westwall.'),
('9999', 'Sonstiges', 'Sonstiges bedeutet, dass die Bauwerksfunktion bekannt, aber nicht in der Attributwertliste aufgeführt ist.');
CREATE TABLE ax_zustand_bauwerkoderanlagefuerindustrieundgewerbe (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_bauwerkoderanlagefuerindustrieundgewerbe IS 'Alias: "AX_Zustand_BauwerkOderAnlageFuerIndustrieUndGewerbe", UML-Typ: Enumeration';
INSERT INTO ax_zustand_bauwerkoderanlagefuerindustrieundgewerbe (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb, stillgelegt, verlassen', 'Außer Betrieb, stillgelegt, verlassen bedeutet, dass sich Bauwerk oder Anlage für Industrie und Gewerbe nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('2200', 'Verfallen, zerstört', 'Verfallen, zerstört bedeutet, dass sich der ursprüngliche Zustand von Bauwerk oder Anlage für Industrie und Gewerbe durch menschliche oder zeitliche Einwirkungen so verändert hat, dass eine Nutzung nicht mehr möglich ist.'),
('4000', 'Im Bau', 'Im Bau bedeutet, dass sich überwiegende Teile der Bauwerke oder Anlagen für Industrie und Gewerbe (Großbaustelle) im Bau befinden.'),
('4100', 'Offen', 'Offen bedeutet, dass Bauwerk oder Anlage für Industrie und Gewerbe allgemein zugänglich ist.'),
('4200', 'Verschlossen', 'Verschlossen bedeutet, dass Bauwerk oder Anlage für Industrie und Gewerbe nicht allgemein zugänglich ist.');
CREATE TABLE ax_lagezurerdoberflaeche_vorratsbehaelterspeicherbauwerk (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_lagezurerdoberflaeche_vorratsbehaelterspeicherbauwerk IS 'Alias: "AX_LageZurErdoberflaeche_VorratsbehaelterSpeicherbauwerk", UML-Typ: Enumeration';
INSERT INTO ax_lagezurerdoberflaeche_vorratsbehaelterspeicherbauwerk (wert,beschreibung,dokumentation) VALUES
('1200', 'Unter der Erdoberfläche', 'Unter der Erdoberfläche bedeutet, dass sich der Vorratsbehälter bzw. das Speicherbauwerk unter der Erdoberfläche befindet.'),
('1400', 'Aufgeständert', 'Aufgeständert bedeutet, dass der Vorratsbehälter bzw. das Speicherbauwerk auf Stützen steht.');
CREATE TABLE ax_blattart_buchungsblatt (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_blattart_buchungsblatt IS 'Alias: "AX_Blattart_Buchungsblatt", UML-Typ: Enumeration';
INSERT INTO ax_blattart_buchungsblatt (wert,beschreibung,dokumentation) VALUES
('1000', 'Grundbuchblatt', 'Ein Grundbuchblatt ist ein Buchungsblatt, das die Buchung im Grundbuch enthält.'),
('2000', 'Katasterblatt', 'Ein Katasterblatt ist ein Buchungsblatt, das die Buchung im Liegenschaftskataster enthält.'),
('3000', 'Pseudoblatt', 'Ein Pseudoblatt ist ein Buchungsblatt, das die Buchung, die bereits vor Eintrag im Grundbuch Rechtskraft erlangt hat, enthält.'),
('4000', 'Erwerberblatt', 'Ein Erwerberblatt ist ein Buchungsblatt, das die Buchung, die bereits im Liegenschaftskataster, aber noch nicht im Grundbuch gebucht ist, enthält (Buchungsvorschlag für die Grundbuchverwaltung).
Pseudoblatt und Erwerberblatt werden nach Eintragung in das Grundbuch historisch.'),
('5000', 'Fiktives Blatt', 'Das fiktive Blatt enthält die aufgeteilten Grundstücke und Rechte als Ganzes. Es bildet um die Miteigentumsanteile eine fachliche Klammer.');
CREATE TABLE ax_eigentuemerart_namensnummer (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_eigentuemerart_namensnummer IS 'Alias: "AX_Eigentuemerart_Namensnummer", UML-Typ: Enumeration';
INSERT INTO ax_eigentuemerart_namensnummer (wert,beschreibung,dokumentation) VALUES
('1000', 'Natürliche Personen', ''),
('1100', 'Natürliche Person - Alleineigentum oder Ehepartner', ''),
('1200', 'Natürliche Person - Wohnsitz im Land', ''),
('1300', 'Natürliche Person - Wohnsitz außerhalb des Landes', ''),
('1500', 'Natürliche Person - Gemeinschaftseigentum', ''),
('2000', 'Juristische Personen', ''),
('2100', 'Gemeinnützige Bau-, Wohnungs- oder Siedlungsgesellschaft oder -genossenschaft einschließlich Heimstätte', ''),
('2200', 'Sonstige gemeinnützige Institution (Träger von Krankenhäusern, Altenheimen usw.)', ''),
('2300', 'Privates Wohnungsunternehmen, private Baugesellschaft u.ä.', ''),
('2400', 'Kreditinstitut', ''),
('2500', 'Versicherungsunternehmen', ''),
('2900', 'Andere Unternehmen, Gesellschaften usw.', ''),
('3000', 'Körperschaften', ''),
('3100', 'Stiftung', ''),
('4000', 'Kirchliches Eigentum', ''),
('4100', 'Evangelische Kirche', ''),
('4200', 'Katholische Kirche', ''),
('4900', 'Andere Kirchen, Religionsgemeinschaften usw.', ''),
('5100', 'Bundesrepublik Deutschland', ''),
('5101', 'Bundesrepublik Deutschland, Bundesstraßenverwaltung', ''),
('5102', 'Bundesrepublik Deutschland, Bundeswehrverwaltung', ''),
('5103', 'Bundesrepublik Deutschland, Forstverwaltung', ''),
('5104', 'Bundesrepublik Deutschland, Finanzverwaltung', ''),
('5105', 'Bundesrepublik Deutschland, Zivilschutz', ''),
('5106', 'Bundesrepublik Deutschland, Wasserstraßenverwaltung', ''),
('5107', 'Bundesrepublik Deutschland, Bundeseisenbahnvermögen', ''),
('5108', 'Bundesanstalt für Immobilienaufgaben', ''),
('5210', 'Eigentum des Volkes nach DDR-Recht', ''),
('5220', 'Eigentum der Genossenschaften und deren Einrichtungen', ''),
('5230', 'Eigentum der gesellschaftlichen Organisationen und deren Einrichtungen', ''),
('5240', 'Kommunale Gebietskörperschaften nach DDR-Recht', ''),
('5300', 'Ausländischer Staat', ''),
('5400', 'Kreis', ''),
('5500', 'Gemeinde', ''),
('5600', 'Kommunale Gebietskörperschaften', ''),
('5700', 'Andere Gebietskörperschaften, Regionalverbände usw.', ''),
('5800', 'Zweckverbände, Kommunale Betriebe', ''),
('5920', 'Eigenes Bundesland', ''),
('5921', 'Eigenes Bundesland, Denkmalpflege', ''),
('5922', 'Eigenes Bundesland, Domänenverwaltung', ''),
('5923', 'Eigenes Bundesland, Eichverwaltung', ''),
('5924', 'Eigenes Bundesland, Finanzverwaltung', ''),
('5925', 'Eigenes Bundesland, Forstverwaltung', ''),
('5926', 'Eigenes Bundesland, Gesundheitswesen', ''),
('5927', 'Eigenes Bundesland, Polizeiverwaltung', ''),
('5928', 'Eigenes Bundesland, innere Verwaltung', ''),
('5929', 'Eigenes Bundesland, Justizverwaltung', ''),
('5930', 'Eigenes Bundesland, Kultusverwaltung', ''),
('5931', 'Eigenes Bundesland, Landespflanzenschutzverwaltung', ''),
('5932', 'Eigenes Bundesland, Arbeitsverwaltung', ''),
('5933', 'Eigenes Bundesland, Sozialwesen', ''),
('5934', 'Eigenes Bundesland, Landesbetrieb Straßen und Verkehr', ''),
('5935', 'Eigenes Bundesland, Umweltverwaltung', ''),
('5936', 'Eigenes Bundesland, Vermessungs- und Katasterverwaltung', ''),
('5937', 'Eigenes Bundesland, Wasserwirtschaftsverwaltung', ''),
('5938', 'Eigenes Bundesland, Wirtschaftsverwaltung', ''),
('5939', 'Eigenes Bundesland, Liegenschafts- und Baubetreuung (LBB)', ''),
('5940', 'Eigenes Bundesland, Naturschutzverwaltung', ''),
('6000', 'Anderes Bundesland (allg.)', ''),
('6001', 'Schleswig-Holstein', ''),
('6002', 'Hamburg', ''),
('6003', 'Niedersachsen', ''),
('6004', 'Bremen', ''),
('6005', 'Nordrhein-Westfalen', ''),
('6006', 'Hessen', ''),
('6007', 'Rheinland-Pfalz', ''),
('6008', 'Baden-Württemberg', ''),
('6009', 'Bayern', ''),
('6010', 'Saarland', ''),
('6011', 'Berlin', ''),
('6012', 'Brandenburg', ''),
('6013', 'Mecklenburg-Vorpommern', ''),
('6014', 'Sachsen', ''),
('6015', 'Sachsen-Anhalt', ''),
('6016', 'Thüringen', ''),
('7100', 'Deutsche Bahn AG', ''),
('8000', 'Herrenlos', ''),
('9000', 'Eigentümer unbekannt', '');
CREATE TABLE ax_buchungsart_buchungsstelle (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_buchungsart_buchungsstelle IS 'Alias: "AX_Buchungsart_Buchungsstelle", UML-Typ: Enumeration';
INSERT INTO ax_buchungsart_buchungsstelle (wert,beschreibung,dokumentation) VALUES
('1100', 'Grundstück', 'Das Grundstück ist ein räumlich abgegrenzter Teil der Erdoberfläche, der auf einem besonderen Blatt, dem Grundbuchblatt, für sich allein oder auf einem gemeinschaftlichen Grundbuchblatt unter einer eindeutigen Nummer des Bestandsverzeichnisses eingetragen ist (Grundstück im Rechtssinn). Das Grundstück besteht aus einem oder mehreren Flurstücken.'),
('1101', 'Aufgeteiltes Grundstück WEG', 'Ein aufgeteiltes GrundstückWEG ist die Zusammenfassung aller in Wohnungs- oder Teileigentum aufgeteilten Anteile eines Grundstücks. Es handelt sich daher um eine Buchungsart für das Fiktive Blatt.'),
('1102', 'Aufgeteiltes Grundstück Par. 3 Abs. 4 GBO', 'Ein aufgeteiltes Grundstück nach Par. 3 Abs. 4 GBO ist die Zusammenfassung aller dienenden Miteigentumsanteile eines Grundstücks (Miteigentumsanteil nach § 3 Abs. 4 GBO). Es handelt sich daher um eine Buchungsart für das Fiktive Blatt.'),
('1200', 'Ungetrennter Hofraum', 'Zu einem ungetrennten Hofraum gehören Grundstücke, die zwar in ihren Außengrenzen, nicht aber bezüglich der daran bestehenden Anteile vermessen und katastermäßig erfasst sind. Im Grundbuch werden die nicht ausgemessenen , einzelnen Grundstücksflächen als Anteil an einem ungetrennten Hofraum ausgewiesen. Bis zur Vermessung der einzelnen Grundstücksflächen und Aufnahme in das Liegenschaftsbuch gilt das Gebäudesteuerbuch als amtliches Verzeichnis nach Par. 2 Abs. 2 GBO. Diese Nummer des Gebäudesteuerbuchs ist bis zur Vermessung im Grundbuch eingetragen. Für ungetrennte Hofräume existieren zwei miteinander korrespondierende Eintragungen:
In einem Grundbuchblatt sind alle ungetrennten Hofräume eines Grundbuchbezirks verzeichnet. Im zweiten Grundbuchblatt ist im Bestandsverzeichnis dann der Anteil an einem bestimmten ungetrennten Hofraum eingetragen.
Nach der katasterlichen Erfassung wird die bisherige Eintragung in beiden Grundbüchern gelöscht und das vermessenene Grundstück als normales Grundstück gebucht.'),
('1301', 'Wohnungs-/Teileigentum', 'Das Wohnungseigentum kann nach Par. 3 Wohnungseigentumsgesetz (WEG) durch Vertrag der Miteigentümer oder nach Par. 8 WEG durch Erklärung des Eigentümers 
begründet werden.
Das entstehende Wohnungseigentum (Teileigentum) ist echtes Eigentum bürgerlichen Rechts in Form einer rechtlichen Verbindung von Miteigentum an Grundstück und Gebäude mit Sondereigentum an einer Wohnung bzw. Teileigentum an nicht zu Wohnzwecken dienenden Räumen.'),
('1302', 'Miteigentum Par. 3 Abs. 4 GBO', 'Ein Miteigentum nach Par. 3 Abs. 4 der Grundbuchordnung (GBO) ist ein Miteigentum an einem dienenden Grundstück. Ist das Grundstück im wirtschaftlichen Sinn als Zubehör mehrerer anderer Grundstücke anzusehen und steht es im Miteigentum dieser Grundstücke (Bruchteilseigentum nach Par. 1008 ff des Bürgerlichen Gesetzbuchs (BGB), muss das Grundstück nicht in einem separaten Grundbuch geführt werden. Vielmehr wird das dienende Grundstück in ideellen Miteigentumsanteilen auf den Grundbuchblättern der herrschenden Grundstücke gebucht.'),
('1303', 'Anteil am ungetrennten Hofraum', 'Hierbei handelt es sich um die Buchung des Anteils am ungetrennten Hofraum.'),
('1401', 'Aufgeteilter Anteil Wohnungs-/Teileigentum', 'Hier wurde der mit dem Sondereigentum verbundene Miteigentumsanteil (Wohnungs-/Teileigentum) nochmals unterteilt. Die vorgenommene Grundbucheintragung deutet auf eine Untergemeinschaft innerhalb der Gesamtgemeinschaft hin. Es handelt sich um eine Buchungsart für das Fiktive Blatt.'),
('1402', 'Aufgeteilter Anteil Miteigentum Par. 3 Abs. 4 GBO', 'Hier wurde der Miteigentumsanteil nach Par. 3 (4) GBO nochmals unterteilt. Die vorgenommene Grundbucheintragung deutet auf eine Untergemeinschaft innerhalb der Gesamtgemeinschaft hin. Es handelt sich um eine Buchungsart für das Fiktive Blatt.'),
('1403', 'Aufgeteilter Anteil am ungetrennten Hofraum', 'Hier wurde der Anteil an ungeteiltem Hofraum nochmals unterteilt. Die vorgenommene Grundbucheintragung deutet auf eine Untergemeinschaft innerhalb der Gesamtgemeinschaft hin. Es handelt sich um eine Buchungsart für das Fiktive Blatt.'),
('1404', 'Nach §3 Abs. 4 GBO aufgeteilter Anteil an Wohnungs-/Teileigentum', 'Nach §3 Abs. 4 GBO aufgeteilter Anteil an Wohnungs-/Teileigentum'),
('1501', 'Anteil an Wohnungs-/Teileigentumsanteil', 'Hier wird der Anteil an dem Wohnungs-/Teileigentumsanteil im Grundbuch eingetragen.'),
('1502', 'Anteil an Miteigentumsanteil Par. 3 Abs. 4 GBO', 'Hier wird der Anteil an dem Miteigentumsanteil nach Par. 3 Abs. 4 GBO im Grundbuch eingetragen'),
('1503', 'Anteil am Anteil zum ungetrennten Hofraum', 'Hier wird der Anteil an dem Anteil an dem ungetrennten Hofraum im Grundbuch eingetragen.'),
('1504', 'Anteil nach §3 Abs. 4 GBO am Wohnungs-/Teileigentumsanteil', ''),
('2101', 'Erbbaurecht', 'Veräußerliches und vererbliches grundstücksgleiches Recht, auf oder unter der Erdoberfläche eines (in der Regel) fremden Grundstücks ein Bauwerk zu haben.'),
('2102', 'Untererbbaurecht', 'Untererbbaurecht ist das Erbbaurecht an einem Erbbaurecht. Hier ist der Belastungsgegenstand nicht das Grundstück, sondern das auf diesem lastenden Erbbaurecht.'),
('2103', 'Gebäudeeigentum', 'Das Gebäudeeigentum an einem Grundstück als Ganzes zur Errichtung und Nutzung eines Gebäudes.'),
('2104', 'Fischereirecht', 'Fischereirecht ist die Befugnis, in einem Binnengewässer (See, Teich, Fluß, Bach) Fische, Krebse und andere nutzbare Wassertiere (z.B. Muscheln, Frösche), die nicht Gegenstand des Jagdrechts sind, zu hegen und sich anzueignen.'),
('2105', 'Bergwerksrecht', 'Bergwerksrecht ist das ausschließliche Recht, in einem bestimmten Feld die in der Bewilligung bezeichneten Bodenschätze aufzusuchen und zu gewinnen (Par.9 I, Par. 8 BBergG vom 13.08.1980, BGBl. I 1310).'),
('2106', 'Nutzungsrecht', 'Hierunter sind alle Nutzungsrechte zu verstehen, die im Bestandsverzeichnis eingetragen werden, unabhängig von ihrer öffentlich- oder privatrechtlichen Natur. Die nähere Bezeichnung des Nutzungsrechts ergibt sich aus dem Attribut Buchungstext.'),
('2107', 'Realgewerberecht', 'Hierbei handelt es sich um die frei veräußerliche und vererbliche Befugnis zum Betrieb eines bestimmten Gewerbes, die mit dem Besitz einer Liegenschaft verbunden sein kann aber nicht zwingend an ein bestimmtes Grundstücks gebunden sein muss. Die nähere Bezeichnung des Nutzungsrechts ergibt sich aus dem Attribut Buchungstext.'),
('2108', 'Gemeinderecht', 'Gemeinderecht ist das Recht zur Nutzung eines gemeinschaftlichen Grundstücks. Die näheren Angaben zu diesem Recht sind in privatrechtlichen Verträgen enthalten.'),
('2109', 'Stavenrecht', 'Ist ein mit dem Erbbaurecht vergleichbares Recht in den nordfriesischen Küstenregionen.'),
('2110', 'Hauberge', ''),
('2201', 'Aufgeteiltes Erbbaurecht WEG', 'Diese Buchungsart ist die Zusammenfassung aller Anteile eines Erbbaurechts, die auf mehreren Grundbuchblättern gebucht sind. Es handelt sich hier um eine Buchungsart für das Fiktive Blatt.'),
('2202', 'Aufgeteiltes Untererbbaurecht WEG', 'Diese Buchungsart ist die Zusammenfassung aller Anteile eines Untererbbaurechts, die auf mehreren Grundbuchblättern gebucht sind. Es handelt sich hier um eine Buchungsart für das Fiktive Blatt.'),
('2203', 'Aufgeteiltes Recht Par. 3 Abs. 4 GBO', 'Diese Buchungsart ist die Zusammenfassung aller dienenden Miteigentumsanteile eines Erbbaurechts. Es handelt sich hier um eine Buchungsart für das Fiktive Blatt.'),
('2204', 'Aufgeteiltes Recht, Körperschaft', 'Diese Buchungsart ist die Zusammenfassung aller auf den Grundbuchblättern der herrschenden Grundstücke gebuchten Nutzanteile an einer Körperschaft. Es handelt sich hier um eine Buchungsart für das Fiktive Blatt. Eine Körperschaft besteht aus einem Verband von Mitgliedern, deren Mitgliedschaft an landesrechtliche (meistens altrechtliche ) und persönliche Merkmale gebunden ist; die Mitglieder haben das Recht zur Nutzung des Grundstücks in einem bestimmten Umfang (z.B. Körperschaftswaldungen).'),
('2205', 'Aufgeteiltes Gebäudeeigentum', 'Diese Buchungsart ist die Zusammenfassung aller Anteile eines Gebäudeeigentums, die auf mehreren Grundbuchblättern gebucht sind. Es handelt sich hier um eine Buchungsart für das Fiktive Blatt.'),
('2206', 'Aufgeteiltes Recht Par. 3 Abs. 4 GBO (Untererbbaurecht)', 'Historisches Untererbbaurecht, welches gemäß § 3 Abs. 4 GBO aufgeteilt worden ist. Es handelt sich hier um eine Buchungsart für das Fiktive Blatt.'),
('2301', 'Wohnungs-/Teilerbbaurecht', 'Wohnungs-/Teilerbaurechte können nach Par. 30 WEG unter Anwendung der Par. 3, 8 WEG begründet werden, wobei an die Stelle des Miteigentums am Grundstück die Mitberechtigung nach Bruchteilen an einem Erbbaurecht tritt, mit welchem das Sondereigentum an der Wohnung bzw. den nicht zu Wohnzwecken dienenden Räumen verbunden wird.'),
('2302', 'Wohnungs-/Teiluntererbbaurecht', 'Wohnungs-/Teiluntererbbaurecht ist die Aufteilung eines Untererbbaurechts analog Par. 30 WEG.'),
('2303', 'Erbbaurechtsanteil Par. 3 Abs. 4 GBO', 'Ein Erbbaurechtsanteil nach Par. 3 Abs. 4 der Grundbuchordnung (GBO) ist ein Miteigentum an einem dienenden Erbbaurecht.'),
('2304', 'Anteiliges Recht, Körperschaft', 'Eintragung eines Anteils an dem Recht - Körperschaft nach Par. 9 GBO im Grundbuch des jeweils herrschenden Grundstückes, dabei besteht die Körperschaft aus einem Verband von Mitgliedern, deren Mitgliedschaft an gebietliche und persönliche Merkmale geknüpft ist (z. B. Körperschaftswaldungen).'),
('2305', 'Anteil am Gebäudeeigentum', 'Ist der Anteil des Nutzungsberechtigten für die Nutzung des auf dem Grundstück stehenden Gebäudes.'),
('2306', 'Untererbbaurechtsanteil Par. 3 Abs. 4 GBO', 'Untererbbaurecht, welches gemäß § 3 Abs. 4 GBO aufgeteilt worden ist.'),
('2401', 'Aufgeteilter Anteil Wohnungs-/Teilerbbaurecht', 'Hierbei wurde der Anteil an einem Wohnungs-/Teilerbbaurecht nochmals unterteilt. Es handelt sich um eine Buchungsart für das Fiktive Blatt.'),
('2402', 'Aufgeteilter Anteil Wohnungs-/Teiluntererbbaurecht', 'Hierbei wurde der Anteil an einem Wohnungs-/Teiluntererbbaurecht nochmals unterteilt. Es handelt sich um eine Buchungsart für das Fiktive Blatt.'),
('2403', 'Aufgeteilter Erbbaurechtsanteil Par. 3 Abs. 4 GBO', 'Hierbei wurde der Anteil an einem Erbbaurechtsanteil nochmals unterteilt. Es handelt sich um eine Buchungsart für das Fiktive Blatt.'),
('2404', 'Aufgeteiltes anteiliges Recht, Körperschaft', 'Hierbei wurde der Anteil an einem anteiligem Recht Körperschaft nochmals unterteilt. Es handelt sich um eine Buchungsart für das Fiktive Blatt.'),
('2405', 'Aufgeteilter Anteil am Gebäudeeigentum', 'Hierbei wurde der Anteil an einem Gebäudeeigentum nochmals unterteilt. Es handelt sich um eine Buchungsart für das Fiktive Blatt.'),
('2406', 'Nach §3 Abs. 4 GBO aufgeteilter Anteil an Wohnungs-/Teilerbbaurecht', ''),
('2407', 'Nach §3 Abs. 4 GBO aufgeteilter Anteil an Wohnungs-/Teiluntererbbaurecht', ''),
('2501', 'Anteil am Wohnungs-/Teilerbbaurechtsanteil', 'Hier wird der Anteil an dem Wohnungs-/Teilerbbaurechtsanteil im Grundbuch eingetragen.'),
('2502', 'Anteil am Wohnungs-/Teiluntererbbaurechtsanteil', 'Hier wird der Anteil an dem Wohnungs-/Teiluntererbbaurechtsanteil im Grundbuch eingetragen.'),
('2503', 'Anteil am Erbbaurechtsanteil Par. 3 Abs. 4 GBO', 'Hier wird der Anteil an dem Erbbaurechtsanteil im Grundbuch eingetragen.'),
('2504', 'Anteil am anteiligen Recht, Körperschaft', 'Hier wird der Anteil an dem anteiligen Recht Körperschaft im Grundbuch eingetragen.'),
('2505', 'Anteil am Anteil zum Gebäudeeigentum', 'Hier wird der Anteil an dem Anteil zum Gebäudeeigentum im Grundbuch eingetragen.'),
('2506', 'Anteil nach §3 Abs. 4 GBO am Wohnungs-/Teilerbbaurechtsanteil', ''),
('2507', 'Anteil nach §3 Abs. 4 GBO am Wohnungs-/Teiluntererbbaurechtsanteil', ''),
('3100', 'Vermerk subjektiv dinglicher Rechte (Par. 9 GBO)', 'Der Vermerk ist ein Hinweis auf eine in Abteilung II des Grundbuchs des dienenden Grundstücks eingetragene Belastung. Er selbst ist kein Recht; seine Eintragung sichert lediglich, dass bei einer Aufhebung des Rechts im Grundbuch des dienenden Grundstücks die Bewilligung derer erforderlich ist, die der Rechtsänderung nach Par. 876 S. 2, 877, 888 BGB zustimmen müssen.'),
('4100', 'Stockwerkseigentum', ''),
('5101', 'Von Buchungspflicht befreit Par. 3 Abs. 2 GBO', 'Grundstücke nach Par. 3 Abs. 2 sind von der Buchungspflicht befreit und werden auf dem Katasterblatt gebucht.'),
('5200', 'Anliegerflurstück', 'Ein Flurstück dessen Teilflächen den anliegenden Flurstücken zugerechnet wird.'),
('5201', 'Anliegerweg', ''),
('5202', 'Anliegergraben', ''),
('5203', 'Anliegerwasserlauf, Anliegergewässer', ''),
('6101', 'Nicht gebuchtes Fischereirecht', 'Das nicht gebuchte Fischereirecht wird nach Wasserrecht im Fischwasserkataster nachgewiesen und ist im Grundbuch nicht gebucht.');
CREATE TABLE ax_li_processstep_ohnedatenerhebung_description (
  wert character varying,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_li_processstep_ohnedatenerhebung_description IS 'Alias: "AX_LI_ProcessStep_OhneDatenerhebung_Description", UML-Typ: Enumeration';
INSERT INTO ax_li_processstep_ohnedatenerhebung_description (wert,beschreibung,dokumentation) VALUES
('Erhebung', NULL, 'Erhebung beschreibt des Prozess der Datengewinnung durch die Katasterverwaltung.'),
('Übernahme', NULL, 'Übernahme beschreibt die Datengewinnung durch Übernahme der Daten aus dem Grundbuch.');
CREATE TABLE ax_anrede_person (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_anrede_person IS 'Alias: "AX_Anrede_Person", UML-Typ: Enumeration';
INSERT INTO ax_anrede_person (wert,beschreibung,dokumentation) VALUES
('1000', 'Frau', 'Frau ist eine natürliche, menschliche Person weiblichen Geschlechts.'),
('2000', 'Herr', 'Herr ist eine natürliche, menschliche Person männlichen Geschlechts.'),
('3000', 'Firma', 'Firma ist ein gewerbliches Unternehmen.');
CREATE TABLE ax_artderrechtsgemeinschaft_namensnummer (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_artderrechtsgemeinschaft_namensnummer IS 'Alias: "AX_ArtDerRechtsgemeinschaft_Namensnummer", UML-Typ: Enumeration';
INSERT INTO ax_artderrechtsgemeinschaft_namensnummer (wert,beschreibung,dokumentation) VALUES
('1000', 'Erbengemeinschaft', ''),
('2000', 'Gütergemeinschaft', ''),
('3000', 'BGB-Gesellschaft', ''),
('4010', 'Gesamtberechtigte gemäß § 428 BGB', ''),
('4020', 'Gesamtberechtigte gemäß § 432 BGB', ''),
('4030', 'Mitglieder eines nicht eingetragenen Vereins', ''),
('4040', 'Fortgesetzte Gütergemeinschaft', ''),
('4050', 'Beendete, nicht auseinandergesetzte Gütergemeinschaft', ''),
('4060', 'Errungenschaftsgemeinschaft', ''),
('4070', 'Fortgesetzte Errungenschaftsgemeinschaft', ''),
('4080', 'Beendete, nicht auseinandergesetzte Errungenschaftsgemeinschaft', ''),
('4090', 'Fahrnisgemeinschaft', ''),
('4100', 'Fortgesetzte Fahrnisgemeinschaft', ''),
('4110', 'Beendete, nicht auseinandergesetzte Fahrnisgemeinschaft', ''),
('4120', 'Eigentums- und Vermögensgemeinschaft nach FGB', ''),
('4130', 'Beendete, nicht auseinandergesetzte Eigentums- und Vermögensgemeinschaft nach FGB', ''),
('4140', 'Altrechtliche Gemeinschaft', ''),
('9999', 'Sonstiges', '');
CREATE TABLE ax_punktstabilitaet_hoehenfestpunkt_guetedesvermarkungstra (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_punktstabilitaet_hoehenfestpunkt_guetedesvermarkungstra IS 'Alias: "AX_Punktstabilitaet_Hoehenfestpunkt_GueteDesVermarkungstraegers", UML-Typ: Enumeration';
INSERT INTO ax_punktstabilitaet_hoehenfestpunkt_guetedesvermarkungstra (wert,beschreibung,dokumentation) VALUES
('1000', 'Sehr gut', ''),
('2000', 'Gut', ''),
('3000', 'Befriedigend', ''),
('4000', 'Ausreichend', ''),
('5000', 'Mangelhaft', ''),
('9998', 'Nicht bekannt', '');
CREATE TABLE ax_punktstabilitaet_hoehenfestpunkt_guetedesbaugrundes (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_punktstabilitaet_hoehenfestpunkt_guetedesbaugrundes IS 'Alias: "AX_Punktstabilitaet_Hoehenfestpunkt_GueteDesBaugrundes", UML-Typ: Enumeration';
INSERT INTO ax_punktstabilitaet_hoehenfestpunkt_guetedesbaugrundes (wert,beschreibung,dokumentation) VALUES
('1000', 'Sehr gut', ''),
('2000', 'Gut', ''),
('3000', 'Befriedigend', ''),
('4000', 'Ausreichend', ''),
('5000', 'Mangelhaft', ''),
('9998', 'Nicht untersucht', '');
CREATE TABLE ax_punktstabilitaet_hoehenfestpunkt_geologischestabilitaet (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_punktstabilitaet_hoehenfestpunkt_geologischestabilitaet IS 'Alias: "AX_Punktstabilitaet_Hoehenfestpunkt_GeologischeStabilitaet", UML-Typ: Enumeration';
INSERT INTO ax_punktstabilitaet_hoehenfestpunkt_geologischestabilitaet (wert,beschreibung,dokumentation) VALUES
('1000', 'Sehr gut', ''),
('2000', 'Gut', ''),
('3000', 'Befriedigend', ''),
('4000', 'Ausreichend', ''),
('5000', 'Mangelhaft', ''),
('9998', 'Nicht untersucht', '');
CREATE TABLE ax_klassifikation_hierarchiestufe3d_lagefestpunkt (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_klassifikation_hierarchiestufe3d_lagefestpunkt IS 'Alias: "AX_Klassifikation_Hierarchiestufe3D_Lagefestpunkt", UML-Typ: Enumeration';
INSERT INTO ax_klassifikation_hierarchiestufe3d_lagefestpunkt (wert,beschreibung,dokumentation) VALUES
('1000', 'A', ''),
('2000', 'B', ''),
('3000', 'C', ''),
('4000', 'D', ''),
('5000', 'E', ''),
('9998', 'Nach Quellenlage nicht zu spezifizieren', '');
CREATE TABLE ax_klassifikation_ordnung_lagefestpunkt (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_klassifikation_ordnung_lagefestpunkt IS 'Alias: "AX_Klassifikation_Ordnung_Lagefestpunkt", UML-Typ: Enumeration';
INSERT INTO ax_klassifikation_ordnung_lagefestpunkt (wert,beschreibung,dokumentation) VALUES
('1000', '1. Ordnung', ''),
('2000', '2. Ordnung', ''),
('3000', '3. Ordnung', ''),
('4000', '4. Ordnung', ''),
('5000', '5. Ordnung', ''),
('6000', 'ÜL - Übergeordneter Lagefestpunkt (Berlin)', ''),
('9000', 'LFP, der nur eine interne Bedeutung hat', ''),
('9998', 'Nach Quellenlage nicht zu spezifizieren', ''),
('9999', 'Sonstiges', '');
CREATE TABLE ax_skizzenart_skizze (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_skizzenart_skizze IS 'Alias: "AX_Skizzenart_Skizze", UML-Typ: Enumeration';
INSERT INTO ax_skizzenart_skizze (wert,beschreibung,dokumentation) VALUES
('1000', 'Einmessungsskizze', ''),
('2000', 'Sonstige Lageskizze', ''),
('2100', 'Sonstige Einmessungsskizze', ''),
('2200', 'Sonstige Ansichtszeichnung oder Foto', ''),
('2300', 'Randzeichnung', ''),
('3000', 'Ausschnitt aus der Punktübersicht', ''),
('3100', 'Luftbildausschnitt mit Punkteintrag', ''),
('4000', 'Diagramm, Tabelle', '');
CREATE TABLE ax_funktion_schwerefestpunkt (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_schwerefestpunkt IS 'Alias: "AX_Funktion_Schwerefestpunkt", UML-Typ: Enumeration';
INSERT INTO ax_funktion_schwerefestpunkt (wert,beschreibung,dokumentation) VALUES
('1000', 'Zentrum', ''),
('2000', 'Exzentrum', '');
CREATE TABLE ax_punktstabilitaet_hoehenfestpunkt_hoehenstabilitaetauswi (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_punktstabilitaet_hoehenfestpunkt_hoehenstabilitaetauswi IS 'Alias: "AX_Punktstabilitaet_Hoehenfestpunkt_HoehenstabilitaetAusWiederholung", UML-Typ: Enumeration';
INSERT INTO ax_punktstabilitaet_hoehenfestpunkt_hoehenstabilitaetauswi (wert,beschreibung,dokumentation) VALUES
('1000', 'Sehr gut', ''),
('2000', 'Gut', ''),
('3000', 'Befriedigend', ''),
('4000', 'Bedenklich', ''),
('5000', 'Mangelhaft', ''),
('9998', 'Nicht bekannt', '');
CREATE TABLE ax_punktstabilitaet_hoehenfestpunkt_vermutetehoehenstabili (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_punktstabilitaet_hoehenfestpunkt_vermutetehoehenstabili IS 'Alias: "AX_Punktstabilitaet_Hoehenfestpunkt_VermuteteHoehenstabilitaet", UML-Typ: Enumeration';
INSERT INTO ax_punktstabilitaet_hoehenfestpunkt_vermutetehoehenstabili (wert,beschreibung,dokumentation) VALUES
('1000', 'Sehr gut', ''),
('2000', 'Gut', ''),
('3000', 'Befriedigend', ''),
('4000', 'Ausreichend', ''),
('5000', 'Mangelhaft', ''),
('5100', 'Mangelhaft (Bergsenkungsgebiet)', ''),
('5200', 'Mangelhaft (in rutschgefährdeter Hanglage)', ''),
('5300', 'Mangelhaft (sehr nahe an Gewässer)', ''),
('5400', 'Mangelhaft (instabiler Untergrund)', ''),
('9998', 'Nicht untersucht', '');
CREATE TABLE ax_ordnung_schwerefestpunkt (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_ordnung_schwerefestpunkt IS 'Alias: "AX_Ordnung_Schwerefestpunkt", UML-Typ: Enumeration';
INSERT INTO ax_ordnung_schwerefestpunkt (wert,beschreibung,dokumentation) VALUES
('0500', 'Schweregrundnetzpunkt', ''),
('1000', '1. Ordnung', ''),
('2000', '2. Ordnung', ''),
('3000', '3. Ordnung', ''),
('4000', '4. Ordnung', ''),
('9000', 'SFP, der nur eine interne Bedeutung hat', ''),
('9998', 'Nach Quellenlage nicht zu spezifizieren', '');
CREATE TABLE ax_punktstabilitaet_hoehenfestpunkt_grundwasserschwankung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_punktstabilitaet_hoehenfestpunkt_grundwasserschwankung IS 'Alias: "AX_Punktstabilitaet_Hoehenfestpunkt_Grundwasserschwankung", UML-Typ: Enumeration';
INSERT INTO ax_punktstabilitaet_hoehenfestpunkt_grundwasserschwankung (wert,beschreibung,dokumentation) VALUES
('1000', 'Sehr gering (kleiner gleich 0,5 m)', ''),
('2000', 'Gering (größer 0,5 m und kleiner gleich 2 m)', ''),
('3000', 'Mäßig (größer 2 m und kleiner gleich 5 m)', ''),
('4000', 'Stark (größer 5 m und kleiner gleich 10 m)', ''),
('5000', 'Sehr stark (größer 10 m)', ''),
('9998', 'Nicht untersucht', '');
CREATE TABLE ax_punktstabilitaet (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_punktstabilitaet IS 'Alias: "AX_Punktstabilitaet", UML-Typ: Enumeration';
INSERT INTO ax_punktstabilitaet (wert,beschreibung,dokumentation) VALUES
('1000', 'Sehr gut', ''),
('2000', 'Gut', ''),
('3000', 'Befriedigend', ''),
('4000', 'Ausreichend', ''),
('5000', 'Mangelhaft', ''),
('5100', 'Mangelhaft (Bergsenkungsgebiet)', ''),
('5200', 'Mangelhaft (in rutschgefährdeter Hanglage)', ''),
('5300', 'Mangelhaft (sehr nahe an Gewässer)', ''),
('5400', 'Mangelhaft (instabiler Untergrund)', ''),
('6000', 'Aus Wiederholungsmessungen nachgewiesen', ''),
('9998', 'Nicht untersucht', '');
CREATE TABLE ax_klassifikation_wertigkeit_lagefestpunkt (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_klassifikation_wertigkeit_lagefestpunkt IS 'Alias: "AX_Klassifikation_Wertigkeit_Lagefestpunkt", UML-Typ: Enumeration';
INSERT INTO ax_klassifikation_wertigkeit_lagefestpunkt (wert,beschreibung,dokumentation) VALUES
('1000', 'Fundamentalpunkt', 'Punkt auf dem die Position (3D), die schwerebezogene Höhe und die Schwere hoch genau bestimmt worden sind.'),
('2000', 'Übergeordneter Festpunkt', ''),
('3000', 'Geodätischer Grundnetzpunkt', ''),
('4000', 'Gebrauchsfestpunkt', ''),
('5000', 'Untergeordneter Festpunkt', ''),
('9998', 'Nach Quellenlage nicht zu spezifizieren', ''),
('9999', 'Sonstiges', '');
CREATE TABLE ax_funktion_lagefestpunkt (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_lagefestpunkt IS 'Alias: "AX_Funktion_Lagefestpunkt", UML-Typ: Enumeration';
INSERT INTO ax_funktion_lagefestpunkt (wert,beschreibung,dokumentation) VALUES
('1000', 'Zentrum', ''),
('2000', 'Exzentrum', ''),
('3000', 'Zwillingspunkt, Orientierungspunkt', ''),
('4000', 'Versicherungspunkt', '');
CREATE TABLE ax_funktion_referenzstationspunkt (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_referenzstationspunkt IS 'Alias: "AX_Funktion_Referenzstationspunkt", UML-Typ: Enumeration';
INSERT INTO ax_funktion_referenzstationspunkt (wert,beschreibung,dokumentation) VALUES
('1000', 'Zentrum', ''),
('2000', 'Exzentrum', '');
CREATE TABLE ax_punktstabilitaet_hoehenfestpunkt_grundwasserstand (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_punktstabilitaet_hoehenfestpunkt_grundwasserstand IS 'Alias: "AX_Punktstabilitaet_Hoehenfestpunkt_Grundwasserstand", UML-Typ: Enumeration';
INSERT INTO ax_punktstabilitaet_hoehenfestpunkt_grundwasserstand (wert,beschreibung,dokumentation) VALUES
('1000', 'Sehr tief (größer 10 m)', ''),
('2000', 'Tief (größer 5 m und kleiner gleich 10 m)', ''),
('3000', 'Normal (größer 2 m und kleiner gleich 5 m)', ''),
('4000', 'Hoch (größer 0,5 m und kleiner gleich 2 m)', ''),
('5000', 'Sehr hoch (kleiner gleich 0,5 m)', ''),
('9000', 'Abgesenkt', ''),
('9998', 'Nicht untersucht', '');
CREATE TABLE ax_gnsstauglichkeit (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_gnsstauglichkeit IS 'Alias: "AX_GNSSTauglichkeit", UML-Typ: Enumeration';
INSERT INTO ax_gnsstauglichkeit (wert,beschreibung,dokumentation) VALUES
('1000', 'Vermutlich sehr gut', 'Weitgehende Horizontfreiheit, Mehrwegeffekte nicht wahrscheinlich.'),
('1001', 'Sehr gut', 'Sehr gute Satelliten-Empfangseigenschaften in Messungen nachgewiesen.'),
('3000', 'Vermutlich gut', 'Eingeschränkte Horizontfreiheit.'),
('3001', 'Gut', 'Eingeschränkte Horizontfreiheit, Tauglichkeit nachgewiesen.'),
('3100', 'Vermutlich befriedigend', 'Mehrwegeffekte möglich.'),
('3101', 'Befriedigend', 'Mehrwegeffekte nachgewiesen.'),
('5000', 'Ungenügend', 'Festpunkt nicht geeignet für Satellitenmessverfahren.'),
('9998', 'Nicht untersucht', '');
CREATE TABLE ax_ordnung_hoehenfestpunkt (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_ordnung_hoehenfestpunkt IS 'Alias: "AX_Ordnung_Hoehenfestpunkt", UML-Typ: Enumeration';
INSERT INTO ax_ordnung_hoehenfestpunkt (wert,beschreibung,dokumentation) VALUES
('1000', '1. Ordnung', ''),
('1001', '1. Ordnung - Netzverdichtung GPS (Niedersachsen)', ''),
('2000', '2. Ordnung', ''),
('3000', '3. Ordnung', ''),
('3001', '3. Ordnung - nivellitisch bestimmter Bodenpunkt für Referenzstation', ''),
('4000', '4. Ordnung', ''),
('6000', 'ÜH - Übergeordneter Höhenfestpunkt (Berlin)', ''),
('9000', 'Höhenfestpunkt, der nur eine interne Bedeutung hat', ''),
('9998', 'Nach Quellenlage nicht zu spezifizieren', '');
CREATE TABLE ax_punktstabilitaet_hoehenfestpunkt_topographieundumwelt (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_punktstabilitaet_hoehenfestpunkt_topographieundumwelt IS 'Alias: "AX_Punktstabilitaet_Hoehenfestpunkt_TopographieUndUmwelt", UML-Typ: Enumeration';
INSERT INTO ax_punktstabilitaet_hoehenfestpunkt_topographieundumwelt (wert,beschreibung,dokumentation) VALUES
('1000', 'Keine', ''),
('2000', 'Geringe', ''),
('3000', 'Mäßige', ''),
('4000', 'Starke', ''),
('5000', 'Sehr starke', ''),
('9998', 'Nicht untersucht', '');
CREATE TABLE ax_marke (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_marke IS 'Alias: "AX_Marke", UML-Typ: Enumeration';
INSERT INTO ax_marke (wert,beschreibung,dokumentation) VALUES
('1000', 'Marke, allgemein', ''),
('1100', 'Stein', ''),
('1110', 'Stein, Grenzstein', ''),
('1111', 'Lochstein', ''),
('1112', 'Vermessungspunktstein', ''),
('1120', 'Unbehauener Feldstein', ''),
('1130', 'Gemeinde- und Waldgrenzstein', ''),
('1131', 'Gemeindegrenzstein', ''),
('1132', 'Waldgrenzstein, Forstgrenzstein', ''),
('1140', 'Kunststoffmarke', ''),
('1160', 'Landesgrenzstein', ''),
('1190', 'Stein mit Besonderheiten in Form oder Material', ''),
('1200', 'Rohr', ''),
('1201', 'Rohr mit Schutzkappe', ''),
('1202', 'Rohr mit Kopf', ''),
('1203', 'Rohr mit Bolzen, oberirdisch', ''),
('1210', 'Eisenrohr', ''),
('1211', 'Eisenrohr (mit Schutzkappe)', ''),
('1212', 'Eisenrohr (ohne Schutzkappe)', ''),
('1220', 'Kunststoffrohr', ''),
('1221', 'Kunststoffrohr (mit Schutzkappe)', ''),
('1222', 'Kunststoffrohr (ohne Schutzkappe)', ''),
('1230', 'Drainrohr', ''),
('1240', 'Rohr mit Schutzkasten', ''),
('1250', 'Zementrohr', ''),
('1260', 'Glasrohr', ''),
('1290', 'Tonrohr', ''),
('1300', 'Bolzen/Nagel', ''),
('1310', 'Bolzen', ''),
('1311', 'Adapterbolzen', ''),
('1320', 'Nagel', ''),
('1400', 'Meißelzeichen (z. B. Kreuz, Kerbe, Anker)', ''),
('1410', 'Bohrloch', ''),
('1500', 'Pfahl', ''),
('1600', 'Sonstige Marke', ''),
('1610', 'Marke in Schutzbehälter', ''),
('1620', 'Flasche', ''),
('1630', 'Platte', ''),
('1631', 'Klinkerplatte', ''),
('1632', 'Granitplatte', ''),
('1635', 'Platte mit Loch', ''),
('1640', 'Hohlziegel', ''),
('1650', 'Klebemarke', ''),
('1655', 'Schlagmarke', ''),
('1660', 'Kanaldeckel (Kreuz des Gütesiegels auf Rand)', ''),
('1670', 'Marke besonderer Ausführung', ''),
('1700', 'Punkt dauerhaft und gut erkennbar festgelegt', ''),
('1710', 'Punkt der baulichen Anlage', ''),
('1711', 'Sockel (roh)', ''),
('1712', 'Sockel (verputzt)', ''),
('1713', 'Mauerecke (roh)', ''),
('1714', 'Mauerecke (verputzt)', ''),
('1720', 'Grenzsäule', ''),
('1800', 'Pfeiler', ''),
('1820', 'Kegel', ''),
('2100', 'Festlegung 1. Ordnung, Kopf 30x30 cm, Bezugspunkt Platte', ''),
('2101', 'Festlegung 1. Ordnung, Bezugspunkt Kopf 30x30 cm', ''),
('2102', 'Festlegung STN 1. Ordnung, Pfeilerkopf 30x30 cm, Bezugspunkt Platte 60x60 cm, Steinwürfel, Tonkegel', ''),
('2110', 'Festlegung 2. bis 5. Ordnung, Kopf 16x16 oder 12x12 cm, Bezugspunkt Platte 30x30 cm', ''),
('2111', 'Festlegung 2. bis 5. Ordnung, Bezugspunkt Kopf 16x16 oder 12x12 cm, Platte 30x30 cm', ''),
('2120', 'Festlegung 2. bis 4. Ordnung, Kopf 20x20 cm, Bezugspunkt Platte', ''),
('2121', 'Festlegung 2. bis 4. Ordnung, Bezugspunkt Kopf 20x20 cm,', ''),
('2130', 'Festlegung 2. bis 4. Ordnung, Kopf 25x25 cm, Bezugspunkt Platte', ''),
('2131', 'Festlegung 2. bis 4. Ordnung, Bezugspunkt Kopf 25x25 cm,', ''),
('2132', 'Festlegung STN 3. und 5. Ordnung, Pfeilerkopf 16x16 cm, Bezugspunkt Platte 30x30-40x40 cm', ''),
('2133', 'Festlegung STN 3. und 5. Ordnung, Pfeilerkopf 16x16 cm, Bezugspunkt Bolzen oder Rotgußkappe im Fels', ''),
('2134', 'Festlegung TP-Feld, Pfeilerkopf 25x25 cm, Bezugspunkt Platte 35x35 cm', ''),
('2135', 'Festlegung RBP-Feld, Pfeilerkopf 16x16 cm mit Gravur "TP" und "Dreieck", Bezugspunkt Platte 30x30-35x35 cm', ''),
('2140', 'Plattformbolzen mit Aufschrift TP', ''),
('2150', 'Turmbolzen mit Aufschrift TP', ''),
('2160', 'Leuchtschraube oder -bolzen', ''),
('2161', 'Schraube (vertikal)', ''),
('2162', 'Messingmarke oder Messingbolzen', ''),
('2163', 'Keramikbolzen, oberirdisch', ''),
('2164', 'Bolzen im Fels, unterirdisch', ''),
('2165', 'Rotgusskappe im Fels, unterirdisch', ''),
('2166', 'Messingbolzen (gewölbt), Aufschrift TP und Dreieck', ''),
('2167', '3D-Messingbolzen (Durchmesser 5 cm) mit Inschrift RFP HESSEN', ''),
('2170', 'Turmbolzen, Festlegungsbolzen oder sonstiger Bolzen, keine weiteren Angaben bekannt oder gespeichert', ''),
('2180', 'Festlegung 2. Ordnung, Kopf 16x16 cm oder 12x12 cm, Bezugspunkt Platte 60x60 cm', ''),
('2181', 'Festlegung 2. Ordnung, Bezugspunkt Kopf 16x16 cm oder 12x12 cm, Platte 60x60 cm', ''),
('2190', 'Festlegung 2. bis 3. Ordnung, Kopf 16x16 cm, Bezugspunkt Platte 40x40 cm', ''),
('2191', 'Festlegung 2. bis 3. Ordnung, Bezugspunkt Kopf 16x16 cm, Platte 40x40 cm', ''),
('2192', 'Bergpfeiler ca. 60 cm lang, ohne Platte, Kopf 12x12 cm', ''),
('2200', 'Pfeiler mit Aufschrift AP', ''),
('2201', 'Pfeiler mit Aufschrift AP mit Platte, Bezugspunkt Kopf', ''),
('2210', 'Plattformbolzen mit der Aufschrift AP', ''),
('2220', 'Turmbolzen mit der Aufschrift AP', ''),
('2230', 'Festlegung der Wasserstraßenverwaltung, Stein mit Rohr und Stehbolzen, Typ 1', ''),
('2240', 'Festlegung der Wasserstraßenverwaltung, Stein mit Rohr und Stehbolzen, Typ 2', ''),
('2250', 'Festlegung der Wasserstraßenverwaltung, Stein mit Rohr und Stehbolzen, Typ 3', ''),
('2260', 'Festlegung Sachsen-Anhalt SANREF (unterirdischer Granitpfeiler mit Kopfbolzen)', ''),
('2261', '3D-Bolzen einzementiert in Kopffläche einer Festlegung STN 1. Ordnung', ''),
('2262', '3D-Bolzen in Kopffläche einer Festle-gung TP-Feld', ''),
('2263', '3D-Bolzen in Kopffläche einer AF Sachsen 3. Ordnung', ''),
('2264', '3D-Bolzen in Kopffläche einer AF Sachsen 5. Ordnung', ''),
('2265', '3D-Bolzen in Granitplatte unter Schutzkasten oder Kunststoff- Schutz-rohr', ''),
('2266', '3D-Bolzen in Kopffläche, einbetonierter Granitpfeiler 40x40x90 cm', ''),
('2267', '3D-Bolzen in Kopffläche, einbetonierter Granitpfeiler 25x25x100 cm', ''),
('2268', '3D-Bolzen in Kopffläche, einbetonierter Granitpfeiler 30x30x100 cm', ''),
('2269', '3D-Bolzen in Kopffläche, einbetonierter Granitpfeiler 50x50x100 cm', ''),
('2300', 'Alte Festlegung der Kgl. Generalkommission und von Kurhessen, Rillenstein', ''),
('2310', 'Alte Festlegung von Nassau, exz., ehemals 2.O.', ''),
('2320', 'Alte Festlegung von Nassau, exz., ehemals 3.O.', ''),
('2330', 'Alte Festlegung von Hessen-Darmstadt, 3.O.', ''),
('2340', 'Alte Festlegung von Hessen-Darmstadt, 4.O.', ''),
('2350', 'Alte Festlegung von Hessen-Darmstadt, 3.O. exz.', ''),
('2360', 'Alte Festlegung von Hessen-Darmstadt, 4.O.exz.', ''),
('2370', 'Alte Festlegung von Westfalen, 2. O. exz.', ''),
('2400', 'Alte Festlegung von Württemberg, exz.', ''),
('2410', 'Alte Festlegung von Württemberg', ''),
('2420', 'Alte Festlegung von Mecklenburg, ehemals 1. bis 2. Ordnung', ''),
('2430', 'Alte Festlegung von Mecklenburg, ehemals 2. bis 3. Ordnung', ''),
('2440', 'Alte Festlegung von Mecklenburg, ehemals 4. Ordnung', ''),
('2450', 'Alte Festlegung Sachsen, 1. und 2. Ordnung (Nagelsche Säule)', ''),
('2460', 'Alte Festlegung Sachsen, 3. Ordnung, Pfeilerkopf 35x35 cm mit zentrischer Messingmarke', ''),
('2470', 'Alte Festlegung Sachsen, 5. Ordnung, Pfeilerkopf 25x25 cm mit zentrischer Messingmarke', ''),
('2500', 'Alte Festlegung von Baden, exz., Typ 1', ''),
('2510', 'Alte Festlegung von Baden, exz., Typ 2', ''),
('2540', 'Alte Festlegung von Baden', ''),
('2550', 'Rohr mit Schutzkasten, Grundständer', ''),
('2551', 'Grundständer mit Messingmarke unter Schutzkasten', ''),
('2552', 'Marke (allgemein) unter Schutzkasten', ''),
('2553', 'Platte unter Schutzkasten', ''),
('2560', 'Rohr mit Verschlusskappe und aufgesetztem Lochstein', ''),
('2600', 'Alte Festlegung in Bayern, exz.', ''),
('2601', 'Gebohrter Granitstein (Bezugspunkt) über Tonrohr', ''),
('2602', 'Gebohrter Granitstein über Tonrohr (Bezugspunkt)', ''),
('2603', 'Gebohrter Granitstein (Bezugspunkt) über Platte', ''),
('2604', 'Gebohrter Granitstein über Platte (Bezugspunkt)', ''),
('2605', 'Gebohrter Granitstein (Bezugspunkt) über Eisenrohr', ''),
('2606', 'Gebohrter Granitstein über Eisenrohr (Bezugspunkt)', ''),
('2607', 'Betonstein (Bezugspunkt) über Platte', ''),
('2608', 'Betonstein über Platte (Bezugspunkt)', ''),
('2609', 'Betonstein mit durchgehendem Bohrloch (Einschaltpunkt-Stein in Bayern)', ''),
('2610', 'Alte Festlegung in Bayern', ''),
('2611', 'KT-Stein der österreichischen Katastraltriangulation', ''),
('2612', 'Stein (Bezugspunkt) über Platte', ''),
('2613', 'Stein über Platte (Bezugspunkt)', ''),
('2614', 'Stein (Bezugspunkt) über Tonrohr', ''),
('2615', 'Stein über Tonrohr (Bezugspunkt)', ''),
('2616', 'Stein mit Eisenrohr', ''),
('2620', 'Alte Festlegung in Sachsen-Coburg, 3.O.', ''),
('2630', 'Alte Festlegung in Sachsen-Coburg, 4.O.', ''),
('2640', 'Alte Festlegung in Bayern und der Pfalz, HDNP-Stein', ''),
('2700', 'Festlegung MP-Pfeiler', ''),
('2710', 'Festlegung Orientierungspunkt, Bezugspunkt Platte', ''),
('2750', 'Steinpfeiler', ''),
('2760', 'Betonpfeiler', ''),
('2770', 'Kreuz (gemeisselt)', ''),
('2800', 'Knopf', ''),
('2810', 'Mitte', ''),
('2820', 'Spitze', ''),
('2830', 'Kreuz (Mitte)', ''),
('2840', 'Helmstange', ''),
('2850', 'Fahnenstange', ''),
('2860', 'Wetterstange', ''),
('2870', 'Blitzableiter', ''),
('2880', 'Antenne', ''),
('2890', 'Rohrstange', ''),
('2900', 'Platte, unterirdisch', ''),
('2901', 'Platte einbetoniert mit zentrischem Messingbolzen', ''),
('2902', 'Platte einbetoniert mit zentrischem Bohrloch', ''),
('2903', 'Platte einbetoniert mit zentrischer Keramikmarke', ''),
('2904', 'Platte einbetoniert mit zentrischer Messingmarke', ''),
('2910', 'Steinwürfel, unterirdisch', ''),
('2920', 'Steinplatte, unterirdisch', ''),
('2930', 'Platte, unterirdisch, 60x60 cm', ''),
('2940', 'Platte, unterirdisch, 30x30 cm', ''),
('2950', 'Platte, unterirdisch, mit Stehniet', ''),
('2951', 'Platte, unterirdisch, mit Kopfbolzen', ''),
('2960', 'Platte, unterirdisch, mit Schutzrohr', ''),
('2970', 'Pfeiler 30x30x90 cm, mit Stehniete', ''),
('2980', 'Platte, mit Bolzen, unterirdisch, im Schacht', ''),
('3000', 'Unterirdische Festlegung', ''),
('3011', 'Unterirdische Festlegung mit Achatkugel', ''),
('3012', 'Unterirdische Festlegung mit Halbkugel', ''),
('3013', 'Unterirdische Festlegung mit Diabaseinsatz', ''),
('3014', 'Unterirdische Festlegung im Schacht', ''),
('3015', 'Kleine unterirdische Festlegung', ''),
('3020', 'Unterirdischer Rammpfahl', ''),
('3030', 'Unterirdischer Pfeilerbolzen', ''),
('3040', 'Unterirdischer Bolzen', ''),
('3050', 'Hamburger Flachpunkt', ''),
('3060', 'Unterirdische Säule', ''),
('3070', 'Unterirdischer Rammstab', ''),
('3100', 'Rohrfestpunkt', ''),
('3110', 'Rohrfestpunkt, Hamburger Bauart', ''),
('3120', 'Rohrfestpunkt, Oldenburger Bauart', ''),
('3130', 'Rohrfestpunkt, Eider Bauart', ''),
('3140', 'Rohrfestpunkt Nordrhein-Westfalen', ''),
('3150', 'Rohrfestpunkt Nebenpunkt, flach gegründet', ''),
('3160', 'Rohrfestpunkt, Celler Bauart', ''),
('3200', 'Mauerbolzen', ''),
('3210', 'Mauerbolzen, horizontal eingebracht', ''),
('3220', 'Mauerbolzen, vertikal eingebracht', ''),
('3230', 'Höhenmarke', ''),
('3231', 'Höhenmarke (Königlich Preußische Landesaufnahme)', ''),
('3232', 'Höhenmarke (Königlich Sächsische Landesaufnahme)', ''),
('3233', 'Höhenmarke (Reichsamt für Landesaufnahme)', ''),
('3240', 'Kugelbolzen', ''),
('3250', 'Tonnenbolzen', ''),
('3260', 'Landeshöhenbolzen', ''),
('3270', 'Stehbolzen bzw. Bolzen vertikal', ''),
('3280', 'Stehniete', ''),
('3290', 'sonstiger horizontaler Bolzen', ''),
('3300', 'Pfeilerbolzen', ''),
('3301', 'Pfeilerbolzen, Bezugspunkt Pfeileroberfläche', ''),
('3310', 'Pfeilerbolzen, Naturstein, Bolzen horizontal', ''),
('3311', 'Pfeilerbolzen, Naturstein, Bolzen horizontal, Bezugspunkt Pfeileroberfläche', ''),
('3320', 'Pfeilerbolzen, Naturstein, Bolzen vertikal', ''),
('3330', 'Pfeilerbolzen, Beton, Bolzen, horizontal', ''),
('3331', 'Pfeilerbolzen, Beton, Bolzen horizontal, Bezugspunkt Pfeileroberfläche', ''),
('3340', 'Pfeilerbolzen, Beton, Bolzen vertikal', ''),
('3350', 'Pfeilerniete, Naturstein, Niete vertikal', ''),
('3400', 'Rammpfahl', ''),
('3410', 'Rammpfahl, Bolzen horizontal', ''),
('3420', 'Rammpfahl, Bolzen vertikal', ''),
('3810', 'Schraubpfahl', ''),
('3820', 'Hektometerstein', ''),
('3830', 'Markstein', ''),
('3840', 'Schraubbolzen', ''),
('3845', 'Schraubeisen', ''),
('3850', 'Lochmarke/-bolzen (ohne Höhentafel)', ''),
('3860', 'Lochmarke/-bolzen mit Höhentafel', ''),
('3870', 'Festpunktstein', ''),
('3880', 'Eichpfahl', ''),
('4100', 'Gravimeterplatte 80 x 80 oder 60 x 60 cm', ''),
('4110', 'Gravimeternagel', ''),
('4120', 'Gravimeterpfeiler 20 x 20 x 100 cm', ''),
('4130', 'Gravimeterpfeiler 16 x 16 x 60 cm', ''),
('4140', 'Messingscheibe mit zentrischer Wölbung (Durchm. 8 cm)', ''),
('4150', 'Stehniete, Messing (Durchmesser 3 cm, Aufschrift SFP)', ''),
('4160', 'Messplakette, Aufschrift', ''),
('5100', 'Gewindebolzen (höchste Stelle, Mitte) auf Metallplatte (Betonpfeiler mit Fundament im festen Erdboden)', ''),
('5150', 'Oberfläche der Metallplatte (höchste Stelle, Mitte) (Betonpfeiler mit Fundament im festen Erdboden)', ''),
('5200', 'Gewindebolzen (höchste Stelle, Mitte) auf Metallplatte (Gemauerter Pfeiler auf einem Bauwerk)', ''),
('5250', 'Oberfläche der Metallplatte (höchste Stelle, Mitte) (Gemauerter Pfeiler auf einem Bauwerk)', ''),
('5300', 'Gewindebolzen (höchste Stelle, Mitte) auf Metallplatte (Stahlpfeiler auf einem Bauwerk)', ''),
('5350', 'Oberfläche der Metallplatte (höchste Stelle, Mitte) (Stahlpfeiler auf einem Bauwerk)', ''),
('5400', 'Gewindebolzen (höchste Stelle, Mitte) auf Metallplatte (Seitlich befestigtes Stahlrohr am Bauwerk)', ''),
('5450', 'Oberfläche der Metallplatte (höchste Stelle, Mitte) (Seitlich befestigtes Stahlrohr am Bauwerk)', ''),
('5500', 'Gewindebolzen (höchste Stelle, Mitte) auf Metallplatte (Antennenträger)', ''),
('5550', 'Oberfläche der Metallplatte (höchste Stelle, Mitte) (Antennenträger)', ''),
('5900', 'GNSS-Antennenhalterung, Oberfläche Platte (Loch) (SL)', ''),
('9000', 'Marke unter Bemerkung näher definiert', ''),
('9500', 'Ohne Marke', ''),
('9600', 'Abmarkung zeitweilig ausgesetzt', ''),
('9998', 'Nach Quellenlage nicht zu spezifizieren', ''),
('9999', 'Sonstiges', '');
CREATE TABLE ax_horizontfreiheit_netzpunkt (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_horizontfreiheit_netzpunkt IS 'Alias: "AX_Horizontfreiheit_Netzpunkt", UML-Typ: Enumeration';
INSERT INTO ax_horizontfreiheit_netzpunkt (wert,beschreibung,dokumentation) VALUES
('1000', 'Uneingeschränkt', ''),
('2000', 'Eingeschränkt', ''),
('3000', 'Nicht geeignet', '');
CREATE TABLE ax_blattart_historischesflurstueck (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_blattart_historischesflurstueck IS 'Alias: "AX_Blattart_HistorischesFlurstueck", UML-Typ: Enumeration';
INSERT INTO ax_blattart_historischesflurstueck (wert,beschreibung,dokumentation) VALUES
('1000', 'Grundbuchblatt', ''),
('2000', 'Katasterblatt', '');
CREATE TABLE ax_qualitaet_hauskoordinate (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_qualitaet_hauskoordinate IS 'Alias: "AX_Qualitaet_Hauskoordinate", UML-Typ: Enumeration';
INSERT INTO ax_qualitaet_hauskoordinate (wert,beschreibung,dokumentation) VALUES
('1000', 'AmtlichMit (A)', 'Amtliche Hausnummer, Koordinate liegt sicher innerhalb der erfassten Gebäudegeometrie.'),
('2000', 'Amtlich (B)', 'Amtliche Hausnummer, Koordinate liegt sicher innerhalb der Flurstücksfläche, das Gebäude ist nicht sicher in der Örtlichkeit vorhanden.'),
('3000', 'Katasterintern (C)', 'Katasterinterne Hausnummer, die Koordinate liegt sicher innerhalb der erfassten Gebäudegeometrie.');
CREATE TABLE ax_art_punktkennung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_art_punktkennung IS 'Alias: "AX_Art_Punktkennung", UML-Typ: Enumeration';
INSERT INTO ax_art_punktkennung (wert,beschreibung,dokumentation) VALUES
('1000', 'Punktkennung - allgemein', ''),
('1100', 'Punktkennung - Grenzpunkt', ''),
('1200', 'Punktkennung - Besonderer Gebäudepunkt', ''),
('1300', 'Punktkennung - Besonderer topographischer Punkt', ''),
('1400', 'Punktkennung - Aufnahmepunkt', ''),
('1500', 'Punktkennung - Sicherungspunkt', ''),
('1600', 'Punktkennung - Sonstiger Vermessungspunkt', ''),
('1700', 'Punktkennung - Besonderer Bauwerkspunkt', '');
CREATE TABLE ax_art_reservierung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_art_reservierung IS 'Alias: "AX_Art_Reservierung", UML-Typ: Enumeration';
INSERT INTO ax_art_reservierung (wert,beschreibung,dokumentation) VALUES
('1000', 'Punktkennung', ''),
('1300', 'Punktkennung - Grenzpunkt', ''),
('1400', 'Punktkennung - Besonderer Gebäudepunkt', ''),
('1500', 'Punktkennung - Besonderer topographischer Punkt', ''),
('1600', 'Punktkennung - Besonderer Bauwerkspunkt', ''),
('1700', 'Punktkennung - Aufnahmepunkt', ''),
('1800', 'Punktkennung - Sicherungspunkt', ''),
('1900', 'Punktkennung - Sonstiger Vermessungspunkt', ''),
('2000', 'Punktkennung - Lagefestpunkt', ''),
('2100', 'Punktkennung - Höhenfestpunkt', ''),
('2200', 'Punktkennung - Schwerefestpunkt', ''),
('2300', 'Punktkennung - Referenzstationspunkt', ''),
('3000', 'Flurstückskennzeichen', 'Eine Reservierung von Folgenummern zu einer Nummer darf sich nur auf aktuelle Flurstücke 11001 beziehen und nicht auf dauerhaft reservierte ausfallende Nummern, die keine aktuellen Flurstücke haben.'),
('4000', 'FN-Nummer', ''),
('5000', 'Abmarkungsprotokollnummer', ''),
('6000', 'Buchungsblattkennzeichen', ''),
('6100', 'Katasterblatt', ''),
('6200', 'Pseudoblatt', ''),
('6300', 'Erwerberblatt', ''),
('6400', 'Fiktives Blatt', '');
CREATE TABLE ax_art_adressat_auszug (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_art_adressat_auszug IS 'Alias: "AX_Art_Adressat_Auszug", UML-Typ: Enumeration';
INSERT INTO ax_art_adressat_auszug (wert,beschreibung,dokumentation) VALUES
('1000', 'Privat', ''),
('2000', 'Notar', ''),
('3000', 'Grundbuchamt', ''),
('4000', 'Finanzamt', ''),
('5000', 'Bauaufsichtsbehörde', ''),
('6000', 'Weitere Beteiligte', '');
CREATE TABLE ax_horizontfreiheit_grenzpunkt (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_horizontfreiheit_grenzpunkt IS 'Alias: "AX_Horizontfreiheit_Grenzpunkt", UML-Typ: Enumeration';
INSERT INTO ax_horizontfreiheit_grenzpunkt (wert,beschreibung,dokumentation) VALUES
('1000', 'Uneingeschränkt', ''),
('2000', 'Eingeschränkt', ''),
('3000', 'Nicht geeignet', '');
CREATE TABLE ax_bemerkungzurabmarkung_grenzpunkt (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_bemerkungzurabmarkung_grenzpunkt IS 'Alias: "AX_BemerkungZurAbmarkung_Grenzpunkt", UML-Typ: Enumeration';
INSERT INTO ax_bemerkungzurabmarkung_grenzpunkt (wert,beschreibung,dokumentation) VALUES
('1000', 'Abmarkung unterirdisch gesichert', ''),
('2000', 'Abmarkung exzentrisch gesichert', ''),
('3000', 'Abmarkung unterirdisch und exzentrisch gesichert', ''),
('4000', 'Ohne unterirdische oder exzentrische Sicherung', '');
CREATE TABLE ax_gruendederausgesetztenabmarkung_grenzpunkt (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_gruendederausgesetztenabmarkung_grenzpunkt IS 'Alias: "AX_GruendeDerAusgesetztenAbmarkung_Grenzpunkt", UML-Typ: Enumeration';
INSERT INTO ax_gruendederausgesetztenabmarkung_grenzpunkt (wert,beschreibung,dokumentation) VALUES
('1000', 'Grenzpunkt durch bauliche Anlage ausreichend gekennzeichnet', ''),
('2000', 'Grenzpunkt liegt innerhalb einer baulichen Anlage', ''),
('3000', 'Grenzpunkt in öffentlich-rechtlichem Bodenordnungsverfahren', ''),
('4000', 'Grenzpunkt liegt innerhalb eines Baugebietes', ''),
('5000', 'Grenzpunkt liegt innerhalb oder an einem Gewässer', ''),
('6000', 'Keine Abmarkung aufgrund von anderweitigen Hindernissen', ''),
('7000', 'Abmarkung würde unzumutbare Schäden verursachen', ''),
('8000', 'Langfristige gemeinschaftliche Nutzung der angrenzenden Flurstücke', ''),
('9000', 'Angrenzende Flurstücke dienen dem Gemeingebrauch', ''),
('9999', 'Sonstiges', '');
CREATE TABLE ax_artderflurstuecksgrenze_besondereflurstuecksgrenze (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_artderflurstuecksgrenze_besondereflurstuecksgrenze IS 'Alias: "AX_ArtDerFlurstuecksgrenze_BesondereFlurstuecksgrenze", UML-Typ: Enumeration';
INSERT INTO ax_artderflurstuecksgrenze_besondereflurstuecksgrenze (wert,beschreibung,dokumentation) VALUES
('1000', 'Strittige Grenze', ''),
('2001', 'Nicht festgestellte Grenze', ''),
('2002', 'Verwaltungsstreitverfahren (Grenze)', ''),
('2003', 'Mittellinie in Gewässern', ''),
('2004', 'Flurstücksgrenze nicht feststellbar', 'Eine "nicht feststellbare Flurstücksgrenze" ist eine bisher nicht festgestellte Flurstücksgrenze, die nach den Daten des Liegenschaftskatasters nicht mit einer für die Grenzfeststellung erforderlichen Genauigkeit und Zuverlässigkeit in die Örtlichkeit übertragen werden kann und für die ein öffentlich-rechtlicher Grenzfeststellungsvertrag zwischen den Eigentümern mangels (positiver) Einigung nicht zustande kommt. Die fehlende Einigung bedeutet nicht zwangsläufig, dass sich die jeweiligen Eigentümer zivilrechtlich streiten.'),
('2010', 'Topographische Grenzeinrichtung', ''),
('2100', 'Topographische Gewässerbegrenzung', ''),
('2500', 'Grenze der Region', ''),
('3000', 'Grenze der Flur', ''),
('7003', 'Grenze der Gemarkung', ''),
('7101', 'Grenze der Bundesrepublik Deutschland', ''),
('7102', 'Grenze des Bundeslandes', ''),
('7103', 'Grenze des Regierungsbezirks', ''),
('7104', 'Grenze des Landkreises', ''),
('7106', 'Grenze der Gemeinde', ''),
('7107', 'Grenze des Gemeindeteils', ''),
('7108', 'Grenze der Verwaltungsgemeinschaft', '');
CREATE TABLE ax_datenerhebung_schwere (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_datenerhebung_schwere IS 'Alias: "AX_Datenerhebung_Schwere", UML-Typ: Enumeration';
INSERT INTO ax_datenerhebung_schwere (wert,beschreibung,dokumentation) VALUES
('0800', 'Mittels zentrisch gemessenem vertikalen Schweregradienten auf die Vermarkung abgeleitet', ''),
('0900', 'Mittels exzentrisch gemessenem vertikalen Schweregradienten abgeleitet', ''),
('1000', 'Mittels Freiluftreduktion über geringe Entfernung abgeleitet', 'Höhenunterschied bis 1 m, Horizontalabstand bis 5 m'),
('2000', 'Mittels Freiluftreduktion über größere Entfernung abgeleitet', ''),
('3000', 'Mittels Interpolation unter Verwendung einfacher Bougueranomalien ermittelt', 'Topografische Reduktion erfolgt nur als Plattenreduktion'),
('3050', 'Mittels Interpolation unter Verwendung verfeinerter Bougueranomalien ermittelt', 'Topografische Reduktion erfolgt als Platten- und Geländereduktion'),
('3100', 'Durch Abschlag (-19*10^-8m*s^-2) aus Schwerewert im DHSN82 ermittelt', ''),
('3200', 'Durch Transformation aus ISGN71 ermittelt', ''),
('4000', 'Durch andere Methode ermittelt', ''),
('9998', 'Methode unbekannt', '');
CREATE TABLE ax_genauigkeitsstufe_punktort (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_genauigkeitsstufe_punktort IS 'Alias: "AX_Genauigkeitsstufe_Punktort", UML-Typ: Enumeration';
INSERT INTO ax_genauigkeitsstufe_punktort (wert,beschreibung,dokumentation) VALUES
('0900', 'Standardabweichung S kleiner 1 mm', ''),
('1000', 'Standardabweichung S kleiner gleich 2 mm', ''),
('1100', 'Standardabweichung S kleiner gleich 5 mm', ''),
('1200', 'Standardabweichung S kleiner gleich 1 cm', ''),
('1300', 'Standardabweichung S kleiner gleich 1,5 cm', ''),
('2000', 'Standardabweichung S kleiner gleich 2 cm', ''),
('2050', 'Standardabweichung S kleiner gleich 2,5 cm', ''),
('2100', 'Standardabweichung S kleiner gleich 3 cm', ''),
('2200', 'Standardabweichung S kleiner gleich 6 cm', ''),
('2300', 'Standardabweichung S kleiner gleich 10 cm', ''),
('2400', 'Standardabweichung S kleiner gleich 20 cm', ''),
('3000', 'Standardabweichung S kleiner gleich 30 cm', ''),
('3100', 'Standardabweichung S kleiner gleich 60 cm', ''),
('3200', 'Standardabweichung S kleiner gleich 100 cm', ''),
('3300', 'Standardabweichung S kleiner gleich 500 cm', ''),
('5000', 'Standardabweichung S größer 500 cm', '');
CREATE TABLE ax_schwereanomalie_schwere_art (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_schwereanomalie_schwere_art IS 'Alias: "AX_Schwereanomalie_Schwere_Art", UML-Typ: Enumeration';
INSERT INTO ax_schwereanomalie_schwere_art (wert,beschreibung,dokumentation) VALUES
('1000', 'Geländereduktion', 'Teil der topografischen Reduktion, der die Abweichung der Erdoberfläche von einer horizontalen Platte oder sphärischen Figur berücksichtigt.'),
('2000', 'Freiluftanomalie', 'Differenz zwischen dem mittels Freiluftreduktion auf das Geoid reduzierten Schwerewert und dem entsprechenden Wert der Normalschwere auf dem Niveauellipsoid.'),
('3000', 'Faye-Anomalie', 'Freiluftanomalie mit zusätzlich angebrachter Geländereduktion'),
('3100', 'Schwereanomalie nach Molodenski', 'Schwere im Oberflächenpunkt minus Normalschwere im zugeordneten Telluroidpunkt'),
('4000', 'Verfeinerte Bougueranomalie', 'Topografische Reduktion erfolgt als Plattenreduktion und Geländereduktion'),
('5000', 'Einfache Bougueranomalie', 'Topografische Reduktion erfolgt nur als Plattenreduktion'),
('6000', 'Bougueranomalie im DHSN96 mit Freiluft- und Plattenreduktion', 'Normalschwere im GRS80'),
('9998', 'Unbekannt', '');
CREATE TABLE ax_datenerhebung_punktort (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_datenerhebung_punktort IS 'Alias: "AX_Datenerhebung_Punktort", UML-Typ: Enumeration';
INSERT INTO ax_datenerhebung_punktort (wert,beschreibung,dokumentation) VALUES
('0100', 'Aus GNSS-Messung', ''),
('0110', 'Aus langzeitstatischer GNSS-Messung', ''),
('0120', 'Aus statischer GNSS-Messung', ''),
('0130', 'Aus Echtzeit-GNSS-Messung', ''),
('0200', 'Aus trigonometrischer Messung im TP-Netz', ''),
('0210', 'Aus lokaler trigonometrischer Messung (innerhalb einer Punktgruppe)', ''),
('0220', 'Aus netzweiser terrestrischer Messung', ''),
('1000', 'Aus Katastervermessung ermittelt', ''),
('1010', 'Aus Katastervermessung mit höchster Lagegenauigkeit (NW)', ''),
('1020', 'Aus Katastervermessung mit hoher Lagegenauigkeit (NW)', ''),
('1030', 'Aus Katastervermessung mit mittlerer Lagegenauigkeit (NW)', ''),
('1040', 'Aus Katastervermessung mit unzureichender Lagegenauigkeit (NW)', ''),
('1050', 'Aus Ausgleichung des Katasterzahlenwerks ermittelt', 'Aus Beobachtungen des vorliegenden Katasterzahlenwerks werden in einem Ausgleichungsverfahren überbestimmte Koordinaten ermittelt, über die Informationen zur Genauigkeit und Zuverlässigkeit vorliegen.'),
('1060', 'Aus Vermessung mit höchster Positionsgenauigkeit', ''),
('1070', 'Aus Vermessung mit mittlerer Positionsgenauigkeit', ''),
('1080', 'Aus Vermessung mit unterer Positionsgenauigkeit', ''),
('1100', 'Aufgrund Anforderungen mit Netzanschluss ermittelt', ''),
('1200', 'Aufgrund Anforderungen mit Bezug zur Flurstücksgrenze ermittelt', ''),
('1300', 'Aufgrund Anforderungen des LiegVermErlasses ermittelt (NI)', ''),
('1400', 'Aufgrund Anforderungen des Fortführungerlasses II ermittelt (NI)', ''),
('1500', 'Aufgrund Anforderungen älterer Vorschriften ermittelt', ''),
('1600', 'Auf einheitlichem und eindeutigem Raumbezug basierend (E-Koord.) (BW)', ''),
('1610', 'Auf bislang einheitlichem Raumbezug basierend ermittelt (B-Koord.) (BW)', ''),
('1620', 'Auf früher gültigem Raumbezug basierend ermittelt(T-Koord.) (BW)', ''),
('1630', 'Aufgrund Anforderungen des AP-Erlasses (M-V)', ''),
('1640', 'Aufgrund Anforderungen der LiVermA M-V, basierend auf AP-Feld', ''),
('1650', 'Aufgrund Anforderungen der LiVermA M-V', ''),
('1700', 'Aufgrund Anforderungen des LiegVermErlasses LSA (LSA)', ''),
('1710', 'Aufgrund Anforderungen der Anleitung für die Ausführung von Neuvermessungen, 1953, DDR (LSA)', ''),
('1720', 'Aufgrund Anforderungen der Liegenschaftsvermessungsordnung 112/82, DDR (LSA)', ''),
('1800', 'Aus Koordinatentransformation ermittelt', ''),
('1900', 'Aus sonstiger Vermessung ermittelt', ''),
('2000', 'Aus Luftbildmessung oder Fernerkundungsdaten ermittelt', ''),
('3000', 'Aus Netzvermessung ermittelt', ''),
('3100', 'Aufgrund Anforderungen des Festpunktfelderlasses ermittelt (NI, ST)', ''),
('3200', 'Aufgrund Anforderungen des Polygonpunktfelderlasses ermittelt (NI)', ''),
('3300', 'Aus Polygonierungsmessung', ''),
('4000', 'Aus Katasterunterlagen und Karten für graphische Zwecke ermittelt', ''),
('4100', 'Aus Katasterzahlen für graphische Zwecke ermittelt', ''),
('4200', 'Aus Katasterkarten digitalisiert', ''),
('4210', 'Aus Katasterkarten digitalisiert, Kartenmaßstab M größer gleich 1 zu 1000', ''),
('4220', 'Aus Katasterkarten digitalisiert, Kartenmaßstab 1 zu 1000 größer M größer gleich 1 zu 2000', ''),
('4230', 'Aus Katasterkarten digitalisiert, Kartenmaßstab 1 zu 2000 größer M größer gleich 1 zu 3000', ''),
('4240', 'Aus Katasterkarten digitalisiert, Kartenmaßstab 1 zu 3000 größer M größer gleich 1 zu 5000', ''),
('4250', 'Aus Katasterkarten digitalisiert, Kartenmaßstab 1 zu 5000 größer M', ''),
('4260', 'Mit sonstigen geometrischen Bedingungen und/oder Homogenisierung (M größer gleich 1 zu 1000)', ''),
('4270', 'Mit Berechnung oder Abstandsbedingung (M größer gleich 1 zu 1000)', ''),
('4280', 'Mit sonstigen geometrischen Bedingungen und/oder Homogenisierung (M kleiner 1 zu 1000)', ''),
('4290', 'Mit Berechnung oder Abstandsbedingungen (M kleiner 1 zu 1000)', ''),
('4300', 'Aus sonstigen Unterlagen digitalisiert', ''),
('4310', 'Aus sonstigen Unterlagen digitalisiert, Kartenmaßstab M größer gleich 1 zu 1000', ''),
('4320', 'Aus sonstigen Unterlagen digitalisiert, Kartenmaßstab 1 zu 1000 größer M größer gleich 1 zu 2000', ''),
('4330', 'Aus sonstigen Unterlagen digitalisiert, Kartenmaßstab 1 zu 2000 größer M größer gleich 1 zu 3000', ''),
('4340', 'Aus sonstigen Unterlagen digitalisiert, Kartenmaßstab 1 zu 3000 größer M größer gleich 1 zu 5000', ''),
('4350', 'Aus sonstigen Unterlagen digitalisiert, Kartenmaßstab 1 zu 5000 größer M', ''),
('4360', 'Aus sonstigen Unterlagen digitalisiert, Mit sonstigen geometrischen Bedingungen und/oder Homogenisierung (M größer gleich 1 zu 1000)', ''),
('4370', 'Aus sonstigen Unterlagen digitalisiert, Mit Berechnung oder Abstandsbedingung (M größer gleich 1 zu 1000)', ''),
('4380', 'Aus sonstigen Unterlagen digitalisiert, Mit sonstigen geometrischen Bedingungen und/oder Homogenisierung (M kleiner 1 zu 1000)', ''),
('4390', 'Aus sonstigen Unterlagen digitalisiert, Mit Berechnung oder Abstandsbedingungen (M kleiner 1 zu 1000)', ''),
('5000', 'Aus Nivellement', ''),
('5010', 'Aus geometrischem Nivellement', ''),
('5020', 'Aus trigonometrischer Höhenübertragung', ''),
('5030', 'Aus trigonometrischer Präzisionshöhenübertragung', ''),
('5100', 'Präzisionsnivellement', ''),
('5110', 'Präzisionsnivellement, Messgenauigkeit 1.Ordnung', ''),
('5120', 'Präzisionsnivellement, Messgenauigkeit 2.Ordnung', ''),
('5130', 'Präzisionsnivellement, Messgenauigkeit 3.Ordnung', ''),
('5140', 'Präzisionsnivellement, Messgenauigkeit 4.Ordnung', ''),
('5200', 'Präzisionsnivellement (nur eine Messungsrichtung)', ''),
('5500', 'Höhe aus Laserscannermessung', ''),
('6000', 'Aus satellitengeodätischer Messung und Addition einer Höhenanomalie', ''),
('6100', 'Mittels Höhenanomalie abgeleitet von gemessener ellipsoidischer Höhe', ''),
('6200', 'Mittels Höhenanomalie abgeleitet von gemessener Normalhöhe', ''),
('7000', 'Aus trigonometrischer Messung', ''),
('8000', 'Aus analoger Unterlage abgeleitet', ''),
('8100', 'Aus näherungsweiser Berechnung oder Transformation', ''),
('8200', 'Aus Stereo-Auswertung von Luftbildern', ''),
('8300', 'Graphisch bestimmt', ''),
('8310', 'Aus der Topographischen Karte 1 zu 10 000 abgegriffen', ''),
('8320', 'Aus der Topographischen Karte 1 zu 25 000 abgegriffen', ''),
('9998', 'Nach Quellenlage nicht zu spezifizieren', '');
CREATE TABLE ax_vertrauenswuerdigkeit_punktort (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_vertrauenswuerdigkeit_punktort IS 'Alias: "AX_Vertrauenswuerdigkeit_Punktort", UML-Typ: Enumeration';
INSERT INTO ax_vertrauenswuerdigkeit_punktort (wert,beschreibung,dokumentation) VALUES
('1100', 'Vertrauenswürdigkeitsstufe Ausgleichung', 'Vertrauenswürdigkeitsstufe Ausgleichung: Die Vertrauenswürdigkeit ist durch Ausgleichung und durch mathematisch-statistische Testverfahren festgestellt. Bei den örtlichen Vermessungen sind die Anschlusspunkte auf Identität überprüft.'),
('1200', 'Vertrauenswürdigkeitsstufe Berechnung', 'Vertrauenswürdigkeitsstufe Berechnung: Die Vertrauenswürdigkeit ist durch Berechnung überprüft. Bei den örtlichen Vermessungen sind die Anschlusspunkte auf Identität überprüft. Die Zuverlässigkeit ist durch Programm festgestellt bzw. ergibt sich durch die rechnerisch wirksam kontrollierte Ermittlung der Position (Doppelbestimmung).'),
('1300', 'Vertrauenswürdigkeitsstufe Bestimmungsverfahren', 'Vertrauenswürdigkeitsstufe Bestimmungsverfahren: Die Vertrauenswürdigkeit ist durch die Art der Bestimmung der Position überprüft. Bei den örtlichen Vermessungen sind die Anschlusspunkte auf Identität überprüft. Die Position ist durch wirksame Kontrollen überprüft.'),
('1400', 'Vertrauenswürdigkeitsstufe ohne Kontrollen', 'Vertrauenswürdigkeitsstufe ohne Kontrollen: Die Berechnung ist nicht überprüft.');
CREATE TABLE ax_genauigkeitsstufe_schwere (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_genauigkeitsstufe_schwere IS 'Alias: "AX_Genauigkeitsstufe_Schwere", UML-Typ: Enumeration';
INSERT INTO ax_genauigkeitsstufe_schwere (wert,beschreibung,dokumentation) VALUES
('0900', 'Standardabweichung S kleiner gleich 12 * 10^-8m*s^-2', ''),
('1000', 'Standardabweichung S kleiner 20*10^-8m*s^-2', ''),
('1500', 'Standardabweichung S kleiner gleich 50 * 10^-8m*s^-2', ''),
('2000', 'Standardabweichung S kleiner gleich 100*10^-8m*s^-2', ''),
('3000', 'Standardabweichung S größer 100*10^-8m*s^-2', ''),
('4000', 'Als Schwereanschlusspunkt ungeeignet', '');
CREATE TABLE ax_tauglichkeit_gcg (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_tauglichkeit_gcg IS 'Alias: "AX_Tauglichkeit_GCG", UML-Typ: Enumeration';
INSERT INTO ax_tauglichkeit_gcg (wert,beschreibung,dokumentation) VALUES
('1000', 'Gut geeignet', ''),
('2000', 'Bedingt geeignet', ''),
('5000', 'Ungeeignet', ''),
('9998', 'Nicht untersucht', '');
CREATE TABLE ax_li_processstep_punktort_description (
  wert character varying,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_li_processstep_punktort_description IS 'Alias: "AX_LI_ProcessStep_Punktort_Description", UML-Typ: Enumeration';
INSERT INTO ax_li_processstep_punktort_description (wert,beschreibung,dokumentation) VALUES
('Erhebung', NULL, 'Erhebung beschreibt im Attribut stepDateTime den Erfassungszeitpunkt (Zeitpunkt der Messung), z. B. für Position, Lage oder Höhe.'),
('Berechnung', NULL, 'Berechnung beschreibt im Attribut stepDateTime den Auswertezeitpunkt, z. B. von Position, Lage oder Höhe.');
CREATE TABLE ax_schwerestatus_schwere (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_schwerestatus_schwere IS 'Alias: "AX_Schwerestatus_Schwere", UML-Typ: Enumeration';
INSERT INTO ax_schwerestatus_schwere (wert,beschreibung,dokumentation) VALUES
('1000', 'Amtliche Schwere', 'Gültiger Wert in dem amtlichen Schwerebezugssystem.'),
('2000', 'Weitere gültige Schwere', 'Weiterer gültiger Wert in einem nicht-amtlichen Schwerebezugssystem.'),
('3000', 'Vorläufige Schwere', 'Vorläufige Schwere.'),
('4000', 'Zu keiner Zeit gültig gewesene Schwere', 'Zu keiner Zeit gültig gewesene Schwere.'),
('5000', 'Historische Schwere', 'Ein historischer, nicht mehr amtlicher oder gültiger Wert.'),
('5100', 'Schwere, die sich als fehlerhaft herausgestellt hat', 'Schwere, die sich als fehlerhaft herausgestellt hat.');
CREATE TABLE ax_messmethode_schwere (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_messmethode_schwere IS 'Alias: "AX_Messmethode_Schwere", UML-Typ: Enumeration';
INSERT INTO ax_messmethode_schwere (wert,beschreibung,dokumentation) VALUES
('1000', 'Absolutgravimetermessung', ''),
('2000', 'Relativgravimetermessung', '');
CREATE TABLE ax_koordinatenstatus_punktort (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_koordinatenstatus_punktort IS 'Alias: "AX_Koordinatenstatus_Punktort", UML-Typ: Enumeration';
INSERT INTO ax_koordinatenstatus_punktort (wert,beschreibung,dokumentation) VALUES
('1000', 'Amtliche Koordinaten bzw. amtliche Höhe', 'Gültiger Wert in dem amtlichen Bezugssystem.'),
('2000', 'Weitere gültige Koordinaten bzw. weitere gültige Höhe', 'Weiterer gültiger Wert in einem nicht-amtlichen Bezugssystem.'),
('3000', 'Vorläufige Koordinaten bzw. vorläufige Höhe', 'Vorläufige Koordinaten bzw. vorläufige Höhe.'),
('4000', 'Zu keiner Zeit gültig gewesene Koordinaten bzw. Höhe', 'Zu keiner Zeit gültig gewesene Koordinaten bzw. Höhe.'),
('5000', 'Historische (nicht mehr gültige) Koordinaten bzw. Höhe', 'Ein historischer, nicht mehr amtlicher oder gültiger Wert.'),
('5100', 'Koordinaten bzw. Höhe, die sich als fehlerhaft herausgestellt haben', 'Koordinaten bzw. Höhe, die sich als fehlerhaft herausgestellt haben.');
CREATE TABLE ax_vertrauenswuerdigkeit_schwere (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_vertrauenswuerdigkeit_schwere IS 'Alias: "AX_Vertrauenswuerdigkeit_Schwere", UML-Typ: Enumeration';
INSERT INTO ax_vertrauenswuerdigkeit_schwere (wert,beschreibung,dokumentation) VALUES
('1100', 'Ausgleichung', 'Die Identität der Anschlusspunkte ist überprüft. Die Zuverlässigkeitskriterien sind durch Ausgleichung und durch mathematisch-statistische Testverfahren festgestellt.'),
('1300', 'Ohne Ausgleichung kontrolliert', 'Die Zuverlässigkeitskriterien sind auf andere Weise (z. B. durch Vergleich von Schwereanomalien) festgestellt.'),
('1400', 'Unkontrolliert', 'Der Schwerewert ist nicht unabhängig überprüft.');
CREATE TABLE ax_lagezurerdoberflaeche_gebaeude (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_lagezurerdoberflaeche_gebaeude IS 'Alias: "AX_LageZurErdoberflaeche_Gebaeude", UML-Typ: Enumeration';
INSERT INTO ax_lagezurerdoberflaeche_gebaeude (wert,beschreibung,dokumentation) VALUES
('1200', 'Unter der Erdoberfläche', 'Unter der Erdoberfläche bedeutet, dass sich das Gebäude unter der Erdoberfläche befindet.'),
('1400', 'Aufgeständert', 'Aufgeständert bedeutet, dass ein Gebäude auf Stützen steht.'),
('1500', 'Beweglich, drehbar', 'Beweglich, drehbar bedeutet, dass ein Gebäude beweglich oder drehbar ist.');
CREATE TABLE ax_untererbezugspunkt (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_untererbezugspunkt IS 'Alias: "AX_UntererBezugspunkt", UML-Typ: Enumeration';
INSERT INTO ax_untererbezugspunkt (wert,beschreibung,dokumentation) VALUES
('1000', 'Hauseingang/ Eingangstür', 'Hauseingang/Eingangstür ist ein Eingang, der in ein Haus führt.'),
('2000', 'Mittlere Höhe Schnittpunkt mit Gelände', 'Mittlere Höhe Schnittpunkt mit Gelände ist der Mittelwert aller Schnittpunkte, die sich aus dem Schnitt der Kanten und dem Gelände ergeben.'),
('3000', 'Höchster Punkt Schnittpunkt mit Gelände', 'Höchster Punkt Schnittpunkt mit Gelände ist der am höchsten gelegene Punkt, der sich aus dem Schnitt einer Kante und Gelände ergibt.'),
('4000', 'Niedrigster Punkt Schnittpunkt mit Gelände', 'Niedrigster Punkt Schnittpunkt mit Gelände ist der am niedrigsten gelegene Punkt, der sich aus dem Schnitt einer Kante und Gelände ergibt.');
CREATE TABLE ax_nutzung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_nutzung IS 'Alias: "AX_Nutzung", UML-Typ: Enumeration';
INSERT INTO ax_nutzung (wert,beschreibung,dokumentation) VALUES
('1000', 'Zivil', 'Zivil wird für ein Gebäude verwendet, das privaten, öffentlichen oder religiösen Zwecken dient und nicht militärisch genutzt wird.'),
('1100', 'Privat', 'Privat bezeichnet ein Gebäude, das wohn- oder privatwirtschaftlichen Zwecken dient.'),
('1200', 'Öffentlich', 'Öffentlich bedeutet, dass in einem Gebäude Aufgaben der öffentlichen Hand wahrgenommen werden oder dass das Gebäude für die Nutzung durch die Allgemeinheit vorgesehen ist.'),
('1300', 'Religiös', 'Religiös bezeichnet ein Gebäude, das religiösen Zwecken dient.'),
('2000', 'Militärisch', 'Militärisch bedeutet, dass das Gebäude von Streitkräften genutzt wird.');
CREATE TABLE ax_dachform (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_dachform IS 'Alias: "AX_Dachform", UML-Typ: Enumeration';
INSERT INTO ax_dachform (wert,beschreibung,dokumentation) VALUES
('1000', 'Flachdach', 'Flachdächer sind Dächer, die keine oder nureine geringe Dachneigung bis zu 10° (17,6%) aufweisen.'),
('2100', 'Pultdach', 'Ein Pultdach ist ein Dach mit nur einer geneigten Dachfläche. Die untere Kante bildet die Dachtraufe, die obere den Dachfirst. Die Neigung des Pultdaches beträgt mindestens 10°.'),
('2200', 'Versetztes Pultdach', 'Ein versetztes Pultdach besteht aus zwei Pultdächern, deren Firste in der Höhe versetzt sind. Zwischen den Dachflächen entsteht immer eine Wandfläche.'),
('3100', 'Satteldach', 'Das Satteldach besteht aus zwei entgegengesetzt geneigten Dachflächen, die am Dachfirst aufeinander treffen.'),
('3200', 'Walmdach', 'Ein Walmdach hat nicht nur auf der Traufseite, sondern auch auf der Giebelseite geneigte Dachflächen, die als Walm bezeichnet werden. Ein vollständiger Walm ersetzt den Giebel und hat eine einheitliche Traufhöhe, das Dach hat also an allen vier Seiten Schrägen. In Abgrenzung zum Zeltdach besitzt ein Walmdach immer einen Dachfirst.'),
('3300', 'Krüppelwalmdach', 'Ein Walm, dessen Traufe oberhalb der Traufe des Hauptdaches liegt, bildet ein Krüppelwalmdach. Es bleibt ein trapezförmiger Restgiebel erhalten.'),
('3400', 'Mansardendach', 'Bei der Dachform Mansardendach sind die Dachflächen im unteren Bereich abgeknickt, so dass die untere Dachfläche über eine wesentlich steilere Neigung verfügt als die obere.'),
('3500', 'Zeltdach', 'Ein Zeltdach zeichnet sich durch mindestens drei gegeneinander geneigte Dachflächen aus, die in einer Spitze zusammenlaufen. Abgrenzung zum Turmdach: Neigung des Zeltdachs < 45°.'),
('3600', 'Kegeldach', 'Ein Kegeldach ist eine Dachform, die einem Kreiskegel entspricht.'),
('3700', 'Kuppeldach', 'Ein Kuppeldach beschreibt eine halbkugel- oder glockenförmige Dachform.'),
('3800', 'Sheddach', 'Ein Sheddach ist eine Dachform, bei der mehrere gleichartige pult- oder satteldachartige Dachaufbauten hintereinander angereiht werden.'),
('3900', 'Bogendach', 'Ein Bogendach besitzt eine Wölbung die kreis- oder elliptische Formen annehmen kann.'),
('4000', 'Turmdach', 'Ein Turmdach ist ein Zeltdach mit einer Neigung von mehr als 45°.'),
('5000', 'Mischform', 'Die Dachform Mischform setzt sich aus mehreren Standarddachformen zusammen, wobei keine Dachform überwiegt.'),
('9999', 'Sonstiges', 'Sonstiges Dach ist eine Dachform, die auch durch eine Zerlegung in Standarddachformen nicht modelliert werden kann.');
CREATE TABLE ax_art_gebaeudepunkt (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_art_gebaeudepunkt IS 'Alias: "AX_Art_Gebaeudepunkt", UML-Typ: Enumeration';
INSERT INTO ax_art_gebaeudepunkt (wert,beschreibung,dokumentation) VALUES
('1100', 'First', ''),
('1200', 'Traufe', ''),
('2100', 'Eingang', ''),
('2200', 'Lichtschacht', '');
CREATE TABLE ax_gebaeudefunktion (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_gebaeudefunktion IS 'Alias: "AX_Gebaeudefunktion", UML-Typ: Enumeration';
INSERT INTO ax_gebaeudefunktion (wert,beschreibung,dokumentation) VALUES
('1000', 'Wohngebäude', 'Wohngebäude ist ein Gebäude, das zum Wohnen genutzt wird.'),
('1010', 'Wohnhaus', 'Wohnhaus ist ein Gebäude, in dem Menschen ihren Wohnsitz haben.'),
('1020', 'Wohnheim', 'Wohnheim ist ein Gebäude, das nach seiner baulichen Anlage und Ausstattung zur Unterbringung von Studenten, Arbeitern u. a. bestimmt ist.'),
('1021', 'Kinderheim', 'Kinderheim ist ein Gebäude, welches zur Unterbringung und Betreuung von Kindern, die vorübergehend oder dauerhaft getrennt von ihren leiblichen Eltern oder sonstigen Erziehungsberechtigten leben, dient.'),
('1022', 'Seniorenheim', 'Seniorenheim ist ein Gebäude, welches zur Unterbringung, Betreuung und Pflege von Menschen dient.'),
('1023', 'Schwesternwohnheim', 'Schwesternwohnheim ist ein Gebäude, in dem Angehörige eines Ordens oder Pflegepersonal wohnen.'),
('1024', 'Studenten-, Schülerwohnheim', 'Studenten-, Schülerwohnheim ist ein Gebäude, in welchem Studenten bzw. Schüler wohnen.'),
('1025', 'Schullandheim', 'Schullandheim ist ein Gebäude in ländlicher Region, in dem sich Schulklassen jeweils für einige Tage zur Erholung und zum Unterricht aufhalten.'),
('1100', 'Gemischt genutztes Gebäude mit Wohnen', 'Gemischt genutztes Gebäude mit Wohnen ist ein Gebäude, in dem sowohl gewohnt wird, als auch Teile des Gebäudes zum Anbieten von Dienstleistungen, zur Durchführung von öffentlichen oder privaten Verwaltungsarbeiten, zur gewerblichen oder industriellen Tätigkeit genutzt werden.'),
('1110', 'Wohngebäude mit Gemeinbedarf', 'Wohngebäude mit Gemeinbedarf ist ein Gebäude, das vorrangig dem Wohnen als auch der Allgemeinheit, z. B. zur Versammlung, dient.'),
('1120', 'Wohngebäude mit Handel und Dienstleistungen', 'Wohngebäude mit Handel und Dienstleistungen ist ein Gebäude, das vorrangig dem Wohnen als auch dem Anbieten von Arbeitsleistungen, die nicht im Zusammenhang mit der Produktion von materiellen Gütern stehen, dient.'),
('1121', 'Wohn- und Verwaltungsgebäude', 'Wohn- und Verwaltungsgebäude ist ein Gebäude, in dem gewohnt wird und in dem sich Räume einer öffentlichen oder privaten Verwaltung befinden.'),
('1122', 'Wohn- und Bürogebäude', 'Wohn- und Bürogebäude ist ein Gebäude, in dem gewohnt wird und in dem sich Büros mehrerer Unternehmen befinden.'),
('1123', 'Wohn- und Geschäftsgebäude', 'Wohn- und Geschäftsgebäude ist ein Gebäude, in dem gewohnt wird und in dem sich ein oder mehrere Geschäfte befinden, in denen Waren zum Verkauf angeboten werden.'),
('1130', 'Wohngebäude mit Gewerbe und Industrie', 'Wohngebäude mit Gewerbe und Industrie ist ein Gebäude, das vorrangig dem Wohnen und dem Anbieten von gewerblichen oder industriellen Tätigkeiten dient.'),
('1131', 'Wohn- und Betriebsgebäude', 'Wohn- und Betriebsgebäude ist ein Gebäude, das sowohl zum Wohnen als auch zur Produktion von Gütern dient.'),
('1210', 'Land- und forstwirtschaftliches Wohngebäude', 'Land- und forstwirtschaftliches Wohngebäude ist ein Gebäude, in dem Beschäftigte der Land- und Forstwirtschaft wohnen.'),
('1220', 'Land- und forstwirtschaftliches Wohn- und Betriebsgebäude', 'Land- und forstwirtschaftliches Wohn- und Betriebsgebäude ist ein Gebäude, das zum Wohnen und zur Produktion von land- und forstwirtschaftlichen Gütern dient.'),
('1221', 'Bauernhaus', 'Bauernhaus ist das Wohn- und Betriebsgebäude eines Landwirts.'),
('1222', 'Wohn- und Wirtschaftsgebäude', 'Wohn- und Wirtschaftsgebäude ist ein Gebäude, in dem gewohnt wird und das zum Betrieb eines wirtschaftlichen Anwesens notwendig ist.'),
('1223', 'Forsthaus', 'Forsthaus ist ein Gebäude, das gleichzeitig Wohnhaus und Dienststelle der Försterin oder des Försters ist.'),
('1310', 'Gebäude zur Freizeitgestaltung', 'Gebäude zur Freizeitgestaltung ist ein Gebäude, das der Ausübung von freizeitlichen Aktivitäten dient.'),
('1311', 'Ferienhaus', 'Ferienhaus ist ein Gebäude, das zum vorübergehenden Aufenthalt von Gästen dient.'),
('1312', 'Wochenendhaus', 'Wochenendhaus ist ein Gebäude, in dem dauerhaftes Wohnen möglich, aber nicht gestattet ist. Es dient nur zum zeitlich begrenzten Aufenthalt in der Freizeit, beispielsweise am Wochenende oder im Urlaub und steht i. d. R. in einem besonders dafür ausgewiesenen Gebiet (Wochenendhausgebiet).'),
('1313', 'Gartenhaus', 'Gartenhaus ist ein eingeschossiges Gebäude in einfacher Ausführung und dient hauptsächlich der Unterbringung von Gartengeräten.'),
('2000', 'Gebäude für Wirtschaft oder Gewerbe', 'Gebäude für Wirtschaft oder Gewerbe ist ein Gebäude, das der Produktion von Waren, der Verteilung von Gütern und dem Angebot von Dienstleistungen dient.'),
('2010', 'Gebäude für Handel und Dienstleistungen', 'Gebäude für Handel und Dienstleistungen ist ein Gebäude, in dem Arbeitsleistungen, die nicht der Produktion von materiellen Gütern dienen, angeboten werden. Dazu gehört u. a. der Handel (Ankauf, Transport, Verkauf) mit Gütern, Kapital oder Wissen.'),
('2020', 'Bürogebäude', 'Bürogebäude ist ein Gebäude, in dem private Wirtschaftunternehmen ihre Verwaltungsarbeit durchführen.'),
('2030', 'Kreditinstitut', 'Kreditinstitut ist ein Gebäude, in dem Unternehmen gewerbsmäßig Geldgeschäfte (Verwaltung von Ersparnissen, Vergabe von Krediten) betreiben, die einen kaufmännisch eingerichteten Geschäftsbetrieb erfordern.'),
('2040', 'Versicherung', 'Versicherung ist ein Gebäude, in dem Versicherungsunternehmen gewerbsmäßige Versicherungsgeschäfte betreiben.'),
('2050', 'Geschäftsgebäude', 'Geschäftsgebäude ist ein Gebäude, in dem Ein- und Verkauf von Waren stattfindet.'),
('2051', 'Kaufhaus', 'Kaufhaus ist ein Gebäude, meist mit mehreren Stockwerken, in dem breite Warensortimente zum Kauf angeboten werden.'),
('2052', 'Einkaufszentrum', 'Einkaufszentrum ist ein Gebäude oder Gebäudekomplex, in dem mehrere Geschäfte untergebracht sind.'),
('2053', 'Markthalle', 'Markthalle ist ein Gebäude, in dem Marktstände fest oder vorübergehend aufgebaut sind.'),
('2054', 'Laden', 'Laden ist ein Geschäft, in dem Waren des Einzelhandels angeboten und verkauft werden.'),
('2055', 'Kiosk', 'Kiosk ist ein kleines in meist leichter Bauweise errichtetes Gebäude, das als Verkaufseinrichtung für ein beschränktes Warenangebot dient.'),
('2056', 'Apotheke', 'Apotheke ist ein Geschäft, in dem Arzneimittel hergestellt und verkauft werden.'),
('2060', 'Messehalle', 'Messehalle ist ein Gebäude, das zur Ausstellung von Kunstgegenständen oder Wirtschaftsgütern dient.'),
('2070', 'Gebäude für Beherbergung', 'Gebäude für Beherbergung ist ein Gebäude, das der Unterbringung von Gästen dient.'),
('2071', 'Hotel, Motel, Pension', 'Hotel, Motel, Pension ist ein Gebäude mit Beherbergungs- und/oder Verpflegungsbetrieb nach Service, Ausstattung und Qualität in verschiedene Kategorien eingeteilt. Das Motel ist besonders eingerichtet für Reisende mit Kraftfahrzeug an verkehrsreichen Straßen.'),
('2072', 'Jugendherberge', 'Jugendherberge ist eine zur Förderung von Jugendreisen dienende Aufenthalts- und Übernachtungsstätte.'),
('2073', 'Hütte (mit Übernachtungsmöglichkeit)', 'Hütte (mit Übernachtungsmöglichkeit) ist ein Gebäude außerhalb von Ortschaften, meist in den Bergen, in dem Menschen übernachten und Schutz suchen können.'),
('2074', 'Campingplatzgebäude', 'Campingplatzgebäude ist ein Gebäude auf einem angelegten Platz, z. B. mit Strom- und Wasseranschlüssen sowie sanitären Einrichtungen.'),
('2080', 'Gebäude für Bewirtung', 'Gebäude für Bewirtung ist ein Gebäude, in dem die Möglichkeit besteht Mahlzeiten und Getränke einzunehmen.'),
('2081', 'Gaststätte, Restaurant', 'Gaststätte, Restaurant ist ein Gebäude, in dem gegen Entgelt Mahlzeiten und Getränke zum Verzehr angeboten werden.'),
('2082', 'Hütte (ohne Übernachtungsmöglichkeit)', 'Hütte (ohne Übernachtungsmöglichkeit) ist ein Gebäude außerhalb von Ortschaften, meist in den Bergen, in dem Menschen Schutz suchen können und in dem die Möglichkeit besteht, Mahlzeiten und Getränke einzunehmen.'),
('2083', 'Kantine', 'Kantine ist ein Gebäude, das einem Unternehmen, einer Behörde oder einer öffentlichen Einrichtung zur Ausgabe von Mahlzeiten und Getränken dient.'),
('2090', 'Freizeit- und Vergnügungsstätte', 'Freizeit- und Vergnügungsstätte ist ein Gebäude, in dem man in seiner Freizeit bestimmte Angebote wahrnehmen kann.'),
('2091', 'Festsaal', 'Festsaal ist ein Gebäude, in dem Feierlichkeiten ausgerichtet werden.'),
('2092', 'Kino', 'Kino ist ein Gebäude, in dem Filme für ein Publikum abgespielt werden.'),
('2093', 'Kegel-, Bowlinghalle', 'Kegel-, Bowlinghalle ist ein Gebäude, in dem die Sportarten Kegeln oder Bowling ausgeübt werden.'),
('2094', 'Spielkasino', 'Spielkasino ist eine Einrichtung, in der öffentlich zugänglich staatlich konzessioniertes Glücksspiel betrieben wird.'),
('2095', 'Spielhalle', 'Spielhalle ist eine Einrichtung, in der durch die Spielverordnung geregeltes Automatenspiel betrieben wird.'),
('2100', 'Gebäude für Gewerbe und Industrie', 'Gebäude für Gewerbe und Industrie ist ein Gebäude, dass vorwiegend gewerblichen oder industriellen Zwecken dient.'),
('2110', 'Produktionsgebäude', 'Produktionsgebäude ist ein Gebäude, das zur Herstellung von Wirtschaftsgütern dient.'),
('2111', 'Fabrik', 'Fabrik ist ein Gebäude mit technischen Anlagen zur Herstellung von Waren in großen Mengen.'),
('2112', 'Betriebsgebäude', 'Betriebsgebäude ist ein Gebäude, in dem Arbeitskräfte und Produktionsmittel zusammengefasst sind, um Leistungen zu erbringen oder Güter herzustellen.'),
('2113', 'Brauerei', 'Brauerei ist ein Gebäude, in dem Getränke durch Gärung hergestellt werden.'),
('2114', 'Brennerei', 'Brennerei ist ein Gebäude, in dem alkoholische Getränke durch Destillation hergestellt werden.'),
('2120', 'Werkstatt', 'Werkstatt ist ein Gebäude, in dem mit Werkzeugen und Maschinen Güter hergestellt oder repariert werden.'),
('2121', 'Sägewerk', 'Sägewerk ist ein Gebäude, in dem Holz zugeschnitten wird.'),
('2130', 'Tankstelle', 'Tankstelle ist ein Gebäude, in dem hauptsächlich Kfz-Kraftstoffe, Schmiermittel und Zubehör verkauft werden, meist mit Einrichtungen zur Durchführung von Wartungs- und Pflegearbeiten von Kraftfahrzeugen.'),
('2131', 'Waschstraße, Waschanlage, Waschhalle', 'Waschstraße, Waschanlage, Waschhalle ist ein Gebäude, in dem Fahrzeuge gereinigt werden.'),
('2140', 'Gebäude für Vorratshaltung', 'Gebäude für Vorratshaltung ist ein Gebäude, in dem Güter vorübergehend gelagert werden.'),
('2141', 'Kühlhaus', 'Kühlhaus ist ein Gebäude, das zur Lagerung von Gütern mit niedriger Temperatur dient.'),
('2142', 'Speichergebäude', 'Speichergebäude ist ein Gebäude zur Vorratshaltung.'),
('2143', 'Lagerhalle, Lagerschuppen, Lagerhaus', 'Lagerhalle, Lagerschuppen, Lagerhaus ist ein Gebäude zur Vorratshaltung von Gütern (z. B. Material, Fertigerzeugnissen).'),
('2150', 'Speditionsgebäude', 'Speditionsgebäude bezeichnet ein Gebäude mit technischen, organisatorischen und wirtschaftlichen Einrichtungen, die der Beförderung von Gütern über räumliche Entfernungen dienen.'),
('2160', 'Gebäude für Forschungszwecke', 'Gebäude für Forschungszwecke ist ein Gebäude, in dem Forschung betrieben wird.'),
('2170', 'Gebäude für Grundstoffgewinnung', 'Gebäude zur Grundstoffgewinnung ist ein Gebäude zur Gewinnung von Grundstoffen (z.B. Erz oder Kohle).'),
('2171', 'Bergwerk', 'Bergwerk ist ein Gebäude zur Gewinnung von Rohstoffen aus der Erde.'),
('2172', 'Saline', 'Saline ist eine Anlage zur Gewinnung von Kochsalz.'),
('2180', 'Gebäude für betriebliche Sozialeinrichtung', 'Gebäude für betriebliche Sozialeinrichtung ist ein Gebäude, in dem Arbeitnehmern betriebliche Zusatzangebote gewährt werden (z. B. Kinderbetreuung, Betriebssport oder Beratung).'),
('2200', 'Sonstiges Gebäude für Gewerbe und Industrie', 'Sonstiges Gebäude für Gewerbe und Industrie ist ein Gebäude, das zum Anbieten von gewerblichen oder industriellen Tätigkeiten genutzt wird.'),
('2210', 'Mühle', 'Mühle ist ein Gebäude, das zum Mahlen, zum Sägen, zum Pumpen oder zur Erzeugung von Strom dient.'),
('2211', 'Windmühle', 'Windmühle ist ein Gebäude, dessen wesentlicher Bestandteil die an einer Achse befestigten Flächen (Flügel, Schaufeln) sind, die von der Windkraft in Drehung versetzt werden.'),
('2212', 'Wassermühle', 'Wassermühle ist ein Gebäude mit einem Mühlrad, das von Wasser angetrieben wird.'),
('2213', 'Schöpfwerk', 'Schöpfwerk ist ein Gebäude, in dem Pumpen Wasser einem höher gelegenen Vorfluter zuführen u. a. zur künstlichen Entwässerung von landwirtschaftlich genutzten Flächen und im Falle von Polder- und Mündungsschöpfwerken auch zur Sicherstellung des Hochwasser- oder Überschwemmungsschutzes.'),
('2220', 'Wetterstation', 'Wetterstation ist ein Gebäude, in dem meteorologische Daten erfasst und ausgewertet werden.'),
('2310', 'Gebäude für Handel und Dienstleistung mit Wohnen', 'Gebäude für Handel und Dienstleistungen mit Wohnen ist ein Gebäude, in dem Arbeitsleistungen, die nicht der Produktion von materiellen Gütern dienen, angeboten werden und in dem zusätzlich gewohnt wird.'),
('2320', 'Gebäude für Gewerbe und Industrie mit Wohnen', 'Gebäude für Gewerbe und Industrie mit Wohnen ist ein Gebäude, das zum Anbieten von gewerblichen oder industriellen Tätigkeiten genutzt und in dem zusätzlich gewohnt wird.'),
('2400', 'Betriebsgebäude zu Verkehrsanlagen (allgemein)', 'Betriebsgebäude zu Verkehrsanlagen (allgemein) ist ein Gebäude zur Aufrechterhaltung, Instandhaltung oder Überwachung von Verkehrsanlagen.'),
('2410', 'Betriebsgebäude für Straßenverkehr', 'Betriebsgebäude für Straßenverkehr ist ein Gebäude zur Aufrechterhaltung oder Instandhaltung des Straßenverkehrs.'),
('2411', 'Straßenmeisterei', 'Straßenmeisterei ist das Verwaltungsgebäude einer Dienststelle, die für den ordnungsgemäßen Zustand von Straßen verantwortlich ist.'),
('2412', 'Wartungshalle', 'Wartungshalle ist ein Gebäude zur Wartung oder Instandsetzung.'),
('2420', 'Betriebsgebäude für Schienenverkehr', 'Betriebsgebäude für Schienenverkehr ist ein Gebäude zur Aufrechterhaltung oder Instandhaltung des Schienenverkehrs.'),
('2421', 'Bahnwärterhaus', 'Bahnwärterhaus ist ein Gebäude, das als Dienstwohnung für Bahnwärter dient.'),
('2422', 'Lokschuppen, Wagenhalle', 'Lokschuppen, Wagenhalle ist ein Gebäude, das als Unterstellplatz für Schienenfahrzeuge dient.'),
('2423', 'Stellwerk, Blockstelle', 'Stellwerk, Blockstelle ist ein Gebäude, von dem aus die Signale und Weichen im Bahnhof und auf der freien Strecke für die Züge gestellt werden.'),
('2424', 'Betriebsgebäude des Güterbahnhofs', 'Betriebsgebäude des Güterbahnhofs ist ein Gebäude zur Aufrechterhaltung oder Überwachung des Güterzugverkehrs.'),
('2430', 'Betriebsgebäude für Flugverkehr', 'Betriebsgebäude für Flugverkehr ist ein Gebäude zur Aufrechterhaltung oder Überwachung des Flugverkehrs.'),
('2431', 'Flugzeughalle', 'Flugzeughalle ist ein Gebäude, in dem Flugzeuge abgestellt, inspiziert und repariert werden.'),
('2440', 'Betriebsgebäude für Schiffsverkehr', 'Betriebsgebäude für Schiffsverkehr ist ein Gebäude zur Aufrechterhaltung oder Überwachung des Schiffsverkehrs.'),
('2441', 'Werft (Halle)', 'Werft (Halle) ist ein Gebäude, in dem Schiffe gebaut und repariert werden.'),
('2442', 'Dock (Halle)', 'Dock (Halle) ist ein Gebäude, in dem Schiffe trockengelegt werden.'),
('2443', 'Betriebsgebäude zur Schleuse', 'Betriebsgebäude zur Schleuse ist ein Gebäude, in dem der Schleusenbetrieb gesteuert und überwacht wird.'),
('2444', 'Bootshaus', 'Bootshaus ist ein Gebäude, das als Unterstellplatz für kleinere Wasserfahrzeuge dient.'),
('2450', 'Betriebsgebäude zur Seilbahn', 'Betriebsgebäude zur Seilbahn ist ein Gebäude, in dem der Seilbahnbetrieb gesteuert und überwacht wird.'),
('2451', 'Spannwerk zur Drahtseilbahn', 'Spannwerk zur Drahtseilbahn ist ein Gebäude, in dem das Seil der Seilbahn gespannt und umgelenkt wird.'),
('2460', 'Gebäude zum Parken', 'Gebäude zum Parken ist ein Gebäude zum Abstellen von Fahrzeugen.'),
('2461', 'Parkhaus', 'Parkhaus ist ein Gebäude, in dem Fahrzeuge auf mehreren Etagen abgestellt werden.'),
('2462', 'Parkdeck', 'Parkdeck ist ein Gebäude, in dem Fahrzeuge auf einer Etage abgestellt werden.'),
('2463', 'Garage', 'Garage ist ein Gebäude, in dem Fahrzeuge abgestellt werden.'),
('2464', 'Fahrzeughalle', 'Fahrzeughalle ist ein Gebäude, in dem Fahrzeuge abgestellt, inspiziert und repariert werden.'),
('2465', 'Tiefgarage', 'Tiefgarage ist ein Bauwerk unter der Erdoberfläche, in dem Fahrzeuge abgestellt werden.'),
('2500', 'Gebäude zur Versorgung', 'Gebäude zur Versorgung ist ein Gebäude, das die Grundversorgung mit Wasser oder Energie sicherstellt.'),
('2501', 'Gebäude zur Energieversorgung', 'Gebäude zur Energieversorgung ist ein Gebäude, das die Grundversorgung mit Energie sicherstellt.'),
('2510', 'Gebäude zur Wasserversorgung', 'Gebäude zur Wasserversorgung ist ein Gebäude, das die Grundversorgung mit Wasser sicherstellt.'),
('2511', 'Wasserwerk', 'Wasserwerk ist ein Gebäude zur Aufbereitung und Bereitstellung von Trinkwasser.'),
('2512', 'Pumpstation', 'Pumpstation ist ein Gebäude an einem Rohrleitungssystem, in dem eine oder mehrere Pumpen zur Wasserversorgung eingebaut sind.'),
('2513', 'Wasserbehälter', 'Wasserbehälter ist ein Gebäude, in dem Wasser gespeichert wird, das zum Ausgleich der Differenz zwischen Wasserzuführung und -abgabe dient.'),
('2520', 'Gebäude zur Elektrizitätsversorgung', 'Gebäude zur Elektrizitätsversorgung ist ein Gebäude, in dem Elektrizität erzeugt oder übertragen wird.'),
('2521', 'Elektrizitätswerk', 'Elektrizitätswerk ist ein Gebäude, in dem Elektrizität erzeugt wird.'),
('2522', 'Umspannwerk', 'Umspannwerk ist ein Gebäude, in dem verschiedene Spannungsebenen des elektrischen Versorgungsnetzes miteinander verbunden werden.'),
('2523', 'Umformer', 'Umformer ist ein kleines Gebäude in dem ein Transformator zum Umformen von Gleichstrom in Wechselstrom oder von Gleichstrom in Gleichstrom anderer Spannung untergebracht ist.'),
('2527', 'Reaktorgebäude', 'Reaktorgebäude ist ein zentrales Gebäude eines Kernkraftwerkes, in dem aus radioaktivem Material mittels Kernspaltung Wärmeenergie erzeugt wird.'),
('2528', 'Turbinenhaus', 'Turbinenhaus ist ein Gebäude, in dem eine Kraftmaschine die Energie von strömendem Dampf, Gas, Wasser oder Wind unmittelbar in elektrische Energie umsetzt.'),
('2529', 'Kesselhaus', 'Kesselhaus ist ein Gebäude, in dem ein Dampfkessel mitsamt seiner Feuerung aufgestellt ist.'),
('2540', 'Gebäude für Fernmeldewesen', 'Gebäude für Fernmeldewesen ist ein Gebäude, in dem sich Einrichtungen zur Telekommunikation befinden.'),
('2560', 'Gebäude an unterirdischen Leitungen', 'Gebäude an unterirdischen Leitungen ist ein Gebäude, das zur Kontrolle von Versorgungsleitungen unter der Erde dient.'),
('2570', 'Gebäude zur Gasversorgung', 'Gebäude zur Gasversorgung ist ein Gebäude, in dem sich Gasanlagen befinden.'),
('2571', 'Gaswerk', 'Gaswerk ist ein Gebäude, in dem technische Gase hergestellt, gespeichert und bereitgestellt werden.'),
('2580', 'Heizwerk', 'Heizwerk ist ein Gebäude zur zentralen Erzeugung von Wärme (z.B. für Warmwasserversorgung).'),
('2590', 'Gebäude zur Versorgungsanlage', 'Gebäude zur Versorgungsanlage ist ein Gebäude, in dem sich Anlagen zur Unterstützung von Versorgungseinrichtungen befinden.'),
('2591', 'Pumpwerk (nicht für Wasserversorgung)', 'Pumpwerk (nicht für Wasserversorgung) ist ein Gebäude, in dem Wasser aus einem niedriger gelegenen Gewässer in ein höher gelegenes gepumpt wird.'),
('2600', 'Gebäude zur Entsorgung', 'Gebäude zur Entsorgung ist ein Gebäude zur Beseitigung von Abwässern oder Abfällen.'),
('2610', 'Gebäude zur Abwasserbeseitigung', 'Gebäude zur Abwasserbeseitigung ist ein Gebäude zur Reinigung von verschmutztem Wasser oder zur Entsorgung von Fäkalien.'),
('2611', 'Gebäude der Kläranlage', 'Gebäude der Kläranlage ist ein Gebäude innerhalb einer Kläranlage.'),
('2612', 'Toilette', 'Toilette ist eine Einrichtung mit sanitären Vorrichtungen zur Aufnahme von Körperausscheidungen.'),
('2620', 'Gebäude zur Abfallbehandlung', 'Gebäude zur Abfallbehandlung ist ein Gebäude zur Behandlung von Abfällen.'),
('2621', 'Müllbunker', 'Müllbunker ist ein Gebäude, in dem Müll gelagert wird.'),
('2622', 'Gebäude zur Müllverbrennung', 'Gebäude zur Müllverbrennung ist ein Gebäude in dem Abfälle mit chemisch/physikalischen und biologischen oder thermischen Verfahren oder Kombination dieser Verfahren behandelt werden.'),
('2623', 'Gebäude der Abfalldeponie', 'Gebäude der Abfalldeponie ist ein Gebäude auf einer Fläche, die zur endgültigen Lagerung von Abfällen genutzt wird.'),
('2700', 'Gebäude für Land- und Forstwirtschaft', 'Gebäude für Land- und Forstwirtschaft ist ein Gebäude, das land- und forstwirtschaftlichen Zwecken dient.'),
('2720', 'Land- und forstwirtschaftliches Betriebsgebäude', 'Land- und forstwirtschaftliches Betriebsgebäude ist ein Gebäude zur Produktion von land- und forstwirtschaftlichen Gütern.'),
('2721', 'Scheune', 'Scheune ist ein Gebäude zur Lagerung landwirtschaftlicher Güter (z. B. Stroh, Heu und Getreide).'),
('2723', 'Schuppen', 'Schuppen ist ein Gebäude in einfacher Ausführung, das als Abstellplatz oder als Lagerraum zur Unterbringung von Fahrzeugen, Geräten und Materialien der Land- und Forstwirtschaft verwendet wird.'),
('2724', 'Stall', 'Stall ist ein Gebäude, in dem Tiere untergebracht sind.'),
('2726', 'Scheune und Stall', 'Scheune und Stall ist ein Gebäude, in dem landwirtschaftliche Güter gelagert werden (z.B. Stroh, Heu oder Getreide) und in dem auch Tiere untergebracht sein können.'),
('2727', 'Stall für Tiergroßhaltung', 'Stall für Tiergroßhaltung ist ein Gebäude zur Unterbringung einer großen Anzahl von Tieren.'),
('2728', 'Reithalle', 'Reithalle ist ein Gebäude zum Ausüben des Reitsports.'),
('2729', 'Wirtschaftsgebäude', 'Wirtschaftsgebäude ist ein Gebäude, das zu wirtschaftlichen Zwecken dient (z.B. Lager- oder Produktionshallen).'),
('2732', 'Almhütte', 'Almhütte ist ein einfaches, hoch in den Bergen gelegenes Gebäude, das überwiegend weidewirtschaftlichen Zwecken dient und hauptsächlich im Sommer genutzt wird.'),
('2735', 'Jagdhaus, Jagdhütte', 'Jagdhaus, Jagdhütte ist ein Gebäude, das als Unterkunft bei der Jagd dient.'),
('2740', 'Treibhaus, Gewächshaus', 'Treibhaus, Gewächshaus ist ein Gebäude mit lichtdurchlässigem Dach und Wänden, das durch künstliche Klimagestaltung der Aufzucht oder Produktion von Pflanzen dient.'),
('2741', 'Treibhaus', 'Treibhaus ist ein Gebäude mit lichtdurchlässigem Dach und Wänden, das durch künstliche Klimagestaltung der Aufzucht oder Produktion von Pflanzen dient.'),
('2742', 'Gewächshaus, verschiebbar', 'Gewächshaus, verschiebbar ist ein Gebäude mit lichtdurchlässigem Dach und Wänden, das durch künstliche Klimagestaltung der Aufzucht oder Produktion von Pflanzen dient und dabei z. B. auf Schienen hin- und her bewegt werden kann.'),
('3000', 'Gebäude für öffentliche Zwecke', 'Gebäude für öffentliche Zwecke ist ein Gebäude das der Allgemeinheit dient.'),
('3010', 'Verwaltungsgebäude', 'Verwaltungsgebäude ist ein Gebäude, in dem Verwaltungstätigkeiten durchgeführt werden.'),
('3011', 'Parlament', 'Parlament ist ein Gebäude, in dem die gesetzgebende Volksvertretung (Bundestag, Landtag) tagt.'),
('3012', 'Rathaus', 'Rathaus ist ein Gebäude, in dem der Vorstand einer Gemeinde seinen Amtssitz hat und/oder Teile der Verwaltung untergebracht sind.'),
('3013', 'Post', 'Post ist ein Gebäude, in dem die Post Dienstleistungen anbietet.'),
('3014', 'Zollamt', 'Zollamt ist ein Gebäude für die Zollabfertigung an der Staatsgrenze (Grenzzollamt) oder im Inland (Binnenzollamt).'),
('3015', 'Gericht', 'Gericht ist ein Gebäude, in dem Rechtsprechung und Rechtspflege stattfinden.'),
('3016', 'Botschaft, Konsulat', 'Botschaft, Konsulat ist ein Gebäude, in dem eine ständige diplomatische Vertretung ersten Rangs eines fremden Staates oder einer internationalen Organisation untergebracht ist.'),
('3017', 'Kreisverwaltung', 'Kreisverwaltung ist ein Gebäude, in dem sich die Verwaltung eines Landkreises befindet.'),
('3018', 'Bezirksregierung', 'Bezirksregierung ist ein Gebäude, in dem sich die Regierung eines Bezirks befindet.'),
('3019', 'Finanzamt', 'Finanzamt ist ein Gebäude, in dem sich eine örtliche Behörde der Finanzverwaltung befindet.'),
('3020', 'Gebäude für Bildung und Forschung', 'Gebäude für Bildung und Forschung ist ein Gebäude, in dem durch Ausbildung Wissen und Können auf verschiedenen Gebieten vermittelt werden bzw. wo neues Wissen durch wissenschaftliche Tätigkeit gewonnen wird.'),
('3021', 'Allgemein bildende Schule', 'Allgemein bildende Schule ist ein Gebäude, in dem Kindern, Jugendlichen und Erwachsenen durch planmäßigen Unterricht Wissen vermittelt wird.'),
('3022', 'Berufsbildende Schule', 'Berufsbildende Schule ist ein Gebäude, in dem berufsbezogenes und fachgebundenes Wissen vermittelt wird.'),
('3023', 'Hochschulgebäude (Fachhochschule, Universität)', 'Hochschulgebäude (Fachhochschule, Universität) ist ein Gebäude, in dem Wissenschaften gelehrt und Forschung betrieben wird.'),
('3024', 'Forschungsinstitut', 'Forschungsinstitut ist ein Gebäude, in dem Forschung betrieben wird.'),
('3030', 'Gebäude für kulturelle Zwecke', 'Gebäude für kulturelle Zwecke ist ein Gebäude, in dem kulturelle Ereignisse stattfinden sowie ein Gebäude von kulturhistorischer Bedeutung.'),
('3031', 'Schloss', 'Schloss ist ein Gebäude, das als repräsentativer Wohnsitz vor allem des Adels dient oder diente.'),
('3032', 'Theater, Oper', 'Theater, Oper ist ein Gebäude, in dem Bühnenstücke aufgeführt werden.'),
('3033', 'Konzertgebäude', 'Konzertgebäude ist ein Gebäude, in dem Musikaufführungen stattfinden.'),
('3034', 'Museum', 'Museum ist ein Gebäude, in dem Sammlungen von (historischen) Objekten oder Reproduktionen davon ausgestellt werden.'),
('3035', 'Rundfunk, Fernsehen', 'Rundfunk-, Fernsehen ist ein Gebäude, in dem Radio- und Fernsehprogramme produziert und gesendet werden.'),
('3036', 'Veranstaltungsgebäude', 'Veranstaltungsgebäude ist ein Gebäude, das hauptsächlich für kulturelle Zwecke wie z. B. Aufführungen, Ausstellungen, Konzerte genutzt wird.'),
('3037', 'Bibliothek, Bücherei', 'Bibliothek, Bücherei ist ein Gebäude, in dem Bücher und Zeitschriften gesammelt, aufbewahrt und ausgeliehen werden.'),
('3038', 'Burg, Festung', 'Burg, Festung ist ein Gebäude innerhalb einer befestigten Anlage.'),
('3040', 'Gebäude für religiöse Zwecke', 'Gebäude für religiöse Zwecke ist ein Gebäude, das bei Gottesdiensten oder sonstigen religiösen Veranstaltungen als Versammlungsort dient.'),
('3041', 'Kirche', 'Kirche ist ein Gebäude, in dem sich Christen zu Gottesdiensten versammeln.'),
('3042', 'Synagoge', 'Synagoge ist ein Gebäude, in dem sich Personen jüdischen Glaubens zu Gottesdiensten, zum Schriftstudium und zur Unterweisung versammeln.'),
('3043', 'Kapelle', 'Kapelle ist ein kleines Gebäude (Gebets-, Tauf-, Grabkapelle) für (christliche) gottesdienstliche Zwecke.'),
('3044', 'Gemeindehaus', 'Gemeindehaus ist ein Gebäude, das Personen einer bestimmten Glaubensgemeinschaft zu verschiedenen Zwecken dient.'),
('3045', 'Gotteshaus', 'Gotteshaus ist ein Gebäude, in dem Gläubige einer nichtchristlichen Religionsgemeinschaft religiöse Handlungen vollziehen.'),
('3046', 'Moschee', 'Moschee ist ein Gebäude, in dem sich Personen muslimischen Glaubens zum Gebet versammeln und das als sozialer Treffpunkt dient.'),
('3047', 'Tempel', 'Tempel ist ein Gebäude, das Personen in der Ausübung ihrer Religion (z. B. Buddhisten, Hinduisten) als Versammlungsort dient.'),
('3048', 'Kloster', 'Kloster ist ein Gebäude, in dem Angehörige eines Ordens in einer auf die Ausübung ihrer Religion konzentrierten Lebensweise zusammenleben.'),
('3050', 'Gebäude für Gesundheitswesen', 'Gebäude für Gesundheitswesen ist ein Gebäude, das der ambulanten oder stationären Behandlung und Pflege von Patienten dient.'),
('3051', 'Krankenhaus', 'Krankenhaus ist ein Gebäude, in dem Kranke behandelt und/oder gepflegt werden.'),
('3052', 'Heilanstalt, Pflegeanstalt, Pflegestation', 'Heilanstalt, Pflegeanstalt, Pflegestation ist ein Gebäude, das einer länger andauernden Behandlung von Patienten dient.'),
('3053', 'Ärztehaus, Poliklinik', 'Ärztehaus, Poliklinik ist ein Gebäude, in dem mehrere Ärzte unterschiedlicher Fachrichtung Kranke ambulant behandeln und versorgen.'),
('3054', 'Rettungswache', 'Rettungswache ist ein Gebäude des Rettungsdienstes, in dem sich die Besatzungen der Rettungsdienstfahrzeuge in ihrer einsatzfreien Zeit aufhalten. Hier sind auch die Fahrzeuge und Geräte untergebracht.'),
('3060', 'Gebäude für soziale Zwecke', 'Gebäude für soziale Zwecke ist ein Gebäude, in dem ältere Menschen, Obdachlose, Jugendliche oder Kinder betreut werden.'),
('3061', 'Jugendfreizeitheim', 'Jugendfreizeitheim ist ein Gebäude der offenen Kinder- und Jugendarbeit.'),
('3062', 'Freizeit-, Vereinsheim, Dorfgemeinschafts-, Bürgerhaus', 'Freizeit-, Vereinsheim, Dorfgemeinschafts-, Bürgerhaus ist ein Gebäude zur gemeinschaftlichen Nutzung unterschiedlicher sozialer Gruppen.'),
('3063', 'Seniorenfreizeitstätte', 'Seniorenfreizeitstätte ist ein Gebäude zur Ausübung seniorengerechter Freizeitaktivitäten.'),
('3064', 'Obdachlosenheim', 'Obdachlosenheim ist ein Gebäude, in dem Obdachlose untergebracht sind und betreut werden.'),
('3065', 'Kinderkrippe, Kindergarten, Kindertagesstätte', 'Kinderkrippe, Kindergarten, Kindertagesstätte ist ein Gebäude, in dem Kinder im Vorschulalter betreut werden.'),
('3066', 'Asylbewerberheim', 'Asylbewerberheim ist ein Gebäude, in dem Asylbewerber ohne Aufenthaltsgenehmigung für Deutschland eine gewisse Zeit untergebracht sind.'),
('3070', 'Gebäude für Sicherheit und Ordnung', 'Gebäude für Sicherheit und Ordnung ist ein Gebäude, das für Personen und Gegenstände dient, die zur Verhütung oder Bekämpfung von Rechtsverletzungen und zum Katastrophenschutz eingesetzt werden, oder zur Unterbringung von Strafgefangenen.'),
('3071', 'Polizei', 'Polizei ist ein Gebäude für Polizeibedienstete, die in einem bestimmten Gebiet für Sicherheit und Ordnung zuständig sind.'),
('3072', 'Feuerwehr', 'Feuerwehr ist ein Gebäude der Feuerwehr, in dem Personen und Geräte zur Brandbekämpfung sowie zu anderen Hilfeleistungen untergebracht sind.'),
('3073', 'Kaserne', 'Kaserne ist ein Gebäude zur ortsfesten Unterbringung von Angehörigen der Bundeswehr und der Polizei sowie deren Ausrüstung.'),
('3074', 'Schutzbunker', 'Schutzbunker ist ein Gebäude zum Schutz der Zivilbevölkerung vor militärischen Angriffen.'),
('3075', 'Justizvollzugsanstalt', 'Justizvollzugsanstalt ist ein Gebäude zur Unterbringung von Untersuchungshäftlingen und Strafgefangenen.'),
('3080', 'Friedhofsgebäude', 'Friedhofsgebäude ist ein Gebäude, das zur Aufrechterhaltung des Friedhofbetriebes dient (z. B. Verwaltung, Leichenhalle, Krematorium).'),
('3081', 'Trauerhalle', 'Trauerhalle ist ein Gebäude, welches für Bestattungszeremonien bestimmt ist und zur kurzzeitigen Aufbewahrung von Toten dienen kann.'),
('3082', 'Krematorium', 'Krematorium ist ein Gebäude, in dem Feuerbestattungen durchgeführt werden.'),
('3090', 'Empfangsgebäude', 'Empfangsgebäude ist ein Gebäude mit Wartesaal, Fahrkarten- und Gepäckschalter zur Abwicklung des Straßen-, Schienen-, Seilbahn-, Luft- und Schiffsverkehrs.'),
('3091', 'Bahnhofsgebäude', 'Bahnhofsgebäude ist ein Gebäude u. a. mit Wartebereich und Fahrkartenausgabe zur Abwicklung des Bahnverkehrs.'),
('3092', 'Flughafengebäude', 'Flughafengebäude ist ein Gebäude u. a. mit Wartebereich, Flugticket- und Gepäckschalter zur Abwicklung des Flugverkehrs.'),
('3094', 'Gebäude zum U-Bahnhof', 'Gebäude zum U-Bahnhof ist ein Gebäude u. a. mit Wartebereich und Fahrkartenausgabe zur Abwicklung des U-Bahn-Verkehrs.'),
('3095', 'Gebäude zum S-Bahnhof', 'Gebäude zum S-Bahnhof ist ein Gebäude u. a. mit Wartebereich und Fahrkartenausgabe zur Abwicklung des S-Bahn-Verkehrs.'),
('3097', 'Gebäude zum Busbahnhof', 'Gebäude zum Busbahnhof ist ein Gebäude auf dem Busbahnhof, das zur Abwicklung des Busverkehrs dient.'),
('3098', 'Empfangsgebäude Schifffahrt', 'Empfangsgebäude Schifffahrt ist ein Gebäude u. a. mit Wartebereich, Fahrticket- und Gepäckschalter zur Abwicklung des Schiffsverkehrs.'),
('3100', 'Gebäude für öffentliche Zwecke mit Wohnen', 'Gebäude für öffentliche Zwecke mit Wohnen ist ein Gebäude, das der Allgemeinheit dient und auch zum Wohnen genutzt wird.'),
('3200', 'Gebäude für Erholungszwecke', 'Gebäude für Erholungszwecke ist ein Gebäude zur Freizeitgestaltung mit dem Ziel der Erhaltung und Wiederherstellung der Leistungsfähigkeit des Menschen.'),
('3210', 'Gebäude für Sportzwecke', 'Gebäude für Sportzwecke ist ein Gebäudes, in dem verschiedene Sportarten ausgeübt werden.'),
('3211', 'Sport-, Turnhalle', 'Sport-, Turnhalle ist ein Gebäude, das für den Turnunterricht und für sportliche Betätigungen in der Freizeit errichtet und dementsprechend ausgestattet ist.'),
('3212', 'Gebäude zum Sportplatz', 'Gebäude zum Sportplatz ist ein Gebäude auf einer Fläche, die zur sportlichen Betätigung genutzt wird.'),
('3220', 'Badegebäude', 'Badegebäude ist ein Gebäude, in dem sich Anlagen zur Erholung und sportlichen Betätigung im Wasser befinden.'),
('3221', 'Hallenbad', 'Hallenbad ist ein Gebäude mit Schwimmbecken und zugehörigen Einrichtungen (z. B. Umkleidekabinen).'),
('3222', 'Gebäude im Freibad', 'Gebäude im Freibad ist ein Gebäude, das sich in einer Außenanlage mit Schwimmbecken und zugehörigen Einrichtungen (z. B. Umkleidekabinen) befindet.'),
('3230', 'Gebäude im Stadion', 'Gebäude im Stadion ist ein Gebäude, das sich in einer großen Anlage für sportliche Aktivitäten und Wettkämpfe befindet.'),
('3240', 'Gebäude für Kurbetrieb', 'Gebäude für Kurbetrieb ist ein Gebäude, in dem Maßnahmen zur Erholung oder Rehabilitation durchgeführt werden.'),
('3241', 'Badegebäude für medizinische Zwecke', 'Badegebäude für medizinische Zwecke ist ein Gebäude, in dem Bäder zur therapeutischen Anwendung durchgeführt werden.'),
('3242', 'Sanatorium', 'Sanatorium ist ein Gebäude mit zugehörigen Einrichtungen, das klimagünstig gelegen ist, unter fachärztlicher Leitung steht und zur Behandlung chronisch Kranker und Genesender bestimmt ist, für die kein Krankenhausaufenthalt in Frage kommt.'),
('3260', 'Gebäude im Zoo', 'Gebäude im Zoo ist ein Gebäude, das sich in einer parkartigen Anlage zur Haltung und öffentlichen Zurschaustellung verschiedener Tierarten befindet.'),
('3261', 'Empfangsgebäude des Zoos', 'Empfangsgebäude des Zoos ist ein Gebäude, das sich im Eingangsbereich des Zoos befindet u. a. mit Wartebereich und Einlasskontrolle.'),
('3262', 'Aquarium, Terrarium, Voliere', 'Aquarium, Terrarium, Voliere ist ein Gebäude, in dem Fische und Wasserpflanzen, Reptilien und Amphibien oder Vögel gehalten und gezüchtet werden.'),
('3263', 'Tierschauhaus', 'Tierschauhaus ist ein Gebäude, in dem Tiere untergebracht sind und Besuchern gezeigt werden.'),
('3264', 'Stall im Zoo', 'Stall im Zoo ist ein Gebäude, das meist zur separaten Unterbringung der Zootiere dient.'),
('3270', 'Gebäude im botanischen Garten', 'Gebäude im botanischen Garten ist ein Gebäude, das sich in einer parkartigen Anlage mit thematisch geordneter Anpflanzung befindet.'),
('3271', 'Empfangsgebäude des botanischen Gartens', 'Empfangsgebäude des botanischen Gartens ist ein Gebäude, das sich im Eingangsbereich des botanischen Gartens befindet u. a. mit Wartebereich und Einlasskontrolle.'),
('3272', 'Gewächshaus (Botanik)', 'Gewächshaus (Botanik) ist ein Gebäude, welches das geschützte und kontrollierte Kultivieren von Pflanzen ermöglicht.'),
('3273', 'Pflanzenschauhaus', 'Pflanzenschauhaus ist ein Gebäude, in dem Pflanzen unterschiedlicher Klima- oder Vegetationszonen ausgestellt sind und Besuchern gezeigt werden.'),
('3280', 'Gebäude für andere Erholungseinrichtung', 'Gebäude für andere Erholungseinrichtung ist ein Gebäude, das einer anderen Art der Erholung dient.'),
('3281', 'Schutzhütte', 'Schutzhütte ist ein Gebäude zum Schutz vor Unwetter.'),
('3290', 'Touristisches Informationszentrum', 'Touristisches Informationszentrum ist eine Auskunftsstelle für Touristen.'),
('9998', 'Nach Quellenlage nicht zu spezifizieren', 'Nach Quellenlage nicht zu spezifizieren bedeutet, dass keine Aussage über die Werteart gemacht werden kann.');
CREATE TABLE ax_bauweise_gebaeude (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_bauweise_gebaeude IS 'Alias: "AX_Bauweise_Gebaeude", UML-Typ: Enumeration';
INSERT INTO ax_bauweise_gebaeude (wert,beschreibung,dokumentation) VALUES
('1100', 'Freistehendes Einzelgebäude', 'Freistehendes Einzelgebäude ist ein freistehendes Wohngebäude mit in der Regel bis zu 2½ Geschossen (auch Villa, Landhaus, Bungalow).'),
('1200', 'Freistehender Gebäudeblock', 'Freistehender Gebäudeblock ist ein freistehendes Wohngebäude (Mehrfamilienhaus), in der Regel
3 - 8-geschossig.'),
('1300', 'Einzelgarage', 'Einzelgarage ist eine einzeln stehende oder angebaute einzelne Garage als Abstellmöglichkeit für ein Fahrzeug, meist einen Pkw (auch eine einzelne Garage in Garagenhöfen).'),
('1400', 'Doppelgarage', 'Doppelgarage ist eine einzeln stehende oder angebaute Garage als Abstellmöglichkeit für zwei Fahrzeuge, meist zwei Pkw.'),
('1500', 'Sammelgarage', 'Sammelgarage ist eine Garage mit Abstellmöglichkeit für mehr als zwei Fahrzeuge, meist Pkw.'),
('2100', 'Doppelhaushälfte', 'Doppelhaushälfte ist ein dreiseitig freistehendes Wohnhaus mit in der Regel bis zu 2½ Geschossen, an dem ein im allgemeinen gleichartiges Wohnhaus angebaut ist (etwa gleicher Baustil und ungefähr gleiche Baumaße).'),
('2200', 'Reihenhaus', 'Reihenhaus ist eines von mehr als 2 gleichartig aneinandergebauten Wohnhäusern mit in der Regel bis zu 2½ Geschossen in einer geschlossenen Häuserzeile (etwa gleicher Baustil und ungefähr gleiche Baumaße).'),
('2300', 'Haus in Reihe', 'Haus in Reihe ist eines von mehr als zwei ungleichartigen, aneinandergebauten Wohnhäusern, in der Regel mit bis zu 2 ½ Geschossen (z. B. in geschlossener Bauweise errichtete Wohngebäude in alten Ortskernen).'),
('2400', 'Gruppenhaus', 'Gruppenhaus ist eines von mehr als 2 gleichartigen, aneinandergebauten Wohnhäusern mit in der Regel bis zu 2½ Geschossen, die so gegeneinander verschoben sind, dass keine gemeinsame Achse gegeben ist.'),
('2500', 'Gebäudeblock in geschlossener Bauweise', 'Gebäudeblock in geschlossener Bauweise ist eines von mehreren aneinandergebauten Wohngebäuden (Mehrfamilienhäuser), in der Regel 3-8 geschossig; z. B. in Stadtkernen.'),
('4000', 'Offene Halle', 'Unter einer Offenen Halle ist eine Halle zu verstehen, bei der alle vier Seiten offen sind.
Hallen, bei denen eine, zwei oder drei Seiten geschlossen sind, werden nur mit der entsprechenden Gebäudefunktion ohne Belegung der Bauweise erfasst. Die offenen Gebäudeseiten sind mit Besondere Gebäudelinie, Beschaffenheit Offene Gebäudelinie zu belegen.'),
('9999', 'Sonstiges', 'Sonstiges bedeutet, dass das Gebäude eine Bauweise aufweist, die bekannt, aber nicht in der Liste der Wertearten aufgeführt ist.');
CREATE TABLE ax_weitere_gebaeudefunktion (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_weitere_gebaeudefunktion IS 'Alias: "AX_Weitere_Gebaeudefunktion", UML-Typ: Enumeration';
INSERT INTO ax_weitere_gebaeudefunktion (wert,beschreibung,dokumentation) VALUES
('1000', 'Bankfiliale', 'Bankfiliale ist eine Einrichtung in der Geldgeschäfte getätigt werden.'),
('1010', 'Hotel', 'Hotel ist ein Beherbergungs- und/oder Verpflegungsbetrieb.'),
('1020', 'Jugendherberge', 'Jugendherberge ist eine zur Förderung von Jugendreisen dienende Aufenthalts- und Übernachtungsstätte.'),
('1030', 'Gaststätte', 'Gaststätte ist eine Einrichtung, in der gegen Entgelt Mahlzeiten und Getränke zum sofortigen Verzehr angeboten werden.'),
('1040', 'Kino', 'Kino ist eine Einrichtung, in der alle Arten von Filmen bzw. Lichtspielen für ein Publikum abgespielt werden.'),
('1050', 'Spielkasino', 'Spielkasino ist eine Einrichtung, in der öffentlich zugänglich staatlich konzessioniertes Glücksspiel betrieben wird.'),
('1051', 'Spielhalle', 'Spielhalle ist eine Einrichtung, in der durch die Spielverordnung geregeltes Automatenspiel betrieben wird.'),
('1060', 'Tiefgarage', 'Tiefgarage ist ein Bauwerk unterhalb der Erdoberfläche, in dem Fahrzeuge abgestellt werden.'),
('1070', 'Parkdeck', 'Parkdeck ist eine Fläche auf einem Gebäude, auf der Fahrzeuge abgestellt werden.'),
('1080', 'Toilette', 'Toilette ist eine Einrichtung mit sanitären Vorrichtungen zur Aufnahme von Körperausscheidungen.'),
('1090', 'Post', 'Post ist eine Einrichtung, von der aus Briefe, Pakete befördert und weitere Dienstleistungen angeboten werden.'),
('1100', 'Zoll', 'Zoll ist eine Einrichtung der Zollabfertigung.'),
('1110', 'Theater', 'Theater ist eine Einrichtung, in der Bühnenstücke aufgeführt werden.'),
('1120', 'Museum', 'Museum ist eine Einrichtung in der Sammlungen von (historischen) Objekten oder Reproduktionen davon ausgestellt werden.'),
('1130', 'Bibliothek', 'Bibliothek ist eine Einrichtung, in der Bücher und Zeitschriften gesammelt, aufbewahrt und ausgeliehen werden.'),
('1140', 'Kapelle', 'Kapelle ist eine Einrichtung für (christliche) gottesdienstliche Zwecke .'),
('1150', 'Moschee', 'Moschee ist ein Einrichtung, in der sich Muslime zu Gottesdiensten versammeln oder zu anderen Zwecken treffen.'),
('1160', 'Tempel', 'Tempel ist eine Einrichtung, die Personen in der Ausübung ihrer Religion (z. B. Buddhisten, Hinduisten) als Versammlungsort dient.'),
('1170', 'Apotheke', 'Apotheke ist ein Geschäft, in dem Arzneimittel hergestellt und verkauft werden.'),
('1180', 'Polizeiwache', 'Polizeiwache ist eine Dienststelle der Polizei.'),
('1190', 'Rettungsstelle, Notaufnahme', 'Rettungsstelle, Notaufnahme ist eine Anlaufstelle zur Akutversorgung und ist Teil der Notfallmedizin.'),
('1200', 'Touristisches Informationszentrum', 'Touristisches Informationszentrum ist eine Auskunftsstelle für Touristen.'),
('1210', 'Kindergarten', 'Kindergarten ist eine Einrichtung, in der Kinder im Vorschulalter betreut werden.'),
('1220', 'Arztpraxis', 'Arztpraxis ist die Arbeitsstätte eines Arztes.'),
('1230', 'Supermarkt', 'Supermarkt ist eine Einrichtung, in der sich ein Einzelhandelsgeschäft befindet, das Lebensmittel und andere Erzeugnisse des täglichen Bedarfs anbietet.'),
('1240', 'Geschäft', 'Geschäft ist eine Einrichtung, in der sich Räumlichkeiten befinden, in denen Waren oder Dienstleistungen gewerblich zum Verkauf angeboten werden.');
CREATE TABLE ax_zustand_gebaeude (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_gebaeude IS 'Alias: "AX_Zustand_Gebaeude", UML-Typ: Enumeration';
INSERT INTO ax_zustand_gebaeude (wert,beschreibung,dokumentation) VALUES
('1000', 'In behelfsmäßigem Zustand', 'In behelfsmäßigem Zustand bedeutet, dass das Gebäude nur eingeschränkt bewohnt oder genutzt werden kann.'),
('2000', 'In ungenutztem Zustand', 'In ungenutztem Zustand bedeutet, dass das Gebäude nicht genutzt wird.'),
('2100', 'Außer Betrieb, stillgelegt, verlassen', 'Außer Betrieb, stillgelegt, verlassen bedeutet, dass das Gebäude auf Dauer nicht mehr bewohnt oder genutzt wird.'),
('2200', 'Verfallen, zerstört', 'Verfallen, zerstört bedeutet, dass sich der ursprüngliche Zustand des Gebäudes durch menschliche oder zeitliche Einwirkungen so verändert hat, dass eine Nutzung nicht mehr möglich ist.'),
('2300', 'Teilweise zerstört', 'Teilweise zerstört bedeutet, dass sich der ursprüngliche Zustand des Gebäudes durch menschliche oder zeitliche Einwirkungen so verändert hat, dass eine Nutzung nur noch teilweise möglich ist.'),
('3000', 'Geplant und beantragt', 'Geplant und beantragt bedeutet, dass ein Gebäude geplant und dessen Errichtung beantragt ist.'),
('4000', 'Im Bau', 'Im Bau bedeutet, dass sich ein Gebäude im Bau befindet.');
CREATE TABLE ax_obererbezugspunkt (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_obererbezugspunkt IS 'Alias: "AX_ObererBezugspunkt", UML-Typ: Enumeration';
INSERT INTO ax_obererbezugspunkt (wert,beschreibung,dokumentation) VALUES
('1000', 'Mittlere Traufhöhe (Schnitt aufgehendes Mauerwerk mit Dachhaut)', 'Mittlere Traufhöhe ist der Mittelwert aus höchster und niedrigster Traufhöhe.'),
('1100', 'Mittlere Giebelhöhe', 'Mittlere Giebelhöhe ist der Mittelwert aus Traufhöhe und Firsthöhe an der Giebelseite.'),
('1200', 'Mittlere Höhe der Dachkanten', 'Mittlere Höhe der Dachkanten ist der Mittelwert der Höhen aller Dachkanten.'),
('1300', 'Höchste Traufhöhe (Schnitt aufgehendes Mauerwerk mit Dachhaut)', 'Höchste Traufhöhe ist der absolut am höchsten gelegene Punkt aller Traufhöhen.'),
('1400', 'Höchster Punkt der Dachaufbauten', 'Höchster Punkt der Dachaufbauten ist der höchstgelegene Punkt der Dachaufbauten.'),
('1500', 'Höchste Dachkante', 'Höchste Dachkante ist die am höchsten gelegene Verbindung von Traufe und First.'),
('1600', 'Niedrigste Traufhöhe (Schnitt aufgehendes Mauerwerk mit Dachhaut)', 'Niedrigste Traufhöhe ist der absolut am niedrigsten gelegene Punkt aller Traufhöhen die sich durch den Schnitt des aufgehenden Mauerwerks mit der Dachhaut ergeben.'),
('1700', 'Niedrigste Dachkante', 'niedrigste Dachkante ist die am niedrigsten gelegene Verbindung von Traufe und First.'),
('1800', 'First', 'First ist die oberste, waagerechte Kante einer Dachform. Bei gewölbten und runden, tonnenförmigen Dachkonstruktionen verläuft der First am Scheitelpunkt des Bogens.'),
('1900', 'Höchster Punkt', 'Höchster Punkt ist der höchste Punkt des Objekts.'),
('2000', 'Mittlere Höhe', 'Mittlere Höhe ist der Mittelwert der Höhen aus höchsten und niedrigsten Punkt des Objekts.'),
('2100', 'Niedrigster Punkt', 'Niedrigster Punkt ist der niedrigste Punkt des Objekts.');
CREATE TABLE ax_bauart_bauteil (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_bauart_bauteil IS 'Alias: "AX_Bauart_Bauteil", UML-Typ: Enumeration';
INSERT INTO ax_bauart_bauteil (wert,beschreibung,dokumentation) VALUES
('1100', 'Geringergeschossiger Gebäudeteil', 'Ein geringergeschossiger Gebäudeteil hat eine niedrigere Geschosshöhe als der größte Teil des Gebäudes.'),
('1200', 'Höhergeschossiger Gebäudeteil (nicht Hochhaus)', 'Ein höhergeschossiger Gebäudeteil hat eine höhere Geschosshöhe als der größte Teil des Gebäudes.'),
('1300', 'Hochhausgebäudeteil', 'Hochhausgebäudeteil ist der Teil eines Gebäudes, welches die Definition der Attributart Hochhaus beim AX_Gebaeude erfüllt.'),
('1400', 'Abweichende Geschosshöhe', 'Die abweichende Geschosshöhe bezeichnet einen Bauteil, dessen Geschosshöhe von der Höhe anderer Bauteile des Gebäudes abweicht.'),
('2000', 'Keller', 'Keller bezeichnet ein Geschoss, welches ganz oder zum Teil unter der Geländeoberfläche liegt.'),
('2100', 'Tiefgarage', 'Tiefgarage ist ein Bauteil unter der Erdoberfläche, in dem Fahrzeuge abgestellt werden.'),
('2300', 'Loggia', 'Loggia ist ein Raum in einem Gebäude, der sich zum Außenraum öffnet.'),
('2350', 'Wintergarten', 'Wintergarten bezeichnet den fest umbauten Raum einer Terrasse.'),
('2400', 'Arkade', 'Arkade bezeichnet den durch Säulen getragenen Bogengang eines Gebäudes.'),
('2500', 'Auskragender Geschossteil / zurückspringendes Geschoss', 'Bei einem auskragenden Geschossteil bzw. zurückspringenden Geschoss kann keine eindeutige Zuordnung zu „auskragend“ oder „zurückspringend“ erfolgen.'),
('2510', 'Auskragender Geschossteil', 'Bei einem auskragenden Geschossteil ragt ein Teil des Geschosses über den Umring hinaus, der durch das aufgehende Mauerwerk im Erdgeschoss definiert ist.'),
('2520', 'Zurückspringendes Geschoss', 'Bei einem zurückspringenden Geschoss reicht ein Geschoss nicht bis zum Umring, der durch das aufgehende Mauerwerk im Erdgeschoss definiert ist.'),
('2610', 'Durchfahrt im Gebäude', 'Durchfahrt ist eine Stelle, an der mit Fahrzeugen durch Gebäude gefahren werden kann.'),
('2620', 'Durchfahrt an überbautem Verkehrsweg', 'Durchfahrt an überbautem Verkehrsweg ist eine Stelle, an der mit Fahrzeugen durch Gebäude gefahren werden kann.'),
('2710', 'Schornstein im Gebäude', 'Schornstein im Gebäude ist ein über das Dach hinausragender Abzugskanal für die Rauchgase einer Feuerungsanlage oder für andere Abgase.'),
('2720', 'Turm im Gebäude', 'Turm im Gebäude ist ein hochaufragendes Bauteil innerhalb eines Gebäudes.'),
('9999', 'Sonstiges', '');
CREATE TABLE ax_dachgeschossausbau_gebaeude (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_dachgeschossausbau_gebaeude IS 'Alias: "AX_Dachgeschossausbau_Gebaeude", UML-Typ: Enumeration';
INSERT INTO ax_dachgeschossausbau_gebaeude (wert,beschreibung,dokumentation) VALUES
('1000', 'Nicht ausbaufähig', 'Nicht ausbaufähig bedeutet, dass sich das Dachgeschoss des Gebäudes nicht zum Ausbau zu Wohnzwecken eignet.'),
('2000', 'Ausbaufähig', 'Ausbaufähig bedeutet, dass sich das Dachgeschoss des Gebäudes zum Ausbau zu Wohnzwecken eignet.'),
('3000', 'Ausgebaut', 'Ausgebaut bedeutet, dass das Dachgeschoss des Gebäudes zu Wohnzwecken ausgebaut ist.'),
('4000', 'Ausbaufähigkeit unklar', 'Ausbaufähigkeit unklar bedeutet, dass für das Gebäude keine Aussage zur Ausbaufähigkeit des Dachgeschosses getroffen werden kann.');
CREATE TABLE ax_beschaffenheit_besonderegebaeudelinie (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_beschaffenheit_besonderegebaeudelinie IS 'Alias: "AX_Beschaffenheit_BesondereGebaeudelinie", UML-Typ: Enumeration';
INSERT INTO ax_beschaffenheit_besonderegebaeudelinie (wert,beschreibung,dokumentation) VALUES
('1000', 'Offene Gebäudelinie', ''),
('1100', 'Geschlossene Seite einer Überdachung', 'Überdachungen sind oftmals an einer oder mehreren Seiten geschlossen. Geschlossene Seite einer Überdachung weist eine geschlossene Seite einer Überdachung bzw. Carport nach.'),
('2100', 'Unverputzt', ''),
('2200', 'Verputzt', ''),
('2300', 'Verklinkert', ''),
('3100', 'Holz', ''),
('3200', 'Sichtbeton', ''),
('3300', 'Naturstein', ''),
('3400', 'Glas', ''),
('4000', 'Trennlinie nicht eindeutig festgelegt', ''),
('9999', 'Sonstiges', '');
CREATE TABLE ax_funktion_gebaeudeinstallation3d (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_gebaeudeinstallation3d IS 'Alias: "AX_Funktion_GebaeudeInstallation3D", UML-Typ: Enumeration';
INSERT INTO ax_funktion_gebaeudeinstallation3d (wert,beschreibung,dokumentation) VALUES
('1010', 'Wintergarten', 'Wintergarten bezeichnet den fest umbauten Raum einer Terrasse.'),
('1020', 'Arkade', 'Arkade bezeichnet den durch Säulen getragenen Bogengang eines Gebäudes.'),
('1030', 'Schornstein im Gebäude', 'Schornstein im Gebäude ist ein über das Dach hinausragender Abzugskanal für die Rauchgase einer Feuerungsanlage oder für andere Abgase.'),
('1040', 'Säule', 'Säule ist eine lotrechte, freistehende Stütze aus Holz, Stein, Ziegel oder Metall.'),
('1050', 'Treppe', 'Treppe ist ein aus Stufen gebildeter Auf- oder Abgang.'),
('1060', 'Gaube', 'Gaube ist ein Dachaufbau im geneigten Dach eines Gebäudes.'),
('1070', 'Balkon', 'Balkon ist eine Plattform an einem Gebäude, die über dem Geländeniveau liegt und aus dem Baukörper hinausragt. Ein Balkon wird von einer Brüstung oder einem Geländer eingefasst.'),
('1080', 'Fahrstuhlaufbau', 'Fahrstuhlaufbau ist ein Aufbau auf einen Dach, in welchem die Technik des Fahrstuhls untergebracht ist.'),
('1090', 'Antenne', 'Antenne ist eine Vorrichtung zum Senden und Empfangen elektromagnetischer Wellen.'),
('1100', 'Geländer', ''),
('1110', 'Vordach', 'Ein Vordach ist ein zusätzliches kleines Dach, das über dem Eingangsbereich eines Hauses angebracht ist.'),
('1120', 'Beleuchtung', 'Beleuchtung bezeichnet eine auf einem Dach installierte künstliche Lichtquelle.'),
('9999', 'Sonstiges', '');
CREATE TABLE ax_null_listenelement3d (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_null_listenelement3d IS 'Alias: "AX_Null_Listenelement3D", UML-Typ: Enumeration';
INSERT INTO ax_null_listenelement3d (wert,beschreibung,dokumentation) VALUES
('1000', 'Keine Angabe', ''),
('2000', 'Nicht eingetragen', '');
CREATE TABLE ax_li_processstep_dachhoehe_source (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_li_processstep_dachhoehe_source IS 'Alias: "AX_LI_ProcessStep_Dachhoehe_Source", UML-Typ: Enumeration';
INSERT INTO ax_li_processstep_dachhoehe_source (wert,beschreibung,dokumentation) VALUES
('1000', 'Aus Laserscanmessung', ''),
('2000', 'Aus Stockwerken', ''),
('3000', 'Aus Standardwerten', ''),
('4000', 'Aus Photogrammetrie -manuell', ''),
('5000', 'Aus Photogrammetrie -automatisch', ''),
('6000', 'Manuell', ''),
('9998', 'Nach Quellelage nicht zu spezifizieren', ''),
('9999', 'Sonstiges', '');
CREATE TABLE ax_li_processstep_bodenhoehe_description (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_li_processstep_bodenhoehe_description IS 'Alias: "AX_LI_ProcessStep_Bodenhoehe_Description", UML-Typ: Enumeration';
INSERT INTO ax_li_processstep_bodenhoehe_description (wert,beschreibung,dokumentation) VALUES
('1000', 'Aus Verschneidung mit DGM', ''),
('1100', 'Aus Verschneidung mit DGM 1', ''),
('1200', 'Aus Verschneidung mit DGM 2', ''),
('1300', 'Aus Verschneidung mit DGM 5', ''),
('1400', 'Aus Verschneidung mit DGM 10', ''),
('1500', 'Aus Verschneidung mit DGM 25', ''),
('1600', 'Aus Verschneidung mit DGM 50', ''),
('1700', 'Aus Verschneidung mit DGM 200', ''),
('1800', 'Aus Verschneidung mit DGM 1000', ''),
('2000', 'Aus Einzelmessung', ''),
('3000', 'Aus Photogrammetrie -manuell', ''),
('4000', 'Aus Photogrammetrie -automatisch', ''),
('9998', 'Nach Quellenlage nicht zu spezifizieren', ''),
('9999', 'Sonstiges', '');
CREATE TABLE ax_bezugspunktdach (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_bezugspunktdach IS 'Alias: "AX_BezugspunktDach", UML-Typ: Enumeration';
INSERT INTO ax_bezugspunktdach (wert,beschreibung,dokumentation) VALUES
('1000', 'First', 'First bezeichnet die obere Dachkante einer Dachfläche.'),
('2000', 'Mittelwert', 'Der Mittelwert ist eine allgemeine Bezeichnung für das arithmetische Mittel.'),
('2100', 'Arithmetrisches Mittel', 'Das arithmetische Mittel ist ein Mittelwert, der als Quotient aus der Summe aller beobachteten Werte und der Anzahl der Werte definiert ist'),
('2200', 'Median', 'Der Median, oder Zentralwert, bezeichnet eine Grenze zwischen zwei Hälften. In der Statistik halbiert der Median eine Verteilung.'),
('2300', 'Geometrisches Mittel', 'Das geometrische Mittel ist ein Mittelwert; es ist in der Statistik ein geeignetes Mittelmaß für Größen, von denen das Produkt anstelle der Summe interpretierbar ist.'),
('3000', 'Traufe', 'Traufe bezeichnet den Schnittpunkt der Dachhaut mit dem aufgehenden Mauerwerk.'),
('9998', 'Nach Quellenlage nicht zu spezifizieren', '');
CREATE TABLE ax_dateitypraster_textur3d (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_dateitypraster_textur3d IS 'Alias: "AX_DateiTypRaster_Textur3D", UML-Typ: Enumeration';
INSERT INTO ax_dateitypraster_textur3d (wert,beschreibung,dokumentation) VALUES
('1000', 'Jpg', ''),
('2000', 'Jp2', ''),
('3000', 'Gif', ''),
('4000', 'Bmp', ''),
('5000', 'Tif', ''),
('6000', 'Png', '');
CREATE TABLE ax_typ_textur3d (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_typ_textur3d IS 'Alias: "AX_Typ_Textur3D", UML-Typ: Enumeration';
INSERT INTO ax_typ_textur3d (wert,beschreibung,dokumentation) VALUES
('1000', 'Typisch', 'Eine typische Textur ist eine generalisierte Darstellung der Struktur und Farbe der Oberfläche.'),
('2000', 'Spezifisch', 'Eine spezifische Textur ist eine fotorealistische Darstellung der Oberfläche.');
CREATE TABLE ax_material_materialeigenschaft_material3d (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_material_materialeigenschaft_material3d IS 'Alias: "AX_Material_Materialeigenschaft_Material3D", UML-Typ: Enumeration';
INSERT INTO ax_material_materialeigenschaft_material3d (wert,beschreibung,dokumentation) VALUES
('1000', 'Holz', ''),
('2000', 'Beton', ''),
('3000', 'Klinker', ''),
('4000', 'Putz', ''),
('5000', 'Glas', ''),
('9999', 'Sonstiges', '');
CREATE TABLE ax_artdergebietsgrenze_gebietsgrenze (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_artdergebietsgrenze_gebietsgrenze IS 'Alias: "AX_ArtDerGebietsgrenze_Gebietsgrenze", UML-Typ: Enumeration';
INSERT INTO ax_artdergebietsgrenze_gebietsgrenze (wert,beschreibung,dokumentation) VALUES
('7100', 'Grenze eines Staates', 'Grenze eines Staates ist eine politische Grenze zwischen Staaten zur Sicherung der territorialen Integrität und der exakten Definition des räumlichen Geltungsbereichs staatlicher Rechtsordnungen.'),
('7101', 'Grenze der Bundesrepublik Deutschland', 'Grenze der Bundesrepublik Deutschland begrenzt das Gebiet der Bundesrepublik Deutschland.'),
('7102', 'Grenze des Bundeslandes', 'Grenze des Bundeslandes begrenzt das Gebiet einer Verwaltungseinheit auf der Bundeslandebene.'),
('7103', 'Grenze des Regierungsbezirks', 'Grenze des Regierungsbezirks begrenzt das Gebiet einer Verwaltungseinheit auf der Regierungsbezirksebene.'),
('7104', 'Grenze des Kreises / Kreisfreien Stadt / Region', 'Grenze des Kreises / Kreisfreien Stadt / Region begrenzt das Gebiet einer Verwaltungseinheit auf der Kreisebene bzw. der kreisfreien Stadt.'),
('7105', 'Grenze der Verwaltungsgemeinschaft', 'Grenze der Verwaltungsgemeinschaft begrenzt das Gebiet einer Verwaltungseinheit auf der Verwaltungsgemeinschaftsebene.'),
('7106', 'Grenze der Gemeinde', 'Grenze der Gemeinde begrenzt ein kommunales Gebiet auf der Gemeindeebene.'),
('7107', 'Grenze des Gemeindeteils', 'Grenze des Gemeindeteils begrenzt das Gebiet einer Verwaltungseinheit auf der Gemeindeteilebene.'),
('7108', 'Grenze eines Kondominiums', 'Grenze eines Kondominiums begrenzt ein Gebiet, das unter gemeinsamer Verwaltung von zwei oder mehreren Staaten steht.');
CREATE TABLE ax_art_verbandsgemeinde (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_art_verbandsgemeinde IS 'Alias: "AX_Art_Verbandsgemeinde", UML-Typ: Enumeration';
INSERT INTO ax_art_verbandsgemeinde (wert,beschreibung,dokumentation) VALUES
('1000', 'Samtgemeinde', 'Samtgemeinde umfasst in Niedersachsen das Gebiet einer Samtgemeinde.'),
('2000', 'Verbandsgemeinde', 'Verbandsgemeinde umfasst in Rheinland-Pfalz das Gebiet einer Verbandsgemeinde, das aus benachbarten Gemeinden desselben Landkreises gebildet wird.'),
('3000', 'Amt', 'Amt umfasst das Gebiet eines Amtes, das aus Gemeinden desselben Landkreises besteht.');
CREATE TABLE ax_zustand_gebietsgrenze (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_gebietsgrenze IS 'Alias: "AX_Zustand_Gebietsgrenze", UML-Typ: Enumeration';
INSERT INTO ax_zustand_gebietsgrenze (wert,beschreibung,dokumentation) VALUES
('4100', 'Streitig/strittig', 'Streitig/strittig bedeutet, dass der Grenzverlauf umstritten ist.'),
('4200', 'Grenzverlauf, fiktiv', 'Grenzverlauf, fiktiv’ bedeutet, dass für den Grenzverlauf des Gebietes keine explizite Grenzgeometrie festgelegt ist.');
CREATE TABLE ax_art_baublock (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_art_baublock IS 'Alias: "AX_Art_Baublock", UML-Typ: Enumeration';
INSERT INTO ax_art_baublock (wert,beschreibung,dokumentation) VALUES
('1000', 'Nettobaublockfläche', ''),
('2000', 'Bruttobaublockfläche', '');
CREATE TABLE ax_bodenart_bodenschaetzung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_bodenart_bodenschaetzung IS 'Alias: "AX_Bodenart_Bodenschaetzung", UML-Typ: Enumeration';
INSERT INTO ax_bodenart_bodenschaetzung (wert,beschreibung,dokumentation) VALUES
('1100', 'Sand (S)', ''),
('1200', 'Anlehmiger Sand (Sl)', ''),
('2100', 'Lehmiger Sand (lS)', ''),
('2200', 'Stark lehmiger Sand (SL)', ''),
('3100', 'Lehm (L)', ''),
('3200', 'Sandiger Lehm (sL)', ''),
('4100', 'Ton (T)', ''),
('4200', 'Schwerer Lehm (LT)', ''),
('5000', 'Moor (Mo)', ''),
('6110', 'Sand mit Moor (SMo)', ''),
('6120', 'Lehmiger Sand mit Moor (lSMo)', ''),
('6130', 'Lehm mit Moor (LMo)', ''),
('6140', 'Ton mit Moor (TMo)', ''),
('6210', 'Moor mit Sand (MoS)', ''),
('6220', 'Moor mit lehmigem Sand (MolS)', ''),
('6230', 'Moor mit Lehm (MoL)', ''),
('6240', 'Moor mit Ton (MoT)', ''),
('7100', 'Sand auf stark lehmigem Sand (S/SL)', ''),
('7110', 'Sand auf sandigem Lehm (S/sL)', ''),
('7120', 'Sand auf Lehm (S/L)', ''),
('7130', 'Sand auf schwerem Lehm (S/LT)', ''),
('7140', 'Sand auf Ton (S/T)', ''),
('7200', 'Anlehmiger Sand auf sandigem Lehm (Sl/sL)', ''),
('7210', 'Anlehmiger Sand auf Lehm (Sl/L)', ''),
('7220', 'Anlehmiger Sand auf schwerem Lehm (Sl/LT)', ''),
('7230', 'Anlehmiger Sand auf Ton (Sl/T)', ''),
('7300', 'Lehmiger Sand auf Lehm (lS/L)', ''),
('7310', 'Lehmiger Sand auf schwerem Lehm (lS/LT)', ''),
('7320', 'Lehmiger Sand auf Sand (lS/S)', ''),
('7330', 'Lehmiger Sand auf Ton (lS/T)', ''),
('7400', 'Stark lehmiger Sand auf Ton (SL/T)', ''),
('7410', 'Stark lehmiger Sand auf schwerem Lehm (SL/LT)', ''),
('7420', 'Stark lehmiger Sand auf Sand (SL/S)', ''),
('7500', 'Ton auf sandigem Lehm (T/sL)', ''),
('7510', 'Ton auf stark lehmigem Sand (T/SL)', ''),
('7520', 'Ton auf lehmigem Sand (T/lS)', ''),
('7530', 'Ton auf anlehmigem Sand (T/Sl)', ''),
('7540', 'Ton auf Sand (T/S)', ''),
('7600', 'Schwerer Lehm auf stark lehmigem Sand (LT/SL)', ''),
('7610', 'Schwerer Lehm auf lehmigem Sand (LT/lS)', ''),
('7620', 'Schwerer Lehm auf anlehmigem Sand (LT/Sl)', ''),
('7630', 'Schwerer Lehm auf Sand (LT/S)', ''),
('7700', 'Lehm auf lehmigem Sand (L/lS)', ''),
('7710', 'Lehm auf anlehmigem Sand (L/Sl)', ''),
('7720', 'Lehm auf Sand (L/S)', ''),
('7800', 'Sandiger Lehm auf Sand (sL/S)', ''),
('7810', 'Sandiger Lehm auf anlehmigem Sand (sL/Sl)', ''),
('7820', 'Sandiger Lehm auf Ton (sL/T)', ''),
('8110', 'Sand auf Moor (S/Mo)', ''),
('8120', 'Lehmiger Sand auf Moor (lS/Mo)', ''),
('8130', 'Lehm auf Moor (L/Mo)', ''),
('8140', 'Ton auf Moor (T/Mo)', ''),
('8210', 'Moor auf Sand (Mo/S)', ''),
('8220', 'Moor auf lehmigem Sand (Mo/lS)', ''),
('8230', 'Moor auf Lehm (Mo/L)', ''),
('8240', 'Moor auf Ton (Mo/T)', ''),
('9120', 'Lehm und Moor, Bodenwechsel (L+Mo)', ''),
('9130', 'Lehmiger Sand, steinig (lSg)', ''),
('9140', 'Lehm, steinig (Lg)', ''),
('9150', 'Lehmiger Sand und Steine/Blöcke (lS+St)', ''),
('9160', 'Lehm und Steine/Blöcke (L+St)', ''),
('9170', 'Steine/Blöcke und lehmiger Sand (St+lS)', ''),
('9180', 'Steine/Blöcke und Lehm (St+L)', ''),
('9190', 'Lehmiger Sand und Felsen (lS+Fe)', ''),
('9200', 'Lehm und Felsen (L+Fe)', ''),
('9210', 'Felsen und lehmiger Sand (Fe+lS)', ''),
('9220', 'Felsen und Lehm (Fe+L)', ''),
('9310', 'Sand auf lehmigem Sand (S/lS)', ''),
('9320', 'Anlehmiger Sand auf Mergel (Sl/Me)', ''),
('9350', 'Lehmiger Sand auf Mergel (lS/Me)', ''),
('9360', 'Lehmiger Sand auf sandigem Lehm (lS/sL)', ''),
('9370', 'Lehmiger Sand mit Mergel (lSMe)', ''),
('9380', 'Lehmiger Sand mit Moor auf Mergel (lSMo/Me)', ''),
('9390', 'Anlehmiger Sand mit Moor (SlMo)', ''),
('9410', 'Lehm auf Mergel (L/Me)', ''),
('9420', 'Lehm mit Moor auf Mergel (LMo/Me)', ''),
('9430', 'Schwerer Lehm auf Moor (LT/Mo)', ''),
('9440', 'Ton auf Mergel (T/Me)', ''),
('9450', 'Moor auf Mergel (Mo/Me)', ''),
('9460', 'Moor mit Lehm auf Mergel (MoL/Me)', ''),
('9470', 'Moor mit Mergel (MoMe)', ''),
('9480', 'LößDiluvium (LöD)', ''),
('9490', 'AlluviumDiluvium (AlD)', '');
CREATE TABLE ax_entstehungsart (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_entstehungsart IS 'Alias: "AX_Entstehungsart", UML-Typ: Enumeration';
INSERT INTO ax_entstehungsart (wert,beschreibung,dokumentation) VALUES
('1000', 'Diluvium (D)', ''),
('1100', 'Diluvium, Alluvium (DAl)', ''),
('1110', 'Diluvium, Alluvium, grob, steinig (DAlg)', ''),
('1200', 'Diluvium, Löß (DLö)', ''),
('1300', 'Diluvium, Verwitterung (DV)', ''),
('1310', 'Diluvium, Verwitterung, grob, steinig (DVg)', ''),
('1400', 'Diluvium, grob, steinig (Dg)', ''),
('1410', 'Diluvium, grob, steinig, Alluvium (DgAl)', ''),
('1420', 'Diluvium, grob, steinig, Löß (DgLö)', ''),
('1430', 'Diluvium, grob, steinig, Verwitterung (DgV)', ''),
('2000', 'Löß (Lö)', ''),
('2100', 'Löß, Diluvium (LöD)', ''),
('2110', 'Löß, Diluvium, grob, steinig (LöDg)', ''),
('2120', 'Löß, Diluvium, Verwitterung (LöDV)', ''),
('2200', 'Löß, Alluvium (LöAl)', ''),
('2210', 'Löß, Alluvium, grob, steinig (LöAlg)', ''),
('2300', 'Löß, Verwitterung (LöV)', ''),
('2310', 'Löß, Verwitterung, grob, steinig (LöVg)', ''),
('2400', 'Löß über Verwitterung, gesteinig (LöVg)', ''),
('3000', 'Alluvium (Al)', ''),
('3100', 'Alluvium, Diluvium (AlD)', ''),
('3200', 'Alluvium, Löß (AlLö)', ''),
('3300', 'Alluvium, Verwitterung (AlV)', ''),
('3310', 'Alluvium, Verwitterung, grob, steinig (AlVg)', ''),
('3400', 'Alluvium, grob, steinig (Alg)', ''),
('3410', 'Alluvium, grob, steinig, Diluvium (AlgD)', ''),
('3420', 'Alluvium, grob, steinig, Löß (AlgLö)', ''),
('3430', 'Alluvium, grob, steinig, Verwitterung (AlgV)', ''),
('3500', 'Alluvium, Marsch (AlMa)', ''),
('3610', 'Alluvium, Moor (AlMo)', ''),
('3620', 'Moor, Alluvium (MoAI)', ''),
('3700', 'Mergel (Me)', ''),
('4000', 'Verwitterung (V)', ''),
('4100', 'Verwitterung, Diluvium (VD)', ''),
('4110', 'Verwitterung, Diluvium, grob, steinig (VDg)', ''),
('4200', 'Verwitterung, Alluvium (VAl)', ''),
('4210', 'Verwitterung, Alluvium, grob, steinig (VAlg)', ''),
('4300', 'Verwitterung, Löß (VLö)', ''),
('4400', 'Verwitterung, grob, steinig (Vg)', ''),
('4410', 'Verwitterung, grob, steinig, Diluvium (VgD)', ''),
('4420', 'Verwitterung, grob, steinig, Löß (VgLö)', ''),
('4430', 'Verwitterung, grob, steinig, Alluvium (VgAl)', ''),
('5000', 'Entstehungsart nicht erkennbar (-)', '');
CREATE TABLE ax_wasserverhaeltnisse (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_wasserverhaeltnisse IS 'Alias: "AX_Wasserverhaeltnisse", UML-Typ: Enumeration';
INSERT INTO ax_wasserverhaeltnisse (wert,beschreibung,dokumentation) VALUES
('7000', 'Wasserstufe nicht erkennbar (-)', ''),
('7100', 'Wasserstufe (1)', ''),
('7200', 'Wasserstufe (2)', ''),
('7300', 'Wasserstufe (3)', ''),
('7310', 'Wasserstufe (3-)', ''),
('7400', 'Wasserstufe (4)', ''),
('7410', 'Wasserstufe (4-)', ''),
('7500', 'Wasserstufe (5)', ''),
('7510', 'Wasserstufe (5-)', ''),
('7600', 'Wasserstufe (3+4)', '');
CREATE TABLE ax_bedeutung_grablochderbodenschaetzung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_bedeutung_grablochderbodenschaetzung IS 'Alias: "AX_Bedeutung_GrablochDerBodenschaetzung", UML-Typ: Enumeration';
INSERT INTO ax_bedeutung_grablochderbodenschaetzung (wert,beschreibung,dokumentation) VALUES
('1100', 'Grabloch, bestimmend, lagerichtig (innerhalb der zugehörigen bodengeschätzten Fläche)', ''),
('1200', 'Grabloch, bestimmend, lagerichtig (außerhalb der zugehörigen bodengeschätzten Fläche)', ''),
('1300', 'Grabloch, bestimmend, nicht lagerichtig (innerhalb der zugehörigen bodengeschätzten Fläche)', ''),
('2000', 'Grabloch für Muster- und Vergleichsstück', ''),
('3000', 'Grabloch, nicht bestimmend, lagerichtig', '');
CREATE TABLE ax_klassifizierung_bewertung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_klassifizierung_bewertung IS 'Alias: "AX_Klassifizierung_Bewertung", UML-Typ: Enumeration';
INSERT INTO ax_klassifizierung_bewertung (wert,beschreibung,dokumentation) VALUES
('1000', 'Grundvermögen', ''),
('1110', 'Unbebautes Grundstück', ''),
('1120', 'Unbebautes Grundstück mit Gebäude von untergeordneter Bedeutung', ''),
('1130', 'Unbebautes Grundstück mit einem dem Verfall preisgegebenen Gebäude', ''),
('1140', 'Unbebautes Grundstück für Erholungs- und Freizeitzwecke', ''),
('1210', 'Einfamilienhausgrundstück', ''),
('1220', 'Zweifamilienhausgrundstück', ''),
('1230', 'Mietwohngrundstück', ''),
('1240', 'Gemischtgenutztes Grundstück', ''),
('1250', 'Geschäftsgrundstück', ''),
('1260', 'Sonstiges bebautes Grundstück', ''),
('1310', 'Einfamilienhaus auf fremdem Grund und Boden', ''),
('1320', 'Zweifamilienhaus auf fremdem Grund und Boden', ''),
('1330', 'Mietwohngrundstück, Mietwohngebäude auf fremdem Grund und Boden', ''),
('1340', 'Gemischtgenutztes Grundstück, gemischtgenutztes Gebäude auf fremdem Grund und Boden', ''),
('1350', 'Geschäftsgrundstück, Geschäftsgebäude auf fremdem Grund und Boden', ''),
('1360', 'Sonstige bebaute Grundstücke, sonstige Gebäude auf fremdem Grund und Boden', ''),
('1370', 'Sonstige bebaute Grundstücke, sonstige Anlagen auf fremdem Grund und Boden (Energie-/Wärmegewinnung)', ''),
('3000', 'Landwirtschaftliche Nutzung (LN)', ''),
('3100', 'Forstwirtschaftliche Nutzung (H)', ''),
('3105', 'Forstwirtschaftliche Nutzung mit Bewirtschaftungsbeschränkung (HB)', ''),
('3200', 'Weinbauliche Nutzung (WG)', ''),
('3201', 'Weingarten 1 (WG1)', ''),
('3202', 'Weingarten 2 (WG2)', ''),
('3203', 'Weingarten 3 (WG3)', ''),
('3204', 'Weingarten 4 (WG4)', ''),
('3205', 'Weingarten 5 (WG5)', ''),
('3206', 'Weingarten 6 (WG6)', ''),
('3207', 'Weingarten 7 (WG7)', ''),
('3208', 'Weingarten 8 (WG8)', ''),
('3209', 'Weingarten 9 (WG9)', ''),
('3300', 'Gärtnerische Nutzung', ''),
('3310', 'Gemüsebau - Freiland (GE)', ''),
('3315', 'Gemüsebau - unter Glas und Kunststoffen (GEGL)', ''),
('3320', 'Blumen- und Zierpflanzenbau - Freiland (BL)', ''),
('3325', 'Blumen- und Zierpflanzenbau - unter Glas und Kunststoffen (BLGL)', ''),
('3330', 'Obstbau - Freiland (OB)', ''),
('3335', 'Obstbau - unter Glas und Kunststoffen (OBGL)', ''),
('3340', 'Baumschulen - Freiland (BS)', ''),
('3345', 'Baumschulen - unter Glas und Kunststoffen (BSGL)', ''),
('3400', 'Übrige land- und forstwirtschaftliche Nutzungen', ''),
('3410', 'Kleingarten- und Dauergartenland (KLG)', ''),
('3411', 'Gartenlaube größer 30 qm (GL)', ''),
('3420', 'Hopfen (HOPF)', ''),
('3430', 'Spargel (SPA)', ''),
('3440', 'Sonstige Sonderkulturen (SOKU)', ''),
('3450', 'Saatzucht (SAAT)', ''),
('3460', 'Weihnachtsbaumkultur (WEIH)', ''),
('3470', 'Kurzumtriebsplantage (KUP)', ''),
('3480', 'Wasserflächen (WAS)', ''),
('3481', 'Wasserflächen - stehende Gewässer mit Fischertrag zwischen 1 und 4 kg/Ar (WAS1)', ''),
('3482', 'Wasserflächen - stehende Gewässer mit Fischertrag über 4 kg/Ar (WAS4)', ''),
('3490', 'Wasserflächen - fließende Gewässer mit Fischertrag (FLI)', ''),
('3500', 'Nutzungsarten Abbauland, Geringstland und Unland ()', ''),
('3510', 'Abbauland (AB)', ''),
('3520', 'Geringstland (GER)', ''),
('3530', 'Unland (U)', ''),
('3600', 'Nutzungsart Hofstelle (NF)', ''),
('3610', 'Hofstelle - Wirtschaftsgebäude im bewertungsrechtlichen Sinn (WIGE)', ''),
('3611', 'Hofstelle - Wirtschaftsgebäude der Fass- und Flaschenweinerzeugung (WEIN)', ''),
('3612', 'Hofstelle - Wirtschaftsgebäude der Imkerei (IMK)', ''),
('3613', 'Hofstelle - Wirtschaftsgebäude der Wanderschäferei (SCHA)', ''),
('3614', 'Hofstelle - Wirtschaftsgebäude des Pilzanbaus (PILZ)', ''),
('3615', 'Hofstelle - Wirtschaftsgebäude der Produktion von Nützlingen (NÜTZ)', ''),
('3616', 'Hofstelle - Wirtschaftsgebäude sonstiger Nebenbetriebe (NEB)', ''),
('3700', 'weitere Nutzungen', ''),
('3710', 'Windenergie (WEA)', ''),
('3999', 'Nicht klassifiziert (NA)', '');
CREATE TABLE ax_klimastufe (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_klimastufe IS 'Alias: "AX_Klimastufe", UML-Typ: Enumeration';
INSERT INTO ax_klimastufe (wert,beschreibung,dokumentation) VALUES
('6000', 'Klimastufe nicht erkennbar (-)', ''),
('6100', 'Klimastufe 8° C und darüber (a)', ''),
('6200', 'Klimastufe 7,9° - 7,0° C (b)', ''),
('6300', 'Klimastufe 6,9° - 5,7° C (c)', ''),
('6400', 'Klimastufe 5,6° C und darunter (d)', '');
CREATE TABLE ax_bodenstufe (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_bodenstufe IS 'Alias: "AX_Bodenstufe", UML-Typ: Enumeration';
INSERT INTO ax_bodenstufe (wert,beschreibung,dokumentation) VALUES
('2100', 'Bodenstufe (I)', ''),
('2200', 'Bodenstufe (II)', ''),
('2300', 'Bodenstufe (III)', ''),
('2400', 'Bodenstufe Misch- und Schichtböden sowie künstlich veränderte Böden (-)', ''),
('3100', 'Bodenstufe (II+III)', ''),
('3200', 'Bodenstufe ("(III)")', ''),
('3300', 'Bodenstufe (IV)', '');
CREATE TABLE ax_zustandsstufe (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustandsstufe IS 'Alias: "AX_Zustandsstufe", UML-Typ: Enumeration';
INSERT INTO ax_zustandsstufe (wert,beschreibung,dokumentation) VALUES
('1100', 'Zustandsstufe (1)', ''),
('1200', 'Zustandsstufe (2)', ''),
('1300', 'Zustandsstufe (3)', ''),
('1400', 'Zustandsstufe (4)', ''),
('1500', 'Zustandsstufe (5)', ''),
('1600', 'Zustandsstufe (6)', ''),
('1700', 'Zustandsstufe (7)', ''),
('1800', 'Zustandsstufe Misch- und Schichtböden sowie künstlich veränderte Böden (-)', '');
CREATE TABLE ax_nutzungsart_bodenschaetzung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_nutzungsart_bodenschaetzung IS 'Alias: "AX_Nutzungsart_Bodenschaetzung", UML-Typ: Enumeration';
INSERT INTO ax_nutzungsart_bodenschaetzung (wert,beschreibung,dokumentation) VALUES
('1000', 'Ackerland (A)', ''),
('2000', 'Acker-Grünland (AGr)', ''),
('3000', 'Grünland (Gr)', ''),
('4000', 'Grünland-Acker (GrA)', '');
CREATE TABLE ax_merkmal_musterundvergleichsstueck (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_merkmal_musterundvergleichsstueck IS 'Alias: "AX_Merkmal_MusterUndVergleichsstueck", UML-Typ: Enumeration';
INSERT INTO ax_merkmal_musterundvergleichsstueck (wert,beschreibung,dokumentation) VALUES
('1000', 'Musterstück (M)', ''),
('3000', 'Vergleichsstück (V)', '');
CREATE TABLE ax_nutzungsart_musterundvergleichsstueck (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_nutzungsart_musterundvergleichsstueck IS 'Alias: "AX_Nutzungsart_MusterUndVergleichsstueck", UML-Typ: Enumeration';
INSERT INTO ax_nutzungsart_musterundvergleichsstueck (wert,beschreibung,dokumentation) VALUES
('1000', 'Ackerland (A)', ''),
('2000', 'Acker-Grünland (AGr)', ''),
('3000', 'Grünland (Gr)', ''),
('4000', 'Grünland-Acker (GrA)', '');
CREATE TABLE ax_bodenart_musterundvergleichsstueck (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_bodenart_musterundvergleichsstueck IS 'Alias: "AX_Bodenart_MusterUndVergleichsstueck", UML-Typ: Enumeration';
INSERT INTO ax_bodenart_musterundvergleichsstueck (wert,beschreibung,dokumentation) VALUES
('1100', 'Sand (S)', ''),
('1200', 'Anlehmiger Sand (Sl)', ''),
('2100', 'Lehmiger Sand (lS)', ''),
('2200', 'Stark lehmiger Sand (SL)', ''),
('3100', 'Lehm (L)', ''),
('3200', 'Sandiger Lehm (sL)', ''),
('4100', 'Ton (T)', ''),
('4200', 'Schwerer Lehm (LT)', ''),
('5000', 'Moor (Mo)', ''),
('6110', 'Sand mit Moor (SMo)', ''),
('6120', 'Lehmiger Sand mit Moor (lSMo)', ''),
('6130', 'Lehm mit Moor (LMo)', ''),
('6140', 'Ton mit Moor (TMo)', ''),
('6210', 'Moor mit Sand (MoS)', ''),
('6220', 'Moor mit lehmigem Sand (MolS)', ''),
('6230', 'Moor mit Lehm (MoL)', ''),
('6240', 'Moor mit Ton (MoT)', ''),
('7100', 'Sand auf stark lehmigem Sand (S/SL)', ''),
('7110', 'Sand auf sandigem Lehm (S/sL)', ''),
('7120', 'Sand auf Lehm (S/L)', ''),
('7130', 'Sand auf schwerem Lehm (S/LT)', ''),
('7140', 'Sand auf Ton (S/T)', ''),
('7200', 'Anlehmiger Sand auf sandigem Lehm (Sl/sL)', ''),
('7210', 'Anlehmiger Sand auf Lehm (Sl/L)', ''),
('7220', 'Anlehmiger Sand auf schwerem Lehm (Sl/LT)', ''),
('7230', 'Anlehmiger Sand auf Ton (Sl/T)', ''),
('7300', 'Lehmiger Sand auf Lehm (lS/L)', ''),
('7310', 'Lehmiger Sand auf schwerem Lehm (lS/LT)', ''),
('7320', 'Lehmiger Sand auf Sand (lS/S)', ''),
('7330', 'Lehmiger Sand auf Ton (lS/T)', ''),
('7400', 'Stark lehmiger Sand auf Ton (SL/T)', ''),
('7410', 'Stark lehmiger Sand auf schwerem Lehm (SL/LT)', ''),
('7420', 'Stark lehmiger Sand auf Sand (SL/S)', ''),
('7500', 'Ton auf sandigem Lehm (T/sL)', ''),
('7510', 'Ton auf stark lehmigem Sand (T/SL)', ''),
('7520', 'Ton auf lehmigem Sand (T/lS)', ''),
('7530', 'Ton auf anlehmigem Sand (T/Sl)', ''),
('7540', 'Ton auf Sand (T/S)', ''),
('7600', 'Schwerer Lehm auf stark lehmigem Sand (LT/SL)', ''),
('7610', 'Schwerer Lehm auf lehmigem Sand (LT/lS)', ''),
('7620', 'Schwerer Lehm auf anlehmigem Sand (LT/Sl)', ''),
('7630', 'Schwerer Lehm auf Sand (LT/S)', ''),
('7700', 'Lehm auf lehmigem Sand (L/lS)', ''),
('7710', 'Lehm auf anlehmigem Sand (L/Sl)', ''),
('7720', 'Lehm auf Sand (L/S)', ''),
('7800', 'Sandiger Lehm auf Sand (sL/S)', ''),
('7810', 'Sandiger Lehm auf anlehmigem Sand (sL/Sl)', ''),
('7820', 'Sandiger Lehm auf Ton (sL/T)', ''),
('8110', 'Sand auf Moor (S/Mo)', ''),
('8120', 'Lehmiger Sand auf Moor (lS/Mo)', ''),
('8130', 'Lehm auf Moor (L/Mo)', ''),
('8140', 'Ton auf Moor (T/Mo)', ''),
('8210', 'Moor auf Sand (Mo/S)', ''),
('8220', 'Moor auf lehmigem Sand (Mo/lS)', ''),
('8230', 'Moor auf Lehm (Mo/L)', ''),
('8240', 'Moor auf Ton (Mo/T)', ''),
('9120', 'Lehm und Moor, Bodenwechsel (L+Mo)', ''),
('9130', 'Lehmiger Sand, steinig (lSg)', ''),
('9140', 'Lehm, steinig (Lg)', ''),
('9150', 'Lehmiger Sand und Steine/Blöcke (lS+St)', ''),
('9160', 'Lehm und Steine/Blöcke (L+St)', ''),
('9170', 'Steine/Blöcke und lehmiger Sand (St+lS)', ''),
('9180', 'Steine/Blöcke und Lehm (St+L)', ''),
('9190', 'Lehmiger Sand und Felsen (lS+Fe)', ''),
('9200', 'Lehm und Felsen (L+Fe)', ''),
('9210', 'Felsen und lehmiger Sand (Fe+lS)', ''),
('9220', 'Felsen und Lehm (Fe+L)', '');
CREATE TABLE ax_sonstigeangaben_musterundvergleichsstueck (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_sonstigeangaben_musterundvergleichsstueck IS 'Alias: "AX_SonstigeAngaben_MusterUndVergleichsstueck", UML-Typ: Enumeration';
INSERT INTO ax_sonstigeangaben_musterundvergleichsstueck (wert,beschreibung,dokumentation) VALUES
('1100', 'Nass, zu viel Wasser (Wa+)', ''),
('1200', 'Trocken, zu wenig Wasser (Wa-)', ''),
('1300', 'Besonders günstige Wasserverhältnisse (Wa gt)', ''),
('1400', 'Rieselwasser, künstliche Bewässerung (RiWa)', ''),
('2100', 'Unbedingtes Wiesenland (W)', ''),
('2200', 'Streuwiese (Str)', ''),
('2300', 'Hutung (Hu)', ''),
('2400', 'Acker-Hackrain (Hack)', ''),
('2500', 'Grünland-Hackrain (Hack)', ''),
('2600', 'Garten (G)', ''),
('3000', 'Neukultur (N)', ''),
('4000', 'Tiefkultur (T)', ''),
('5000', 'Geringstland (Ger)', '');
CREATE TABLE ax_sonstigeangaben_bodenschaetzung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_sonstigeangaben_bodenschaetzung IS 'Alias: "AX_SonstigeAngaben_Bodenschaetzung", UML-Typ: Enumeration';
INSERT INTO ax_sonstigeangaben_bodenschaetzung (wert,beschreibung,dokumentation) VALUES
('1100', 'Nass, zu viel Wasser (Wa+)', ''),
('1200', 'Trocken, zu wenig Wasser (Wa-)', ''),
('1300', 'Besonders günstige Wasserverhältnisse (Wa gt)', ''),
('1400', 'Rieselwasser, künstliche Bewässerung (RiWa)', ''),
('2100', 'Unbedingtes Wiesenland (W)', ''),
('2200', 'Streuwiese (Str)', ''),
('2300', 'Hutung (Hu)', ''),
('2400', 'Acker-Hackrain (Hack)', ''),
('2500', 'Grünland-Hackrain (Hack)', ''),
('2600', 'Garten (G)', ''),
('3000', 'Neukultur (N)', ''),
('4000', 'Tiefkultur (T)', ''),
('5000', 'Geringstland (Ger)', ''),
('9000', 'Nachschätzung erforderlich', '');
CREATE TABLE ax_landschaftstyp (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_landschaftstyp IS 'Alias: "AX_Landschaftstyp", UML-Typ: Enumeration';
INSERT INTO ax_landschaftstyp (wert,beschreibung,dokumentation) VALUES
('1100', 'Gebirge, Bergland, Hügelland', 'Gebirge, Bergland, Hügelland bezeichnet eine zusammenhängende größere Erhebung der Erdoberfläche. Es besteht aus einzelnen Bergen und Hochflächen, die durch Täler und Senken gegliedert sind.'),
('1200', 'Berg, Berge', 'Berg, Berge bezeichnet eine über die Umgebung deutlich herausragende Geländeerhebung, einzeln oder als Teil eines Gebirges.'),
('1300', 'Becken, Senke', 'Becken, Senke bezeichnet ein gegenüber der Umgebung tiefer liegendes Land.'),
('1400', 'Tal, Niederung', 'Tal, Niederung bezeichnet im Bergland einen langgestreckten oder gewundenen, unterschiedlich tiefen und breiten Einschnitt im Gelände mit gleichsinnig gerichtetem Gefälle einschließlich des dazu gehörigen Talraumes, im Flachland eine offene Hohlform. Ferner zählen hierzu auch (talähnliche) Talungen und glaziale Rinnen, die beide kein gleichsinniges Gefälle aufweisen.'),
('1500', '(Tief-) Ebene, Flachland', '(Tief-) Ebene, Flachland ist ein Teil der Erdoberfläche mit geringen Höhenunterschieden in einer Höhenlage bis 200- 300 m über NHN.'),
('1600', 'Plateau, Hochfläche', 'Plateau, Hochfläche, bezeichnet einen Teil der Erdoberfläche mit fehlenden oder kaum wahrnehmbaren Höhenunterschieden in einer Höhenlage ab etwa 200-300 m über NHN.'),
('1700', 'Mündungsgebiet', 'Mündungsgebiet bezeichnet die typische, durch Ablagerung von Schwebestoffen entstandene Landschaft im Bereich der Mündung eines fließenden Gewässers in ein anderes Binnengewässer oder in ein Meer.'),
('1800', 'Dünenlandschaft', 'Dünenlandschaft ist eine, vom Wind gebildete, durch Sandanhäufungen geprägte Landschaft.'),
('1900', 'Wald-, Heidelandschaft', 'Wald-, Heidelandschaft ist eine größere zusammenhängende, mit Bäumen bestandene Fläche (Wald) einschließlich darin befindlicher Lichtungen. Hierzu gehören viele ehemalige Heiden, die heute vorwiegend ökonomisch genutzte monokulturartige Forste mit meist Fichten- oder Kiefernbeständen bilden.'),
('2000', 'Inselgruppe', 'Inselgruppe ist eine Gruppe mehrerer nahe beieinander liegender Inseln geologisch gleicher Entstehung.'),
('2100', 'Seenlandschaft', 'Seenlandschaft ist eine durch zahlreiche, nahe beieinander liegende Binnenseen geprägte Landschaft.'),
('2200', 'Siedlungs-, Wirtschaftslandschaft', 'Siedlungs-, Wirtschaftslandschaft ist eine durch Siedlungsverdichtung oder spezielle Wirtschaftsorientierung geprägte Landschaft.'),
('2300', 'Moorlandschaft', 'Moorlandschaft ist eine durch heutige und ehemalige Moore gekennzeichnete Landschaft.'),
('2400', 'Heidelandschaft', 'Heidelandschaft ist eine waldfreie Landschaft der unteren Höhenstufen, die von einer mehr oder weniger lockeren Zwergstrauchformation geprägt wird.'),
('2500', 'Küstenlandschaft', 'Küstenlandschaft enthält jene auf dem Festland gelegenen Gebiete, die dem Meer abgerungen worden sind (Polder, Marschen), deren Entstehung dem Meer zu verdanken ist (Nehrungen, Haken) oder deren Küste durch das Meer geformt wird (Steilküste, Strände, Halbinseln).');
CREATE TABLE ax_funktion_schutzgebietnachwasserrecht (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_schutzgebietnachwasserrecht IS 'Alias: "AX_Funktion_SchutzgebietNachWasserrecht", UML-Typ: Enumeration';
INSERT INTO ax_funktion_schutzgebietnachwasserrecht (wert,beschreibung,dokumentation) VALUES
('2111', 'Öffentliche Wasserversorgung', 'Öffentliche Wasserversorgung ist die Aufgabe eines Wasserschutzgebietes. Ziel ist es, die Gewässer der öffentlichen Wasserversorgung vor nachteiligen Einwirkungen zu schützen.'),
('2112', 'Grundwasseranreicherung', 'Grundwasseranreicherung ist eine Methode, das Grundwasser durch Infiltration (Zugang von Wasser in die Erdrinde) in einem fest definierten Gebiet (Wasserschutzgebiet) anzureichern.'),
('2113', 'Verhütung von schädlichem Abfluss', 'Verhütung von schädlichem Abfluss ist eine Aufgabe eines Wasserschutzgebietes. In diesem Gebiet soll das schädliche Abfließen von Niederschlagswasser sowie das Abschwemmen und der Eintrag von Bodenbestandteilen, Dünge- oder Pflanzenbehandlungsmitteln in Gewässer verhindert werden.');
CREATE TABLE ax_artderfestlegung_naturumweltoderbodenschutzrecht (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_artderfestlegung_naturumweltoderbodenschutzrecht IS 'Alias: "AX_ArtDerFestlegung_NaturUmweltOderBodenschutzrecht", UML-Typ: Enumeration';
INSERT INTO ax_artderfestlegung_naturumweltoderbodenschutzrecht (wert,beschreibung,dokumentation) VALUES
('1610', 'Schutzfläche nach Europarecht', ''),
('1611', 'Flora-Fauna-Habitat-Gebiet', 'Flora-Fauna-Habitat-Gebiet ist ein Schutzgebiet von gemeinschaftlicher Bedeutung im Sinne der Richtlinie 92/43/EWG des Rates der Europäischen Wirtschaftsgemeinschaft zur Erhaltung der natürlichen Lebensräume sowie der wildlebenden Pflanzen und Tiere.'),
('1612', 'Vogelschutzgebiet', 'Vogelschutzgebiet ist ein besonderes Schutzgebiet (Special Protected Area, SPA) im Sinne Artikel 4 Abs. 1 der Richtlinie 79/409/EWG des Rates der Europäischen Wirtschaftsgemeinschaft über die Erhaltung der wildlebenden Vogelarten (Vogelschutzrichtlinie).'),
('1615', 'Nationales Naturmonument', 'Nationales Naturmonument ist ein rechtsverbindlich festgesetztes Gebiet von herausragender Bedeutung (Bundesnaturschutzgesetz §24 Abs.4).'),
('1620', 'Schutzflächen nach Landesnaturschutzgesetz', ''),
('1621', 'Naturschutzgebiet', 'Naturschutzgebiet ist ein rechtsverbindlich festgesetztes Gebiet, in dem ein besonderer Schutz von Natur und Landschaft in ihrer Ganzheit oder in einzelnen Teilen zur Erhaltung von Lebensgemeinschaften oder Biotopen bestimmter wildlebender Tier- und Pflanzenarten, aus wissenschaftlichen, naturgeschichtlichen oder landeskundlichen Gründen oder wegen ihrer Seltenheit, besonderen Eigenart oder hervorragenden Schönheit erforderlich ist.'),
('1622', 'Geschützter Landschaftsbestandteil', 'Geschützter Landschaftsbestandteil ist ein rechtsverbindlich festgesetzter Teil von Natur und Landschaft, dessen besonderer Schutz zur Sicherstellung der Leistungsfähigkeit des Naturhaushalts, zur Belebung, Gliederung oder Pflege des Orts- und Landschaftsbildes oder zur Abwehr schädlicher Einwirkungen erforderlich ist.'),
('1623', 'Landschaftsschutzgebiet', 'Landschaftsschutzgebiet ist ein rechtsverbindlich festgesetztes Gebiet, in dem ein besonderer Schutz von Natur und Landschaft zur Erhaltung oder Wiederherstellung der Leistungsfähigkeit des Naturhaushalts oder der Nutzungsfähigkeit der Naturgüter, wegen der Vielfalt, Eigenart oder Schönheit des Landschaftsbildes oder wegen der besonderen Bedeutung für die Erholung erforderlich ist.'),
('1624', 'Naturpark', 'Naturpark ist ein einheitlich zu entwickelndes und zu pflegendes Gebiet, das großräumig ist, überwiegend Landschaftsschutzgebiet oder Naturschutzgebiet ist, sich wegen seiner landschaftlichen Voraussetzungen für die Erholung besonders eignet und nach den Grundsätzen und Zielen der Raumordnung und der Landesplanung für die Erholung oder den Fremdenverkehr vorgesehen ist.'),
('1630', 'Bundesbodenschutzgesetz', ''),
('1631', 'Verdachtsfläche auf schädliche Bodenveränderung', ''),
('1632', 'Schädliche Bodenveränderung', ''),
('1633', 'Altlastenverdächtige Fläche', ''),
('1634', 'Altlast', ''),
('1635', 'Gesicherte Altlast', ''),
('1636', 'Gesicherte schädliche Bodenveränderung', ''),
('1640', 'Bundesimmisionsschutzgesetz', ''),
('1641', 'Belastungsgebiet', ''),
('1642', 'Schutzbedürftiges Gebiet', ''),
('1643', 'Gefährdetes Gebiet', ''),
('1644', 'Abstandszone, Störfallbetrieb', ''),
('1650', 'Naturschutzgesetz', ''),
('1651', 'Besonders geschütztes Biotop', ''),
('1652', 'Besonders geschütztes Feuchtgrünland', ''),
('1653', 'Naturdenkmal', 'Naturdenkmal ist eine rechtsverbindlich festgesetzte Einzelschöpfung der Natur, deren besonderer Schutz erforderlich ist (z.B. Baum).'),
('1654', 'Einstweilige Sicherstellung, Veränderungssperre', ''),
('1655', 'Vorkaufsrecht', ''),
('1656', 'Ausgleichs- oder Kompensationsfläche', ''),
('1660', 'Bodenschutzgesetz', ''),
('1661', 'Dauerbeobachtungsflächen', ''),
('1662', 'Bodenschutzgebiet', '');
CREATE TABLE ax_artderfestlegung_anderefestlegungnachwasserrecht (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_artderfestlegung_anderefestlegungnachwasserrecht IS 'Alias: "AX_ArtDerFestlegung_AndereFestlegungNachWasserrecht", UML-Typ: Enumeration';
INSERT INTO ax_artderfestlegung_anderefestlegungnachwasserrecht (wert,beschreibung,dokumentation) VALUES
('1410', 'Wasserstraßengesetz', ''),
('1420', 'Veränderungssperre', ''),
('1421', 'Veränderungssperre nach Bundeswasserstraßengesetz', ''),
('1430', 'Landeswassergesetz', ''),
('1440', 'Überschwemmungsgebiet', 'Überschwemmungsgebiet ist ein durch Rechtsverordnung festgesetztes oder natürliches Gebiet, das bei Hochwasser überschwemmt werden kann bzw. überschwemmt wird.'),
('1441', 'Festgesetztes Überschwemmungsgebiet', 'Festgesetztes Überschwemmungsgebiet ist ein zur Sicherung des schadlosen Hochwasserabflusses durch Rechtsverordnung festgesetztes Gebiet.'),
('1442', 'Natürliches Überschwemmungsgebiet', 'Natürliches Überschwemmungsgebiet ist ein Gebiet, das bei Hochwasser überschwemmt wird.'),
('1443', 'Vorläufig gesichertes Überschwemmungsgebiet', 'Entsprechend des Hamburgischen Wassergesetzes (HWaG) für den Begriff "Vorläufige Sicherung".'),
('1450', 'Pegelschutzgebiet', ''),
('1460', 'Wasser- und Bodenverbandsgebiet', ''),
('1470', 'Deichgebiet', ''),
('1480', 'Unterhaltungsverbandsgebiet', '');
CREATE TABLE ax_zone_schutzzone (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zone_schutzzone IS 'Alias: "AX_Zone_Schutzzone", UML-Typ: Enumeration';
INSERT INTO ax_zone_schutzzone (wert,beschreibung,dokumentation) VALUES
('1010', 'Zone I', 'Zone I ist eine räumlich begrenzte Fläche eines Schutzgebiets, für die die Fachverwaltung besondere Schutzbestimmungen festgelegt hat.'),
('1020', 'Zone II', 'Zone II ist eine räumlich begrenzte Fläche eines Schutzgebiets, für die die Fachverwaltung besondere Schutzbestimmungen festgelegt hat.'),
('1030', 'Zone III', 'Zone III ist eine räumlich begrenzte Fläche eines Schutzgebiets, für die die Fachverwaltung besondere Schutzbestimmungen festgelegt hat.'),
('1031', 'Zone IIIa', 'Zone IIIa ist eine räumlich begrenzte Fläche eines Wasser- oder Heilquellenschutzgebietes, für die die Fachverwaltung besondere Schutzbestimmungen festgelegt hat.'),
('1032', 'Zone IIIb', 'Zone IIIb ist eine räumlich begrenzte Fläche eines Wasser- oder Heilquellenschutzgebietes, für die die Fachverwaltung besondere Schutzbestimmungen festgelegt hat.'),
('1040', 'Zone IV', 'Zone IV ist eine räumlich begrenzte Fläche eines Wasser- oder Heilquellenschutzgebietes, für die die Fachverwaltung besondere Schutzbestimmungen festgelegt hat.'),
('1060', 'Kernzone', 'Kernzone ist eine räumlich begrenzte Fläche eines Biosphärenreservats, für die die Fachverwaltung besondere Schutzbestimmungen festgelegt hat.'),
('1070', 'Pflegezone', 'Pflegezone ist eine räumlich begrenzte Fläche eines Biosphärenreservates, für die die Fachverwaltung besondere Schutzbestimmungen festgelegt hat.'),
('1080', 'Entwicklungszone', 'Entwicklungszone ist eine räumlich begrenzte Fläche eines Biosphärenreservates, für die die Fachverwaltung besondere Schutzbestimmungen festgelegt hat.'),
('1090', 'Regenerationszone', 'Regenerationszone ist eine räumlich begrenzte Fläche eines Biosphärenreservates, für die die Fachverwaltung besondere Schutzbestimmungen festgelegt hat.

Nach §25 Abschnitt 3 des Bundesnaturschutzgesetzes (BNatSchG *Stand:1.03.2010) darf die „Regenerationszone“ nicht mehr verwendet werden.'),
('9997', 'Attribut trifft nicht zu', 'Attribut trifft nicht zu bedeutet, dass keiner der in der Werteliste aufgeführten Attributwerte dem vorliegenden Sachverhalt entspricht.');
CREATE TABLE ax_artderfestlegung_denkmalschutzrecht (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_artderfestlegung_denkmalschutzrecht IS 'Alias: "AX_ArtDerFestlegung_Denkmalschutzrecht", UML-Typ: Enumeration';
INSERT INTO ax_artderfestlegung_denkmalschutzrecht (wert,beschreibung,dokumentation) VALUES
('2700', 'Kulturdenkmal', ''),
('2710', 'Bau- und Kunstdenkmal nach Landesdenkmalschutzgesetz', ''),
('2711', 'Baudenkmal', 'Baudenkmal ist eine bauliche Anlage, an deren Erhaltung wegen ihrer geschichtlichen Bedeutung ein öffentliches Interesse besteht.'),
('2712', 'Kunstdenkmal', ''),
('2713', 'Gartendenkmal', ''),
('2800', 'Archäologisches Denkmal (auch Bodendenkmal) nach Landesdenkmalschutzgesetz', ''),
('2810', 'Archäologisches Denkmal', 'Archäologisches Denkmal ist ein Ort, an dem Reste vor- oder frühgeschichtlicher Kulturen oder früheren menschlichen Wirkens entdeckt wurden.'),
('2820', 'Bodendenkmal', 'Bodendenkmal ist eine mit dem Boden verbundene oder im Boden verborgene Sache, die von Menschen geschaffen oder bearbeitet wurde oder Aufschluss über menschliches Leben in vergangenen Zeiten gibt und deshalb erhaltenswert ist.'),
('2900', 'Schutzgebiet oder -bereiche nach Landesdenkmalschutzgesetz', ''),
('2910', 'Denkmalzone oder -bereich', ''),
('2920', 'Geschützter Baubereich', ''),
('2930', 'Grabungsschutzgebiet', ''),
('3100', 'Befestigungen', ''),
('3110', 'Befestigung (Burg)', 'Befestigung (Burg) ist eine Anlage zum Schutz der Menschen vor äußerer Bedrohung.'),
('3111', 'Burg (Fliehburg, Ringwall)', 'Burg (Fliehburg, Ringwall) ist eine ur- oder frühgeschichtliche runde, ovale oder an Gegebenheiten des Geländes (Böschungskanten) angepasste Befestigungsanlage, die aus einem Erdwall mit oder ohne Holzeinbauten besteht.'),
('3112', 'Erdwerk', ''),
('3113', 'Ringwall', ''),
('3114', 'Steinwerk', ''),
('3115', 'Festung', ''),
('3116', 'Gräftenanlage', ''),
('3117', 'Schanze', 'Schanze ist eine mittelalterliche oder neuzeitliche, in der Regel geschlossene, quadratische, rechteckige oder sternförmige Wallanlage mit Außengraben.'),
('3118', 'Lager', 'Lager ist die Bezeichnung für ein befestigtes Truppenlager in der Römer- oder in der Neuzeit (z.B. bei Belagerungen im 30 jährigen Krieg).'),
('3120', 'Wachturm (römisch), Warte', 'Wachtturm (römisch), Warte ist ein allein oder in Verbindung mit einem Befestigungssystem (Limes) stehender Beobachtungsturm.'),
('3121', 'Wachturm', ''),
('3122', 'Warte', ''),
('3130', 'Befestigung (Wall, Graben)', 'Befestigung (Wall, Graben) ist ein aus Erde aufgeschütteter Grenz-, Schutz- oder Stadtwall. Zu der Befestigung (Wall) zählen auch Limes und Landwehr.'),
('3131', 'Grenzwall, Schutzwall', 'Grenzwall, Schutzwall ist ein aus Erde aufgeschütteter Wall.'),
('3132', 'Limes', ''),
('3133', 'Landwehr', 'Landwehr ist eine mittelalterliche Verteidigungslinie aus ein- bis mehrfachem Wallgrabensystem.'),
('3134', 'Stadtwall', ''),
('3135', 'Historischer Wall', ''),
('3200', 'Historische Siedlung', 'Historische Siedlung ist eine Stelle, an der sich eine ur- oder frühgeschichtliche Siedlung befunden hat.'),
('3210', 'Pfahlbau', 'Pfahlbau ist ein auf eingerammte Pfähle gestelltes, frei über dem Untergrund (Wasser oder Land) stehendes Gebäude.'),
('3220', 'Wüstung', ''),
('3230', 'Wurt', ''),
('3240', 'Abri', ''),
('3250', 'Höhle', ''),
('3300', 'Historische Bestattung', ''),
('3310', 'Großsteingrab (Dolmen, Hünenbett)', 'Großsteingrab (Dolmen, Hünenbett) ist ein Grab mit Steineinbau, d.h. es ist ein aus großen Steinen (z.B. Findlingen) errichteter Grabbau.'),
('3320', 'Grabhügel (Hügelgrab)', 'Grabhügel (Hügelgrab) ist ein meist runder oder ovaler Hügel, der über einer ur- oder frühgeschichtlichen Bestattung aus Erde aufgeschüttet oder aus Plaggen aufgeschichtet wurde.'),
('3330', 'Grabhügelfeld', 'Grabhügelfeld ist eine abgegrenzte Fläche, auf der sich mehrere Grabhügel befinden.'),
('3340', 'Urnenfriedhof', ''),
('3350', 'Körpergräberfeld', ''),
('3360', 'Reihengräberfriedhof', ''),
('3400', 'Historisches land- oder forstwirtschaftliches Objekt', ''),
('3410', 'Historischer Pflanzkamp', ''),
('3420', 'Historisches Viehgehege', ''),
('3430', 'Sandfang', ''),
('3440', 'Historisches Ackersystem', ''),
('3500', 'Historische Bergbau-, Verhüttungs- oder sonstige Produktionsstätte', ''),
('3510', 'Historisches Bergbaurelikt', ''),
('3520', 'Historischer Meiler', ''),
('3530', 'Historischer Ofen', ''),
('3540', 'Historischer Verhüttungsplatz', ''),
('3600', 'Historische Straße oder Weg', ''),
('3610', 'Heerstraße', ''),
('3620', 'Hohlweg', ''),
('3630', 'Moorweg', ''),
('3640', 'Wegespur', ''),
('3700', 'Historisches wasserwirtschaftliches Objekt', ''),
('3710', 'Historische Wasserleitung', 'Historische Wasserleitung ist ein meist offenes System von Gräben, Kunstgräben und Kanälen, in dem Wasser transportiert wird.'),
('3720', 'Aquädukt', 'Aquädukt ist ein brückenartiges Steinbauwerk zur Überführung von Freispiegel-Wasserleitungen mit natürlichem Gefälle über Täler oder andere Bodenunebenheiten.'),
('3730', 'Historischer Deich', ''),
('3740', 'Historischer Damm', ''),
('3750', 'Historischer Graben', ''),
('3800', 'Steinmal', 'Steinmal ist eine kultische oder rechtliche Kennzeichnung, bestehend aus einzelnen oder Gruppen von Steinen.'),
('3810', 'Schalenstein', ''),
('3820', 'Rillenstein', ''),
('3830', 'Wetzrillen', ''),
('3840', 'Kreuzstein', ''),
('3850', 'Historischer Grenzstein', ''),
('3860', 'Menhir', '');
CREATE TABLE ax_ergebnisderueberpruefung_klassifizierungnachwasserrecht (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_ergebnisderueberpruefung_klassifizierungnachwasserrecht IS 'Alias: "AX_ErgebnisDerUeberpruefung_KlassifizierungNachWasserrecht", UML-Typ: Enumeration';
INSERT INTO ax_ergebnisderueberpruefung_klassifizierungnachwasserrecht (wert,beschreibung,dokumentation) VALUES
('1000', 'Fehlerkorrektur', 'Fehlerkorrektur beschreibt dass eine Anpassung durchgeführt wurde, obwohl in der Realwelt keine tatsächliche Änderung stattgefunden hat.'),
('2000', 'Bestätigung des Ist-Zustandes', 'Bestätigung des Ist-Zustandes beschreibt, dass das Objekt zum Zeitpunkt einer Überprüfung als zutreffend ermittelt wurde.'),
('3000', 'Erfassung eines neuen Objektes', 'Erfassung eines neuen Objektes beschreibt, dass eine tatsächliche Änderungen in der Realwelt zur Neubildung des Objektes geführt haben. Das bedeutet, dass eine fachliche Änderung auf Ebene der Objekt- und/oder Attributart stattfand.'),
('4000', 'Geometrieveränderung eines bestehenden Objektes', 'Geometrieveränderung eines bestehenden Objektes beschreibt eine Änderung der Umringsgeometrie in der Realwelt, ohne das eine fachliche Änderung auf Ebene der Objekt- oder Attributart stattfand.');
CREATE TABLE ax_artderfestlegung_anderefestlegungnachstrassenrecht (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_artderfestlegung_anderefestlegungnachstrassenrecht IS 'Alias: "AX_ArtDerFestlegung_AndereFestlegungNachStrassenrecht", UML-Typ: Enumeration';
INSERT INTO ax_artderfestlegung_anderefestlegungnachstrassenrecht (wert,beschreibung,dokumentation) VALUES
('1210', 'Bundesfernstraßengesetz', ''),
('1220', 'Anbauverbot', ''),
('1230', 'Anbauverbot nach Bundesfernstraßengesetz', ''),
('1231', 'Anbauverbot (40m)', ''),
('1232', 'Anbauverbot (20m)', ''),
('1240', 'Anbaubeschränkung', ''),
('1241', 'Anbaubeschränkung (100m)', ''),
('1242', 'Anbaubeschränkung (40m)', ''),
('1250', 'Veränderungssperre nach Bundesfernstraßengesetz', ''),
('1260', 'Landesstraßengesetz', ''),
('1270', 'Anbauverbot nach Landesstraßengesetz', ''),
('1280', 'Veränderungssperre', '');
CREATE TABLE ax_zustand_naturumweltoderbodenschutzrecht (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_naturumweltoderbodenschutzrecht IS 'Alias: "AX_Zustand_NaturUmweltOderBodenschutzrecht", UML-Typ: Enumeration';
INSERT INTO ax_zustand_naturumweltoderbodenschutzrecht (wert,beschreibung,dokumentation) VALUES
('1000', 'Amtlich festgestellt', 'Amtlich festgestellt bedeutet, dass der Zustand für eine dem Natur-, Umwelt- oder Bodenschutzrecht unterliegende Fläche durch eine Verwaltungsstelle festgelegt wird.'),
('2000', 'Einstweilig sicher gestellt', 'Einstweilig sicher gestellt bedeutet, dass durch die zuständige Fachbehörde eine dem Natur-, Umwelt- oder Bodenschutzrecht unterliegende Fläche eine Veränderungssperre erlassen wurde.');
CREATE TABLE ax_besonderefunktion_forstrecht (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_besonderefunktion_forstrecht IS 'Alias: "AX_BesondereFunktion_Forstrecht", UML-Typ: Enumeration';
INSERT INTO ax_besonderefunktion_forstrecht (wert,beschreibung,dokumentation) VALUES
('1000', 'Ohne besondere gesetzliche Bindung', ''),
('1010', 'Ohne besondere gesetzliche Bindung nach LWaldG- Holzboden', ''),
('2000', 'Schutzwald', ''),
('2010', 'Schutzwald - Holzboden', ''),
('3000', 'Erholungswald', ''),
('3010', 'Erholungswald - Holzboden', ''),
('4000', 'Bannwald', ''),
('4010', 'Nationalpark - Holzboden', ''),
('5010', 'Naturschutzgebiet - Holzboden', ''),
('6000', 'Schutz- und Erholungswald', ''),
('6010', 'Schutz- und Erholungswald - Holzboden', ''),
('7010', 'Nationalpark - Nichtholzboden', ''),
('8010', 'Naturschutzgebiet - Nichtholzboden', ''),
('9000', 'Andere Forstbetriebsfläche', ''),
('9010', 'Nichtholzboden', ''),
('9999', 'Sonstiges', '');
CREATE TABLE ax_artderfestlegung_klassifizierungnachwasserrecht (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_artderfestlegung_klassifizierungnachwasserrecht IS 'Alias: "AX_ArtDerFestlegung_KlassifizierungNachWasserrecht", UML-Typ: Enumeration';
INSERT INTO ax_artderfestlegung_klassifizierungnachwasserrecht (wert,beschreibung,dokumentation) VALUES
('1300', 'Klassifizierung nach Bundes- oder Landeswassergesetz', ''),
('1310', 'Gewässer I. Ordnung - Bundeswasserstraße', ''),
('1320', 'Gewässer I. Ordnung - nach Landesrecht', ''),
('1330', 'Gewässer II. Ordnung', ''),
('1340', 'Gewässer III. Ordnung', '');
CREATE TABLE ax_artderfestlegung_schutzgebietnachwasserrecht (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_artderfestlegung_schutzgebietnachwasserrecht IS 'Alias: "AX_ArtDerFestlegung_SchutzgebietNachWasserrecht", UML-Typ: Enumeration';
INSERT INTO ax_artderfestlegung_schutzgebietnachwasserrecht (wert,beschreibung,dokumentation) VALUES
('1510', 'Wasserschutzgebiet', 'Wasserschutzgebiet ist ein Schutzgebiet von Wassergewinnungsanlagen mit Nutzungsbeschränkungen, um ober- und unterirdisches Wasser vor Verunreinigungen zu schützen.'),
('1520', 'Heilquellenschutzgebiet', 'Heilquellenschutzgebiet ist ein Schutzgebiet, in dem Handlungen untersagt sind, die den Bestand oder die Beschaffenheit der staatlich anerkannten Heilquellen gefährden.');
CREATE TABLE ax_artderfestlegung_klassifizierungnachstrassenrecht (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_artderfestlegung_klassifizierungnachstrassenrecht IS 'Alias: "AX_ArtDerFestlegung_KlassifizierungNachStrassenrecht", UML-Typ: Enumeration';
INSERT INTO ax_artderfestlegung_klassifizierungnachstrassenrecht (wert,beschreibung,dokumentation) VALUES
('1100', 'Klassifizierung nach Bundes- oder Landesstraßengesetz', ''),
('1110', 'Bundesautobahn', ''),
('1120', 'Bundesstraße', ''),
('1130', 'Landes- oder Staatsstraße', ''),
('1140', 'Kreisstraße', ''),
('1150', 'Gemeindestraße', ''),
('1160', 'Ortsstraße', ''),
('1170', 'Gemeindeverbindungsstraße', ''),
('1180', 'Sonstige öffentliche Straße', ''),
('1190', 'Privatstraße', '');
CREATE TABLE ax_artderfestlegung_sonstigesrecht (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_artderfestlegung_sonstigesrecht IS 'Alias: "AX_ArtDerFestlegung_SonstigesRecht", UML-Typ: Enumeration';
INSERT INTO ax_artderfestlegung_sonstigesrecht (wert,beschreibung,dokumentation) VALUES
('4100', 'Luftverkehrsgesetz', ''),
('4110', 'Bauschutzbereich', ''),
('4120', 'Beschränkter Bauschutzbereich', ''),
('4200', 'Bundeskleingartengesetz', ''),
('4210', 'Dauerkleingarten', ''),
('4300', 'Berggesetz', ''),
('4301', 'Bodenbewegungsgebiet', 'Bodenbewegungsgebiet ist ein Gebiet, in dem sich die oberen Erdschichten auf Grund verschiedener Einflüsse (z.B. geologische Kräfte, Bergbau) lage- oder höhenmäßig verändern.'),
('4302', 'Bruchfeld', 'Bruchfeld ist ein durch Bergbau unterhöhltes Gebiet, das teilweise bereits eingebrochen ist oder sich in Absenkung befindet.'),
('4310', 'Baubeschränkung', ''),
('4400', 'Reichsheimstättengesetz', ''),
('4410', 'Reichsheimstätte', ''),
('4500', 'Schutzbereichsgesetz', ''),
('4510', 'Schutzbereich', ''),
('4600', 'Eisenbahnneuordnungsgesetz', ''),
('4610', 'Übergabebescheidverfahren', ''),
('4710', 'Baubeschränkungen durch Richtfunkverbindungen', ''),
('4720', 'Truppenübungsplatz, Standortübungsplatz', 'Truppenübungsplatz, Standortübungsplatz ist ein Gelände zur militärischen Ausbildung.'),
('4730', 'Militärbrache', 'Militärbrache ist eine ehemals militärisch genutzte Fläche, die aktuell nicht mehr militärisch genutzt wird.'),
('4800', 'Vermessungs- und Katasterrecht', ''),
('4810', 'Schutzfläche Festpunkt', ''),
('4811', 'Schutzfläche Festpunkt, 1 m Radius', ''),
('4812', 'Schutzfläche Festpunkt, 2 m Radius', ''),
('4813', 'Schutzfläche Festpunkt, 5 m Radius', ''),
('4814', 'Schutzfläche Festpunkt, 10 m Radius', ''),
('4815', 'Schutzfläche Festpunkt, 30 m Radius', ''),
('4820', 'Marksteinschutzfläche', ''),
('4830', 'Liegenschaftskatastererneuerung', ''),
('4900', 'Fischereirecht', ''),
('5100', 'Jagdkataster', ''),
('5200', 'Landesgrundbesitzkataster', ''),
('5300', 'Bombenblindgängerverdacht', ''),
('5400', 'Rieselfeld', 'Rieselfeld ist eine Fläche, auf der organisch verunreinigtes Wasser zum Zwecke der biologischen Reinigung verrieselt wird.'),
('5500', 'Sicherungsstreifen', ''),
('5600', 'Grenzbereinigung', ''),
('5700', 'Hochwasserdeich', 'Hochwasserdeich ist die Eigenschaft (Widmung) eines Deiches, die durch die obere Deichbehörde festgelegt wird.'),
('5710', 'Hauptdeich, 1. Deichlinie', 'Hauptdeich, 1. Deichlinie ist die Eigenschaft (Widmung) eines Deiches, die durch die obere Deichbehörde festgelegt wird.'),
('5720', '2. Deichlinie', '2. Deichlinie ist die Eigenschaft (Widmung) eines Deiches, die durch die obere Deichbehörde festgelegt wird.'),
('6000', 'Beregnungsverband', ''),
('7000', 'Weinlage', ''),
('7100', 'Weinbausteillage', ''),
('7200', 'Weinbergsrolle', ''),
('7300', 'Weinbausteilstlage', ''),
('8000', 'Benachteiligtes landwirtschaftliches Gebiet', ''),
('9100', 'Mitverwendung Hochwasserschutz, Oberirdische Anlagen', ''),
('9200', 'Mitverwendung Hochwasserschutz, Unterirdische Anlagen', ''),
('9300', 'Hafennutzungsgebiet', ''),
('9400', 'Hafenerweiterungsgebiet', ''),
('9450', 'Hafenbecken', 'Hafenbecken ist ein rechtlich definierter Teil eines Gewässers, in dem Schiffe be- und entladen werden'),
('9500', 'Bohrung verfüllt', ''),
('9600', 'Zollgrenze', ''),
('9700', 'Belastung nach §7 Abs. 2 GBO', ''),
('9999', 'Sonstiges', 'Sonstiges bedeutet, dass Art der Festlegung bekannt, aber nicht in der Attributwertliste aufgeführt ist.');
CREATE TABLE ax_rechtszustand_schutzzone (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_rechtszustand_schutzzone IS 'Alias: "AX_Rechtszustand_Schutzzone", UML-Typ: Enumeration';
INSERT INTO ax_rechtszustand_schutzzone (wert,beschreibung,dokumentation) VALUES
('1000', 'Amtlich festgestellt', 'Amtlich festgestellt bedeutet, dass der Zustand von Schutzzone durch einen Verwaltungsstelle festgelegt wird.'),
('2000', 'Im Verfahren befindlich', 'Im Verfahren befindlich bedeutet, dass das Genehmigungsverfahren für die Festlegung eines Wasserschutz-, Heilquellenschutzgebietes begonnen aber noch nicht abgeschlossen ist.'),
('3000', 'In Planung', 'In Planung bedeutet, dass ein Wasserschutz-, Heilquellenschutzgebiet geplant ist, aber das Genehmigungsverfahren noch nicht begonnen hat.');
CREATE TABLE ax_artderfestlegung_forstrecht (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_artderfestlegung_forstrecht IS 'Alias: "AX_ArtDerFestlegung_Forstrecht", UML-Typ: Enumeration';
INSERT INTO ax_artderfestlegung_forstrecht (wert,beschreibung,dokumentation) VALUES
('3900', 'Klassifizierung nach Bundes- oder Landeswaldgesetz', ''),
('3910', 'Staatswald Bund', ''),
('3920', 'Staatswald Land', ''),
('3930', 'Kommunalwald', ''),
('3940', 'Anstalts- und Stiftungswald', ''),
('3950', 'Anderer öffentlicher Wald', ''),
('3960', 'Privater Gemeinschaftswald', ''),
('3970', 'Großprivatwald', ''),
('3980', 'Kleinprivatwald', ''),
('3990', 'Anderer Privatwald', '');
CREATE TABLE ax_artderfestlegung_bauraumoderbodenordnungsrecht (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_artderfestlegung_bauraumoderbodenordnungsrecht IS 'Alias: "AX_ArtDerFestlegung_BauRaumOderBodenordnungsrecht", UML-Typ: Enumeration';
INSERT INTO ax_artderfestlegung_bauraumoderbodenordnungsrecht (wert,beschreibung,dokumentation) VALUES
('1700', 'Festlegung nach Baugesetzbuch - Allgemeines Städtebaurecht', ''),
('1710', 'Bebauungsplan', ''),
('1720', 'Veränderungssperre nach Baugesetzbuch', ''),
('1730', 'Vorkaufsrechtssatzung', ''),
('1740', 'Enteignungsverfahren', ''),
('1750', 'Umlegung nach dem BauGB', ''),
('1760', 'Bauland', ''),
('1770', 'Vereinfachte Umlegung', ''),
('1780', 'Vorhaben- und Erschließungsplan', ''),
('1790', 'Flächennutzungsplan', ''),
('1800', 'Festlegung nach Baugesetzbuch - Besonderes Städtebaurecht', ''),
('1810', 'Städtebauliche Entwicklungsmaßnahme', ''),
('1811', 'Städtebauliche Entwicklungsmaßnahme (Beschluss zu vorbereitenden Untersuchungen gefasst)', ''),
('1820', 'Erhaltungssatzung', ''),
('1821', 'Städtebauliches Erhaltungsgebiet', ''),
('1822', 'Soziales Erhaltungsgebiet', ''),
('1823', 'Erhaltungsgebiet zur städtebaulichen Umstrukturierung', ''),
('1824', 'Soziales Erhaltungsgebiet (Aufstellungsbeschluss gefasst)', ''),
('1830', 'Städtebauliche Gebote', ''),
('1840', 'Sanierung', ''),
('1841', 'Sanierung (Beschluss zu vorbereitenden Untersuchungen gefasst)', ''),
('1900', 'Wohnungsbauerleichterungsgesetz', ''),
('2100', 'Flurbereinigungsgesetz', ''),
('2110', 'Flurbereinigung (Par. 1 und 37 FlurbG)', ''),
('2115', 'Flurbereinigung nach Par. 1 in Kombination mit Par. 87 FlurbG', ''),
('2120', 'Vereinfachtes Flurbereinigungsverfahren (Par. 86 FlurbG)', ''),
('2130', 'Unternehmensflurbereinigung (nach Par. 87 oder 90 FlurbG)', ''),
('2140', 'Beschleunigtes Zusammenlegungsverfahren (Par. 91 FlurbG)', ''),
('2150', 'Freiwilliger Landtausch (Par. 103a FlurbG)', ''),
('2160', 'Verfahren nach dem Gemeinheitsteilungsgesetz', ''),
('2170', 'Verfahren nach dem Gemeinschaftswaldgesetz', ''),
('2180', 'Freiwilliger Nutzungstausch', ''),
('2190', 'Neuvermessungsgebiet innerhalb des Bodenordnungsgebietes', ''),
('2200', 'Verfahren nach dem Landwirtschaftsanpassungsgesetz', ''),
('2210', 'Flurneuordnung', ''),
('2220', 'Freiwilliger Landtausch (Par. 54 LwAnpG)', ''),
('2230', 'Bodenordnungsverfahren (Par. 56 LwAnpG)', ''),
('2240', 'Zusammenführung von Boden- und Gebäudeeigentum (Par. 64 LwAnpG)', ''),
('2300', 'Bodensonderungsgesetz', ''),
('2310', 'Unvermessenes Eigentum', ''),
('2320', 'Unvermessenes Nutzungsrecht', ''),
('2330', 'Ergänzende Bodenneuordnung', ''),
('2340', 'Komplexe Bodenneuordnung', ''),
('2400', 'Vermögenszuordnungsgesetz', ''),
('2410', 'Vermögenszuordnung nach Plan', ''),
('2411', 'Vermögenszuordnung nach dem Aufteilungsplan', ''),
('2412', 'Vermögenszuordnung nach dem Zuordnungsplan', ''),
('2500', 'Landesraumordnungsgesetz', ''),
('2510', 'Wasservorranggebiete', ''),
('2600', 'Bauordnung', ''),
('2610', 'Baulast', ''),
('2611', 'Begünstigende Baulast', ''),
('2612', 'Belastende Baulast', ''),
('2700', 'Grenzfeststellungsverfahren nach Hamb. Wassergesetz', ''),
('2800', 'Verkehrsflächenbereinigung', ''),
('2900', 'Verfahren nach dem hessischen Grenzbereinigungsgesetz', '');
CREATE TABLE ax_artderfestlegung_schutzgebietnachnaturumweltoderbodensc (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_artderfestlegung_schutzgebietnachnaturumweltoderbodensc IS 'Alias: "AX_ArtDerFestlegung_SchutzgebietNachNaturUmweltOderBodenschutzrecht", UML-Typ: Enumeration';
INSERT INTO ax_artderfestlegung_schutzgebietnachnaturumweltoderbodensc (wert,beschreibung,dokumentation) VALUES
('1670', 'Nationalpark', 'Nationalpark ist ein rechtsverbindlich festgesetztes einheitlich zu schützendes Gebiet, das großräumig und von besonderer Eigenart ist, im überwiegenden Teil die Voraussetzungen eines Naturschutzgebietes erfüllt und sich in einem vom Menschen nicht oder nur wenig beeinflussten Zustand befindet.'),
('1680', 'Lärmschutzbereich', ''),
('1690', 'Biosphärenreservat', 'Biosphärenreservat ist ein rechtsverbindlich festgesetztes einheitlich zu schützendes und zu entwickelndes Gebiet, das 
1. großräumig und für bestimmte Landschaftstypen charakteristisch ist, 
2. in wesentlichen Teilen seines Gebietes die Voraussetzungen eines Naturschutzgebietes, im Übrigen überwiegend eines Landschaftsschutzgebietes erfüllt, 
3. vornehmlich der Erhaltung, Entwicklung oder Wiederherstellung einer durch hergebrachte vielfältige Nutzung geprägten Landschaft und der darin historisch gewachsenen Arten- und Biotopvielfalt, einschließlich Wild- und frühere Kulturformen wirtschaftlich genutzter oder nutzbarer Tier- und Pflanzenarten dient und 
4. beispielhaft der Entwicklung und Erprobung von Naturgütern besonders schonenden Wirtschaftsweise dient.');
CREATE TABLE ax_art_verband (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_art_verband IS 'Alias: "AX_Art_Verband", UML-Typ: Enumeration';
INSERT INTO ax_art_verband (wert,beschreibung,dokumentation) VALUES
('1000', 'Planungsverband', ''),
('2000', 'Region', ''),
('9999', 'Sonstiges', '');
CREATE TABLE ax_behoerde (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_behoerde IS 'Alias: "AX_Behoerde", UML-Typ: Enumeration';
INSERT INTO ax_behoerde (wert,beschreibung,dokumentation) VALUES
('1000', 'Grundbuchamt', ''),
('1100', 'Katasteramt', ''),
('1200', 'Finanzamt', ''),
('1300', 'Flurbereinigungsbehörde', ''),
('1400', 'Forstamt', ''),
('1500', 'Wasserwirtschaftsamt', ''),
('1600', 'Straßenbauamt', ''),
('1700', 'Gemeindeamt', ''),
('1800', 'Landratsamt', ''),
('1900', 'Kreis- oder Stadtverwaltung', ''),
('2000', 'Wasser- und Bodenverband', ''),
('2100', 'Umlegungsstelle', ''),
('2200', 'Landesvermessungsverwaltung', 'Landesvermessungsverwaltung ist eine Fachstelle, die für die Aufgaben des amtlichen Vermessungswesens, insbesondere für die Landesvermessung und des Liegenschaftskatasters in einem Bundesland zuständig ist.'),
('2300', 'ÖbVI', ''),
('2400', 'Bundeseisenbahnvermögen', ''),
('2500', 'Landwirtschaftskammer', ''),
('2600', 'Bauaufsicht', ''),
('2700', 'Gutachterausschuss', ''),
('2800', 'Oberer Gutachterausschuss', '');
CREATE TABLE ax_bezeichnung_verwaltungsgemeinschaft (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_bezeichnung_verwaltungsgemeinschaft IS 'Alias: "AX_Bezeichnung_Verwaltungsgemeinschaft", UML-Typ: Enumeration';
INSERT INTO ax_bezeichnung_verwaltungsgemeinschaft (wert,beschreibung,dokumentation) VALUES
('1000', 'Samtgemeinde', 'Samtgemeinde umfasst in Niedersachsen das Gebiet einer Samtgemeinde.'),
('2000', 'Verbandsgemeinde', 'Verbandsgemeinde umfasst eine Gebietskörperschaft, die aus mehreren rechtlich selbständigen Ortsgemeinden bzw. Mitgliedsgemeinden besteht.'),
('3000', 'Amt', 'Amt umfasst das Gebiet eines Amtes, das aus Gemeinden desselben Landkreises besteht.'),
('9999', 'Sonstiges', '');
CREATE TABLE ax_rolledergemeinde (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_rolledergemeinde IS 'Alias: "AX_RolleDerGemeinde", UML-Typ: Enumeration';
INSERT INTO ax_rolledergemeinde (wert,beschreibung,dokumentation) VALUES
('5000', 'Gemeinde, die sich einer erfüllenden Gemeinde bedient', 'Gemeinde, die sich einer erfüllenden Gemeinde bedient umfasst in einem Bundesland das Gebiet einer Gemeinde, die sich einer erfüllenden Gemeinde bedient.'),
('6000', 'Erfüllende Gemeinde', 'Erfüllende Gemeinde umfasst in einem Bundesland das Gebiet einer erfüllende Gemeinde, welche in einer vereinbarten Verwaltungsgemeinschaft die Aufgaben des Gemeindeverwaltungsverbands erfüllt.');
CREATE TABLE ax_administrative_funktion (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_administrative_funktion IS 'Alias: "AX_Administrative_Funktion", UML-Typ: Enumeration';
INSERT INTO ax_administrative_funktion (wert,beschreibung,dokumentation) VALUES
('1001', 'Bundesrepublik', 'Bundesrepublik ist die Bezeichnung Deutschlands und ist aus der Gesamtheit der deutschen Länder (Gliedstaaten) gebildet.'),
('2001', 'Land', 'Land ist ein teilsouveräner Gliedstaat der Bundesrepublik Deutschland.'),
('2002', 'Freistaat', 'Freistaat ist ein teilsouveräner Gliedstaat der Bundesrepublik Deutschland (historisch gewachsene Bezeichnung für Land).'),
('2003', 'Freie und Hansestadt', 'Freie und Hansestadt ist eine historisch gewachsene Bezeichnung.'),
('3001', 'Regierungsbezirk', 'Regierungsbezirk ist ein Verwaltungsbezirk innerhalb eines Landes, welcher mehrere Stadt- und Landkreise umfasst.'),
('3002', 'Freie Hansestadt', 'Freie Hansestadt ist eine historisch gewachsene Bezeichnung.'),
('3003', 'Bezirk', 'Bezirk ist ein abgegrenztes Gebiet einer Stadt.'),
('3004', 'Stadt (Bremerhaven)', 'Stadt (Bremerhaven) ist die Bezeichnung der kreisfreien Stadt Bremerhaven.'),
('3005', 'Regierungsvertretung', 'Regierungsvertretung ist eine Bezeichung von Referaten des Niedersächsischen Ministeriums für Inneres und Sport.'),
('4001', 'Kreis', 'Kreis ist eine mehrere Gemeinden bzw. Städte umfassende kommunale Verwaltungseinheit.'),
('4002', 'Landkreis', 'Landkreis ist eine mehrere Gemeinden bzw. Städte umfassende kommunale Verwaltungseinheit.'),
('4003', 'Kreisfreie Stadt', 'Kreisfreie Stadt ist eine kommunale Verwaltungseinheit, die keinem Kreis oder Landkreis angehört.'),
('4007', 'Ursprünglich gemeindefreies Gebiet', ''),
('4008', 'Ortsteil', 'Ortsteil ist ein räumlich abgegrenzter Bereich einer Gemeinde.'),
('4009', 'Region', ''),
('5001', 'Verbandsgemeinde', 'Verbandsgemeinde ist eine kommunale Verwaltungskooperation zwischen Gemeinden.'),
('5002', 'Verbandsfreie Gemeinde', 'Verbandsfreie Gemeinde ist eine kreisangehörige Gebietskörperschaft, die keiner Verbandsgemeinde angehört.'),
('5003', 'Verwaltungsverband', 'Verwaltungsverband ist eine kommunale Verwaltungskooperation zwischen Gemeinden.'),
('5004', 'Große kreisangehörige Stadt', 'Große kreisangehörige Stadt ist eine kreisangehörige Stadt, die bestimmte Verwaltungsfunktionen vom Landkreis/Kreis übernimmt.

Hinweis: Unterscheidung zu 6013 Große kreisangehoerige Stadt aufgrund länderspezifischer Anforderungen.'),
('5006', 'Verwaltungsgemeinschaft', 'Verwaltungsgemeinschaft ist eine kommunale Verwaltungskooperation zwischen Gemeinden.'),
('5007', 'Amt', 'Amt ist eine kommunale Verwaltungskooperation zwischen Gemeinden.'),
('5008', 'Samtgemeinde', 'Samtgemeinde ist eine kommunale Verwaltungskooperation zwischen Gemeinden.'),
('5009', 'Gemeindeverwaltungsverband', 'Gemeindeverwaltungsverband ist eine kommunale Verwaltungskooperation zwischen Gemeinden.'),
('5012', 'Gemeinde, die sich einer erfüllenden Gemeinde bedient', 'Gemeinde, die sich einer erfüllenden Gemeinde bedient ist eine Gemeinde, die Verwaltungsfunktionen von einer anderen Gemeinde erfüllen lässt.'),
('5013', 'Erfüllende Gemeinde', 'Erfüllende Gemeinde ist eine Gemeinde, die Verwaltungsfunktionen für andere Gemeinden erfüllt.'),
('5014', 'Einheitsgemeinde', 'Einheitsgemeinde ist die Bezeichnung für eine bestimmte länderspezifische Form eines kommunalen Gemeindetyps in Deutschland.'),
('6001', 'Gemeinde', 'Gemeinde ist unterste selbständige Verwaltungseinheit.'),
('6002', 'Ortsgemeinde', 'Ortsgemeinde ist eine Gemeinde, die einer Verbandsgemeinde angehört.'),
('6003', 'Stadt', 'Stadt ist eine Gemeinde, die den Titel Stadt trägt.'),
('6004', 'Kreisangehörige Stadt', 'Kreisangehörige Stadt ist eine Stadt, die einem Landkreis/Kreis angehört.'),
('6005', 'Große Kreisstadt', 'Große Kreisstadt ist eine kreisangehörige Stadt, die bestimmte Verwaltungsfunktionen vom Landkreis/Kreis übernimmt.'),
('6006', 'Amtsangehörige Stadt', 'Amtsangehörige Stadt ist eine kreisangehörige Stadt, die einem Amt angehört.'),
('6007', 'Amtsangehörige Landgemeinde', 'Amtsangehörige Landgemeinde‘ ist eine kreisangehörige Gemeinde, die einem Amt angehört.'),
('6008', 'Amtsangehörige Gemeinde', 'Amtsangehörige Gemeinde ist eine kreisangehörige Gemeinde, die einem Amt angehört.'),
('6009', 'Kreisangehörige Gemeinde', 'Kreisangehörige Gemeinde ist eine Gemeinde, die einem Landkreis/Kreis angehört.'),
('6010', 'Mitgliedsgemeinde einer Verwaltungsgemeinschaft', 'Mitgliedsgemeinde einer Verwaltungsgemeinschaft ist eine kreisangehörige Gemeinde bzw. Stadt, die einer Verwaltungsgemeinschaft angehört.'),
('6011', 'Mitgliedsgemeinde', 'Mitgliedsgemeinde ist eine Gemeinde, die Teil einer Verwaltungskooperation ist.'),
('6012', 'Markt', 'Markt ist eine kreisangehörige Gemeinde, die den Titel Markt trägt.'),
('6013', 'Große kreisangehoerige Stadt', 'Große kreisangehoerige Stadt ist eine kreisangehörige Stadt, die bestimmte Verwaltungsfunktionen vom Landkreis/Kreis übernimmt.

Hinweis: Unterscheidung zu 5004 Große kreisangehörige Stadt aufgrund länderspezifischer Anforderungen.'),
('6014', 'Kreisangehörige Gemeinde, die die Bezeichnung Stadt führt', 'Kreisangehörige Gemeinde, die die Bezeichnung Stadt führt ist eine Gemeinde, die den Titel Stadt führt und einem Landkreis/Kreis angehört.'),
('6015', 'Gemeindefreies Gebiet', 'Gemeindefreies Gebiet ist ein Gebiet, das zu keiner Gemeinde gehört.'),
('6016', 'Gemeindefreier Bezirk', ''),
('6017', 'Landeshauptstadt', ''),
('6018', 'Bergstadt', ''),
('6019', 'Hansestadt', ''),
('6020', 'Inselgemeinde', ''),
('6021', 'Flecken', ''),
('7001', 'Gemeindeteil', 'Gemeindeteil ist ein räumlich abgetrennter Bereich einer Gemeinde.'),
('7003', 'Gemarkung', 'Gemarkung ist eine Flächeneinheit des Katasters.'),
('7004', 'Stadtteil', 'Stadtteil ist ein räumlich abgetrennter Bereich einer Stadt.'),
('7005', 'Stadtbezirk', 'Stadtbezirk ist ein abgegrenztes Gebiet einer Stadt.'),
('7007', 'Ortsteil (Gemeinde)', 'Ortsteil ist ein räumlich abgetrennter Bereich einer Gemeinde.'),
('8001', 'Kondominium', 'Kondominium ist ein Gebiet, welches unter der gemeinsamen Verwaltung mehrerer Staaten steht.');
CREATE TABLE ax_liniendarstellung_topographischelinie (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_liniendarstellung_topographischelinie IS 'Alias: "AX_Liniendarstellung_TopographischeLinie", UML-Typ: Enumeration';
INSERT INTO ax_liniendarstellung_topographischelinie (wert,beschreibung,dokumentation) VALUES
('1000', 'Durchgezogen', ''),
('2000', 'Lang gestrichelt', ''),
('3000', 'Kurz gestrichelt', '');
CREATE TABLE ax_darstellung_gebaeudeausgestaltung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_darstellung_gebaeudeausgestaltung IS 'Alias: "AX_Darstellung_Gebaeudeausgestaltung", UML-Typ: Enumeration';
INSERT INTO ax_darstellung_gebaeudeausgestaltung (wert,beschreibung,dokumentation) VALUES
('0251', 'Topographische Begrenzungslinie', ''),
('0252', 'Überdeckte topographische Begrenzungslinie', ''),
('1011', 'Hochhausbegrenzungslinie', ''),
('1012', 'Begrenzungslinie eines öffentlichen Gebäudes', ''),
('1013', 'Begrenzungslinie eines nicht öffentlichen Gebäudes', ''),
('1014', 'Offene Begrenzungslinie eines Gebäudes', ''),
('1016', 'Begrenzungslinie eines unterirdischen Gebäudes', ''),
('1041', 'Durchfahrt im Gebäude', ''),
('1042', 'Durchfahrt an überbauter Straße', ''),
('1043', 'Arkade', ''),
('1044', 'Freitreppe', ''),
('1045', 'Überdachung', ''),
('1046', 'Aufgeständertes Gebäude', ''),
('1047', 'Begrenzungslinie auskragendes Geschoss, aufgehendes Mauerwerk', ''),
('1048', 'Rampe', '');
CREATE TABLE ax_buchungsart_anlieger (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_buchungsart_anlieger IS 'Alias: "AX_Buchungsart_Anlieger", UML-Typ: Enumeration';
INSERT INTO ax_buchungsart_anlieger (wert,beschreibung,dokumentation) VALUES
('5200', 'Anliegerflurstück', 'Ein Flurstück dessen Teilflächen den anliegenden Flurstücken zugerechnet wird.'),
('5201', 'Anliegerweg', ''),
('5202', 'Anliegergraben', ''),
('5203', 'Anliegerwasserlauf, Anliegergewässer', '');
CREATE TABLE ax_wirtschaftsartgrundbuch (
  wert character varying,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_wirtschaftsartgrundbuch IS 'Alias: "AX_WirtschaftsartGrundbuch", UML-Typ: Enumeration';
INSERT INTO ax_wirtschaftsartgrundbuch (wert,beschreibung,dokumentation) VALUES
('Wohnbaufläche', NULL, 'Wohnbaufläche wird aggregiert aus der Nutzungsart 1100.'),
('Industrie- und Gewerbefläche', NULL, 'Industrie- und Gewerbefläche wird aggregiert aus den Nutzungsarten 1200 bis 1204, 1300 bis 1308, 1400 bis 1405 und 1500 bis 1505.'),
('Mischnutzung', NULL, 'Mischnutzung wird aggregiert aus den Nutzungsarten 1600 bis 1671 und 1700 bis 1702.'),
('Gebäude- und Freifläche Land- und Forstwirtschaft', NULL, 'Gebäude- und Freifläche Land- und Forstwirtschaft wird aggregiert aus der Nutzungsart 1672.'),
('Erholungsfläche', NULL, 'Erholungsfläche wird aggregiert aus den Nutzungsarten 1800 bis 1871.'),
('Friedhof', NULL, 'Friedhof wird aggregiert aus den Nutzungsarten 1900 bis 1971 und 3253.'),
('Verkehrsfläche', NULL, 'Verkehrsfläche wird aus den Nutzungsarten 2101 bis 2271, 2300 bis 2371 und 2400 bis 2471 aggregiert.'),
('Landwirtschaftsfläche', NULL, 'Landwirtschaftsfläche wird aggregiert aus den Nutzungsarten 3100 bis 3109.'),
('Waldfläche', NULL, 'Waldfläche wird aggregiert aus den Nutzungsarten 3200 bis 3203.'),
('Sonstige Vegetationsfläche', NULL, 'Sonstige Vegetationsfläche wird aggregiert aus den Nutzungsarten 3300, 3400, 3500 und 3600.'),
('Unland', NULL, 'Unland wird aggregiert aus den Nutzungsarten 3700 bis 3704.'),
('Wasserfläche', NULL, 'Wasserfläche wird aggregiert aus den Nutzungsarten 4100 bis 4104, 4200 und 4201, 4300 bis 4303, 4400 und 4401.');
CREATE TABLE ax_art_bereichzeitlich (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_art_bereichzeitlich IS 'Alias: "AX_Art_BereichZeitlich", UML-Typ: Enumeration';
INSERT INTO ax_art_bereichzeitlich (wert,beschreibung,dokumentation) VALUES
('1000', 'Stichtagsbezogen ohne Historie', 'Stichtagsbezogen ohne Historie selektiert die Differenzdaten zwischen letzter erfolgreicher Datenabgabe und Stichzeitpunkt, in der Sekundärdatenbank ist stets nur der aktuelle Stand der Daten verfügbar.'),
('1100', 'Stichtagsbezogen mit Historie', 'Stichtagsbezogen mit Historie selektiert die Differenzdaten zwischen letzter erfolgreicher Datenabgabe und Stichzeitpunkt, in der Sekundärdatenbank werden zumindest temporär auch untergegangene Objekte und Objektversionen vorgehalten.'),
('3000', 'Fallbezogen ohne Historie', 'Fallbezogen ohne Historie selektiert alle Änderungen zwischen letzter erfolgreicher Datenabgabe und Stichzeitpunkt, in der Sekundärdatenbank ist stets nur der aktuelle Stand der Daten verfügbar.'),
('3100', 'Fallbezogen mit Historie', 'Fallbezogen mit Historie selektiert alle Änderungen zwischen letzter erfolgreicher Datenabgabe und Stichzeitpunkt, in der Sekundärdatenbank werden zumindest temporär auch untergegangene Objekte und Objektversionen vorgehalten.');
CREATE TABLE ax_letzteabgabeart (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_letzteabgabeart IS 'Alias: "AX_LetzteAbgabeArt", UML-Typ: Enumeration';
INSERT INTO ax_letzteabgabeart (wert,beschreibung,dokumentation) VALUES
('1000', 'Zeitintervall', 'Standardabgabe: LAZ + Abgabeintervall'),
('1100', 'NBA auf Abruf', 'Zwischenabgabe: LAZ bis heute.'),
('2000', 'Wiederholungslauf', 'Identische Wiederholung des fehlerhaften Laufs: VAZ bis LAZ.'),
('2100', 'Aufholungslauf auf Abruf', 'Wiederholungslauf zuzüglich der Änderungsdaten bis heute: VAZ bis heute.'),
('2200', 'Aufholungslauf bis Intervallende', 'Zusammenfassung mehrerer Abgabeintervalle: VAZ bis Intervallende nach heute.');
CREATE TABLE ax_ausgabemedium_benutzer (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_ausgabemedium_benutzer IS 'Alias: "AX_Ausgabemedium_Benutzer", UML-Typ: Enumeration';
INSERT INTO ax_ausgabemedium_benutzer (wert,beschreibung,dokumentation) VALUES
('1000', 'Analog', 'Analog ist eine Abgabe der Daten in ausgedruckter Form.'),
('2000', 'CD-R', 'CD-R ist eine CD, die nur einmal bespielbar ist. (Compact Disc Recordable)'),
('3000', 'DVD', 'DVD ist ein CD ähnlicher Datenträger mit größerer Speicherkapazität.'),
('4000', 'E-Mail', 'E-Mail ist die Abgabe der Daten in einer briefähnlichen Nachricht auf elektronischem Weg in Computernetzwerken.');
CREATE TABLE ax_datenformat_benutzer (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_datenformat_benutzer IS 'Alias: "AX_Datenformat_Benutzer", UML-Typ: Enumeration';
INSERT INTO ax_datenformat_benutzer (wert,beschreibung,dokumentation) VALUES
('1000', 'NAS', 'NAS (Normbasierte Austauschschnittstelle) ist eine Datenschnittstelle zum Austausch von Geoinformationen, die im Rahmen der Modellierung des AAA-Modells definiert wurde.'),
('2000', 'DXF', 'DXF (Drawing Interchange Format) ist ein spezifiziertes Dateiformat zum CAD-Datenaustausch. Es enthält neben Geometrien und Fachinformationen auch Angaben für eine einfache graphische Darstellung.'),
('3000', 'TIFF', 'TIFF (Tagged Image File Format) ist ein Dateiformat zur verlustfreien Speicherung von Bilddaten.'),
('4000', 'GeoTIFF', 'GeoTIFF ist ein Dateiformat zur verlustfreien Speicherung von Bilddaten mit eingebetteten Informationen zur Georeferenzierung.'),
('5000', 'PDF', 'Das Portable Document Format (PDF) ist ein plattformunabhängiges Dateiformat für Dokumente, das vom Unternehmen Adobe Systems entwickelt wurde.'),
('6000', 'Shape', 'Shape ist ein von der Firma ESRI entwickeltes Format für Geodaten.');
CREATE TABLE ax_abgabeversion (
  wert character varying,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_abgabeversion IS 'Alias: "AX_Abgabeversion", UML-Typ: Enumeration';
INSERT INTO ax_abgabeversion (wert,beschreibung,dokumentation) VALUES
('6.0.1', NULL, ''),
('7.1.2', NULL, ''),
('6.0.0', NULL, '');
CREATE TABLE ax_verwendeteobjekte_abgeleitetehoehenlinie (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_verwendeteobjekte_abgeleitetehoehenlinie IS 'Alias: "AX_VerwendeteObjekte_AbgeleiteteHoehenlinie", UML-Typ: Enumeration';
INSERT INTO ax_verwendeteobjekte_abgeleitetehoehenlinie (wert,beschreibung,dokumentation) VALUES
('5200', 'DGM', ''),
('5210', 'DGM modifiziert', ''),
('5410', 'Punktwolke3D', ''),
('5420', 'Punkt3D', ''),
('5430', 'Stukturlinie3D', ''),
('5440', 'Fläche3D', '');
CREATE TABLE ax_verwendeteobjekte_dhmgitter (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_verwendeteobjekte_dhmgitter IS 'Alias: "AX_VerwendeteObjekte_DHMGitter", UML-Typ: Enumeration';
INSERT INTO ax_verwendeteobjekte_dhmgitter (wert,beschreibung,dokumentation) VALUES
('5200', 'DGM', ''),
('5210', 'DGM modifiziert', ''),
('5220', 'DOM', ''),
('5230', 'DOM modifiziert', ''),
('5410', 'Punktwolke3D', ''),
('5420', 'Punkt3D', ''),
('5430', 'Stukturlinie3D', ''),
('5440', 'Fläche3D', '');
CREATE TABLE ax_berechnungsmethode (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_berechnungsmethode IS 'Alias: "AX_Berechnungsmethode", UML-Typ: Enumeration';
INSERT INTO ax_berechnungsmethode (wert,beschreibung,dokumentation) VALUES
('5300', 'Einfache Mittelbildung', ''),
('5310', 'Gewichtete Mittelbildung', ''),
('5320', 'Gleitende Schrägebene', ''),
('5330', 'Prädiktion', ''),
('5340', 'Polynomansatz', ''),
('5350', 'Finite Elemente', ''),
('5360', 'Dreiecksvermaschung', '');
CREATE TABLE ax_auspraegung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_auspraegung IS 'Alias: "AX_Auspraegung", UML-Typ: Enumeration';
INSERT INTO ax_auspraegung (wert,beschreibung,dokumentation) VALUES
('5200', 'DGM', ''),
('5210', 'DGM modifiziert', ''),
('5220', 'DOM', ''),
('5230', 'DOM modifiziert', '');
CREATE TABLE ax_zustand_boeschungkliff (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_boeschungkliff IS 'Alias: "AX_Zustand_BoeschungKliff", UML-Typ: Enumeration';
INSERT INTO ax_zustand_boeschungkliff (wert,beschreibung,dokumentation) VALUES
('2400', 'Befestigt', ''),
('2500', 'Unbefestigt', '');
CREATE TABLE ax_art_dammwalldeich (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_art_dammwalldeich IS 'Alias: "AX_Art_DammWallDeich", UML-Typ: Enumeration';
INSERT INTO ax_art_dammwalldeich (wert,beschreibung,dokumentation) VALUES
('1910', 'Hochwasserdeich', 'Hochwasserdeich ist ein Deich an einem Fliessgewässer oder im Küstengebiet, der dem Schutz eines Gebietes vor Hochwasser oder gegen Sturmfluten dient.'),
('1920', 'Hauptdeich, Landesschutzdeich', 'Hauptdeich, Landesschutzdeich ist ein Deich der ersten Deichlinie zum Schutz der Küsten- und Inselgebiete gegen Sturmflut.'),
('1930', 'Überlaufdeich', 'Überlaufdeich ist ein Deich vor dem Hauptdeich, der in erster Linie dem Schutz landwirtschaftlich genutzter Flächen gegen leichte Sturmtiden dient und der bei höheren Sturmtiden überströmt wird.'),
('1940', 'Leitdeich', 'Leitdeich ist ein dammartiges Bauwerk im Watt, um strömendes Wasser in bestimmte Richtungen zu lenken und zum Schutz von Wasserläufen im Watt (Außentiefs) vor Versandung.'),
('1950', 'Polderdeich', 'Polderdeich ist ein vor dem Hauptdeich liegender Deich, der landwirtschaftlich nutzbares Land (z. B. Marschland) schützt.'),
('1960', 'Schlafdeich', 'Schlafdeich ist ein ehemaliger Hauptdeich, der infolge einer Vorverlegung der Deichlinie zu einem Binnendeich geworden ist und keine unmittelbare Schutzaufgabe mehr zu erfüllen hat.'),
('1970', 'Mitteldeich', 'Mitteldeich ist ein Deich der 2. Deichlinie, auch an größeren Flüssen. Er soll Überschwemmungen beim Bruch des Deiches der ersten Deichlinie verhindern.'),
('1980', 'Binnendeich', 'Binnendeich ist ein Deich an kleineren Wasserläufen, der Überschwemmungen durch ablaufendes Oberflächenwasser verhindern soll.'),
('1990', 'Wall', 'Wall ist ein meist künstlich aus Erde und Feldsteinen oder Torf errichtetes, langgestrecktes und schmales Landschaftselement, das oft ein- oder beidseitig von Aushubgräben begleitet wird und keinen nennenswerten Bewuchs trägt.'),
('1991', 'Wallkante, rechts', ''),
('1992', 'Wallkante, links', ''),
('1993', 'Wallmitte', ''),
('2000', 'Knick', 'Knick oder auch Wallhecke ist ein Wall, der mit Sträuchern in Heckenform und einzeln stehenden Bäumen bewachsen ist. Knicks sind landschaftsprägend und können der Grenzmarkierung, Einfriedung und dem Schutz gegen Winderosion dienen.'),
('2001', 'Knickkante, rechts', ''),
('2002', 'Knickkante, links', ''),
('2003', 'Knickmitte', ''),
('2010', 'Graben mit Wall, rechts', ''),
('2011', 'Graben mit Wall, links', ''),
('2012', 'Graben mit Knick, rechts', ''),
('2013', 'Graben mit Knick, links', '');
CREATE TABLE ax_funktion_dammwalldeich (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_dammwalldeich IS 'Alias: "AX_Funktion_DammWallDeich", UML-Typ: Enumeration';
INSERT INTO ax_funktion_dammwalldeich (wert,beschreibung,dokumentation) VALUES
('3001', 'Hochwasserschutz, Sturmflutschutz', 'Hochwasserschutz, Sturmflutschutz bedeutet, dass Damm, Wall, Deich dem Schutz vor Hochwasser bzw. Sturmflut dient.'),
('3002', 'Verkehrsführung', 'Verkehrsführung bedeutet, dass auf Damm, Wall, Deich ein Verkehrsweg verläuft.'),
('3003', 'Hochwasserschutz, Sturmflutschutz zugleich Verkehrsführung', 'Hochwasserschutz, Sturmflutschutz zugleich Verkehrsführung bedeutet, dass Damm, Wall, Deich dem Schutz vor Hochwasser dient und auf dem gleichzeitig ein Verkehrsweg verläuft.'),
('3004', 'Lärmschutz', 'Lärmschutz bedeutet, dass Damm, Wall, Deich dem Schutz vor Lärmemissionen dient.');
CREATE TABLE ax_zustand_hoehleneingang (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_hoehleneingang IS 'Alias: "AX_Zustand_Hoehleneingang", UML-Typ: Enumeration';
INSERT INTO ax_zustand_hoehleneingang (wert,beschreibung,dokumentation) VALUES
('2200', 'Verfallen, zerstört', 'Verfallen, zerstört bedeutet, dass sich der ursprüngliche Zustand von Höhleneingang durch menschliche oder zeitliche Einwirkungen so verändert hat, dass eine Nutzung nicht mehr möglich ist.'),
('4100', 'Offen', 'Offen bedeutet, dass Höhleneingang allgemein zugänglich ist.'),
('4200', 'Verschlossen', 'Verschlossen bedeutet, dass Höhleneingang nicht allgemein zugänglich ist.');
CREATE TABLE ax_ergebnisderueberpruefung_dammwalldeich (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_ergebnisderueberpruefung_dammwalldeich IS 'Alias: "AX_ErgebnisDerUeberpruefung_DammWallDeich", UML-Typ: Enumeration';
INSERT INTO ax_ergebnisderueberpruefung_dammwalldeich (wert,beschreibung,dokumentation) VALUES
('1000', 'Fehlerkorrektur', 'Fehlerkorrektur beschreibt dass eine Anpassung durchgeführt wurde, obwohl in der Realwelt keine tatsächliche Änderung stattgefunden hat.'),
('2000', 'Bestätigung des Ist-Zustandes', 'Bestätigung des Ist-Zustandes beschreibt, dass das Objekt zum Zeitpunkt einer Überprüfung als zutreffend ermittelt wurde.'),
('3000', 'Erfassung eines neuen Objektes', 'Erfassung eines neuen Objektes beschreibt, dass eine tatsächliche Änderungen in der Realwelt zur Neubildung des Objektes geführt haben. Das bedeutet, dass eine fachliche Änderung auf Ebene der Objekt- und/oder Attributart stattfand.'),
('4000', 'Geometrieveränderung eines bestehenden Objektes', 'Geometrieveränderung eines bestehenden Objektes beschreibt eine Änderung der Umringsgeometrie in der Realwelt, ohne das eine fachliche Änderung auf Ebene der Objekt- oder Attributart stattfand.');
CREATE TABLE ax_funktion_einschnitt (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_einschnitt IS 'Alias: "AX_Funktion_Einschnitt", UML-Typ: Enumeration';
INSERT INTO ax_funktion_einschnitt (wert,beschreibung,dokumentation) VALUES
('3002', 'Verkehrsführung', 'Verkehrsführung bedeutet, dass im Einschnitt ein Verkehrsweg verläuft.'),
('3004', 'Lärmschutz', 'Lärmschutz bedeutet, dass der Einschnitt, in dem gleichzeitig ein Verkehrsweg verläuft, dem Schutz vor Lärmemissionen dient.');
CREATE TABLE ax_ursprung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_ursprung IS 'Alias: "AX_Ursprung", UML-Typ: Enumeration';
INSERT INTO ax_ursprung (wert,beschreibung,dokumentation) VALUES
('1100', 'Natürlich entstanden', ''),
('1110', 'Künstlich entstanden', '');
CREATE TABLE ax_art_strukturlinie3d (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_art_strukturlinie3d IS 'Alias: "AX_Art_Strukturlinie3D", UML-Typ: Enumeration';
INSERT INTO ax_art_strukturlinie3d (wert,beschreibung,dokumentation) VALUES
('1100', 'Gewässerbegrenzung', 'Gewässerbegrenzung ist die Linie, welche ein Gewässer zum Ufer hin abgrenzt.'),
('1200', 'Geländekante, allgemein', 'Geländekante, allgemein ist die einzelne Kante unterschiedlich geneigter Geländeflächen und keine Obergruppe anderer Geländekanten.'),
('1210', 'Steilrand, Kliffkante', 'Steilrand, Kliffkante begrenzt den von der Brandung beständig abgetragenen Steilhang einer Küste.'),
('1220', 'Oberkante', 'Oberkante ist die obere Kante eines ZUSO Böschung, Kliff oder eines Bauwerkes wie z. B. Kai- oder Stützmauer.'),
('1230', 'Unterkante', 'Unterkante ist die untere Kante eines ZUSO Böschung, Kliff oder eines Bauwerkes wie z. B. Kai- oder Stützmauer.'),
('1240', 'Sonstige Begrenzungskante', 'Sonstige Begrenzungskante sind alle Kanten, die nicht anderen Kanten zugeordnet werden können (z. B. Trennschraffe).'),
('1250', 'Oberkante zugleich Unterkante', 'Oberkante zugleich Unterkante beschreibt den Wechsel der Böschungsneigung (Gefällewechsel) innerhalb von ZUSO Böschung, Kliff.'),
('1300', 'Geripplinie', 'Geripplinie ist eine Falllinie, welche zur Erfassung von Rücken und Mulden erforderlich ist.'),
('1310', 'Muldenlinie', 'Muldenlinie ist die tiefste Linie einer Mulde.'),
('1311', 'Wasserführende Muldenlinie', 'Wasserführende Muldenlinie ist die tiefste Linie einer Mulde, die Wasser führt.'),
('1320', 'Rückenlinie', 'Rückenlinie ist die höchste Linie bei lang gestreckten Bergrücken, welche die Wasserscheide bildet.'),
('1400', 'Bauwerksbegrenzungslinie', 'Bauwerksbegrenzungslinie ist die Linie, welche ein Bauwerk zur umliegenden Umgebung hin abgrenzt.'),
('1410', 'Brückenbegrenzungslinie', 'Brückenbegrenzungslinie ist die Linie, welche eine Brücke zur umliegenden Umgebung hin abgrenzt.'),
('1420', 'Tunnelbegrenzungslinie', 'Tunnelbegrenzungslinie ist die Linie, welche ein Tunnelportal zur umliegenden Umgebung hin abgrenzt.');
CREATE TABLE ax_datenerhebung3d (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_datenerhebung3d IS 'Alias: "AX_Datenerhebung3D", UML-Typ: Enumeration';
INSERT INTO ax_datenerhebung3d (wert,beschreibung,dokumentation) VALUES
('5000', 'Terrestrische Aufnahme', ''),
('5001', 'Terrestrisches Laserscanning', ''),
('5010', 'Interaktive photogrammetrische Datenerfassung', ''),
('5020', 'Airborne Laserscanning', ''),
('5021', 'Airborne Laserscanning, first pulse', ''),
('5022', 'Airborne Laserscanning, last pulse', ''),
('5030', 'Digitalisierung analoger Vorlagen', ''),
('5040', 'Bildkorrelation', ''),
('5060', 'Amtliche Festlegung', ''),
('9999', 'Sonstiges', '');
CREATE TABLE ax_li_processstep3d_description (
  wert character varying,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_li_processstep3d_description IS 'Alias: "AX_LI_ProcessStep3D_Description", UML-Typ: Enumeration';
INSERT INTO ax_li_processstep3d_description (wert,beschreibung,dokumentation) VALUES
('Erhebung', NULL, 'Erhebung beschreibt im Attribut stepDateTime den Erfassungszeitpunkt (Zeitpunkt der Messung).'),
('Berechnung', NULL, 'Berechnung beschreibt im Attribut stepDateTime den Auswertezeitpunkt.');
CREATE TABLE ax_art_flaeche3d (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_art_flaeche3d IS 'Alias: "AX_Art_Flaeche3D", UML-Typ: Enumeration';
INSERT INTO ax_art_flaeche3d (wert,beschreibung,dokumentation) VALUES
('1000', 'Aussparungsfläche', 'Aussparungsfläche ist eine Fläche, die bei der DHM-Bearbeitung nicht berücksichtigt wird.'),
('1010', 'DGM-Aussparungsfläche', 'DGM-Aussparungsfläche ist eine Fläche, die bei der DGM-Bearbeitung nicht berücksichtigt wird.'),
('1020', 'DOM-Aussparungsfläche', 'DOM-Aussparungsfläche ist eine Fläche, die bei der DOM-Bearbeitung nicht berücksichtigt wird.'),
('1030', 'Kartographische Aussparungsfläche', 'Kartographische Aussparungsfläche ist eine Fläche, die bei der kartographischen Bearbeitung nicht berücksichtigt wird.'),
('1040', 'Brückenbegrenzungsfläche', 'Brückenbegrenzungsfläche ist eine Fläche, die bei der Bearbeitung von Brücken-DGM berücksichtigt wird.');
CREATE TABLE ax_art_punkt3d (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_art_punkt3d IS 'Alias: "AX_Art_Punkt3D", UML-Typ: Enumeration';
INSERT INTO ax_art_punkt3d (wert,beschreibung,dokumentation) VALUES
('1010', 'Markanter Geländepunkt', 'Markanter Geländepunkt ist ein charakteristischer Höhenpunkt an markanten Geländestellen.'),
('1020', 'Kuppenpunkt', 'Kuppenpunkt ist ein charakteristischer Höhenpunkt an der höchsten Stelle einer rundlichen Einzelerhebung.'),
('1030', 'Kesselpunkt', 'Kesselpunkt ist ein charakteristischer Höhenpunkt an der tiefsten Stelle einer rundlichen Vertiefung.'),
('1040', 'Sattelpunkt', 'Sattelpunkt ist ein charakteristischer Höhenpunkt im Schnittpunkt einer Rücken und Muldenlinie.'),
('1100', 'Besonderer Höhenpunkt', 'Besonderer Höhenpunkt ist ein charakteristischer Höhenpunkt.'),
('1110', 'Höhenpunkt auf Wasserfläche', 'Höhenpunkt auf Wasserfläche ist ein charakteristischer Höhenpunkt auf einer Wasserfläche.'),
('1120', 'Wegepunkt', 'Wegepunkt ist ein charakteristischer Höhenpunkt auf einem Weg oder einer Straße.'),
('1210', 'Strukturiert erfasster Geländepunkt', 'Strukturiert erfasster Geländepunkt ist ein Geländepunkt, der nach einem bestimmten Kriterium erfasst wurde.'),
('1220', 'Gemessener Höhenlinienpunkt', 'Gemessener Höhenlinienpunkt ist ein gemessener Höhenpunkt innerhalb einer Höhenlinie.'),
('1230', 'Dynamisch gemessener Höhenprofilpunkt', 'Dynamisch gemessener Höhenlinienprofilpunkt ist ein gemessener Höhenpunkt innerhalb eines Höhenprofils.');
CREATE TABLE ax_art_punktwolke3d (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_art_punktwolke3d IS 'Alias: "AX_Art_Punktwolke3D", UML-Typ: Enumeration';
INSERT INTO ax_art_punktwolke3d (wert,beschreibung,dokumentation) VALUES
('1000', 'Unklassifizierte Punkte', 'Unklassifizierte Punkte sind nicht spezifizierte Höhenpunkte.'),
('1100', 'Geländepunkte, allgemein', 'Geländepunkte sind nicht näher spezifizierte Höhenpunkte auf dem Gelände als auch in trockengefallenen Gewässer-/Wattflächen.'),
('1110', 'Feinklassifizierte Geländepunkte', 'Feinklassifizierte Geländepunkte sind verifizierte Höhenpunkte auf dem Gelände als auch in trockengefallenen Gewässer-/Wattflächen.'),
('1120', 'Geländepunkte ohne Keller', 'Geländepunkte ohne Keller sind Höhenpunkte auf dem Gelände als auch in trockengefallenen Gewässer-/Wattflächen, die nicht in einem (Keller-)Abgang oder Lichtschacht liegen.'),
('1130', 'Gewässerpunkte', 'Gewässerpunkte sind nicht näher spezifizierte Höhenpunkte auf einem Gewässer.'),
('1200', 'Nicht-Geländepunkte, allgemein', 'Nicht-Geländepunkte sind nicht näher spezifizierte Höhenpunkte, die nicht auf dem Gelände liegen.'),
('1210', 'Tiefpunkte, Rauschen', 'Tiefpunkte sind nicht näher spezifizierte Höhenpunkte, die unterhalb des Geländes liegen und durch Fehlmessungen (Multipath-Effekt) entstanden sind.'),
('1220', 'Hochpunkte, Rauschen', 'Hochpunkte sind nicht näher spezifizierte Höhenpunkte, die kein Oberflächenobjekt beschreiben und durch Fehlmessungen (z. B.: Vögel, Nebel, Wolken, etc.) entstanden sind.'),
('1300', 'Bauwerkspunkte, allgemein', 'Bauwerkspunkte sind nicht näher spezifizierte Höhenpunkte auf einem Bauwerk.'),
('1310', 'Gebäudepunkte', 'Gebäudepunkte sind nicht näher spezifizierte Höhenpunkte auf einem Gebäude.'),
('1315', 'Gebäudeinstallationspunkte', 'Gebäudeinstallationspunkte sind Höhenpunkte, auf einer Gebäudeinstallation (z.B.: Antenne, Schornstein, etc.).'),
('1318', 'Kellerpunkte', 'Kellerpunkte sind Höhenpunkte, die in einem Keller-/Abgang oder Lichtschacht liegen.'),
('1320', 'Brückenpunkte', 'Brückenpunkte sind nicht näher spezifizierte Höhenpunkte auf einem Brückenbauwerk, die die eigentliche Brückenüberführung beschreiben.'),
('1325', 'Brückenfundamentpunkte', 'Brückenfundamentpunkte sind Höhenpunkte, die das Brückenfundament sowie Pfeiler und Widerlager beschreiben.'),
('1330', 'Wasserbauwerkspunkte', 'Wasserbauwerkspunkte sind Höhenpunkte, die ein Wasserbauwerk wie z. B. Buhnen, Parallelwerke, Leitdämme, nicht bewegliche Bauteile von Anlegebrücken, Sperrwerken und Schleusen, Wehre, Leuchtfeuer, etc. beschreiben.'),
('1340', 'Straßenpunkte', 'Straßenpunkte sind nicht näher spezifizierte Höhenpunkte auf einer Straße.'),
('1350', 'Bahnkörperpunkte', 'Bahnkörperpunkte sind nicht näher spezifizierte Höhenpunkte auf einem Bahnkörper (Schotterung).'),
('1400', 'Vegetationspunkte, allgemein', 'Vegetationspunkte sind nicht näher spezifizierte Höhenpunkte auf der Vegetation.'),
('1401', 'Vegetationspunkte, niedrige Vegetation', 'Vegetationspunkte, niedrige Vegetation sind nicht näher spezifizierte Höhenpunkte auf der Vegetation mit einer Höhe bis 1,5 Meter über dem Gelände.'),
('1402', 'Vegetationspunkte, mittel hohe Vegetation', 'Vegetationspunkte, mittelhohe Vegetation sind nicht näher spezifizierte Höhenpunkte auf der Vegetation mit einer Höhe ab 1,5 Meter bis 8 Meter über dem Gelände.'),
('1403', 'Vegetationspunkte, hohe Vegetation', 'Vegetationspunkte, hohe Vegetation sind nicht näher spezifizierte Höhenpunkte auf der Vegetation mit einer Höhe ab 8 Meter über dem Gelände.'),
('1500', 'Energieversorgungspunkte, allgemein', 'Energieversorgungspunkte sind nicht näher spezifizierte Höhenpunkte auf einem Energieversorgungsobjekt.'),
('1501', 'Leitungsschutzpunkte', 'Leitungsschutzpunkte sind Höhenpunkte auf einem Leitungsschutz.'),
('1502', 'Leitungsdrahtpunkte', 'Leitungsdrahtpunkte sind Höhenpunkte auf einem Leitungsdraht.'),
('1503', 'Fernleitungsmastpunkte', 'Fernleitungsmastpunkte sind Höhenpunkte auf einem Fernleitungsmast.'),
('1504', 'Fernleitungsinfrastrukturpunkte', 'Fernleitungsinfrastrukturpunkte sind nicht näher spezifizierte Höhenpunkte auf einem Fernleitungsinfrastrukturobjekt wie z. B. einem Isolator, etc.');
CREATE TABLE ax_weiterenutzung_tatsaechlichenutzung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_weiterenutzung_tatsaechlichenutzung IS 'Alias: "AX_WeitereNutzung_TatsaechlicheNutzung", UML-Typ: Enumeration';
INSERT INTO ax_weiterenutzung_tatsaechlichenutzung (wert,beschreibung,dokumentation) VALUES
('1000', 'Überlagernd', 'Überlagernd beschreibt die Überlagerung des Objektes zu weiteren Objekten der Tatsächlichen Nutzung.');
CREATE TABLE ax_ergebnisderueberpruefung_tatsaechlichenutzung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_ergebnisderueberpruefung_tatsaechlichenutzung IS 'Alias: "AX_ErgebnisDerUeberpruefung_TatsaechlicheNutzung", UML-Typ: Enumeration';
INSERT INTO ax_ergebnisderueberpruefung_tatsaechlichenutzung (wert,beschreibung,dokumentation) VALUES
('1000', 'Fehlerkorrektur', 'Fehlerkorrektur beschreibt dass eine Anpassung durchgeführt wurde, obwohl in der Realwelt keine tatsächliche Änderung stattgefunden hat.'),
('2000', 'Bestätigung des Ist-Zustandes', 'Bestätigung des Ist-Zustandes beschreibt, dass das Objekt zum Zeitpunkt einer Überprüfung als zutreffend ermittelt wurde.'),
('3000', 'Erfassung eines neuen Objektes', 'Erfassung eines neuen Objektes beschreibt, dass eine tatsächliche Änderung in der Realwelt zur Neubildung des Objektes geführt hat. Das bedeutet, dass eine fachliche Änderung auf Ebene der Objekt- und/oder Attributart stattfand.'),
('4000', 'Geometrieveränderung eines bestehenden Objektes', 'Geometrieveränderung eines bestehenden Objektes beschreibt eine Änderung der Umringsgeometrie in der Realwelt, ohne das eine fachliche Änderung auf Ebene der Objekt- oder Attributart stattfand.');
CREATE TABLE ax_hydrologischesmerkmal_gewaesserachse (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_hydrologischesmerkmal_gewaesserachse IS 'Alias: "AX_HydrologischesMerkmal_Gewaesserachse", UML-Typ: Enumeration';
INSERT INTO ax_hydrologischesmerkmal_gewaesserachse (wert,beschreibung,dokumentation) VALUES
('2000', 'Nicht ständig Wasser führend', 'Nicht ständig Wasser führend heißt, dass ein Gewässer nicht ganzjährig Wasser führt.'),
('3000', 'Trocken, versiegt', 'Trocken, versiegt heißt, dass ein Gewässerbett ganzjährig kein Wasser führt.');
CREATE TABLE ax_funktion_stehendesgewaesser (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_stehendesgewaesser IS 'Alias: "AX_Funktion_StehendesGewaesser", UML-Typ: Enumeration';
INSERT INTO ax_funktion_stehendesgewaesser (wert,beschreibung,dokumentation) VALUES
('8610', 'See', 'See ist eine natürliche oder künstlich angelegte, größere, stehende oder nahezu stehende Wasserfläche, die im allgemeinen Sprachgebrauch als See anzusehen ist.'),
('8620', 'Teich', 'Teich ist eine natürliche oder künstlich angelegte, stehende oder nahezu stehende Wasserfläche, die im allgemeinen Sprachgebrauch als Teich anzusehen ist.'),
('8630', 'Stausee', 'Stausee ist eine mit Wasser gefüllte, allseitig umschlossene Hohlform der Landoberfläche ohne unmittelbaren Zusammenhang mit Meer.'),
('8631', 'Speicherbecken', 'Speicherbecken ist eine zeitweise mit Wasser gefüllte, allseitig umschlossene Hohlform der Landoberfläche ohne unmittelbaren Zusammenhang mit Meer'),
('8640', 'Baggersee', 'Baggersee ist ein künstlich geschaffenes Gewässer, aus dem Bodenmaterial gefördert wird oder wurde.'),
('9999', 'Sonstiges', 'Sonstiges bedeutet, dass die Funktion des Stehenden Gewässers bekannt, aber nicht in der Werteliste aufgeführt ist.');
CREATE TABLE ax_funktion_meer (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_meer IS 'Alias: "AX_Funktion_Meer", UML-Typ: Enumeration';
INSERT INTO ax_funktion_meer (wert,beschreibung,dokumentation) VALUES
('8710', 'Küstengewässer', 'Küstengewässer ist die Fläche zwischen der Küstenlinie bei mittlerem Hochwasser oder der seewärtigen Begrenzung der oberirdischen Gewässer und der seewärtigen Begrenzung des deutschen Hoheitsgebietes. Dem mittleren Hochwasser ist der mittlere Wasserstand der Ostsee gleichzusetzen.');
CREATE TABLE ax_funktion_fliessgewaesser (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_fliessgewaesser IS 'Alias: "AX_Funktion_Fliessgewaesser", UML-Typ: Enumeration';
INSERT INTO ax_funktion_fliessgewaesser (wert,beschreibung,dokumentation) VALUES
('8200', 'Fluss', 'Fluss ist ein natürliches, fließendes Gewässer (ggf. auch mit begradigten, kanalisierten Teilstücken), das wegen seiner Größe und Bedeutung im allgemeinen Sprachgebrauch als Fluss angesprochen wird.'),
('8210', 'Altwasser', 'Altwasser ist ein Teil eines Fließgewässers, der bei einer Begradigung vom fließenden Gewässer abgeschnitten wurde und wichtiger Lebensraum für z. B. Wasser-vögel, Amphibien und Libellen ist.'),
('8220', 'Altarm', 'Altarm bezeichnet eine an einem Ende des Fließgewässers abgeschnittene Strecke eines Flusses.'),
('8230', 'Flussmündungstrichter', 'Flussmündungstrichter ist der Bereich des Flusses im Übergang zum Meer. Er beginnt dort, wo die bis dahin etwa parallel verlaufenden Ufer des Flusses sich trichterförmig zur offenen See hin erweitern. Die Abgrenzungen der Flussmündungstrichter ergeben sich aus dem Bundeswasserstraßengesetz (meerseitig) und den Bekanntmachungen der Wasser- und Schifffahrtsverwaltung sowie höchst-richterlicher Rechtsprechung (binnenseitig).'),
('8300', 'Kanal', 'Kanal bezeichnet einen künstlich angelegten Wasserlauf.'),
('8400', 'Graben', 'Graben ist ein ständig oder zeitweise fließendes, künstlich angelegtes oder natürliches Gewässer, das im allgemeinen Sprachgebrauch als Graben anzusehen ist.'),
('8410', 'Fleet', 'Fleet ist die Bezeichnung für eine noch vorhandene, aber stark veränderte oder überhaupt erst künstlich angelegte Wasserverbindung in Hamburg sowie in Bremen - ehemals für einen marschtypischen Entwässerungsgraben genutzte Bezeichnung.'),
('8500', 'Bach', 'Bach ist ein natürliches, fließendes Gewässer, das wegen seiner geringen Größe und Bedeutung im allgemeinen Sprachgebrauch als Bach anzusehen ist.');
CREATE TABLE ax_nutzung_hafenbecken (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_nutzung_hafenbecken IS 'Alias: "AX_Nutzung_Hafenbecken", UML-Typ: Enumeration';
INSERT INTO ax_nutzung_hafenbecken (wert,beschreibung,dokumentation) VALUES
('1000', 'Zivil', 'Zivil bedeutet, dass Hafenbecken privaten oder öffentlichen Zwecken dient und nicht militärisch genutzt wird.'),
('2000', 'Militärisch', 'Militärisch bedeutet, dass Hafenbecken nur von Streitkräften genutzt wird.'),
('3000', 'Teils zivil, teils militärisch', 'Teils zivil, teils militärisch bedeutet, dass Hafenbecken sowohl zivil als auch militärisch genutzt wird.');
CREATE TABLE ax_tidemerkmal_meer (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_tidemerkmal_meer IS 'Alias: "AX_Tidemerkmal_Meer", UML-Typ: Enumeration';
INSERT INTO ax_tidemerkmal_meer (wert,beschreibung,dokumentation) VALUES
('1000', 'Mit Tideeinfluss', 'Mit Tideeinfluss sind periodische Änderungen des Wasserspiegels und horizontale Bewegungen des Wassers, hervorgerufen durch die Massenanziehungs- und Fliehkräfte des Systems Sonne, Mond und Erde in Verbindung mit der Erdrotation.');
CREATE TABLE ax_hydrologischesmerkmal_fliessgewaesser (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_hydrologischesmerkmal_fliessgewaesser IS 'Alias: "AX_HydrologischesMerkmal_Fliessgewaesser", UML-Typ: Enumeration';
INSERT INTO ax_hydrologischesmerkmal_fliessgewaesser (wert,beschreibung,dokumentation) VALUES
('2000', 'Nicht ständig Wasser führend', 'Nicht ständig Wasser führend heißt, dass ein Gewässer nicht ganzjährig Wasser führt.');
CREATE TABLE ax_widmung_stehendesgewaesser (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_widmung_stehendesgewaesser IS 'Alias: "AX_Widmung_StehendesGewaesser", UML-Typ: Enumeration';
INSERT INTO ax_widmung_stehendesgewaesser (wert,beschreibung,dokumentation) VALUES
('1310', 'Gewässer I. Ordnung - Bundeswasserstraße', 'Gewässer I. Ordnung - Bundeswasserstraße ist ein Gewässer, das der Zuständigkeit des Bundes obliegt.'),
('1320', 'Gewässer I. Ordnung - nach Landesrecht', 'Gewässer I. Ordnung - nach Landesrecht ist ein Gewässer, das der Zuständigkeit des Landes obliegt.'),
('1330', 'Gewässer II. Ordnung', 'Gewässer II. Ordnung ist ein Gewässer, für das die Unterhaltungsverbände zuständig sind.'),
('1340', 'Gewässer III. Ordnung', 'Gewässer III. Ordnung ist ein Gewässer, das weder zu den Gewässern I. noch II. Ordnung zählt.');
CREATE TABLE ax_zustand_gewaesserachse (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_gewaesserachse IS 'Alias: "AX_Zustand_Gewaesserachse", UML-Typ: Enumeration';
INSERT INTO ax_zustand_gewaesserachse (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb, stillgelegt, verlassen', 'Außer Betrieb, stillgelegt, verlassen bedeutet, dass sich der Kanal nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('4000', 'Im Bau', 'Im Bau bedeutet, dass der Kanal noch nicht fertiggestellt ist.');
CREATE TABLE ax_funktion_hafenbecken (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_hafenbecken IS 'Alias: "AX_Funktion_Hafenbecken", UML-Typ: Enumeration';
INSERT INTO ax_funktion_hafenbecken (wert,beschreibung,dokumentation) VALUES
('8810', 'Sportboothafenbecken', 'Sportboothafenbecken sind Wasserflächen, die dem Anlegen und Festmachen von Sportbooten dienen.');
CREATE TABLE ax_zustand_stehendesgewaesser (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_stehendesgewaesser IS 'Alias: "AX_Zustand_StehendesGewaesser", UML-Typ: Enumeration';
INSERT INTO ax_zustand_stehendesgewaesser (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb, stillgelegt', 'Außer Betrieb, stillgelegt bedeutet, dass sich die Fläche nicht mehr in regelmäßiger, der Bestimmung entsprechender Nutzung befindet.'),
('8000', 'Erweiterung, Neuansiedlung', 'Erweiterung, Neuansiedlung bedeutet, dass die Fläche in ihrer Nutzung gemäß der Objektart erweitert wird und eine Fertigstellung absehbar ist.');
CREATE TABLE ax_hydrologischesmerkmal_stehendesgewaesser (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_hydrologischesmerkmal_stehendesgewaesser IS 'Alias: "AX_HydrologischesMerkmal_StehendesGewaesser", UML-Typ: Enumeration';
INSERT INTO ax_hydrologischesmerkmal_stehendesgewaesser (wert,beschreibung,dokumentation) VALUES
('2000', 'Nicht ständig Wasser führend', 'Nicht ständig Wasser führend heißt, dass ein Gewässer nicht ganzjährig Wasser führt.');
CREATE TABLE ax_schifffahrtskategorie_kanal (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_schifffahrtskategorie_kanal IS 'Alias: "AX_Schifffahrtskategorie_Kanal", UML-Typ: Enumeration';
INSERT INTO ax_schifffahrtskategorie_kanal (wert,beschreibung,dokumentation) VALUES
('1000', 'Binnenwasserstraße', 'Binnenwasserstraße ist ein oberirdisches Gewässer oder Küstengewässer, das gesetzlich für den Personen- und/oder Güterverkehr mit Schiffen bestimmt ist. Binnengewässer im Küstengebiet sind gegen das Küstengewässer gesetzlich abgegrenzt. Die Binnenwasserstraße ist ein Gewässer 1. Ordnung.'),
('2000', 'Seewasserstraße', 'Seewasserstraße ist ein als Wasserstraße gesetzlich festgelegter Teil eines Küstengewässers. Die Seewasserstraße ist ein Gewässer 1. Ordnung.'),
('3000', 'Landesgewässer mit Verkehrsordnung', 'Landesgewässer mit Verkehrsordnung ist eine Wasserstraße, die keine Binnenwasserstraße ist. Die Schiffbarkeit wird durch eine Landesverkehrsordnung geregelt. Das Landesgewässer mit Verkehrsordnung ist ein Gewässer 1. Ordnung.');
CREATE TABLE ax_zustand_kanal (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_kanal IS 'Alias: "AX_Zustand_Kanal", UML-Typ: Enumeration';
INSERT INTO ax_zustand_kanal (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb, stillgelegt, verlassen', 'Außer Betrieb, stillgelegt, verlassen bedeutet, dass sich der Kanal nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('4000', 'Im Bau', 'Im Bau bedeutet, dass der Kanal noch nicht fertiggestellt ist.');
CREATE TABLE ax_widmung_wasserlauf (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_widmung_wasserlauf IS 'Alias: "AX_Widmung_Wasserlauf", UML-Typ: Enumeration';
INSERT INTO ax_widmung_wasserlauf (wert,beschreibung,dokumentation) VALUES
('1310', 'Gewässer I. Ordnung - Bundeswasserstraße', 'Gewässer I. Ordnung - Bundeswasserstraße ist ein Gewässer, das der Zuständigkeit des Bundes obliegt.'),
('1320', 'Gewässer I. Ordnung - nach Landesrecht', 'Gewässer I. Ordnung - nach Landesrecht ist ein Gewässer, das der Zuständigkeit des Landes obliegt.'),
('1330', 'Gewässer II. Ordnung', 'Gewässer II. Ordnung ist ein Gewässer, für das die Unterhaltungsverbände zuständig sind.'),
('1340', 'Gewässer III. Ordnung', 'Gewässer III. Ordnung ist ein Gewässer, das weder zu den Gewässern I. noch II. Ordnung zählt.');
CREATE TABLE ax_widmung_kanal (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_widmung_kanal IS 'Alias: "AX_Widmung_Kanal", UML-Typ: Enumeration';
INSERT INTO ax_widmung_kanal (wert,beschreibung,dokumentation) VALUES
('1310', 'Gewässer I. Ordnung - Bundeswasserstraße', 'Gewässer I. Ordnung -Bundeswasserstraße ist ein Gewässer, das der Zuständigkeit des Bundes obliegt.'),
('1320', 'Gewässer I. Ordnung - nach Landesrecht', 'Gewässer I. Ordnung - nach Landesrecht ist ein Gewässer, das der Zuständigkeit des Landes obliegt.'),
('1330', 'Gewässer II. Ordnung', 'Gewässer II. Ordnung ist ein Gewässer, für das die Unterhaltungsverbände zuständig sind.'),
('1340', 'Gewässer III. Ordnung', 'Gewässer III. Ordnung ist ein Gewässer, das weder zu den Gewässern I. noch II. Ordnung zählt.');
CREATE TABLE ax_funktion_gewaesserachse (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_gewaesserachse IS 'Alias: "AX_Funktion_Gewaesserachse", UML-Typ: Enumeration';
INSERT INTO ax_funktion_gewaesserachse (wert,beschreibung,dokumentation) VALUES
('8300', 'Kanal', 'Kanal ist ein für die Schifffahrt angelegter künstlicher Wasserlauf.');
CREATE TABLE ax_nutzung_stehendesgewaesser (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_nutzung_stehendesgewaesser IS 'Alias: "AX_Nutzung_StehendesGewaesser", UML-Typ: Enumeration';
INSERT INTO ax_nutzung_stehendesgewaesser (wert,beschreibung,dokumentation) VALUES
('1000', 'Trinkwasser', 'Trinkwasser im vorliegenden Sinne bezeichnet Wasser, das für den menschlichen Genuss geeignet ist.'),
('2000', 'Energie', 'Energie weist die Nutzung eines Stehenden Gewässers zur Energiegewinnung aus.'),
('3000', 'Brauchwasser', 'Brauchwasser dient spezifischen technischen, gewerblichen, industriellen, landwirtschaftlichen, hauswirtschaftlichen oder ähnlichen Zwecken, ohne dass hierfür Trinkwasserqualität verlangt wird. Hierzu zählen z B. Kesselspeisewasser, Kühlwasser, unterschiedlich aufbereitetes Rohwasser.');
CREATE TABLE ax_schifffahrtskategorie (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_schifffahrtskategorie IS 'Alias: "AX_Schifffahrtskategorie", UML-Typ: Enumeration';
INSERT INTO ax_schifffahrtskategorie (wert,beschreibung,dokumentation) VALUES
('1000', 'Binnenwasserstraße', 'Binnenwasserstraße ist ein oberirdisches Gewässer oder Küstengewässer, das gesetzlich für den Personen- und/oder Güterverkehr mit Schiffen bestimmt ist. Binnengewässer im Küstengebiet sind gegen das Küstengewässer gesetzlich abgegrenzt. Die Binnenwasserstraße ist ein Gewässer 1. Ordnung.'),
('2000', 'Seewasserstraße', 'Seewasserstraße ist ein als Wasserstraße gesetzlich festgelegter Teil eines Küstengewässers. Die Seewasserstraße ist ein Gewässer 1. Ordnung.'),
('3000', 'Landesgewässer mit Verkehrsordnung', 'Landesgewässer mit Verkehrsordnung ist eine Wasserstraße, die keine Binnenwasserstraße ist. Die Schiffbarkeit wird durch eine Landesverkehrsordnung geregelt. Das Landesgewässer mit Verkehrsordnung ist ein Gewässer 1. Ordnung.');
CREATE TABLE ax_abbaugut_bergbaubetrieb (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_abbaugut_bergbaubetrieb IS 'Alias: "AX_Abbaugut_Bergbaubetrieb", UML-Typ: Enumeration';
INSERT INTO ax_abbaugut_bergbaubetrieb (wert,beschreibung,dokumentation) VALUES
('1000', 'Erden, Lockergestein', 'Erden, Lockergestein bedeutet, dass feinkörnige Gesteine abgebaut werden.'),
('1001', 'Ton', 'Ton ist ein Abbaugut, das aus gelblichem bis grauem Lockergestein besteht und durch Verwitterung älterer Gesteine entsteht.'),
('1003', 'Kaolin', 'Kaolin ist ein Abbaugut, das aus weißem, erdigem Gestein, fast reinem Aluminiumsilikat (kieselsaure Tonerde) besteht.'),
('1007', 'Kalk, Kalktuff, Kreide', 'Kalk, Kalktuff, Kreide ist ein Abbaugut, das aus erdigem weißen Kalkstein besteht.'),
('2000', 'Steine, Gestein, Festgestein', 'Steine, Gestein, Festgestein bedeutet, dass grobkörnige oder feste Gesteine abgebaut werden.'),
('2002', 'Schiefer, Dachschiefer', 'Schiefer, Dachschiefer ist ein toniges Abbaugut, das in dünne ebene Platten spaltbar ist.'),
('2003', 'Metamorpher Schiefer', 'Metamorpher Schiefer ist ein Abbaugut, dessen ursprüngliche Zusammensetzung und Struktur durch Wärme und Druck innerhalb der Erdkruste verändert worden ist.'),
('2005', 'Kalkstein', 'Kalkstein ist ein Abbaugut, das als weit verbreitetes Sedimentgestein überwiegend aus Calciumcarbonat besteht.'),
('2006', 'Dolomitstein', 'Dolomitstein ist ein Abbaugut, das überwiegend aus calcium- und magnesiumhaltigen Mineralien besteht.'),
('2013', 'Basalt, Diabas', 'Basalt, Diabas ist ein Abbaugut, das aus basischem Ergussgestein besteht.'),
('2021', 'Talkschiefer, Speckstein', 'Talkschiefer, Speckstein ist ein farbloses bis graugrünes, sich fettig anfühlendes Abbaugut, das aus dem weichen Mineral Talk besteht.'),
('3000', 'Erze', 'Erze bedeutet, dass die in der Natur vorkommenden, metallhaltigen Mineralien und Mineralgemische abgebaut oder gespeichert werden.'),
('3001', 'Eisen', 'Eisen wird als Eisenerz abgebaut und durch Verhüttung gewonnen.'),
('3002', 'Buntmetallerze', 'Buntmetallerze ist das Abbaugut, das alle Nichteisenmetallerze als Sammelbegriff umfasst.'),
('3003', 'Kupfer', 'Kupfer wird als Kupfererz abgebaut und durch Verhüttung gewonnen.'),
('3005', 'Zink', 'Zink wird als Zinkerz abgebaut und durch spezielle Verfahren gewonnen.'),
('3006', 'Zinn', 'Zinn wird als Zinnerz abgebaut und durch spezielle Verfahren gewonnen.'),
('3007', 'Wismut, Kobalt, Nickel', 'Wismut, Kobalt, Nickel werden als Erze abgebaut und durch spezielle Verfahren gewonnen.'),
('3008', 'Uran', 'Uran wird als Uranerz abgebaut und durch spezielle Verfahren gewonnen.'),
('3009', 'Mangan', 'Mangan wird als Manganerz abgebaut und durch spezielle Verfahren gewonnen.'),
('3011', 'Edelmetallerze', 'Edelmetallerze ist das Abbaugut, aus dem Edelmetalle (z. B. Gold, Silber) gewonnen werden.'),
('4000', 'Treib- und Brennstoffe', 'Treib- und Brennstoffe bedeutet, dass die in der Natur vorkommenden brennbaren organischen und anorganischen Substanzen abgebaut oder gewonnen werden.'),
('4020', 'Kohle', 'Kohle ist ein Abbaugut, das durch Inkohlung (Umwandlungsprozess pflanzlicher Substanzen) entstanden ist.'),
('4021', 'Braunkohle', 'Braunkohle ist ein Abbaugut, das durch einen bestimmten Grad von Inkohlung (Umwandlungsprozess pflanzlicher Substanzen) entstanden ist.'),
('4022', 'Steinkohle', 'Steinkohle ist ein Abbaugut, das durch vollständige Inkohlung (Umwandlungsprozess pflanzlicher Substanzen) entstanden ist.'),
('4030', 'Ölschiefer', 'Ölschiefer ist ein Abbaugut, das aus dunklem, bitumenhaltigem, tonigem Gestein besteht.'),
('5000', 'Industrieminerale, Salze', 'Industrieminerale, Salze bedeutet, dass die in der Natur vorkommenden Mineralien abgebaut werden.'),
('5001', 'Gipsstein', 'Gipsstein ist ein natürliches Abbaugut.'),
('5002', 'Anhydritstein', 'Anhydritstein ist ein Abbaugut, das aus wasserfreiem Gips besteht.'),
('5003', 'Steinsalz', 'Steinsalz ist ein Abbaugut, das aus Salzstöcken gewonnen wird und aus Natriumchlorid besteht.'),
('5004', 'Kalisalz', 'Kalisalz ist ein Abbaugut, das aus Salzstöcken gewonnen wird und aus Chloriden und Sulfaten besteht.'),
('5005', 'Kalkspat', 'Kalkspat ist ein weißes oder hell gefärbtes Abbaugut (Calciumcarbonat).'),
('5006', 'Flussspat', 'Flussspat ist ein Abbaugut, das aus Calciumfluorid besteht.'),
('5007', 'Schwerspat', 'Schwerspat ist ein formenreiches, rhombisches weißes bis farbiges Abbaugut.'),
('5011', 'Graphit', 'Graphit ist ein bleigraues, weiches, metallglänzendes Abbaugut, das aus fast reinem Kohlenstoff besteht.');
CREATE TABLE ax_zustand_sportfreizeitunderholungsflaeche (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_sportfreizeitunderholungsflaeche IS 'Alias: "AX_Zustand_SportFreizeitUndErholungsflaeche", UML-Typ: Enumeration';
INSERT INTO ax_zustand_sportfreizeitunderholungsflaeche (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb, stillgelegt, verlassen', 'Außer Betrieb, stillgelegt, verlassen bedeutet, dass sich die Fläche nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('8000', 'Erweiterung, Neuansiedlung', 'Erweiterung, Neuansiedlung bedeutet, dass die Fläche in ihrer Nutzung gemäß der Objektart erweitert wird und eine Fertigstellung absehbar ist.');
CREATE TABLE ax_artderbebauung_siedlungsflaeche (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_artderbebauung_siedlungsflaeche IS 'Alias: "AX_ArtDerBebauung_Siedlungsflaeche", UML-Typ: Enumeration';
INSERT INTO ax_artderbebauung_siedlungsflaeche (wert,beschreibung,dokumentation) VALUES
('1000', 'Offen', 'Offen beschreibt die Bebauung von Fläche gemischter Nutzung, die vorwiegend durch einzelstehende Gebäude charakterisiert wird.'),
('2000', 'Geschlossen', 'Geschlossen beschreibt die Bebauung von Siedlungsfläche, die vorwiegend durch zusammenhängende Gebäude charakterisiert wird. Die Gebäudeabdeckung ist in der Regel > 50 Prozent der Fläche.');
CREATE TABLE ax_zustand_industrieundgewerbeflaeche (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_industrieundgewerbeflaeche IS 'Alias: "AX_Zustand_IndustrieUndGewerbeflaeche", UML-Typ: Enumeration';
INSERT INTO ax_zustand_industrieundgewerbeflaeche (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb, stillgelegt, verlassen', 'Außer Betrieb, stillgelegt, verlassen bedeutet, dass sich die Fläche nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('4000', 'Im Bau', 'Im Bau bedeutet, dass sich überwiegende Teile der Industrie- und Gewerbefläche im Bau befinden.'),
('8000', 'Erweiterung, Neuansiedlung', 'Erweiterung, Neuansiedlung bedeutet, dass die Fläche in ihrer Nutzung gemäß der Objektart erweitert wird und eine Fertigstellung absehbar ist.');
CREATE TABLE ax_funktion_bergbaubetrieb (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_bergbaubetrieb IS 'Alias: "AX_Funktion_Bergbaubetrieb", UML-Typ: Enumeration';
INSERT INTO ax_funktion_bergbaubetrieb (wert,beschreibung,dokumentation) VALUES
('1200', 'Parken', 'Parken bezeichnet eine Fläche die vorwiegend dem Abstellen von Fahrzeugen dient und zu diesem Zweck ggf. mit Gebäuden, Bauwerken, Anlagen oder Kennzeichnungen versehen ist.');
CREATE TABLE ax_funktion_tagebaugrubesteinbruch (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_tagebaugrubesteinbruch IS 'Alias: "AX_Funktion_TagebauGrubeSteinbruch", UML-Typ: Enumeration';
INSERT INTO ax_funktion_tagebaugrubesteinbruch (wert,beschreibung,dokumentation) VALUES
('1200', 'Parken', 'Parken bezeichnet eine Fläche die vorwiegend dem Abstellen von Fahrzeugen dient und zu diesem Zweck ggf. mit Gebäuden, Bauwerken, Anlagen oder Kennzeichnungen versehen ist.');
CREATE TABLE ax_zustand_flaechebesondererfunktionalerpraegung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_flaechebesondererfunktionalerpraegung IS 'Alias: "AX_Zustand_FlaecheBesondererFunktionalerPraegung", UML-Typ: Enumeration';
INSERT INTO ax_zustand_flaechebesondererfunktionalerpraegung (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb, stillgelegt, verlassen', 'Außer Betrieb, stillgelegt, verlassen bedeutet, dass sich die Fläche funktionaler Prägung nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('8000', 'Erweiterung, Neuansiedlung', 'Erweiterung, Neuansiedlung bedeutet, dass die Fläche in ihrer Nutzung gemäß der Objektart erweitert wird und eine Fertigstellung absehbar ist.');
CREATE TABLE ax_primaerenergie_industrieundgewerbeflaeche (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_primaerenergie_industrieundgewerbeflaeche IS 'Alias: "AX_Primaerenergie_IndustrieUndGewerbeflaeche", UML-Typ: Enumeration';
INSERT INTO ax_primaerenergie_industrieundgewerbeflaeche (wert,beschreibung,dokumentation) VALUES
('1000', 'Wasser', 'Wasser bedeutet, dass das Kraftwerk potentielle und kinetische Energie des Wasserkreislaufs in elektrische Energie umwandelt.'),
('2000', 'Kernkraft', 'Kernkraft bedeutet, dass das Kraftwerk die durch Kernspaltung gewonnene Energie in eine andere Energieform umwandelt.'),
('3000', 'Sonne', 'Sonne bedeutet, dass das Kraftwerk bzw. Heizwerk Sonnenenergie in eine andere Energieform umwandelt.'),
('4000', 'Wind', 'Wind bedeutet, dass das Kraftwerk die Strömungsenergie des Windes in elektrische Energie umwandelt.'),
('5000', 'Gezeiten', 'Gezeiten bedeutet, dass das Kraftwerk die kinetische Energie der Meeresgezeiten in elektrische Energie umwandet.'),
('6000', 'Erdwärme', 'Erdwärme bedeutet, dass das Heizwerk die geothermische Energie der Erde nutzt.'),
('7000', 'Verbrennung', 'Verbrennung bedeutet, dass das Kraftwerk bzw. Heizwerk die durch Verbrennung freiwerdende Energie in eine andere Energieform umwandelt.'),
('7100', 'Kohle', 'Kohle bedeutet, dass das Kraftwerk bzw. Heizwerk die durch Verbrennung von Kohle freiwerdende Energie in eine andere Energieform umwandelt.'),
('7200', 'Öl', 'Öl bedeutet, dass das Kraftwerk bzw. Heizwerk die durch Verbrennung von Öl freiwerdende Energie in eine andere Energieform umwandelt.'),
('7300', 'Gas', 'Gas bedeutet, dass das Kraftwerk bzw. Heizwerk die durch Verbrennung von Gas freiwerdende Energie in eine andere Energieform umwandelt.'),
('7400', 'Müll, Abfall', 'Müll, Abfall bedeutet, dass das Kraftwerk bzw. Heizwerk die durch Verbrennung von Müll bzw. Abfall freiwerdende Energie in eine andere Energieform umwandelt.'),
('7500', 'Biomasse', 'Biomasse sind organische Substanzen (z.B. Pflanzen, Futtermittelabfälle, Gülle), die verbrannt und/oder vergärt werden, um Energie zu gewinnen.');
CREATE TABLE ax_funktion_friedhof (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_friedhof IS 'Alias: "AX_Funktion_Friedhof", UML-Typ: Enumeration';
INSERT INTO ax_funktion_friedhof (wert,beschreibung,dokumentation) VALUES
('1200', 'Parken', 'Parken bezeichnet eine Fläche die vorwiegend dem Abstellen von Fahrzeugen dient und zu diesem Zweck ggf. mit Gebäuden, Bauwerken, Anlagen oder Kennzeichnungen versehen ist.'),
('9401', 'Gebäude- und Freifläche Friedhof', 'Gebäude- und Freifläche Friedhof ist eine bebaute oder unbebaute Fläche, die der Bestattung von Verstorbenen dient. Die Friedhofskapelle, das Krematorium oder Leichenhalle sind in der Nutzung Friedhof inbegriffen.'),
('9402', 'Friedhof (ohne Gebäude)', 'Friedhof (ohne Gebäude) umfasst eingefriedete Flächen für Gräber.'),
('9403', 'Parkfriedhof', 'Parkfriedhof ist ein Friedhof, der als Park angelegt ist.'),
('9404', 'Historischer Friedhof', 'Historischer Friedhof ist ein Friedhof, der als historisch gilt.');
CREATE TABLE ax_abbaugut_tagebaugrubesteinbruch (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_abbaugut_tagebaugrubesteinbruch IS 'Alias: "AX_Abbaugut_TagebauGrubeSteinbruch", UML-Typ: Enumeration';
INSERT INTO ax_abbaugut_tagebaugrubesteinbruch (wert,beschreibung,dokumentation) VALUES
('1000', 'Erden, Lockergestein', 'Erden, Lockergestein bedeutet, dass feinkörnige Gesteine abgebaut werden.'),
('1001', 'Ton', 'Ton ist ein Abbaugut, das aus gelblichem bis grauem Lockergestein besteht und durch Verwitterung älterer Gesteine entsteht.'),
('1002', 'Bentonit', 'Bentonit ist ein tonartiges Abbaugut, das durch Verwitterung vulkanischer Asche (Tuffe) entstanden ist.'),
('1003', 'Kaolin', 'Kaolin ist ein Abbaugut, das aus weißem, erdigem Gestein, fast reinem Aluminiumsilikat (kieselsaure Tonerde) besteht.'),
('1004', 'Lehm', 'Lehm ist ein Abbaugut, das durch Verwitterung entstanden ist und aus gelb bis braun gefärbtem sandhaltigem Ton besteht.'),
('1005', 'Löß, Lößlehm', 'Löß, Lößlehm ist ein Abbaugut das aus feinsten gelblichen Sedimenten besteht und eine hohe Wasserspeicherfähigkeit aufweist.'),
('1007', 'Kalk, Kalktuff, Kreide', 'Kalk, Kalktuff, Kreide ist ein Abbaugut, das aus erdigem weißen Kalkstein besteht.'),
('1008', 'Sand', 'Sand ist ein Abbaugut, das aus kleinen, losen Mineralkörnern (häufig Quarz) besteht.'),
('1009', 'Kies, Kiessand', 'Kies, Kiessand ist ein Abbaugut, das aus vom Wasser rund geschliffenen Gesteinsbrocken besteht.'),
('1011', 'Farberden', 'Farberden ist ein Abbaugut, das durch Verwitterung entstanden ist und vorrangig aus eisenhaltigem Gestein besteht.'),
('1012', 'Quarzsand', 'Quarzsand ist ein Abbaugut, das vorwiegend aus kleinen, losen Quarzkörnern besteht.'),
('2000', 'Steine, Gestein, Festgestein', 'Steine, Gestein, Festgestein bedeutet, dass grobkörnige oder feste Gesteine abgebaut werden.'),
('2001', 'Tonstein', 'Tonstein ist ein gelblich bis graues Abbaugut, das überwiegend aus Tonmineralien besteht.'),
('2002', 'Schiefer, Dachschiefer', 'Schiefer, Dachschiefer ist ein toniges Abbaugut, das in dünne ebene Platten spaltbar ist.'),
('2003', 'Metamorpher Schiefer', 'Metamorpher Schiefer ist ein Abbaugut, dessen ursprüngliche Zusammensetzung und Struktur durch Wärme und Druck innerhalb der Erdkruste verändert worden ist.'),
('2004', 'Mergelstein', 'Mergelstein ist ein Abbaugut, das sich größtenteils aus Ton und Kalk zusammensetzt.'),
('2005', 'Kalkstein', 'Kalkstein ist ein Abbaugut, das als weit verbreitetes Sedimentgestein überwiegend aus Calciumcarbonat besteht.'),
('2006', 'Dolomitstein', 'Dolomitstein ist ein Abbaugut, das überwiegend aus calcium- und magnesiumhaltigen Mineralien besteht.'),
('2007', 'Travertin', 'Travertin ist ein Abbaugut, das aus gelblichen Kiesel- oder Kalktuffen besteht.'),
('2008', 'Marmor', 'Marmor ist ein Abbaugut, das als rein weißer kristalliner, körniger Kalkstein (Calciumcarbonat) vorkommt.'),
('2009', 'Sandstein', 'Sandstein ist ein Abbaugut, das aus verfestigtem Sedimentgestein besteht.'),
('2010', 'Grauwacke', 'Grauwacke ist ein Abbaugut, das aus tonhaltigem Sandstein besteht und mit Gesteinsbruchstücken angereichert sein kann.'),
('2012', 'Gneis', 'Gneis ist ein metamorphes Abbaugut mit Schieferung, das aus Feldspat, Quarz und Glimmer besteht.'),
('2013', 'Basalt, Diabas', 'Basalt, Diabas ist ein Abbaugut, das aus basischem Ergussgestein besteht.'),
('2015', 'Porphyr, Quarzporphyr', 'Porphyr, Quarzporphyr ist ein eruptiv entstandenes Abbaugut, das aus einer dichten Grundmasse und groben Einsprenglingen besteht.'),
('2016', 'Granit', 'Granit ist ein eruptiv entstandenes Abbaugut, das aus körnigem Feldspat, Quarz, Glimmer besteht.'),
('2017', 'Granodiorit', 'Granodiorit ist ein hell- bis dunkelgraues Abbaugut. Es ist ein mittelkörniges Tiefengestein mit den Hauptbestandteilen Feldspat, Quarz, Hornblende und Biotit.'),
('2018', 'Tuff-, Bimsstein', 'Tuff-, Bimsstein ist ein helles, sehr poröses Abbaugut, das durch rasches Erstarren der Lava entstanden ist.'),
('2019', 'Trass', 'Trass ist ein Abbaugut, das aus vulkanischem Aschentuff (Bimsstein) besteht.'),
('2020', 'Lavaschlacke', 'Lavaschlacke ist ein Abbaugut, das aus ausgestoßenem, geschmolzenen Vulkangestein besteht.'),
('2021', 'Talkschiefer, Speckstein', 'Talkschiefer, Speckstein ist ein farbloses bis graugrünes, sich fettig anfühlendes Abbaugut, das aus dem weichen Mineral Talk besteht.'),
('4000', 'Treib- und Brennstoffe', 'Treib- und Brennstoffe bedeutet, dass die in der Natur vorkommenden brennbaren organischen und anorganischen Substanzen abgebaut oder gewonnen werden.'),
('4010', 'Torf', 'Torf ist ein Abbaugut, das aus der unvollkommenen Zersetzung abgestorbener pflanzlicher Substanz unter Luftabschluss in Mooren entstanden ist.'),
('4020', 'Kohle', 'Kohle ist ein Abbaugut, das durch Inkohlung (Umwandlungsprozess pflanzlicher Substanzen) entstanden ist.'),
('4021', 'Braunkohle', 'Braunkohle ist ein Abbaugut, das durch einen bestimmten Grad von Inkohlung (Umwandlungsprozess pflanzlicher Substanzen) entstanden ist.'),
('4022', 'Steinkohle', 'Steinkohle ist ein Abbaugut, das durch vollständige Inkohlung (Umwandlungsprozess pflanzlicher Substanzen) entstanden ist.'),
('4030', 'Ölschiefer', 'Ölschiefer ist ein Abbaugut, das aus dunklem, bitumenhaltigen, tonigen Gestein besteht.'),
('5000', 'Industrieminerale, Salze', 'Industrieminerale, Salze bedeutet, dass die in der Natur vorkommenden Mineralien abgebaut werden.'),
('5001', 'Gipsstein', 'Gipsstein ist ein natürliches Abbaugut.'),
('5002', 'Anhydritstein', 'Anhydritstein ist ein Abbaugut, das aus wasserfreiem Gips besteht.'),
('5005', 'Kalkspat', 'Kalkspat ist ein weißes oder hell gefärbtes Abbaugut (Calciumcarbonat).'),
('5008', 'Quarz', 'Quarz ist ein Abbaugut, das aus verschiedenen Gesteinsarten (Granit, Gneis, Sandstein) gewonnen wird.'),
('5009', 'Feldspat', 'Feldspat ist ein weiß bis grauweißes gesteinsbildendes Mineral von blättrigem Bruch, das abgebaut wird.'),
('5010', 'Pegmatitsand', 'Pegmatitsand ist ein Abbaugut, das durch Verwitterung von Granit und Gneis entstanden ist.'),
('9999', 'Sonstiges', 'Sonstiges bedeutet, dass das Abbaugut bekannt, aber nicht in der Attributwertliste aufgeführt ist.');
CREATE TABLE ax_zustand_tagebaugrubesteinbruch (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_tagebaugrubesteinbruch IS 'Alias: "AX_Zustand_TagebauGrubeSteinbruch", UML-Typ: Enumeration';
INSERT INTO ax_zustand_tagebaugrubesteinbruch (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb, stillgelegt, verlassen', 'Außer Betrieb, stillgelegt, verlassen bedeutet, dass sich Tagebau, Grube, Steinbruch nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('8000', 'Erweiterung, Neuansiedlung', 'Erweiterung, Neuansiedlung bedeutet, dass die Fläche in ihrer Nutzung gemäß der Objektart erweitert wird und eine Fertigstellung absehbar ist.');
CREATE TABLE ax_funktion_industrieundgewerbeflaeche (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_industrieundgewerbeflaeche IS 'Alias: "AX_Funktion_IndustrieUndGewerbeflaeche", UML-Typ: Enumeration';
INSERT INTO ax_funktion_industrieundgewerbeflaeche (wert,beschreibung,dokumentation) VALUES
('1200', 'Parken', 'Parken bezeichnet eine Fläche die vorwiegend dem Abstellen von Fahrzeugen dient und zu diesem Zweck ggf. mit Gebäuden, Bauwerken, Anlagen oder Kennzeichnungen versehen ist.'),
('1400', 'Handel und Dienstleistung', 'Handel und Dienstleistung bezeichnet eine Fläche, auf der vorwiegend Gebäude stehen, in denen Handels- und/oder Dienstleistungsbetriebe ansässig sind. Dazu gehören auch Flächen zur Beherbergung, Restauration und/oder Vergnügung.'),
('1410', 'Freie Berufe und weitere Dienstleistungen', 'Freie Berufe und weitere Dienstleistungen bezeichnet eine Fläche mit Gebäuden und Einrichtungen welche zur Ausübung freier Berufe wie auch weiterer Dienstleistungen genutzt wird.'),
('1420', 'Bank, Kredit', 'Bank, Kredit bezeichnet eine Fläche mit Gebäuden und Einrichtungen der Bank- oder Kreditunternehmen.'),
('1430', 'Versicherung', 'Versicherung bezeichnet eine Fläche mit Gebäuden und Einrichtungen der Versicherungsgesellschaften.'),
('1440', 'Handel', 'Handel bezeichnet Anlagen mit Einzelhandels- und Dienstleistungsbetrieben, die durch einheitliche Verwaltung, auf das Einzugsgebiet abgestimmter Anbieter und durch umfangreiche Parkmöglichkeiten geprägt sind.'),
('1450', 'Ausstellung, Messe', 'Ausstellung, Messe bezeichnet eine Fläche mit Ausstellungshallen und sonstigen Einrichtungen zur Präsentation von Warenmustern.'),
('1460', 'Beherbergung', 'Beherbergung bezeichnet eine Fläche mit Gebäuden und Einrichtungen für das gewerbliche Angebot der Unterbringung von Personen.'),
('1470', 'Restauration', 'Restauration bezeichnet eine Fläche mit Gebäuden und Einrichtungen für das gewerbliche Angebot der gastronomischen Versorgung.'),
('1480', 'Vergnügung', 'Vergnügung bezeichnet eine Fläche mit Gebäuden und Einrichtungen, in denen Möglichkeiten zur unterhaltsamen Freizeitgestaltung angeboten werden.'),
('1490', 'Gärtnerei', 'Gärtnerei bezeichnet eine Fläche mit Gebäuden, Gewächshäusern und sonstigen Einrichtungen, zur Aufzucht von Blumen und Gemüsepflanzen.'),
('1510', 'Handwerk', 'Handwerk bezeichnet eine Fläche, auf der vorwiegend Handwerksbetriebe vorhanden sind.'),
('1520', 'Tankstelle', 'Tankstelle bezeichnet eine Fläche, auf der sich Gebäude und Einrichtungen befinden, an denen Kraftfahrzeuge mit den benötigten Kraftstoffen versorgt werden.'),
('1530', 'Logistik und Transport', 'Logistik und Transport umfasst Flächen mit Gebäuden und Einrichtungen, die sich mit der Planung, Steuerung und Durchführung von Güter-, Informations- und Personenströmen befassen. Hierzu gehören Speditionen, Bus- und Taxiunternehmen, Kurier-, Express- und Paketdienste.'),
('1540', 'Forschung und Entwicklung', 'Forschung und Entwicklung bezeichnet eine Fläche, auf der sich vorwiegend industrielle Forschungs- und Entwicklungseinrichtungen befinden.'),
('1700', 'Industrie und Gewerbe', 'Industrie und Gewerbe bezeichnet Flächen, auf denen vorwiegend Industrie- und Gewerbebetriebe vorhanden sind. Darin sind Gebäude- und Freiflächen und die Betriebsfläche Lagerfläche enthalten.'),
('1701', 'Gebäude- und Freifläche Industrie und Gewerbe', 'Darin sind die Gebäude- und Freiflächen der folgenden Differenzierung enthalten ohne die Betriebsfläche Lagerfläche.'),
('1710', 'Produktion', 'Produktion bezeichnet eine Fläche, auf der vorwiegend Produktionsbetriebe vorhanden sind.'),
('1740', 'Lagerfläche', 'Lagerfläche bezeichnet Areale, auf denen inner- und außerhalb von Gebäuden wirtschaftliche Güter gelagert werden, ohne Zusammenhang zu weiteren Wertearten.'),
('1770', 'Grundstoff', 'Grundstoff bezeichnet eine Fläche mit Produktionsbetrieben, die Ausgangsmaterialien für die weiterverarbeitende Industrie produzieren.'),
('1780', 'Betriebliche Sozialeinrichtung', 'Betriebliche Sozialeinrichtung bezeichnet eine Fläche innerhalb eines Betriebes mit Gebäuden und Einrichtungen für soziale Zwecke.'),
('1790', 'Werft', 'Werft bezeichnet eine Fläche mit Gebäuden und sonstigen Einrichtungen zum Bau oder zur Reparatur von Schiffen.'),
('1801', 'Nahrungs-, Futter-, Genussmittel', 'Nahrungs-, Futter-, Genussmittel bezeichnet Flächen zur Fertigung von Erzeugnissen der Landwirtschaft, Forstwirtschaft sowie die Herstellung verschiedener Halbwaren, die noch keine Nahrungs- Futter- oder Genussmittel darstellen.'),
('1802', 'Textil, Bekleidung, Lederwaren', 'Textil, Bekleidung, Lederwaren bezeichnet Flächen auf denen primär Textil, Bekleidung und Lederwaren wie nachfolgend beschrieben gefertigt oder verarbeitet werden. Textilwaren umfasst Spinnstoffaufbereitung und Spinnerei, Weberei, Veredlung von Textilien und Bekleidung, sowie die Herstellung von konfektionierten Textilwaren. Bekleidung umfasst alle Schneiderarbeiten aus allen Materialien für alle Bekleidungsartikel und Bekleidungszubehör. Lederwaren umfasst das Zurichten und Färben von Pelzen und die Verarbeitung von Fellen zu Leder durch Gerben und Zurichten sowie die Weiterverarbeitung des Leders zu Gebrauchsgegenständen.'),
('1803', 'Holz-, Naturfaser-, Verpackungsprodukte', 'Holz-, Naturfaser-, Verpackungsprodukte bezeichnet Flächen auf denen primär Holz-, Naturfaser- oder Verpackungsprodukte wie nachfolgend beschrieben gefertigt oder verarbeitet werden. Holzprodukte umfassen die Herstellung von Bauholz, Sperrholz, Furniere, Verpackungsmittel, Lagerbehälter und Ladungsträger, Bodenbeläge, Fachwerk, vorgefertigte Gebäude. Naturfaserprodukte sind Veredelungen von Holz- und Zellprodukten. Verpackungsprodukte umfasst Flächen für die Fertigung von Verpackungsmaterial aus bspw. Papier, Karton, Pappe und Holz.'),
('1804', 'Print-, Audio-, Videoprodukte', 'Print-, Audio-, Videoprodukte bezeichnet Flächen auf denen primär die Erstellung, Bearbeitung oder Vervielfältigung von bespielten Ton-, Bild- und Datenträgern erfolgt.'),
('1805', 'Mineralölverarbeitung, Kokerei', 'Mineralölverarbeitung, Kokerei bezeichnet Flächen auf denen primär Rohöl und Kohle zu gebrauchsfertigen Erzeugnissen verarbeitet werden. Das vorherrschende Verfahren ist die Mineralölverarbeitung durch Trennung von Rohöl in Teilerzeugnisse anhand von Verfahren wie Spaltung und Destillation.'),
('1806', 'Chemie-, Pharma-, Kunststoffprodukte', 'Chemie-, Pharma-, Kunststoffprodukte bezeichnet Flächen auf denen primär Chemische, Pharma- und Kunststoffprodukte wie nachfolgend beschrieben gefertigt oder verarbeitet werden. Chemische Produkte umfasst die Verarbeitung organischer und anorganischer Rohstoffe in einem chemischen Verfahren zu chemischen Erzeugnissen. Pharmaprodukte umfasst die Herstellung von pharmazeutischen Grundstoffen und pharmazeutischen Spezialitäten wie auch die Herstellung von Arzneimitteln chemischen und botanischen Ursprungs. Kunststoffprodukte umfasst die Herstellung von Harzen, Kunststoffen und nicht vulkanisierbaren thermoplastischen Elastomeren sowie das Mischen von Harzen nach Kundenwunsch und die Herstellung von synthetischen Harzen nach eigener Spezifikation.'),
('1807', 'Mineralische Bau- und Werkstoffe', 'Mineralische Bau- und Werkstoffe bezeichnet Flächen auf denen primär Bau- und Werkstoffe wie nachfolgend beschrieben gefertigt oder verarbeitet werden. Baustoffe umfassen den Großhandel mit Steinen, Sand, Kies, Schotter, Zement, Mörtel, Dämmplatten sowie Fertigteilbauten aus mineralischen Stoffen, z. B. Garagen. Werkstoffe umfasst die Herstellung von Waren unter Verwendung von Stoffen mineralischen Ursprungs bezogen auf die Herstellung von Glas und Erzeugnissen daraus, keramischen Erzeugnissen, Ziegeln und Erzeugnissen aus gebranntem Ton sowie Zement und Gips, verarbeiteten Naturstein und sonstigen Mineralerzeugnissen.'),
('1808', 'Metallerzeugung und -verarbeitung', 'Metallerzeugung und –verarbeitung umfasst die Flächen für die Tätigkeiten des Schmelzens und Legierens von Eisenmetallen und NE-Metallen aus Erz, Roheisen oder Schrott mit elektrometallurgischen und anderen metallurgischen Verfahren wie auch Flächen für die Herstellung von Metalllegierungen und Superlegierungen durch Zugabe anderer chemischer Elemente zu reinen Metallen.'),
('1809', 'Technik, Elektrik, Elektronik', 'Technik, Elektrik, Elektronik umfasst Flächen für die Herstellung von Datenverarbeitungsgeräten, sowie elektronischen und optischen Erzeugnissen.'),
('1810', 'Maschinenbau', 'Maschinenbau umfasst Flächen für den Bau von Maschinen, die mechanisch oder durch Wärme auf Materialien einwirken oder an Materialien Vorgänge durchführen, einschließlich ihrer mechanischen Bestandteile, die Kraft erzeugen und anwenden, sowie spezieller Teile dafür.'),
('1811', 'Fahrzeugbau', 'Fahrzeugbau umfassen die Flächen für die Herstellung von Raum-, Luft-, Wasser- Schienen- und Strassenfahrzeugen zur Personen- oder Güterbeförderung wie auch die Flächen zur Herstellung verschiedener Teile und Zubehör.'),
('1812', 'Möbel und sonstige Konsumgüter', 'Möbel und sonstige Konsumgüter bezeichnet Flächen auf denen primär Möbel und sonstige Konsumgüter wie nachfolgend beschrieben gefertigt oder verarbeitet werden. Möbel umfassen die Herstellung von Möbeln aller Art und verwandten Erzeugnissen aus beliebigem Material, außer Stein, Beton und Keramik, für alle Einsatzbereiche und die verschiedensten Zwecke. Sonstige Konsumgüter umfasst die Fertigung von weiteren Waren vor allem für den privaten Ge- oder Verbrauch.'),
('2500', 'Versorgungsanlage', 'Versorgungsanlage bezeichnet eine Fläche, auf der vorwiegend Anlagen und Gebäude zur Versorgung mit Elektrizität, Wärme, Wasser, Öl, Gas oder zur elektronischen Informationsübertragung vorhanden sind.'),
('2501', 'Gebäude- und Freifläche Versorgungsanlage', 'Gebäude- und Freifläche Versorgungsanlage bezeichnet eine Fläche, auf der vorwiegend Anlagen und Gebäude zur Versorgung der Allgemeinheit mit Elektrizität, Wärme und Wasser vorhanden sind.'),
('2502', 'Betriebsfläche Versorgungsanlage', 'Betriebsfläche Versorgungsanlage bezeichnet eine Fläche, auf der vorwiegend Anlagen und Gebäude zur Versorgung der Allgemeinheit mit Elektrizität, Wärme und Wasser vorhanden sind.'),
('2520', 'Wasserwerk', 'Wasserwerk bezeichnet eine Fläche mit Bauwerken und sonstigen Einrichtungen zur Gewinnung und/ oder zur Aufbereitung von (Trink-)wasser.'),
('2521', 'Gebäude- und Freifläche Versorgungsanlage, Wasser', 'Gebäude- und Freifläche Versorgungsanlage, Wasser ist Teil von Wasserwerk. Wasserwerk bezeichnet eine Fläche mit Bauwerken und sonstigen Einrichtungen zur Gewinnung und/ oder zur Aufbereitung von (Trink-)wasser.'),
('2522', 'Betriebsfläche Versorgungsanlage, Wasser', 'Betriebsfläche Versorgungsanlage, Wasser ist Teil von Wasserwerk. Wasserwerk bezeichnet eine Fläche mit Bauwerken und sonstigen Einrichtungen zur Gewinnung und/ oder zur Aufbereitung von (Trink-)wasser.'),
('2530', 'Kraftwerk', 'Kraftwerk bezeichnet eine Fläche mit Bauwerken und sonstigen Einrichtungen zur Erzeugung von elektrischer Energie.'),
('2531', 'Gebäude- und Freifläche Versorgungsanlage, Elektrizität', 'Gebäude- und Freifläche Versorgungsanlage, Elektrizität ist Teil von Kraftwerk. Kraftwerk bezeichnet eine Fläche mit Bauwerken und sonstigen Einrichtungen zur Erzeugung von elektrischer Energie.'),
('2532', 'Betriebsfläche Versorgungsanlage, Elektrizität', 'Betriebsfläche Versorgungsanlage, Elektrizität ist Teil von Kraftwerk. Kraftwerk bezeichnet eine Fläche mit Bauwerken und sonstigen Einrichtungen zur Erzeu-gung von elektrischer Energie.'),
('2540', 'Umspannstation', 'Umspannstation bezeichnet eine Fläche mit Gebäuden und sonstigen Einrichtungen, um Strom auf eine andere Spannungsebene zu transformieren.'),
('2550', 'Raffinerie', 'Raffinerie bezeichnet eine Fläche mit Bauwerken und sonstigen Einrichtungen zur Aufbereitung von Erdöl.'),
('2551', 'Gebäude- und Freifläche Versorgungsanlage, Öl', 'Gebäude- und Freifläche Versorgungsanlage, Öl ist Teil von Raffinerie. Raffinerie bezeichnet eine Fläche mit Bauwerken und sonstigen Einrichtungen zur Aufbereitung von Erdöl.'),
('2552', 'Betriebsfläche Versorgungsanlage, Öl', 'Betriebsfläche Versorgungsanlage, Öl ist Teil von Raffinerie. Raffinerie bezeichnet eine Fläche mit Bauwerken und sonstigen Einrichtungen zur Aufbereitung von Erdöl.'),
('2560', 'Gaswerk', 'Gaswerk bezeichnet eine Fläche mit Gebäuden und Einrichtungen zur Aufbereitung von Erdgas.'),
('2561', 'Gebäude- und Freifläche Versorgungsanlage, Gas', 'Gebäude- und Freifläche Versorgungsanlage, Gas ist Teil von Gaswerk. Gaswerk bezeichnet eine Fläche mit Bauwerken und sonstigen Einrichtungen zur Aufbe-reitung von Gas.'),
('2562', 'Betriebsfläche Versorgungsanlage, Gas', 'Betriebsfläche Versorgungsanlage, Gas ist Teil von Gaswerk. Gaswerk bezeichnet eine Fläche mit Bauwerken und sonstigen Einrichtungen zur Aufbereitung von Gas.'),
('2570', 'Heizwerk', 'Heizwerk bezeichnet eine Fläche mit Bauwerken und sonstigen Einrichtungen zur Erzeugung von Wärmeenergie zu Heizzwecken.'),
('2571', 'Gebäude- und Freifläche Versorgungsanlage, Wärme', 'Gebäude- und Freifläche Versorgungsanlage, Wärme ist Teil von Heizwerk. Heizwerk bezeichnet eine Fläche mit Bauwerken und sonstigen Einrichtungen zur Er-zeugung von Wärmeenergie zu Heizzwecken.'),
('2572', 'Betriebsfläche Versorgungsanlage, Wärme', 'Betriebsfläche Versorgungsanlage, Wärme ist Teil von Heizwerk. Heizwerk bezeichnet eine Fläche mit Bauwerken und sonstigen Einrichtungen zur Erzeugung von Wärmeenergie zu Heizzwecken.'),
('2580', 'Funk- und Fernmeldeanlage', 'Funk- und Fernmeldeanlage bezeichnet eine Fläche, auf der vorwiegend Anlagen und Gebäude zur elektronischen Informationsübertragung stehen.'),
('2581', 'Gebäude- und Freifläche Versorgungsanlage, Funk- und Fernmeldewesen', 'Gebäude- und Freifläche Versorgungsanlage, Funk- und Fernmeldewesen ist Teil von Funk- und Fernmeldeanlage. Funk- und Fernmeldeanlage bezeichnet eine Fläche, auf der vorwiegend Anlagen und Gebäude zur elektronischen Informationenvermittlung stehen.'),
('2582', 'Betriebsfläche Versorgungsanlage, Funk- und Fernmeldewesen', 'Betriebsfläche Versorgungsanlage, Funk- und Fernmeldewesen ist Teil von Funk- und Fernmeldeanlage. Funk- und Fernmeldeanlage bezeichnet eine Fläche, auf der vorwiegend Anlagen und Gebäude zur elektronischen Informationenvermittlung stehen.'),
('2600', 'Entsorgung', 'Entsorgung bezeichnet eine Fläche, auf der vorwiegend Anlagen und Gebäude zur Verwertung und Entsorgung von Abwasser und festen Abfallstoffen vorhanden sind.'),
('2601', 'Gebäude- und Freifläche Entsorgungsanlage', 'Gebäude- und Freifläche Entsorgungsanlage ist Teil von Entsorgung. Entsorgung bezeichnet eine Fläche, auf der vorwiegend Anlagen und Gebäude zur Verwertung und Entsorgung von Abwasser und festen Abfallstoffen vorhanden sind.'),
('2602', 'Betriebsfläche Entsorgungsanlage', 'Betriebsfläche Entsorgungsanlage ist Teil von Entsorgung. Entsorgung bezeichnet eine Fläche, auf der vorwiegend Anlagen und Gebäude zur Verwertung und Entsorgung von Abwasser und festen Abfallstoffen vorhanden sind.'),
('2610', 'Kläranlage, Klärwerk', 'Kläranlage, Klärwerk bezeichnet eine Fläche mit Bauwerken und sonstigen Einrichtungen zur Reinigung von Abwasser.'),
('2611', 'Gebäude- und Freifläche Entsorgungsanlage, Abwasserbeseitigung', 'Gebäude- und Freifläche Entsorgungsanlage, Abwasserbeseitigung ist Teil von Kläranlage, Klärwerk. Kläranlage, Klärwerk bezeichnet eine Fläche mit Bauwer-ken und sonstigen Einrichtungen zur Reinigung von Abwasser.'),
('2612', 'Betriebsfläche Entsorgungsanlage, Abwasserbeseitigung', 'Betriebsfläche Entsorgungsanlage, Abwasserbeseitigung ist Teil von Kläranlage, Klärwerk. Kläranlage, Klärwerk bezeichnet eine Fläche mit Bauwerken und sonstigen Einrichtungen zur Reinigung von Abwasser.'),
('2620', 'Abfallbehandlungsanlage', 'Abfallbehandlungsanlage bezeichnet eine Fläche mit Bauwerken und sonstigen Einrichtungen, auf der Abfälle mit chemisch/physikalischen und biologischen oder thermischen Verfahren oder Kombinationen dieser Verfahren behandelt werden.'),
('2621', 'Gebäude- und Freifläche Entsorgungsanlage, Abfallbeseitigung', 'Gebäude- und Freifläche Entsorgungsanlage, Abfallbeseitigung ist Teil von Abfallbehandlungsanlage. Abfallbehandlungsanlage bezeichnet eine Fläche mit Bauwerken und sonstigen Einrichtungen, auf der Abfälle mit chemisch/physikalischen und biologischen oder thermischen Verfahren oder Kombinationen dieser Verfahren behandelt werden.'),
('2622', 'Betriebsfläche Entsorgungsanlage, Abfallbeseitigung', 'Betriebsfläche Entsorgungsanlage, Abfallbeseitigung ist Teil von Abfallbehandlungsanlage. Abfallbehandlungsanlage bezeichnet eine Fläche mit Bauwerken und sonstigen Einrichtungen, auf der Abfälle mit chemisch/physikalischen und biologischen oder thermischen Verfahren oder Kombinationen dieser Verfahren behan-delt werden.'),
('2623', 'Betriebsfläche Entsorgungsanlage, Schlamm', 'Betriebsfläche Entsorgungsanlage, Schlamm ist Teil von Abfallbehandlungsanlage. Abfallbehandlungsanlage bezeichnet eine Fläche mit Bauwerken und sonstigen Einrichtungen, auf der Abfälle mit chemisch/physikalischen und biologischen oder thermischen Verfahren oder Kombinationen dieser Verfahren behandelt wer-den.'),
('2630', 'Deponie (oberirdisch)', 'Deponie (oberirdisch) bezeichnet eine Fläche, auf der oberirdisch Abfallstoffe gelagert werden.'),
('2640', 'Deponie (untertägig)', 'Deponie (untertägig) bezeichnet eine oberirdische Betriebsfläche, unter der Abfallstoffe eingelagert werden (Untertagedeponie).'),
('2700', 'Förderanlage', 'Förderanlage bezeichnet eine Fläche mit Einrichtungen zur Förderung von Rohstoffen und Energieträgern.'),
('2701', 'Gebäude- und Freifläche Förderanlage', 'Gebäude- und Freifläche Förderanlage bezeichnet eine Fläche, auf der vorwiegend Anlagen und Gebäude zur 
Förderung von Rohstoffen und Energieträgern vorhanden sind.');
CREATE TABLE ax_funktion_wohnbauflaeche (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_wohnbauflaeche IS 'Alias: "AX_Funktion_Wohnbauflaeche", UML-Typ: Enumeration';
INSERT INTO ax_funktion_wohnbauflaeche (wert,beschreibung,dokumentation) VALUES
('1200', 'Parken', 'Parken bezeichnet eine Fläche die vorwiegend dem Abstellen von Fahrzeugen dient und zu diesem Zweck ggf. mit Gebäuden, Bauwerken, Anlagen oder Kennzeichnungen versehen ist.');
CREATE TABLE ax_artderbebauung_wohnbauflaeche (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_artderbebauung_wohnbauflaeche IS 'Alias: "AX_ArtDerBebauung_Wohnbauflaeche", UML-Typ: Enumeration';
INSERT INTO ax_artderbebauung_wohnbauflaeche (wert,beschreibung,dokumentation) VALUES
('1000', 'Offen', 'Offen beschreibt die Bebauung von Wohnbaufläche, die vorwiegend durch einzelstehende Gebäude charakterisiert wird.'),
('2000', 'Geschlossen', 'Geschlossen beschreibt die Bebauung von Wohnbaufläche, die vorwiegend durch zusammenhängende Gebäude charakterisiert wird. Die Gebäudeabdeckung ist in der Regel > 50 Prozent der Wohnbaufläche.');
CREATE TABLE ax_funktion_siedlungsflaeche (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_siedlungsflaeche IS 'Alias: "AX_Funktion_Siedlungsflaeche", UML-Typ: Enumeration';
INSERT INTO ax_funktion_siedlungsflaeche (wert,beschreibung,dokumentation) VALUES
('1200', 'Parken', 'Parken bezeichnet eine Fläche die vorwiegend dem Abstellen von Fahrzeugen dient und zu diesem Zweck ggf. mit Gebäuden, Bauwerken, Anlagen oder Kennzeichnungen versehen ist.');
CREATE TABLE ax_funktion_sportfreizeitunderholungsflaeche (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_sportfreizeitunderholungsflaeche IS 'Alias: "AX_Funktion_SportFreizeitUndErholungsflaeche", UML-Typ: Enumeration';
INSERT INTO ax_funktion_sportfreizeitunderholungsflaeche (wert,beschreibung,dokumentation) VALUES
('1200', 'Parken', 'Parken bezeichnet eine Fläche die vorwiegend dem Abstellen von Fahrzeugen dient und zu diesem Zweck ggf. mit Gebäuden, Bauwerken, Anlagen oder Kennzeichnungen versehen ist.'),
('4001', 'Gebäude- und Freifläche Sport, Freizeit und Erholung', 'Gebäude- und Freifläche Sport, Freizeit und Erholung ist eine bebaute Fläche, die dem Sport, der Freizeitgestaltung oder der Erholung dient.'),
('4100', 'Sportanlage', 'Sportanlage ist eine Fläche mit Bauwerken und Einrichtungen, die zur Ausübung von (Wettkampf-)Sport und für Zuschauer bestimmt ist.'),
('4101', 'Gebäude- und Freifläche Sport', 'Gebäude- und Freifläche Sport ist eine bebaute Fläche, die dem Sport dient.'),
('4110', 'Golf', 'Golf ist eine Fläche mit Bauwerken und Einrichtungen, die zur Ausübung des Golfsports genutzt wird.'),
('4120', 'Sportplatz', 'Sportplatz ist eine Freianlage, die sowohl dem organisierten Wettkampfsport als auch nicht wettkampforientierten Sport-, Bewegungs- und Freizeitaktivitäten dient. Auf einem Sportplatz können verschiedene Sportarten betrieben werden.'),
('4130', 'Rennbahn', 'Rennbahn ist eine, je nach Art des Rennens, verschiedenartig gestaltete Strecke (oval, gerade, kurvig), auf der Rennen stattfinden.'),
('4140', 'Reitsport', 'Reitsport bezeichnet eine Fläche mit Bauwerken und Einrichtungen, die zur Ausübung des Reitsports genutzt wird.'),
('4150', 'Schießanlage', 'Schießanlage ist eine Fläche zum Übungs- und Wettkampfschießen.'),
('4160', 'Eis-, Rollschuhbahn', 'Eis-, Rollschuhbahn ist eine künstlich angelegte Bahn zum Eislaufen oder Rollschuhfahren.'),
('4170', 'Tennis', 'Tennis ist eine Fläche mit Bauwerken und Einrichtungen, die zur Ausübung des Tennissports genutzt wird.'),
('4200', 'Freizeitanlage', 'Freizeitanlage bezeichnet eine Fläche, die vorwiegend der Freizeitgestaltung oder dazu dient, Tiere zu zeigen.'),
('4210', 'Zoo', 'Zoo ist ein Gelände mit Tierschauhäusern und umzäunten Gehegen, auf dem Tiere gehalten und gezeigt werden.'),
('4211', 'Gebäude- und Freifläche Freizeit, Zoologie', 'Gebäude- und Freifläche Freizeit, Zoologie ist eine öffentliche Fläche mit Gebäuden und Bauwerken sowie den unmittelbar zu den Gebäuden gehörigen Freiflächen, in denen Tiere gehalten und gezeigt werden.'),
('4220', 'Safaripark, Wildpark', 'Safaripark, Wildpark, ist ein Gelände mit umzäunten Gehegen, in denen Tiere im Freien gehalten und gezeigt werden.'),
('4230', 'Freizeitpark', 'Freizeitpark ist ein Gelände mit Karussells, Verkaufs- und Schaubuden und/oder Wildgattern, das der Freizeitgestaltung dient.'),
('4235', 'Kletteranlage', 'Kletteranlage ist eine Fläche mit Bauwerken und Einrichtungen, die zur Ausübung des Klettersports genutzt wird.'),
('4240', 'Freilichtbühne', 'Freilichtbühne ist eine Anlage mit Bühne und Zuschauerbänken für Aufführungen im Freien.'),
('4250', 'Freilichtmuseum', 'Freilichtmuseum ist eine volkskundliche Museumsanlage, in der Wohnformen oder historische 
Betriebsformen in ihrer natürlichen Umgebung im Freien dargestellt sind.'),
('4260', 'Autokino, Freilichtkino', 'Autokino, Freilichtkino ist ein Lichtspieltheater im Freien, in dem der Film im Allgemeinen vom Auto aus angesehen wird.'),
('4270', 'Verkehrsübungsplatz, Testgelände, Fahrsicherheit', 'Verkehrsübungsplatz, Testgelände, Fahrsicherheit ist eine Fläche, die persönlichen Übungs- und Erprobungszwecken dient.'),
('4275', 'Go-Kart-Bahn', 'Go-Kart-Bahn umfasst eine abgegrenzte Strecke mit Anlagen und Gebäuden, die zur Ausübung des Kartrennsports genutzt wird. Hierzu gehören Indoor- und Outdoor-Kartbahnen.'),
('4280', 'Hundeübungsplatz', 'Hundeübungsplatz ist eine Fläche, auf der Übungen mit Hunden durchgeführt werden.'),
('4290', 'Modellfluggelände', 'Modellfluggelände ist eine Fläche, die zur Ausübung des Modellflugsports dient.'),
('4295', 'Gelände für Luftsportgeräte', 'Gelände für Luftsportgeräte ist eine Fläche auf der Ultraleichtflug-, Hängegleiter-, Gleitsegel-, Sprungfallschirm-, Gleitflug- und Freiballonaktivitäten ausgeübt werden.'),
('4300', 'Erholungsfläche', 'Erholungsfläche ist eine Fläche mit Bauwerken und Einrichtungen, die zur Erholung bestimmt ist.'),
('4301', 'Gebäude- und Freifläche Erholung', 'Gebäude- und Freifläche Erholung ist eine öffentliche Fläche mit Gebäuden und Bauwerken sowie den unmittelbar zu den Gebäuden gehörigen Freiflächen, die zur Erholung bestimmt sind.'),
('4310', 'Wochenend- und Ferienhausfläche', 'Wochenend- und Ferienhausfläche bezeichnet eine extra dafür ausgewiesene Fläche auf der vorwiegend Wochenend- und Ferienhäuser stehen dürfen.'),
('4320', 'Schwimmen', 'Schwimmen ist eine Anlage mit Wasserfläche sowie Anlagen an Ufern von Gewässern für den Badebetrieb und Schwimmsport.'),
('4321', 'Gebäude- und Freifläche Erholung, Bad', 'Gebäude- und Freifläche Erholung, Bad bezeichnet eine öffentliche Fläche, auf der vorwiegend Anlagen und Gebäude zur Erholung, für den Badebetrieb und den Schwimmsport vorhanden sind.'),
('4330', 'Campingplatz', 'Campingplatz ist eine Fläche für den Aufbau einer größeren Zahl von Zelten oder zum Abstellen und Benutzen von Wohnwagen mit ortsfesten Anlagen und Einrichtungen.'),
('4331', 'Gebäude- und Freifläche Erholung, Camping', 'Gebäude- und Freifläche Erholung, Camping bezeichnet eine Fläche, auf der vorwiegend Anlagen und Gebäude zur Erholung sowie für den Betrieb eines Campingplatzes vorhanden sind.'),
('4400', 'Grünanlage', 'Grünanlage’ ist eine Anlage mit Bäumen, Sträuchern, Rasenflächen, Blumenrabatten und Wegen. Sie dient der Erholung einschließlich spielerischer Aktivitäten oder erfüllt stadtgestalterische Aufgaben.'),
('4410', 'Siedlungsgrünfläche', 'Siedlungsgrünfläche ist eine unbebaute Wiese, Rasenfläche und Parkanlage in Städten und Siedlungen.'),
('4420', 'Park', 'Park ist eine landschaftsgärtnerisch gestaltete Grünanlage, die der Repräsentation und der Erholung dient.'),
('4430', 'Botanischer Garten', 'Botanischer Garten ist ein der Öffentlichkeit zugänglicher Garten zum Studium der Pflanzenwelt; systematisch geordnete Sammlung in Freiland und Gewächshäusern (Warmhäuser).'),
('4431', 'Gebäude- und Freifläche Grünanlage, Botanik', 'Gebäude- und Freifläche Grünanlage, Botanik ist eine öffentliche Fläche mit Gebäuden und Bauwerken, in der Pflanzen der Öffentlichkeit zugänglich gemacht werden.'),
('4440', 'Kleingarten', 'Kleingarten (Schrebergarten) ist eine Anlage von Gartengrundstücken, die im Unterschied zu Gartenbauland vorwiegend der Freizeit und Erholung dient.'),
('4450', 'Wochenendplatz', 'Wochenendplatz sind Flächen, die der Freizeitgestaltung dienen.'),
('4460', 'Garten', 'Garten sind Flächen, die nicht im unmittelbaren Zusammenhang mit Wohnbauflächen stehen und nicht dem Bundeskleingartengesetz unterliegen. Der Garten dient, im Gegensatz zum Vorgarten oder Ziergarten, hauptsächlich der Erzeugung von Nutzpflanzen, wie z.B. Kräutern, Obst und Gemüse als Nahrungsmittel zum privaten Gebrauch.'),
('4470', 'Spielplatz, Bolzplatz', 'Spielplatz, Bolzplatz ist ein Platz an dem körperliche oder geistige Tätigkeit aus eigenem Antrieb ohne Zweckbestimmung ausgeübt wird.'),
('9999', 'Sonstiges', 'Sonstiges bedeutet, dass die Funktion der Sport-, Freizeit- und Erholungsfläche bekannt, diese aber nicht in der Werteliste aufgeführt ist.');
CREATE TABLE ax_zustand_flaechegemischternutzung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_flaechegemischternutzung IS 'Alias: "AX_Zustand_FlaecheGemischterNutzung", UML-Typ: Enumeration';
INSERT INTO ax_zustand_flaechegemischternutzung (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb, stillgelegt, verlassen', 'Außer Betrieb, stillgelegt, verlassen bedeutet, dass sich die Fläche nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('8000', 'Erweiterung, Neuansiedlung', 'Erweiterung, Neuansiedlung bedeutet, dass die Fläche in ihrer Nutzung gemäß der Objektart erweitert wird und eine Fertigstellung absehbar ist.');
CREATE TABLE ax_funktion_flaechegemischternutzung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_flaechegemischternutzung IS 'Alias: "AX_Funktion_FlaecheGemischterNutzung", UML-Typ: Enumeration';
INSERT INTO ax_funktion_flaechegemischternutzung (wert,beschreibung,dokumentation) VALUES
('1200', 'Parken', 'Parken bezeichnet eine Fläche, die vorwiegend dem Abstellen von Fahrzeugen dient und zu diesem Zweck ggf. mit Gebäuden, Bauwerken, Anlagen oder Kennzeichnungen versehen ist.'),
('2100', 'Gebäude- und Freifläche Mischnutzung mit Wohnen', 'Gebäude- und Freifläche Mischnutzung mit Wohnen bezeichnet eine Fläche, die Wohn- und anderen Nutzungen zugleich dient, und bei der die Wohn- oder andere Nutzung von nicht ganz untergeordneter Bedeutung ist.'),
('2110', 'Wohnen mit Öffentlich', 'Wohnen mit Öffentlich beschreibt eine baulich geprägte Fläche, die sowohl für Wohnzwecke als auch der Allgemeinheit dient. Es dominieren die Wohnzwecke.'),
('2120', 'Wohnen mit Handel und Dienstleistungen', 'Wohnen mit Handel und Dienstleistungen beschreibt eine baulich geprägte Fläche, die sowohl für Wohnzwecke als auch für Handels- und/oder Dienstleistungsbetrieben dient. Es dominieren die Wohnzwecke.'),
('2130', 'Wohnen mit Gewerbe und Industrie', 'Wohnen mit Gewerbe und Industrie beschreibt eine baulich geprägte Fläche, die sowohl für Wohnzwecke als auch für Gewerbe- und/oder Industriebetrieben dienen. Es dominieren die Wohnzwecke.'),
('2140', 'Öffentlich mit Wohnen', 'Öffentlich mit Wohnen beschreibt eine baulich geprägte Fläche, die sowohl für Wohnzwecke als auch der Allgemeinheit dient. Es dominieren die Zwecke für die Allgemeinheit.'),
('2150', 'Handel und Dienstleistungen mit Wohnen', 'Handel und Dienstleistungen mit Wohnen beschreibt eine baulich geprägte Fläche, die sowohl für Wohnzwecke als auch für Handels- und/oder Dienstleistungsbetrieben dient. Es dominieren die Zwecke für Handel und Dienstleistung.'),
('2160', 'Gewerbe und Industrie mit Wohnen', 'Gewerbe und Industrie mit Wohnen‘ beschreibt eine baulich geprägte Fläche, die sowohl für Wohnzwecke als auch für Gewerbe- und/oder Industriebetrieben dienen. Es dominieren die Zwecke für Gewerbe und Industrie.'),
('2700', 'Gebäude- und Freifläche Land- und Forstwirtschaft', 'Gebäude- und Freifläche Land- und Forstwirtschaft bezeichnet eine Fläche, die vorwiegend der Land- und Forstwirtschaft dient, einschließlich des Wohnteils.'),
('2710', 'Wohnen', 'Wohnen ist eine Fläche zu Wohnzwecken, die mit einer Fläche der land- und forstwirtschaftlichen Nutzung in Verbindung steht.'),
('2720', 'Betrieb', 'Betrieb ist eine Fläche, die betrieblichen Zwecken in der Land- und Forstwirtschaft dient.'),
('2730', 'Wohnen und Betrieb', 'Wohnen und Betrieb ist eine Fläche, die sowohl Wohn- als auch betrieblichen Zwecken in der Land- und Forstwirtschaft dient.'),
('3000', 'Fischereiwirtschaftsfläche', 'Fischereiwirtschaftsfläche bezeichnet Flächen/Areale, die dem (gewerblichen) Fangen oder Züchten von Fischen und anderen Wassertieren/ im Wasser lebenden Organismen zur Nahrungsgewinnung und Weiterverarbeitung dienen.'),
('3001', 'Fischereiwirtschaftsfläche mit Fischzucht, Muschelzucht', 'Fischereiwirtschaftsfläche mit Fischzucht, Muschelzucht bezeichnet Flächen/Areale, die dem (gewerblichen) Züchten/der kontrollierten Aufzucht von im Wasser lebenden Organismen, insbesondere Fischen und Muscheln, zur Nahrungsgewinnung und Weiterverarbeitung dienen.'),
('3002', 'Fischereiwirtschaftsfläche mit Algenzucht', 'Fischereiwirtschaftsfläche mit Algenzucht bezeichnet Flächen/Areale, die dem (gewerblichen) Züchten/der kontrollierten Aufzucht von im Wasser lebenden Organismen, insbesondere Algen, zur Nahrungsgewinnung und Weiterverarbeitung dienen.'),
('3003', 'Fischereiwirtschaftsfläche mit Fischzucht, Muschelzucht und Algenzucht', 'Fischereiwirtschaftsfläche mit Fischzucht, Muschelzucht und Algenzucht bezeichnet Flächen/Areale, die dem (gewerblichen) Züchten/der kontrollierten Aufzucht von im Wasser lebenden Organismen, insbesondere Fisch, Muscheln und Algen, zur Nahrungsgewinnung und Weiterverarbeitung dienen.'),
('6800', 'Landwirtschaftliche Betriebsfläche', 'Landwirtschaftliche Betriebsfläche’ ist eine bebaute oder unbebaute Fläche, die dem landwirtschaftlichen Betrieb ohne eine Wohnnutzung dient.'),
('6810', 'Landwirtschaftliche Betriebsfläche für Tierhaltung', 'Landwirtschaftliche Betriebsfläche für Tierhaltung’ bezeichnet eine bebaute oder unbebaute Fläche, die vorwiegend dem landwirtschaftlichen Betrieb, primär der Tierhaltung, dient. Diese umfasst auch die Gebäude- und Freiflächen.'),
('6820', 'Landwirtschaftliche Betriebsfläche für pflanzliche Produktion', 'Landwirtschaftliche Betriebsfläche für pflanzliche Produktion’ bezeichnet eine bebaute oder unbebaute Fläche, die vorwiegend dem landwirtschaftlichen Betrieb, primär der pflanzlichen Produktion, dient. Diese umfasst auch die Gebäude- und Freiflächen.'),
('6830', 'Landwirtschaftliche Betriebsfläche für Tierhaltung und pflanzliche Produktion', 'Landwirtschaftliche Betriebsfläche für Tierhaltung und pflanzliche Produktion’ bezeichnet eine bebaute oder unbebaute Fläche, die vorwiegend dem landwirtschaftlichen Betrieb, primär der Tierhaltung und der pflanzlichen Produktion, dient. Diese umfasst auch die Gebäude- und Freiflächen.'),
('7600', 'Forstwirtschaftliche Betriebsfläche', 'Forstwirtschaftliche Betriebsfläche bezeichnet eine bebaute oder unbebaute Fläche, die dem forstwirtschaftlichen Betrieb ohne eine Wohnnutzung dient.');
CREATE TABLE ax_funktion_flaechebesondererfunktionalerpraegung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_flaechebesondererfunktionalerpraegung IS 'Alias: "AX_Funktion_FlaecheBesondererFunktionalerPraegung", UML-Typ: Enumeration';
INSERT INTO ax_funktion_flaechebesondererfunktionalerpraegung (wert,beschreibung,dokumentation) VALUES
('1100', 'Öffentliche Zwecke', 'Öffentliche Zwecke bezeichnet eine Fläche, die vorwiegend der Erfüllung öffentlicher Aufgaben und dem Gemeinwesen dient.'),
('1110', 'Regierung und Verwaltung', 'Regierung und Verwaltung bezeichnet eine Fläche auf der vorwiegend Gebäude der öffentlichen Regierung und Verwaltung, z. B. Rathaus, Gericht, Kreisverwaltung stehen.'),
('1120', 'Bildung und Wissenschaft', 'Bildung und Wissenschaft bezeichnet eine Fläche, auf der vorwiegend Gebäude stehen, in denen geistige, kulturelle und soziale Fähigkeiten vermittelt werden und/oder wissenschaftliche Forschung betrieben wird (z.B. Schulen, Universitäten, Institute).'),
('1130', 'Kultur', 'Kultur’ bezeichnet eine Fläche auf der vorwiegend Anlagen und Gebäude für kulturelle Zwecke, z.B. Konzert- und Museumsgebäude, Bibliotheken, Theater, Schlösser und Burgen stehen.'),
('1140', 'Religiöse Einrichtung', 'Religiöse Einrichtung bezeichnet eine Fläche auf der vorwiegend religiöse Gebäude stehen.'),
('1150', 'Gesundheit, Kur', 'Gesundheit, Kur bezeichnet eine Fläche auf der vorwiegend Gebäude des Gesundheitswesens stehen, z.B. Krankenhäuser, Heil- und Pflegeanstalten.'),
('1160', 'Soziales', 'Soziales bezeichnet eine Fläche auf der vorwiegend Gebäude des Sozialwesens stehen, z. B. Kindergärten, Jugend- und Senioreneinrichtungen, Freizeit-, Fremden- und Obdachlosenheime.'),
('1170', 'Sicherheit und Ordnung', 'Sicherheit und Ordnung bezeichnet eine Fläche auf der vorwiegend Anlagen und Gebäude der Polizei, der Bundeswehr, der Feuerwehr und der Justizvollzugsbehörden stehen.'),
('1180', 'Medien und Kommunikation', 'Medien und Kommunikation bezeichnet eine Fläche auf der vorwiegend Anlagen und Gebäude für die Erzeugung und Verbreitung von Printmedien, Hörfunk, Film und Fernsehen sowie Internet und Telefonie stehen.'),
('1200', 'Parken', 'Parken bezeichnet eine Fläche die vorwiegend dem Abstellen von Fahrzeugen dient und zu diesem Zweck ggf. mit Gebäuden, Bauwerken, Anlagen oder Kennzeichnungen versehen ist.'),
('1300', 'Historische Anlage', 'Historische Anlage ist eine Fläche mit historischen Anlagen, z. B. historischen Stadtmauern und -türmen, Denkmälern und Ausgrabungsstätten, sofern keine konkretere Nutzungszuordnung möglich ist.'),
('1310', 'Burg-, Festungsanlage', 'Burg-, Festungsanlage ist eine Fläche mit historischen Wehranlagen.'),
('1320', 'Schlossanlage', 'Schlossanlage ist eine Fläche, die der Ansiedlung des Adels dient oder diente.');
CREATE TABLE ax_zustand_halde (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_halde IS 'Alias: "AX_Zustand_Halde", UML-Typ: Enumeration';
INSERT INTO ax_zustand_halde (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb, stillgelegt, verlassen', 'Außer Betrieb, stillgelegt, verlassen bedeutet, dass sich die Halde nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('8000', 'Erweiterung, Neuansiedlung', 'Erweiterung, Neuansiedlung bedeutet, dass die Fläche in ihrer Nutzung gemäß der Objektart erweitert wird und eine Fertigstellung absehbar ist.');
CREATE TABLE ax_zustand_bergbaubetrieb (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_bergbaubetrieb IS 'Alias: "AX_Zustand_Bergbaubetrieb", UML-Typ: Enumeration';
INSERT INTO ax_zustand_bergbaubetrieb (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb, stillgelegt, verlassen', 'Außer Betrieb, stillgelegt, verlassen bedeutet, dass sich der Bergbaubetrieb nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('8000', 'Erweiterung, Neuansiedlung', 'Erweiterung, Neuansiedlung bedeutet, dass die Fläche in ihrer Nutzung gemäß der Objektart erweitert wird und eine Fertigstellung absehbar ist.');
CREATE TABLE ax_lagergut_industrieundgewerbeflaeche (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_lagergut_industrieundgewerbeflaeche IS 'Alias: "AX_Lagergut_IndustrieUndGewerbeflaeche", UML-Typ: Enumeration';
INSERT INTO ax_lagergut_industrieundgewerbeflaeche (wert,beschreibung,dokumentation) VALUES
('1000', 'Baustoffe', 'Baustoffe sind sämtliche im Bauwesen verwendete Materialien, die als Lagergut aufbewahrt werden.'),
('2000', 'Kohle, Erz und Salz', 'Kohle, Erz und Salz sind durch Bergbau oder Tagebau gewonnene Abbaugüter, die für eine Weiterverwendung (vorübergehend) gelagert werden.'),
('3000', 'Öl', 'Öl ist eine organische Flüssigkeit, die als Rohstoff gewonnen wird und in der Industrie vielseitige Verwendung findet.'),
('4000', 'Erdreich', 'Erdreich bezeichnet eine Fläche auf der Erdreich gelagert wird. Erdreich im vorliegenden Sinne bezeichnet Oberflächenmaterial, das überwiegend aus Mutterboden (Humusanteil, feine Korngrößen) besteht.'),
('5000', 'Schutt', 'Schutt ist eine nicht verfestigte Anhäufung von Trümmerstücken.'),
('6000', 'Schlacke', 'Schlacke ist ein Rückstand aus einem Schmelz- oder Verbrennungsprozess.'),
('7000', 'Abraum', 'Abraum sind unbrauchbare Boden- und Gesteinsmassen.'),
('8000', 'Schrott, Altmaterial', 'Schrott, Altmaterial sind Wertstoffe, die als Sekundärrohstoffe dienen.'),
('9000', 'Gas', 'Gas bezeichnet den Aggregatzustand einer Materie ohne bestimmte Gestalt.'),
('9999', 'Sonstiges', 'Sonstiges bedeutet, dass das Lagergut bekannt, dieses aber in der Werteliste nicht aufgeführt ist.');
CREATE TABLE ax_artderbebauung_flaechegemischternutzung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_artderbebauung_flaechegemischternutzung IS 'Alias: "AX_ArtDerBebauung_FlaecheGemischterNutzung", UML-Typ: Enumeration';
INSERT INTO ax_artderbebauung_flaechegemischternutzung (wert,beschreibung,dokumentation) VALUES
('1000', 'Offen', 'Offen beschreibt die Bebauung von Fläche gemischter Nutzung, die vorwiegend durch einzelstehende Gebäude charakterisiert wird.'),
('2000', 'Geschlossen', 'Geschlossen beschreibt die Bebauung von Fläche gemischter Nutzung, die vorwiegend durch zusammenhängende Gebäude charakterisiert wird. Die Gebäudeabdeckung ist in der Regel > 50 Prozent der Fläche.');
CREATE TABLE ax_zustand_wohnbauflaeche (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_wohnbauflaeche IS 'Alias: "AX_Zustand_Wohnbauflaeche", UML-Typ: Enumeration';
INSERT INTO ax_zustand_wohnbauflaeche (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb, stillgelegt, verlassen', 'Außer Betrieb, stillgelegt, verlassen bedeutet, dass sich die Fläche nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('8000', 'Erweiterung, Neuansiedlung', 'Erweiterung, Neuansiedlung bedeutet, dass die Fläche in ihrer Nutzung gemäß der Objektart erweitert wird und eine Fertigstellung absehbar ist.');
CREATE TABLE ax_zustand_friedhof (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_friedhof IS 'Alias: "AX_Zustand_Friedhof", UML-Typ: Enumeration';
INSERT INTO ax_zustand_friedhof (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb, stillgelegt, verlassen', 'Außer Betrieb, stillgelegt, verlassen bedeutet, dass sich die Fläche nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('8000', 'Erweiterung, Neuansiedlung', 'Erweiterung, Neuansiedlung bedeutet, dass die Fläche in ihrer Nutzung gemäß der Objektart erweitert wird und eine Fertigstellung absehbar ist.');
CREATE TABLE ax_foerdergut_industrieundgewerbeflaeche (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_foerdergut_industrieundgewerbeflaeche IS 'Alias: "AX_Foerdergut_IndustrieUndGewerbeflaeche", UML-Typ: Enumeration';
INSERT INTO ax_foerdergut_industrieundgewerbeflaeche (wert,beschreibung,dokumentation) VALUES
('1000', 'Erdöl', 'Erdöl ist ein flüssiges und brennbares Kohlenwasserstoffgemisch, das gefördert wird.'),
('2000', 'Erdgas', 'Erdgas ist ein in der Erdkruste vorkommendes brennbares Naturgas, das gefördert wird.'),
('3000', 'Sole, Lauge', 'Sole, Lauge ist ein kochsalzhaltiges Wasser, das gefördert wird.'),
('4000', 'Kohlensäure', 'Kohlensäure ist eine schwache Säure, die durch Lösung von Kohlendioxid in Wasser entsteht und gefördert
wird.'),
('5000', 'Erdwärme', 'Erdwärme ist eine auf natürlichem Wege sich erneuernde Wärmeenergie, die aus einer geothermisch geringen Tiefenstufe der Erdkruste gefördert wird.');
CREATE TABLE ax_lagergut_halde (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_lagergut_halde IS 'Alias: "AX_Lagergut_Halde", UML-Typ: Enumeration';
INSERT INTO ax_lagergut_halde (wert,beschreibung,dokumentation) VALUES
('1000', 'Baustoffe', 'Baustoffe sind sämtliche im Bauwesen verwendete Materialien, die als Lagergut aufbewahrt werden.'),
('2000', 'Kohle', 'Kohle ist ein Lagergut, das durch Inkohlung (Umwandlungsprozess pflanzlicher Substanzen) entstanden ist.'),
('4000', 'Erdreich', 'Erdreich bezeichnet eine Fläche auf der Erdreich gelagert wird. Erdreich im vorliegenden Sinne bezeichnet Oberflächenmaterial, das überwiegend aus Mutterboden (Humusanteil, feine Korngrößen) besteht.'),
('5000', 'Schutt', 'Schutt ist eine nicht verfestigte Anhäufung von Trümmerstücken.'),
('6000', 'Schlacke', 'Schlacke ist ein Rückstand aus einem Schmelz- oder Verbrennungsprozess.'),
('7000', 'Abraum', 'Abraum sind unbrauchbare Boden- und Gesteinsmassen.'),
('8000', 'Schrott, Altmaterial', 'Schrott, Altmaterial sind Wertstoffe, die als Sekundärrohstoffe dienen.'),
('9999', 'Sonstiges', 'Sonstiges bedeutet, dass das Lagergut bekannt, dieses aber in der Werteliste nicht aufgeführt ist.');
CREATE TABLE ax_artderbebauung_flaechebesondererfunktionalerpraegung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_artderbebauung_flaechebesondererfunktionalerpraegung IS 'Alias: "AX_ArtDerBebauung_FlaecheBesondererFunktionalerPraegung", UML-Typ: Enumeration';
INSERT INTO ax_artderbebauung_flaechebesondererfunktionalerpraegung (wert,beschreibung,dokumentation) VALUES
('1000', 'Offen', 'Offen beschreibt die Bebauung von Fläche besonderer funktionaler Prägung, die vorwiegend durch einzelstehende Gebäude charakterisiert wird.'),
('2000', 'Geschlossen', 'Geschlossen beschreibt die Bebauung von Fläche besonderer funktionaler Prägung, die vorwiegend durch zusammenhängende Gebäude charakterisiert wird. Die Gebäudeabdeckung ist in der Regel > 50 Prozent der Fläche.');
CREATE TABLE ax_vegetationsmerkmal_landwirtschaft (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_vegetationsmerkmal_landwirtschaft IS 'Alias: "AX_Vegetationsmerkmal_Landwirtschaft", UML-Typ: Enumeration';
INSERT INTO ax_vegetationsmerkmal_landwirtschaft (wert,beschreibung,dokumentation) VALUES
('1010', 'Ackerland', 'Ackerland ist eine Fläche für den Anbau von Feldfrüchten (z.B. Getreide, Hülsenfrüchte, Hackfrüchte) und Beerenfrüchten (z.B. Erdbeeren).'),
('1011', 'Streuobstacker', 'Streuobstacker beschreibt den Bewuchs einer Ackerfläche mit Obstbäumen.'),
('1012', 'Hopfen', 'Hopfen ist eine mit speziellen Vorrichtungen ausgestattete Agrarfläche für den Anbau von Hopfen.'),
('1013', 'Spargel', 'Spargel beschreibt den Bewuchs einer Agrarfläche mit Spargelgewächsen.'),
('1014', 'Hanf', 'Hanf beschreibt den Bewuchs einer Agrarfläche mit Nutzhanf.'),
('1020', 'Grünland', 'Grünland ist eine Grasfläche, die gemäht oder beweidet wird.'),
('1021', 'Streuobstwiese', 'Streuobstwiese beschreibt den Bewuchs einer Grünlandfläche mit Obstbäumen.'),
('1022', 'Salzweide', 'Salzweide ist eine vom Meer periodisch überflutete Weidefläche, in der eine Salzpflanzenvegetation gedeiht. Dieser Bereich bildet den natürlichen Übergang vom Meer zum Festland.'),
('1030', 'Gartenbauland', 'Gartenbauland ist eine Fläche, die dem gewerbsmäßigen Anbau von Gartengewächsen (Gemüse, Obst und Blumen) sowie für die Aufzucht von Kulturpflanzen dient.'),
('1031', 'Baumschule', 'Baumschule ist eine Fläche, auf der Holzgewächse aus Samen, Ablegern oder Stecklingen unter mehrmaligem Umpflanzen (Verschulen) gezogen werden.'),
('1040', 'Rebfläche', 'Rebfläche ist eine mit speziellen Vorrichtungen ausgestattete Agrarfläche, auf der Weinstöcke angepflanzt sind.'),
('1050', 'Obst- und Nussplantage', 'Obst- und Nussplantage ist eine Fläche, die vorwiegend dem Intensivanbau dient und mit Obst-, Nussbäumen oder -sträuchern bepflanzt ist. Im Unterschied zu Streuobst handelt es sich hierbei um gleichmäßige und dichter angelegte Monokulturen.'),
('1051', 'Obst- und Nussbaumplantage', 'Obst- und Nussbaumplantage ist eine landwirtschaftliche Fläche, die vorwiegend dem Intensivanbau dient und mit Obst- oder Nussbäumen bepflanzt ist.'),
('1052', 'Obst- und Nussstrauchplantage', 'Obst- und Nussstrauchplantage ist eine landwirtschaftliche Fläche, die vorwiegend dem Intensivanbau dient und mit Obst- oder Nusssträuchern bepflanzt ist.'),
('1060', 'Weihnachtsbaumkultur', 'Weihnachtsbaumkultur bezeichnet eine landwirtschaftliche Fläche, die vorrangig mit Weihnachtsbäumen bepflanzt ist.'),
('1100', 'Kurzumtriebsplantage', 'Kurzumtriebsplantagen sind Flächen, auf denen Baumarten mit dem Ziel baldiger Holzentnahme angepflanzt werden und deren Bestände eine Umtriebszeit von nicht länger als 20 Jahren haben.'),
('1200', 'Brachland', 'Brachland ist eine Fläche der Landwirtschaft, die seit längerem nicht mehr zu Produktionszwecken genutzt wird.');
CREATE TABLE ax_oberflaechenmaterial_unlandvegetationsloseflaeche (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_oberflaechenmaterial_unlandvegetationsloseflaeche IS 'Alias: "AX_Oberflaechenmaterial_UnlandVegetationsloseFlaeche", UML-Typ: Enumeration';
INSERT INTO ax_oberflaechenmaterial_unlandvegetationsloseflaeche (wert,beschreibung,dokumentation) VALUES
('1010', 'Fels', 'Fels bedeutet, dass die Erdoberfläche aus einer festen Gesteinsmasse besteht.'),
('1020', 'Steine, Schotter', 'Steine, Schotter bedeutet, dass die Erdoberfläche mit zerkleinertem Gestein unterschiedlicher Größe bedeckt ist.'),
('1030', 'Geröll', 'Geröll bedeutet, dass die Erdoberfläche mit durch fließendes Wasser abgerundeten Gesteinen bedeckt ist.'),
('1040', 'Sand', 'Sand bedeutet, dass die Erdoberfläche mit kleinen, losen Gesteinskörnern bedeckt ist.'),
('1110', 'Schnee', 'Schnee bedeutet, dass die Erdoberfläche für die größte Zeit des Jahres mit Schnee bedeckt ist.'),
('1120', 'Eis, Firn', 'Eis, Firn bedeutet, dass die Erdoberfläche mit altem, grobkörnigem, mehrjährigem Schnee im Hochgebirge bedeckt ist, der unter zunehmendem Druck zu Gletschereis wird.');
CREATE TABLE ax_funktion_unlandvegetationsloseflaeche (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_unlandvegetationsloseflaeche IS 'Alias: "AX_Funktion_UnlandVegetationsloseFlaeche", UML-Typ: Enumeration';
INSERT INTO ax_funktion_unlandvegetationsloseflaeche (wert,beschreibung,dokumentation) VALUES
('1000', 'Vegetationslose Fläche', 'Vegetationslose Fläche ist eine Fläche ohne nennenswerten Bewuchs aufgrund besonderer Bodenbeschaffenheit.'),
('1100', 'Gewässerbegleitfläche', 'Gewässerbegleitfläche bezeichnet eine bebaute oder unbebaute Fläche, die einem Gewässer zugeordnet wird. Die Gewässerbegleitfläche ist nicht Bestandteil der Gewässerfläche.'),
('1110', 'Bebaute Gewässerbegleitfläche', 'Bebaute Gewässerbegleitfläche bezeichnet eine bebaute Fläche, die einem Gewässer zugeordnet wird. Sie ist nicht Bestandteil der Gewässerfläche.'),
('1120', 'Unbebaute Gewässerbegleitfläche', 'Unbebaute Gewässerbegleitfläche bezeichnet eine unbebaute Fläche, die einem Gewässer zugeordnet wird. Sie ist nicht Bestandteil der Gewässerfläche.'),
('1200', 'Sukzessionsfläche', 'Sukzessionsfläche ist eine Fläche, die dauerhaft aus der landwirtschaftlichen oder sonstigen bisherigen Nutzung herausgenommen ist und die in den Urzustand z. B. Gehölz, Moor, Heide übergeht.'),
('1300', 'Naturnahe Fläche', 'Naturnahe Fläche ist eine nicht zum Anbau von Kulturpflanzen genutzte Fläche, die mit Pflanzen bewachsen ist.');
CREATE TABLE ax_vegetationsmerkmal_gehoelz (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_vegetationsmerkmal_gehoelz IS 'Alias: "AX_Vegetationsmerkmal_Gehoelz", UML-Typ: Enumeration';
INSERT INTO ax_vegetationsmerkmal_gehoelz (wert,beschreibung,dokumentation) VALUES
('1400', 'Latschenkiefer', 'Latschenkiefer beschreibt den Bewuchs einer Vegetationsfläche mit Latschenkiefer.');
CREATE TABLE ax_funktion_gehoelz (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_gehoelz IS 'Alias: "AX_Funktion_Gehoelz", UML-Typ: Enumeration';
INSERT INTO ax_funktion_gehoelz (wert,beschreibung,dokumentation) VALUES
('1000', 'Windschutz', 'Windschutz ist ein dichter Gehölzbestand, der die angrenzenden Flächen oder Objekte vor Wind schützt.');
CREATE TABLE ax_zustand_wald (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_wald IS 'Alias: "AX_Zustand_Wald", UML-Typ: Enumeration';
INSERT INTO ax_zustand_wald (wert,beschreibung,dokumentation) VALUES
('6100', 'Verjüngungs-, Neuanpflanzungsfläche', 'Verjüngungs-, Neuanpflanzungsfläche bedeutet, dass sich der Wald durch Aufforstung, Naturverjüngung oder durch Anpflanzung neu bildet.'),
('7100', 'Dauerhaft unbestockt', 'Dauerhaft unbestockt umfasst alle als Waldflächen geltenden Flächen, auf denen dauerhaft keine Bäume stehen, aber stehen könnten. Hierzu zählen z. B. Lichtungen oder Äsungsflächen.');
CREATE TABLE ax_vegetationsmerkmal_wald (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_vegetationsmerkmal_wald IS 'Alias: "AX_Vegetationsmerkmal_Wald", UML-Typ: Enumeration';
INSERT INTO ax_vegetationsmerkmal_wald (wert,beschreibung,dokumentation) VALUES
('1100', 'Laubholz', 'Laubholz beschreibt den Bewuchs einer Vegetationsfläche mit Laubbäumen.'),
('1200', 'Nadelholz', 'Nadelholz beschreibt den Bewuchs einer Vegetationsfläche mit Nadelbäumen.'),
('1300', 'Laub- und Nadelholz', 'Laub- und Nadelholz beschreibt den Bewuchs einer Vegetationsfläche mit Laub- und Nadelbäumen.'),
('1310', 'Laubholz mit Nadelbäumen', 'Laubholz mit Nadelbäumen beschreibt den Bewuchs einer Vegetationsfläche mit Laub- und Nadelbäumen. Dabei dominieren die Laubbäume das Erscheinungsbild.'),
('1320', 'Nadelholz mit Laubbäumen', 'Nadelholz mit Laubbäumen beschreibt den Bewuchs einer Vegetationsfläche mit Nadel- und Laubbäumen. Dabei dominieren die Nadelbäume das Erscheinungsbild.');
CREATE TABLE ax_nutzung_wald (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_nutzung_wald IS 'Alias: "AX_Nutzung_Wald", UML-Typ: Enumeration';
INSERT INTO ax_nutzung_wald (wert,beschreibung,dokumentation) VALUES
('1000', 'Forstwirtschaftsfläche', 'Forstwirtschaftsfläche bezeichnet eine Waldfläche, mit oder ohne Bäume, welche forstwirtschaftlich genutzt wird. Hierzu zählen keine Kurzumtriebsplantagen.'),
('2000', 'Unbewirtschaftet', 'Unbewirtschaftet bezeichnet eine Waldfläche, mit oder ohne Bäume, welche nicht bewirtschaftet bzw. nicht wirtschaftlich genutzt wird. Hierzu können auch Waldflächen unter Freileitungen zählen.'),
('3000', 'Waldbestattungsfläche', 'Waldbestattungsfläche ist eine Fläche im Wald, die zur Bestattung dient oder gedient hat.');
CREATE TABLE ax_funktion_strasse (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_strasse IS 'Alias: "AX_Funktion_Strasse", UML-Typ: Enumeration';
INSERT INTO ax_funktion_strasse (wert,beschreibung,dokumentation) VALUES
('2311', 'Gebäude- und Freifläche zu Verkehrsanlagen, Straße', 'Gebäude- und Freifläche zu Verkehrsanlagen, Straße ist eine Fläche. die der Abwicklung und Sicherheit des Verkehrs sowie der Unterhaltung der Verkehrsfläche dient.'),
('2312', 'Begleitfläche Straßenverkehr', 'Begleitfläche Straßenverkehr bezeichnet eine unbebaute Fläche, die einer Straße zugeordnet wird. Die Begleitfläche Straßenverkehr ist nicht Bestandteil der Fahrbahn.'),
('2313', 'Straßenentwässerungsanlage', 'Straßenentwässerungsanlage ist der zur Entwässerung dienende Bestandteil der Verkehrsanlage.'),
('2314', 'Betriebsfläche Straßenverkehr', 'Betriebsfläche Straßenverkehr bezeichnet bebaute oder unbebaute Flächen, die vorwiegend der Versorgung und Unterhaltung der Verkehrsflächen des Straßenverkehrs dienen. Hierzu gehören z.B. Straßenmeistereien.'),
('2315', 'Fahrbahn', 'Fahrbahn bezeichnet Flächen, die den zusammenhängenden, befestigten Teil der Straße bilden, als Verkehrsraum dienen und mit Fahrzeugen befahren werden dürfen. Zur Fahrbahn gehören auch Stand- und Kriechspuren.'),
('5130', 'Fußgängerzone', 'Fußgängerzone ist ein dem Fußgängerverkehr vorbehaltener Bereich, in dem ausnahmsweise öffentlicher Personenverkehr, Lieferverkehr oder Fahrradverkehr zulässig sein kann.');
CREATE TABLE ax_zustand_flugverkehr (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_flugverkehr IS 'Alias: "AX_Zustand_Flugverkehr", UML-Typ: Enumeration';
INSERT INTO ax_zustand_flugverkehr (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb, stillgelegt, verlassen', 'Außer Betrieb, stillgelegt, verlassen bedeutet, dass sich Flugverkehr nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('4000', 'Im Bau', 'Im Bau bedeutet, dass sich überwiegende Teile von Flugverkehr im Bau befinden.'),
('8000', 'Erweiterung, Neuansiedlung', 'Erweiterung, Neuansiedlung bedeutet, dass die Fläche in ihrer Nutzung gemäß der Objektart erweitert wird und eine Fertigstellung absehbar ist.');
CREATE TABLE ax_bahnkategorie_bahnstrecke (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_bahnkategorie_bahnstrecke IS 'Alias: "AX_Bahnkategorie_Bahnstrecke", UML-Typ: Enumeration';
INSERT INTO ax_bahnkategorie_bahnstrecke (wert,beschreibung,dokumentation) VALUES
('1100', 'Eisenbahn', 'Eisenbahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem im Nah- und/oder Fernverkehr Personen befördert und/oder Güter transportiert werden.'),
('1101', 'Personenverkehr', 'Personenverkehr ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem im Nah- und/oder Fernverkehr Personen befördert werden.'),
('1102', 'Güterverkehr', 'Güterverkehr ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem im Nah- und/oder Fernverkehr Güter transportiert werden.'),
('1104', 'S-Bahn', 'S-Bahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, der zur schnellen Personenbeförderung in Ballungsräumen dient und meist auf eigenen Gleisen verläuft.'),
('1200', 'Stadtbahn', 'Stadtbahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem eine elektrisch betriebene Schienenbahn zur Personenbeförderung im öffentlichen Nahverkehr fährt. Sie kann sowohl ober- als auch unterirdisch verlaufen.'),
('1201', 'Straßenbahn', 'Straßenbahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem eine elektrisch betriebene Schienenbahn zur Personenbeförderung fährt. Sie verläuft i. d. R. oberirdisch.'),
('1202', 'U-Bahn', 'U-Bahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem eine elektrisch betriebene Schienenbahn zur Personenbeförderung in Großstädten fährt. Sie verläuft i. d. R. unterirdisch.'),
('1300', 'Seilbahn, Bergbahn', 'Seilbahn, Bergbahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem eine Schienenbahn große Höhenunterschiede überwindet.'),
('1301', 'Zahnradbahn', 'Zahnradbahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem eine Schienenbahn mittels Zahnradantrieb große Höhenunterschiede in stark geneigtem Gelände überwindet.'),
('1302', 'Standseilbahn', 'Standseilbahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem eine Schienenbahn auf einer stark geneigten, meist kurzen und geraden Strecke verläuft. Mit Hilfe eines oder mehrerer Zugseile wird ein Schienenfahrzeug bergauf gezogen und gleichzeitig ein zweites bergab gelassen.'),
('1400', 'Museumsbahn', 'Museumsbahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem ausschließlich Touristen in alten, meist restaurierten Zügen befördert werden.'),
('1500', 'Bahn im Freizeitpark', 'Bahn im Freizeitpark ist die Bezeichnung für einen schienengebundenen Verkehrsweg innerhalb eines Freizeitparks.'),
('1600', 'Magnetschwebebahn', 'Magnetschwebebahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem räderlose Schienenfahrzeuge mit Hilfe von Magnetfeldern an oder auf einer Fahrschiene schwebend entlanggeführt werden.');
CREATE TABLE ax_funktion_strassenachse (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_strassenachse IS 'Alias: "AX_Funktion_Strassenachse", UML-Typ: Enumeration';
INSERT INTO ax_funktion_strassenachse (wert,beschreibung,dokumentation) VALUES
('1808', 'Fußgängerzone', 'Fußgängerzone ist ein dem Fußgängerverkehr vorbehaltener Bereich, in dem ausnahmsweise öffentlicher Personenverkehr, Lieferverkehr oder Fahrradverkehr zulässig sein kann.');
CREATE TABLE ax_spurweite (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_spurweite IS 'Alias: "AX_Spurweite", UML-Typ: Enumeration';
INSERT INTO ax_spurweite (wert,beschreibung,dokumentation) VALUES
('1000', 'Normalspur (Regelspur, Vollspur)', 'Normalspur (Regelspur, Vollspur) hat eine Spurweite von 1435 mm. Das ist das Innenmaß zwischen den Innenkanten der Schienenköpfe eines Gleises.'),
('2000', 'Schmalspur', 'Schmalspur ist eine Spurweite, die kleiner ist als 1435 mm.'),
('3000', 'Breitspur', 'Breitspur ist eine Spurweite, die größer ist als 1435 mm.'),
('9997', 'Attribut trifft nicht zu', 'Attribut trifft nicht zu bedeutet, dass keiner der in der Werteliste aufgeführten Attributwerte dem vorliegenden Sachverhalt entspricht.');
CREATE TABLE ax_elektrifizierung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_elektrifizierung IS 'Alias: "AX_Elektrifizierung", UML-Typ: Enumeration';
INSERT INTO ax_elektrifizierung (wert,beschreibung,dokumentation) VALUES
('1000', 'Elektrifiziert', 'Elektrifiziert bedeutet, dass den Schienenfahrzeugen über eine Oberleitung oder eine Stromschiene längs des Fahrweges elektrische Energie zugeführt werden kann.'),
('2000', 'Nicht elektrifiziert', 'Nicht elektrifiziert bedeutet, dass die Schienenfahrzeuge ohne elektrische Energie angetrieben werden.');
CREATE TABLE ax_besonderefahrstreifen (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_besonderefahrstreifen IS 'Alias: "AX_BesondereFahrstreifen", UML-Typ: Enumeration';
INSERT INTO ax_besonderefahrstreifen (wert,beschreibung,dokumentation) VALUES
('1000', 'Mit Radweg', 'Mit Radweg bedeutet, dass parallel zur Objektart ein Radweg verläuft, der aber nicht als eigenständiges Objekt erfasst wird.'),
('2000', 'Mit Fußweg', 'Mit Fußweg bedeutet, dass parallel zur Objektart ein Fußweg verläuft, der aber nicht als eigenständiges Objekt erfasst wird.'),
('3000', 'Mit Rad- und Fußweg', 'Mit Rad- und Fußweg bedeutet, dass parallel zur Objektart Objektart ein Rad- und Fußweg verläuft, der aber nicht als eigenständiges Objekt erfasst wird.');
CREATE TABLE ax_internationalebedeutung_strasse (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_internationalebedeutung_strasse IS 'Alias: "AX_InternationaleBedeutung_Strasse", UML-Typ: Enumeration';
INSERT INTO ax_internationalebedeutung_strasse (wert,beschreibung,dokumentation) VALUES
('2001', 'Europastraße', 'Europastraßen sind Abschnitte von Bundesfernstraßen, die einen Teil des von der Europäischen Konferenz der Verkehrsminister beschlossenen internationalen europäischen Straßennetzes bilden.');
CREATE TABLE ax_befahrbarkeit_fahrwegachse (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_befahrbarkeit_fahrwegachse IS 'Alias: "AX_Befahrbarkeit_Fahrwegachse", UML-Typ: Enumeration';
INSERT INTO ax_befahrbarkeit_fahrwegachse (wert,beschreibung,dokumentation) VALUES
('1000', 'Ganzjährig befahrbar', 'Ganzjährig befahrbar bedeutet, dass Fahrwegachse zu jeder Jahreszeit befahrbar ist.'),
('2000', 'Eingeschränkt befahrbar', 'Eingeschränkt befahrbar bedeutet, dass Fahrwegachse nicht ganzjährig befahrbar ist.');
CREATE TABLE ax_funktion_wegachse (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_wegachse IS 'Alias: "AX_Funktion_Wegachse", UML-Typ: Enumeration';
INSERT INTO ax_funktion_wegachse (wert,beschreibung,dokumentation) VALUES
('5211', 'Hauptwirtschaftsweg', 'Hauptwirtschaftsweg ist ein Weg mit fester Fahrbahndecke zur Erschließung eines oder mehrerer Grundstücke, der für den Kraftverkehr zu jeder Jahreszeit befahrbar ist. Dazu gehören auch Lkw-befahrbare Wege im Wald, die dem forstwirtschaftlichen Holztransport zu jeder Zeit dienen.'),
('5212', 'Wirtschaftsweg', 'Wirtschaftsweg ist ein leicht- oder unbefestigter Weg zur Erschließung land- und forstwirtschaftlicher Flächen.'),
('5240', 'Radweg', 'Radweg ist ein Weg, der als besonders gekennzeichneter und abgegrenzter Teil einer Straße oder mit selbständiger Linienführung für den Fahrradverkehr bestimmt ist.'),
('5250', 'Rad- und Fußweg', 'Rad- und Fußweg ist ein Weg, der als besonders gekennzeichneter und abgegrenzter Teil einer Straße oder mit selbständiger Linienführung ausschließlich für den Fahrrad- und Fußgängerverkehr bestimmt ist.');
CREATE TABLE ax_bahnkategorie (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_bahnkategorie IS 'Alias: "AX_Bahnkategorie", UML-Typ: Enumeration';
INSERT INTO ax_bahnkategorie (wert,beschreibung,dokumentation) VALUES
('1100', 'Eisenbahn', 'Eisenbahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem im Nah- und Fernverkehr Personen befördert und Güter transportiert werden.'),
('1101', 'Personenverkehr', 'Personenverkehr ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem im Nah- und / oder Fernverkehr Personen transportiert werden.'),
('1102', 'Güterverkehr', 'Güterverkehr ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem im Nah- und / oder Fernverkehr Güter transportiert werden.'),
('1103', 'Betriebsverkehr', 'Betriebsverkehr ist die Bezeichnung für eine Bahnverkehrsanlage, das aus innerbetrieblichen Gründen erforderlich ist.'),
('1104', 'S-Bahn', 'S-Bahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, der zur schnellen Personenbeförderung in Ballungsräumen dient und meist auf eigenen Gleisen verläuft.'),
('1200', 'Stadtbahn', 'Stadtbahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem eine elektrisch betriebene Schienenbahn zur Personenbeförderung im öffentlichen Nahverkehr fährt. Sie kann sowohl ober- als auch unterirdisch verlaufen.'),
('1201', 'Straßenbahn', 'Straßenbahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem eine elektrisch betriebene Schienenbahn zur Personenbeförderung fährt. Sie verläuft i. d. R. oberirdisch.'),
('1202', 'U-Bahn', 'U-Bahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem eine elektrisch betriebene Schienenbahn zur Personenbeförderung in Großstädten fährt. Sie verläuft i. d. R. unterirdisch.'),
('1300', 'Seilbahn, Bergbahn', 'Seilbahn, Bergbahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem eine Schienenbahn große Höhenunterschiede überwindet.'),
('1301', 'Zahnradbahn', 'Zahnradbahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem eine Schienenbahn mittels Zahnradantrieb große Höhenunterschiede in stark geneigtem Gelände überwindet.'),
('1302', 'Standseilbahn', 'Standseilbahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem eine Schienenbahn auf einer stark geneigten, meist kurzen und geraden Strecke verläuft. Mit Hilfe eines oder mehrerer Zugseile wird ein Schienenfahrzeug bergauf gezogen und gleichzeitig ein zweites bergab gelassen.'),
('1400', 'Museumsbahn', 'Museumsbahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem ausschließlich Touristen in alten, meist restaurierten Zügen befördert werden.'),
('1500', 'Bahn im Freizeitpark', 'Bahn im Freizeitpark ist die Bezeichnung für einen schienengebundenen Verkehrsweg innerhalb eines Freizeitparks.'),
('1600', 'Magnetschwebebahn', 'Magnetschwebebahn ist die Bezeichnung für einen schienengebundenen Verkehrsweg, auf dem räderlose Schienenfahrzeuge mit Hilfe von Magnetfeldern an oder auf einer Fahrschiene schwebend entlanggeführt werden.');
CREATE TABLE ax_besondereverkehrsbedeutung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_besondereverkehrsbedeutung IS 'Alias: "AX_BesondereVerkehrsbedeutung", UML-Typ: Enumeration';
INSERT INTO ax_besondereverkehrsbedeutung (wert,beschreibung,dokumentation) VALUES
('1000', 'Überörtlicher Verkehr', 'Überörtlicher Verkehr beschreibt das durchgehende Straßennetz des tatsächlich stattfindenden Verkehrs, über den aufgrund des Ausbauzustandes und der örtlichen Verkehrsregelung der überörtliche Verkehr geleitet wird.
Dieser ist unabhängig von gesetzlichen Festlegungen (z. B. Landesstraßengesetz). Deshalb richtet er sich auch nicht nach der Widmung. Die Werteart BVB 1000 beschreibt somit gleichzeitig den überörtlichen Verkehr und den dazugehörigen innerörtlichen Durchgangsverkehr.'),
('1003', 'Nahverkehr', 'Nahverkehr beschreibt sowohl den zwischenörtlichen Verkehr ohne überörtliche Bedeutung, als auch den innerörtlichen Durchgangsverkehr des angebundenen Ortes.'),
('2000', 'Ortsverkehr', 'Ortsverkehr beschreibt den tatsächlich stattfindenden Verkehr auf einer Straße (Ortsstraße), unabhängig von örtlichen Festlegungen (z. B. Ortssatzungen).
Unter Ortsverkehr werden sowohl Sammel- als auch Anliegerverkehr subsumiert. Er bezeichnet sämtliche innerörtliche Verkehrswege, die nicht dem überörtlichen Verkehr oder Nahverkehr zugeordnet werden können.'),
('2001', 'Sammelverkehr', 'Sammelverkehr beschreibt den tatsächlich stattfindenden Verkehr auf einer Straße (Sammelstraße), unabhängig von örtlichen Festlegungen (z. B. Ortssatzungen).
Die Sammelstraße leitet hauptsächlich den innerörtlichen Verkehr von den Anliegerstraßen zum überörtlichen Verkehr oder Nahverkehr.'),
('2002', 'Anliegerverkehr', 'Anliegerverkehr beschreibt den tatsächlich stattfindenden Verkehr auf einer Straße (Anliegerstraße), unabhängig von örtlichen Festlegungen (z. B. Ortssatzungen). Die Anliegerstraße ist eine Straße auf die jeder Straßenanlieger von seinem Anwesen aus freie Zufahrt hat und die nicht die Funktion einer Sammelstraße übernimmt.');
CREATE TABLE ax_markierung_wegachse (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_markierung_wegachse IS 'Alias: "AX_Markierung_Wegachse", UML-Typ: Enumeration';
INSERT INTO ax_markierung_wegachse (wert,beschreibung,dokumentation) VALUES
('1401', 'Gekennzeichneter Wanderweg', 'Gekennzeichneter Wanderweg ist ein als Wanderweg eindeutig markierter Weg.'),
('1402', 'Gekennzeichneter Rad(wander)weg', 'Gekennzeichneter Rad(wander)weg ist ein als Rad(wander)weg eindeutig markierter Weg.');
CREATE TABLE ax_zustand_schiffsverkehr (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_schiffsverkehr IS 'Alias: "AX_Zustand_Schiffsverkehr", UML-Typ: Enumeration';
INSERT INTO ax_zustand_schiffsverkehr (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb, stillgelegt, verlassen', 'Außer Betrieb, stillgelegt, verlassen bedeutet, dass sich Schiffsverkehr nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('4000', 'Im Bau', 'Im Bau bedeutet, dass sich überwiegende Teile von Schiffsverkehr im Bau befinden.'),
('8000', 'Erweiterung, Neuansiedlung', 'Erweiterung, Neuansiedlung bedeutet, dass die Fläche in ihrer Nutzung gemäß der Objektart erweitert wird und eine Fertigstellung absehbar ist.');
CREATE TABLE ax_befestigung_fahrwegachse (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_befestigung_fahrwegachse IS 'Alias: "AX_Befestigung_Fahrwegachse", UML-Typ: Enumeration';
INSERT INTO ax_befestigung_fahrwegachse (wert,beschreibung,dokumentation) VALUES
('1000', 'Leicht befestigt', 'Leicht befestigt bedeutet, dass Fahrwegachse mit einem Belag versehen ist.'),
('2000', 'Unbefestigt', 'Unbefestigt bedeutet, dass Fahrwegachse nicht mit einem Belag versehen ist.');
CREATE TABLE ax_fahrbahntrennung_strasse (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_fahrbahntrennung_strasse IS 'Alias: "AX_Fahrbahntrennung_Strasse", UML-Typ: Enumeration';
INSERT INTO ax_fahrbahntrennung_strasse (wert,beschreibung,dokumentation) VALUES
('2000', 'Getrennt', 'Getrennt bedeutet, dass sich ein Grünstreifen, eine Leitplanke oder ein sonstiges Hindernis zwischen zwei Fahrbahnen befindet.');
CREATE TABLE ax_funktion_flugverkehr (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_flugverkehr IS 'Alias: "AX_Funktion_Flugverkehr", UML-Typ: Enumeration';
INSERT INTO ax_funktion_flugverkehr (wert,beschreibung,dokumentation) VALUES
('1200', 'Parken', 'Parken bezeichnet eine Fläche, die vorwiegend dem Abstellen von Fahrzeugen dient und zu diesem Zweck ggf. mit Gebäuden, Bauwerken, Anlagen oder Kennzeichnungen versehen ist.'),
('5501', 'Gebäude- und Freifläche zu Verkehrsanlagen, Luftfahrt', 'Gebäude- und Freifläche zu Verkehrsanlagen, Luftfahrt ist eine besondere Flugverkehrsfläche.'),
('5502', 'Begleitfläche Flugverkehr', 'Begleitfläche Flugverkehr bezeichnet eine unbebaute Fläche, die dem Flugverkehr zugeordnet wird. Hierzu gehören z.B. Grünflächen neben den Flugverkehrsflächen.'),
('5503', 'Betriebsfläche Flugverkehr', 'Betriebsfläche Flugverkehr bezeichnet bebaute oder unbebaute Flächen, die vorwiegend der Versorgung und Unterhaltung des Flugverkehrs dienen.');
CREATE TABLE ax_oberflaechenmaterial_strasse (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_oberflaechenmaterial_strasse IS 'Alias: "AX_Oberflaechenmaterial_Strasse", UML-Typ: Enumeration';
INSERT INTO ax_oberflaechenmaterial_strasse (wert,beschreibung,dokumentation) VALUES
('1220', 'Beton', 'Beton bedeutet, dass die Oberfläche von der Objektart aus Beton besteht.'),
('1230', 'Bitumen, Asphalt', 'Bitumen, Asphalt bedeutet, dass die Oberfläche von der Objektart aus Bitumen bzw. Asphalt besteht.'),
('1240', 'Pflaster', 'Pflaster bedeutet, dass die Oberfläche von der Objektart gepflastert ist.'),
('1250', 'Gestein, zerkleinert', 'Gestein, zerkleinert bedeutet, dass die Oberfläche von der Objektart aus Schotter, Splitt, Sand oder aus einem Gemisch dieser Materialen besteht.');
CREATE TABLE ax_funktion_platz (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_platz IS 'Alias: "AX_Funktion_Platz", UML-Typ: Enumeration';
INSERT INTO ax_funktion_platz (wert,beschreibung,dokumentation) VALUES
('5130', 'Fußgängerzone', 'Fußgängerzone ist ein dem Fußgängerverkehr vorbehaltener Bereich, in dem ausnahmsweise öffentlicher Personenverkehr, Lieferverkehr oder Fahrradverkehr zulässig sein kann.'),
('5310', 'Parkplatz', 'Parkplatz bezeichnet eine Fläche, auf der vorwiegend Anlagen und Gebäude zum Abstellen von Fahrzeugen stehen.'),
('5320', 'Rastplatz', 'Rastplatz ist eine Anlage zum Rasten der Verkehrsteilnehmer mit unmittelbarem Anschluss zur Straße ohne Versorgungseinrichtung, ggf. mit Toiletten.'),
('5330', 'Raststätte, Autohof', 'Raststätte, Autohof ist eine Anlage an Verkehrsstraßen mit Bauwerken und Einrichtungen zur Versorgung und Erholung von Reisenden. Dazu gehören auch Autohöfe gemäß der Verwaltungsvorschriften zur Straßenverkehrsordnung (VwV-StVO).'),
('5340', 'Marktplatz', 'Marktplatz ist ein Platz, auf dem Markt abgehalten wird.'),
('5350', 'Festplatz', 'Festplatz ist eine Fläche, auf der zeitlich begrenzte Festveranstaltungen stattfinden.'),
('5360', 'Busbahnhof', 'Busbahnhof ist eine Verkehrsanlage, die als zentraler Verknüpfungspunkt verschiedener Buslinien dient.'),
('5370', 'Caravan-, Wohnmobilstellplatz', 'Caravan-, Wohnmobilstellplatz ist ein öffentlich zugänglicher Stellplatz für Caravan-, Wohn- bzw. Reisemobile, auf dem man im Fahrzeug ein oder mehrere Nächte übernachten darf.
Auf einigen dieser Stellplätze sind auch Wohnwagengespanne zugelassen. Diese unterliegen nicht der "Verordnung über Camping- und Wochenendplätze" (CW-VO) und sind aus rechtlicher Sicht keine Campingplätze, sondern Parkplätze im Sinne des örtlich geltenden Straßenverkehrsrechts.');
CREATE TABLE ax_nutzung_flugverkehr (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_nutzung_flugverkehr IS 'Alias: "AX_Nutzung_Flugverkehr", UML-Typ: Enumeration';
INSERT INTO ax_nutzung_flugverkehr (wert,beschreibung,dokumentation) VALUES
('1000', 'Zivil', 'Zivil bedeutet, dass Flugverkehr privaten oder öffentlichen Zwecken dient und nicht militärisch genutzt wird.'),
('2000', 'Militärisch', 'Militärisch bedeutet, dass Flugverkehr nur von Streitkräften genutzt wird.'),
('3000', 'Teils zivil, teils militärisch', 'Teils zivil, teils militärisch bedeutet dass Flugverkehr sowohl zivil als auch militärisch genutzt wird.');
CREATE TABLE ax_funktion_fahrbahnachse (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_fahrbahnachse IS 'Alias: "AX_Funktion_Fahrbahnachse", UML-Typ: Enumeration';
INSERT INTO ax_funktion_fahrbahnachse (wert,beschreibung,dokumentation) VALUES
('1808', 'Fußgängerzone', 'Fußgängerzone ist ein dem Fußgängerverkehr vorbehaltener Bereich, in dem ausnahmsweise öffentlicher Personenverkehr, Lieferverkehr oder Fahrradverkehr zulässig sein kann.');
CREATE TABLE ax_zustand_strasse (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_strasse IS 'Alias: "AX_Zustand_Strasse", UML-Typ: Enumeration';
INSERT INTO ax_zustand_strasse (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb, stillgelegt, verlassen', 'Außer Betrieb, stillgelegt, verlassen bedeutet, dass sich die Straßenverkehrsfläche nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('4000', 'Im Bau', 'Im Bau bedeutet, dass sich überwiegende Teile des Straßenverkehrs im Bau befinden.'),
('8000', 'Erweiterung, Neuansiedlung', 'Erweiterung, Neuansiedlung bedeutet, dass die Fläche in ihrer Nutzung gemäß der Objektart erweitert wird und eine Fertigstellung absehbar ist.');
CREATE TABLE ax_anzahlderstreckengleise (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_anzahlderstreckengleise IS 'Alias: "AX_AnzahlDerStreckengleise", UML-Typ: Enumeration';
INSERT INTO ax_anzahlderstreckengleise (wert,beschreibung,dokumentation) VALUES
('1000', 'Eingleisig', 'Eingleisig bedeutet, dass für Bahnstrecke nur ein Gleis für beide Fahrtrichtungen zur Verfügung steht.'),
('2000', 'Zweigleisig', 'Zweigleisig bedeutet, dass für Bahnstrecke je ein Gleis für eine Fahrtrichtung zur Verfügung steht.');
CREATE TABLE ax_funktion_weg (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_weg IS 'Alias: "AX_Funktion_Weg", UML-Typ: Enumeration';
INSERT INTO ax_funktion_weg (wert,beschreibung,dokumentation) VALUES
('5210', 'Fahrweg', 'Fahrweg ist ein Weg, auf dem das Befahren mit Fahrzeugen möglich ist.'),
('5211', 'Hauptwirtschaftsweg', 'Hauptwirtschaftsweg ist ein Weg mit fester Fahrbahndecke zur Erschließung eines oder mehrerer Grundstücke, der für den Kraftverkehr zu jeder Jahreszeit befahrbar ist. Dazu gehören auch Lkw-befahrbare Wege im Wald, die dem forstwirtschaftlichen Holztransport zu jeder Zeit dienen.'),
('5212', 'Wirtschaftsweg', 'Wirtschaftsweg ist ein leicht- oder unbefestigter Weg zur Erschließung land- und forstwirtschaftlicher Flächen.'),
('5220', 'Fußweg', 'Fußweg ist ein Weg, der auf Grund seines Ausbauzustandes nur von Fußgängern zu begehen ist.'),
('5230', 'Gang', 'Gang ist ein schmaler Fußweg.'),
('5240', 'Radweg', 'Radweg ist ein Weg, der als besonders gekennzeichneter und abgegrenzter Teil einer Straße oder mit selbständiger Linienführung für den Fahrradverkehr bestimmt ist.'),
('5250', 'Rad- und Fußweg', 'Rad- und Fußweg ist ein Weg, der als besonders gekennzeichneter und abgegrenzter Teil einer Straße oder mit selbständiger Linienführung ausschließlich für den Fahrrad- und Fußgängerverkehr bestimmt ist.'),
('5260', 'Reitweg', 'Reitweg ist ein besonders ausgebauter Weg, auf dem ausschließlich das Reiten zugelassen ist.'),
('5270', 'Begleitfläche Weg', 'Begleitfläche Weg bezeichnet eine unbebaute Fläche, die einem Weg zugeordnet wird.'),
('9999', 'Sonstiges', 'Sonstiges bedeutet, dass die Funktion des Wegs bekannt, diese aber nicht in der Werteliste aufgeführt ist.');
CREATE TABLE ax_zustand_bahnverkehr (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand_bahnverkehr IS 'Alias: "AX_Zustand_Bahnverkehr", UML-Typ: Enumeration';
INSERT INTO ax_zustand_bahnverkehr (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb, stillgelegt, verlassen', 'Außer Betrieb, stillgelegt, verlassen bedeutet, dass sich die Bahnverkehrsfläche nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('4000', 'Im Bau', 'Im Bau bedeutet, dass sich überwiegende Teile des Bahnverkehrs im Bau befinden.'),
('8000', 'Erweiterung, Neuansiedlung', 'Erweiterung, Neuansiedlung bedeutet, dass die Fläche in ihrer Nutzung gemäß der Objektart erweitert wird und eine Fertigstellung absehbar ist.');
CREATE TABLE ax_verkehrsdienst_bahnstrecke (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_verkehrsdienst_bahnstrecke IS 'Alias: "AX_Verkehrsdienst_Bahnstrecke", UML-Typ: Enumeration';
INSERT INTO ax_verkehrsdienst_bahnstrecke (wert,beschreibung,dokumentation) VALUES
('1000', 'Fernverkehr', 'Fernverkehr bedeutet, dass auf der Bahnstrecke von einem Eisenbahnverkehrsunternehmen ein nationaler oder internationaler Schienenpersonenfernverkehrsdienst erbracht wird.');
CREATE TABLE ax_art_flugverkehr (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_art_flugverkehr IS 'Alias: "AX_Art_Flugverkehr", UML-Typ: Enumeration';
INSERT INTO ax_art_flugverkehr (wert,beschreibung,dokumentation) VALUES
('5511', 'Internationaler Flughafen', 'Internationaler Flughafen ist ein Verkehrsflughafen, der im Luftfahrthandbuch als solcher ausgewiesen ist.'),
('5512', 'Regionalflughafen', 'Regionalflughafen ist ein Verkehrsflughafen der gemäß Raumordnungsgesetz als Regionalflughafen eingestuft ist, bzw. als Flughafen, Verkehrsflughafen oder Regionalflughafen im Luftfahrthandbuch ausgewiesen ist.'),
('5513', 'Sonderflughafen', 'Sonderflughafen ist ein Flughafen, der im Luftfahrthandbuch als solcher ausgewiesen ist.'),
('5521', 'Verkehrslandeplatz', 'Verkehrslandeplatz ist ein Flugplatz, der im Luftfahrthandbuch als Flugplatz, Landeplatz oder Verkehrslandeplatz ausgewiesen ist.'),
('5522', 'Sonderlandeplatz', 'Sonderlandeplatz ist ein Flugplatz, der im Luftfahrthandbuch oder in den Bescheiden der zuständigen Luftfahrtbehörden als Sonderlandeplatz ausgewiesen ist.'),
('5530', 'Hubschrauberlandeplatz', 'Hubschrauberlandeplatz ist ein Flugplatz, der im Luftfahrthandbuch, in der Luftfahrtkarte 1:500000 (ICAO) oder aufgrund von Ländervorschriften als solcher ausgewiesen ist.'),
('5550', 'Segelfluggelände', 'Segelfluggelände ist ein Flugplatz, der in der Luftfahrtkarte 1:500000 (ICAO) für den Segelflugsport ausgewiesen ist.');
CREATE TABLE ax_widmung_strasse (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_widmung_strasse IS 'Alias: "AX_Widmung_Strasse", UML-Typ: Enumeration';
INSERT INTO ax_widmung_strasse (wert,beschreibung,dokumentation) VALUES
('1301', 'Bundesautobahn', 'Bundesautobahn ist eine durch Verwaltungsakt zur Bundesautobahn gewidmete Bundesfernstraße.'),
('1303', 'Bundesstraße', 'Bundesstraße ist eine durch Verwaltungsakt zur Bundesstraße gewidmete Bundesfernstraße.'),
('1305', 'Landesstraße, Staatsstraße', 'Landesstraße, Staatsstraße ist eine durch Verwaltungsakt zur Landesstraße bzw. Staatsstraße gewidmete Straße.'),
('1306', 'Kreisstraße', 'Kreisstraße ist eine durch Verwaltungsakt zur Kreisstraße gewidmete Straße.'),
('1307', 'Gemeindestraße', 'Gemeindestraße ist eine durch Verwaltungsakt zur Gemeindestrasse gewidmete Straße.'),
('9997', 'Nicht öffentliche Straße', 'Nicht öffentliche Straße bedeutet, dass hier ein Straßenverkehr erlaubt ist, dieser aber nur zweckgebunden, z. B. in einem Krankenhausgelände, durchgeführt wird.'),
('9999', 'Sonstige öffentliche Straße', 'Sonstige öffentliche Straße bedeutet, dass es sich um eine öffentliche Straße handelt, die aber keiner der vorhandenen Widmung zugewiesen werden kann.');
CREATE TABLE ax_zustand (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_zustand IS 'Alias: "AX_Zustand", UML-Typ: Enumeration';
INSERT INTO ax_zustand (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb, stillgelegt, verlassen', 'Außer Betrieb, stillgelegt, verlassen bedeutet, dass sich die Objektart nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('4000', 'Im Bau', 'Im Bau bedeutet, dass die Objektart noch nicht fertiggestellt ist.');
CREATE TABLE ax_funktion_bahnverkehr (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_bahnverkehr IS 'Alias: "AX_Funktion_Bahnverkehr", UML-Typ: Enumeration';
INSERT INTO ax_funktion_bahnverkehr (wert,beschreibung,dokumentation) VALUES
('1200', 'Parken', 'Parken bezeichnet eine Fläche, die vorwiegend dem Abstellen von Fahrzeugen dient und zu diesem Zweck ggf. mit Gebäuden, Bauwerken, Anlagen oder Kennzeichnungen versehen ist.'),
('2321', 'Gebäude- und Freifläche zu Verkehrsanlagen, Schiene', 'Gebäude- und Freifläche zu Verkehrsanlage, Schiene dient der Abwicklung und Sicherheit des Verkehrs sowie der Unterhaltung der Verkehrsfläche'),
('2322', 'Begleitfläche Bahnverkehr', 'Begleitfläche Bahnverkehr bezeichnet eine unbebaute Fläche, die dem Bahnverkehr zugeordnet wird. Die Begleitfläche Bahnverkehr ist nicht Bestandteil der Gleisanlagen.'),
('2323', 'Betriebsfläche Bahnverkehr', 'Betriebsfläche Bahnverkehr bezeichnet bebaute oder unbebaute Flächen, die vorwiegend der Versorgung, Unterhaltung und Instandhaltung des Bahnverkehrs dienen.'),
('2324', 'Trasse, Streckengleisbett', 'Trasse, Streckengleisbett ist ein befestigtes, dem allgemeinen Schienenverkehr dienendes Gleisbett einschließlich der auf Brücken oder in Tunneln verlaufenden Abschnitte.');
CREATE TABLE ax_funktion_schiffsverkehr (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_funktion_schiffsverkehr IS 'Alias: "AX_Funktion_Schiffsverkehr", UML-Typ: Enumeration';
INSERT INTO ax_funktion_schiffsverkehr (wert,beschreibung,dokumentation) VALUES
('1200', 'Parken', 'Parken bezeichnet eine Fläche, die vorwiegend dem Abstellen von Fahrzeugen dient und zu diesem Zweck ggf. mit Gebäuden, Bauwerken, Anlagen oder Kennzeichnungen versehen ist.'),
('2341', 'Gebäude- und Freifläche zu Verkehrsanlagen, Schifffahrt', 'Gebäude- und Freifläche zu Verkehrsanlagen, Schifffahrt ist eine Fläche, die dem Schiffsverkehr dient.'),
('2342', 'Begleitfläche Schiffsverkehr', 'Begleitfläche Schiffsverkehr bezeichnet eine unbebaute Fläche, die dem Schiffsverkehr zugeordnet wird. Hierzu zählt z.B. Ufer.'),
('5600', 'Betriebsfläche Schiffsverkehr', 'Betriebsfläche Schiffsverkehr bezeichnet bebaute oder unbebaute Flächen die dem landseitigen Betrieb des Schiffsverkehrs dienen.'),
('5610', 'Hafenanlage (Landfläche)', 'Hafenanlage (Landfläche) bezeichnet die Fläche innerhalb von Hafen, die nicht von Wasser bedeckt ist und die ausschließlich zum Betrieb des Hafens dient.'),
('5620', 'Schleuse (Landfläche)', 'Schleuse (Landfläche) bezeichnet die Fläche innerhalb von Schleuse, die nicht von Wasser bedeckt ist und die ausschließlich zum Betrieb der Schleuse dient..'),
('5630', 'Anlegestelle', 'Anlegestelle umfasst mehr als den überlagernden landseitigen Anleger, der eine feste oder schwimmende Einrichtung zum Anlegen von Schiffen ist.'),
('5640', 'Fähranlage', 'Fähranlage ist eine besondere Landfläche von der in der Regel nach festem Fahrplan über Flüsse, Seen, Kanäle, Meerengen oder Meeresarme ein Schiffsverkehr stattfindet.');
CREATE TABLE ax_verarbeitungsart_fortfuehrungsauftrag (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_verarbeitungsart_fortfuehrungsauftrag IS 'Alias: "AX_Verarbeitungsart_Fortfuehrungsauftrag", UML-Typ: Enumeration';
INSERT INTO ax_verarbeitungsart_fortfuehrungsauftrag (wert,beschreibung,dokumentation) VALUES
('1000', 'Fortführen mit Sperre', ''),
('2000', 'Fortführungssimulation mit Unterbrechung der Verarbeitung', ''),
('3000', 'Unterbrochenen Auftrag fortsetzen', ''),
('4000', 'Fortführen ohne Sperre', ''),
('5000', 'Entsperren und Auftrag zurücksetzen', '');
CREATE TABLE ax_verarbeitungsart_einrichtungsauftrag (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_verarbeitungsart_einrichtungsauftrag IS 'Alias: "AX_Verarbeitungsart_Einrichtungsauftrag", UML-Typ: Enumeration';
INSERT INTO ax_verarbeitungsart_einrichtungsauftrag (wert,beschreibung,dokumentation) VALUES
('6000', 'Einrichten ohne Sperre', 'Ein Einrichtungsauftrag kann aus mehreren Dateien (Konvoi) bestehen (6000er, mit einem abschließenden 6100er).'),
('6100', 'Ende Einrichten ohne Sperre', 'Verarbeitungsart der letzten Datei einer Folge von Einrichtungsaufträgen.

6100 ist ein leerer Auftrag, d.h. es sind keine AAA-Fachobjekte enthalten; "LZI.beginnt" wird vom Verarbeitungsbeginn des 6100 einheitlich für ganzen Konvoi bestimmt; 

6100 stößt bezogen auf seinen Konvoi und bezüglich ggf. bereits eingerichteter Bereiche Prüfungen an, z.B. Flächendeckungsprüfungen, die den korrekten Anschluss an das eingerichtete Gebiet gewährleisten.'),
('6200', 'Abbruch', '6200 dient zum Abbruch eines Konvois und zum Rücksetzen des temporären Arbeitsbereichs.

Nach Ausführung diesen Auftrages ist das aufnehmende System wieder in dem Zustand, der vor Beginn des Einrichtungskonvois dort herrschte.');
CREATE TABLE ax_impliziteloeschungderreservierung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_impliziteloeschungderreservierung IS 'Alias: "AX_ImpliziteLoeschungDerReservierung", UML-Typ: Enumeration';
INSERT INTO ax_impliziteloeschungderreservierung (wert,beschreibung,dokumentation) VALUES
('1000', 'Reservierte Punktkennungen und Flurstückskennzeichen löschen', ''),
('2000', 'Reservierte Punktkennungen löschen', ''),
('3000', 'Reservierte Flurstückskennzeichen löschen', ''),
('4000', 'Ohne Löschung reservierter Punktkennungen und Flurstückskennzeichen', '');
CREATE TABLE ax_selektionsmasstab_benutzungsauftrag (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_selektionsmasstab_benutzungsauftrag IS 'Alias: "AX_Selektionsmasstab_Benutzungsauftrag", UML-Typ: Enumeration';
INSERT INTO ax_selektionsmasstab_benutzungsauftrag (wert,beschreibung,dokumentation) VALUES
('0500', '1-zu-500', ''),
('1000', '1-zu-1000', ''),
('2000', '1-zu-2000', ''),
('3000', '1-zu-5000', '');
CREATE TABLE ax_reservierungsart_reservierungsauftrag (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_reservierungsart_reservierungsauftrag IS 'Alias: "AX_Reservierungsart_Reservierungsauftrag", UML-Typ: Enumeration';
INSERT INTO ax_reservierungsart_reservierungsauftrag (wert,beschreibung,dokumentation) VALUES
('1100', 'Reservierung im Anschluss an die höchst vergebene Nummer', ''),
('1200', 'Reservierung im Anschluss an die höchst vergebene Folgenummer', ''),
('2100', 'Reservierung unter Verwendung von Nummerierungslücken bei der Nummer', ''),
('2200', 'Reservierung unter Verwendung von Nummerierungslücken bei der Folgenummer', ''),
('3000', 'Löschung einer Reservierung', '');
CREATE TABLE ax_wirtschaftsart (
  wert character varying,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ax_wirtschaftsart IS 'Alias: "AX_Wirtschaftsart", UML-Typ: Enumeration';
INSERT INTO ax_wirtschaftsart (wert,beschreibung,dokumentation) VALUES
('Wohnbaufläche', NULL, '-==- Auswerteregel -==-
Wohnbaufläche wird aggregiert aus der Nutzungsartkennung 1100.'),
('Industrie- und Gewerbefläche', NULL, '-==- Auswerteregel -==-
Industrie- und Gewerbefläche wird aggregiert aus den Nutzungsarten 1200 bis 1204, 1300 bis 1308, 1400 bis 1405 und 1500 bis 1505.'),
('Mischnutzung', NULL, '-==- Auswerteregel -==-
Mischnutzung wird aggregiert aus den Nutzungsarten 1600 bis 1671 und 1700 bis 1702.'),
('Gebäude- und Freifläche Land- und Forstwirtschaft', NULL, '-==- Auswerteregel -==-
Gebäude- und Freifläche Land- und Forstwirtschaft wird aggregiert aus der Nutzungsart 1672.'),
('Erholungsfläche', NULL, '-==- Auswerteregel -==-
Erholungsfläche wird aggregiert aus den Nutzungsarten 1800 bis 1871.'),
('Friedhof', NULL, '-==- Auswerteregel -==-
Friedhof wird aggregiert aus den Nutzungsarten 1900 bis 1971 und 3203.'),
('Verkehrsfläche', NULL, '-==- Auswerteregel -==-
Verkehrsfläche wird aus den Nutzungsarten 2101 bis 2271, 2300 bis 2371 und 2400 bis 2471 aggregiert.'),
('Landwirtschaftsfläche', NULL, '-==- Auswerteregel -==-
Landwirtschaftsfläche wird aggregiert aus den Nutzungsarten 3100 bis 3106 sowie 3110 und 3120.'),
('Waldfläche', NULL, '-==- Auswerteregel -==-
Waldfläche wird aggregiert aus den Nutzungsarten 3200 bis 3202.'),
('Sonstige Vegetationsfläche', NULL, '-==- Auswerteregel -==-
Sonstige Vegetationsfläche wird aggregiert aus den Nutzungsarten 3300, 3400, 3500 und 3600.'),
('Unland', NULL, '-==- Auswerteregel -==-
Unland wird aggregiert aus den Nutzungsarten 3700 bis 3704.'),
('Wasserfläche', NULL, '-==- Auswerteregel -==-
Wasserfläche wird aggregiert aus den Nutzungsarten 4100 bis 4104, 4200 und 4201, 4300 bis 4303, 4400 und 4401.');
CREATE TABLE ln_funktion_wasserwirtschaft (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_funktion_wasserwirtschaft IS 'Alias: "LN_Funktion_Wasserwirtschaft", UML-Typ: Enumeration';
INSERT INTO ln_funktion_wasserwirtschaft (wert,beschreibung,dokumentation) VALUES
('7111', 'Trinkwasser', 'Trinkwasser im vorliegenden Sinne bezeichnet Wasser, das für den menschlichen Genuss geeignet ist.'),
('7112', 'Energie', 'Energie weist die Nutzung eines Stehendes Gewässers zur Energiegewinnung aus.'),
('7113', 'Brauchwasser', 'Brauchwasser dient spezifischen technischen, gewerblichen, industriellen, landwirtschaftlichen, hauswirtschaftlichen oder ähnlichen Zwecken, ohne dass im allgemeinen hierfür Trinkwasserqualität verlangt wird. Hierzu zählen z B. Kesselspeisewasser, Kühlwasser, unterschiedlich aufbereitetes Rohwasser.');
CREATE TABLE ln_zustand_wasserwirtschaft (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_zustand_wasserwirtschaft IS 'Alias: "LN_Zustand_Wasserwirtschaft", UML-Typ: Enumeration';
INSERT INTO ln_zustand_wasserwirtschaft (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb', 'Außer Betrieb bedeutet, dass sich das Objekt nicht mehr in regelmäßiger, der Bestimmung entsprechender Nutzung befindet.'),
('4000', 'Im Bau', 'Im Bau bedeutet, dass die Bauarbeiten am Objekt bereits begonnen haben und das Objekt noch nicht fertiggestellt ist.');
CREATE TABLE ln_art_wasserwirtschaft (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_art_wasserwirtschaft IS 'Alias: "LN_Art_Wasserwirtschaft", UML-Typ: Enumeration';
INSERT INTO ln_art_wasserwirtschaft (wert,beschreibung,dokumentation) VALUES
('7100', 'Wasserregulierung', 'Wasserregulierung’ bezeichnet Flächen zur Stauung, Speicherung und zum Rückhalt von Wasser auf gefluteten und flutbaren Flächen.'),
('7110', 'Stauung', 'Stauung umschreibt künstlich angelegte Flächen zur dauerhaften Speicherung von Wasser zur wirtschaftlichen Nutzung (z. B. Staudamm und die dazugehörige Wasserfläche).'),
('7120', 'Speicherung', 'Speicherung umschreibt Flächen in Verbindung mit künstlichen Anlagen zur temporären Speicherung von Wasser.'),
('7130', 'Niederschlagrückhalt', 'Niederschlagrückhalt’ beschreibt künstliche Anlagen zum Rückhalt von Niederschlägen ausgehend von Regen oder Hochwasser.'),
('7200', 'Entwässerung', 'Entwässerung beschreibt Flächen zum Abführen von Wasser (z. B. Gräben, Vorfluter, Verrohrungen).');
CREATE TABLE ln_art_aquakulturundfischereiwirtschaft (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_art_aquakulturundfischereiwirtschaft IS 'Alias: "LN_Art_AquakulturUndFischereiwirtschaft", UML-Typ: Enumeration';
INSERT INTO ln_art_aquakulturundfischereiwirtschaft (wert,beschreibung,dokumentation) VALUES
('6400', 'Fischzucht, Muschelzucht', 'Fischzucht, Muschelzucht bezeichnet Flächen/Areale, die dem (gewerblichen) Züchten bzw. der kontrollierten Aufzucht von im Wasser lebenden Organismen, insbesondere Fischen und Muscheln, zur Nahrungsgewinnung und Weiterverarbeitung dienen.'),
('6500', 'Algenzucht', 'Algenzucht bezeichnet Flächen/Areale, die dem (gewerblichen) Züchten bzw. der kontrollierten Aufzucht von im Wasser lebenden Organismen, insbesondere Algen, zur Nahrungsgewinnung und Weiterverarbeitung dienen.');
CREATE TABLE ln_art_forstwirtschaft (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_art_forstwirtschaft IS 'Alias: "LN_Art_Forstwirtschaft", UML-Typ: Enumeration';
INSERT INTO ln_art_forstwirtschaft (wert,beschreibung,dokumentation) VALUES
('6100', 'Forstwirtschaftsfläche', 'Forstwirtschaftsfläche bezeichnet eine Waldfläche mit oder ohne Bäumen, welche forstwirtschaftlich genutzt wird. Hierzu zählen keine Kurzumtriebsplantagen.'),
('6200', 'Betriebsfläche Forstwirtschaft', 'Betriebsfläche Forstwirtschaft bezeichnet eine bebaute und unbebaute Fläche, die vorwiegend dem forstwirtschaftlich Betrieb dient.');
CREATE TABLE ln_bewirtschaftung_landwirtschaft (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_bewirtschaftung_landwirtschaft IS 'Alias: "LN_Bewirtschaftung_Landwirtschaft", UML-Typ: Enumeration';
INSERT INTO ln_bewirtschaftung_landwirtschaft (wert,beschreibung,dokumentation) VALUES
('1010', 'Ackerland', 'Ackerland ist eine Fläche für den Anbau von Feldfrüchten (z.B. Getreide, Hülsenfrüchte, Hackfrüchte) und Beerenfrüchten (z.B. Erdbeeren).'),
('1011', 'Streuobstacker', 'Streuobstacker beschreibt den Bewuchs einer Ackerfläche mit Obstbäumen.'),
('1012', 'Hopfen', 'Hopfen ist eine mit speziellen Vorrichtungen ausgestattete Agrarfläche für den Anbau von Hopfen.'),
('1013', 'Spargel', 'Spargel beschreibt den Bewuchs einer landwirtschaftlichen Fläche mit Spargel.'),
('1014', 'Hanf', 'Hanf beschreibt den Bewuchs einer Agrarfläche mit Nutzhanf.'),
('1020', 'Mahd- und Weideland', 'Mahd- und Weideland ist eine Grasfläche, die gemäht oder beweidet wird.'),
('1021', 'Streuobstwiese', 'Streuobstwiese beschreibt den Bewuchs einer Mahd- oder Weidelandfläche mit Obstbäumen.'),
('1030', 'Gartenbauland', 'Gartenbauland ist eine Fläche, die dem gewerbsmäßigen Anbau von Gartengewächsen (Gemüse, Obst und Blumen) sowie für die Aufzucht von Kulturpflanzen dient.'),
('1040', 'Rebfläche', 'Rebfläche ist eine mit speziellen Vorrichtungen ausgestattete Agrarfläche, auf der Weinstöcke angepflanzt sind.'),
('1050', 'Obst- und Nussplantage', 'Obst- und Nussplantage ist eine Fläche, die vorwiegend dem Intensivobstanbau dient und mit Obst- und Nussbäumen und -sträuchern bestanden ist. Im Unterschied zu Streuobst handelt es sich hierbei um gleichmäßige und dichter angelegte Monokulturen.'),
('1060', 'Kurzumtriebsplantage', 'Kurzumtriebsplantage sind landwirtschaftliche Kulturen oder Anpflanzung schnell wachsender Bäume mit dem Ziel, innerhalb kurzer Umtriebszeiten Holz als nachwachsenden Rohstoff zu produzieren; auch mit Ziel der Energieerzeugung.'),
('1070', 'Baumschule', 'Baumschule ist eine Fläche, auf der Holzgewächse aus Samen, Ablegern oder Stecklingen unter mehrmaligem Umpflanzen (Verschulen) gezogen werden.'),
('1080', 'Weihnachtsbaumkultur', 'Weihnachtsbaumkultur bezeichnet eine landwirtschaftliche Fläche, die vorrangig mit Weihnachtsbäumen bepflanzt ist.'),
('1200', 'Brachland', 'Brachland ist eine Fläche der Landwirtschaft, die seit längerem nicht mehr zu Produktionszwecken genutzt wird.'),
('1300', 'Betriebsfläche Landwirtschaft', 'Betriebsfläche Landwirtschaft bezeichnet eine bebaute und unbebaute Fläche, die dem landwirtschaftlich Betrieb dient.');
CREATE TABLE ln_artderbetriebsflaeche_landwirtschaft (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_artderbetriebsflaeche_landwirtschaft IS 'Alias: "LN_ArtDerBetriebsflaeche_Landwirtschaft", UML-Typ: Enumeration';
INSERT INTO ln_artderbetriebsflaeche_landwirtschaft (wert,beschreibung,dokumentation) VALUES
('1000', 'Tierhaltung', 'Tierhaltung bezeichnet eine bebaute und unbebaute Fläche, die vorwiegend dem landwirtschaftlichen Betrieb, primär der Tierhaltung dient. Diese umfasst auch die Gebäude- und Freiflächen.'),
('2000', 'Pflanzliche Produktion', 'Pflanzliche Produktion bezeichnet eine bebaute und unbebaute Fläche, die vorwiegend dem landwirtschaftlichen Betrieb, primär der pflanzlichen Produktion dient. Diese umfasst auch die Gebäude- und Freiflächen.');
CREATE TABLE ln_zustand_gewerblichedienstleistungen (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_zustand_gewerblichedienstleistungen IS 'Alias: "LN_Zustand_GewerblicheDienstleistungen", UML-Typ: Enumeration';
INSERT INTO ln_zustand_gewerblichedienstleistungen (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb', 'Außer Betrieb bedeutet, dass sich die Fläche nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('8000', 'Erweiterung, Neuansiedlung', 'Erweiterung, Neuansiedlung bedeutet, dass die Fläche in ihrer Nutzung gemäß der Objektart erweitert wird und eine Fertigstellung absehbar ist.');
CREATE TABLE ln_foerdergut_abbau (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_foerdergut_abbau IS 'Alias: "LN_Foerdergut_Abbau", UML-Typ: Enumeration';
INSERT INTO ln_foerdergut_abbau (wert,beschreibung,dokumentation) VALUES
('1000', 'Erdöl', 'Erdöl ist ein flüssiges und brennbares Kohlenwasserstoffgemisch, das gefördert wird.'),
('2000', 'Erdgas', 'Erdgas ist ein in der Erdkruste vorkommendes brennbares Naturgas, das gefördert wird.'),
('3000', 'Sole, Lauge', 'Sole, Lauge ist ein kochsalzhaltiges Wasser, das gefördert wird.'),
('4000', 'Kohlensäure', 'Kohlensäure ist eine schwache Säure, die durch Lösung von Kohlendioxid in Wasser entsteht und gefördert wird.'),
('5000', 'Erdwärme', 'Erdwärme ist eine auf natürlichem Wege sich erneuernde Wärmeenergie, die aus einer geothermisch geringen Tiefenstufe der Erdkruste gefördert wird.');
CREATE TABLE ln_art_versorgungundentsorgung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_art_versorgungundentsorgung IS 'Alias: "LN_Art_VersorgungUndEntsorgung", UML-Typ: Enumeration';
INSERT INTO ln_art_versorgungundentsorgung (wert,beschreibung,dokumentation) VALUES
('2500', 'Versorgungsanlage', 'Versorgungsanlage bezeichnet Flächen, auf denen sich vorwiegend Anlagen und Gebäude für die Versorgung mit Wasser oder Energie befinden.'),
('2520', 'Wasserwerk', 'Wasserwerk ist eine Fläche, auf der Gebäude und Einrichtungen zur Aufbereitung und Bereitstellung von Trinkwasser steht.'),
('2530', 'Kraftwerk', 'Kraftwerk bezeichnet eine Fläche mit Bauwerken und sonstigen Einrichtungen zur Erzeugung von elektrischer Energie.'),
('2540', 'Umspannstation', 'Umspannstation bezeichnet eine Fläche mit Gebäuden und sonstigen Einrichtungen, um Strom auf eine andere Spannungsebene zu transformieren.'),
('2570', 'Heizwerk', 'Heizwerk bezeichnet eine Fläche mit Bauwerken und sonstigen Einrichtungen zur Erzeugung von Wärmeenergie zu Heizzwecken.'),
('2575', 'Biogasanlage', 'Biogasanlage ist eine Anlage, in der aus Biomasse Gas, Strom oder/und Wärme erzeugt wird.
Dies umfasst ebenfalls die zur Produktion erforderlichen Bauwerke (Fahrsilo, Fermenter, usw.).'),
('2580', 'Funk- und Fernmeldeanlage', 'Funk- und Fernmeldeanlage bezeichnet eine Fläche, auf der vorwiegend Anlagen und Gebäude zur elektronischen Informationsübertragung stehen.'),
('2600', 'Entsorgungsanlage', 'Entsorgungsanlage bezeichnet Flächen, auf denen sich vorwiegend Anlagen und Gebäude für die Beseitigung von Abwässern oder Abfällen befinden.'),
('2610', 'Kläranlage, Klärwerk', 'Kläranlage, Klärwerk bezeichnet eine Fläche mit Bauwerken und sonstigen Einrichtungen zur Reinigung von Abwasser.'),
('2620', 'Abfallbehandlungsanlage', 'Abfallbehandlungsanlage bezeichnet eine Fläche mit Bauwerken und sonstigen Einrichtungen, auf der Abfälle mit chemisch/physikalischen und biologischen oder thermischen Verfahren oder Kombinationen dieser Verfahren behandelt werden.');
CREATE TABLE ln_abbaugut_abbau (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_abbaugut_abbau IS 'Alias: "LN_Abbaugut_Abbau", UML-Typ: Enumeration';
INSERT INTO ln_abbaugut_abbau (wert,beschreibung,dokumentation) VALUES
('1000', 'Erden, Lockergestein', 'Erden, Lockergestein bedeutet, dass feinkörnige Gesteine abgebaut werden.'),
('2000', 'Steine, Gestein, Festgestein', 'Steine, Gestein, Festgestein bedeutet, dass grobkörnige oder feste Gesteine abgebaut werden.'),
('3000', 'Erze', 'Erze bedeutet, dass die in der Natur vorkommenden, metallhaltigen Mineralien und Mineralgemische abgebaut oder gespeichert werden.'),
('4000', 'Treib- und Brennstoffe', 'Treib- und Brennstoffe bedeutet, dass die in der Natur vorkommenden brennbaren organischen und anorganischen Substanzen abgebaut oder gewonnen werden.'),
('5000', 'Industrieminerale, Salze', 'Industrieminerale, Salze bedeutet, dass die in der Natur vorkommenden Mineralien abgebaut werden.');
CREATE TABLE ln_art_industrieundverarbeitendesgewerbe (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_art_industrieundverarbeitendesgewerbe IS 'Alias: "LN_Art_IndustrieUndVerarbeitendesGewerbe", UML-Typ: Enumeration';
INSERT INTO ln_art_industrieundverarbeitendesgewerbe (wert,beschreibung,dokumentation) VALUES
('1801', 'Nahrungs-, Futter-, Genussmittel', 'Nahrungs-, Futter-, Genussmittel bezeichnet Flächen zur Fertigung von Erzeugnissen der Landwirtschaft, Forstwirtschaft sowie die Herstellung verschiedener Halbwaren, die noch keine Nahrungs-, Futter- oder Genussmittel darstellen.'),
('1802', 'Textil-, Bekleidungs-, Lederwaren', 'Textil-, Bekleidungs-, Lederwaren bezeichnet Flächen auf denen primär Textil-, Bekleidungs- und Lederwaren wie nachfolgend beschrieben gefertigt oder verarbeitet werden. Textilwaren umfasst Spinnstoffaufbereitung und Spinnerei, Weberei, Veredlung von Textilien und Bekleidung, sowie die Herstellung von konfektionierten Textilwaren. Bekleidungswaren umfassen alle Schneiderarbeiten aus allen Materialien für alle Bekleidungsartikel und Bekleidungszubehör. Lederwaren umfasst das Zurichten und Färben von Pelzen und die Verarbeitung von Fellen zu Leder durch Gerben und Zurichten sowie die Weiterverarbeitung des Leders zu Gebrauchsgegenständen.'),
('1803', 'Holz-, Naturfaser-, Verpackungsprodukte', 'Holz-, Naturfaser-, Verpackungsprodukte bezeichnet Flächen auf denen primär Holz-, Naturfaser- oder Verpackungsprodukte wie nachfolgend beschrieben gefertigt oder verarbeitet werden. Holzprodukte umfassen die Herstellung von Bauholz, Sperrholz, Furniere, Verpackungsmittel, Lagerbehälter und Ladungsträger, Bodenbeläge, Fachwerk, vorgefertigte Gebäude. Naturfaserprodukte sind Veredelungen von Holz- und Zellprodukten. Verpackungsprodukte umfasst Flächen für die Fertigung von Verpackungsmaterial aus bspw. Papier, Karton, Pappe und Holz.'),
('1804', 'Print-, Audio-, Videoprodukte', 'Print-, Audio-, Videoprodukte bezeichnet Flächen auf denen primär die massenhafte Fertigung von Druckerzeugnissen bzw. bespielten Ton-, Bild- und Datenträgern erfolgt.'),
('1805', 'Mineralölverarbeitung, Kokerei', 'Mineralölverarbeitung, Kokerei bezeichnet Flächen auf denen primär Rohöl und Kohle zu gebrauchsfertigen Erzeugnissen verarbeitet werden. Das vorherrschende Verfahren ist die Mineralölverarbeitung durch Trennung von Rohöl in Teilerzeugnisse anhand von Verfahren wie Spaltung und Destillation.'),
('1806', 'Chemische-, Pharma-, Kunststoffprodukte', 'Chemische, Pharma-, Kunststoffprodukte bezeichnet Flächen auf denen primär Chemische, Pharma- und Kunststoffprodukte wie nachfolgend beschrieben gefertigt oder verarbeitet werden. Chemische Produkte umfasst die Verarbeitung organischer und anorganischer Rohstoffe in einem chemischen Verfahren zu chemischen Erzeugnissen. 
Pharmaprodukte umfasst die Herstellung von pharmazeutischen Grundstoffen und pharmazeutischen Spezialitäten wie auch die Herstellung von Arzneimitteln chemischen und botanischen Ursprungs.
Kunststoffprodukte umfasst die Herstellung von Harzen, Kunststoffen und nicht vulkanisierbaren thermoplastischen Elastomeren sowie das Mischen von Harzen nach Kundenwunsch und die Herstellung von synthetischen Harzen nach eigener Spezifikation.'),
('1807', 'Mineralische Bau- und Werkstoffe', 'Mineralische Bau- und Werkstoffe bezeichnet Flächen auf denen primär Bau- und Werkstoffe wie nachfolgend beschrieben gefertigt oder verarbeitet werden. Baustoffe umfassen den Großhandel mit Steinen, Sand, Kies, Schotter, Zement, Mörtel, Dämmplatten sowie Fertigteilbauten aus mineralischen Stoffen, z. B. Garagen. Werkstoffe umfasst die Herstellung von Waren unter Verwendung von Stoffen mineralischen Ursprungs bezogen auf die Herstellung von Glas und Erzeugnissen daraus, keramischen Erzeugnissen, Ziegeln und Erzeugnissen aus gebranntem Ton sowie Zement und Gips, verarbeiteten Naturstein und sonstigen Mineralerzeugnissen.'),
('1808', 'Metallerzeugung und –verarbeitung', 'Metallerzeugung und -verarbeitung umfasst die Flächen für die Tätigkeiten des Schmelzens und Legierens von Eisenmetallen und NE-Metallen aus Erz, Roheisen oder Schrott mit elektrometallurgischen und anderen metallurgischen Verfahren wie auch Flächen für die Herstellung von Metalllegierungen und Superlegierungen durch Zugabe anderer chemischer Elemente zu reinen Metallen.'),
('1809', 'Technik, Elektrik, Elektronik', 'Technik, Elektrik, Elektronik umfasst Flächen für die Herstellung von Datenverarbeitungsgeräten, sowie elektronischen und optischen Erzeugnissen.'),
('1810', 'Maschinenbau', 'Maschinenbau umfasst Flächen für den Bau von Maschinen, die mechanisch oder durch Wärme auf Materialien einwirken oder an Materialien Vorgänge durchführen, einschließlich ihrer mechanischen Bestandteile, die Kraft erzeugen und anwenden, sowie spezieller Teile dafür.'),
('1811', 'Fahrzeugbau und Zulieferer', 'Fahrzeugbau und Zulieferer umfasst die Flächen für die Herstellung von Raum-, Luft-, Wasser-, Schienen- und Straßenfahrzeugen zur Personen- oder Güterbeförderung wie auch die Flächen zur Herstellung verschiedener Teile und Zubehör.'),
('1812', 'Möbel und sonstige Konsumgüter', 'Möbel und sonstige Konsumgüter bezeichnet Flächen auf denen primär Möbel und sonstige Konsumgüter wie nachfolgend beschrieben gefertigt oder verarbeitet werden. Möbel umfassen die Herstellung von Möbeln aller Art und verwandten Erzeugnissen aus beliebigem Material, außer Stein, Beton und Keramik, für alle Einsatzbereiche und die verschiedensten Zwecke. Sonstige Konsumgüter umfassen den Verkauf von weiteren Neu- und Gebrauchtwaren vor allem an private Haushalte für den privaten Ge- oder Verbrauch.');
CREATE TABLE ln_zustand_lagerung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_zustand_lagerung IS 'Alias: "LN_Zustand_Lagerung", UML-Typ: Enumeration';
INSERT INTO ln_zustand_lagerung (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb', 'Außer Betrieb bedeutet, dass sich die Fläche nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('8000', 'Erweiterung, Neuansiedlung', 'Erweiterung, Neuansiedlung bedeutet, dass die Fläche in ihrer Nutzung gemäß der Objektart erweitert wird und eine Fertigstellung absehbar ist.');
CREATE TABLE ln_art_abbau (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_art_abbau IS 'Alias: "LN_Art_Abbau", UML-Typ: Enumeration';
INSERT INTO ln_art_abbau (wert,beschreibung,dokumentation) VALUES
('3110', 'Tagebau', 'Tagebau ist eine Fläche, auf der oberirdisch Bodenmaterial abgebaut wird. Rekultivierte Tagebaue, Gruben, Steinbrüche werden als Objekte entsprechend der vorhandenen Nutzung erfasst.'),
('3120', 'Untertagebau', 'Untertagebau ist eine Fläche, die für die Förderung des Abbaugutes unter Tage genutzt wird.'),
('3200', 'Förderanlage', 'Förderanlage bezeichnet eine Fläche mit Einrichtungen zur Förderung von Rohstoffen und Energieträgern.');
CREATE TABLE ln_funktion_kulturundunterhaltung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_funktion_kulturundunterhaltung IS 'Alias: "LN_Funktion_KulturUndUnterhaltung", UML-Typ: Enumeration';
INSERT INTO ln_funktion_kulturundunterhaltung (wert,beschreibung,dokumentation) VALUES
('1210', 'Kultur', 'Kultur bezeichnet eine Fläche auf der vorwiegend Anlagen und Gebäude für kulturelle Zwecke, z.B. Konzert- und Museumsgebäude, Bibliotheken, Theater, Schlösser und Burgen stehen.'),
('1220', 'Medien und Kommunikation', 'Medien und Kommunikation bezeichnet eine Fläche auf der vorwiegend Anlagen und Gebäude für die Erzeugung und Verbreitung von Printmedien, Hörfunk, Film und Fernsehen sowie Internet und Telefonie stehen.'),
('1230', 'Vergnügung', 'Vergnügung‘ bezeichnet eine Fläche mit Gebäuden und Einrichtungen, in denen Möglichkeiten zur unterhaltsamen Freizeitgestaltung angeboten werden.');
CREATE TABLE ln_art_freiluftundnaherholung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_art_freiluftundnaherholung IS 'Alias: "LN_Art_FreiluftUndNaherholung", UML-Typ: Enumeration';
INSERT INTO ln_art_freiluftundnaherholung (wert,beschreibung,dokumentation) VALUES
('4400', 'Grünanlage', 'Grünanlage ist in erster Linie eine Anlage mit Bäumen, Sträuchern, Rasenflächen, Blumenrabatten und Wegen, die vor allem der Erholung und Verschönerung des Stadtbildes dient.'),
('4410', 'Siedlungsgrünfläche', 'Siedlungsgrünfläche ist eine unbebaute Wiese, Freifläche oder anderweitige Grünfläche in Städten und Siedlungen.'),
('4420', 'Park', 'Park ist eine landschaftsgärtnerisch gestaltete Grünanlage, die der Repräsentation und der Erholung dient.'),
('4430', 'Botanischer Garten', 'Botanischer Garten ist ein der Öffentlichkeit zugänglicher Garten zum Studium der Pflanzenwelt; systematisch geordnete Sammlung in Freiland und Gewächshäusern (Warmhäuser).'),
('4440', 'Kleingarten', 'Kleingarten ist eine Anlage von Gartengrundstücken, die im Unterschied zu Gartenland vorwiegend der Freizeit und Erholung dient.'),
('4450', 'Wochenendplatz', 'Wochenendplatz sind Flächen, die der Freizeitgestaltung dienen.'),
('4470', 'Spielplatz, Bolzplatz', 'Spielplatz, Bolzplatz ist eine Freianlage, die dem nicht wettkampforientierten Sport-, Bewegungs- und Freizeitaktivitäten dient. Es können verschiedene Sportarten betrieben werden.'),
('4480', 'Zierfläche', 'Zierfläche ist eine der Öffentlichkeit zugängliche künstlich gepflegte Fläche kleineren Ausmaßes die vornehmlich der optischen Auflockerung des Stadtbildes dient, zur Erholung mit Kunst, Zierpflanzen.');
CREATE TABLE ln_art_gewerblichedienstleistungen (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_art_gewerblichedienstleistungen IS 'Alias: "LN_Art_GewerblicheDienstleistungen", UML-Typ: Enumeration';
INSERT INTO ln_art_gewerblichedienstleistungen (wert,beschreibung,dokumentation) VALUES
('1310', 'Handwerk', 'Handwerk‘ bezeichnet eine Fläche, auf der vorwiegend Handwerksbetriebe vorhanden sind.'),
('1320', 'Logistik und Transport', 'Logistik und Transport‘ umfasst Flächen mit Gebäuden und Einrichtungen, die sich mit der Planung, Steuerung und Durchführung von Güter-, Informations- und Personenströmen befassen. Hierzu gehören Speditionen, Bus- und Taxiunternehmen, Kurier-, Express- und Paketdienste.'),
('1330', 'Tankstelle', 'Tankstelle‘ bezeichnet eine Fläche, auf der sich Gebäude und Einrichtungen befinden, an denen Kraftfahrzeuge mit den benötigten Kraftstoffen versorgt werden.'),
('1410', 'Forschung und Entwicklung', 'Forschung und Entwicklung‘ bezeichnet eine Fläche, auf der sich vorwiegend industrielle Forschungs- und Entwicklungseinrichtungen befinden.'),
('1510', 'freie Berufe und weitere Dienstleistungen', 'freie Berufe und weitere Dienstleistungen‘ bezeichnet eine Fläche mit Gebäuden und Einrichtungen welche zur Ausübung freier Berufe wie auch weiterer Dienstleistungen genutzt wird.'),
('1520', 'Finanz- und Versicherungsdienstleistung', 'Finanz- und Versicherungsdienstleistungen‘ bezeichnet eine Fläche mit Gebäuden und Einrichtungen von Bank- oder Kreditunternehmen sowie von Versicherungsgesellschaften.'),
('1530', 'Handel', 'Handel‘ bezeichnet Flächen mit Anlagen mit Einzelhandels- und Dienstleistungsbetrieben, die durch einheitliche Verwaltung, auf das Einzugsgebiet abgestimmter Anbieter und durch umfangreiche Parkmöglichkeiten geprägt sind.'),
('1540', 'Ausstellung, Messe', 'Ausstellung, Messe‘ bezeichnet eine Fläche mit Ausstellungshallen und sonstigen Einrichtungen zur Präsentation von Warenmustern.'),
('1550', 'Gärtnerei', 'Gärtnerei bezeichnet eine Fläche mit Gebäuden, Gewächshäusern und sonstigen Einrichtungen, die der Aufzucht von Blumen und Gemüsepflanzen dienen.'),
('1560', 'Restauration', 'Restauration bezeichnet eine Fläche mit Gebäuden und Einrichtungen für das gewerbliche Angebot der gastronomischen Versorgung.'),
('1570', 'Beherbergung (Hotel, Pension, Herberge)', 'Beherbergung‘ bezeichnet eine Fläche mit Gebäuden und Einrichtungen für das gewerbliche Angebot der Unterbringung von Personen wie z.B. Hotel, Pension oder Herberge.'),
('1600', 'Verkehrsübungsplatz, Testgelände, Fahrsicherheit', 'Verkehrsübungsplatz, Testgelände, Fahrsicherheit umfasst Flächen, die Übungs- und Erprobungszwecken (auch technischer Produkte) dienen.');
CREATE TABLE ln_lagergut_lagerung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_lagergut_lagerung IS 'Alias: "LN_Lagergut_Lagerung", UML-Typ: Enumeration';
INSERT INTO ln_lagergut_lagerung (wert,beschreibung,dokumentation) VALUES
('1000', 'Baustoffe', 'Baustoffe sind sämtliche im Bauwesen verwendete Materialien, die als Lagergut aufbewahrt werden.'),
('2000', 'Kohle, Erz, Salz', 'Kohle, Erz und Salz sind durch Berg- bzw. Tagebau gewonnene Abbaugüter, die für eine Weiterverwendung (vorübergehend) gelagert werden.'),
('3000', 'Öl', 'Öl ist eine organische Flüssigkeit, die als Rohstoff gewonnen wird und in der Industrie vielseitige Verwendung findet.'),
('4000', 'Erdreich', 'Erdreich‘ bezeichnet eine Fläche auf der „Erdreich“ gelagert wird. Erdreich im vorliegenden Sinne bezeichnet Oberflächenmaterial, das überwiegend aus Mutterboden (Humusanteil, feine Korngrößen) besteht.'),
('5000', 'Schutt', 'Schutt ist eine nicht verfestigte Anhäufung von Trümmerstücken.'),
('7000', 'Abraum', 'Abraum sind unbrauchbare Boden- und Gesteinsmassen.'),
('8000', 'Schrott, Altmaterial', 'Schrott, Altmaterial sind Wertstoffe, die als Sekundärrohstoffe dienen.'),
('9000', 'Gas', 'Gas bezeichnet den Aggregatzustand einer Materie ohne bestimmte Gestalt.');
CREATE TABLE ln_zustand_industrieundverarbeitendesgewerbe (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_zustand_industrieundverarbeitendesgewerbe IS 'Alias: "LN_Zustand_IndustrieUndVerarbeitendesGewerbe", UML-Typ: Enumeration';
INSERT INTO ln_zustand_industrieundverarbeitendesgewerbe (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb', 'Außer Betrieb bedeutet, dass sich die Fläche nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('8000', 'Erweiterung, Neuansiedlung', 'Erweiterung, Neuansiedlung bedeutet, dass die Fläche in ihrer Nutzung gemäß der Objektart erweitert wird und eine Fertigstellung absehbar ist.');
CREATE TABLE ln_zustand_versorgungundentsorgung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_zustand_versorgungundentsorgung IS 'Alias: "LN_Zustand_VersorgungUndEntsorgung", UML-Typ: Enumeration';
INSERT INTO ln_zustand_versorgungundentsorgung (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb', 'Außer Betrieb bedeutet, dass sich die Fläche nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('8000', 'Erweiterung, Neuansiedlung', 'Erweiterung, Neuansiedlung bedeutet, dass die Fläche in ihrer Nutzung gemäß der Objektart erweitert wird und eine Fertigstellung absehbar ist.');
CREATE TABLE ln_zustand_abbau (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_zustand_abbau IS 'Alias: "LN_Zustand_Abbau", UML-Typ: Enumeration';
INSERT INTO ln_zustand_abbau (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb', 'Außer Betrieb bedeutet, dass sich die Fläche nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('8000', 'Erweiterung, Neuansiedlung', 'Erweiterung, Neuansiedlung bedeutet, dass die Fläche in ihrer Nutzung gemäß der Objektart erweitert wird und eine Fertigstellung absehbar ist.');
CREATE TABLE ln_funktion_oeffentlicheeinrichtungen (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_funktion_oeffentlicheeinrichtungen IS 'Alias: "LN_Funktion_OeffentlicheEinrichtungen", UML-Typ: Enumeration';
INSERT INTO ln_funktion_oeffentlicheeinrichtungen (wert,beschreibung,dokumentation) VALUES
('1110', 'Regierung und Verwaltung', 'Regierung und Verwaltung bezeichnet eine Fläche auf der vorwiegend Gebäude der öffentlichen Regierung und Verwaltung, z. B. Rathaus, Gericht, Kreisverwaltung stehen.'),
('1120', 'Bildung und Wissenschaft', 'Bildung und Wissenschaft bezeichnet eine Fläche, auf der vorwiegend Gebäude stehen, in denen geistige, kulturelle und soziale Fähigkeiten vermittelt werden und/oder wissenschaftliche Forschung betrieben wird (z.B. Schulen, Universitäten, Institute).'),
('1140', 'Religiöse Einrichtung', 'Religiöse Einrichtung bezeichnet eine Fläche auf der vorwiegend religiöse Gebäude stehen.'),
('1150', 'Gesundheit, Kur', 'Gesundheit, Kur bezeichnet eine Fläche auf der vorwiegend Gebäude des Gesundheitswesens stehen, z.B. Krankenhäuser, Heil- und Pflegeanstalten.'),
('1160', 'Soziales', 'Soziales bezeichnet eine Fläche auf der vorwiegend Gebäude des Sozialwesens stehen, z. B. Kindergärten, Jugend- und Senioreneinrichtungen, Freizeit-, Fremden- und Obdachlosenheime.'),
('1170', 'Sicherheit und Ordnung', 'Sicherheit und Ordnung bezeichnet eine Fläche auf der vorwiegend Anlagen und Gebäude der Polizei, der Bundeswehr, der Feuerwehr und der Justizvollzugsbehörden stehen.');
CREATE TABLE ln_art_freizeitanlage (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_art_freizeitanlage IS 'Alias: "LN_Art_Freizeitanlage", UML-Typ: Enumeration';
INSERT INTO ln_art_freizeitanlage (wert,beschreibung,dokumentation) VALUES
('4210', 'Zoo', 'Zoo ist ein Gelände mit Tierschauhäusern und umzäunten Gehegen, auf dem Tiere gehalten und gezeigt werden.'),
('4220', 'Safaripark, Wildpark', 'Safaripark, Wildpark ist ein Gelände mit umzäunten Gehegen, in denen Tiere im Freien gehalten und gezeigt werden.'),
('4230', 'Freizeitpark', 'Freizeitpark ist ein Gelände mit Karussells, Verkaufs- und Schaubuden und/oder Wildgattern, das der Freizeitgestaltung dient.'),
('4240', 'Freilichtbühne', 'Freilichtbühne ist eine Anlage mit Bühne und Zuschauerbänken für Aufführungen im Freien.'),
('4250', 'Freilichtmuseum', 'Freilichtmuseum ist eine volkskundliche Museumsanlage, in der Wohnformen oder historische Betriebsformen in ihrer natürlichen Umgebung im Freien dargestellt sind.'),
('4260', 'Autokino, Freilichtkino', 'Autokino, Freilichtkino ist ein Lichtspieltheater im Freien, in dem der Film im Allgemeinen vom Auto aus angesehen wird.'),
('4270', 'Modellfluggelände', 'Modellfluggelände ist eine Fläche, die zur Ausübung des Modellflugsports dient.'),
('4310', 'Festplatz', 'Festplatz ist eine Fläche, auf der zeitlich begrenzte Festveranstaltungen stattfinden.'),
('4320', 'Freizeitbad', 'Freizeitbad ist eine Anlage mit Schwimmbecken oder eine Anlage an Ufern von Gewässern für den Badebetrieb und Schwimmsport.'),
('4330', 'Campingplatz', 'Campingplatz ist eine Fläche für den Aufbau einer größeren Zahl von Zelten oder zum Abstellen und Benutzen von Wohnwagen mit ortsfesten Anlagen und Einrichtungen.'),
('4340', 'Kletteranlage', 'Kletteranlage ist eine Fläche mit Bauwerken und Einrichtungen, die zur Ausübung des Klettersports genutzt wird.'),
('4350', 'Gelände für Luftsportgeräte', 'Gelände für Luftsportgeräte ist eine Fläche, auf der Ultraleichtflug-, Hängegleiter-, Gleitsegel-, Sprungfallschirm-, Gleitflug- und Freiballonaktivitäten ausgeübt werden.'),
('4360', 'Go-Kart-Bahn', 'Go-Kart-Bahn umfasst eine abgegrenzte Strecke mit Anlagen und Gebäuden, die zur Ausübung des Kartrennsports genutzt wird. Hierzu gehören Indoor- und Outdoor-Kartbahnen.'),
('4370', 'Hundeübungsplatz', 'Hundeübungsplatz ist eine Fläche, auch mit Bauwerken, die speziell mit Hunden genutzt wird. (z. B. Rennhundesport, Parcours zum Abrichten).');
CREATE TABLE ln_zustand_oeffentlicheeinrichtungen (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_zustand_oeffentlicheeinrichtungen IS 'Alias: "LN_Zustand_OeffentlicheEinrichtungen", UML-Typ: Enumeration';
INSERT INTO ln_zustand_oeffentlicheeinrichtungen (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb', 'Außer Betrieb bedeutet, dass sich die Fläche nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('8000', 'Erweiterung, Neuansiedlung', 'Erweiterung, Neuansiedlung bedeutet, dass die Fläche in ihrer Nutzung gemäß der Objektart erweitert wird und eine Fertigstellung absehbar ist.');
CREATE TABLE ln_funktion_lagerung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_funktion_lagerung IS 'Alias: "LN_Funktion_Lagerung", UML-Typ: Enumeration';
INSERT INTO ln_funktion_lagerung (wert,beschreibung,dokumentation) VALUES
('8100', 'Deponie', 'Deponie bezeichnet eine Fläche, auf der oberirdisch Abfallstoffe gelagert werden. Deponie bezeichnet ebenfalls eine oberirdische Betriebsfläche, unter der Abfallstoffe unterirdisch eingelagert werden (Untertagedeponie).'),
('8200', 'Halde', 'Halde ist eine Fläche, auf der sich eine Aufschüttung von Material oberhalb der umgebenden Geländeoberfläche befindet, welche langfristig gelagert wird.'),
('8300', 'Lagerfläche', 'Lagerfläche bezeichnet Flächen, auf denen inner- und außerhalb von Gebäuden wirtschaftliche Güter gelagert werden.

Hinweis: Lager von Paketdienstleistern werden unter der Objektart 221310 LN_GewerblicheDienstleistungen’ geführt.');
CREATE TABLE ln_zustand_wohnnutzung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_zustand_wohnnutzung IS 'Alias: "LN_Zustand_Wohnnutzung", UML-Typ: Enumeration';
INSERT INTO ln_zustand_wohnnutzung (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb', 'Außer Betrieb bedeutet, dass sich die Fläche nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('8000', 'Erweiterung, Neuansiedlung', 'Erweiterung, Neuansiedlung bedeutet, dass die Fläche in ihrer Nutzung gemäß der Objektart erweitert wird und eine Fertigstellung absehbar ist.');
CREATE TABLE ln_oberflaeche_lagerung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_oberflaeche_lagerung IS 'Alias: "LN_Oberflaeche_Lagerung", UML-Typ: Enumeration';
INSERT INTO ln_oberflaeche_lagerung (wert,beschreibung,dokumentation) VALUES
('1000', 'oberirdisch', 'oberirdisch ist eine Fläche, auf der sich die Objekte auf oder über der Erdoberfläche befinden.'),
('2000', 'unterirdisch', 'unterirdisch ist eine Fläche, auf der sich die Objekte unter der Erdoberfläche befinden.');
CREATE TABLE ln_primaerenergie_versorgungundentsorgung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_primaerenergie_versorgungundentsorgung IS 'Alias: "LN_Primaerenergie_VersorgungUndEntsorgung", UML-Typ: Enumeration';
INSERT INTO ln_primaerenergie_versorgungundentsorgung (wert,beschreibung,dokumentation) VALUES
('1000', 'Wasser', 'Wasser bedeutet, dass das Kraftwerk potentielle und kinetische Energie des Wasserkreislaufs in elektrische Energie umwandelt.'),
('2000', 'Kernkraft', 'Kernkraft bedeutet, dass das Kraftwerk die durch Kernspaltung gewonnene Energie in eine andere Energieform umwandelt.'),
('3000', 'Sonne', 'Sonne bedeutet, dass das Kraftwerk bzw. Heizwerk Sonnenenergie in eine andere Energieform umwandelt.'),
('4000', 'Wind', 'Wind bedeutet, dass das Kraftwerk die Strömungsenergie des Windes in elektrische Energie umwandelt.'),
('5000', 'Gezeiten', 'Gezeiten bedeutet, dass das Kraftwerk die kinetische Energie der Meeresgezeiten in elektrische Energie umwandelt.'),
('6000', 'Erdwärme', 'Erdwärme bedeutet, dass das Heizwerk die geothermische Energie der Erde nutzt.'),
('7100', 'Kohle', 'Kohle bedeutet, dass das Kraftwerk bzw. Heizwerk die durch Verbrennung von Kohle frei werdende Energie in eine andere Energieform umwandelt.'),
('7200', 'Öl', 'Öl bedeutet, dass das Kraftwerk bzw. Heizwerk die durch Verbrennung von Öl freiwerdende Energie in eine andere Energieform umwandelt.'),
('7300', 'Gas', 'Gas bedeutet, dass das Kraftwerk bzw. Heizwerk die durch Verbrennung von Gas freiwerdende Energie in eine andere Energieform umwandelt.'),
('7400', 'Müll, Abfall', 'Müll, Abfall bedeutet, dass das Kraftwerk bzw. Heizwerk die durch Verbrennung von Müll bzw. Abfall freiwerdende Energie in eine andere Energieform umwandelt.'),
('7500', 'Biomasse', 'Biomasse sind organische Substanzen (z.B. Pflanzen, Futtermittelabfälle, Gülle), die verbrannt und/oder vergärt werden, um Energie zu gewinnen.');
CREATE TABLE ln_artderbestattungsflaeche_bestattung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_artderbestattungsflaeche_bestattung IS 'Alias: "LN_ArtDerBestattungsflaeche_Bestattung", UML-Typ: Enumeration';
INSERT INTO ln_artderbestattungsflaeche_bestattung (wert,beschreibung,dokumentation) VALUES
('1000', 'Friedhof', 'Friedhof umfasst eingefriedete Flächen für Gräber.'),
('2000', 'Waldbestattungsfläche', 'Waldbestattungsfläche umfasst eine besondere Waldfläche außerhalb eines Friedhofes zur Bestattung ohne Pflege der Grabstelle.'),
('3000', 'historischer Friedhof', 'historischer Friedhof ist ein Friedhof, der als historisch gilt.'),
('4000', 'Parkfriedhof', 'Parkfriedhof ist ein Friedhof, der als Park angelegt ist.');
CREATE TABLE ln_zeitlichkeit_wohnnutzung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_zeitlichkeit_wohnnutzung IS 'Alias: "LN_Zeitlichkeit_Wohnnutzung", UML-Typ: Enumeration';
INSERT INTO ln_zeitlichkeit_wohnnutzung (wert,beschreibung,dokumentation) VALUES
('1000', 'Dauerhaft', 'Dauerhaft bezeichnet eine beständige fortwährend anhaltende Nutzung der Flächen.'),
('2000', 'Zeitweilig', 'Zeitweilig bezeichnet die Nutzung der Flächen nur zu bestimmten Zeiten wie z.B. Ferienhäuser und Wochenendhäuser.');
CREATE TABLE ln_zustand_kulturundunterhaltung (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_zustand_kulturundunterhaltung IS 'Alias: "LN_Zustand_KulturUndUnterhaltung", UML-Typ: Enumeration';
INSERT INTO ln_zustand_kulturundunterhaltung (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb', 'Außer Betrieb bedeutet, dass sich die Fläche nicht mehr in regelmäßiger, der Bestimmung entsprechenden Nutzung befindet.'),
('8000', 'Erweiterung, Neuansiedlung', 'Erweiterung, Neuansiedlung bedeutet, dass die Fläche in ihrer Nutzung gemäß der Objektart erweitert wird und eine Fertigstellung absehbar ist.');
CREATE TABLE ln_sportart_sportanlage (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_sportart_sportanlage IS 'Alias: "LN_Sportart_Sportanlage", UML-Typ: Enumeration';
INSERT INTO ln_sportart_sportanlage (wert,beschreibung,dokumentation) VALUES
('1010', 'Ballsport', 'Ballsport bedeutet, dass ein Spielfeld oder Stadion zur Ausübung des Ballsports genutzt wird.'),
('1011', 'Fußball', 'Fußball bedeutet, dass ein Spielfeld oder Stadion zum Fußball spielen genutzt wird.'),
('1012', 'Golf', 'Golf ist eine Fläche mit Bauwerken und Einrichtungen, die zur Ausübung des Golfsports genutzt wird.'),
('1013', 'Tennis', 'Tennis ist eine Fläche mit baulichen Anlagen und mit Spielfeldern für den Tennissport. Die zusammenhängenden Spielflächen innerhalb einer Tennisanlage werden zu einem Spielfeld zusammengefasst.'),
('1020', 'Leichtathletik', 'Leichtathletik bedeutet, dass ein Spielfeld oder Stadion zur Ausübung verschiedener Leichtathletikdisziplinen genutzt wird'),
('1030', 'Wassersport', 'Wassersport bezeichnet ein Areal welches beispielsweise zum Rudern, Segeln oder für Wasserski genutzt wird.'),
('1040', 'Schwimmen', 'Schwimmen bedeutet, dass ein Stadion zum Schwimmen genutzt wird.'),
('1050', 'Ski', 'Ski bedeutet, dass ein Stadion zur Ausübung des Skisports genutzt wird.'),
('1060', 'Motorrennsport', 'Motorrennsport bedeutet, dass eine Rennbahn zur Ausübung des Motorrennsports genutzt wird.'),
('1070', 'Eislauf, Eishockey', 'Eislauf, Eishockey bedeutet, dass ein Stadion zur Ausübung des Eislaufsports oder des Eishockeysports genutzt wird.'),
('1080', 'Rollschuhlaufen, Skating', 'Rollschuhlaufen, Skating bedeutet, dass eine Laufbahn zum Rollschuhfahren, Skaten genutzt wird.'),
('1110', 'Radsport', 'Radsport bedeutet, dass ein Stadion oder eine Rennbahn zur Ausübung des Radsports genutzt wird.'),
('1120', 'Pferdesport', 'Pferdesport ist eine Anlage für Wettkämpfe und/oder dient der Ausübung des Reitsports. Die Fläche des Reitsports kann u.a. Stallungen und kleine bauliche Anlagen enthalten.'),
('1130', 'Schießen', 'Schießen umfasst ein Gelände mit Gebäuden zum Üben und Prüfen von Schusswaffen und Schützen. (z.B. Schützenvereinsanlagen, Schießanlagen, Trainingsgelände für Schützen).');
CREATE TABLE ln_hafenkategorie_schiffsverkehr (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_hafenkategorie_schiffsverkehr IS 'Alias: "LN_Hafenkategorie_Schiffsverkehr", UML-Typ: Enumeration';
INSERT INTO ln_hafenkategorie_schiffsverkehr (wert,beschreibung,dokumentation) VALUES
('1010', 'Containerhafen', 'Containerhafen ist ein Hafen mit speziellen Einrichtungen (z. B. Verladebrücken) für den Umschlag von genormten Containern.'),
('1020', 'Ölhafen', 'Ölhafen ist ein Hafen mit speziellen Einrichtungen (z. B. Tankanlagen) für den Umschlag von Rohöl und den daraus verarbeiteten Produkten'),
('1030', 'Fischereihafen', 'Fischereihafen ist ein Hafen mit speziellen Einrichtungen (z. B. Kühlhäuser) für den Umschlag von frisch gefangenem Fisch.'),
('1040', 'Sporthafen, Yachthafen', 'Sporthafen, Yachthafen ist ein Hafen für Sport- und Freizeitschiffe.'),
('1050', 'Fährhafen', 'Fährhafen ist ein Hafen zum Anlegen von Fährschiffen.'),
('1060', 'Stückguthafen', 'Stückguthafen ist ein Hafen, in dem nur Stückgüter umgeschlagen werden.'),
('1070', 'Hafen für Massengüter', 'Hafen für Massengüter ist ein Hafen, in dem Massengüter umgeschlagen werden.'),
('1080', 'Hafenbecken', 'Hafenbecken’ ist der ufernahe Bereich eines Gewässers, der zum Be- und Entladen von Schiffen dient und Schiffen gleichzeitig Schutz bietet.');
CREATE TABLE ln_fussgaengerzone_strassenundwegeverkehr (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_fussgaengerzone_strassenundwegeverkehr IS 'Alias: "LN_Fussgaengerzone_StrassenUndWegeverkehr", UML-Typ: Enumeration';
INSERT INTO ln_fussgaengerzone_strassenundwegeverkehr (wert,beschreibung,dokumentation) VALUES
('5130', 'Fußgängerzone', 'Fußgängerzone ist ein dem Fußgängerverkehr vorbehaltener Bereich, in dem ausnahmsweise öffentlicher Personenverkehr, Lieferverkehr oder Fahrradverkehr zulässig sein kann.');
CREATE TABLE ln_funktion_bahnverkehr (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_funktion_bahnverkehr IS 'Alias: "LN_Funktion_Bahnverkehr", UML-Typ: Enumeration';
INSERT INTO ln_funktion_bahnverkehr (wert,beschreibung,dokumentation) VALUES
('5210', 'Bahnverkehrsfläche', 'Bahnverkehrsfläche ist eine Fläche die der Abwicklung und Sicherheit des Bahnverkehrs sowie der Unterhaltung dieser Verkehrsflächen dient. Sie beinhaltet die Flächen der Trasse sowie deren Begleitfläche.'),
('5211', 'Trasse (Streckengleisbett)', 'Trasse ist ein befestigtes, dem allgemeinen Schienenverkehr dienendes Gleisbett einschließlich der auf Brücken oder in Tunneln verlaufenden Abschnitte.'),
('5212', 'Begleitfläche Bahnverkehr', 'Begleitfläche Bahnverkehr bezeichnet eine unbebaute Fläche, die dem Bahnverkehr zugeordnet wird. Die Begleitfläche Bahnverkehr ist nicht Bestandteil der Gleisanlagen.'),
('5220', 'Betriebsfläche Bahnverkehr', 'Betriebsfläche Bahnverkehr bezeichnet Flächen, auf denen vorwiegend Anlagen und Gebäude zur Versorgung, Unterhaltung und Instandhaltung des Bahnverkehrs vorhanden sind.'),
('5230', 'Bahnhofsstation', 'Bahnhofsstation ist eine Anlage im Netz der Schienen- und Magnetschwebebahnen zur Abwicklung des Personen- und Güterverkehrs entsprechend der Angaben des Betreibers.');
CREATE TABLE ln_zustand_schiffsverkehr (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_zustand_schiffsverkehr IS 'Alias: "LN_Zustand_Schiffsverkehr", UML-Typ: Enumeration';
INSERT INTO ln_zustand_schiffsverkehr (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb', 'Außer Betrieb bedeutet, dass sich das Objekt nicht mehr in regelmäßiger, der Bestimmung entsprechender Nutzung befindet.'),
('4000', 'Im Bau', 'Im Bau bedeutet, dass die Bauarbeiten am Objekt bereits begonnen haben und das Objekt noch nicht fertiggestellt ist.'),
('8000', 'Erweiterung, Neuansiedlung', 'Erweiterung, Neuansiedlung bedeutet, dass die Fläche in ihrer Nutzung gemäß der Objektart erweitert wird und eine Fertigstellung absehbar ist.');
CREATE TABLE ln_nutzung_flugverkehr (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_nutzung_flugverkehr IS 'Alias: "LN_Nutzung_Flugverkehr", UML-Typ: Enumeration';
INSERT INTO ln_nutzung_flugverkehr (wert,beschreibung,dokumentation) VALUES
('1000', 'Zivil', 'zivil bedeutet, dass Flugverkehr privaten oder öffentlichen Zwecken dient und nicht militärisch genutzt wird.'),
('2000', 'Militärisch', 'Militärisch bedeutet, dass Flugverkehr nur von Streitkräften genutzt wird.');
CREATE TABLE ln_funktion_schiffsverkehr (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_funktion_schiffsverkehr IS 'Alias: "LN_Funktion_Schiffsverkehr", UML-Typ: Enumeration';
INSERT INTO ln_funktion_schiffsverkehr (wert,beschreibung,dokumentation) VALUES
('5410', 'Schiffsverkehrsfläche', 'Schiffsverkehrsfläche umfasst die wasserseitigen Flächen, auf denen der fließende oder stehende Schiffsverkehr stattfindet und die mit ihr in Zusammenhang stehenden begleitenden Freifläche wie z.B. die Uferstreifen.'),
('5411', 'Wasserweg', 'Wasserweg ist der Transportweg auf dem Wasser, auf dem hauptsächlich durch Schifffahrt Personen und / oder Güter befördert werden. Hierin sind neben dem Wasserkörper auch die Schleusenkammeren eingeschlossen.'),
('5412', 'Begleitfläche Schiffsverkehr', 'Begleitfläche Schiffsverkehr bezeichnet landseitige unbebaute Flächen, die dem Schiffsverkehr zugeordnet wird. Die Begleitfläche Schiffsverkehr ist nicht Bestandteil der Wasserverkehrsanlagen.'),
('5413', 'Wasserliegeplatz', 'Wasserliegeplatz bezeichnet eine wasserseitige Stelle außerhalb von Hafenbecken, an dem Wasserfahrzeuge vorübergehend oder dauerhaft verankert sind, mit dem Zweck des Güterumschlages (keine Boots-, Stand- oder Landliegeplätze).'),
('5420', 'Betriebsfläche Schiffsverkehr', 'Betriebsfläche bezeichnet landseitige Flächen mit zugehörigen Bauwerken, die dem Betrieb des Schiffsverkehrs zuzuordnen sind.'),
('5421', 'Fähranlage', 'Fähranlage ist eine besondere Landfläche von der in der Regel nach festem Fahrplan über Flüsse, Seen, Kanäle, Meerengen oder Meeresarme ein Schiffsverkehr stattfindet.'),
('5422', 'Hafenanlage', 'Hafenanlage bezeichnet die landseitige Fläche die nicht von Wasser bedeckt ist und die ausschließlich zum Betrieb des Hafens (zum Be- und Entladen) dient.'),
('5423', 'Anlegestelle', 'Anlegestelle umfasst den landseitigen Anleger umgebenden Bereich, der eine feste oder schwimmende Einrichtung zum Anlegen von Schiffen und Booten ist.'),
('5424', 'Schleuse', 'Schleuse bezeichnet die Fläche Landfläche die ausschließlich zum Betrieb der Schleuse dient.');
CREATE TABLE ln_typ_schutzanlage (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_typ_schutzanlage IS 'Alias: "LN_Typ_Schutzanlage", UML-Typ: Enumeration';
INSERT INTO ln_typ_schutzanlage (wert,beschreibung,dokumentation) VALUES
('1910', 'Hochwasserdeich', 'Hochwasserdeich ist ein Deich an einem Fließgewässer oder im Küstengebiet, der dem Schutz eines Gebietes vor Hochwasser oder gegen Sturmfluten dient.'),
('1920', 'Hauptdeich, Landesschutzdeich', 'Hauptdeich, Landesschutzdeich ist ein Deich der ersten Deichlinie zum Schutz der Küsten- und Inselgebiete gegen Sturmflut.'),
('1930', 'Überlaufdeich', 'Überlaufdeich ist ein Deich vor dem Hauptdeich, der in erster Linie dem Schutz landwirtschaftlich genutzter Flächen gegen leichte Sturmtiden dient und der bei höheren Sturmtiden überströmt wird.'),
('1940', 'Leitdeich', 'Leitdeich ist ein dammartiges Bauwerk im Watt, um strömendes Wasser in bestimmte Richtungen zu lenken und zum Schutz von Wasserläufen im Watt (Außentiefs) vor Versandung.'),
('1950', 'Polderdeich', 'Polderdeich ist ein vor dem Hauptdeich liegender Deich, der landwirtschaftlich nutzbares Land (z. B. Marschland) schützt.');
CREATE TABLE ln_artdesparkplatzes_strassenundwegeverkehr (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_artdesparkplatzes_strassenundwegeverkehr IS 'Alias: "LN_ArtDesParkplatzes_StrassenUndWegeverkehr", UML-Typ: Enumeration';
INSERT INTO ln_artdesparkplatzes_strassenundwegeverkehr (wert,beschreibung,dokumentation) VALUES
('1000', 'Öffentlich', 'Öffentlich bezeichnet die Zugänglichkeit und Nutzung eines Parkplatzes für jedermann.'),
('2000', 'Nutzungsbezogen', 'Nutzungsbezogen bezeichnet die eingeschränkte Nutzungsrecht eines Parkplatzes wie z.B. Parkplätze auf einem Firmengelände');
CREATE TABLE ln_funktion_flugverkehr (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_funktion_flugverkehr IS 'Alias: "LN_Funktion_Flugverkehr", UML-Typ: Enumeration';
INSERT INTO ln_funktion_flugverkehr (wert,beschreibung,dokumentation) VALUES
('5310', 'Flugverkehrsfläche', 'Flugverkehrsfläche umfasst die baulich geprägte Fläche und die mit ihr in Zusammenhang stehende Freifläche, die ausschließlich oder vorwiegend dem Flugverkehr dient.'),
('5311', 'Startbahn, Landebahn', 'Startbahn, Landebahn ist eine Fläche, auf der Flugzeuge starten bzw. landen.'),
('5312', 'Begleitfläche Flugverkehr', 'Begleitfläche Flugverkehr bezeichnet eine unbebaute Fläche, die dem Flugverkehr zugeordnet wird. Die Begleitfläche Flugverkehr beinhaltet nicht die Flächen für den Flugverkehr wie Vorfeld, Start- und Landebahn oder Taxiway. Hierzu gehören z.B. Grünflächen neben den Flugverkehrsflächen.'),
('5313', 'Zurollbahn, Taxiway', 'Zurollbahn, Taxiway ist ein Verbindungsweg zwischen den Terminals bzw. dem Vorfeld und der Start- und/oder Landebahn.'),
('5314', 'Vorfeld', 'Vorfeld ist ein Bereich, in dem Flugzeuge abgefertigt und abgestellt werden.'),
('5320', 'Betriebsfläche Flugverkehr', 'Betriebsfläche Flugverkehr bezeichnet Flächen, auf denen vorwiegend Anlagen und Gebäude zur Versorgung und Unterhaltung des Flugverkehrs vorhanden sind. Hierzu gehören z.B. Hangars.');
CREATE TABLE ln_zuflusssteuerung_schutzanlage (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_zuflusssteuerung_schutzanlage IS 'Alias: "LN_Zuflusssteuerung_Schutzanlage", UML-Typ: Enumeration';
INSERT INTO ln_zuflusssteuerung_schutzanlage (wert,beschreibung,dokumentation) VALUES
('1000', 'Gesteuert', 'Gesteuert bedeutet, dass die eingedeichte Fläche regelmäßig zu einem bestimmten festgelegten Zeitpunkt geflutet wird (z.B. bei einem ausgewählten Pegelstand).'),
('2000', 'Ungesteuert', 'Ungesteuert bedeutet, dass die eingedeichte Fläche ereignisabhängig geflutet wird.');
CREATE TABLE ln_zustand_strassenundwegeverkehr (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_zustand_strassenundwegeverkehr IS 'Alias: "LN_Zustand_StrassenUndWegeverkehr", UML-Typ: Enumeration';
INSERT INTO ln_zustand_strassenundwegeverkehr (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb', 'Außer Betrieb bedeutet, dass sich das Objekt nicht mehr in regelmäßiger, der Bestimmung entsprechender Nutzung befindet.'),
('4000', 'Im Bau', 'Im Bau bedeutet, dass die Bauarbeiten am Objekt bereits begonnen haben und das Objekt noch nicht fertiggestellt ist.'),
('8000', 'Erweiterung, Neuansiedlung', 'Erweiterung, Neuansiedlung bedeutet, dass die Fläche in ihrer Nutzung gemäß der Objektart erweitert wird und eine Fertigstellung absehbar ist.');
CREATE TABLE ln_funktion_schutzanlage (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_funktion_schutzanlage IS 'Alias: "LN_Funktion_Schutzanlage", UML-Typ: Enumeration';
INSERT INTO ln_funktion_schutzanlage (wert,beschreibung,dokumentation) VALUES
('5510', 'Hochwasserschutz (Damm, Wall, Deich, Schutzwand, Schutzmauer)', 'Hochwasserschutz ist eine Fläche die einen Hochwasserfall oder dessen Auswirkungen begrenzt. Hierzu zählen Damm, Wall, Deich, Schutzwand, Schutzmauer.'),
('5520', 'Polder', 'Polder ist eine eingedeichte Fläche innerhalb eines Überschwemmungsgebietes, die zum Schutz vor Überflutung ereignisabhängig oder regelmäßig geflutet werden kann.'),
('5530', 'Lärmschutz (Wall, Schutzwand)', 'Lärmschutz bedeutet, dass das Bauwerk dem Schutz vor Lärmemissionen dient. Hierzu zählen ein Lärmschutzwall oder eine Lärmschutzwand.'),
('5540', 'Windschutz (Hecke, Knick)', 'Windschutz beschreibt bauliche Anlagen oder geeigneten Bewuchs zur Hemmung von Windschäden und Verwehungen. (z. B. Hecken, Feldgehölze, Knicks).');
CREATE TABLE ln_zustand_bahnverkehr (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_zustand_bahnverkehr IS 'Alias: "LN_Zustand_Bahnverkehr", UML-Typ: Enumeration';
INSERT INTO ln_zustand_bahnverkehr (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb', 'Außer Betrieb bedeutet, dass sich das Objekt nicht mehr in regelmäßiger, der Bestimmung entsprechender Nutzung befindet.'),
('4000', 'Im Bau', 'Im Bau bedeutet, dass die Bauarbeiten am Objekt bereits begonnen haben und das Objekt noch nicht fertiggestellt ist.'),
('8000', 'Erweiterung, Neuansiedlung', 'Erweiterung, Neuansiedlung bedeutet, dass die Fläche in ihrer Nutzung gemäß der Objektart erweitert wird und eine Fertigstellung absehbar ist.');
CREATE TABLE ln_funktion_strassenundwegeverkehr (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_funktion_strassenundwegeverkehr IS 'Alias: "LN_Funktion_StrassenUndWegeverkehr", UML-Typ: Enumeration';
INSERT INTO ln_funktion_strassenundwegeverkehr (wert,beschreibung,dokumentation) VALUES
('5110', 'Straßen- und Wegeverkehrsfläche', 'Straßen- und Wegeverkehrsfläche ist eine Fläche die der Abwicklung und Sicherheit des Verkehrs sowie der Unterhaltung der Verkehrsfläche dient. Sie beinhaltet die Flächen der Fahrbahn sowie deren Begleitfläche.'),
('5111', 'Fahrbahn', 'Fahrbahn bezeichnet Flächen, die den zusammenhängenden, befestigten Teil der Straße bilden, als Verkehrsraum dienen und mit Fahrzeugen befahren werden dürfen. Zur Fahrbahn gehören auch Stand- und Kriechspuren.'),
('5112', 'Begleitfläche Straßen- und Wegeverkehr', 'Begleitfläche Straßen- und Wegeverkehr bezeichnet eine unbebaute Fläche, die einer Straße oder eines Weges zugeordnet wird. Die Begleitfläche Straßen- und Wegeverkehr ist nicht Bestandteil der Fahrbahn.'),
('5120', 'Betriebsfläche Straßen- und Wegeverkehr', 'Betriebsfläche Straßen- und Wegeverkehr bezeichnet Flächen, auf denen vorwiegend Anlagen und Gebäude zur Versorgung und Unterhaltung der Verkehrsflächen bzw. des Straßen- und Wegeverkehrs vorhanden sind. Hierzu gehören z.B. Straßenmeistereien.'),
('5130', 'Rastplatz', 'Rastplatz ist eine Anlage zum Rasten der Verkehrsteilnehmer mit unmittelbarem Anschluss zur Straße ohne Versorgungseinrichtung, ggf. mit Toiletten.'),
('5140', 'Raststätte, Autohof', 'Raststätte, Autohof ist eine Anlage an Verkehrsstraßen mit Bauwerken und Einrichtungen zur Versorgung und Erholung von Reisenden. Dazu gehören Autohöfe gemäß der Verwaltungsvorschriften zur Straßenverkehrsordnung (VwV-StVO).'),
('5150', 'Parkplatz', 'Parkplatz bezeichnet eine Fläche, auf der vorwiegend Anlagen und Gebäude zum Abstellen von Fahrzeugen stehen.'),
('5160', 'Marktplatz', 'Marktplatz ist eine Fläche, auf der Waren regelmäßig an einem zentralen Ort gehandelt werden.'),
('5170', 'Busbahnhof', 'Busbahnhof umfasst einen zentralen Platz, an dem sich der Autobusverkehr einer Stadt oder Region konzentriert. Meist mit Haltestellenanlagen.'),
('5180', 'Caravan-, Wohnmobilstellplatz', 'Caravan-, Wohnmobilstellplatz ist ein öffentlich zugänglicher Stellplatz für Caravan-, Wohn- bzw. Reisemobile, auf dem man im Fahrzeug ein oder mehrere Nächte übernachten darf.
Auf einigen dieser Stellplätze sind auch Wohnwagengespanne zugelassen. Diese unterliegen nicht der "Verordnung über Camping- und Wochenendplätze" (CW-VO) und sind aus rechtlicher Sicht keine Campingplätze, sondern Parkplätze im Sinne des örtlich gültigen Straßenverkehrsrechts.');
CREATE TABLE ln_zustand_flugverkehr (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_zustand_flugverkehr IS 'Alias: "LN_Zustand_Flugverkehr", UML-Typ: Enumeration';
INSERT INTO ln_zustand_flugverkehr (wert,beschreibung,dokumentation) VALUES
('2100', 'Außer Betrieb', 'Außer Betrieb bedeutet, dass sich das Objekt nicht mehr in regelmäßiger, der Bestimmung entsprechender Nutzung befindet.'),
('4000', 'Im Bau', 'Im Bau bedeutet, dass die Bauarbeiten am Objekt bereits begonnen haben und das Objekt noch nicht fertiggestellt ist.'),
('8000', 'Erweiterung, Neuansiedlung', 'Erweiterung, Neuansiedlung bedeutet, dass die Fläche in ihrer Nutzung gemäß der Objektart erweitert wird und eine Fertigstellung absehbar ist.');
CREATE TABLE ln_nutzung_schiffsverkehr (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ln_nutzung_schiffsverkehr IS 'Alias: "LN_Nutzung_Schiffsverkehr", UML-Typ: Enumeration';
INSERT INTO ln_nutzung_schiffsverkehr (wert,beschreibung,dokumentation) VALUES
('1000', 'Zivil', 'zivil bedeutet, dass Schiffsverkehr privaten oder öffentlichen Zwecken dient und nicht militärisch genutzt wird.'),
('2000', 'Militärisch', 'Militärisch bedeutet, dass Schiffsverkehr nur von Streitkräften genutzt wird.');
CREATE TABLE lb_oberflaechenmaterial_lockermaterial (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE lb_oberflaechenmaterial_lockermaterial IS 'Alias: "LB_Oberflaechenmaterial_Lockermaterial", UML-Typ: Enumeration';
INSERT INTO lb_oberflaechenmaterial_lockermaterial (wert,beschreibung,dokumentation) VALUES
('1000', 'Geröll, Schotter, Kies', 'Geröll, Schotter Kies umfasst unbewachsene Oberflächen, die mit größeren, abgerundeten oder kantigen Gesteinstrümmern bedeckt sind. Hierzu zählen auch Kohle, Erze oder Salze in zerkleinerter Form.'),
('2000', 'Sand, Feinkies', 'Sand, Feinkies umfasst unbewachsene Oberflächen, die mit kleinen losen Gesteinskörnern bedeckt sind.'),
('3000', 'Erdreich', 'Erdreich sind unbewachsene Oberflächen, die überwiegend mit Mutterboden (Humusanteil, feine Körngrößen) bedeckt sind.'),
('4000', 'Ton, Schluff', 'Ton, Schluff umfasst unbewachsene Oberflächen ohne Humusanteil, die mit mineralischen Partikeln sehr feiner Korngröße bedeckt sind und im Allgemeinen auch als Lehm bezeichnet werden.'),
('5000', 'künstlich', 'künstlich umfasst jegliche Art aus fragmentierten Materialien künstlichen Ursprungs in aufgeschütteter Form. Beispiele für künstliche Materialien sind: Abfall, Müll, Schutt, Schlacke, Schrott, Altmaterial.');
CREATE TABLE lb_wassersaettigung_lockermaterial (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE lb_wassersaettigung_lockermaterial IS 'Alias: "LB_Wassersaettigung_Lockermaterial", UML-Typ: Enumeration';
INSERT INTO lb_wassersaettigung_lockermaterial (wert,beschreibung,dokumentation) VALUES
('1000', 'ganzjährig', 'ganzjährige Wassersättigung bedeutet, dass die Hohlräume des Bodens ganzjährig vollständig mit Wasser gefüllt sind. Ein solcher nasser Standort kann zeitweise auch unter Wasser stehen.'),
('2000', 'zeitweilig', 'zeitweilige Wassersättigung bedeutet, dass die Hohlräume des Bodens in regelmäßigem Zyklus (periodisch) oder nur gelegentlich und vorübergehend (episodisch) vollständig mit Wasser gefüllt sind. Ein solcher vorübergehend nasser Standort kann zeitweise auch unter Wasser stehen.');
CREATE TABLE lb_vegetationsmerkmal_holzigevegetation (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE lb_vegetationsmerkmal_holzigevegetation IS 'Alias: "LB_Vegetationsmerkmal_HolzigeVegetation", UML-Typ: Enumeration';
INSERT INTO lb_vegetationsmerkmal_holzigevegetation (wert,beschreibung,dokumentation) VALUES
('4000', 'Bäume', 'Bäume bedeutet, dass die Oberflächen mit verholzten Pflanzen bestanden ist, welche aus einem Wurzelwerk, einem daraus emporsteigenden, hochgewachsenen Stamm und einer verästelten Krone bestehen.'),
('5000', 'Gehölz', 'Gehölz ist eine Mischfläche, die mit einzelnen verholzten Pflanzen unterschiedlicher Wuchshöhe und Wuchsform (sowohl Bäume als auch Büsche oder Sträucher) in gemischter Form bestockt ist.'),
('6000', 'Büsche, Sträucher', 'Büsche, Sträucher umfasst eine Fläche, die mit holziger Vegetation unterschiedlicher Wuchsform und begrenzter Wuchshöhe bestanden ist. Büsche und Sträucher haben in der Regel mehrere Stammtriebe, deren Sprossen sich nahe der Bodenoberfläche verzweigen.'),
('7000', 'Zwergsträucher', 'Zwergsträucher ist eine Sonderform der holzigen Vegetation. Sie umfasst eine Fläche, die mit Pflanzen sehr niederer Wuchshöhe bestanden ist. Beispiele hierfür sind: Heidekrautgewächse, Lavendel.');
CREATE TABLE lb_blattform_holzigevegetation (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE lb_blattform_holzigevegetation IS 'Alias: "LB_Blattform_HolzigeVegetation", UML-Typ: Enumeration';
INSERT INTO lb_blattform_holzigevegetation (wert,beschreibung,dokumentation) VALUES
('1000', 'Laub', 'Laub beschreibt die Zugehörigkeit der Pflanzen zur Gruppe der Laubhölzer (Bedecktsamer).'),
('2000', 'Nadel', 'Nadel beschreibt die Zugehörigkeit der Pflanzen zur Gruppe der Nadelhölzer (Nacktsamer).');
CREATE TABLE lb_wassersaettigung_holzigevegetation (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE lb_wassersaettigung_holzigevegetation IS 'Alias: "LB_Wassersaettigung_HolzigeVegetation", UML-Typ: Enumeration';
INSERT INTO lb_wassersaettigung_holzigevegetation (wert,beschreibung,dokumentation) VALUES
('1000', 'ganzjährig', 'ganzjährige Wassersättigung bedeutet, dass die Hohlräume des Bodens ganzjährig vollständig mit Wasser gefüllt sind. Ein solcher nasser Standort kann zeitweise auch unter Wasser stehen.'),
('2000', 'zeitweilig', 'zeitweilige Wassersättigung bedeutet, dass die Hohlräume des Bodens in regelmäßigem Zyklus (periodisch) oder nur gelegentlich und vorübergehend (episodisch) vollständig mit Wasser gefüllt sind. Ein solcher vorübergehend nasser Standort kann zeitweise auch unter Wasser stehen.');
CREATE TABLE lb_wassersaettigung_krautigevegetation (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE lb_wassersaettigung_krautigevegetation IS 'Alias: "LB_Wassersaettigung_KrautigeVegetation", UML-Typ: Enumeration';
INSERT INTO lb_wassersaettigung_krautigevegetation (wert,beschreibung,dokumentation) VALUES
('1000', 'ganzjährig', 'ganzjährige Wassersättigung bedeutet, dass die Hohlräume des Bodens ganzjährig vollständig mit Wasser gefüllt sind. Ein solcher nasser Standort kann zeitweise auch unter Wasser stehen.'),
('2000', 'zeitweilig', 'zeitweilige Wassersättigung bedeutet, dass die Hohlräume des Bodens in regelmäßigem Zyklus (periodisch) oder nur gelegentlich und vorübergehend (episodisch) vollständig mit Wasser gefüllt sind. Ein solcher vorübergehend nasser Standort kann zeitweise auch unter Wasser stehen.');
CREATE TABLE lb_vegetationsmerkmal_krautigevegetation (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE lb_vegetationsmerkmal_krautigevegetation IS 'Alias: "LB_Vegetationsmerkmal_KrautigeVegetation", UML-Typ: Enumeration';
INSERT INTO lb_vegetationsmerkmal_krautigevegetation (wert,beschreibung,dokumentation) VALUES
('1000', 'Gras', 'Gras beschreibt den Bewuchs einer Vegetationsfläche mit schlanken, krautigen einkeimblättrigen Blütenpflanzen.'),
('2000', 'Röhricht, Schilf', 'Röhricht, Schilf beschreibt den Bewuchs einer Vegetations- oder Wasserfläche mit Schilfrohr- und schilfrohrähnlichen Pflanzen.'),
('3000', 'Getreide, Staudengewächse, Farne', 'Getreide, Staudengewächse, Farne umfasst Flächen, die überwiegend mit krautigen Pflanzen (Getreide, Mais und andere Ackerfrüchte, Staudengewächse, Farne) bestanden sind. Hierzu zählt auch zeitweise vegetationsloses Erdreich (Mutterboden) von landwirtschaftlich genutzten Ackerflächen.');
CREATE TABLE lb_wasserfuehrung_binnengewaesser (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE lb_wasserfuehrung_binnengewaesser IS 'Alias: "LB_Wasserfuehrung_Binnengewaesser", UML-Typ: Enumeration';
INSERT INTO lb_wasserfuehrung_binnengewaesser (wert,beschreibung,dokumentation) VALUES
('1000', 'ganzjährig', 'ganzjährige Wasserführung bedeutet, dass Gewässer das ganze Jahr hindurch perennierend Wasser führt.'),
('2000', 'zeitweilig', 'zeitweilige Wasserführung bedeutet, dass das Gewässer in regelmäßigem Zyklus (periodisch) Wasser führt (Beispiele: Schneeschmelze, Regenzeit etc.), oder nur gelegentlich und vorübergehend (episodisch) Wasser führt (Beispiel: saisonunabhängige Starkregenereignisse).');
CREATE TABLE lb_eisart_eis (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE lb_eisart_eis IS 'Alias: "LB_Eisart_Eis", UML-Typ: Enumeration';
INSERT INTO lb_eisart_eis (wert,beschreibung,dokumentation) VALUES
('2010', 'Gletscher', 'Gletscher umfasst eine von Gletschereis bedeckte Fläche. Gletschereis ist aus mehrjährigem Schnee unter zunehmendem Eigendruck entstanden. Gletscher sind entsprechend der Jahreszeiten teils mit Schnee bedeckt.'),
('2020', 'Dauerschnee, Firn', 'Dauerschnee bedeutet, dass die Erdoberfläche ganzjährig mit Schnee bedeckt ist. Firn bedeutet, dass die Erdoberfläche im Hochgebirge mit altem, grobkörnigem, mehrjährigem und stark verdichtetem Schnee bedeckt ist, der unter zunehmendem Druck zu Gletschereis wird.');
CREATE TABLE lb_fliesseigenschaft_binnengewaesser (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE lb_fliesseigenschaft_binnengewaesser IS 'Alias: "LB_Fliesseigenschaft_Binnengewaesser", UML-Typ: Enumeration';
INSERT INTO lb_fliesseigenschaft_binnengewaesser (wert,beschreibung,dokumentation) VALUES
('1000', 'fließend', 'fließend bedeutet, dass das Wasser aufgrund eines Gefälles ständig in Bewegung ist.'),
('2000', 'stehend', 'stehend bedeutet, dass das Gewässer insgesamt oder abschnittsweise eine einheitliche Höhe des Wasserspiegels besitzt; dies schließt saisonale Schwankungen dieser einheitlichen Wasserspiegelhöhe nicht aus.');
CREATE TABLE lb_meerart_meer (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE lb_meerart_meer IS 'Alias: "LB_Meerart_Meer", UML-Typ: Enumeration';
INSERT INTO lb_meerart_meer (wert,beschreibung,dokumentation) VALUES
('1010', 'Watt', 'Watt ist ein aus Sand oder Schlick bestehender Boden an flachen Gezeitenküsten und Flüssen, der bei Ebbe ganz oder teilweise trocken fällt.'),
('1020', 'Haff, Bodden', 'Haff, Bodden ist ein vom offenen Meer durch Landzungen gänzlich oder teilweise abgetrenntes Küstengewässer an der Ostsee.'),
('1030', 'Priel', 'Priel ist eine natürliche Rinne im Watt, die auch bei Ebbe Wasser führt.');
CREATE TABLE lb_gewaesserart_binnengewaesser (
  wert integer,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE lb_gewaesserart_binnengewaesser IS 'Alias: "LB_Gewaesserart_Binnengewaesser", UML-Typ: Enumeration';
INSERT INTO lb_gewaesserart_binnengewaesser (wert,beschreibung,dokumentation) VALUES
('1010', 'Fluss', 'Fluss ist ein natürliches, fließendes Gewässer (ggf. auch mit begradigten, kanalisierten Teilstücken), das wegen seiner Größe und Bedeutung im allgemeinen Sprachgebrauch als Fluss angesprochen wird. Kriterien hierfür können eine größere Wassertiefe, ein größere Breite oder größere Gewässerquerschnitt sein.'),
('1020', 'Bach', 'Bach ist ein natürliches, fließendes Gewässer, das wegen seiner geringen Größe und Bedeutung im allgemeinen Sprachgebrauch als Bach anzusehen ist. Kriterien hierfür können eine geringere Wassertiefe, eine geringe Breite, oder kleiner Gewässerquerschnitt sein. Bäche unterscheiden sich von Flüssen durch ihren stärker ans Gelände angepassten Verlauf, das unregelmäßige Längsprofil und den oft schießenden Abfluss.'),
('2000', 'Altwasser, Altarm', 'Altwasser, Altarm ist ein Teil eines Fließgewässers, der bei einer Begradigung vom fließenden Gewässer an beiden oder an einem Ende abgetrennt wurde, wodurch das Gewässer einen eher stehenden Charakter bekommt.'),
('3010', 'Kanal', 'Kanal bezeichnet einen künstlich angelegten Wasserlauf. In der Regel hat er einen regelmäßigen Gewässerquerschnitt und einen geradlinigen Verlauf.'),
('3020', 'Graben', 'Graben ist ein ständig oder zeitweise fließendes, künstlich angelegtes Gewässer, das im allgemeinen Sprachgebrauch als Graben anzusehen ist. In der Regel hat er einen regelmäßigen Gewässerquerschnitt und einen geradlinigen Verlauf.'),
('4000', 'Becken', 'Becken ist eine zweckgebundene, künstlich errichtete, befestigte Hohlform im Gelände, die im allgemeinen Sprachgebrauch als eine Art von "Becken" bezeichnet werden. In der Regel sind Becken von einer künstlich errichteten Umrandung oder einem Bauwerk ganz oder teilweise umschlossen. Beispiele hierfür sind: Hafenbecken, Speicherbecken, Rückhaltebecken, Klärbecken, Fischzuchtbecken.'),
('5000', 'See, Teich', 'See, Teich ist eine natürliche oder naturnah angelegte, stehende oder nahezu stehende Wasserfläche, die im allgemeinen Sprachgebrauch als See oder Teich anzusehen ist. In der Regel haben Seen und Teiche einen natürlichen oder naturnahen Uferverlauf. Dies gilt auch für Talsperren- und Stauseen.');
CREATE TABLE ci_rolecode (
  wert character varying,
  beschreibung character varying,
  dokumentation character varying,
  PRIMARY KEY (wert)
);

COMMENT ON TABLE ci_rolecode IS 'Alias: "CI_RoleCode", UML-Typ: Enumeration';
INSERT INTO ci_rolecode (wert,beschreibung,dokumentation) VALUES
('author', NULL, ''),
('principalInvestigator', NULL, ''),
('distributor', NULL, ''),
('owner', NULL, ''),
('processor', NULL, ''),
('publisher', NULL, ''),
('pointOfContact', NULL, ''),
('resourceProvider', NULL, ''),
('user', NULL, ''),
('custodian', NULL, ''),
('originator', NULL, '');
CREATE TABLE aa_anlassart (
  codespace text,
  id character varying,
  value text,
  PRIMARY KEY (id)
);

COMMENT ON TABLE aa_anlassart IS 'Alias: "AA_Anlassart", UML-Typ: Code Liste';
CREATE TABLE aa_gefuehrteobjektart (
  codespace text,
  id character varying,
  value text,
  PRIMARY KEY (id)
);

COMMENT ON TABLE aa_gefuehrteobjektart IS 'Alias: "AA_GefuehrteObjektart", UML-Typ: Code Liste';
CREATE TABLE aa_anlassart_benutzungsauftrag (
  codespace text,
  id character varying,
  value text,
  PRIMARY KEY (id)
);

COMMENT ON TABLE aa_anlassart_benutzungsauftrag IS 'Alias: "AA_Anlassart_Benutzungsauftrag", UML-Typ: Code Liste';
CREATE TABLE aa_weiteremodellart (
  codespace text,
  id character varying,
  value text,
  PRIMARY KEY (id)
);

COMMENT ON TABLE aa_weiteremodellart IS 'Alias: "AA_WeitereModellart", UML-Typ: Code Liste';
CREATE TABLE aa_besonderemeilensteinkategorie (
  codespace text,
  id character varying,
  value text,
  PRIMARY KEY (id)
);

COMMENT ON TABLE aa_besonderemeilensteinkategorie IS 'Alias: "AA_BesondereMeilensteinkategorie", UML-Typ: Code Liste';

INSERT INTO aa_anlassart (id, value) VALUES ('000000', 'Ersteinrichtung');
INSERT INTO aa_anlassart (id, value) VALUES ('010307', 'Eintragung des Flurstückes');
INSERT INTO aa_anlassart (id, value) VALUES ('010308', 'Löschen des Flurstückes');
INSERT INTO aa_anlassart (id, value) VALUES ('010309', 'Veränderung der Gemeindezugehörigkeit einzelner Flurstücke');
INSERT INTO aa_anlassart (id, value) VALUES ('010310', 'Veränderung der Gemeindezugehörigkeit');
INSERT INTO aa_anlassart (id, value) VALUES ('010312', 'Veränderung der Flurstücksnummer ');
INSERT INTO aa_anlassart (id, value) VALUES ('010317', 'Gebäudeeinmessung nach § 14 Abs. 2 Satz 2 VermGeoG LSA');
INSERT INTO aa_anlassart (id, value) VALUES ('010401', 'Veränderung der besonderen Flurstücksgrenze');
INSERT INTO aa_anlassart (id, value) VALUES ('010402', 'Veränderung der Lage');
INSERT INTO aa_anlassart (id, value) VALUES ('010403', 'Veränderung der tatsächlichen Nutzung mit Änderung der Wirtschaftsart');
INSERT INTO aa_anlassart (id, value) VALUES ('010404', 'Veränderung des Anliegervermerks');
INSERT INTO aa_anlassart (id, value) VALUES ('010405', 'Veränderung der tatsächlichen Nutzung ohne Änderung der Wirtschaftsart ');
INSERT INTO aa_anlassart (id, value) VALUES ('010501', 'Berichtigung der Flächenangabe');
INSERT INTO aa_anlassart (id, value) VALUES ('010502', 'Berichtigung eines Zeichenfehlers');
INSERT INTO aa_anlassart (id, value) VALUES ('010503', 'Berichtigung eines Katastrierungsfehlers');
INSERT INTO aa_anlassart (id, value) VALUES ('300420', 'Veränderung der Bodenschätzung');
INSERT INTO aa_anlassart (id, value) VALUES ('010511', 'Berichtigung der Flächenangabe mit Veränderung des Flurstückskennzeichens');
INSERT INTO aa_anlassart (id, value) VALUES ('050300', 'Berichtigung aufgrund Erwerbsvorgängen außerhalb des Grundbuchs');
INSERT INTO aa_anlassart (id, value) VALUES ('060000', 'Grundstücke buchen');
INSERT INTO aa_anlassart (id, value) VALUES ('060100', 'Abschreibung');
INSERT INTO aa_anlassart (id, value) VALUES ('060101', 'Abschreibung auf neues Buchungsblatt');
INSERT INTO aa_anlassart (id, value) VALUES ('010601', 'Verfahren nach dem Flurbereinigungsgesetz');
INSERT INTO aa_anlassart (id, value) VALUES ('010602', 'Verfahren nach dem Baugesetzbuch');
INSERT INTO aa_anlassart (id, value) VALUES ('010611', 'Flurbereinigung');
INSERT INTO aa_anlassart (id, value) VALUES ('010615', 'Übernahme von wichtigen Terminen im Ablauf eines Bodenordnungsverfahrens ');
INSERT INTO aa_anlassart (id, value) VALUES ('010616', 'Vermessung der Verfahrensgrenze des Flurbereinigungsgebietes');
INSERT INTO aa_anlassart (id, value) VALUES ('010619', 'Übernahme von Flurbereinigungsergebnissen');
INSERT INTO aa_anlassart (id, value) VALUES ('010621', 'Umlegung');
INSERT INTO aa_anlassart (id, value) VALUES ('010622', 'Umlegung nach § 76 BauGB');
INSERT INTO aa_anlassart (id, value) VALUES ('010623', 'Vereinfachte Umlegung');
INSERT INTO aa_anlassart (id, value) VALUES ('010700', 'Katastererneuerung');
INSERT INTO aa_anlassart (id, value) VALUES ('010701', 'Katastererneuerung - vereinfachte Neuvermessung');
INSERT INTO aa_anlassart (id, value) VALUES ('010702', 'Erneuerung der Lagekoordinaten ');
INSERT INTO aa_anlassart (id, value) VALUES ('010703', 'Veränderung aufgrund der Qualitätsverbesserung');
INSERT INTO aa_anlassart (id, value) VALUES ('010704', 'Qualitätssicherung und Datenpflege');
INSERT INTO aa_anlassart (id, value) VALUES ('010801', 'Zuschreibung eines Flurstückes (Gebietsreform)');
INSERT INTO aa_anlassart (id, value) VALUES ('010802', 'Abschreibung eines Flurstückes (Gebietsreform)');
INSERT INTO aa_anlassart (id, value) VALUES ('010900', 'Grenzfeststellung');
INSERT INTO aa_anlassart (id, value) VALUES ('010901', 'Grenzvermessung');
INSERT INTO aa_anlassart (id, value) VALUES ('010902', 'Grenzwiederherstellung');
INSERT INTO aa_anlassart (id, value) VALUES ('010903', 'Grenzbestimmung');
INSERT INTO aa_anlassart (id, value) VALUES ('010904', 'Grenzabmarkung ');
INSERT INTO aa_anlassart (id, value) VALUES ('020100', 'Katasterliche Buchungsdaten fortführen');
INSERT INTO aa_anlassart (id, value) VALUES ('020102', 'Katasterliche Buchung eines buchungsfreien Grundstücks');
INSERT INTO aa_anlassart (id, value) VALUES ('020200', 'Namensnummer von katasterlichen Buchungsstellen verändern');
INSERT INTO aa_anlassart (id, value) VALUES ('020201', 'Katasterliche Namensnummer und Rechtsgemeinschaft fortführen');
INSERT INTO aa_anlassart (id, value) VALUES ('020301', 'Veränderung der Personendaten');
INSERT INTO aa_anlassart (id, value) VALUES ('020302', 'Veränderung der Personengruppe');
INSERT INTO aa_anlassart (id, value) VALUES ('020304', 'Veränderung der Verwaltung');
INSERT INTO aa_anlassart (id, value) VALUES ('020305', 'Veränderung der Vertretung ');
INSERT INTO aa_anlassart (id, value) VALUES ('030000', 'Grundbuchblattbezeichnung ändern');
INSERT INTO aa_anlassart (id, value) VALUES ('030100', 'Umnummerierung (infolge Zuständigkeitsänderungen am Grundbuch)');
INSERT INTO aa_anlassart (id, value) VALUES ('040000', 'Beschreibung der Buchungsstelle ändern');
INSERT INTO aa_anlassart (id, value) VALUES ('040100', 'Änderungen am Wohnungseigentum');
INSERT INTO aa_anlassart (id, value) VALUES ('040200', 'Änderungen am Wohnungserbbaurecht');
INSERT INTO aa_anlassart (id, value) VALUES ('040500', 'Änderungen an den Beziehungen zwischen den Buchungsstellen');
INSERT INTO aa_anlassart (id, value) VALUES ('040600', 'Änderungen in der Ergänzung, Beschreibung sowie der Bemerkung zu Buchungen');
INSERT INTO aa_anlassart (id, value) VALUES ('050000', 'Angaben zu Eigentümer oder Erbbauberechtigten verändern');
INSERT INTO aa_anlassart (id, value) VALUES ('050100', 'Eigentumsänderung');
INSERT INTO aa_anlassart (id, value) VALUES ('050101', 'Kompletter Eigentumswechsel im Grundbuchblatt');
INSERT INTO aa_anlassart (id, value) VALUES ('050102', 'Teilweiser Eigentumswechsel im Grundbuchblatt');
INSERT INTO aa_anlassart (id, value) VALUES ('050200', 'Berichtigung aufgrund Erbnachweis');
INSERT INTO aa_anlassart (id, value) VALUES ('060102', 'Abschreibung auf bestehendes Buchungsblatt');
INSERT INTO aa_anlassart (id, value) VALUES ('060200', 'Teilung');
INSERT INTO aa_anlassart (id, value) VALUES ('060201', 'Buchung der neuen Grundstücke in einem bestehenden Buchungsblatt');
INSERT INTO aa_anlassart (id, value) VALUES ('060600', 'Vollziehung einer Verschmelzung');
INSERT INTO aa_anlassart (id, value) VALUES ('060700', 'Buchung aufgrund Veränderung der Grundstücksbezeichnung oder der Größe (Spalten 3 + 4 des BV)');
INSERT INTO aa_anlassart (id, value) VALUES ('060801', 'Buchung des Grundstücks auf ein neues Buchungsblatt (1)');
INSERT INTO aa_anlassart (id, value) VALUES ('060802', 'Buchung des Grundstücks auf ein bestehendes Buchungsblatt der Miteigentümer');
INSERT INTO aa_anlassart (id, value) VALUES ('060900', 'Aufhebung eines Wohnungseigentums');
INSERT INTO aa_anlassart (id, value) VALUES ('062000', 'Grundbuchblatt schließen');
INSERT INTO aa_anlassart (id, value) VALUES ('070000', 'Rechte buchen');
INSERT INTO aa_anlassart (id, value) VALUES ('070100', 'Erbbaurecht anlegen');
INSERT INTO aa_anlassart (id, value) VALUES ('070200', 'Erbbaurecht aufheben');
INSERT INTO aa_anlassart (id, value) VALUES ('070300', 'Herrschvermerk buchen');
INSERT INTO aa_anlassart (id, value) VALUES ('070400', 'Herrschvermerk aufheben');
INSERT INTO aa_anlassart (id, value) VALUES ('070500', 'Untererbbaurecht anlegen');
INSERT INTO aa_anlassart (id, value) VALUES ('070600', 'Untererbbaurecht aufheben');
INSERT INTO aa_anlassart (id, value) VALUES ('070700', 'Sonstige Rechte anlegen');
INSERT INTO aa_anlassart (id, value) VALUES ('070800', 'Sonstige Rechte aufheben');
INSERT INTO aa_anlassart (id, value) VALUES ('070900', 'Wohnungserbbaurecht aufheben');
INSERT INTO aa_anlassart (id, value) VALUES ('071000', 'Wohnungsuntererbbaurecht aufheben');
INSERT INTO aa_anlassart (id, value) VALUES ('071100', 'Teilung Herrschvermerk aufheben');
INSERT INTO aa_anlassart (id, value) VALUES ('071200', 'Teilung sonstiges Recht aufheben');
INSERT INTO aa_anlassart (id, value) VALUES ('080000', 'Anteile buchen');
INSERT INTO aa_anlassart (id, value) VALUES ('080200', 'Anlegen von Wohnungseigentum');
INSERT INTO aa_anlassart (id, value) VALUES ('080300', 'Anlegen von Wohnungserbbaurecht');
INSERT INTO aa_anlassart (id, value) VALUES ('080400', 'Anlegen von Wohnungsuntererbbaurecht');
INSERT INTO aa_anlassart (id, value) VALUES ('080500', 'Teilung eines Herrschvermerks');
INSERT INTO aa_anlassart (id, value) VALUES ('080600', 'Teilung eines sonstigen Rechts');
INSERT INTO aa_anlassart (id, value) VALUES ('080650', 'Auflösung ungetrennter Hofräume');
INSERT INTO aa_anlassart (id, value) VALUES ('080700', 'Teilung am ungetrennten Hofraum aufheben');
INSERT INTO aa_anlassart (id, value) VALUES ('080800', 'Teilung einer Buchung § 3 Abs. 4 GBO nach Wohnungseigentumsgesetz');
INSERT INTO aa_anlassart (id, value) VALUES ('080900', 'Teilung eines Anteils am ungetrennten Hofraum nach Wohnungseigentumsgesetz');
INSERT INTO aa_anlassart (id, value) VALUES ('090000', 'Ändern in Verzeichnissen ohne Grundbucheintragung');
INSERT INTO aa_anlassart (id, value) VALUES ('090100', 'Verwaltung eintragen oder ändern');
INSERT INTO aa_anlassart (id, value) VALUES ('090200', 'Personengruppe eintragen oder ändern');
INSERT INTO aa_anlassart (id, value) VALUES ('090300', 'Änderung der Anschrift');
INSERT INTO aa_anlassart (id, value) VALUES ('090400', 'Änderung der Personendaten');
INSERT INTO aa_anlassart (id, value) VALUES ('090500', 'Entstehung eines Festpunkts (erstmalige Aufnahme in AFIS)');
INSERT INTO aa_anlassart (id, value) VALUES ('090510', 'Änderung von Koordinaten, Höhe und/oder Schwerewert eines Festpunkts');
INSERT INTO aa_anlassart (id, value) VALUES ('090520', 'Veränderung der Vermarkung und/oder der beschreibenden Angaben eines Festpunkts');
INSERT INTO aa_anlassart (id, value) VALUES ('090530', 'Zerstörung der Vermarkung eines Festpunkts');
INSERT INTO aa_anlassart (id, value) VALUES ('090540', 'Untergang eines Festpunktes');
INSERT INTO aa_anlassart (id, value) VALUES ('001000', 'Grundaktualisierung');
INSERT INTO aa_anlassart (id, value) VALUES ('100000', 'Veränderung der Angaben zu den Nutzerprofilen');
INSERT INTO aa_anlassart (id, value) VALUES ('002000', 'Spitzenaktualisierung');
INSERT INTO aa_anlassart (id, value) VALUES ('200000', 'Veränderung von Gebäudedaten');
INSERT INTO aa_anlassart (id, value) VALUES ('200100', 'Eintragen eines Gebäudes');
INSERT INTO aa_anlassart (id, value) VALUES ('200200', 'Veränderung der Gebäudeeigenschaften');
INSERT INTO aa_anlassart (id, value) VALUES ('200300', 'Löschen eines Gebäudes');
INSERT INTO aa_anlassart (id, value) VALUES ('300000', 'Sonstige Daten fortführen');
INSERT INTO aa_anlassart (id, value) VALUES ('300100', 'Veränderungen der Angaben zum Netzpunkt');
INSERT INTO aa_anlassart (id, value) VALUES ('300410', 'Veränderung der öffentlich-rechtlichen und sonstigen Festsetzungen');
INSERT INTO aa_anlassart (id, value) VALUES ('300421', 'Erfassung der Bodenschätzung ');
INSERT INTO aa_anlassart (id, value) VALUES ('300430', 'Veränderung der Bewertung');
INSERT INTO aa_anlassart (id, value) VALUES ('300440', 'Veränderung der Gebietseinheiten');
INSERT INTO aa_anlassart (id, value) VALUES ('300501', 'Veränderung aufgrund der Homogenisierung ');
INSERT INTO aa_anlassart (id, value) VALUES ('300600', 'Veränderung der Reservierung von Fachkennzeichen');
INSERT INTO aa_anlassart (id, value) VALUES ('300700', 'Veränderung von Katalogeinträgen ');
INSERT INTO aa_anlassart (id, value) VALUES ('300800', 'Veränderung von Metadaten');
INSERT INTO aa_anlassart (id, value) VALUES ('300900', 'Veränderung der Geometrie durch Implizitbehandlung');
INSERT INTO aa_anlassart (id, value) VALUES ('004100', 'Automatische Kartographische Generalisierung mit Konflikt');
INSERT INTO aa_anlassart (id, value) VALUES ('005000', 'Interaktive Kartographische Generalisierung');
INSERT INTO aa_anlassart (id, value) VALUES ('006000', 'Veränderung an der Landesgrenze und des Gebietes');
INSERT INTO aa_anlassart (id, value) VALUES ('009999', 'Sonstiges');
INSERT INTO aa_anlassart (id, value) VALUES ('003000', 'Angaben zur Grundbuchfortführung');
INSERT INTO aa_anlassart (id, value) VALUES ('010101', 'Zerlegung oder Sonderung');
INSERT INTO aa_anlassart (id, value) VALUES ('010102', 'Verschmelzung');
INSERT INTO aa_anlassart (id, value) VALUES ('010103', 'Zerlegung und Verschmelzung');
INSERT INTO aa_anlassart (id, value) VALUES ('010104', 'Flurstückszerlegung mit Eigentumsübergang nach Straßengesetzen');
INSERT INTO aa_anlassart (id, value) VALUES ('010105', 'Zerlegung ');
INSERT INTO aa_anlassart (id, value) VALUES ('010107', 'Sonderung ');
INSERT INTO aa_anlassart (id, value) VALUES ('010199', 'Verschmelzung von Flurstücken auf unterschiedlichen Beständen/Buchungsstellen');
INSERT INTO aa_anlassart (id, value) VALUES ('010201', 'Veränderung aufgrund der Vorschriften des Straßenrechts');
INSERT INTO aa_anlassart (id, value) VALUES ('010202', 'Veränderung aufgrund der Vorschriften des Wasserrechts');
INSERT INTO aa_anlassart (id, value) VALUES ('010203', 'Veränderung am Flurstück mit Änderung der Umfangsgrenzen ');
INSERT INTO aa_anlassart (id, value) VALUES ('010205', 'Veränderung aufgrund Berichtigung eines Aufnahmefehlers');
INSERT INTO aa_anlassart (id, value) VALUES ('010206', 'Veränderung aufgrund gerichtlicher Entscheidung');
INSERT INTO aa_anlassart (id, value) VALUES ('010207', 'Veränderung aufgrund Berichtigung eines Grenzbestimmungsfehlers');
INSERT INTO aa_anlassart (id, value) VALUES ('010301', 'Veränderung der Flurstücksbezeichnung');
INSERT INTO aa_anlassart (id, value) VALUES ('010303', 'Veränderung der Gemeindezugehörigkeit ganzer Gemarkungen');
INSERT INTO aa_anlassart (id, value) VALUES ('010305', 'Veränderung der Flurzugehörigkeit');
INSERT INTO aa_anlassart (id, value) VALUES ('050400', 'Namensänderung');
INSERT INTO aa_anlassart (id, value) VALUES ('060901', 'Buchung des Grundstücks auf ein neues Buchungsblatt (2)');
INSERT INTO aa_anlassart (id, value) VALUES ('060902', 'Buchung des Grundstücks auf ein bestehendes Buchungsblatt');
INSERT INTO aa_anlassart (id, value) VALUES ('061000', 'Umschreibung des Grundbuchs (§§ 28 ff, 68 GBV)');
INSERT INTO aa_anlassart (id, value) VALUES ('061100', 'Neufassung des Grundbuchs (§§ 33, 69 GBV)');
INSERT INTO aa_anlassart (id, value) VALUES ('061200', 'Erstbuchung eines Grundstücks');
INSERT INTO aa_anlassart (id, value) VALUES ('061400', 'Aufhebung von Anteilen am ungetrennten Hofraum');

CREATE TABLE ax_netzknoten (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  bezeichnung character varying NOT NULL,
  ergebnisderueberpruefung integer,
  statement character varying,
  processstep_ax_li_processstep_mitdatenerhebung_description character varying[],
  processstep_rationale character varying[],
  processstep_datetime character(20)[],
  processstep_individualname character varying[],
  processstep_organisationname character varying[],
  processstep_positionname character varying[],
  processstep_phone character varying[],
  processstep_address character varying[],
  processstep_onlineresource character varying[],
  processstep_hoursofservice character varying[],
  processstep_contactinstructions character varying[],
  processstep_role character varying[],
  processstep_ax_datenerhebung character varying[],
  processstep_scaledenominator character varying[],
  processstep_sourcereferencesystem character varying[],
  processstep_sourceextent character varying[],
  processstep_sourcestep character varying[],
  herkunft_source_source_ax_datenerhebung character varying[],
  herkunft_source_source_scaledenominator character varying[],
  herkunft_source_source_sourcereferencesystem character varying[],
  herkunft_source_source_sourceextent character varying[],
  herkunft_source_source_sourcestep character varying[],
  bestehtaus character(16)[],
  istteilvon character(16)[],
  hat3d character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_netzknoten_gml ON ax_netzknoten USING btree (gml_id,beginnt);
CREATE INDEX ax_netzknoten_endet ON ax_netzknoten USING btree (endet);
CREATE INDEX ax_netzknoten_hat3d ON ax_netzknoten USING gin (hat3d);
CREATE INDEX ax_netzknoten_bestehtaus ON ax_netzknoten USING gin (bestehtaus);
CREATE INDEX ax_netzknoten_istteilvon ON ax_netzknoten USING gin (istteilvon);

COMMENT ON TABLE ax_netzknoten IS 'FeatureType: "AX_Netzknoten"';
COMMENT ON COLUMN ax_netzknoten.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_netzknoten.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_netzknoten.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_netzknoten.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_netzknoten.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_netzknoten.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_netzknoten.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_netzknoten.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_netzknoten.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_netzknoten.bezeichnung IS 'bezeichnung  CharacterString 1';
COMMENT ON COLUMN ax_netzknoten.ergebnisderueberpruefung IS 'ergebnisDerUeberpruefung enumeration AX_ErgebnisDerUeberpruefung_BauwerkeEinrichtungenUndSonstigeAngaben 0..1';
COMMENT ON COLUMN ax_netzknoten.statement IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|statement|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_netzknoten.processstep_ax_li_processstep_mitdatenerhebung_description IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|description|AX_LI_ProcessStep_MitDatenerhebung_Description enumeration  1';
COMMENT ON COLUMN ax_netzknoten.processstep_rationale IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|rationale|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_netzknoten.processstep_datetime IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|dateTime|DateTime  DateTime 0..1';
COMMENT ON COLUMN ax_netzknoten.processstep_individualname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|individualName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_netzknoten.processstep_organisationname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|organisationName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_netzknoten.processstep_positionname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|positionName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_netzknoten.processstep_phone IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|phone|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_netzknoten.processstep_address IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|address|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_netzknoten.processstep_onlineresource IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|onlineResource|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_netzknoten.processstep_hoursofservice IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|hoursOfService|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_netzknoten.processstep_contactinstructions IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|contactInstructions|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_netzknoten.processstep_role IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|role|CI_RoleCode enumeration CI_RoleCode 1';
COMMENT ON COLUMN ax_netzknoten.processstep_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_netzknoten.processstep_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_netzknoten.processstep_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_netzknoten.processstep_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_netzknoten.processstep_sourcestep IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_netzknoten.herkunft_source_source_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_netzknoten.herkunft_source_source_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_netzknoten.herkunft_source_source_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_netzknoten.herkunft_source_source_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_netzknoten.herkunft_source_source_sourcestep IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_netzknoten.hat3d IS 'Assoziation zu: FeatureType AX_Bauwerk3D (ax_bauwerk3d) 0..*';
CREATE TABLE ax_besondererbauwerkspunkt (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  art integer,
  hoehe double precision[],
  obererbezugspunkt integer[],
  untererbezugspunkt integer[],
  punktkennung character varying,
  sonstigeeigenschaft character varying[],
  zustaendigestelle_land character varying,
  zustaendigestelle_stelle character varying,
  bestehtaus character(16)[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_besondererbauwerkspunkt_gml ON ax_besondererbauwerkspunkt USING btree (gml_id,beginnt);
CREATE INDEX ax_besondererbauwerkspunkt_endet ON ax_besondererbauwerkspunkt USING btree (endet);
CREATE INDEX ax_besondererbauwerkspunkt_bestehtaus ON ax_besondererbauwerkspunkt USING gin (bestehtaus);
CREATE INDEX ax_besondererbauwerkspunkt_istteilvon ON ax_besondererbauwerkspunkt USING gin (istteilvon);

COMMENT ON TABLE ax_besondererbauwerkspunkt IS 'FeatureType: "AX_BesondererBauwerkspunkt"';
COMMENT ON COLUMN ax_besondererbauwerkspunkt.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_besondererbauwerkspunkt.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_besondererbauwerkspunkt.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_besondererbauwerkspunkt.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_besondererbauwerkspunkt.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_besondererbauwerkspunkt.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_besondererbauwerkspunkt.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_besondererbauwerkspunkt.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_besondererbauwerkspunkt.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_besondererbauwerkspunkt.art IS 'art enumeration AX_Art_Bauwerkspunkt 0..1';
COMMENT ON COLUMN ax_besondererbauwerkspunkt.hoehe IS 'objekthoehe|AX_RelativeHoehe|hoehe  Length 1';
COMMENT ON COLUMN ax_besondererbauwerkspunkt.obererbezugspunkt IS 'objekthoehe|AX_RelativeHoehe|obererBezugspunkt enumeration AX_ObererBezugspunkt 0..1';
COMMENT ON COLUMN ax_besondererbauwerkspunkt.untererbezugspunkt IS 'objekthoehe|AX_RelativeHoehe|untererBezugspunkt enumeration AX_UntererBezugspunkt 0..1';
COMMENT ON COLUMN ax_besondererbauwerkspunkt.punktkennung IS 'punktkennung  CharacterString 0..1';
COMMENT ON COLUMN ax_besondererbauwerkspunkt.sonstigeeigenschaft IS 'sonstigeEigenschaft  CharacterString 0..*';
COMMENT ON COLUMN ax_besondererbauwerkspunkt.zustaendigestelle_land IS 'zustaendigeStelle|AX_Dienststelle_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_besondererbauwerkspunkt.zustaendigestelle_stelle IS 'zustaendigeStelle|AX_Dienststelle_Schluessel|stelle  CharacterString 1';
CREATE TABLE ax_referenzstationspunkt (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  darstellungshinweis character varying,
  erstvermarkung date,
  frueherepunktnummer character varying[],
  gemarkungsnummer character varying,
  land character varying,
  gemeinde_gemeinde character varying NOT NULL,
  gemeinde_gemeindeteil character varying,
  gemeinde_kreis character varying NOT NULL,
  gemeinde_land character varying NOT NULL,
  gemeinde_regierungsbezirk character varying,
  internebemerkungen character varying[],
  katasteramt_land character varying,
  katasteramt_stelle character varying,
  land_land character varying NOT NULL,
  namelagebeschreibung character varying,
  nutzerspezifischebemerkungen character varying[],
  nutzungextern character varying NOT NULL,
  punktkennung character varying NOT NULL,
  punktvermarkung integer NOT NULL,
  relativehoehe double precision,
  untergangsdatum date,
  vermarkungsdatum date,
  funktion integer,
  befund character varying,
  gnsstauglichkeit integer,
  punktstabilitaet integer,
  ueberwachungsdatum date,
  bestehtaus character(16)[],
  istteilvon character(16)[],
  istidentischmitlfp character(16),
  istidentischmithfp character(16),
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_referenzstationspunkt_gml ON ax_referenzstationspunkt USING btree (gml_id,beginnt);
CREATE INDEX ax_referenzstationspunkt_endet ON ax_referenzstationspunkt USING btree (endet);
CREATE INDEX ax_referenzstationspunkt_istidentischmitlfp ON ax_referenzstationspunkt USING btree (istidentischmitlfp);
CREATE INDEX ax_referenzstationspunkt_istidentischmithfp ON ax_referenzstationspunkt USING btree (istidentischmithfp);
CREATE INDEX ax_referenzstationspunkt_bestehtaus ON ax_referenzstationspunkt USING gin (bestehtaus);
CREATE INDEX ax_referenzstationspunkt_istteilvon ON ax_referenzstationspunkt USING gin (istteilvon);

COMMENT ON TABLE ax_referenzstationspunkt IS 'FeatureType: "AX_Referenzstationspunkt"';
COMMENT ON COLUMN ax_referenzstationspunkt.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_referenzstationspunkt.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_referenzstationspunkt.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_referenzstationspunkt.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_referenzstationspunkt.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_referenzstationspunkt.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_referenzstationspunkt.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_referenzstationspunkt.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_referenzstationspunkt.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_referenzstationspunkt.darstellungshinweis IS 'darstellungshinweis  Boolean 0..1';
COMMENT ON COLUMN ax_referenzstationspunkt.erstvermarkung IS 'erstvermarkung  Date 0..1';
COMMENT ON COLUMN ax_referenzstationspunkt.frueherepunktnummer IS 'frueherePunktnummer  CharacterString 0..*';
COMMENT ON COLUMN ax_referenzstationspunkt.gemarkungsnummer IS 'gemarkung|AX_Gemarkung_Schluessel|gemarkungsnummer  CharacterString 1';
COMMENT ON COLUMN ax_referenzstationspunkt.land IS 'gemarkung|AX_Gemarkung_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_referenzstationspunkt.gemeinde_gemeinde IS 'gemeinde|AX_Gemeindekennzeichen|gemeinde  CharacterString 1';
COMMENT ON COLUMN ax_referenzstationspunkt.gemeinde_gemeindeteil IS 'gemeinde|AX_Gemeindekennzeichen|gemeindeteil  CharacterString 0..1';
COMMENT ON COLUMN ax_referenzstationspunkt.gemeinde_kreis IS 'gemeinde|AX_Gemeindekennzeichen|kreis  CharacterString 1';
COMMENT ON COLUMN ax_referenzstationspunkt.gemeinde_land IS 'gemeinde|AX_Gemeindekennzeichen|land  CharacterString 1';
COMMENT ON COLUMN ax_referenzstationspunkt.gemeinde_regierungsbezirk IS 'gemeinde|AX_Gemeindekennzeichen|regierungsbezirk  CharacterString 0..1';
COMMENT ON COLUMN ax_referenzstationspunkt.internebemerkungen IS 'interneBemerkungen  CharacterString 0..*';
COMMENT ON COLUMN ax_referenzstationspunkt.katasteramt_land IS 'katasteramt|AX_Dienststelle_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_referenzstationspunkt.katasteramt_stelle IS 'katasteramt|AX_Dienststelle_Schluessel|stelle  CharacterString 1';
COMMENT ON COLUMN ax_referenzstationspunkt.land_land IS 'land|AX_Bundesland_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_referenzstationspunkt.namelagebeschreibung IS 'nameLagebeschreibung  CharacterString 0..1';
COMMENT ON COLUMN ax_referenzstationspunkt.nutzerspezifischebemerkungen IS 'nutzerspezifischeBemerkungen  CharacterString 0..*';
COMMENT ON COLUMN ax_referenzstationspunkt.nutzungextern IS 'nutzungExtern  Boolean 1';
COMMENT ON COLUMN ax_referenzstationspunkt.punktkennung IS 'punktkennung  CharacterString 1';
COMMENT ON COLUMN ax_referenzstationspunkt.punktvermarkung IS 'punktvermarkung enumeration AX_Marke 1';
COMMENT ON COLUMN ax_referenzstationspunkt.relativehoehe IS 'relativeHoehe  Length 0..1';
COMMENT ON COLUMN ax_referenzstationspunkt.untergangsdatum IS 'untergangsdatum  Date 0..1';
COMMENT ON COLUMN ax_referenzstationspunkt.vermarkungsdatum IS 'vermarkungsdatum  Date 0..1';
COMMENT ON COLUMN ax_referenzstationspunkt.funktion IS 'funktion enumeration AX_Funktion_Referenzstationspunkt 0..1';
COMMENT ON COLUMN ax_referenzstationspunkt.befund IS 'qualitaetsangaben|AX_DQFestpunkt|befund  CharacterString 0..1';
COMMENT ON COLUMN ax_referenzstationspunkt.gnsstauglichkeit IS 'qualitaetsangaben|AX_DQFestpunkt|gnssTauglichkeit enumeration AX_GNSSTauglichkeit 0..1';
COMMENT ON COLUMN ax_referenzstationspunkt.punktstabilitaet IS 'qualitaetsangaben|AX_DQFestpunkt|punktstabilitaet enumeration AX_Punktstabilitaet 0..1';
COMMENT ON COLUMN ax_referenzstationspunkt.ueberwachungsdatum IS 'qualitaetsangaben|AX_DQFestpunkt|ueberwachungsdatum  Date 0..1';
COMMENT ON COLUMN ax_referenzstationspunkt.istidentischmitlfp IS 'Assoziation zu: FeatureType AX_Lagefestpunkt (ax_lagefestpunkt) 0..1';
COMMENT ON COLUMN ax_referenzstationspunkt.istidentischmithfp IS 'Assoziation zu: FeatureType AX_Hoehenfestpunkt (ax_hoehenfestpunkt) 0..1';
CREATE TABLE ax_lagefestpunkt (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  darstellungshinweis character varying,
  erstvermarkung date,
  frueherepunktnummer character varying[],
  gemarkungsnummer character varying,
  land character varying,
  gemeinde_gemeinde character varying NOT NULL,
  gemeinde_gemeindeteil character varying,
  gemeinde_kreis character varying NOT NULL,
  gemeinde_land character varying NOT NULL,
  gemeinde_regierungsbezirk character varying,
  internebemerkungen character varying[],
  katasteramt_land character varying,
  katasteramt_stelle character varying,
  land_land character varying NOT NULL,
  namelagebeschreibung character varying,
  nutzerspezifischebemerkungen character varying[],
  nutzungextern character varying NOT NULL,
  punktkennung character varying NOT NULL,
  punktvermarkung integer NOT NULL,
  relativehoehe double precision,
  untergangsdatum date,
  vermarkungsdatum date,
  funktion integer,
  hierarchiestufe3d integer,
  ordnung integer,
  wertigkeit integer,
  abstand double precision,
  messung date,
  befund character varying,
  gnsstauglichkeit integer,
  punktstabilitaet integer,
  ueberwachungsdatum date,
  bestehtaus character(16)[],
  istteilvon character(16)[],
  istidentischmitrsp character(16),
  istexzentrumzu character(16),
  istzentrumzu character(16)[],
  istidentischmitsfp character(16),
  unterschiedlicherbezugspunktmitsfp character(16),
  unterschiedlicherbezugspunktmithfp character(16),
  istidentischmithfp character(16),
  istidentischmitsvp character(16),
  unterschiedlicherbezugspunktmitsvp character(16),
  unterschiedlicherbezugspunktmitap character(16),
  istidentischmitap character(16),
  unterschiedlicherbezugspunktmitgrenzpunkt character(16),
  istidentischmitgrenzpunkt character(16),
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_lagefestpunkt_gml ON ax_lagefestpunkt USING btree (gml_id,beginnt);
CREATE INDEX ax_lagefestpunkt_endet ON ax_lagefestpunkt USING btree (endet);
CREATE INDEX ax_lagefestpunkt_istidentischmitrsp ON ax_lagefestpunkt USING btree (istidentischmitrsp);
CREATE INDEX ax_lagefestpunkt_istexzentrumzu ON ax_lagefestpunkt USING btree (istexzentrumzu);
CREATE INDEX ax_lagefestpunkt_istzentrumzu ON ax_lagefestpunkt USING gin (istzentrumzu);
CREATE INDEX ax_lagefestpunkt_istidentischmitsfp ON ax_lagefestpunkt USING btree (istidentischmitsfp);
CREATE INDEX ax_lagefestpunkt_unterschiedlicherbezugspunktmitsfp ON ax_lagefestpunkt USING btree (unterschiedlicherbezugspunktmitsfp);
CREATE INDEX ax_lagefestpunkt_unterschiedlicherbezugspunktmithfp ON ax_lagefestpunkt USING btree (unterschiedlicherbezugspunktmithfp);
CREATE INDEX ax_lagefestpunkt_istidentischmithfp ON ax_lagefestpunkt USING btree (istidentischmithfp);
CREATE INDEX ax_lagefestpunkt_istidentischmitsvp ON ax_lagefestpunkt USING btree (istidentischmitsvp);
CREATE INDEX ax_lagefestpunkt_unterschiedlicherbezugspunktmitsvp ON ax_lagefestpunkt USING btree (unterschiedlicherbezugspunktmitsvp);
CREATE INDEX ax_lagefestpunkt_unterschiedlicherbezugspunktmitap ON ax_lagefestpunkt USING btree (unterschiedlicherbezugspunktmitap);
CREATE INDEX ax_lagefestpunkt_istidentischmitap ON ax_lagefestpunkt USING btree (istidentischmitap);
CREATE INDEX ax_lagefestpunkt_unterschiedlicherbezugspunktmitgrenzpunkt ON ax_lagefestpunkt USING btree (unterschiedlicherbezugspunktmitgrenzpunkt);
CREATE INDEX ax_lagefestpunkt_istidentischmitgrenzpunkt ON ax_lagefestpunkt USING btree (istidentischmitgrenzpunkt);
CREATE INDEX ax_lagefestpunkt_bestehtaus ON ax_lagefestpunkt USING gin (bestehtaus);
CREATE INDEX ax_lagefestpunkt_istteilvon ON ax_lagefestpunkt USING gin (istteilvon);

COMMENT ON TABLE ax_lagefestpunkt IS 'FeatureType: "AX_Lagefestpunkt"';
COMMENT ON COLUMN ax_lagefestpunkt.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_lagefestpunkt.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_lagefestpunkt.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_lagefestpunkt.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.darstellungshinweis IS 'darstellungshinweis  Boolean 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.erstvermarkung IS 'erstvermarkung  Date 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.frueherepunktnummer IS 'frueherePunktnummer  CharacterString 0..*';
COMMENT ON COLUMN ax_lagefestpunkt.gemarkungsnummer IS 'gemarkung|AX_Gemarkung_Schluessel|gemarkungsnummer  CharacterString 1';
COMMENT ON COLUMN ax_lagefestpunkt.land IS 'gemarkung|AX_Gemarkung_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_lagefestpunkt.gemeinde_gemeinde IS 'gemeinde|AX_Gemeindekennzeichen|gemeinde  CharacterString 1';
COMMENT ON COLUMN ax_lagefestpunkt.gemeinde_gemeindeteil IS 'gemeinde|AX_Gemeindekennzeichen|gemeindeteil  CharacterString 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.gemeinde_kreis IS 'gemeinde|AX_Gemeindekennzeichen|kreis  CharacterString 1';
COMMENT ON COLUMN ax_lagefestpunkt.gemeinde_land IS 'gemeinde|AX_Gemeindekennzeichen|land  CharacterString 1';
COMMENT ON COLUMN ax_lagefestpunkt.gemeinde_regierungsbezirk IS 'gemeinde|AX_Gemeindekennzeichen|regierungsbezirk  CharacterString 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.internebemerkungen IS 'interneBemerkungen  CharacterString 0..*';
COMMENT ON COLUMN ax_lagefestpunkt.katasteramt_land IS 'katasteramt|AX_Dienststelle_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_lagefestpunkt.katasteramt_stelle IS 'katasteramt|AX_Dienststelle_Schluessel|stelle  CharacterString 1';
COMMENT ON COLUMN ax_lagefestpunkt.land_land IS 'land|AX_Bundesland_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_lagefestpunkt.namelagebeschreibung IS 'nameLagebeschreibung  CharacterString 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.nutzerspezifischebemerkungen IS 'nutzerspezifischeBemerkungen  CharacterString 0..*';
COMMENT ON COLUMN ax_lagefestpunkt.nutzungextern IS 'nutzungExtern  Boolean 1';
COMMENT ON COLUMN ax_lagefestpunkt.punktkennung IS 'punktkennung  CharacterString 1';
COMMENT ON COLUMN ax_lagefestpunkt.punktvermarkung IS 'punktvermarkung enumeration AX_Marke 1';
COMMENT ON COLUMN ax_lagefestpunkt.relativehoehe IS 'relativeHoehe  Length 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.untergangsdatum IS 'untergangsdatum  Date 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.vermarkungsdatum IS 'vermarkungsdatum  Date 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.funktion IS 'funktion enumeration AX_Funktion_Lagefestpunkt 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.hierarchiestufe3d IS 'klassifikation|AX_Klassifikation_Lagefestpunkt|hierarchiestufe3D enumeration AX_Klassifikation_Hierarchiestufe3D_Lagefestpunkt 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.ordnung IS 'klassifikation|AX_Klassifikation_Lagefestpunkt|ordnung enumeration AX_Klassifikation_Ordnung_Lagefestpunkt 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.wertigkeit IS 'klassifikation|AX_Klassifikation_Lagefestpunkt|wertigkeit enumeration AX_Klassifikation_Wertigkeit_Lagefestpunkt 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.abstand IS 'pfeilerhoehe|AX_Pfeilerhoehe_Lagefestpunkt|abstand  Length 1';
COMMENT ON COLUMN ax_lagefestpunkt.messung IS 'pfeilerhoehe|AX_Pfeilerhoehe_Lagefestpunkt|messung  Date 1';
COMMENT ON COLUMN ax_lagefestpunkt.befund IS 'qualitaetsangaben|AX_DQFestpunkt|befund  CharacterString 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.gnsstauglichkeit IS 'qualitaetsangaben|AX_DQFestpunkt|gnssTauglichkeit enumeration AX_GNSSTauglichkeit 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.punktstabilitaet IS 'qualitaetsangaben|AX_DQFestpunkt|punktstabilitaet enumeration AX_Punktstabilitaet 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.ueberwachungsdatum IS 'qualitaetsangaben|AX_DQFestpunkt|ueberwachungsdatum  Date 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.istidentischmitrsp IS 'Assoziation zu: FeatureType AX_Referenzstationspunkt (ax_referenzstationspunkt) 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.istexzentrumzu IS 'Assoziation zu: FeatureType AX_Lagefestpunkt (ax_lagefestpunkt) 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.istzentrumzu IS 'Assoziation zu: FeatureType AX_Lagefestpunkt (ax_lagefestpunkt) 0..*';
COMMENT ON COLUMN ax_lagefestpunkt.istidentischmitsfp IS 'Assoziation zu: FeatureType AX_Schwerefestpunkt (ax_schwerefestpunkt) 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.unterschiedlicherbezugspunktmitsfp IS 'Assoziation zu: FeatureType AX_Schwerefestpunkt (ax_schwerefestpunkt) 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.unterschiedlicherbezugspunktmithfp IS 'Assoziation zu: FeatureType AX_Hoehenfestpunkt (ax_hoehenfestpunkt) 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.istidentischmithfp IS 'Assoziation zu: FeatureType AX_Hoehenfestpunkt (ax_hoehenfestpunkt) 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.istidentischmitsvp IS 'Assoziation zu: FeatureType AX_SonstigerVermessungspunkt (ax_sonstigervermessungspunkt) 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.unterschiedlicherbezugspunktmitsvp IS 'Assoziation zu: FeatureType AX_SonstigerVermessungspunkt (ax_sonstigervermessungspunkt) 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.unterschiedlicherbezugspunktmitap IS 'Assoziation zu: FeatureType AX_Aufnahmepunkt (ax_aufnahmepunkt) 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.istidentischmitap IS 'Assoziation zu: FeatureType AX_Aufnahmepunkt (ax_aufnahmepunkt) 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.unterschiedlicherbezugspunktmitgrenzpunkt IS 'Assoziation zu: FeatureType AX_Grenzpunkt (ax_grenzpunkt) 0..1';
COMMENT ON COLUMN ax_lagefestpunkt.istidentischmitgrenzpunkt IS 'Assoziation zu: FeatureType AX_Grenzpunkt (ax_grenzpunkt) 0..1';
CREATE TABLE ax_schwerefestpunkt (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  darstellungshinweis character varying,
  erstvermarkung date,
  frueherepunktnummer character varying[],
  gemarkungsnummer character varying,
  land character varying,
  gemeinde_gemeinde character varying NOT NULL,
  gemeinde_gemeindeteil character varying,
  gemeinde_kreis character varying NOT NULL,
  gemeinde_land character varying NOT NULL,
  gemeinde_regierungsbezirk character varying,
  internebemerkungen character varying[],
  katasteramt_land character varying,
  katasteramt_stelle character varying,
  land_land character varying NOT NULL,
  namelagebeschreibung character varying,
  nutzerspezifischebemerkungen character varying[],
  nutzungextern character varying NOT NULL,
  punktkennung character varying NOT NULL,
  punktvermarkung integer NOT NULL,
  relativehoehe double precision,
  untergangsdatum date,
  vermarkungsdatum date,
  funktion integer,
  ordnung integer,
  befund character varying,
  gnsstauglichkeit integer,
  punktstabilitaet integer,
  ueberwachungsdatum date,
  bestehtaus character(16)[],
  istteilvon character(16)[],
  istidentischmitlfp character(16),
  unterschiedlicherbezugspunktmitlfp character(16),
  istzentrumzu character(16)[],
  istexzentrumzu character(16),
  unterschiedlicherbezugspunktmithfp character(16),
  istidentischmithfp character(16),
  istidentischmitsp character(16),
  istidentischmitsvp character(16),
  istidentischmitap character(16),
  istidentischmitgrenzpunkt character(16),
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_schwerefestpunkt_gml ON ax_schwerefestpunkt USING btree (gml_id,beginnt);
CREATE INDEX ax_schwerefestpunkt_endet ON ax_schwerefestpunkt USING btree (endet);
CREATE INDEX ax_schwerefestpunkt_istidentischmitlfp ON ax_schwerefestpunkt USING btree (istidentischmitlfp);
CREATE INDEX ax_schwerefestpunkt_unterschiedlicherbezugspunktmitlfp ON ax_schwerefestpunkt USING btree (unterschiedlicherbezugspunktmitlfp);
CREATE INDEX ax_schwerefestpunkt_istzentrumzu ON ax_schwerefestpunkt USING gin (istzentrumzu);
CREATE INDEX ax_schwerefestpunkt_istexzentrumzu ON ax_schwerefestpunkt USING btree (istexzentrumzu);
CREATE INDEX ax_schwerefestpunkt_unterschiedlicherbezugspunktmithfp ON ax_schwerefestpunkt USING btree (unterschiedlicherbezugspunktmithfp);
CREATE INDEX ax_schwerefestpunkt_istidentischmithfp ON ax_schwerefestpunkt USING btree (istidentischmithfp);
CREATE INDEX ax_schwerefestpunkt_istidentischmitsp ON ax_schwerefestpunkt USING btree (istidentischmitsp);
CREATE INDEX ax_schwerefestpunkt_istidentischmitsvp ON ax_schwerefestpunkt USING btree (istidentischmitsvp);
CREATE INDEX ax_schwerefestpunkt_istidentischmitap ON ax_schwerefestpunkt USING btree (istidentischmitap);
CREATE INDEX ax_schwerefestpunkt_istidentischmitgrenzpunkt ON ax_schwerefestpunkt USING btree (istidentischmitgrenzpunkt);
CREATE INDEX ax_schwerefestpunkt_bestehtaus ON ax_schwerefestpunkt USING gin (bestehtaus);
CREATE INDEX ax_schwerefestpunkt_istteilvon ON ax_schwerefestpunkt USING gin (istteilvon);

COMMENT ON TABLE ax_schwerefestpunkt IS 'FeatureType: "AX_Schwerefestpunkt"';
COMMENT ON COLUMN ax_schwerefestpunkt.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_schwerefestpunkt.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_schwerefestpunkt.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_schwerefestpunkt.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_schwerefestpunkt.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_schwerefestpunkt.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_schwerefestpunkt.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_schwerefestpunkt.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_schwerefestpunkt.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_schwerefestpunkt.darstellungshinweis IS 'darstellungshinweis  Boolean 0..1';
COMMENT ON COLUMN ax_schwerefestpunkt.erstvermarkung IS 'erstvermarkung  Date 0..1';
COMMENT ON COLUMN ax_schwerefestpunkt.frueherepunktnummer IS 'frueherePunktnummer  CharacterString 0..*';
COMMENT ON COLUMN ax_schwerefestpunkt.gemarkungsnummer IS 'gemarkung|AX_Gemarkung_Schluessel|gemarkungsnummer  CharacterString 1';
COMMENT ON COLUMN ax_schwerefestpunkt.land IS 'gemarkung|AX_Gemarkung_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_schwerefestpunkt.gemeinde_gemeinde IS 'gemeinde|AX_Gemeindekennzeichen|gemeinde  CharacterString 1';
COMMENT ON COLUMN ax_schwerefestpunkt.gemeinde_gemeindeteil IS 'gemeinde|AX_Gemeindekennzeichen|gemeindeteil  CharacterString 0..1';
COMMENT ON COLUMN ax_schwerefestpunkt.gemeinde_kreis IS 'gemeinde|AX_Gemeindekennzeichen|kreis  CharacterString 1';
COMMENT ON COLUMN ax_schwerefestpunkt.gemeinde_land IS 'gemeinde|AX_Gemeindekennzeichen|land  CharacterString 1';
COMMENT ON COLUMN ax_schwerefestpunkt.gemeinde_regierungsbezirk IS 'gemeinde|AX_Gemeindekennzeichen|regierungsbezirk  CharacterString 0..1';
COMMENT ON COLUMN ax_schwerefestpunkt.internebemerkungen IS 'interneBemerkungen  CharacterString 0..*';
COMMENT ON COLUMN ax_schwerefestpunkt.katasteramt_land IS 'katasteramt|AX_Dienststelle_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_schwerefestpunkt.katasteramt_stelle IS 'katasteramt|AX_Dienststelle_Schluessel|stelle  CharacterString 1';
COMMENT ON COLUMN ax_schwerefestpunkt.land_land IS 'land|AX_Bundesland_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_schwerefestpunkt.namelagebeschreibung IS 'nameLagebeschreibung  CharacterString 0..1';
COMMENT ON COLUMN ax_schwerefestpunkt.nutzerspezifischebemerkungen IS 'nutzerspezifischeBemerkungen  CharacterString 0..*';
COMMENT ON COLUMN ax_schwerefestpunkt.nutzungextern IS 'nutzungExtern  Boolean 1';
COMMENT ON COLUMN ax_schwerefestpunkt.punktkennung IS 'punktkennung  CharacterString 1';
COMMENT ON COLUMN ax_schwerefestpunkt.punktvermarkung IS 'punktvermarkung enumeration AX_Marke 1';
COMMENT ON COLUMN ax_schwerefestpunkt.relativehoehe IS 'relativeHoehe  Length 0..1';
COMMENT ON COLUMN ax_schwerefestpunkt.untergangsdatum IS 'untergangsdatum  Date 0..1';
COMMENT ON COLUMN ax_schwerefestpunkt.vermarkungsdatum IS 'vermarkungsdatum  Date 0..1';
COMMENT ON COLUMN ax_schwerefestpunkt.funktion IS 'funktion enumeration AX_Funktion_Schwerefestpunkt 0..1';
COMMENT ON COLUMN ax_schwerefestpunkt.ordnung IS 'ordnung enumeration AX_Ordnung_Schwerefestpunkt 0..1';
COMMENT ON COLUMN ax_schwerefestpunkt.befund IS 'qualitaetsangaben|AX_DQFestpunkt|befund  CharacterString 0..1';
COMMENT ON COLUMN ax_schwerefestpunkt.gnsstauglichkeit IS 'qualitaetsangaben|AX_DQFestpunkt|gnssTauglichkeit enumeration AX_GNSSTauglichkeit 0..1';
COMMENT ON COLUMN ax_schwerefestpunkt.punktstabilitaet IS 'qualitaetsangaben|AX_DQFestpunkt|punktstabilitaet enumeration AX_Punktstabilitaet 0..1';
COMMENT ON COLUMN ax_schwerefestpunkt.ueberwachungsdatum IS 'qualitaetsangaben|AX_DQFestpunkt|ueberwachungsdatum  Date 0..1';
COMMENT ON COLUMN ax_schwerefestpunkt.istidentischmitlfp IS 'Assoziation zu: FeatureType AX_Lagefestpunkt (ax_lagefestpunkt) 0..1';
COMMENT ON COLUMN ax_schwerefestpunkt.unterschiedlicherbezugspunktmitlfp IS 'Assoziation zu: FeatureType AX_Lagefestpunkt (ax_lagefestpunkt) 0..1';
COMMENT ON COLUMN ax_schwerefestpunkt.istzentrumzu IS 'Assoziation zu: FeatureType AX_Schwerefestpunkt (ax_schwerefestpunkt) 0..*';
COMMENT ON COLUMN ax_schwerefestpunkt.istexzentrumzu IS 'Assoziation zu: FeatureType AX_Schwerefestpunkt (ax_schwerefestpunkt) 0..1';
COMMENT ON COLUMN ax_schwerefestpunkt.unterschiedlicherbezugspunktmithfp IS 'Assoziation zu: FeatureType AX_Hoehenfestpunkt (ax_hoehenfestpunkt) 0..1';
COMMENT ON COLUMN ax_schwerefestpunkt.istidentischmithfp IS 'Assoziation zu: FeatureType AX_Hoehenfestpunkt (ax_hoehenfestpunkt) 0..1';
COMMENT ON COLUMN ax_schwerefestpunkt.istidentischmitsp IS 'Assoziation zu: FeatureType AX_Sicherungspunkt (ax_sicherungspunkt) 0..1';
COMMENT ON COLUMN ax_schwerefestpunkt.istidentischmitsvp IS 'Assoziation zu: FeatureType AX_SonstigerVermessungspunkt (ax_sonstigervermessungspunkt) 0..1';
COMMENT ON COLUMN ax_schwerefestpunkt.istidentischmitap IS 'Assoziation zu: FeatureType AX_Aufnahmepunkt (ax_aufnahmepunkt) 0..1';
COMMENT ON COLUMN ax_schwerefestpunkt.istidentischmitgrenzpunkt IS 'Assoziation zu: FeatureType AX_Grenzpunkt (ax_grenzpunkt) 0..1';
CREATE TABLE ax_hoehenfestpunkt (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  darstellungshinweis character varying,
  erstvermarkung date,
  frueherepunktnummer character varying[],
  gemarkungsnummer character varying,
  land character varying,
  gemeinde_gemeinde character varying NOT NULL,
  gemeinde_gemeindeteil character varying,
  gemeinde_kreis character varying NOT NULL,
  gemeinde_land character varying NOT NULL,
  gemeinde_regierungsbezirk character varying,
  internebemerkungen character varying[],
  katasteramt_land character varying,
  katasteramt_stelle character varying,
  land_land character varying NOT NULL,
  namelagebeschreibung character varying,
  nutzerspezifischebemerkungen character varying[],
  nutzungextern character varying NOT NULL,
  punktkennung character varying NOT NULL,
  punktvermarkung integer NOT NULL,
  relativehoehe double precision,
  untergangsdatum date,
  vermarkungsdatum date,
  nivlinie character varying[],
  ordnung integer,
  befund character varying,
  gnsstauglichkeit integer,
  geologischestabilitaet integer,
  grundwasserschwankung integer,
  grundwasserstand integer,
  guetedesbaugrundes integer,
  guetedesvermarkungstraegers integer,
  hoehenstabilitaetauswiederholungsmessungen integer,
  topographieundumwelteinfluesse integer,
  vermutetehoehenstabilitaet integer,
  ueberwachungsdatum date,
  bestehtaus character(16)[],
  istteilvon character(16)[],
  istidentischmitrsp character(16),
  unterschiedlicherbezugspunktmitlfp character(16),
  istidentischmitlfp character(16),
  unterschiedlicherbezugspunktmitsfp character(16),
  istidentischmitsfp character(16),
  unterschiedlicherbezugspunktmitsp character(16),
  unterschiedlicherbezugspunktmitsvp character(16),
  unterschiedlicherbezugspunktmitap character(16),
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_hoehenfestpunkt_gml ON ax_hoehenfestpunkt USING btree (gml_id,beginnt);
CREATE INDEX ax_hoehenfestpunkt_endet ON ax_hoehenfestpunkt USING btree (endet);
CREATE INDEX ax_hoehenfestpunkt_istidentischmitrsp ON ax_hoehenfestpunkt USING btree (istidentischmitrsp);
CREATE INDEX ax_hoehenfestpunkt_unterschiedlicherbezugspunktmitlfp ON ax_hoehenfestpunkt USING btree (unterschiedlicherbezugspunktmitlfp);
CREATE INDEX ax_hoehenfestpunkt_istidentischmitlfp ON ax_hoehenfestpunkt USING btree (istidentischmitlfp);
CREATE INDEX ax_hoehenfestpunkt_unterschiedlicherbezugspunktmitsfp ON ax_hoehenfestpunkt USING btree (unterschiedlicherbezugspunktmitsfp);
CREATE INDEX ax_hoehenfestpunkt_istidentischmitsfp ON ax_hoehenfestpunkt USING btree (istidentischmitsfp);
CREATE INDEX ax_hoehenfestpunkt_unterschiedlicherbezugspunktmitsp ON ax_hoehenfestpunkt USING btree (unterschiedlicherbezugspunktmitsp);
CREATE INDEX ax_hoehenfestpunkt_unterschiedlicherbezugspunktmitsvp ON ax_hoehenfestpunkt USING btree (unterschiedlicherbezugspunktmitsvp);
CREATE INDEX ax_hoehenfestpunkt_unterschiedlicherbezugspunktmitap ON ax_hoehenfestpunkt USING btree (unterschiedlicherbezugspunktmitap);
CREATE INDEX ax_hoehenfestpunkt_bestehtaus ON ax_hoehenfestpunkt USING gin (bestehtaus);
CREATE INDEX ax_hoehenfestpunkt_istteilvon ON ax_hoehenfestpunkt USING gin (istteilvon);

COMMENT ON TABLE ax_hoehenfestpunkt IS 'FeatureType: "AX_Hoehenfestpunkt"';
COMMENT ON COLUMN ax_hoehenfestpunkt.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_hoehenfestpunkt.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_hoehenfestpunkt.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_hoehenfestpunkt.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.darstellungshinweis IS 'darstellungshinweis  Boolean 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.erstvermarkung IS 'erstvermarkung  Date 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.frueherepunktnummer IS 'frueherePunktnummer  CharacterString 0..*';
COMMENT ON COLUMN ax_hoehenfestpunkt.gemarkungsnummer IS 'gemarkung|AX_Gemarkung_Schluessel|gemarkungsnummer  CharacterString 1';
COMMENT ON COLUMN ax_hoehenfestpunkt.land IS 'gemarkung|AX_Gemarkung_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_hoehenfestpunkt.gemeinde_gemeinde IS 'gemeinde|AX_Gemeindekennzeichen|gemeinde  CharacterString 1';
COMMENT ON COLUMN ax_hoehenfestpunkt.gemeinde_gemeindeteil IS 'gemeinde|AX_Gemeindekennzeichen|gemeindeteil  CharacterString 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.gemeinde_kreis IS 'gemeinde|AX_Gemeindekennzeichen|kreis  CharacterString 1';
COMMENT ON COLUMN ax_hoehenfestpunkt.gemeinde_land IS 'gemeinde|AX_Gemeindekennzeichen|land  CharacterString 1';
COMMENT ON COLUMN ax_hoehenfestpunkt.gemeinde_regierungsbezirk IS 'gemeinde|AX_Gemeindekennzeichen|regierungsbezirk  CharacterString 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.internebemerkungen IS 'interneBemerkungen  CharacterString 0..*';
COMMENT ON COLUMN ax_hoehenfestpunkt.katasteramt_land IS 'katasteramt|AX_Dienststelle_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_hoehenfestpunkt.katasteramt_stelle IS 'katasteramt|AX_Dienststelle_Schluessel|stelle  CharacterString 1';
COMMENT ON COLUMN ax_hoehenfestpunkt.land_land IS 'land|AX_Bundesland_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_hoehenfestpunkt.namelagebeschreibung IS 'nameLagebeschreibung  CharacterString 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.nutzerspezifischebemerkungen IS 'nutzerspezifischeBemerkungen  CharacterString 0..*';
COMMENT ON COLUMN ax_hoehenfestpunkt.nutzungextern IS 'nutzungExtern  Boolean 1';
COMMENT ON COLUMN ax_hoehenfestpunkt.punktkennung IS 'punktkennung  CharacterString 1';
COMMENT ON COLUMN ax_hoehenfestpunkt.punktvermarkung IS 'punktvermarkung enumeration AX_Marke 1';
COMMENT ON COLUMN ax_hoehenfestpunkt.relativehoehe IS 'relativeHoehe  Length 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.untergangsdatum IS 'untergangsdatum  Date 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.vermarkungsdatum IS 'vermarkungsdatum  Date 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.nivlinie IS 'nivlinie  CharacterString 0..*';
COMMENT ON COLUMN ax_hoehenfestpunkt.ordnung IS 'ordnung enumeration AX_Ordnung_Hoehenfestpunkt 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.befund IS 'qualitaetsangaben|AX_DQHoehenfestpunkt|befund  CharacterString 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.gnsstauglichkeit IS 'qualitaetsangaben|AX_DQHoehenfestpunkt|gnssTauglichkeit enumeration AX_GNSSTauglichkeit 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.geologischestabilitaet IS 'qualitaetsangaben|AX_DQHoehenfestpunkt|punktstabilitaet|AX_Punktstabilitaet_Hoehenfestpunkt|geologischeStabilitaet enumeration AX_Punktstabilitaet_Hoehenfestpunkt_GeologischeStabilitaet 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.grundwasserschwankung IS 'qualitaetsangaben|AX_DQHoehenfestpunkt|punktstabilitaet|AX_Punktstabilitaet_Hoehenfestpunkt|grundwasserschwankung enumeration AX_Punktstabilitaet_Hoehenfestpunkt_Grundwasserschwankung 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.grundwasserstand IS 'qualitaetsangaben|AX_DQHoehenfestpunkt|punktstabilitaet|AX_Punktstabilitaet_Hoehenfestpunkt|grundwasserstand enumeration AX_Punktstabilitaet_Hoehenfestpunkt_Grundwasserstand 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.guetedesbaugrundes IS 'qualitaetsangaben|AX_DQHoehenfestpunkt|punktstabilitaet|AX_Punktstabilitaet_Hoehenfestpunkt|gueteDesBaugrundes enumeration AX_Punktstabilitaet_Hoehenfestpunkt_GueteDesBaugrundes 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.guetedesvermarkungstraegers IS 'qualitaetsangaben|AX_DQHoehenfestpunkt|punktstabilitaet|AX_Punktstabilitaet_Hoehenfestpunkt|gueteDesVermarkungstraegers enumeration AX_Punktstabilitaet_Hoehenfestpunkt_GueteDesVermarkungstraegers 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.hoehenstabilitaetauswiederholungsmessungen IS 'qualitaetsangaben|AX_DQHoehenfestpunkt|punktstabilitaet|AX_Punktstabilitaet_Hoehenfestpunkt|hoehenstabilitaetAusWiederholungsmessungen enumeration AX_Punktstabilitaet_Hoehenfestpunkt_HoehenstabilitaetAusWiederholung 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.topographieundumwelteinfluesse IS 'qualitaetsangaben|AX_DQHoehenfestpunkt|punktstabilitaet|AX_Punktstabilitaet_Hoehenfestpunkt|topographieUndUmwelteinfluesse enumeration AX_Punktstabilitaet_Hoehenfestpunkt_TopographieUndUmwelt 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.vermutetehoehenstabilitaet IS 'qualitaetsangaben|AX_DQHoehenfestpunkt|punktstabilitaet|AX_Punktstabilitaet_Hoehenfestpunkt|vermuteteHoehenstabilitaet enumeration AX_Punktstabilitaet_Hoehenfestpunkt_VermuteteHoehenstabilitaet 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.ueberwachungsdatum IS 'qualitaetsangaben|AX_DQHoehenfestpunkt|ueberwachungsdatum  Date 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.istidentischmitrsp IS 'Assoziation zu: FeatureType AX_Referenzstationspunkt (ax_referenzstationspunkt) 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.unterschiedlicherbezugspunktmitlfp IS 'Assoziation zu: FeatureType AX_Lagefestpunkt (ax_lagefestpunkt) 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.istidentischmitlfp IS 'Assoziation zu: FeatureType AX_Lagefestpunkt (ax_lagefestpunkt) 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.unterschiedlicherbezugspunktmitsfp IS 'Assoziation zu: FeatureType AX_Schwerefestpunkt (ax_schwerefestpunkt) 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.istidentischmitsfp IS 'Assoziation zu: FeatureType AX_Schwerefestpunkt (ax_schwerefestpunkt) 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.unterschiedlicherbezugspunktmitsp IS 'Assoziation zu: FeatureType AX_Sicherungspunkt (ax_sicherungspunkt) 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.unterschiedlicherbezugspunktmitsvp IS 'Assoziation zu: FeatureType AX_SonstigerVermessungspunkt (ax_sonstigervermessungspunkt) 0..1';
COMMENT ON COLUMN ax_hoehenfestpunkt.unterschiedlicherbezugspunktmitap IS 'Assoziation zu: FeatureType AX_Aufnahmepunkt (ax_aufnahmepunkt) 0..1';
CREATE TABLE ax_sicherungspunkt (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  horizontfreiheit integer,
  punktkennung character varying,
  relativehoehe double precision,
  sonstigeeigenschaft character varying[],
  vermarkung_marke integer NOT NULL,
  zustaendigestelle_land character varying,
  zustaendigestelle_stelle character varying,
  bestehtaus character(16)[],
  istteilvon character(16)[],
  hat character(16)[],
  beziehtsichauf character(16),
  gehoertzu character(16),
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_sicherungspunkt_gml ON ax_sicherungspunkt USING btree (gml_id,beginnt);
CREATE INDEX ax_sicherungspunkt_endet ON ax_sicherungspunkt USING btree (endet);
CREATE INDEX ax_sicherungspunkt_hat ON ax_sicherungspunkt USING gin (hat);
CREATE INDEX ax_sicherungspunkt_beziehtsichauf ON ax_sicherungspunkt USING btree (beziehtsichauf);
CREATE INDEX ax_sicherungspunkt_gehoertzu ON ax_sicherungspunkt USING btree (gehoertzu);
CREATE INDEX ax_sicherungspunkt_bestehtaus ON ax_sicherungspunkt USING gin (bestehtaus);
CREATE INDEX ax_sicherungspunkt_istteilvon ON ax_sicherungspunkt USING gin (istteilvon);

COMMENT ON TABLE ax_sicherungspunkt IS 'FeatureType: "AX_Sicherungspunkt"';
COMMENT ON COLUMN ax_sicherungspunkt.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_sicherungspunkt.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_sicherungspunkt.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_sicherungspunkt.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_sicherungspunkt.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_sicherungspunkt.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_sicherungspunkt.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_sicherungspunkt.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_sicherungspunkt.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_sicherungspunkt.horizontfreiheit IS 'horizontfreiheit enumeration AX_Horizontfreiheit_Netzpunkt 0..1';
COMMENT ON COLUMN ax_sicherungspunkt.punktkennung IS 'punktkennung  CharacterString 0..1';
COMMENT ON COLUMN ax_sicherungspunkt.relativehoehe IS 'relativeHoehe  Length 0..1';
COMMENT ON COLUMN ax_sicherungspunkt.sonstigeeigenschaft IS 'sonstigeEigenschaft  CharacterString 0..*';
COMMENT ON COLUMN ax_sicherungspunkt.vermarkung_marke IS 'vermarkung_Marke enumeration AX_Marke 1';
COMMENT ON COLUMN ax_sicherungspunkt.zustaendigestelle_land IS 'zustaendigeStelle|AX_Dienststelle_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_sicherungspunkt.zustaendigestelle_stelle IS 'zustaendigeStelle|AX_Dienststelle_Schluessel|stelle  CharacterString 1';
COMMENT ON COLUMN ax_sicherungspunkt.hat IS 'Assoziation zu: FeatureType AX_Schwerefestpunkt (ax_schwerefestpunkt) 0..*';
COMMENT ON COLUMN ax_sicherungspunkt.beziehtsichauf IS 'Assoziation zu: FeatureType AX_SonstigerVermessungspunkt (ax_sonstigervermessungspunkt) 0..1';
COMMENT ON COLUMN ax_sicherungspunkt.gehoertzu IS 'Assoziation zu: FeatureType AX_Aufnahmepunkt (ax_aufnahmepunkt) 0..1';
CREATE TABLE ax_sonstigervermessungspunkt (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  horizontfreiheit integer,
  punktkennung character varying,
  relativehoehe double precision,
  sonstigeeigenschaft character varying[],
  vermarkung_marke integer NOT NULL,
  zustaendigestelle_land character varying,
  zustaendigestelle_stelle character varying,
  art character varying,
  bestehtaus character(16)[],
  istteilvon character(16)[],
  verbundenmit character(16)[],
  beziehtsichauf character(16)[],
  gehoertzu character(16)[],
  mit character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_sonstigervermessungspunkt_gml ON ax_sonstigervermessungspunkt USING btree (gml_id,beginnt);
CREATE INDEX ax_sonstigervermessungspunkt_endet ON ax_sonstigervermessungspunkt USING btree (endet);
CREATE INDEX ax_sonstigervermessungspunkt_verbundenmit ON ax_sonstigervermessungspunkt USING gin (verbundenmit);
CREATE INDEX ax_sonstigervermessungspunkt_beziehtsichauf ON ax_sonstigervermessungspunkt USING gin (beziehtsichauf);
CREATE INDEX ax_sonstigervermessungspunkt_gehoertzu ON ax_sonstigervermessungspunkt USING gin (gehoertzu);
CREATE INDEX ax_sonstigervermessungspunkt_mit ON ax_sonstigervermessungspunkt USING gin (mit);
CREATE INDEX ax_sonstigervermessungspunkt_bestehtaus ON ax_sonstigervermessungspunkt USING gin (bestehtaus);
CREATE INDEX ax_sonstigervermessungspunkt_istteilvon ON ax_sonstigervermessungspunkt USING gin (istteilvon);

COMMENT ON TABLE ax_sonstigervermessungspunkt IS 'FeatureType: "AX_SonstigerVermessungspunkt"';
COMMENT ON COLUMN ax_sonstigervermessungspunkt.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_sonstigervermessungspunkt.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_sonstigervermessungspunkt.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_sonstigervermessungspunkt.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_sonstigervermessungspunkt.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_sonstigervermessungspunkt.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_sonstigervermessungspunkt.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_sonstigervermessungspunkt.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_sonstigervermessungspunkt.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_sonstigervermessungspunkt.horizontfreiheit IS 'horizontfreiheit enumeration AX_Horizontfreiheit_Netzpunkt 0..1';
COMMENT ON COLUMN ax_sonstigervermessungspunkt.punktkennung IS 'punktkennung  CharacterString 0..1';
COMMENT ON COLUMN ax_sonstigervermessungspunkt.relativehoehe IS 'relativeHoehe  Length 0..1';
COMMENT ON COLUMN ax_sonstigervermessungspunkt.sonstigeeigenschaft IS 'sonstigeEigenschaft  CharacterString 0..*';
COMMENT ON COLUMN ax_sonstigervermessungspunkt.vermarkung_marke IS 'vermarkung_Marke enumeration AX_Marke 1';
COMMENT ON COLUMN ax_sonstigervermessungspunkt.zustaendigestelle_land IS 'zustaendigeStelle|AX_Dienststelle_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_sonstigervermessungspunkt.zustaendigestelle_stelle IS 'zustaendigeStelle|AX_Dienststelle_Schluessel|stelle  CharacterString 1';
COMMENT ON COLUMN ax_sonstigervermessungspunkt.art IS 'art  CharacterString 0..1';
COMMENT ON COLUMN ax_sonstigervermessungspunkt.verbundenmit IS 'Assoziation zu: FeatureType AX_Lagefestpunkt (ax_lagefestpunkt) 0..*';
COMMENT ON COLUMN ax_sonstigervermessungspunkt.beziehtsichauf IS 'Assoziation zu: FeatureType AX_Lagefestpunkt (ax_lagefestpunkt) 0..*';
COMMENT ON COLUMN ax_sonstigervermessungspunkt.gehoertzu IS 'Assoziation zu: FeatureType AX_Schwerefestpunkt (ax_schwerefestpunkt) 0..*';
COMMENT ON COLUMN ax_sonstigervermessungspunkt.mit IS 'Assoziation zu: FeatureType AX_Sicherungspunkt (ax_sicherungspunkt) 0..*';
CREATE TABLE ax_aufnahmepunkt (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  horizontfreiheit integer,
  punktkennung character varying,
  relativehoehe double precision,
  sonstigeeigenschaft character varying[],
  vermarkung_marke integer NOT NULL,
  zustaendigestelle_land character varying,
  zustaendigestelle_stelle character varying,
  bestehtaus character(16)[],
  istteilvon character(16)[],
  beziehtsichauf character(16)[],
  gehoertzu character(16)[],
  hatidentitaet character(16)[],
  haengtan character(16)[],
  hat character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_aufnahmepunkt_gml ON ax_aufnahmepunkt USING btree (gml_id,beginnt);
CREATE INDEX ax_aufnahmepunkt_endet ON ax_aufnahmepunkt USING btree (endet);
CREATE INDEX ax_aufnahmepunkt_beziehtsichauf ON ax_aufnahmepunkt USING gin (beziehtsichauf);
CREATE INDEX ax_aufnahmepunkt_gehoertzu ON ax_aufnahmepunkt USING gin (gehoertzu);
CREATE INDEX ax_aufnahmepunkt_hatidentitaet ON ax_aufnahmepunkt USING gin (hatidentitaet);
CREATE INDEX ax_aufnahmepunkt_haengtan ON ax_aufnahmepunkt USING gin (haengtan);
CREATE INDEX ax_aufnahmepunkt_hat ON ax_aufnahmepunkt USING gin (hat);
CREATE INDEX ax_aufnahmepunkt_bestehtaus ON ax_aufnahmepunkt USING gin (bestehtaus);
CREATE INDEX ax_aufnahmepunkt_istteilvon ON ax_aufnahmepunkt USING gin (istteilvon);

COMMENT ON TABLE ax_aufnahmepunkt IS 'FeatureType: "AX_Aufnahmepunkt"';
COMMENT ON COLUMN ax_aufnahmepunkt.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_aufnahmepunkt.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_aufnahmepunkt.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_aufnahmepunkt.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_aufnahmepunkt.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_aufnahmepunkt.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_aufnahmepunkt.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_aufnahmepunkt.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_aufnahmepunkt.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_aufnahmepunkt.horizontfreiheit IS 'horizontfreiheit enumeration AX_Horizontfreiheit_Netzpunkt 0..1';
COMMENT ON COLUMN ax_aufnahmepunkt.punktkennung IS 'punktkennung  CharacterString 0..1';
COMMENT ON COLUMN ax_aufnahmepunkt.relativehoehe IS 'relativeHoehe  Length 0..1';
COMMENT ON COLUMN ax_aufnahmepunkt.sonstigeeigenschaft IS 'sonstigeEigenschaft  CharacterString 0..*';
COMMENT ON COLUMN ax_aufnahmepunkt.vermarkung_marke IS 'vermarkung_Marke enumeration AX_Marke 1';
COMMENT ON COLUMN ax_aufnahmepunkt.zustaendigestelle_land IS 'zustaendigeStelle|AX_Dienststelle_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_aufnahmepunkt.zustaendigestelle_stelle IS 'zustaendigeStelle|AX_Dienststelle_Schluessel|stelle  CharacterString 1';
COMMENT ON COLUMN ax_aufnahmepunkt.beziehtsichauf IS 'Assoziation zu: FeatureType AX_Lagefestpunkt (ax_lagefestpunkt) 0..*';
COMMENT ON COLUMN ax_aufnahmepunkt.gehoertzu IS 'Assoziation zu: FeatureType AX_Lagefestpunkt (ax_lagefestpunkt) 0..*';
COMMENT ON COLUMN ax_aufnahmepunkt.hatidentitaet IS 'Assoziation zu: FeatureType AX_Schwerefestpunkt (ax_schwerefestpunkt) 0..*';
COMMENT ON COLUMN ax_aufnahmepunkt.haengtan IS 'Assoziation zu: FeatureType AX_Hoehenfestpunkt (ax_hoehenfestpunkt) 0..*';
COMMENT ON COLUMN ax_aufnahmepunkt.hat IS 'Assoziation zu: FeatureType AX_Sicherungspunkt (ax_sicherungspunkt) 0..*';
CREATE TABLE ax_grenzpunkt (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  abmarkung_marke integer NOT NULL,
  ausgesetzteabmarkung_land character varying,
  ausgesetzteabmarkung_stelle character varying,
  bemerkungzurabmarkung integer,
  besonderepunktnummer character varying,
  festgestelltergrenzpunkt character varying,
  gruendederausgesetztenabmarkung integer,
  horizontfreiheit integer,
  punktkennung character varying,
  relativehoehe double precision,
  sonstigeeigenschaft character varying[],
  zeitpunktderentstehung character varying,
  zustaendigestelle_land character varying,
  zustaendigestelle_stelle character varying,
  zwischenmarke character varying,
  bestehtaus character(16)[],
  istteilvon character(16)[],
  gehoertzulfp character(16)[],
  beziehtsichaufsfp character(16)[],
  zeigtauf character(16),
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_grenzpunkt_gml ON ax_grenzpunkt USING btree (gml_id,beginnt);
CREATE INDEX ax_grenzpunkt_endet ON ax_grenzpunkt USING btree (endet);
CREATE INDEX ax_grenzpunkt_gehoertzulfp ON ax_grenzpunkt USING gin (gehoertzulfp);
CREATE INDEX ax_grenzpunkt_beziehtsichaufsfp ON ax_grenzpunkt USING gin (beziehtsichaufsfp);
CREATE INDEX ax_grenzpunkt_zeigtauf ON ax_grenzpunkt USING btree (zeigtauf);
CREATE INDEX ax_grenzpunkt_bestehtaus ON ax_grenzpunkt USING gin (bestehtaus);
CREATE INDEX ax_grenzpunkt_istteilvon ON ax_grenzpunkt USING gin (istteilvon);

COMMENT ON TABLE ax_grenzpunkt IS 'FeatureType: "AX_Grenzpunkt"';
COMMENT ON COLUMN ax_grenzpunkt.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_grenzpunkt.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_grenzpunkt.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_grenzpunkt.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_grenzpunkt.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_grenzpunkt.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_grenzpunkt.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_grenzpunkt.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_grenzpunkt.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_grenzpunkt.abmarkung_marke IS 'abmarkung_Marke enumeration AX_Marke 1';
COMMENT ON COLUMN ax_grenzpunkt.ausgesetzteabmarkung_land IS 'ausgesetzteAbmarkung|AX_Dienststelle_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_grenzpunkt.ausgesetzteabmarkung_stelle IS 'ausgesetzteAbmarkung|AX_Dienststelle_Schluessel|stelle  CharacterString 1';
COMMENT ON COLUMN ax_grenzpunkt.bemerkungzurabmarkung IS 'bemerkungZurAbmarkung enumeration AX_BemerkungZurAbmarkung_Grenzpunkt 0..1';
COMMENT ON COLUMN ax_grenzpunkt.besonderepunktnummer IS 'besonderePunktnummer  CharacterString 0..1';
COMMENT ON COLUMN ax_grenzpunkt.festgestelltergrenzpunkt IS 'festgestellterGrenzpunkt  Boolean 0..1';
COMMENT ON COLUMN ax_grenzpunkt.gruendederausgesetztenabmarkung IS 'gruendeDerAusgesetztenAbmarkung enumeration AX_GruendeDerAusgesetztenAbmarkung_Grenzpunkt 0..1';
COMMENT ON COLUMN ax_grenzpunkt.horizontfreiheit IS 'horizontfreiheit enumeration AX_Horizontfreiheit_Grenzpunkt 0..1';
COMMENT ON COLUMN ax_grenzpunkt.punktkennung IS 'punktkennung  CharacterString 0..1';
COMMENT ON COLUMN ax_grenzpunkt.relativehoehe IS 'relativeHoehe  Length 0..1';
COMMENT ON COLUMN ax_grenzpunkt.sonstigeeigenschaft IS 'sonstigeEigenschaft  CharacterString 0..*';
COMMENT ON COLUMN ax_grenzpunkt.zeitpunktderentstehung IS 'zeitpunktDerEntstehung  CharacterString 0..1';
COMMENT ON COLUMN ax_grenzpunkt.zustaendigestelle_land IS 'zustaendigeStelle|AX_Dienststelle_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_grenzpunkt.zustaendigestelle_stelle IS 'zustaendigeStelle|AX_Dienststelle_Schluessel|stelle  CharacterString 1';
COMMENT ON COLUMN ax_grenzpunkt.zwischenmarke IS 'zwischenmarke  Boolean 0..1';
COMMENT ON COLUMN ax_grenzpunkt.gehoertzulfp IS 'Assoziation zu: FeatureType AX_Lagefestpunkt (ax_lagefestpunkt) 0..*';
COMMENT ON COLUMN ax_grenzpunkt.beziehtsichaufsfp IS 'Assoziation zu: FeatureType AX_Schwerefestpunkt (ax_schwerefestpunkt) 0..*';
COMMENT ON COLUMN ax_grenzpunkt.zeigtauf IS 'Assoziation zu: FeatureType AX_Grenzpunkt (ax_grenzpunkt) 0..1';
CREATE TABLE ax_besonderergebaeudepunkt (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  art integer,
  hoehe double precision[],
  obererbezugspunkt integer[],
  untererbezugspunkt integer[],
  punktkennung character varying,
  sonstigeeigenschaft character varying[],
  zustaendigestelle_land character varying,
  zustaendigestelle_stelle character varying,
  bestehtaus character(16)[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_besonderergebaeudepunkt_gml ON ax_besonderergebaeudepunkt USING btree (gml_id,beginnt);
CREATE INDEX ax_besonderergebaeudepunkt_endet ON ax_besonderergebaeudepunkt USING btree (endet);
CREATE INDEX ax_besonderergebaeudepunkt_bestehtaus ON ax_besonderergebaeudepunkt USING gin (bestehtaus);
CREATE INDEX ax_besonderergebaeudepunkt_istteilvon ON ax_besonderergebaeudepunkt USING gin (istteilvon);

COMMENT ON TABLE ax_besonderergebaeudepunkt IS 'FeatureType: "AX_BesondererGebaeudepunkt"';
COMMENT ON COLUMN ax_besonderergebaeudepunkt.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_besonderergebaeudepunkt.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_besonderergebaeudepunkt.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_besonderergebaeudepunkt.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_besonderergebaeudepunkt.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_besonderergebaeudepunkt.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_besonderergebaeudepunkt.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_besonderergebaeudepunkt.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_besonderergebaeudepunkt.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_besonderergebaeudepunkt.art IS 'art enumeration AX_Art_Gebaeudepunkt 0..1';
COMMENT ON COLUMN ax_besonderergebaeudepunkt.hoehe IS 'objekthoehe|AX_RelativeHoehe|hoehe  Length 1';
COMMENT ON COLUMN ax_besonderergebaeudepunkt.obererbezugspunkt IS 'objekthoehe|AX_RelativeHoehe|obererBezugspunkt enumeration AX_ObererBezugspunkt 0..1';
COMMENT ON COLUMN ax_besonderergebaeudepunkt.untererbezugspunkt IS 'objekthoehe|AX_RelativeHoehe|untererBezugspunkt enumeration AX_UntererBezugspunkt 0..1';
COMMENT ON COLUMN ax_besonderergebaeudepunkt.punktkennung IS 'punktkennung  CharacterString 0..1';
COMMENT ON COLUMN ax_besonderergebaeudepunkt.sonstigeeigenschaft IS 'sonstigeEigenschaft  CharacterString 0..*';
COMMENT ON COLUMN ax_besonderergebaeudepunkt.zustaendigestelle_land IS 'zustaendigeStelle|AX_Dienststelle_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_besonderergebaeudepunkt.zustaendigestelle_stelle IS 'zustaendigeStelle|AX_Dienststelle_Schluessel|stelle  CharacterString 1';
CREATE TABLE ax_wirtschaftlicheeinheit (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  bestehtaus character(16)[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_wirtschaftlicheeinheit_gml ON ax_wirtschaftlicheeinheit USING btree (gml_id,beginnt);
CREATE INDEX ax_wirtschaftlicheeinheit_endet ON ax_wirtschaftlicheeinheit USING btree (endet);
CREATE INDEX ax_wirtschaftlicheeinheit_bestehtaus ON ax_wirtschaftlicheeinheit USING gin (bestehtaus);
CREATE INDEX ax_wirtschaftlicheeinheit_istteilvon ON ax_wirtschaftlicheeinheit USING gin (istteilvon);

COMMENT ON TABLE ax_wirtschaftlicheeinheit IS 'FeatureType: "AX_WirtschaftlicheEinheit"';
COMMENT ON COLUMN ax_wirtschaftlicheeinheit.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_wirtschaftlicheeinheit.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_wirtschaftlicheeinheit.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_wirtschaftlicheeinheit.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_wirtschaftlicheeinheit.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_wirtschaftlicheeinheit.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_wirtschaftlicheeinheit.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_wirtschaftlicheeinheit.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_wirtschaftlicheeinheit.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
CREATE TABLE ax_schutzgebietnachwasserrecht (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  artderfestlegung integer NOT NULL,
  land character varying,
  stelle character varying,
  funktion integer,
  name character varying,
  nummerdesschutzgebietes character varying,
  statement character varying,
  processstep_ax_li_processstep_mitdatenerhebung_description character varying[],
  processstep_rationale character varying[],
  processstep_datetime character(20)[],
  processstep_individualname character varying[],
  processstep_organisationname character varying[],
  processstep_positionname character varying[],
  processstep_phone character varying[],
  processstep_address character varying[],
  processstep_onlineresource character varying[],
  processstep_hoursofservice character varying[],
  processstep_contactinstructions character varying[],
  processstep_role character varying[],
  processstep_ax_datenerhebung character varying[],
  processstep_scaledenominator character varying[],
  processstep_sourcereferencesystem character varying[],
  processstep_sourceextent character varying[],
  processstep_sourcestep character varying[],
  herkunft_source_source_ax_datenerhebung character varying[],
  herkunft_source_source_scaledenominator character varying[],
  herkunft_source_source_sourcereferencesystem character varying[],
  herkunft_source_source_sourceextent character varying[],
  herkunft_source_source_sourcestep character varying[],
  bestehtaus character(16)[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_schutzgebietnachwasserrecht_gml ON ax_schutzgebietnachwasserrecht USING btree (gml_id,beginnt);
CREATE INDEX ax_schutzgebietnachwasserrecht_endet ON ax_schutzgebietnachwasserrecht USING btree (endet);
CREATE INDEX ax_schutzgebietnachwasserrecht_bestehtaus ON ax_schutzgebietnachwasserrecht USING gin (bestehtaus);
CREATE INDEX ax_schutzgebietnachwasserrecht_istteilvon ON ax_schutzgebietnachwasserrecht USING gin (istteilvon);

COMMENT ON TABLE ax_schutzgebietnachwasserrecht IS 'FeatureType: "AX_SchutzgebietNachWasserrecht"';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.artderfestlegung IS 'artDerFestlegung enumeration AX_ArtDerFestlegung_SchutzgebietNachWasserrecht 1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.land IS 'ausfuehrendeStelle|AX_Dienststelle_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.stelle IS 'ausfuehrendeStelle|AX_Dienststelle_Schluessel|stelle  CharacterString 1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.funktion IS 'funktion enumeration AX_Funktion_SchutzgebietNachWasserrecht 0..1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.name IS 'name  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.nummerdesschutzgebietes IS 'nummerDesSchutzgebietes  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.statement IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|statement|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.processstep_ax_li_processstep_mitdatenerhebung_description IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|description|AX_LI_ProcessStep_MitDatenerhebung_Description enumeration  1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.processstep_rationale IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|rationale|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.processstep_datetime IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|dateTime|DateTime  DateTime 0..1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.processstep_individualname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|individualName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.processstep_organisationname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|organisationName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.processstep_positionname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|positionName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.processstep_phone IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|phone|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.processstep_address IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|address|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.processstep_onlineresource IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|onlineResource|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.processstep_hoursofservice IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|hoursOfService|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.processstep_contactinstructions IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|contactInstructions|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.processstep_role IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|role|CI_RoleCode enumeration CI_RoleCode 1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.processstep_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.processstep_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.processstep_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.processstep_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.processstep_sourcestep IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.herkunft_source_source_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.herkunft_source_source_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.herkunft_source_source_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.herkunft_source_source_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_schutzgebietnachwasserrecht.herkunft_source_source_sourcestep IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
CREATE TABLE ax_schutzgebietnachnaturumweltoderbodenschutzrecht (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  artderfestlegung integer NOT NULL,
  land character varying,
  stelle character varying,
  name character varying,
  nummerdesschutzgebietes character varying,
  statement character varying,
  processstep_ax_li_processstep_mitdatenerhebung_description character varying[],
  processstep_rationale character varying[],
  processstep_datetime character(20)[],
  processstep_individualname character varying[],
  processstep_organisationname character varying[],
  processstep_positionname character varying[],
  processstep_phone character varying[],
  processstep_address character varying[],
  processstep_onlineresource character varying[],
  processstep_hoursofservice character varying[],
  processstep_contactinstructions character varying[],
  processstep_role character varying[],
  processstep_ax_datenerhebung character varying[],
  processstep_scaledenominator character varying[],
  processstep_sourcereferencesystem character varying[],
  processstep_sourceextent character varying[],
  processstep_sourcestep character varying[],
  herkunft_source_source_ax_datenerhebung character varying[],
  herkunft_source_source_scaledenominator character varying[],
  herkunft_source_source_sourcereferencesystem character varying[],
  herkunft_source_source_sourceextent character varying[],
  herkunft_source_source_sourcestep character varying[],
  bestehtaus character(16)[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_schutzgebietnachnaturumweltoderbodenschutzrecht_gml ON ax_schutzgebietnachnaturumweltoderbodenschutzrecht USING btree (gml_id,beginnt);
CREATE INDEX ax_schutzgebietnachnaturumweltoderbodenschutzrecht_endet ON ax_schutzgebietnachnaturumweltoderbodenschutzrecht USING btree (endet);
CREATE INDEX ax_snnuob_bestehtaus ON ax_schutzgebietnachnaturumweltoderbodenschutzrecht USING gin (bestehtaus);
CREATE INDEX ax_snnuob_istteilvon ON ax_schutzgebietnachnaturumweltoderbodenschutzrecht USING gin (istteilvon);

COMMENT ON TABLE ax_schutzgebietnachnaturumweltoderbodenschutzrecht IS 'FeatureType: "AX_SchutzgebietNachNaturUmweltOderBodenschutzrecht"';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.artderfestlegung IS 'artDerFestlegung enumeration AX_ArtDerFestlegung_SchutzgebietNachNaturUmweltOderBodenschutzrecht 1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.land IS 'ausfuehrendeStelle|AX_Dienststelle_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.stelle IS 'ausfuehrendeStelle|AX_Dienststelle_Schluessel|stelle  CharacterString 1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.name IS 'name  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.nummerdesschutzgebietes IS 'nummerDesSchutzgebietes  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.statement IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|statement|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.processstep_ax_li_processstep_mitdatenerhebung_description IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|description|AX_LI_ProcessStep_MitDatenerhebung_Description enumeration  1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.processstep_rationale IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|rationale|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.processstep_datetime IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|dateTime|DateTime  DateTime 0..1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.processstep_individualname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|individualName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.processstep_organisationname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|organisationName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.processstep_positionname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|positionName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.processstep_phone IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|phone|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.processstep_address IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|address|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.processstep_onlineresource IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|onlineResource|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.processstep_hoursofservice IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|hoursOfService|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.processstep_contactinstructions IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|contactInstructions|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.processstep_role IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|role|CI_RoleCode enumeration CI_RoleCode 1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.processstep_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.processstep_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.processstep_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.processstep_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.processstep_sourcestep IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.herkunft_source_source_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.herkunft_source_source_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.herkunft_source_source_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.herkunft_source_source_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_schutzgebietnachnaturumweltoderbodenschutzrecht.herkunft_source_source_sourcestep IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
CREATE TABLE ax_verwaltungsgemeinschaft (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  administrativefunktion integer[],
  bezeichnung character varying NOT NULL,
  bezeichnungart integer,
  einwohnerzahl integer,
  historisch character varying,
  regionalsprache character varying[],
  kreis character varying NOT NULL,
  land character varying NOT NULL,
  regierungsbezirk character varying,
  verwaltungsgemeinschaft character varying NOT NULL,
  schluesselgesamt character varying NOT NULL,
  zweitname character varying[],
  bestehtaus character(16)[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_verwaltungsgemeinschaft_gml ON ax_verwaltungsgemeinschaft USING btree (gml_id,beginnt);
CREATE INDEX ax_verwaltungsgemeinschaft_endet ON ax_verwaltungsgemeinschaft USING btree (endet);
CREATE INDEX ax_verwaltungsgemeinschaft_bestehtaus ON ax_verwaltungsgemeinschaft USING gin (bestehtaus);
CREATE INDEX ax_verwaltungsgemeinschaft_istteilvon ON ax_verwaltungsgemeinschaft USING gin (istteilvon);

COMMENT ON TABLE ax_verwaltungsgemeinschaft IS 'FeatureType: "AX_Verwaltungsgemeinschaft"';
COMMENT ON COLUMN ax_verwaltungsgemeinschaft.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_verwaltungsgemeinschaft.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_verwaltungsgemeinschaft.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_verwaltungsgemeinschaft.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_verwaltungsgemeinschaft.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_verwaltungsgemeinschaft.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_verwaltungsgemeinschaft.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_verwaltungsgemeinschaft.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_verwaltungsgemeinschaft.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_verwaltungsgemeinschaft.administrativefunktion IS 'administrativeFunktion enumeration AX_Administrative_Funktion 0..*';
COMMENT ON COLUMN ax_verwaltungsgemeinschaft.bezeichnung IS 'bezeichnung  CharacterString 1';
COMMENT ON COLUMN ax_verwaltungsgemeinschaft.bezeichnungart IS 'bezeichnungArt enumeration AX_Bezeichnung_Verwaltungsgemeinschaft 0..1';
COMMENT ON COLUMN ax_verwaltungsgemeinschaft.einwohnerzahl IS 'einwohnerzahl  Integer 0..1';
COMMENT ON COLUMN ax_verwaltungsgemeinschaft.historisch IS 'historisch  Boolean 0..1';
COMMENT ON COLUMN ax_verwaltungsgemeinschaft.regionalsprache IS 'regionalsprache  CharacterString 0..*';
COMMENT ON COLUMN ax_verwaltungsgemeinschaft.kreis IS 'schluessel|AX_Verwaltungsgemeinschaft_Schluessel|kreis  CharacterString 1';
COMMENT ON COLUMN ax_verwaltungsgemeinschaft.land IS 'schluessel|AX_Verwaltungsgemeinschaft_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_verwaltungsgemeinschaft.regierungsbezirk IS 'schluessel|AX_Verwaltungsgemeinschaft_Schluessel|regierungsbezirk  CharacterString 0..1';
COMMENT ON COLUMN ax_verwaltungsgemeinschaft.verwaltungsgemeinschaft IS 'schluessel|AX_Verwaltungsgemeinschaft_Schluessel|verwaltungsgemeinschaft  CharacterString 1';
COMMENT ON COLUMN ax_verwaltungsgemeinschaft.schluesselgesamt IS 'schluesselGesamt  CharacterString 1';
COMMENT ON COLUMN ax_verwaltungsgemeinschaft.zweitname IS 'zweitname  CharacterString 0..*';
CREATE TABLE ax_besonderertopographischerpunkt (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  punktkennung character varying,
  sonstigeeigenschaft character varying[],
  zustaendigestelle_land character varying,
  zustaendigestelle_stelle character varying,
  bestehtaus character(16)[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_besonderertopographischerpunkt_gml ON ax_besonderertopographischerpunkt USING btree (gml_id,beginnt);
CREATE INDEX ax_besonderertopographischerpunkt_endet ON ax_besonderertopographischerpunkt USING btree (endet);
CREATE INDEX ax_besonderertopographischerpunkt_bestehtaus ON ax_besonderertopographischerpunkt USING gin (bestehtaus);
CREATE INDEX ax_besonderertopographischerpunkt_istteilvon ON ax_besonderertopographischerpunkt USING gin (istteilvon);

COMMENT ON TABLE ax_besonderertopographischerpunkt IS 'FeatureType: "AX_BesondererTopographischerPunkt"';
COMMENT ON COLUMN ax_besonderertopographischerpunkt.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_besonderertopographischerpunkt.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_besonderertopographischerpunkt.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_besonderertopographischerpunkt.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_besonderertopographischerpunkt.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_besonderertopographischerpunkt.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_besonderertopographischerpunkt.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_besonderertopographischerpunkt.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_besonderertopographischerpunkt.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_besonderertopographischerpunkt.punktkennung IS 'punktkennung  CharacterString 0..1';
COMMENT ON COLUMN ax_besonderertopographischerpunkt.sonstigeeigenschaft IS 'sonstigeEigenschaft  CharacterString 0..*';
COMMENT ON COLUMN ax_besonderertopographischerpunkt.zustaendigestelle_land IS 'zustaendigeStelle|AX_Dienststelle_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_besonderertopographischerpunkt.zustaendigestelle_stelle IS 'zustaendigeStelle|AX_Dienststelle_Schluessel|stelle  CharacterString 1';
CREATE TABLE ax_boeschungkliff (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  name character varying,
  objekthoehe double precision,
  statement character varying,
  processstep_ax_li_processstep_mitdatenerhebung_description character varying[],
  processstep_rationale character varying[],
  processstep_datetime character(20)[],
  processstep_individualname character varying[],
  processstep_organisationname character varying[],
  processstep_positionname character varying[],
  processstep_phone character varying[],
  processstep_address character varying[],
  processstep_onlineresource character varying[],
  processstep_hoursofservice character varying[],
  processstep_contactinstructions character varying[],
  processstep_role character varying[],
  processstep_ax_datenerhebung character varying[],
  processstep_scaledenominator character varying[],
  processstep_sourcereferencesystem character varying[],
  processstep_sourceextent character varying[],
  processstep_sourcestep character varying[],
  herkunft_source_source_ax_datenerhebung character varying[],
  herkunft_source_source_scaledenominator character varying[],
  herkunft_source_source_sourcereferencesystem character varying[],
  herkunft_source_source_sourceextent character varying[],
  herkunft_source_source_sourcestep character varying[],
  zustand integer,
  bestehtaus character(16)[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_boeschungkliff_gml ON ax_boeschungkliff USING btree (gml_id,beginnt);
CREATE INDEX ax_boeschungkliff_endet ON ax_boeschungkliff USING btree (endet);
CREATE INDEX ax_boeschungkliff_bestehtaus ON ax_boeschungkliff USING gin (bestehtaus);
CREATE INDEX ax_boeschungkliff_istteilvon ON ax_boeschungkliff USING gin (istteilvon);

COMMENT ON TABLE ax_boeschungkliff IS 'FeatureType: "AX_BoeschungKliff"';
COMMENT ON COLUMN ax_boeschungkliff.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_boeschungkliff.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_boeschungkliff.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_boeschungkliff.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_boeschungkliff.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_boeschungkliff.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_boeschungkliff.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_boeschungkliff.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_boeschungkliff.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_boeschungkliff.name IS 'name  CharacterString 0..1';
COMMENT ON COLUMN ax_boeschungkliff.objekthoehe IS 'objekthoehe  Length 0..1';
COMMENT ON COLUMN ax_boeschungkliff.statement IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|statement|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_boeschungkliff.processstep_ax_li_processstep_mitdatenerhebung_description IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|description|AX_LI_ProcessStep_MitDatenerhebung_Description enumeration  1';
COMMENT ON COLUMN ax_boeschungkliff.processstep_rationale IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|rationale|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_boeschungkliff.processstep_datetime IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|dateTime|DateTime  DateTime 0..1';
COMMENT ON COLUMN ax_boeschungkliff.processstep_individualname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|individualName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_boeschungkliff.processstep_organisationname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|organisationName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_boeschungkliff.processstep_positionname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|positionName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_boeschungkliff.processstep_phone IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|phone|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_boeschungkliff.processstep_address IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|address|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_boeschungkliff.processstep_onlineresource IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|onlineResource|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_boeschungkliff.processstep_hoursofservice IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|hoursOfService|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_boeschungkliff.processstep_contactinstructions IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|contactInstructions|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_boeschungkliff.processstep_role IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|role|CI_RoleCode enumeration CI_RoleCode 1';
COMMENT ON COLUMN ax_boeschungkliff.processstep_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_boeschungkliff.processstep_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_boeschungkliff.processstep_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_boeschungkliff.processstep_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_boeschungkliff.processstep_sourcestep IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_boeschungkliff.herkunft_source_source_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_boeschungkliff.herkunft_source_source_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_boeschungkliff.herkunft_source_source_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_boeschungkliff.herkunft_source_source_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_boeschungkliff.herkunft_source_source_sourcestep IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_boeschungkliff.zustand IS 'zustand enumeration AX_Zustand_BoeschungKliff 0..1';
CREATE TABLE ax_wasserlauf (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  gewaesserkennzahl character varying,
  identnummer character varying,
  name character varying,
  regionalsprache character varying[],
  schifffahrtskategorie integer,
  widmung integer,
  zweitname character varying[],
  bestehtaus character(16)[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_wasserlauf_gml ON ax_wasserlauf USING btree (gml_id,beginnt);
CREATE INDEX ax_wasserlauf_endet ON ax_wasserlauf USING btree (endet);
CREATE INDEX ax_wasserlauf_bestehtaus ON ax_wasserlauf USING gin (bestehtaus);
CREATE INDEX ax_wasserlauf_istteilvon ON ax_wasserlauf USING gin (istteilvon);

COMMENT ON TABLE ax_wasserlauf IS 'FeatureType: "AX_Wasserlauf"';
COMMENT ON COLUMN ax_wasserlauf.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_wasserlauf.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_wasserlauf.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_wasserlauf.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_wasserlauf.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_wasserlauf.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_wasserlauf.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_wasserlauf.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_wasserlauf.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_wasserlauf.gewaesserkennzahl IS 'gewaesserkennzahl  CharacterString 0..1';
COMMENT ON COLUMN ax_wasserlauf.identnummer IS 'identnummer  CharacterString 0..1';
COMMENT ON COLUMN ax_wasserlauf.name IS 'name  CharacterString 0..1';
COMMENT ON COLUMN ax_wasserlauf.regionalsprache IS 'regionalsprache  CharacterString 0..*';
COMMENT ON COLUMN ax_wasserlauf.schifffahrtskategorie IS 'schifffahrtskategorie enumeration AX_Schifffahrtskategorie 0..1';
COMMENT ON COLUMN ax_wasserlauf.widmung IS 'widmung enumeration AX_Widmung_Wasserlauf 0..1';
COMMENT ON COLUMN ax_wasserlauf.zweitname IS 'zweitname  CharacterString 0..*';
CREATE TABLE ax_kanal (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  gewaesserkennzahl character varying,
  identnummer character varying,
  name character varying,
  regionalsprache character varying[],
  schifffahrtskategorie integer,
  widmung integer,
  zweitname character varying[],
  bestehtaus character(16)[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_kanal_gml ON ax_kanal USING btree (gml_id,beginnt);
CREATE INDEX ax_kanal_endet ON ax_kanal USING btree (endet);
CREATE INDEX ax_kanal_bestehtaus ON ax_kanal USING gin (bestehtaus);
CREATE INDEX ax_kanal_istteilvon ON ax_kanal USING gin (istteilvon);

COMMENT ON TABLE ax_kanal IS 'FeatureType: "AX_Kanal"';
COMMENT ON COLUMN ax_kanal.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_kanal.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_kanal.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_kanal.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_kanal.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_kanal.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_kanal.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_kanal.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_kanal.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_kanal.gewaesserkennzahl IS 'gewaesserkennzahl  CharacterString 0..1';
COMMENT ON COLUMN ax_kanal.identnummer IS 'identnummer  CharacterString 0..1';
COMMENT ON COLUMN ax_kanal.name IS 'name  CharacterString 0..1';
COMMENT ON COLUMN ax_kanal.regionalsprache IS 'regionalsprache  CharacterString 0..*';
COMMENT ON COLUMN ax_kanal.schifffahrtskategorie IS 'schifffahrtskategorie enumeration AX_Schifffahrtskategorie_Kanal 0..1';
COMMENT ON COLUMN ax_kanal.widmung IS 'widmung enumeration AX_Widmung_Kanal 0..1';
COMMENT ON COLUMN ax_kanal.zweitname IS 'zweitname  CharacterString 0..*';
CREATE TABLE ax_strasse (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  bezeichnung character varying[],
  fahrbahntrennung integer,
  internationalebedeutung integer,
  name character varying,
  regionalsprache character varying[],
  strassenschluessel character varying[],
  widmung integer NOT NULL,
  zweitname character varying[],
  bestehtaus character(16)[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_strasse_gml ON ax_strasse USING btree (gml_id,beginnt);
CREATE INDEX ax_strasse_endet ON ax_strasse USING btree (endet);
CREATE INDEX ax_strasse_bestehtaus ON ax_strasse USING gin (bestehtaus);
CREATE INDEX ax_strasse_istteilvon ON ax_strasse USING gin (istteilvon);

COMMENT ON TABLE ax_strasse IS 'FeatureType: "AX_Strasse"';
COMMENT ON COLUMN ax_strasse.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_strasse.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_strasse.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_strasse.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_strasse.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_strasse.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_strasse.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_strasse.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_strasse.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_strasse.bezeichnung IS 'bezeichnung  CharacterString 0..*';
COMMENT ON COLUMN ax_strasse.fahrbahntrennung IS 'fahrbahntrennung enumeration AX_Fahrbahntrennung_Strasse 0..1';
COMMENT ON COLUMN ax_strasse.internationalebedeutung IS 'internationaleBedeutung enumeration AX_InternationaleBedeutung_Strasse 0..1';
COMMENT ON COLUMN ax_strasse.name IS 'name  CharacterString 0..1';
COMMENT ON COLUMN ax_strasse.regionalsprache IS 'regionalsprache  CharacterString 0..*';
COMMENT ON COLUMN ax_strasse.strassenschluessel IS 'strassenschluessel  CharacterString 0..*';
COMMENT ON COLUMN ax_strasse.widmung IS 'widmung enumeration AX_Widmung_Strasse 1';
COMMENT ON COLUMN ax_strasse.zweitname IS 'zweitname  CharacterString 0..*';
CREATE TABLE ax_benutzer (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  art character varying,
  direkt character varying,
  email character varying,
  http character varying,
  manuell character varying,
  ausgabemasstab double precision,
  ausgabemedium integer,
  datenformat integer,
  formatangabe character varying,
  letzteabgabeart integer,
  letzteabgabezugriff character(20),
  nbaquittierungerhalten character(20),
  nbauebernahmeerfolgreich character varying,
  profilkennung character varying NOT NULL,
  vorletzteabgabezugriff character(20),
  zahlungsweise character varying,
  zeitlicheberechtigung date,
  istteilvon character(16)[],
  ist character(16) NOT NULL,
  gehoertzu character(16) NOT NULL,
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_benutzer_gml ON ax_benutzer USING btree (gml_id,beginnt);
CREATE INDEX ax_benutzer_endet ON ax_benutzer USING btree (endet);
CREATE INDEX ax_benutzer_ist ON ax_benutzer USING btree (ist);
CREATE INDEX ax_benutzer_gehoertzu ON ax_benutzer USING btree (gehoertzu);
CREATE INDEX ax_benutzer_istteilvon ON ax_benutzer USING gin (istteilvon);

COMMENT ON TABLE ax_benutzer IS 'FeatureType: "AX_Benutzer"';
COMMENT ON COLUMN ax_benutzer.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_benutzer.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_benutzer.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_benutzer.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_benutzer.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_benutzer.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_benutzer.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_benutzer.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_benutzer.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_benutzer.art IS 'art  CharacterString 0..1';
COMMENT ON COLUMN ax_benutzer.direkt IS 'empfaenger|AA_Empfaenger|direkt  Boolean 0..1';
COMMENT ON COLUMN ax_benutzer.email IS 'empfaenger|AA_Empfaenger|email  URI 0..1';
COMMENT ON COLUMN ax_benutzer.http IS 'empfaenger|AA_Empfaenger|http  URI 0..1';
COMMENT ON COLUMN ax_benutzer.manuell IS 'empfaenger|AA_Empfaenger|manuell  CharacterString 0..1';
COMMENT ON COLUMN ax_benutzer.ausgabemasstab IS 'folgeverarbeitung|AX_FOLGEVA|ausgabemasstab  Real 0..1';
COMMENT ON COLUMN ax_benutzer.ausgabemedium IS 'folgeverarbeitung|AX_FOLGEVA|ausgabemedium enumeration AX_Ausgabemedium_Benutzer 0..1';
COMMENT ON COLUMN ax_benutzer.datenformat IS 'folgeverarbeitung|AX_FOLGEVA|datenformat enumeration AX_Datenformat_Benutzer 0..1';
COMMENT ON COLUMN ax_benutzer.formatangabe IS 'folgeverarbeitung|AX_FOLGEVA|formatangabe  CharacterString 0..1';
COMMENT ON COLUMN ax_benutzer.letzteabgabeart IS 'letzteAbgabeArt enumeration AX_LetzteAbgabeArt 0..1';
COMMENT ON COLUMN ax_benutzer.letzteabgabezugriff IS 'letzteAbgabeZugriff  DateTime 0..1';
COMMENT ON COLUMN ax_benutzer.nbaquittierungerhalten IS 'nBAQuittierungErhalten  DateTime 0..1';
COMMENT ON COLUMN ax_benutzer.nbauebernahmeerfolgreich IS 'nBAUebernahmeErfolgreich  Boolean 0..1';
COMMENT ON COLUMN ax_benutzer.profilkennung IS 'profilkennung  CharacterString 1';
COMMENT ON COLUMN ax_benutzer.vorletzteabgabezugriff IS 'vorletzteAbgabeZugriff  DateTime 0..1';
COMMENT ON COLUMN ax_benutzer.zahlungsweise IS 'zahlungsweise  CharacterString 0..1';
COMMENT ON COLUMN ax_benutzer.zeitlicheberechtigung IS 'zeitlicheBerechtigung  Date 0..1';
COMMENT ON COLUMN ax_benutzer.ist IS 'Assoziation zu: FeatureType AX_Person (ax_person) 1';
COMMENT ON COLUMN ax_benutzer.gehoertzu IS 'Assoziation zu: FeatureType AX_Benutzergruppe (ax_benutzergruppe) 1';
CREATE TABLE ax_benutzergruppemitzugriffskontrolle (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  bezeichnung character varying NOT NULL,
  koordinatenreferenzsystem character varying,
  land character varying NOT NULL,
  stelle character varying NOT NULL,
  selektionskriterien character varying[] NOT NULL,
  zugriffhistorie character varying NOT NULL,
  zugriffsartfortfuehrungsanlass character varying[],
  zugriffsartproduktkennungbenutzung character varying[],
  zugriffsartproduktkennungfuehrung character varying[],
  bestehtaus character(16)[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_benutzergruppemitzugriffskontrolle_gml ON ax_benutzergruppemitzugriffskontrolle USING btree (gml_id,beginnt);
CREATE INDEX ax_benutzergruppemitzugriffskontrolle_endet ON ax_benutzergruppemitzugriffskontrolle USING btree (endet);
CREATE INDEX ax_benutzergruppemitzugriffskontrolle_bestehtaus ON ax_benutzergruppemitzugriffskontrolle USING gin (bestehtaus);
CREATE INDEX ax_benutzergruppemitzugriffskontrolle_istteilvon ON ax_benutzergruppemitzugriffskontrolle USING gin (istteilvon);

COMMENT ON TABLE ax_benutzergruppemitzugriffskontrolle IS 'FeatureType: "AX_BenutzergruppeMitZugriffskontrolle"';
COMMENT ON COLUMN ax_benutzergruppemitzugriffskontrolle.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_benutzergruppemitzugriffskontrolle.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_benutzergruppemitzugriffskontrolle.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_benutzergruppemitzugriffskontrolle.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_benutzergruppemitzugriffskontrolle.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_benutzergruppemitzugriffskontrolle.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_benutzergruppemitzugriffskontrolle.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_benutzergruppemitzugriffskontrolle.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_benutzergruppemitzugriffskontrolle.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_benutzergruppemitzugriffskontrolle.bezeichnung IS 'bezeichnung  CharacterString 1';
COMMENT ON COLUMN ax_benutzergruppemitzugriffskontrolle.koordinatenreferenzsystem IS 'koordinatenreferenzsystem  SC_CRS 0..1';
COMMENT ON COLUMN ax_benutzergruppemitzugriffskontrolle.land IS 'zustaendigeStelle|AX_Dienststelle_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_benutzergruppemitzugriffskontrolle.stelle IS 'zustaendigeStelle|AX_Dienststelle_Schluessel|stelle  CharacterString 1';
COMMENT ON COLUMN ax_benutzergruppemitzugriffskontrolle.selektionskriterien IS 'selektionskriterien   1..*';
COMMENT ON COLUMN ax_benutzergruppemitzugriffskontrolle.zugriffhistorie IS 'zugriffHistorie  Boolean 1';
COMMENT ON COLUMN ax_benutzergruppemitzugriffskontrolle.zugriffsartfortfuehrungsanlass IS 'zugriffsartFortfuehrungsanlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_benutzergruppemitzugriffskontrolle.zugriffsartproduktkennungbenutzung IS 'zugriffsartProduktkennungBenutzung codelist AA_Anlassart_Benutzungsauftrag 0..*';
COMMENT ON COLUMN ax_benutzergruppemitzugriffskontrolle.zugriffsartproduktkennungfuehrung IS 'zugriffsartProduktkennungFuehrung codelist AA_Anlassart 0..*';
CREATE TABLE ax_benutzergruppenba (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  bezeichnung character varying NOT NULL,
  koordinatenreferenzsystem character varying,
  land character varying NOT NULL,
  stelle character varying NOT NULL,
  abgabeversion character varying NOT NULL,
  bereichzeitlich_art integer,
  bereichzeitlich_ersterstichtag date,
  bereichzeitlich_intervall date,
  seitenlaenge integer,
  quittierung character varying,
  selektionskriterien character varying[] NOT NULL,
  bestehtaus character(16)[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_benutzergruppenba_gml ON ax_benutzergruppenba USING btree (gml_id,beginnt);
CREATE INDEX ax_benutzergruppenba_endet ON ax_benutzergruppenba USING btree (endet);
CREATE INDEX ax_benutzergruppenba_bestehtaus ON ax_benutzergruppenba USING gin (bestehtaus);
CREATE INDEX ax_benutzergruppenba_istteilvon ON ax_benutzergruppenba USING gin (istteilvon);

COMMENT ON TABLE ax_benutzergruppenba IS 'FeatureType: "AX_BenutzergruppeNBA"';
COMMENT ON COLUMN ax_benutzergruppenba.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_benutzergruppenba.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_benutzergruppenba.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_benutzergruppenba.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_benutzergruppenba.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_benutzergruppenba.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_benutzergruppenba.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_benutzergruppenba.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_benutzergruppenba.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_benutzergruppenba.bezeichnung IS 'bezeichnung  CharacterString 1';
COMMENT ON COLUMN ax_benutzergruppenba.koordinatenreferenzsystem IS 'koordinatenreferenzsystem  SC_CRS 0..1';
COMMENT ON COLUMN ax_benutzergruppenba.land IS 'zustaendigeStelle|AX_Dienststelle_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_benutzergruppenba.stelle IS 'zustaendigeStelle|AX_Dienststelle_Schluessel|stelle  CharacterString 1';
COMMENT ON COLUMN ax_benutzergruppenba.abgabeversion IS 'abgabeversion enumeration AX_Abgabeversion 1';
COMMENT ON COLUMN ax_benutzergruppenba.bereichzeitlich_art IS 'bereichZeitlich|AX_BereichZeitlich|art enumeration AX_Art_BereichZeitlich 1';
COMMENT ON COLUMN ax_benutzergruppenba.bereichzeitlich_ersterstichtag IS 'bereichZeitlich|AX_BereichZeitlich|ersterStichtag  Date 1';
COMMENT ON COLUMN ax_benutzergruppenba.bereichzeitlich_intervall IS 'bereichZeitlich|AX_BereichZeitlich|intervall  TM_Duration 1';
COMMENT ON COLUMN ax_benutzergruppenba.seitenlaenge IS 'portionierungsparameter|AX_Portionierungsparameter|seitenlaenge  Integer 1';
COMMENT ON COLUMN ax_benutzergruppenba.quittierung IS 'quittierung  Boolean 0..1';
COMMENT ON COLUMN ax_benutzergruppenba.selektionskriterien IS 'selektionskriterien   1..*';
CREATE TABLE ap_darstellung (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  art character varying,
  darstellungsprioritaet integer,
  positionierungsregel character varying,
  signaturnummer character varying,
  istteilvon character(16)[],
  dientzurdarstellungvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ap_darstellung_gml ON ap_darstellung USING btree (gml_id,beginnt);
CREATE INDEX ap_darstellung_endet ON ap_darstellung USING btree (endet);
CREATE INDEX ap_darstellung_dientzurdarstellungvon ON ap_darstellung USING gin (dientzurdarstellungvon);
CREATE INDEX ap_darstellung_istteilvon ON ap_darstellung USING gin (istteilvon);

COMMENT ON TABLE ap_darstellung IS 'FeatureType: "AP_Darstellung"';
COMMENT ON COLUMN ap_darstellung.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ap_darstellung.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ap_darstellung.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ap_darstellung.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ap_darstellung.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ap_darstellung.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ap_darstellung.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ap_darstellung.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ap_darstellung.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ap_darstellung.art IS 'art  CharacterString 0..1';
COMMENT ON COLUMN ap_darstellung.darstellungsprioritaet IS 'darstellungsprioritaet  Integer 0..1';
COMMENT ON COLUMN ap_darstellung.positionierungsregel IS 'positionierungsregel  CharacterString 0..1';
COMMENT ON COLUMN ap_darstellung.signaturnummer IS 'signaturnummer  CharacterString 0..1';
COMMENT ON COLUMN ap_darstellung.dientzurdarstellungvon IS 'Assoziation zu: FeatureType AA_Objekt (aa_objekt) 0..*';
CREATE TABLE aa_antrag (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  antragunterbrochen character varying NOT NULL,
  art character varying NOT NULL,
  erlaeuterungzumstatus character varying,
  kennzeichen character varying NOT NULL,
  istteilvon character(16)[],
  gebiet character(16),
  verweistauf character(16)[] NOT NULL,
  bearbeitungsstatus character(16),
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX aa_antrag_gml ON aa_antrag USING btree (gml_id,beginnt);
CREATE INDEX aa_antrag_endet ON aa_antrag USING btree (endet);
CREATE INDEX aa_antrag_gebiet ON aa_antrag USING btree (gebiet);
CREATE INDEX aa_antrag_verweistauf ON aa_antrag USING gin (verweistauf);
CREATE INDEX aa_antrag_bearbeitungsstatus ON aa_antrag USING btree (bearbeitungsstatus);
CREATE INDEX aa_antrag_istteilvon ON aa_antrag USING gin (istteilvon);

COMMENT ON TABLE aa_antrag IS 'FeatureType: "AA_Antrag"';
COMMENT ON COLUMN aa_antrag.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN aa_antrag.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN aa_antrag.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN aa_antrag.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN aa_antrag.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN aa_antrag.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN aa_antrag.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN aa_antrag.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN aa_antrag.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN aa_antrag.antragunterbrochen IS 'antragUnterbrochen  Boolean 1';
COMMENT ON COLUMN aa_antrag.art IS 'art  AA_Antragsart 1';
COMMENT ON COLUMN aa_antrag.erlaeuterungzumstatus IS 'erlaeuterungZumStatus  CharacterString 0..1';
COMMENT ON COLUMN aa_antrag.kennzeichen IS 'kennzeichen  CharacterString 1';
COMMENT ON COLUMN aa_antrag.gebiet IS 'Assoziation zu: FeatureType AA_Antragsgebiet (aa_antragsgebiet) 0..1';
COMMENT ON COLUMN aa_antrag.verweistauf IS 'Assoziation zu: FeatureType AA_Projektsteuerung (aa_projektsteuerung) 1..*';
COMMENT ON COLUMN aa_antrag.bearbeitungsstatus IS 'Assoziation zu: FeatureType AA_Meilenstein (aa_meilenstein) 0..1';
CREATE TABLE aa_vorgang (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  art character varying NOT NULL,
  erlaeuterung character varying,
  istteilvon character(16)[],
  bearbeitbardurch character(16) NOT NULL,
  synchronisiertmit character(16),
  status character(16) NOT NULL,
  enthaelt character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX aa_vorgang_gml ON aa_vorgang USING btree (gml_id,beginnt);
CREATE INDEX aa_vorgang_endet ON aa_vorgang USING btree (endet);
CREATE INDEX aa_vorgang_bearbeitbardurch ON aa_vorgang USING btree (bearbeitbardurch);
CREATE INDEX aa_vorgang_synchronisiertmit ON aa_vorgang USING btree (synchronisiertmit);
CREATE INDEX aa_vorgang_status ON aa_vorgang USING btree (status);
CREATE INDEX aa_vorgang_enthaelt ON aa_vorgang USING gin (enthaelt);
CREATE INDEX aa_vorgang_istteilvon ON aa_vorgang USING gin (istteilvon);

COMMENT ON TABLE aa_vorgang IS 'FeatureType: "AA_Vorgang"';
COMMENT ON COLUMN aa_vorgang.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN aa_vorgang.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN aa_vorgang.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN aa_vorgang.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN aa_vorgang.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN aa_vorgang.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN aa_vorgang.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN aa_vorgang.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN aa_vorgang.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN aa_vorgang.art IS 'art  AA_Vorgangsart 1';
COMMENT ON COLUMN aa_vorgang.erlaeuterung IS 'erlaeuterung  CharacterString 0..1';
COMMENT ON COLUMN aa_vorgang.bearbeitbardurch IS 'Assoziation zu: FeatureType AA_Benutzergruppe (aa_benutzergruppe) 1';
COMMENT ON COLUMN aa_vorgang.synchronisiertmit IS 'Assoziation zu: FeatureType AA_Vorgang (aa_vorgang) 0..1';
COMMENT ON COLUMN aa_vorgang.status IS 'Assoziation zu: FeatureType AA_Meilenstein (aa_meilenstein) 1';
COMMENT ON COLUMN aa_vorgang.enthaelt IS 'Assoziation zu: FeatureType AA_Aktivitaet (aa_aktivitaet) 0..*';
CREATE TABLE aa_projektsteuerung (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  anlassdesprozesses character varying[] NOT NULL,
  art character varying NOT NULL,
  parameterwert character varying[],
  istteilvon character(16)[],
  enthaelt character(16)[] NOT NULL,
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX aa_projektsteuerung_gml ON aa_projektsteuerung USING btree (gml_id,beginnt);
CREATE INDEX aa_projektsteuerung_endet ON aa_projektsteuerung USING btree (endet);
CREATE INDEX aa_projektsteuerung_enthaelt ON aa_projektsteuerung USING gin (enthaelt);
CREATE INDEX aa_projektsteuerung_istteilvon ON aa_projektsteuerung USING gin (istteilvon);

COMMENT ON TABLE aa_projektsteuerung IS 'FeatureType: "AA_Projektsteuerung"';
COMMENT ON COLUMN aa_projektsteuerung.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN aa_projektsteuerung.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN aa_projektsteuerung.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN aa_projektsteuerung.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN aa_projektsteuerung.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN aa_projektsteuerung.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN aa_projektsteuerung.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN aa_projektsteuerung.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN aa_projektsteuerung.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN aa_projektsteuerung.anlassdesprozesses IS 'anlassDesProzesses codelist AA_Anlassart 1..*';
COMMENT ON COLUMN aa_projektsteuerung.art IS 'art  AA_Projektsteuerungsart 1';
COMMENT ON COLUMN aa_projektsteuerung.parameterwert IS 'gebuehren|AA_Gebuehrenangaben|parameterWert  CharacterString 1';
COMMENT ON COLUMN aa_projektsteuerung.enthaelt IS 'Assoziation zu: FeatureType AA_Vorgang (aa_vorgang) 1..*';
CREATE TABLE aa_meilenstein (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  abgeschlossen character varying,
  begonnen character varying,
  bemerkung character varying,
  erfolgreich character varying,
  kategorie character varying,
  wannabgeschlossen character(20),
  istteilvon character(16)[],
  wer character(16),
  vonantrag character(16)[],
  vonvorgang character(16)[],
  vonaktivitaet character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX aa_meilenstein_gml ON aa_meilenstein USING btree (gml_id,beginnt);
CREATE INDEX aa_meilenstein_endet ON aa_meilenstein USING btree (endet);
CREATE INDEX aa_meilenstein_wer ON aa_meilenstein USING btree (wer);
CREATE INDEX aa_meilenstein_vonantrag ON aa_meilenstein USING gin (vonantrag);
CREATE INDEX aa_meilenstein_vonvorgang ON aa_meilenstein USING gin (vonvorgang);
CREATE INDEX aa_meilenstein_vonaktivitaet ON aa_meilenstein USING gin (vonaktivitaet);
CREATE INDEX aa_meilenstein_istteilvon ON aa_meilenstein USING gin (istteilvon);

COMMENT ON TABLE aa_meilenstein IS 'FeatureType: "AA_Meilenstein"';
COMMENT ON COLUMN aa_meilenstein.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN aa_meilenstein.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN aa_meilenstein.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN aa_meilenstein.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN aa_meilenstein.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN aa_meilenstein.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN aa_meilenstein.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN aa_meilenstein.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN aa_meilenstein.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN aa_meilenstein.abgeschlossen IS 'abgeschlossen  Boolean 0..1';
COMMENT ON COLUMN aa_meilenstein.begonnen IS 'begonnen  Boolean 0..1';
COMMENT ON COLUMN aa_meilenstein.bemerkung IS 'bemerkung  CharacterString 0..1';
COMMENT ON COLUMN aa_meilenstein.erfolgreich IS 'erfolgreich  Boolean 0..1';
COMMENT ON COLUMN aa_meilenstein.kategorie IS 'kategorie codelist AA_BesondereMeilensteinkategorie 0..1';
COMMENT ON COLUMN aa_meilenstein.wannabgeschlossen IS 'wannAbgeschlossen  DateTime 0..1';
COMMENT ON COLUMN aa_meilenstein.wer IS 'Assoziation zu: FeatureType AA_Benutzer (aa_benutzer) 0..1';
COMMENT ON COLUMN aa_meilenstein.vonantrag IS 'Assoziation zu: FeatureType AA_Antrag (aa_antrag) 0..*';
COMMENT ON COLUMN aa_meilenstein.vonvorgang IS 'Assoziation zu: FeatureType AA_Vorgang (aa_vorgang) 0..*';
COMMENT ON COLUMN aa_meilenstein.vonaktivitaet IS 'Assoziation zu: FeatureType AA_Aktivitaet (aa_aktivitaet) 0..*';
CREATE TABLE aa_aktivitaet (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  art character varying NOT NULL,
  erlaeuterung character varying,
  istteilvon character(16)[],
  status character(16) NOT NULL,
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX aa_aktivitaet_gml ON aa_aktivitaet USING btree (gml_id,beginnt);
CREATE INDEX aa_aktivitaet_endet ON aa_aktivitaet USING btree (endet);
CREATE INDEX aa_aktivitaet_status ON aa_aktivitaet USING btree (status);
CREATE INDEX aa_aktivitaet_istteilvon ON aa_aktivitaet USING gin (istteilvon);

COMMENT ON TABLE aa_aktivitaet IS 'FeatureType: "AA_Aktivitaet"';
COMMENT ON COLUMN aa_aktivitaet.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN aa_aktivitaet.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN aa_aktivitaet.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN aa_aktivitaet.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN aa_aktivitaet.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN aa_aktivitaet.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN aa_aktivitaet.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN aa_aktivitaet.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN aa_aktivitaet.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN aa_aktivitaet.art IS 'art  AA_Aktivitaetsart 1';
COMMENT ON COLUMN aa_aktivitaet.erlaeuterung IS 'erlaeuterung  CharacterString 0..1';
COMMENT ON COLUMN aa_aktivitaet.status IS 'Assoziation zu: FeatureType AA_Meilenstein (aa_meilenstein) 1';
CREATE TABLE ax_personengruppe (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  namederpersonengruppe character varying NOT NULL,
  istteilvon character(16)[],
  bestehtaus character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_personengruppe_gml ON ax_personengruppe USING btree (gml_id,beginnt);
CREATE INDEX ax_personengruppe_endet ON ax_personengruppe USING btree (endet);
CREATE INDEX ax_personengruppe_bestehtaus ON ax_personengruppe USING gin (bestehtaus);
CREATE INDEX ax_personengruppe_istteilvon ON ax_personengruppe USING gin (istteilvon);

COMMENT ON TABLE ax_personengruppe IS 'FeatureType: "AX_Personengruppe"';
COMMENT ON COLUMN ax_personengruppe.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_personengruppe.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_personengruppe.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_personengruppe.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_personengruppe.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_personengruppe.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_personengruppe.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_personengruppe.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_personengruppe.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_personengruppe.namederpersonengruppe IS 'nameDerPersonengruppe  CharacterString 1';
COMMENT ON COLUMN ax_personengruppe.bestehtaus IS 'Assoziation zu: FeatureType AX_Person (ax_person) *';
CREATE TABLE ax_buchungsblatt (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  blattart integer NOT NULL,
  bezirk character varying NOT NULL,
  land character varying NOT NULL,
  buchungsblattkennzeichen character varying NOT NULL,
  buchungsblattnummermitbuchstabenerweiterung character varying NOT NULL,
  istteilvon character(16)[],
  bestehtaus character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_buchungsblatt_gml ON ax_buchungsblatt USING btree (gml_id,beginnt);
CREATE INDEX ax_buchungsblatt_endet ON ax_buchungsblatt USING btree (endet);
CREATE INDEX ax_buchungsblatt_bestehtaus ON ax_buchungsblatt USING gin (bestehtaus);
CREATE INDEX ax_buchungsblatt_istteilvon ON ax_buchungsblatt USING gin (istteilvon);

COMMENT ON TABLE ax_buchungsblatt IS 'FeatureType: "AX_Buchungsblatt"';
COMMENT ON COLUMN ax_buchungsblatt.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_buchungsblatt.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_buchungsblatt.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_buchungsblatt.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_buchungsblatt.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_buchungsblatt.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_buchungsblatt.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_buchungsblatt.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_buchungsblatt.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_buchungsblatt.blattart IS 'blattart enumeration AX_Blattart_Buchungsblatt 1';
COMMENT ON COLUMN ax_buchungsblatt.bezirk IS 'buchungsblattbezirk|AX_Buchungsblattbezirk_Schluessel|bezirk  CharacterString 1';
COMMENT ON COLUMN ax_buchungsblatt.land IS 'buchungsblattbezirk|AX_Buchungsblattbezirk_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_buchungsblatt.buchungsblattkennzeichen IS 'buchungsblattkennzeichen  CharacterString 1';
COMMENT ON COLUMN ax_buchungsblatt.buchungsblattnummermitbuchstabenerweiterung IS 'buchungsblattnummerMitBuchstabenerweiterung  CharacterString 1';
COMMENT ON COLUMN ax_buchungsblatt.bestehtaus IS 'Assoziation zu: FeatureType AX_Buchungsstelle (ax_buchungsstelle) 0..*';
CREATE TABLE ax_verwaltung (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  beginnderbestellung date,
  bestellungsbeschluss character varying,
  endederbestellung date,
  grundakt character varying,
  notariat character varying,
  statement character varying,
  ax_li_processstep_ohnedatenerhebung_description character varying[],
  processstep_rationale character varying[],
  processstep_datetime character(20)[],
  processstep_individualname character varying[],
  processstep_organisationname character varying[],
  processstep_positionname character varying[],
  processstep_phone character varying[],
  processstep_address character varying[],
  processstep_onlineresource character varying[],
  processstep_hoursofservice character varying[],
  processstep_contactinstructions character varying[],
  processstep_role character varying[],
  processstep_ax_datenerhebung character varying[],
  processstep_scaledenominator character varying[],
  processstep_sourcereferencesystem character varying[],
  processstep_sourceextent character varying[],
  processstep_sourcestep character varying[],
  herkunft_source_source_ax_datenerhebung character varying[],
  herkunft_source_source_scaledenominator character varying[],
  herkunft_source_source_sourcereferencesystem character varying[],
  herkunft_source_source_sourceextent character varying[],
  herkunft_source_source_sourcestep character varying[],
  istteilvon character(16)[],
  beziehtsichauf character(16)[],
  haengtan character(16) NOT NULL,
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_verwaltung_gml ON ax_verwaltung USING btree (gml_id,beginnt);
CREATE INDEX ax_verwaltung_endet ON ax_verwaltung USING btree (endet);
CREATE INDEX ax_verwaltung_beziehtsichauf ON ax_verwaltung USING gin (beziehtsichauf);
CREATE INDEX ax_verwaltung_haengtan ON ax_verwaltung USING btree (haengtan);
CREATE INDEX ax_verwaltung_istteilvon ON ax_verwaltung USING gin (istteilvon);

COMMENT ON TABLE ax_verwaltung IS 'FeatureType: "AX_Verwaltung"';
COMMENT ON COLUMN ax_verwaltung.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_verwaltung.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_verwaltung.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_verwaltung.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_verwaltung.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_verwaltung.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_verwaltung.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_verwaltung.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_verwaltung.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_verwaltung.beginnderbestellung IS 'beginnDerBestellung  Date 0..1';
COMMENT ON COLUMN ax_verwaltung.bestellungsbeschluss IS 'bestellungsbeschluss  CharacterString 0..1';
COMMENT ON COLUMN ax_verwaltung.endederbestellung IS 'endeDerBestellung  Date 0..1';
COMMENT ON COLUMN ax_verwaltung.grundakt IS 'grundakt  CharacterString 0..1';
COMMENT ON COLUMN ax_verwaltung.notariat IS 'notariat  CharacterString 0..1';
COMMENT ON COLUMN ax_verwaltung.statement IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|statement|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_verwaltung.ax_li_processstep_ohnedatenerhebung_description IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|description|AX_LI_ProcessStep_OhneDatenerhebung_Description enumeration  1';
COMMENT ON COLUMN ax_verwaltung.processstep_rationale IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|rationale|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_verwaltung.processstep_datetime IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|dateTime|DateTime  DateTime 0..1';
COMMENT ON COLUMN ax_verwaltung.processstep_individualname IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|individualName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_verwaltung.processstep_organisationname IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|organisationName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_verwaltung.processstep_positionname IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|positionName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_verwaltung.processstep_phone IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|phone|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_verwaltung.processstep_address IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|address|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_verwaltung.processstep_onlineresource IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|onlineResource|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_verwaltung.processstep_hoursofservice IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|hoursOfService|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_verwaltung.processstep_contactinstructions IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|contactInstructions|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_verwaltung.processstep_role IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|role|CI_RoleCode enumeration CI_RoleCode 1';
COMMENT ON COLUMN ax_verwaltung.processstep_ax_datenerhebung IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_verwaltung.processstep_scaledenominator IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_verwaltung.processstep_sourcereferencesystem IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_verwaltung.processstep_sourceextent IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_verwaltung.processstep_sourcestep IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_verwaltung.herkunft_source_source_ax_datenerhebung IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_verwaltung.herkunft_source_source_scaledenominator IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_verwaltung.herkunft_source_source_sourcereferencesystem IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_verwaltung.herkunft_source_source_sourceextent IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_verwaltung.herkunft_source_source_sourcestep IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_verwaltung.beziehtsichauf IS 'Assoziation zu: FeatureType AX_Buchungsstelle (ax_buchungsstelle) 0..*';
COMMENT ON COLUMN ax_verwaltung.haengtan IS 'Assoziation zu: FeatureType AX_Person (ax_person) 1';
CREATE TABLE ax_vertretung (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  angabenzurvertretung character varying,
  artdervertretung character varying[],
  beginndervertretung date,
  endedervertretung date,
  istteilvon character(16)[],
  haengtan character(16) NOT NULL,
  vertritt character(16)[],
  beziehtsichauf character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_vertretung_gml ON ax_vertretung USING btree (gml_id,beginnt);
CREATE INDEX ax_vertretung_endet ON ax_vertretung USING btree (endet);
CREATE INDEX ax_vertretung_haengtan ON ax_vertretung USING btree (haengtan);
CREATE INDEX ax_vertretung_vertritt ON ax_vertretung USING gin (vertritt);
CREATE INDEX ax_vertretung_beziehtsichauf ON ax_vertretung USING gin (beziehtsichauf);
CREATE INDEX ax_vertretung_istteilvon ON ax_vertretung USING gin (istteilvon);

COMMENT ON TABLE ax_vertretung IS 'FeatureType: "AX_Vertretung"';
COMMENT ON COLUMN ax_vertretung.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_vertretung.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_vertretung.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_vertretung.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_vertretung.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_vertretung.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_vertretung.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_vertretung.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_vertretung.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_vertretung.angabenzurvertretung IS 'angabenZurVertretung  CharacterString 0..1';
COMMENT ON COLUMN ax_vertretung.artdervertretung IS 'artDerVertretung  CharacterString 0..*';
COMMENT ON COLUMN ax_vertretung.beginndervertretung IS 'beginnDerVertretung  Date 0..1';
COMMENT ON COLUMN ax_vertretung.endedervertretung IS 'endeDerVertretung  Date 0..1';
COMMENT ON COLUMN ax_vertretung.haengtan IS 'Assoziation zu: FeatureType AX_Person (ax_person) 1';
COMMENT ON COLUMN ax_vertretung.vertritt IS 'Assoziation zu: FeatureType AX_Person (ax_person) 0..*';
COMMENT ON COLUMN ax_vertretung.beziehtsichauf IS 'Assoziation zu: FeatureType AX_Flurstueck (ax_flurstueck) 0..*';
CREATE TABLE ax_namensnummer (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  nenner double precision,
  zaehler double precision,
  artderrechtsgemeinschaft integer,
  beschriebderrechtsgemeinschaft character varying,
  eigentuemerart integer,
  laufendenummernachdin1421 character varying,
  nummer character varying,
  strichblattnummer integer,
  istteilvon character(16)[],
  istbestandteilvon character(16) NOT NULL,
  bestehtausrechtsverhaeltnissenzu character(16),
  hatvorgaenger character(16)[],
  benennt character(16),
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_namensnummer_gml ON ax_namensnummer USING btree (gml_id,beginnt);
CREATE INDEX ax_namensnummer_endet ON ax_namensnummer USING btree (endet);
CREATE INDEX ax_namensnummer_istbestandteilvon ON ax_namensnummer USING btree (istbestandteilvon);
CREATE INDEX ax_namensnummer_bestehtausrechtsverhaeltnissenzu ON ax_namensnummer USING btree (bestehtausrechtsverhaeltnissenzu);
CREATE INDEX ax_namensnummer_hatvorgaenger ON ax_namensnummer USING gin (hatvorgaenger);
CREATE INDEX ax_namensnummer_benennt ON ax_namensnummer USING btree (benennt);
CREATE INDEX ax_namensnummer_istteilvon ON ax_namensnummer USING gin (istteilvon);

COMMENT ON TABLE ax_namensnummer IS 'FeatureType: "AX_Namensnummer"';
COMMENT ON COLUMN ax_namensnummer.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_namensnummer.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_namensnummer.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_namensnummer.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_namensnummer.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_namensnummer.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_namensnummer.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_namensnummer.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_namensnummer.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_namensnummer.nenner IS 'anteil|AX_Anteil|nenner  Real 1';
COMMENT ON COLUMN ax_namensnummer.zaehler IS 'anteil|AX_Anteil|zaehler  Real 1';
COMMENT ON COLUMN ax_namensnummer.artderrechtsgemeinschaft IS 'artDerRechtsgemeinschaft enumeration AX_ArtDerRechtsgemeinschaft_Namensnummer 0..1';
COMMENT ON COLUMN ax_namensnummer.beschriebderrechtsgemeinschaft IS 'beschriebDerRechtsgemeinschaft  CharacterString 0..1';
COMMENT ON COLUMN ax_namensnummer.eigentuemerart IS 'eigentuemerart enumeration AX_Eigentuemerart_Namensnummer 0..1';
COMMENT ON COLUMN ax_namensnummer.laufendenummernachdin1421 IS 'laufendeNummerNachDIN1421  CharacterString 0..1';
COMMENT ON COLUMN ax_namensnummer.nummer IS 'nummer  CharacterString 0..1';
COMMENT ON COLUMN ax_namensnummer.strichblattnummer IS 'strichblattnummer  Integer 0..1';
COMMENT ON COLUMN ax_namensnummer.istbestandteilvon IS 'Assoziation zu: FeatureType AX_Buchungsblatt (ax_buchungsblatt) 1';
COMMENT ON COLUMN ax_namensnummer.bestehtausrechtsverhaeltnissenzu IS 'Assoziation zu: FeatureType AX_Namensnummer (ax_namensnummer) 0..1';
COMMENT ON COLUMN ax_namensnummer.hatvorgaenger IS 'Assoziation zu: FeatureType AX_Namensnummer (ax_namensnummer) 0..*';
COMMENT ON COLUMN ax_namensnummer.benennt IS 'Assoziation zu: FeatureType AX_Person (ax_person) 0..1';
CREATE TABLE ax_anschrift (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  bestimmungsland character varying,
  fax character varying[],
  hausnummer character varying,
  ort_amtlichesortsnamensverzeichnis character varying,
  ort_post character varying NOT NULL,
  ortsteil character varying,
  postfach character varying,
  postleitzahlpostfach character varying,
  postleitzahlpostzustellung character varying,
  statement character varying,
  ax_li_processstep_ohnedatenerhebung_description character varying[],
  processstep_rationale character varying[],
  processstep_datetime character(20)[],
  processstep_individualname character varying[],
  processstep_organisationname character varying[],
  processstep_positionname character varying[],
  processstep_phone character varying[],
  processstep_address character varying[],
  processstep_onlineresource character varying[],
  processstep_hoursofservice character varying[],
  processstep_contactinstructions character varying[],
  processstep_role character varying[],
  processstep_ax_datenerhebung character varying[],
  processstep_scaledenominator character varying[],
  processstep_sourcereferencesystem character varying[],
  processstep_sourceextent character varying[],
  processstep_sourcestep character varying[],
  herkunft_source_source_ax_datenerhebung character varying[],
  herkunft_source_source_scaledenominator character varying[],
  herkunft_source_source_sourcereferencesystem character varying[],
  herkunft_source_source_sourceextent character varying[],
  herkunft_source_source_sourcestep character varying[],
  strasse character varying,
  telefon character varying[],
  weitereadressen character varying[],
  istteilvon character(16)[],
  gehoertzu character(16)[],
  beziehtsichauf character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_anschrift_gml ON ax_anschrift USING btree (gml_id,beginnt);
CREATE INDEX ax_anschrift_endet ON ax_anschrift USING btree (endet);
CREATE INDEX ax_anschrift_gehoertzu ON ax_anschrift USING gin (gehoertzu);
CREATE INDEX ax_anschrift_beziehtsichauf ON ax_anschrift USING gin (beziehtsichauf);
CREATE INDEX ax_anschrift_istteilvon ON ax_anschrift USING gin (istteilvon);

COMMENT ON TABLE ax_anschrift IS 'FeatureType: "AX_Anschrift"';
COMMENT ON COLUMN ax_anschrift.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_anschrift.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_anschrift.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_anschrift.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_anschrift.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_anschrift.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_anschrift.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_anschrift.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_anschrift.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_anschrift.bestimmungsland IS 'bestimmungsland  CharacterString 0..1';
COMMENT ON COLUMN ax_anschrift.fax IS 'fax  CharacterString 0..*';
COMMENT ON COLUMN ax_anschrift.hausnummer IS 'hausnummer  CharacterString 0..1';
COMMENT ON COLUMN ax_anschrift.ort_amtlichesortsnamensverzeichnis IS 'ort_AmtlichesOrtsnamensverzeichnis  CharacterString 0..1';
COMMENT ON COLUMN ax_anschrift.ort_post IS 'ort_Post  CharacterString 1';
COMMENT ON COLUMN ax_anschrift.ortsteil IS 'ortsteil  CharacterString 0..1';
COMMENT ON COLUMN ax_anschrift.postfach IS 'postfach  CharacterString 0..1';
COMMENT ON COLUMN ax_anschrift.postleitzahlpostfach IS 'postleitzahlPostfach  CharacterString 0..1';
COMMENT ON COLUMN ax_anschrift.postleitzahlpostzustellung IS 'postleitzahlPostzustellung  CharacterString 0..1';
COMMENT ON COLUMN ax_anschrift.statement IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|statement|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_anschrift.ax_li_processstep_ohnedatenerhebung_description IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|description|AX_LI_ProcessStep_OhneDatenerhebung_Description enumeration  1';
COMMENT ON COLUMN ax_anschrift.processstep_rationale IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|rationale|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_anschrift.processstep_datetime IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|dateTime|DateTime  DateTime 0..1';
COMMENT ON COLUMN ax_anschrift.processstep_individualname IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|individualName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_anschrift.processstep_organisationname IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|organisationName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_anschrift.processstep_positionname IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|positionName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_anschrift.processstep_phone IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|phone|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_anschrift.processstep_address IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|address|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_anschrift.processstep_onlineresource IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|onlineResource|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_anschrift.processstep_hoursofservice IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|hoursOfService|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_anschrift.processstep_contactinstructions IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|contactInstructions|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_anschrift.processstep_role IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|role|CI_RoleCode enumeration CI_RoleCode 1';
COMMENT ON COLUMN ax_anschrift.processstep_ax_datenerhebung IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_anschrift.processstep_scaledenominator IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_anschrift.processstep_sourcereferencesystem IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_anschrift.processstep_sourceextent IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_anschrift.processstep_sourcestep IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_anschrift.herkunft_source_source_ax_datenerhebung IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_anschrift.herkunft_source_source_scaledenominator IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_anschrift.herkunft_source_source_sourcereferencesystem IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_anschrift.herkunft_source_source_sourceextent IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_anschrift.herkunft_source_source_sourcestep IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_anschrift.strasse IS 'strasse  CharacterString 0..1';
COMMENT ON COLUMN ax_anschrift.telefon IS 'telefon  CharacterString 0..*';
COMMENT ON COLUMN ax_anschrift.weitereadressen IS 'weitereAdressen  CharacterString 0..*';
COMMENT ON COLUMN ax_anschrift.gehoertzu IS 'Assoziation zu: FeatureType AX_Person (ax_person) 0..*';
COMMENT ON COLUMN ax_anschrift.beziehtsichauf IS 'Assoziation zu: FeatureType AX_Dienststelle (ax_dienststelle) 0..*';
CREATE TABLE ax_buchungsstelle (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  nenner double precision,
  zaehler double precision,
  beschreibungdessondereigentums character varying,
  beschreibungdesumfangsderbuchung character varying,
  buchungsart integer NOT NULL,
  buchungstext character varying,
  eingangdeseintragungsantrags date,
  laufendenummer character varying NOT NULL,
  nummerimaufteilungsplan character varying,
  zeitpunktdereintragung date,
  istteilvon character(16)[],
  istbestandteilvon character(16) NOT NULL,
  beziehtsichauf character(16)[],
  wirdverwaltetvon character(16)[],
  durch character(16)[],
  zu character(16)[],
  hatvorgaenger character(16)[],
  an character(16)[],
  verweistauf character(16)[],
  grundstueckbestehtaus character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_buchungsstelle_gml ON ax_buchungsstelle USING btree (gml_id,beginnt);
CREATE INDEX ax_buchungsstelle_endet ON ax_buchungsstelle USING btree (endet);
CREATE INDEX ax_buchungsstelle_istbestandteilvon ON ax_buchungsstelle USING btree (istbestandteilvon);
CREATE INDEX ax_buchungsstelle_beziehtsichauf ON ax_buchungsstelle USING gin (beziehtsichauf);
CREATE INDEX ax_buchungsstelle_wirdverwaltetvon ON ax_buchungsstelle USING gin (wirdverwaltetvon);
CREATE INDEX ax_buchungsstelle_durch ON ax_buchungsstelle USING gin (durch);
CREATE INDEX ax_buchungsstelle_zu ON ax_buchungsstelle USING gin (zu);
CREATE INDEX ax_buchungsstelle_hatvorgaenger ON ax_buchungsstelle USING gin (hatvorgaenger);
CREATE INDEX ax_buchungsstelle_an ON ax_buchungsstelle USING gin (an);
CREATE INDEX ax_buchungsstelle_verweistauf ON ax_buchungsstelle USING gin (verweistauf);
CREATE INDEX ax_buchungsstelle_grundstueckbestehtaus ON ax_buchungsstelle USING gin (grundstueckbestehtaus);
CREATE INDEX ax_buchungsstelle_istteilvon ON ax_buchungsstelle USING gin (istteilvon);

COMMENT ON TABLE ax_buchungsstelle IS 'FeatureType: "AX_Buchungsstelle"';
COMMENT ON COLUMN ax_buchungsstelle.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_buchungsstelle.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_buchungsstelle.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_buchungsstelle.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_buchungsstelle.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_buchungsstelle.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_buchungsstelle.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_buchungsstelle.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_buchungsstelle.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_buchungsstelle.nenner IS 'anteil|AX_Anteil|nenner  Real 1';
COMMENT ON COLUMN ax_buchungsstelle.zaehler IS 'anteil|AX_Anteil|zaehler  Real 1';
COMMENT ON COLUMN ax_buchungsstelle.beschreibungdessondereigentums IS 'beschreibungDesSondereigentums  CharacterString 0..1';
COMMENT ON COLUMN ax_buchungsstelle.beschreibungdesumfangsderbuchung IS 'beschreibungDesUmfangsDerBuchung  CharacterString 0..1';
COMMENT ON COLUMN ax_buchungsstelle.buchungsart IS 'buchungsart enumeration AX_Buchungsart_Buchungsstelle 1';
COMMENT ON COLUMN ax_buchungsstelle.buchungstext IS 'buchungstext  CharacterString 0..1';
COMMENT ON COLUMN ax_buchungsstelle.eingangdeseintragungsantrags IS 'eingangDesEintragungsantrags  Date 0..1';
COMMENT ON COLUMN ax_buchungsstelle.laufendenummer IS 'laufendeNummer  CharacterString 1';
COMMENT ON COLUMN ax_buchungsstelle.nummerimaufteilungsplan IS 'nummerImAufteilungsplan  CharacterString 0..1';
COMMENT ON COLUMN ax_buchungsstelle.zeitpunktdereintragung IS 'zeitpunktDerEintragung  Date 0..1';
COMMENT ON COLUMN ax_buchungsstelle.istbestandteilvon IS 'Assoziation zu: FeatureType AX_Buchungsblatt (ax_buchungsblatt) 1';
COMMENT ON COLUMN ax_buchungsstelle.beziehtsichauf IS 'Assoziation zu: FeatureType AX_Buchungsblatt (ax_buchungsblatt) 0..*';
COMMENT ON COLUMN ax_buchungsstelle.wirdverwaltetvon IS 'Assoziation zu: FeatureType AX_Verwaltung (ax_verwaltung) 0..*';
COMMENT ON COLUMN ax_buchungsstelle.durch IS 'Assoziation zu: FeatureType AX_Buchungsstelle (ax_buchungsstelle) 0..*';
COMMENT ON COLUMN ax_buchungsstelle.zu IS 'Assoziation zu: FeatureType AX_Buchungsstelle (ax_buchungsstelle) 0..*';
COMMENT ON COLUMN ax_buchungsstelle.hatvorgaenger IS 'Assoziation zu: FeatureType AX_Buchungsstelle (ax_buchungsstelle) 0..*';
COMMENT ON COLUMN ax_buchungsstelle.an IS 'Assoziation zu: FeatureType AX_Buchungsstelle (ax_buchungsstelle) 0..*';
COMMENT ON COLUMN ax_buchungsstelle.verweistauf IS 'Assoziation zu: FeatureType AX_Flurstueck (ax_flurstueck) 0..*';
COMMENT ON COLUMN ax_buchungsstelle.grundstueckbestehtaus IS 'Assoziation zu: FeatureType AX_Flurstueck (ax_flurstueck) 0..*';
CREATE TABLE ax_person (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  akademischergrad character varying,
  anrede integer,
  beruf character varying,
  geburtsdatum date,
  geburtsname character varying,
  haushaltsstellelandesgrundbesitz character varying,
  nachnameoderfirma character varying NOT NULL,
  namensbestandteil character varying,
  statement character varying,
  ax_li_processstep_ohnedatenerhebung_description character varying[],
  processstep_rationale character varying[],
  processstep_datetime character(20)[],
  processstep_individualname character varying[],
  processstep_organisationname character varying[],
  processstep_positionname character varying[],
  processstep_phone character varying[],
  processstep_address character varying[],
  processstep_onlineresource character varying[],
  processstep_hoursofservice character varying[],
  processstep_contactinstructions character varying[],
  processstep_role character varying[],
  processstep_ax_datenerhebung character varying[],
  processstep_scaledenominator character varying[],
  processstep_sourcereferencesystem character varying[],
  processstep_sourceextent character varying[],
  processstep_sourcestep character varying[],
  herkunft_source_source_ax_datenerhebung character varying[],
  herkunft_source_source_scaledenominator character varying[],
  herkunft_source_source_sourcereferencesystem character varying[],
  herkunft_source_source_sourceextent character varying[],
  herkunft_source_source_sourcestep character varying[],
  rufname character varying,
  sonstigeeigenschaften character varying,
  sterbedatum date,
  vorname character varying,
  wohnortodersitz character varying,
  istteilvon character(16)[],
  gehoertzu character(16)[],
  benennt character(16)[],
  uebtaus character(16)[],
  wirdvertretenvon character(16)[],
  weistauf character(16)[],
  hat character(16)[],
  zeigtauf character(16),
  besitzt character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_person_gml ON ax_person USING btree (gml_id,beginnt);
CREATE INDEX ax_person_endet ON ax_person USING btree (endet);
CREATE INDEX ax_person_gehoertzu ON ax_person USING gin (gehoertzu);
CREATE INDEX ax_person_benennt ON ax_person USING gin (benennt);
CREATE INDEX ax_person_uebtaus ON ax_person USING gin (uebtaus);
CREATE INDEX ax_person_wirdvertretenvon ON ax_person USING gin (wirdvertretenvon);
CREATE INDEX ax_person_weistauf ON ax_person USING gin (weistauf);
CREATE INDEX ax_person_hat ON ax_person USING gin (hat);
CREATE INDEX ax_person_zeigtauf ON ax_person USING btree (zeigtauf);
CREATE INDEX ax_person_besitzt ON ax_person USING gin (besitzt);
CREATE INDEX ax_person_istteilvon ON ax_person USING gin (istteilvon);

COMMENT ON TABLE ax_person IS 'FeatureType: "AX_Person"';
COMMENT ON COLUMN ax_person.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_person.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_person.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_person.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_person.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_person.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_person.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_person.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_person.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_person.akademischergrad IS 'akademischerGrad  CharacterString 0..1';
COMMENT ON COLUMN ax_person.anrede IS 'anrede enumeration AX_Anrede_Person 0..1';
COMMENT ON COLUMN ax_person.beruf IS 'beruf  CharacterString 0..1';
COMMENT ON COLUMN ax_person.geburtsdatum IS 'geburtsdatum  Date 0..1';
COMMENT ON COLUMN ax_person.geburtsname IS 'geburtsname  CharacterString 0..1';
COMMENT ON COLUMN ax_person.haushaltsstellelandesgrundbesitz IS 'haushaltsstelleLandesgrundbesitz  CharacterString 0..1';
COMMENT ON COLUMN ax_person.nachnameoderfirma IS 'nachnameOderFirma  CharacterString 1';
COMMENT ON COLUMN ax_person.namensbestandteil IS 'namensbestandteil  CharacterString 0..1';
COMMENT ON COLUMN ax_person.statement IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|statement|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_person.ax_li_processstep_ohnedatenerhebung_description IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|description|AX_LI_ProcessStep_OhneDatenerhebung_Description enumeration  1';
COMMENT ON COLUMN ax_person.processstep_rationale IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|rationale|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_person.processstep_datetime IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|dateTime|DateTime  DateTime 0..1';
COMMENT ON COLUMN ax_person.processstep_individualname IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|individualName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_person.processstep_organisationname IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|organisationName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_person.processstep_positionname IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|positionName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_person.processstep_phone IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|phone|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_person.processstep_address IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|address|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_person.processstep_onlineresource IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|onlineResource|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_person.processstep_hoursofservice IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|hoursOfService|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_person.processstep_contactinstructions IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|contactInstructions|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_person.processstep_role IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|role|CI_RoleCode enumeration CI_RoleCode 1';
COMMENT ON COLUMN ax_person.processstep_ax_datenerhebung IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_person.processstep_scaledenominator IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_person.processstep_sourcereferencesystem IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_person.processstep_sourceextent IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_person.processstep_sourcestep IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_person.herkunft_source_source_ax_datenerhebung IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_person.herkunft_source_source_scaledenominator IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_person.herkunft_source_source_sourcereferencesystem IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_person.herkunft_source_source_sourceextent IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_person.herkunft_source_source_sourcestep IS 'qualitaetsangaben|AX_DQOhneDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_person.rufname IS 'rufname  CharacterString 0..1';
COMMENT ON COLUMN ax_person.sonstigeeigenschaften IS 'sonstigeEigenschaften  CharacterString 0..1';
COMMENT ON COLUMN ax_person.sterbedatum IS 'sterbedatum  Date 0..1';
COMMENT ON COLUMN ax_person.vorname IS 'vorname  CharacterString 0..1';
COMMENT ON COLUMN ax_person.wohnortodersitz IS 'wohnortOderSitz  CharacterString 0..1';
COMMENT ON COLUMN ax_person.gehoertzu IS 'Assoziation zu: FeatureType AX_Personengruppe (ax_personengruppe) 0..*';
COMMENT ON COLUMN ax_person.benennt IS 'Assoziation zu: FeatureType AX_Verwaltung (ax_verwaltung) 0..*';
COMMENT ON COLUMN ax_person.uebtaus IS 'Assoziation zu: FeatureType AX_Vertretung (ax_vertretung) 0..*';
COMMENT ON COLUMN ax_person.wirdvertretenvon IS 'Assoziation zu: FeatureType AX_Vertretung (ax_vertretung) 0..*';
COMMENT ON COLUMN ax_person.weistauf IS 'Assoziation zu: FeatureType AX_Namensnummer (ax_namensnummer) 0..*';
COMMENT ON COLUMN ax_person.hat IS 'Assoziation zu: FeatureType AX_Anschrift (ax_anschrift) 0..*';
COMMENT ON COLUMN ax_person.zeigtauf IS 'Assoziation zu: FeatureType AX_Person (ax_person) 0..1';
COMMENT ON COLUMN ax_person.besitzt IS 'Assoziation zu: FeatureType AX_Gebaeude (ax_gebaeude) 0..*';
CREATE TABLE ax_skizze (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  bemerkungen character varying,
  skizzenart integer,
  skizzenname character varying NOT NULL,
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_skizze_gml ON ax_skizze USING btree (gml_id,beginnt);
CREATE INDEX ax_skizze_endet ON ax_skizze USING btree (endet);
CREATE INDEX ax_skizze_istteilvon ON ax_skizze USING gin (istteilvon);

COMMENT ON TABLE ax_skizze IS 'FeatureType: "AX_Skizze"';
COMMENT ON COLUMN ax_skizze.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_skizze.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_skizze.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_skizze.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_skizze.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_skizze.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_skizze.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_skizze.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_skizze.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_skizze.bemerkungen IS 'bemerkungen  CharacterString 0..1';
COMMENT ON COLUMN ax_skizze.skizzenart IS 'skizzenart enumeration AX_Skizzenart_Skizze 0..1';
COMMENT ON COLUMN ax_skizze.skizzenname IS 'skizzenname  URI 1';
CREATE TABLE ax_historischesflurstueckohneraumbezug (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  abweichenderrechtszustand character varying,
  amtlicheflaeche double precision NOT NULL,
  flurnummer integer,
  flurstuecksfolge character varying,
  flurstueckskennzeichen character varying NOT NULL,
  nenner character varying,
  zaehler character varying NOT NULL,
  gemarkungsnummer character varying NOT NULL,
  land character varying NOT NULL,
  gemeindezugehoerigkeit_gemeinde character varying NOT NULL,
  gemeindezugehoerigkeit_gemeindeteil character varying,
  gemeindezugehoerigkeit_kreis character varying NOT NULL,
  gemeindezugehoerigkeit_land character varying NOT NULL,
  gemeindezugehoerigkeit_regierungsbezirk character varying,
  nachfolgerflurstueckskennzeichen character varying[],
  rechtsbehelfsverfahren character varying,
  angabenzumabschnittbemerkung character varying[],
  angabenzumabschnittflurstueck character varying[],
  angabenzumabschnittnummeraktenzeichen character varying[],
  angabenzumabschnittstelle character varying[],
  flaechedesabschnitts double precision[],
  kennungschluessel character varying[],
  vorgaengerflurstueckskennzeichen character varying[],
  zeitpunktderentstehung date,
  zweifelhafterflurstuecksnachweis character varying,
  istteilvon character(16)[],
  isthistgebucht character(16),
  gehoertanteiligzu character(16)[],
  zeigtauf character(16)[],
  weistauf character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_historischesflurstueckohneraumbezug_gml ON ax_historischesflurstueckohneraumbezug USING btree (gml_id,beginnt);
CREATE INDEX ax_historischesflurstueckohneraumbezug_endet ON ax_historischesflurstueckohneraumbezug USING btree (endet);
SELECT AddGeometryColumn('ax_historischesflurstueckohneraumbezug', 'objektkoordinaten', :alkis_epsg, 'POINT', 2);
CREATE INDEX ax_historischesflurstueckohneraumbezug_objektkoordinate1 ON ax_historischesflurstueckohneraumbezug USING gist (objektkoordinaten);
CREATE INDEX ax_historischesflurstueckohneraumbezug_isthistgebucht ON ax_historischesflurstueckohneraumbezug USING btree (isthistgebucht);
CREATE INDEX ax_historischesflurstueckohneraumbezug_gehoertanteiligzu ON ax_historischesflurstueckohneraumbezug USING gin (gehoertanteiligzu);
CREATE INDEX ax_historischesflurstueckohneraumbezug_zeigtauf ON ax_historischesflurstueckohneraumbezug USING gin (zeigtauf);
CREATE INDEX ax_historischesflurstueckohneraumbezug_weistauf ON ax_historischesflurstueckohneraumbezug USING gin (weistauf);
CREATE INDEX ax_historischesflurstueckohneraumbezug_istteilvon ON ax_historischesflurstueckohneraumbezug USING gin (istteilvon);

COMMENT ON TABLE ax_historischesflurstueckohneraumbezug IS 'FeatureType: "AX_HistorischesFlurstueckOhneRaumbezug"';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.abweichenderrechtszustand IS 'abweichenderRechtszustand  Boolean 0..1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.amtlicheflaeche IS 'amtlicheFlaeche  Area 1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.flurnummer IS 'flurnummer  Integer 0..1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.flurstuecksfolge IS 'flurstuecksfolge  CharacterString 0..1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.flurstueckskennzeichen IS 'flurstueckskennzeichen  CharacterString 1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.nenner IS 'flurstuecksnummer|AX_Flurstuecksnummer|nenner  CharacterString 0..1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.zaehler IS 'flurstuecksnummer|AX_Flurstuecksnummer|zaehler  CharacterString 1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.gemarkungsnummer IS 'gemarkung|AX_Gemarkung_Schluessel|gemarkungsnummer  CharacterString 1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.land IS 'gemarkung|AX_Gemarkung_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.gemeindezugehoerigkeit_gemeinde IS 'gemeindezugehoerigkeit|AX_Gemeindekennzeichen|gemeinde  CharacterString 1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.gemeindezugehoerigkeit_gemeindeteil IS 'gemeindezugehoerigkeit|AX_Gemeindekennzeichen|gemeindeteil  CharacterString 0..1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.gemeindezugehoerigkeit_kreis IS 'gemeindezugehoerigkeit|AX_Gemeindekennzeichen|kreis  CharacterString 1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.gemeindezugehoerigkeit_land IS 'gemeindezugehoerigkeit|AX_Gemeindekennzeichen|land  CharacterString 1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.gemeindezugehoerigkeit_regierungsbezirk IS 'gemeindezugehoerigkeit|AX_Gemeindekennzeichen|regierungsbezirk  CharacterString 0..1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.nachfolgerflurstueckskennzeichen IS 'nachfolgerFlurstueckskennzeichen  CharacterString 0..*';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.objektkoordinaten IS 'objektkoordinaten  GM_Point 0..1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.rechtsbehelfsverfahren IS 'rechtsbehelfsverfahren  Boolean 0..1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.angabenzumabschnittbemerkung IS 'sonstigeEigenschaften|AX_SonstigeEigenschaften_Flurstueck|angabenZumAbschnittBemerkung  CharacterString 0..1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.angabenzumabschnittflurstueck IS 'sonstigeEigenschaften|AX_SonstigeEigenschaften_Flurstueck|angabenZumAbschnittFlurstueck  CharacterString 0..1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.angabenzumabschnittnummeraktenzeichen IS 'sonstigeEigenschaften|AX_SonstigeEigenschaften_Flurstueck|angabenZumAbschnittNummerAktenzeichen  CharacterString 0..1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.angabenzumabschnittstelle IS 'sonstigeEigenschaften|AX_SonstigeEigenschaften_Flurstueck|angabenZumAbschnittStelle  CharacterString 0..1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.flaechedesabschnitts IS 'sonstigeEigenschaften|AX_SonstigeEigenschaften_Flurstueck|flaecheDesAbschnitts  Area 0..1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.kennungschluessel IS 'sonstigeEigenschaften|AX_SonstigeEigenschaften_Flurstueck|kennungSchluessel  CharacterString 0..1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.vorgaengerflurstueckskennzeichen IS 'vorgaengerFlurstueckskennzeichen  CharacterString 0..*';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.zeitpunktderentstehung IS 'zeitpunktDerEntstehung  Date 0..1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.zweifelhafterflurstuecksnachweis IS 'zweifelhafterFlurstuecksnachweis  Boolean 0..1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.isthistgebucht IS 'Assoziation zu: FeatureType AX_Buchungsstelle (ax_buchungsstelle) 0..1';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.gehoertanteiligzu IS 'Assoziation zu: FeatureType AX_HistorischesFlurstueckOhneRaumbezug (ax_historischesflurstueckohneraumbezug) 0..*';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.zeigtauf IS 'Assoziation zu: FeatureType AX_LagebezeichnungOhneHausnummer (ax_lagebezeichnungohnehausnummer) 0..*';
COMMENT ON COLUMN ax_historischesflurstueckohneraumbezug.weistauf IS 'Assoziation zu: FeatureType AX_LagebezeichnungMitHausnummer (ax_lagebezeichnungmithausnummer) 0..*';
CREATE TABLE ax_historischesflurstueckalb (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  amtlicheflaeche double precision NOT NULL,
  blattart integer[],
  buchungsart character varying[],
  buchungsblattbezirk_bezirk character varying[],
  buchungsblattbezirk_land character varying[],
  buchungsblattkennzeichen character varying[],
  buchungsblattnummermitbuchstabenerweiterung character varying[],
  laufendenummerderbuchungsstelle character varying[],
  flurnummer integer,
  flurstuecksfolge character varying,
  flurstueckskennzeichen character varying NOT NULL,
  nenner character varying,
  zaehler character varying NOT NULL,
  fortfuehrungsart character varying,
  gemarkungsnummer character varying NOT NULL,
  land character varying NOT NULL,
  laufendenummerderfortfuehrung character varying,
  nachfolgerflurstueckskennzeichen character varying[],
  vorgaengerflurstueckskennzeichen character varying[],
  zeitpunktderentstehungdesbezugsflurstuecks date,
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_historischesflurstueckalb_gml ON ax_historischesflurstueckalb USING btree (gml_id,beginnt);
CREATE INDEX ax_historischesflurstueckalb_endet ON ax_historischesflurstueckalb USING btree (endet);
SELECT AddGeometryColumn('ax_historischesflurstueckalb', 'objektkoordinaten', :alkis_epsg, 'POINT', 2);
CREATE INDEX ax_historischesflurstueckalb_objektkoordinaten_idx ON ax_historischesflurstueckalb USING gist (objektkoordinaten);
CREATE INDEX ax_historischesflurstueckalb_istteilvon ON ax_historischesflurstueckalb USING gin (istteilvon);

COMMENT ON TABLE ax_historischesflurstueckalb IS 'FeatureType: "AX_HistorischesFlurstueckALB"';
COMMENT ON COLUMN ax_historischesflurstueckalb.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_historischesflurstueckalb.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_historischesflurstueckalb.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_historischesflurstueckalb.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_historischesflurstueckalb.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_historischesflurstueckalb.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_historischesflurstueckalb.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_historischesflurstueckalb.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_historischesflurstueckalb.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_historischesflurstueckalb.amtlicheflaeche IS 'amtlicheFlaeche  Area 1';
COMMENT ON COLUMN ax_historischesflurstueckalb.blattart IS 'buchung|AX_Buchung_HistorischesFlurstueck|blattart enumeration AX_Blattart_HistorischesFlurstueck 1';
COMMENT ON COLUMN ax_historischesflurstueckalb.buchungsart IS 'buchung|AX_Buchung_HistorischesFlurstueck|buchungsart  CharacterString 1';
COMMENT ON COLUMN ax_historischesflurstueckalb.buchungsblattbezirk_bezirk IS 'buchung|AX_Buchung_HistorischesFlurstueck|buchungsblattbezirk|AX_Buchungsblattbezirk_Schluessel|bezirk  CharacterString 1';
COMMENT ON COLUMN ax_historischesflurstueckalb.buchungsblattbezirk_land IS 'buchung|AX_Buchung_HistorischesFlurstueck|buchungsblattbezirk|AX_Buchungsblattbezirk_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_historischesflurstueckalb.buchungsblattkennzeichen IS 'buchung|AX_Buchung_HistorischesFlurstueck|buchungsblattkennzeichen  CharacterString 1';
COMMENT ON COLUMN ax_historischesflurstueckalb.buchungsblattnummermitbuchstabenerweiterung IS 'buchung|AX_Buchung_HistorischesFlurstueck|buchungsblattnummerMitBuchstabenerweiterung  CharacterString 1';
COMMENT ON COLUMN ax_historischesflurstueckalb.laufendenummerderbuchungsstelle IS 'buchung|AX_Buchung_HistorischesFlurstueck|laufendeNummerDerBuchungsstelle  CharacterString 1';
COMMENT ON COLUMN ax_historischesflurstueckalb.flurnummer IS 'flurnummer  Integer 0..1';
COMMENT ON COLUMN ax_historischesflurstueckalb.flurstuecksfolge IS 'flurstuecksfolge  CharacterString 0..1';
COMMENT ON COLUMN ax_historischesflurstueckalb.flurstueckskennzeichen IS 'flurstueckskennzeichen  CharacterString 1';
COMMENT ON COLUMN ax_historischesflurstueckalb.nenner IS 'flurstuecksnummer|AX_Flurstuecksnummer|nenner  CharacterString 0..1';
COMMENT ON COLUMN ax_historischesflurstueckalb.zaehler IS 'flurstuecksnummer|AX_Flurstuecksnummer|zaehler  CharacterString 1';
COMMENT ON COLUMN ax_historischesflurstueckalb.fortfuehrungsart IS 'fortfuehrungsart  CharacterString 0..1';
COMMENT ON COLUMN ax_historischesflurstueckalb.gemarkungsnummer IS 'gemarkung|AX_Gemarkung_Schluessel|gemarkungsnummer  CharacterString 1';
COMMENT ON COLUMN ax_historischesflurstueckalb.land IS 'gemarkung|AX_Gemarkung_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_historischesflurstueckalb.laufendenummerderfortfuehrung IS 'laufendeNummerDerFortfuehrung  CharacterString 0..1';
COMMENT ON COLUMN ax_historischesflurstueckalb.nachfolgerflurstueckskennzeichen IS 'nachfolgerFlurstueckskennzeichen  CharacterString 0..*';
COMMENT ON COLUMN ax_historischesflurstueckalb.objektkoordinaten IS 'objektkoordinaten  GM_Point 0..1';
COMMENT ON COLUMN ax_historischesflurstueckalb.vorgaengerflurstueckskennzeichen IS 'vorgaengerFlurstueckskennzeichen  CharacterString 0..*';
COMMENT ON COLUMN ax_historischesflurstueckalb.zeitpunktderentstehungdesbezugsflurstuecks IS 'zeitpunktDerEntstehungDesBezugsflurstuecks  Date 0..1';
CREATE TABLE ax_lagebezeichnungohnehausnummer (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  unverschluesselt character varying,
  gemeinde character varying,
  kreis character varying,
  lage character varying,
  land character varying,
  regierungsbezirk character varying,
  ortsteil character varying,
  zusatzzurlagebezeichnung character varying,
  istteilvon character(16)[],
  beschreibt character(16)[],
  gehoertauchzu character(16),
  gehoertzu character(16)[],
  gehoertzuohne character(16),
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_lagebezeichnungohnehausnummer_gml ON ax_lagebezeichnungohnehausnummer USING btree (gml_id,beginnt);
CREATE INDEX ax_lagebezeichnungohnehausnummer_endet ON ax_lagebezeichnungohnehausnummer USING btree (endet);
CREATE INDEX ax_lagebezeichnungohnehausnummer_beschreibt ON ax_lagebezeichnungohnehausnummer USING gin (beschreibt);
CREATE INDEX ax_lagebezeichnungohnehausnummer_gehoertauchzu ON ax_lagebezeichnungohnehausnummer USING btree (gehoertauchzu);
CREATE INDEX ax_lagebezeichnungohnehausnummer_gehoertzu ON ax_lagebezeichnungohnehausnummer USING gin (gehoertzu);
CREATE INDEX ax_lagebezeichnungohnehausnummer_gehoertzuohne ON ax_lagebezeichnungohnehausnummer USING btree (gehoertzuohne);
CREATE INDEX ax_lagebezeichnungohnehausnummer_istteilvon ON ax_lagebezeichnungohnehausnummer USING gin (istteilvon);

COMMENT ON TABLE ax_lagebezeichnungohnehausnummer IS 'FeatureType: "AX_LagebezeichnungOhneHausnummer"';
COMMENT ON COLUMN ax_lagebezeichnungohnehausnummer.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_lagebezeichnungohnehausnummer.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_lagebezeichnungohnehausnummer.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_lagebezeichnungohnehausnummer.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_lagebezeichnungohnehausnummer.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_lagebezeichnungohnehausnummer.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_lagebezeichnungohnehausnummer.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_lagebezeichnungohnehausnummer.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_lagebezeichnungohnehausnummer.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_lagebezeichnungohnehausnummer.unverschluesselt IS 'lagebezeichnung|AX_Lagebezeichnung|unverschluesselt  CharacterString 0..1';
COMMENT ON COLUMN ax_lagebezeichnungohnehausnummer.gemeinde IS 'lagebezeichnung|AX_Lagebezeichnung|verschluesselt|AX_VerschluesselteLagebezeichnung|gemeinde  CharacterString 1';
COMMENT ON COLUMN ax_lagebezeichnungohnehausnummer.kreis IS 'lagebezeichnung|AX_Lagebezeichnung|verschluesselt|AX_VerschluesselteLagebezeichnung|kreis  CharacterString 1';
COMMENT ON COLUMN ax_lagebezeichnungohnehausnummer.lage IS 'lagebezeichnung|AX_Lagebezeichnung|verschluesselt|AX_VerschluesselteLagebezeichnung|lage  CharacterString 1';
COMMENT ON COLUMN ax_lagebezeichnungohnehausnummer.land IS 'lagebezeichnung|AX_Lagebezeichnung|verschluesselt|AX_VerschluesselteLagebezeichnung|land  CharacterString 1';
COMMENT ON COLUMN ax_lagebezeichnungohnehausnummer.regierungsbezirk IS 'lagebezeichnung|AX_Lagebezeichnung|verschluesselt|AX_VerschluesselteLagebezeichnung|regierungsbezirk  CharacterString 0..1';
COMMENT ON COLUMN ax_lagebezeichnungohnehausnummer.ortsteil IS 'ortsteil  CharacterString 0..1';
COMMENT ON COLUMN ax_lagebezeichnungohnehausnummer.zusatzzurlagebezeichnung IS 'zusatzZurLagebezeichnung  CharacterString 0..1';
COMMENT ON COLUMN ax_lagebezeichnungohnehausnummer.beschreibt IS 'Assoziation zu: FeatureType AX_HistorischesFlurstueckOhneRaumbezug (ax_historischesflurstueckohneraumbezug) 0..*';
COMMENT ON COLUMN ax_lagebezeichnungohnehausnummer.gehoertauchzu IS 'Assoziation zu: FeatureType AX_GeoreferenzierteGebaeudeadresse (ax_georeferenziertegebaeudeadresse) 0..1';
COMMENT ON COLUMN ax_lagebezeichnungohnehausnummer.gehoertzu IS 'Assoziation zu: FeatureType AX_Flurstueck (ax_flurstueck) 0..*';
COMMENT ON COLUMN ax_lagebezeichnungohnehausnummer.gehoertzuohne IS 'Assoziation zu: FeatureType AX_Gebaeude (ax_gebaeude) 0..1';
CREATE TABLE ax_lagebezeichnungmitpseudonummer (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  unverschluesselt character varying,
  gemeinde character varying,
  kreis character varying,
  lage character varying,
  land character varying,
  regierungsbezirk character varying,
  laufendenummer character varying,
  ortsteil character varying,
  pseudonummer character varying NOT NULL,
  istteilvon character(16)[],
  gehoertzupseudo character(16),
  gehoertzu character(16),
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_lagebezeichnungmitpseudonummer_gml ON ax_lagebezeichnungmitpseudonummer USING btree (gml_id,beginnt);
CREATE INDEX ax_lagebezeichnungmitpseudonummer_endet ON ax_lagebezeichnungmitpseudonummer USING btree (endet);
CREATE INDEX ax_lagebezeichnungmitpseudonummer_gehoertzupseudo ON ax_lagebezeichnungmitpseudonummer USING btree (gehoertzupseudo);
CREATE INDEX ax_lagebezeichnungmitpseudonummer_gehoertzu ON ax_lagebezeichnungmitpseudonummer USING btree (gehoertzu);
CREATE INDEX ax_lagebezeichnungmitpseudonummer_istteilvon ON ax_lagebezeichnungmitpseudonummer USING gin (istteilvon);

COMMENT ON TABLE ax_lagebezeichnungmitpseudonummer IS 'FeatureType: "AX_LagebezeichnungMitPseudonummer"';
COMMENT ON COLUMN ax_lagebezeichnungmitpseudonummer.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_lagebezeichnungmitpseudonummer.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_lagebezeichnungmitpseudonummer.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_lagebezeichnungmitpseudonummer.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_lagebezeichnungmitpseudonummer.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_lagebezeichnungmitpseudonummer.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_lagebezeichnungmitpseudonummer.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_lagebezeichnungmitpseudonummer.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_lagebezeichnungmitpseudonummer.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_lagebezeichnungmitpseudonummer.unverschluesselt IS 'lagebezeichnung|AX_Lagebezeichnung|unverschluesselt  CharacterString 0..1';
COMMENT ON COLUMN ax_lagebezeichnungmitpseudonummer.gemeinde IS 'lagebezeichnung|AX_Lagebezeichnung|verschluesselt|AX_VerschluesselteLagebezeichnung|gemeinde  CharacterString 1';
COMMENT ON COLUMN ax_lagebezeichnungmitpseudonummer.kreis IS 'lagebezeichnung|AX_Lagebezeichnung|verschluesselt|AX_VerschluesselteLagebezeichnung|kreis  CharacterString 1';
COMMENT ON COLUMN ax_lagebezeichnungmitpseudonummer.lage IS 'lagebezeichnung|AX_Lagebezeichnung|verschluesselt|AX_VerschluesselteLagebezeichnung|lage  CharacterString 1';
COMMENT ON COLUMN ax_lagebezeichnungmitpseudonummer.land IS 'lagebezeichnung|AX_Lagebezeichnung|verschluesselt|AX_VerschluesselteLagebezeichnung|land  CharacterString 1';
COMMENT ON COLUMN ax_lagebezeichnungmitpseudonummer.regierungsbezirk IS 'lagebezeichnung|AX_Lagebezeichnung|verschluesselt|AX_VerschluesselteLagebezeichnung|regierungsbezirk  CharacterString 0..1';
COMMENT ON COLUMN ax_lagebezeichnungmitpseudonummer.laufendenummer IS 'laufendeNummer  CharacterString 0..1';
COMMENT ON COLUMN ax_lagebezeichnungmitpseudonummer.ortsteil IS 'ortsteil  CharacterString 0..1';
COMMENT ON COLUMN ax_lagebezeichnungmitpseudonummer.pseudonummer IS 'pseudonummer  CharacterString 1';
COMMENT ON COLUMN ax_lagebezeichnungmitpseudonummer.gehoertzupseudo IS 'Assoziation zu: FeatureType AX_GeoreferenzierteGebaeudeadresse (ax_georeferenziertegebaeudeadresse) 0..1';
COMMENT ON COLUMN ax_lagebezeichnungmitpseudonummer.gehoertzu IS 'Assoziation zu: FeatureType AX_Gebaeude (ax_gebaeude) 0..1';
CREATE TABLE ax_lagebezeichnungmithausnummer (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  unverschluesselt character varying,
  gemeinde character varying,
  kreis character varying,
  lage character varying,
  land character varying,
  regierungsbezirk character varying,
  hausnummer character varying NOT NULL,
  ortsteil character varying,
  istteilvon character(16)[],
  weistzum character(16),
  hat character(16)[],
  beziehtsichauchauf character(16),
  gehoertzu character(16)[],
  beziehtsichauf character(16),
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_lagebezeichnungmithausnummer_gml ON ax_lagebezeichnungmithausnummer USING btree (gml_id,beginnt);
CREATE INDEX ax_lagebezeichnungmithausnummer_endet ON ax_lagebezeichnungmithausnummer USING btree (endet);
CREATE INDEX ax_lagebezeichnungmithausnummer_weistzum ON ax_lagebezeichnungmithausnummer USING btree (weistzum);
CREATE INDEX ax_lagebezeichnungmithausnummer_hat ON ax_lagebezeichnungmithausnummer USING gin (hat);
CREATE INDEX ax_lagebezeichnungmithausnummer_beziehtsichauchauf ON ax_lagebezeichnungmithausnummer USING btree (beziehtsichauchauf);
CREATE INDEX ax_lagebezeichnungmithausnummer_gehoertzu ON ax_lagebezeichnungmithausnummer USING gin (gehoertzu);
CREATE INDEX ax_lagebezeichnungmithausnummer_beziehtsichauf ON ax_lagebezeichnungmithausnummer USING btree (beziehtsichauf);
CREATE INDEX ax_lagebezeichnungmithausnummer_istteilvon ON ax_lagebezeichnungmithausnummer USING gin (istteilvon);

COMMENT ON TABLE ax_lagebezeichnungmithausnummer IS 'FeatureType: "AX_LagebezeichnungMitHausnummer"';
COMMENT ON COLUMN ax_lagebezeichnungmithausnummer.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_lagebezeichnungmithausnummer.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_lagebezeichnungmithausnummer.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_lagebezeichnungmithausnummer.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_lagebezeichnungmithausnummer.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_lagebezeichnungmithausnummer.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_lagebezeichnungmithausnummer.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_lagebezeichnungmithausnummer.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_lagebezeichnungmithausnummer.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_lagebezeichnungmithausnummer.unverschluesselt IS 'lagebezeichnung|AX_Lagebezeichnung|unverschluesselt  CharacterString 0..1';
COMMENT ON COLUMN ax_lagebezeichnungmithausnummer.gemeinde IS 'lagebezeichnung|AX_Lagebezeichnung|verschluesselt|AX_VerschluesselteLagebezeichnung|gemeinde  CharacterString 1';
COMMENT ON COLUMN ax_lagebezeichnungmithausnummer.kreis IS 'lagebezeichnung|AX_Lagebezeichnung|verschluesselt|AX_VerschluesselteLagebezeichnung|kreis  CharacterString 1';
COMMENT ON COLUMN ax_lagebezeichnungmithausnummer.lage IS 'lagebezeichnung|AX_Lagebezeichnung|verschluesselt|AX_VerschluesselteLagebezeichnung|lage  CharacterString 1';
COMMENT ON COLUMN ax_lagebezeichnungmithausnummer.land IS 'lagebezeichnung|AX_Lagebezeichnung|verschluesselt|AX_VerschluesselteLagebezeichnung|land  CharacterString 1';
COMMENT ON COLUMN ax_lagebezeichnungmithausnummer.regierungsbezirk IS 'lagebezeichnung|AX_Lagebezeichnung|verschluesselt|AX_VerschluesselteLagebezeichnung|regierungsbezirk  CharacterString 0..1';
COMMENT ON COLUMN ax_lagebezeichnungmithausnummer.hausnummer IS 'hausnummer  CharacterString 1';
COMMENT ON COLUMN ax_lagebezeichnungmithausnummer.ortsteil IS 'ortsteil  CharacterString 0..1';
COMMENT ON COLUMN ax_lagebezeichnungmithausnummer.weistzum IS 'Assoziation zu: FeatureType AX_Turm (ax_turm) 0..1';
COMMENT ON COLUMN ax_lagebezeichnungmithausnummer.hat IS 'Assoziation zu: FeatureType AX_HistorischesFlurstueckOhneRaumbezug (ax_historischesflurstueckohneraumbezug) 0..*';
COMMENT ON COLUMN ax_lagebezeichnungmithausnummer.beziehtsichauchauf IS 'Assoziation zu: FeatureType AX_GeoreferenzierteGebaeudeadresse (ax_georeferenziertegebaeudeadresse) 0..1';
COMMENT ON COLUMN ax_lagebezeichnungmithausnummer.gehoertzu IS 'Assoziation zu: FeatureType AX_Flurstueck (ax_flurstueck) 0..*';
COMMENT ON COLUMN ax_lagebezeichnungmithausnummer.beziehtsichauf IS 'Assoziation zu: FeatureType AX_Gebaeude (ax_gebaeude) 0..1';
CREATE TABLE ax_reservierung (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  ablaufderreservierung date,
  antragsnummer character varying,
  art integer NOT NULL,
  auftragsnummer character varying,
  buchungsblattbezirk_bezirk character varying,
  buchungsblattbezirk_land character varying,
  flur_gemarkung character varying,
  flur_gemarkungsteilflur character varying,
  flur_land character varying,
  gemarkung_gemarkungsnummer character varying,
  gemarkung_land character varying,
  nummer character varying NOT NULL,
  nummerierungsbezirk character varying,
  land character varying NOT NULL,
  stelle character varying NOT NULL,
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_reservierung_gml ON ax_reservierung USING btree (gml_id,beginnt);
CREATE INDEX ax_reservierung_endet ON ax_reservierung USING btree (endet);
CREATE INDEX ax_reservierung_istteilvon ON ax_reservierung USING gin (istteilvon);

COMMENT ON TABLE ax_reservierung IS 'FeatureType: "AX_Reservierung"';
COMMENT ON COLUMN ax_reservierung.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_reservierung.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_reservierung.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_reservierung.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_reservierung.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_reservierung.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_reservierung.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_reservierung.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_reservierung.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_reservierung.ablaufderreservierung IS 'ablaufDerReservierung  Date 0..1';
COMMENT ON COLUMN ax_reservierung.antragsnummer IS 'antragsnummer  CharacterString 0..1';
COMMENT ON COLUMN ax_reservierung.art IS 'art enumeration AX_Art_Reservierung 1';
COMMENT ON COLUMN ax_reservierung.auftragsnummer IS 'auftragsnummer  CharacterString 0..1';
COMMENT ON COLUMN ax_reservierung.buchungsblattbezirk_bezirk IS 'gebietskennung|AX_Reservierungsauftrag_Gebietskennung|buchungsblattbezirk|AX_Buchungsblattbezirk_Schluessel|bezirk  CharacterString 1';
COMMENT ON COLUMN ax_reservierung.buchungsblattbezirk_land IS 'gebietskennung|AX_Reservierungsauftrag_Gebietskennung|buchungsblattbezirk|AX_Buchungsblattbezirk_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_reservierung.flur_gemarkung IS 'gebietskennung|AX_Reservierungsauftrag_Gebietskennung|flur|AX_GemarkungsteilFlur_Schluessel|gemarkung  CharacterString 1';
COMMENT ON COLUMN ax_reservierung.flur_gemarkungsteilflur IS 'gebietskennung|AX_Reservierungsauftrag_Gebietskennung|flur|AX_GemarkungsteilFlur_Schluessel|gemarkungsteilFlur  CharacterString 1';
COMMENT ON COLUMN ax_reservierung.flur_land IS 'gebietskennung|AX_Reservierungsauftrag_Gebietskennung|flur|AX_GemarkungsteilFlur_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_reservierung.gemarkung_gemarkungsnummer IS 'gebietskennung|AX_Reservierungsauftrag_Gebietskennung|gemarkung|AX_Gemarkung_Schluessel|gemarkungsnummer  CharacterString 1';
COMMENT ON COLUMN ax_reservierung.gemarkung_land IS 'gebietskennung|AX_Reservierungsauftrag_Gebietskennung|gemarkung|AX_Gemarkung_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_reservierung.nummer IS 'nummer  CharacterString 1';
COMMENT ON COLUMN ax_reservierung.nummerierungsbezirk IS 'nummerierungsbezirk  CharacterString 0..1';
COMMENT ON COLUMN ax_reservierung.land IS 'vermessungsstelle|AX_Dienststelle_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_reservierung.stelle IS 'vermessungsstelle|AX_Dienststelle_Schluessel|stelle  CharacterString 1';
CREATE TABLE ax_punktkennungvergleichend (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  antragsnummer character varying NOT NULL,
  art integer,
  endgueltigepunktkennung character varying NOT NULL,
  vorlaeufigepunktkennung character varying NOT NULL,
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_punktkennungvergleichend_gml ON ax_punktkennungvergleichend USING btree (gml_id,beginnt);
CREATE INDEX ax_punktkennungvergleichend_endet ON ax_punktkennungvergleichend USING btree (endet);
CREATE INDEX ax_punktkennungvergleichend_istteilvon ON ax_punktkennungvergleichend USING gin (istteilvon);

COMMENT ON TABLE ax_punktkennungvergleichend IS 'FeatureType: "AX_PunktkennungVergleichend"';
COMMENT ON COLUMN ax_punktkennungvergleichend.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_punktkennungvergleichend.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_punktkennungvergleichend.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_punktkennungvergleichend.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_punktkennungvergleichend.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_punktkennungvergleichend.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_punktkennungvergleichend.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_punktkennungvergleichend.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_punktkennungvergleichend.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_punktkennungvergleichend.antragsnummer IS 'antragsnummer  CharacterString 1';
COMMENT ON COLUMN ax_punktkennungvergleichend.art IS 'art enumeration AX_Art_Punktkennung 0..1';
COMMENT ON COLUMN ax_punktkennungvergleichend.endgueltigepunktkennung IS 'endgueltigePunktkennung  CharacterString 1';
COMMENT ON COLUMN ax_punktkennungvergleichend.vorlaeufigepunktkennung IS 'vorlaeufigePunktkennung  CharacterString 1';
CREATE TABLE ax_punktkennunguntergegangen (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  art integer,
  punktkennung character varying NOT NULL,
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_punktkennunguntergegangen_gml ON ax_punktkennunguntergegangen USING btree (gml_id,beginnt);
CREATE INDEX ax_punktkennunguntergegangen_endet ON ax_punktkennunguntergegangen USING btree (endet);
CREATE INDEX ax_punktkennunguntergegangen_istteilvon ON ax_punktkennunguntergegangen USING gin (istteilvon);

COMMENT ON TABLE ax_punktkennunguntergegangen IS 'FeatureType: "AX_PunktkennungUntergegangen"';
COMMENT ON COLUMN ax_punktkennunguntergegangen.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_punktkennunguntergegangen.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_punktkennunguntergegangen.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_punktkennunguntergegangen.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_punktkennunguntergegangen.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_punktkennunguntergegangen.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_punktkennunguntergegangen.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_punktkennunguntergegangen.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_punktkennunguntergegangen.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_punktkennunguntergegangen.art IS 'art enumeration AX_Art_Punktkennung 0..1';
COMMENT ON COLUMN ax_punktkennunguntergegangen.punktkennung IS 'punktkennung  CharacterString 1';
CREATE TABLE ax_fortfuehrungsfall (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  anmerkungfuerdennotar character varying,
  anzahlderfortfuehrungsmitteilungen integer,
  bemerkung character varying,
  fortfuehrungsfallnummer integer NOT NULL,
  fortfuehrungsmitteilunganeigentuemerantragsteller character varying,
  laufendenummer character varying,
  ueberschriftimfortfuehrungsnachweis character varying[] NOT NULL,
  verweistauf_plzort character varying,
  verweistauf_strassehausnummer character varying,
  verweistauf_telefon character varying,
  verweistauf_artderausgabe character varying,
  verweistauf_datumderausgabe character varying,
  verweistauf_dienststelle character varying,
  dienststellenlogo_uri character varying,
  enthaeltewp_uri character varying,
  verweistauf_zusatzartderausgabe character varying,
  verweistauf_uri character varying,
  zeigtaufaltesflurstueck character varying[],
  zeigtaufneuesflurstueck character varying[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_fortfuehrungsfall_gml ON ax_fortfuehrungsfall USING btree (gml_id,beginnt);
CREATE INDEX ax_fortfuehrungsfall_endet ON ax_fortfuehrungsfall USING btree (endet);
CREATE INDEX ax_fortfuehrungsfall_istteilvon ON ax_fortfuehrungsfall USING gin (istteilvon);

COMMENT ON TABLE ax_fortfuehrungsfall IS 'FeatureType: "AX_Fortfuehrungsfall"';
COMMENT ON COLUMN ax_fortfuehrungsfall.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_fortfuehrungsfall.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_fortfuehrungsfall.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_fortfuehrungsfall.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_fortfuehrungsfall.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_fortfuehrungsfall.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_fortfuehrungsfall.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_fortfuehrungsfall.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_fortfuehrungsfall.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_fortfuehrungsfall.anmerkungfuerdennotar IS 'anmerkungFuerDenNotar  CharacterString 0..1';
COMMENT ON COLUMN ax_fortfuehrungsfall.anzahlderfortfuehrungsmitteilungen IS 'anzahlDerFortfuehrungsmitteilungen  Integer 0..1';
COMMENT ON COLUMN ax_fortfuehrungsfall.bemerkung IS 'bemerkung  CharacterString 0..1';
COMMENT ON COLUMN ax_fortfuehrungsfall.fortfuehrungsfallnummer IS 'fortfuehrungsfallnummer  Integer 1';
COMMENT ON COLUMN ax_fortfuehrungsfall.fortfuehrungsmitteilunganeigentuemerantragsteller IS 'fortfuehrungsmitteilungAnEigentuemerAntragsteller  CharacterString 0..1';
COMMENT ON COLUMN ax_fortfuehrungsfall.laufendenummer IS 'laufendeNummer  CharacterString 0..1';
COMMENT ON COLUMN ax_fortfuehrungsfall.ueberschriftimfortfuehrungsnachweis IS 'ueberschriftImFortfuehrungsnachweis codelist AA_Anlassart 1..*';
COMMENT ON COLUMN ax_fortfuehrungsfall.verweistauf_plzort IS 'verweistAuf|AX_FGraphik|ausgabekopf|AX_K_AUSGKOPF_Standard|anschriftDienststelle|AX_K_ANSCHRIFT|plzOrt  CharacterString 1';
COMMENT ON COLUMN ax_fortfuehrungsfall.verweistauf_strassehausnummer IS 'verweistAuf|AX_FGraphik|ausgabekopf|AX_K_AUSGKOPF_Standard|anschriftDienststelle|AX_K_ANSCHRIFT|strasseHausnummer  CharacterString 1';
COMMENT ON COLUMN ax_fortfuehrungsfall.verweistauf_telefon IS 'verweistAuf|AX_FGraphik|ausgabekopf|AX_K_AUSGKOPF_Standard|anschriftDienststelle|AX_K_ANSCHRIFT|telefon  CharacterString 0..1';
COMMENT ON COLUMN ax_fortfuehrungsfall.verweistauf_artderausgabe IS 'verweistAuf|AX_FGraphik|ausgabekopf|AX_K_AUSGKOPF_Standard|artDerAusgabe  CharacterString 1';
COMMENT ON COLUMN ax_fortfuehrungsfall.verweistauf_datumderausgabe IS 'verweistAuf|AX_FGraphik|ausgabekopf|AX_K_AUSGKOPF_Standard|datumDerAusgabe  CharacterString 1';
COMMENT ON COLUMN ax_fortfuehrungsfall.verweistauf_dienststelle IS 'verweistAuf|AX_FGraphik|ausgabekopf|AX_K_AUSGKOPF_Standard|dienststelle  CharacterString 0..1';
COMMENT ON COLUMN ax_fortfuehrungsfall.dienststellenlogo_uri IS 'verweistAuf|AX_FGraphik|ausgabekopf|AX_K_AUSGKOPF_Standard|dienststellenlogo|AX_Dienststellenlogo|uri  URI 1';
COMMENT ON COLUMN ax_fortfuehrungsfall.enthaeltewp_uri IS 'verweistAuf|AX_FGraphik|ausgabekopf|AX_K_AUSGKOPF_Standard|enthaeltEWP|AX_Landeswappen|uri  URI 1';
COMMENT ON COLUMN ax_fortfuehrungsfall.verweistauf_zusatzartderausgabe IS 'verweistAuf|AX_FGraphik|ausgabekopf|AX_K_AUSGKOPF_Standard|zusatzArtDerAusgabe  Boolean 0..1';
COMMENT ON COLUMN ax_fortfuehrungsfall.verweistauf_uri IS 'verweistAuf|AX_FGraphik|uri  URI 1';
COMMENT ON COLUMN ax_fortfuehrungsfall.zeigtaufaltesflurstueck IS 'zeigtAufAltesFlurstueck  CharacterString 0..*';
COMMENT ON COLUMN ax_fortfuehrungsfall.zeigtaufneuesflurstueck IS 'zeigtAufNeuesFlurstueck  CharacterString 0..*';
CREATE TABLE ax_fortfuehrungsnachweisdeckblatt (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  plzort character varying,
  strassehausnummer character varying,
  telefon character varying,
  artderausgabe character varying,
  datumderausgabe character varying,
  dienststelle character varying,
  dienststellenlogo_uri character varying,
  enthaeltewp_uri character varying,
  zusatzartderausgabe character varying,
  auszugfuer_adressat character varying[],
  auszugfuer_art integer[],
  auszugfuer_datum date[],
  bekanntgabeanbeteiligteam date,
  bemerkung character varying,
  eignungspruefungam date,
  eignungspruefungvon character varying,
  erstelltam date,
  erstelltvon character varying,
  fnnummer_gemarkungsnummer character varying NOT NULL,
  fnnummer_land character varying NOT NULL,
  laufendenummer character varying NOT NULL,
  fortfuehrungsentscheidungam date,
  fortfuehrungsentscheidungvon character varying,
  fortfuehrungsfallnummernbereich character varying,
  fortfuehrungsmitteilungenerzeugt date,
  grundbuchmitteilungfuerfinanzamt character varying,
  ingemarkung_gemarkungsnummer character varying NOT NULL,
  ingemarkung_land character varying NOT NULL,
  titel character varying NOT NULL,
  verwaltungsaktjn character varying,
  istteilvon character(16)[],
  beziehtsichauf character(16)[] NOT NULL,
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_fortfuehrungsnachweisdeckblatt_gml ON ax_fortfuehrungsnachweisdeckblatt USING btree (gml_id,beginnt);
CREATE INDEX ax_fortfuehrungsnachweisdeckblatt_endet ON ax_fortfuehrungsnachweisdeckblatt USING btree (endet);
CREATE INDEX ax_fortfuehrungsnachweisdeckblatt_beziehtsichauf ON ax_fortfuehrungsnachweisdeckblatt USING gin (beziehtsichauf);
CREATE INDEX ax_fortfuehrungsnachweisdeckblatt_istteilvon ON ax_fortfuehrungsnachweisdeckblatt USING gin (istteilvon);

COMMENT ON TABLE ax_fortfuehrungsnachweisdeckblatt IS 'FeatureType: "AX_FortfuehrungsnachweisDeckblatt"';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.plzort IS 'ausgabekopf|AX_K_AUSGKOPF_Standard|anschriftDienststelle|AX_K_ANSCHRIFT|plzOrt  CharacterString 1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.strassehausnummer IS 'ausgabekopf|AX_K_AUSGKOPF_Standard|anschriftDienststelle|AX_K_ANSCHRIFT|strasseHausnummer  CharacterString 1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.telefon IS 'ausgabekopf|AX_K_AUSGKOPF_Standard|anschriftDienststelle|AX_K_ANSCHRIFT|telefon  CharacterString 0..1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.artderausgabe IS 'ausgabekopf|AX_K_AUSGKOPF_Standard|artDerAusgabe  CharacterString 1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.datumderausgabe IS 'ausgabekopf|AX_K_AUSGKOPF_Standard|datumDerAusgabe  CharacterString 1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.dienststelle IS 'ausgabekopf|AX_K_AUSGKOPF_Standard|dienststelle  CharacterString 0..1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.dienststellenlogo_uri IS 'ausgabekopf|AX_K_AUSGKOPF_Standard|dienststellenlogo|AX_Dienststellenlogo|uri  URI 1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.enthaeltewp_uri IS 'ausgabekopf|AX_K_AUSGKOPF_Standard|enthaeltEWP|AX_Landeswappen|uri  URI 1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.zusatzartderausgabe IS 'ausgabekopf|AX_K_AUSGKOPF_Standard|zusatzArtDerAusgabe  Boolean 0..1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.auszugfuer_adressat IS 'auszugFuer|AX_Auszug|adressat  CharacterString 1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.auszugfuer_art IS 'auszugFuer|AX_Auszug|art enumeration AX_Art_Adressat_Auszug 1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.auszugfuer_datum IS 'auszugFuer|AX_Auszug|datum  Date 1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.bekanntgabeanbeteiligteam IS 'bekanntgabeAnBeteiligteAm  Date 0..1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.bemerkung IS 'bemerkung  CharacterString 0..1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.eignungspruefungam IS 'eignungspruefungAm  Date 0..1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.eignungspruefungvon IS 'eignungspruefungVon  CharacterString 0..1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.erstelltam IS 'erstelltAm  Date 0..1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.erstelltvon IS 'erstelltVon  CharacterString 0..1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.fnnummer_gemarkungsnummer IS 'fNNummer|AX_Fortfuehrungsnummer|gemarkungsnummer  CharacterString 1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.fnnummer_land IS 'fNNummer|AX_Fortfuehrungsnummer|land  CharacterString 1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.laufendenummer IS 'fNNummer|AX_Fortfuehrungsnummer|laufendeNummer  CharacterString 1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.fortfuehrungsentscheidungam IS 'fortfuehrungsentscheidungAm  Date 0..1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.fortfuehrungsentscheidungvon IS 'fortfuehrungsentscheidungVon  CharacterString 0..1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.fortfuehrungsfallnummernbereich IS 'fortfuehrungsfallNummernbereich  CharacterString 0..1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.fortfuehrungsmitteilungenerzeugt IS 'fortfuehrungsmitteilungenErzeugt  Date 0..1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.grundbuchmitteilungfuerfinanzamt IS 'grundbuchmitteilungFuerFinanzamt  CharacterString 0..1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.ingemarkung_gemarkungsnummer IS 'inGemarkung|AX_Gemarkung_Schluessel|gemarkungsnummer  CharacterString 1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.ingemarkung_land IS 'inGemarkung|AX_Gemarkung_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.titel IS 'titel  CharacterString 1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.verwaltungsaktjn IS 'verwaltungsaktJN  CharacterString 0..1';
COMMENT ON COLUMN ax_fortfuehrungsnachweisdeckblatt.beziehtsichauf IS 'Assoziation zu: FeatureType AX_Fortfuehrungsfall (ax_fortfuehrungsfall) 1..*';
CREATE TABLE ax_schwere (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  aufstellhoehe double precision,
  hinweise character varying,
  berechnungsdatum date,
  bestimmungsdatum date,
  datenerhebung integer,
  genauigkeitsstufe integer,
  genauigkeitswert character varying,
  messmethode integer,
  tauglichkeitgcg integer,
  vertrauenswuerdigkeit integer,
  zustaendigestelleberechnung_land character varying,
  zustaendigestelleberechnung_stelle character varying,
  zustaendigestellemessung_land character varying,
  zustaendigestellemessung_stelle character varying,
  schwereanomalie_art integer[],
  schwereanomalie_wert character varying[],
  schwerebezugssystem integer NOT NULL,
  schwerestatus integer,
  schwerewert character varying,
  ueberpruefungsdatum date,
  genauigkeitvertikalerschweregradient character varying,
  messdatum date,
  messhoehevertikalerschweregradient double precision[],
  wertvertikalerschweregradient character varying,
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_schwere_gml ON ax_schwere USING btree (gml_id,beginnt);
CREATE INDEX ax_schwere_endet ON ax_schwere USING btree (endet);
CREATE INDEX ax_schwere_istteilvon ON ax_schwere USING gin (istteilvon);

COMMENT ON TABLE ax_schwere IS 'FeatureType: "AX_Schwere"';
COMMENT ON COLUMN ax_schwere.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_schwere.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_schwere.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_schwere.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_schwere.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_schwere.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_schwere.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_schwere.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_schwere.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_schwere.aufstellhoehe IS 'aufstellhoehe  Length 0..1';
COMMENT ON COLUMN ax_schwere.hinweise IS 'hinweise  CharacterString 0..1';
COMMENT ON COLUMN ax_schwere.berechnungsdatum IS 'qualitaetsangaben|AX_DQSchwere|berechnungsdatum  Date 0..1';
COMMENT ON COLUMN ax_schwere.bestimmungsdatum IS 'qualitaetsangaben|AX_DQSchwere|bestimmungsdatum  Date 0..1';
COMMENT ON COLUMN ax_schwere.datenerhebung IS 'qualitaetsangaben|AX_DQSchwere|datenerhebung enumeration AX_Datenerhebung_Schwere 0..1';
COMMENT ON COLUMN ax_schwere.genauigkeitsstufe IS 'qualitaetsangaben|AX_DQSchwere|genauigkeitsstufe enumeration AX_Genauigkeitsstufe_Schwere 0..1';
COMMENT ON COLUMN ax_schwere.genauigkeitswert IS 'qualitaetsangaben|AX_DQSchwere|genauigkeitswert  Measure 0..1';
COMMENT ON COLUMN ax_schwere.messmethode IS 'qualitaetsangaben|AX_DQSchwere|messmethode enumeration AX_Messmethode_Schwere 0..1';
COMMENT ON COLUMN ax_schwere.tauglichkeitgcg IS 'qualitaetsangaben|AX_DQSchwere|tauglichkeitGCG enumeration AX_Tauglichkeit_GCG 0..1';
COMMENT ON COLUMN ax_schwere.vertrauenswuerdigkeit IS 'qualitaetsangaben|AX_DQSchwere|vertrauenswuerdigkeit enumeration AX_Vertrauenswuerdigkeit_Schwere 0..1';
COMMENT ON COLUMN ax_schwere.zustaendigestelleberechnung_land IS 'qualitaetsangaben|AX_DQSchwere|zustaendigeStelleBerechnung|AX_Dienststelle_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_schwere.zustaendigestelleberechnung_stelle IS 'qualitaetsangaben|AX_DQSchwere|zustaendigeStelleBerechnung|AX_Dienststelle_Schluessel|stelle  CharacterString 1';
COMMENT ON COLUMN ax_schwere.zustaendigestellemessung_land IS 'qualitaetsangaben|AX_DQSchwere|zustaendigeStelleMessung|AX_Dienststelle_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_schwere.zustaendigestellemessung_stelle IS 'qualitaetsangaben|AX_DQSchwere|zustaendigeStelleMessung|AX_Dienststelle_Schluessel|stelle  CharacterString 1';
COMMENT ON COLUMN ax_schwere.schwereanomalie_art IS 'schwereanomalie|AX_Schwereanomalie_Schwere|art enumeration AX_Schwereanomalie_Schwere_Art 1';
COMMENT ON COLUMN ax_schwere.schwereanomalie_wert IS 'schwereanomalie|AX_Schwereanomalie_Schwere|wert  Measure 1';
COMMENT ON COLUMN ax_schwere.schwerebezugssystem IS 'schwerebezugssystem enumeration AX_Schwerebezugssystem_Schwere 1';
COMMENT ON COLUMN ax_schwere.schwerestatus IS 'schwerestatus enumeration AX_Schwerestatus_Schwere 0..1';
COMMENT ON COLUMN ax_schwere.schwerewert IS 'schwerewert  Measure 0..1';
COMMENT ON COLUMN ax_schwere.ueberpruefungsdatum IS 'ueberpruefungsdatum  Date 0..1';
COMMENT ON COLUMN ax_schwere.genauigkeitvertikalerschweregradient IS 'vertikalerSchweregradient|AX_VertikalerSchweregradient|genauigkeitVertikalerSchweregradient  Measure 0..1';
COMMENT ON COLUMN ax_schwere.messdatum IS 'vertikalerSchweregradient|AX_VertikalerSchweregradient|messdatum  Date 1';
COMMENT ON COLUMN ax_schwere.messhoehevertikalerschweregradient IS 'vertikalerSchweregradient|AX_VertikalerSchweregradient|messhoeheVertikalerSchweregradient  Length *';
COMMENT ON COLUMN ax_schwere.wertvertikalerschweregradient IS 'vertikalerSchweregradient|AX_VertikalerSchweregradient|wertVertikalerSchweregradient  Measure 1';
CREATE TABLE ax_textur3d (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  art character varying,
  darstellungsprioritaet integer,
  signaturnummer character varying,
  thema character varying,
  vorderseite character varying,
  aktualitaet character(20),
  dateitypraster integer,
  link character varying NOT NULL,
  texturkoordinaten double precision[] NOT NULL,
  horizontal integer,
  vertikal integer,
  typ integer,
  dientzurdarstellungvon character(16)[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_textur3d_gml ON ax_textur3d USING btree (gml_id,beginnt);
CREATE INDEX ax_textur3d_endet ON ax_textur3d USING btree (endet);
CREATE INDEX ax_textur3d_dientzurdarstellungvon ON ax_textur3d USING gin (dientzurdarstellungvon);
CREATE INDEX ax_textur3d_istteilvon ON ax_textur3d USING gin (istteilvon);

COMMENT ON TABLE ax_textur3d IS 'FeatureType: "AX_Textur3D"';
COMMENT ON COLUMN ax_textur3d.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_textur3d.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_textur3d.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_textur3d.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_textur3d.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_textur3d.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_textur3d.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_textur3d.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_textur3d.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_textur3d.art IS 'art  CharacterString 0..1';
COMMENT ON COLUMN ax_textur3d.darstellungsprioritaet IS 'darstellungsprioritaet  Integer 0..1';
COMMENT ON COLUMN ax_textur3d.signaturnummer IS 'signaturnummer  CharacterString 0..1';
COMMENT ON COLUMN ax_textur3d.thema IS 'thema  CharacterString 0..1';
COMMENT ON COLUMN ax_textur3d.vorderseite IS 'vorderseite  Boolean 0..1';
COMMENT ON COLUMN ax_textur3d.aktualitaet IS 'aktualitaet  DateTime 0..1';
COMMENT ON COLUMN ax_textur3d.dateitypraster IS 'dateiTypRaster enumeration AX_DateiTypRaster_Textur3D 0..1';
COMMENT ON COLUMN ax_textur3d.link IS 'link  URI 1';
COMMENT ON COLUMN ax_textur3d.texturkoordinaten IS 'texturKoordinaten  Real 1..*';
COMMENT ON COLUMN ax_textur3d.horizontal IS 'texturVerarbeitung|AX_TexturVerarbeitung_Textur3D|horizontal  Integer 1';
COMMENT ON COLUMN ax_textur3d.vertikal IS 'texturVerarbeitung|AX_TexturVerarbeitung_Textur3D|vertikal  Integer 1';
COMMENT ON COLUMN ax_textur3d.typ IS 'typ enumeration AX_Typ_Textur3D 0..1';
CREATE TABLE ax_material3d (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  art character varying,
  darstellungsprioritaet integer,
  signaturnummer character varying,
  thema character varying,
  vorderseite character varying,
  aktualitaet character(20),
  blau integer,
  gruen integer,
  rot integer,
  material integer,
  dientzurdarstellungvon character(16)[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_material3d_gml ON ax_material3d USING btree (gml_id,beginnt);
CREATE INDEX ax_material3d_endet ON ax_material3d USING btree (endet);
CREATE INDEX ax_material3d_dientzurdarstellungvon ON ax_material3d USING gin (dientzurdarstellungvon);
CREATE INDEX ax_material3d_istteilvon ON ax_material3d USING gin (istteilvon);

COMMENT ON TABLE ax_material3d IS 'FeatureType: "AX_Material3D"';
COMMENT ON COLUMN ax_material3d.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_material3d.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_material3d.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_material3d.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_material3d.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_material3d.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_material3d.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_material3d.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_material3d.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_material3d.art IS 'art  CharacterString 0..1';
COMMENT ON COLUMN ax_material3d.darstellungsprioritaet IS 'darstellungsprioritaet  Integer 0..1';
COMMENT ON COLUMN ax_material3d.signaturnummer IS 'signaturnummer  CharacterString 0..1';
COMMENT ON COLUMN ax_material3d.thema IS 'thema  CharacterString 0..1';
COMMENT ON COLUMN ax_material3d.vorderseite IS 'vorderseite  Boolean 0..1';
COMMENT ON COLUMN ax_material3d.aktualitaet IS 'aktualitaet  DateTime 0..1';
COMMENT ON COLUMN ax_material3d.blau IS 'materialeigenschaft|AX_Materialeigenschaft_Material3D|farbeRGB|AX_FarbeRGB_Materialeigenschaft_Material3D|blau  Integer 1';
COMMENT ON COLUMN ax_material3d.gruen IS 'materialeigenschaft|AX_Materialeigenschaft_Material3D|farbeRGB|AX_FarbeRGB_Materialeigenschaft_Material3D|gruen  Integer 1';
COMMENT ON COLUMN ax_material3d.rot IS 'materialeigenschaft|AX_Materialeigenschaft_Material3D|farbeRGB|AX_FarbeRGB_Materialeigenschaft_Material3D|rot  Integer 1';
COMMENT ON COLUMN ax_material3d.material IS 'materialeigenschaft|AX_Materialeigenschaft_Material3D|material enumeration AX_Material_Materialeigenschaft_Material3D 0..1';
CREATE TABLE ax_gemarkungsteilflur (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  administrativefunktion integer[],
  bezeichnung character varying NOT NULL,
  einwohnerzahl integer,
  gehoertzu_land character varying[],
  gehoertzu_stelle character varying[],
  historisch character varying,
  regionalsprache character varying[],
  gemarkung character varying NOT NULL,
  gemarkungsteilflur character varying NOT NULL,
  land character varying NOT NULL,
  schluesselgesamt character varying NOT NULL,
  zweitname character varying[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_gemarkungsteilflur_gml ON ax_gemarkungsteilflur USING btree (gml_id,beginnt);
CREATE INDEX ax_gemarkungsteilflur_endet ON ax_gemarkungsteilflur USING btree (endet);
CREATE INDEX ax_gemarkungsteilflur_istteilvon ON ax_gemarkungsteilflur USING gin (istteilvon);

COMMENT ON TABLE ax_gemarkungsteilflur IS 'FeatureType: "AX_GemarkungsteilFlur"';
COMMENT ON COLUMN ax_gemarkungsteilflur.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_gemarkungsteilflur.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_gemarkungsteilflur.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_gemarkungsteilflur.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_gemarkungsteilflur.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_gemarkungsteilflur.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_gemarkungsteilflur.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_gemarkungsteilflur.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_gemarkungsteilflur.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_gemarkungsteilflur.administrativefunktion IS 'administrativeFunktion enumeration AX_Administrative_Funktion 0..*';
COMMENT ON COLUMN ax_gemarkungsteilflur.bezeichnung IS 'bezeichnung  CharacterString 1';
COMMENT ON COLUMN ax_gemarkungsteilflur.einwohnerzahl IS 'einwohnerzahl  Integer 0..1';
COMMENT ON COLUMN ax_gemarkungsteilflur.gehoertzu_land IS 'gehoertZu|AX_Dienststelle_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_gemarkungsteilflur.gehoertzu_stelle IS 'gehoertZu|AX_Dienststelle_Schluessel|stelle  CharacterString 1';
COMMENT ON COLUMN ax_gemarkungsteilflur.historisch IS 'historisch  Boolean 0..1';
COMMENT ON COLUMN ax_gemarkungsteilflur.regionalsprache IS 'regionalsprache  CharacterString 0..*';
COMMENT ON COLUMN ax_gemarkungsteilflur.gemarkung IS 'schluessel|AX_GemarkungsteilFlur_Schluessel|gemarkung  CharacterString 1';
COMMENT ON COLUMN ax_gemarkungsteilflur.gemarkungsteilflur IS 'schluessel|AX_GemarkungsteilFlur_Schluessel|gemarkungsteilFlur  CharacterString 1';
COMMENT ON COLUMN ax_gemarkungsteilflur.land IS 'schluessel|AX_GemarkungsteilFlur_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_gemarkungsteilflur.schluesselgesamt IS 'schluesselGesamt  CharacterString 1';
COMMENT ON COLUMN ax_gemarkungsteilflur.zweitname IS 'zweitname  CharacterString 0..*';
CREATE TABLE ax_verband (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  administrativefunktion integer[],
  art integer,
  bezeichnung character varying NOT NULL,
  einwohnerzahl integer,
  gemeinde character varying[] NOT NULL,
  gemeindeteil character varying[],
  kreis character varying[] NOT NULL,
  land character varying[] NOT NULL,
  regierungsbezirk character varying[],
  historisch character varying,
  regionalsprache character varying[],
  schluesselgesamt character varying NOT NULL,
  zweitname character varying[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_verband_gml ON ax_verband USING btree (gml_id,beginnt);
CREATE INDEX ax_verband_endet ON ax_verband USING btree (endet);
CREATE INDEX ax_verband_istteilvon ON ax_verband USING gin (istteilvon);

COMMENT ON TABLE ax_verband IS 'FeatureType: "AX_Verband"';
COMMENT ON COLUMN ax_verband.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_verband.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_verband.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_verband.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_verband.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_verband.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_verband.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_verband.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_verband.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_verband.administrativefunktion IS 'administrativeFunktion enumeration AX_Administrative_Funktion 0..*';
COMMENT ON COLUMN ax_verband.art IS 'art enumeration AX_Art_Verband 0..1';
COMMENT ON COLUMN ax_verband.bezeichnung IS 'bezeichnung  CharacterString 1';
COMMENT ON COLUMN ax_verband.einwohnerzahl IS 'einwohnerzahl  Integer 0..1';
COMMENT ON COLUMN ax_verband.gemeinde IS 'enthaelt|AX_Gemeindekennzeichen|gemeinde  CharacterString 1';
COMMENT ON COLUMN ax_verband.gemeindeteil IS 'enthaelt|AX_Gemeindekennzeichen|gemeindeteil  CharacterString 0..1';
COMMENT ON COLUMN ax_verband.kreis IS 'enthaelt|AX_Gemeindekennzeichen|kreis  CharacterString 1';
COMMENT ON COLUMN ax_verband.land IS 'enthaelt|AX_Gemeindekennzeichen|land  CharacterString 1';
COMMENT ON COLUMN ax_verband.regierungsbezirk IS 'enthaelt|AX_Gemeindekennzeichen|regierungsbezirk  CharacterString 0..1';
COMMENT ON COLUMN ax_verband.historisch IS 'historisch  Boolean 0..1';
COMMENT ON COLUMN ax_verband.regionalsprache IS 'regionalsprache  CharacterString 0..*';
COMMENT ON COLUMN ax_verband.schluesselgesamt IS 'schluesselGesamt  CharacterString 1';
COMMENT ON COLUMN ax_verband.zweitname IS 'zweitname  CharacterString 0..*';
CREATE TABLE ax_nationalstaat (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  administrativefunktion integer[],
  bezeichnung character varying NOT NULL,
  einwohnerzahl integer,
  historisch character varying,
  regionalsprache character varying[],
  schluessel character varying NOT NULL,
  schluesselgesamt character varying NOT NULL,
  zweitname character varying[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_nationalstaat_gml ON ax_nationalstaat USING btree (gml_id,beginnt);
CREATE INDEX ax_nationalstaat_endet ON ax_nationalstaat USING btree (endet);
CREATE INDEX ax_nationalstaat_istteilvon ON ax_nationalstaat USING gin (istteilvon);

COMMENT ON TABLE ax_nationalstaat IS 'FeatureType: "AX_Nationalstaat"';
COMMENT ON COLUMN ax_nationalstaat.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_nationalstaat.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_nationalstaat.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_nationalstaat.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_nationalstaat.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_nationalstaat.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_nationalstaat.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_nationalstaat.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_nationalstaat.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_nationalstaat.administrativefunktion IS 'administrativeFunktion enumeration AX_Administrative_Funktion 0..*';
COMMENT ON COLUMN ax_nationalstaat.bezeichnung IS 'bezeichnung  CharacterString 1';
COMMENT ON COLUMN ax_nationalstaat.einwohnerzahl IS 'einwohnerzahl  Integer 0..1';
COMMENT ON COLUMN ax_nationalstaat.historisch IS 'historisch  Boolean 0..1';
COMMENT ON COLUMN ax_nationalstaat.regionalsprache IS 'regionalsprache  CharacterString 0..*';
COMMENT ON COLUMN ax_nationalstaat.schluessel IS 'schluessel  CharacterString 1';
COMMENT ON COLUMN ax_nationalstaat.schluesselgesamt IS 'schluesselGesamt  CharacterString 1';
COMMENT ON COLUMN ax_nationalstaat.zweitname IS 'zweitname  CharacterString 0..*';
CREATE TABLE ax_gemarkung (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  administrativefunktion integer[],
  bezeichnung character varying NOT NULL,
  einwohnerzahl integer,
  gemeindezugehoerigkeit_gemeinde character varying[],
  gemeindezugehoerigkeit_gemeindeteil character varying[],
  gemeindezugehoerigkeit_kreis character varying[],
  gemeindezugehoerigkeit_land character varying[],
  gemeindezugehoerigkeit_regierungsbezirk character varying[],
  historisch character varying,
  istamtsbezirkvon_land character varying[],
  istamtsbezirkvon_stelle character varying[],
  regionalsprache character varying[],
  gemarkungsnummer character varying NOT NULL,
  land character varying NOT NULL,
  schluesselgesamt character varying NOT NULL,
  zweitname character varying[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_gemarkung_gml ON ax_gemarkung USING btree (gml_id,beginnt);
CREATE INDEX ax_gemarkung_endet ON ax_gemarkung USING btree (endet);
CREATE INDEX ax_gemarkung_istteilvon ON ax_gemarkung USING gin (istteilvon);

COMMENT ON TABLE ax_gemarkung IS 'FeatureType: "AX_Gemarkung"';
COMMENT ON COLUMN ax_gemarkung.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_gemarkung.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_gemarkung.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_gemarkung.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_gemarkung.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_gemarkung.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_gemarkung.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_gemarkung.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_gemarkung.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_gemarkung.administrativefunktion IS 'administrativeFunktion enumeration AX_Administrative_Funktion 0..*';
COMMENT ON COLUMN ax_gemarkung.bezeichnung IS 'bezeichnung  CharacterString 1';
COMMENT ON COLUMN ax_gemarkung.einwohnerzahl IS 'einwohnerzahl  Integer 0..1';
COMMENT ON COLUMN ax_gemarkung.gemeindezugehoerigkeit_gemeinde IS 'gemeindezugehoerigkeit|AX_Gemeindekennzeichen|gemeinde  CharacterString 1';
COMMENT ON COLUMN ax_gemarkung.gemeindezugehoerigkeit_gemeindeteil IS 'gemeindezugehoerigkeit|AX_Gemeindekennzeichen|gemeindeteil  CharacterString 0..1';
COMMENT ON COLUMN ax_gemarkung.gemeindezugehoerigkeit_kreis IS 'gemeindezugehoerigkeit|AX_Gemeindekennzeichen|kreis  CharacterString 1';
COMMENT ON COLUMN ax_gemarkung.gemeindezugehoerigkeit_land IS 'gemeindezugehoerigkeit|AX_Gemeindekennzeichen|land  CharacterString 1';
COMMENT ON COLUMN ax_gemarkung.gemeindezugehoerigkeit_regierungsbezirk IS 'gemeindezugehoerigkeit|AX_Gemeindekennzeichen|regierungsbezirk  CharacterString 0..1';
COMMENT ON COLUMN ax_gemarkung.historisch IS 'historisch  Boolean 0..1';
COMMENT ON COLUMN ax_gemarkung.istamtsbezirkvon_land IS 'istAmtsbezirkVon|AX_Dienststelle_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_gemarkung.istamtsbezirkvon_stelle IS 'istAmtsbezirkVon|AX_Dienststelle_Schluessel|stelle  CharacterString 1';
COMMENT ON COLUMN ax_gemarkung.regionalsprache IS 'regionalsprache  CharacterString 0..*';
COMMENT ON COLUMN ax_gemarkung.gemarkungsnummer IS 'schluessel|AX_Gemarkung_Schluessel|gemarkungsnummer  CharacterString 1';
COMMENT ON COLUMN ax_gemarkung.land IS 'schluessel|AX_Gemarkung_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_gemarkung.schluesselgesamt IS 'schluesselGesamt  CharacterString 1';
COMMENT ON COLUMN ax_gemarkung.zweitname IS 'zweitname  CharacterString 0..*';
CREATE TABLE ax_dienststelle (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  administrativefunktion integer[],
  bezeichnung character varying NOT NULL,
  einwohnerzahl integer,
  historisch character varying,
  kennung character varying,
  regionalsprache character varying[],
  land character varying NOT NULL,
  stelle character varying NOT NULL,
  schluesselgesamt character varying NOT NULL,
  stellenart integer,
  zweitname character varying[],
  istteilvon character(16)[],
  hat character(16),
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_dienststelle_gml ON ax_dienststelle USING btree (gml_id,beginnt);
CREATE INDEX ax_dienststelle_endet ON ax_dienststelle USING btree (endet);
CREATE INDEX ax_dienststelle_hat ON ax_dienststelle USING btree (hat);
CREATE INDEX ax_dienststelle_istteilvon ON ax_dienststelle USING gin (istteilvon);

COMMENT ON TABLE ax_dienststelle IS 'FeatureType: "AX_Dienststelle"';
COMMENT ON COLUMN ax_dienststelle.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_dienststelle.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_dienststelle.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_dienststelle.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_dienststelle.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_dienststelle.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_dienststelle.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_dienststelle.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_dienststelle.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_dienststelle.administrativefunktion IS 'administrativeFunktion enumeration AX_Administrative_Funktion 0..*';
COMMENT ON COLUMN ax_dienststelle.bezeichnung IS 'bezeichnung  CharacterString 1';
COMMENT ON COLUMN ax_dienststelle.einwohnerzahl IS 'einwohnerzahl  Integer 0..1';
COMMENT ON COLUMN ax_dienststelle.historisch IS 'historisch  Boolean 0..1';
COMMENT ON COLUMN ax_dienststelle.kennung IS 'kennung  CharacterString 0..1';
COMMENT ON COLUMN ax_dienststelle.regionalsprache IS 'regionalsprache  CharacterString 0..*';
COMMENT ON COLUMN ax_dienststelle.land IS 'schluessel|AX_Dienststelle_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_dienststelle.stelle IS 'schluessel|AX_Dienststelle_Schluessel|stelle  CharacterString 1';
COMMENT ON COLUMN ax_dienststelle.schluesselgesamt IS 'schluesselGesamt  CharacterString 1';
COMMENT ON COLUMN ax_dienststelle.stellenart IS 'stellenart enumeration AX_Behoerde 0..1';
COMMENT ON COLUMN ax_dienststelle.zweitname IS 'zweitname  CharacterString 0..*';
COMMENT ON COLUMN ax_dienststelle.hat IS 'Assoziation zu: FeatureType AX_Anschrift (ax_anschrift) 0..1';
CREATE TABLE ax_bundesland (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  administrativefunktion integer[],
  bezeichnung character varying NOT NULL,
  einwohnerzahl integer,
  historisch character varying,
  istamtsbezirkvon_land character varying[],
  istamtsbezirkvon_stelle character varying[],
  regionalsprache character varying[],
  land character varying NOT NULL,
  schluesselgesamt character varying NOT NULL,
  zweitname character varying[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_bundesland_gml ON ax_bundesland USING btree (gml_id,beginnt);
CREATE INDEX ax_bundesland_endet ON ax_bundesland USING btree (endet);
CREATE INDEX ax_bundesland_istteilvon ON ax_bundesland USING gin (istteilvon);

COMMENT ON TABLE ax_bundesland IS 'FeatureType: "AX_Bundesland"';
COMMENT ON COLUMN ax_bundesland.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_bundesland.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_bundesland.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_bundesland.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_bundesland.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_bundesland.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_bundesland.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_bundesland.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_bundesland.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_bundesland.administrativefunktion IS 'administrativeFunktion enumeration AX_Administrative_Funktion 0..*';
COMMENT ON COLUMN ax_bundesland.bezeichnung IS 'bezeichnung  CharacterString 1';
COMMENT ON COLUMN ax_bundesland.einwohnerzahl IS 'einwohnerzahl  Integer 0..1';
COMMENT ON COLUMN ax_bundesland.historisch IS 'historisch  Boolean 0..1';
COMMENT ON COLUMN ax_bundesland.istamtsbezirkvon_land IS 'istAmtsbezirkVon|AX_Dienststelle_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_bundesland.istamtsbezirkvon_stelle IS 'istAmtsbezirkVon|AX_Dienststelle_Schluessel|stelle  CharacterString 1';
COMMENT ON COLUMN ax_bundesland.regionalsprache IS 'regionalsprache  CharacterString 0..*';
COMMENT ON COLUMN ax_bundesland.land IS 'schluessel|AX_Bundesland_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_bundesland.schluesselgesamt IS 'schluesselGesamt  CharacterString 1';
COMMENT ON COLUMN ax_bundesland.zweitname IS 'zweitname  CharacterString 0..*';
CREATE TABLE ax_regierungsbezirk (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  administrativefunktion integer[],
  bezeichnung character varying NOT NULL,
  einwohnerzahl integer,
  historisch character varying,
  regionalsprache character varying[],
  land character varying NOT NULL,
  regierungsbezirk character varying NOT NULL,
  schluesselgesamt character varying NOT NULL,
  zweitname character varying[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_regierungsbezirk_gml ON ax_regierungsbezirk USING btree (gml_id,beginnt);
CREATE INDEX ax_regierungsbezirk_endet ON ax_regierungsbezirk USING btree (endet);
CREATE INDEX ax_regierungsbezirk_istteilvon ON ax_regierungsbezirk USING gin (istteilvon);

COMMENT ON TABLE ax_regierungsbezirk IS 'FeatureType: "AX_Regierungsbezirk"';
COMMENT ON COLUMN ax_regierungsbezirk.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_regierungsbezirk.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_regierungsbezirk.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_regierungsbezirk.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_regierungsbezirk.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_regierungsbezirk.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_regierungsbezirk.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_regierungsbezirk.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_regierungsbezirk.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_regierungsbezirk.administrativefunktion IS 'administrativeFunktion enumeration AX_Administrative_Funktion 0..*';
COMMENT ON COLUMN ax_regierungsbezirk.bezeichnung IS 'bezeichnung  CharacterString 1';
COMMENT ON COLUMN ax_regierungsbezirk.einwohnerzahl IS 'einwohnerzahl  Integer 0..1';
COMMENT ON COLUMN ax_regierungsbezirk.historisch IS 'historisch  Boolean 0..1';
COMMENT ON COLUMN ax_regierungsbezirk.regionalsprache IS 'regionalsprache  CharacterString 0..*';
COMMENT ON COLUMN ax_regierungsbezirk.land IS 'schluessel|AX_Regierungsbezirk_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_regierungsbezirk.regierungsbezirk IS 'schluessel|AX_Regierungsbezirk_Schluessel|regierungsbezirk  CharacterString 1';
COMMENT ON COLUMN ax_regierungsbezirk.schluesselgesamt IS 'schluesselGesamt  CharacterString 1';
COMMENT ON COLUMN ax_regierungsbezirk.zweitname IS 'zweitname  CharacterString 0..*';
CREATE TABLE ax_gemeindeteil (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  administrativefunktion integer[],
  bezeichnung character varying NOT NULL,
  einwohnerzahl integer,
  gemeinde character varying NOT NULL,
  gemeindeteil character varying,
  kreis character varying NOT NULL,
  land character varying NOT NULL,
  regierungsbezirk character varying,
  historisch character varying,
  regionalsprache character varying[],
  schluesselgesamt character varying NOT NULL,
  zweitname character varying[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_gemeindeteil_gml ON ax_gemeindeteil USING btree (gml_id,beginnt);
CREATE INDEX ax_gemeindeteil_endet ON ax_gemeindeteil USING btree (endet);
CREATE INDEX ax_gemeindeteil_istteilvon ON ax_gemeindeteil USING gin (istteilvon);

COMMENT ON TABLE ax_gemeindeteil IS 'FeatureType: "AX_Gemeindeteil"';
COMMENT ON COLUMN ax_gemeindeteil.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_gemeindeteil.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_gemeindeteil.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_gemeindeteil.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_gemeindeteil.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_gemeindeteil.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_gemeindeteil.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_gemeindeteil.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_gemeindeteil.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_gemeindeteil.administrativefunktion IS 'administrativeFunktion enumeration AX_Administrative_Funktion 0..*';
COMMENT ON COLUMN ax_gemeindeteil.bezeichnung IS 'bezeichnung  CharacterString 1';
COMMENT ON COLUMN ax_gemeindeteil.einwohnerzahl IS 'einwohnerzahl  Integer 0..1';
COMMENT ON COLUMN ax_gemeindeteil.gemeinde IS 'gemeindekennzeichen|AX_Gemeindekennzeichen|gemeinde  CharacterString 1';
COMMENT ON COLUMN ax_gemeindeteil.gemeindeteil IS 'gemeindekennzeichen|AX_Gemeindekennzeichen|gemeindeteil  CharacterString 0..1';
COMMENT ON COLUMN ax_gemeindeteil.kreis IS 'gemeindekennzeichen|AX_Gemeindekennzeichen|kreis  CharacterString 1';
COMMENT ON COLUMN ax_gemeindeteil.land IS 'gemeindekennzeichen|AX_Gemeindekennzeichen|land  CharacterString 1';
COMMENT ON COLUMN ax_gemeindeteil.regierungsbezirk IS 'gemeindekennzeichen|AX_Gemeindekennzeichen|regierungsbezirk  CharacterString 0..1';
COMMENT ON COLUMN ax_gemeindeteil.historisch IS 'historisch  Boolean 0..1';
COMMENT ON COLUMN ax_gemeindeteil.regionalsprache IS 'regionalsprache  CharacterString 0..*';
COMMENT ON COLUMN ax_gemeindeteil.schluesselgesamt IS 'schluesselGesamt  CharacterString 1';
COMMENT ON COLUMN ax_gemeindeteil.zweitname IS 'zweitname  CharacterString 0..*';
CREATE TABLE ax_gemeinde (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  administrativefunktion integer[],
  bezeichnung character varying NOT NULL,
  einwohnerzahl integer,
  gemeinde character varying NOT NULL,
  gemeindeteil character varying,
  kreis character varying NOT NULL,
  land character varying NOT NULL,
  regierungsbezirk character varying,
  historisch character varying,
  istamtsbezirkvon_land character varying[],
  istamtsbezirkvon_stelle character varying[],
  rolle integer[],
  schluessel_kreis character varying[],
  schluessel_land character varying[],
  schluessel_regierungsbezirk character varying[],
  schluessel_verwaltungsgemeinschaft character varying[],
  regionalsprache character varying[],
  schluesselgesamt character varying NOT NULL,
  zweitname character varying[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_gemeinde_gml ON ax_gemeinde USING btree (gml_id,beginnt);
CREATE INDEX ax_gemeinde_endet ON ax_gemeinde USING btree (endet);
CREATE INDEX ax_gemeinde_istteilvon ON ax_gemeinde USING gin (istteilvon);

COMMENT ON TABLE ax_gemeinde IS 'FeatureType: "AX_Gemeinde"';
COMMENT ON COLUMN ax_gemeinde.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_gemeinde.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_gemeinde.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_gemeinde.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_gemeinde.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_gemeinde.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_gemeinde.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_gemeinde.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_gemeinde.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_gemeinde.administrativefunktion IS 'administrativeFunktion enumeration AX_Administrative_Funktion 0..*';
COMMENT ON COLUMN ax_gemeinde.bezeichnung IS 'bezeichnung  CharacterString 1';
COMMENT ON COLUMN ax_gemeinde.einwohnerzahl IS 'einwohnerzahl  Integer 0..1';
COMMENT ON COLUMN ax_gemeinde.gemeinde IS 'gemeindekennzeichen|AX_Gemeindekennzeichen|gemeinde  CharacterString 1';
COMMENT ON COLUMN ax_gemeinde.gemeindeteil IS 'gemeindekennzeichen|AX_Gemeindekennzeichen|gemeindeteil  CharacterString 0..1';
COMMENT ON COLUMN ax_gemeinde.kreis IS 'gemeindekennzeichen|AX_Gemeindekennzeichen|kreis  CharacterString 1';
COMMENT ON COLUMN ax_gemeinde.land IS 'gemeindekennzeichen|AX_Gemeindekennzeichen|land  CharacterString 1';
COMMENT ON COLUMN ax_gemeinde.regierungsbezirk IS 'gemeindekennzeichen|AX_Gemeindekennzeichen|regierungsbezirk  CharacterString 0..1';
COMMENT ON COLUMN ax_gemeinde.historisch IS 'historisch  Boolean 0..1';
COMMENT ON COLUMN ax_gemeinde.istamtsbezirkvon_land IS 'istAmtsbezirkVon|AX_Dienststelle_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_gemeinde.istamtsbezirkvon_stelle IS 'istAmtsbezirkVon|AX_Dienststelle_Schluessel|stelle  CharacterString 1';
COMMENT ON COLUMN ax_gemeinde.rolle IS 'istTeilVonVerwaltungsgemeinschaft|AX_TeilVonVerwaltungsgemeinschaft|rolle enumeration AX_RolleDerGemeinde 1';
COMMENT ON COLUMN ax_gemeinde.schluessel_kreis IS 'istTeilVonVerwaltungsgemeinschaft|AX_TeilVonVerwaltungsgemeinschaft|schluessel|AX_Verwaltungsgemeinschaft_Schluessel|kreis  CharacterString 1';
COMMENT ON COLUMN ax_gemeinde.schluessel_land IS 'istTeilVonVerwaltungsgemeinschaft|AX_TeilVonVerwaltungsgemeinschaft|schluessel|AX_Verwaltungsgemeinschaft_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_gemeinde.schluessel_regierungsbezirk IS 'istTeilVonVerwaltungsgemeinschaft|AX_TeilVonVerwaltungsgemeinschaft|schluessel|AX_Verwaltungsgemeinschaft_Schluessel|regierungsbezirk  CharacterString 0..1';
COMMENT ON COLUMN ax_gemeinde.schluessel_verwaltungsgemeinschaft IS 'istTeilVonVerwaltungsgemeinschaft|AX_TeilVonVerwaltungsgemeinschaft|schluessel|AX_Verwaltungsgemeinschaft_Schluessel|verwaltungsgemeinschaft  CharacterString 1';
COMMENT ON COLUMN ax_gemeinde.regionalsprache IS 'regionalsprache  CharacterString 0..*';
COMMENT ON COLUMN ax_gemeinde.schluesselgesamt IS 'schluesselGesamt  CharacterString 1';
COMMENT ON COLUMN ax_gemeinde.zweitname IS 'zweitname  CharacterString 0..*';
CREATE TABLE ax_buchungsblattbezirk (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  administrativefunktion integer[],
  bezeichnung character varying NOT NULL,
  einwohnerzahl integer,
  gehoertzu_land character varying,
  gehoertzu_stelle character varying,
  historisch character varying,
  regionalsprache character varying[],
  bezirk character varying NOT NULL,
  land character varying NOT NULL,
  schluesselgesamt character varying NOT NULL,
  zweitname character varying[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_buchungsblattbezirk_gml ON ax_buchungsblattbezirk USING btree (gml_id,beginnt);
CREATE INDEX ax_buchungsblattbezirk_endet ON ax_buchungsblattbezirk USING btree (endet);
CREATE INDEX ax_buchungsblattbezirk_istteilvon ON ax_buchungsblattbezirk USING gin (istteilvon);

COMMENT ON TABLE ax_buchungsblattbezirk IS 'FeatureType: "AX_Buchungsblattbezirk"';
COMMENT ON COLUMN ax_buchungsblattbezirk.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_buchungsblattbezirk.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_buchungsblattbezirk.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_buchungsblattbezirk.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_buchungsblattbezirk.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_buchungsblattbezirk.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_buchungsblattbezirk.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_buchungsblattbezirk.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_buchungsblattbezirk.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_buchungsblattbezirk.administrativefunktion IS 'administrativeFunktion enumeration AX_Administrative_Funktion 0..*';
COMMENT ON COLUMN ax_buchungsblattbezirk.bezeichnung IS 'bezeichnung  CharacterString 1';
COMMENT ON COLUMN ax_buchungsblattbezirk.einwohnerzahl IS 'einwohnerzahl  Integer 0..1';
COMMENT ON COLUMN ax_buchungsblattbezirk.gehoertzu_land IS 'gehoertZu|AX_Dienststelle_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_buchungsblattbezirk.gehoertzu_stelle IS 'gehoertZu|AX_Dienststelle_Schluessel|stelle  CharacterString 1';
COMMENT ON COLUMN ax_buchungsblattbezirk.historisch IS 'historisch  Boolean 0..1';
COMMENT ON COLUMN ax_buchungsblattbezirk.regionalsprache IS 'regionalsprache  CharacterString 0..*';
COMMENT ON COLUMN ax_buchungsblattbezirk.bezirk IS 'schluessel|AX_Buchungsblattbezirk_Schluessel|bezirk  CharacterString 1';
COMMENT ON COLUMN ax_buchungsblattbezirk.land IS 'schluessel|AX_Buchungsblattbezirk_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_buchungsblattbezirk.schluesselgesamt IS 'schluesselGesamt  CharacterString 1';
COMMENT ON COLUMN ax_buchungsblattbezirk.zweitname IS 'zweitname  CharacterString 0..*';
CREATE TABLE ax_lagebezeichnungkatalogeintrag (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  administrativefunktion integer[],
  bezeichnung character varying NOT NULL,
  einwohnerzahl integer,
  historisch character varying,
  kennung character varying,
  regionalsprache character varying[],
  gemeinde character varying NOT NULL,
  kreis character varying NOT NULL,
  lage character varying NOT NULL,
  land character varying NOT NULL,
  regierungsbezirk character varying,
  schluesselgesamt character varying NOT NULL,
  zweitname character varying[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_lagebezeichnungkatalogeintrag_gml ON ax_lagebezeichnungkatalogeintrag USING btree (gml_id,beginnt);
CREATE INDEX ax_lagebezeichnungkatalogeintrag_endet ON ax_lagebezeichnungkatalogeintrag USING btree (endet);
CREATE INDEX ax_lagebezeichnungkatalogeintrag_istteilvon ON ax_lagebezeichnungkatalogeintrag USING gin (istteilvon);

COMMENT ON TABLE ax_lagebezeichnungkatalogeintrag IS 'FeatureType: "AX_LagebezeichnungKatalogeintrag"';
COMMENT ON COLUMN ax_lagebezeichnungkatalogeintrag.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_lagebezeichnungkatalogeintrag.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_lagebezeichnungkatalogeintrag.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_lagebezeichnungkatalogeintrag.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_lagebezeichnungkatalogeintrag.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_lagebezeichnungkatalogeintrag.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_lagebezeichnungkatalogeintrag.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_lagebezeichnungkatalogeintrag.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_lagebezeichnungkatalogeintrag.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_lagebezeichnungkatalogeintrag.administrativefunktion IS 'administrativeFunktion enumeration AX_Administrative_Funktion 0..*';
COMMENT ON COLUMN ax_lagebezeichnungkatalogeintrag.bezeichnung IS 'bezeichnung  CharacterString 1';
COMMENT ON COLUMN ax_lagebezeichnungkatalogeintrag.einwohnerzahl IS 'einwohnerzahl  Integer 0..1';
COMMENT ON COLUMN ax_lagebezeichnungkatalogeintrag.historisch IS 'historisch  Boolean 0..1';
COMMENT ON COLUMN ax_lagebezeichnungkatalogeintrag.kennung IS 'kennung  CharacterString 0..1';
COMMENT ON COLUMN ax_lagebezeichnungkatalogeintrag.regionalsprache IS 'regionalsprache  CharacterString 0..*';
COMMENT ON COLUMN ax_lagebezeichnungkatalogeintrag.gemeinde IS 'schluessel|AX_VerschluesselteLagebezeichnung|gemeinde  CharacterString 1';
COMMENT ON COLUMN ax_lagebezeichnungkatalogeintrag.kreis IS 'schluessel|AX_VerschluesselteLagebezeichnung|kreis  CharacterString 1';
COMMENT ON COLUMN ax_lagebezeichnungkatalogeintrag.lage IS 'schluessel|AX_VerschluesselteLagebezeichnung|lage  CharacterString 1';
COMMENT ON COLUMN ax_lagebezeichnungkatalogeintrag.land IS 'schluessel|AX_VerschluesselteLagebezeichnung|land  CharacterString 1';
COMMENT ON COLUMN ax_lagebezeichnungkatalogeintrag.regierungsbezirk IS 'schluessel|AX_VerschluesselteLagebezeichnung|regierungsbezirk  CharacterString 0..1';
COMMENT ON COLUMN ax_lagebezeichnungkatalogeintrag.schluesselgesamt IS 'schluesselGesamt  CharacterString 1';
COMMENT ON COLUMN ax_lagebezeichnungkatalogeintrag.zweitname IS 'zweitname  CharacterString 0..*';
CREATE TABLE ax_kreisregion (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  administrativefunktion integer[],
  bezeichnung character varying NOT NULL,
  einwohnerzahl integer,
  historisch character varying,
  istamtsbezirkvon_land character varying[],
  istamtsbezirkvon_stelle character varying[],
  regionalsprache character varying[],
  kreis character varying NOT NULL,
  land character varying NOT NULL,
  regierungsbezirk character varying,
  schluesselgesamt character varying NOT NULL,
  zweitname character varying[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_kreisregion_gml ON ax_kreisregion USING btree (gml_id,beginnt);
CREATE INDEX ax_kreisregion_endet ON ax_kreisregion USING btree (endet);
CREATE INDEX ax_kreisregion_istteilvon ON ax_kreisregion USING gin (istteilvon);

COMMENT ON TABLE ax_kreisregion IS 'FeatureType: "AX_KreisRegion"';
COMMENT ON COLUMN ax_kreisregion.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_kreisregion.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_kreisregion.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_kreisregion.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_kreisregion.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_kreisregion.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_kreisregion.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_kreisregion.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_kreisregion.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_kreisregion.administrativefunktion IS 'administrativeFunktion enumeration AX_Administrative_Funktion 0..*';
COMMENT ON COLUMN ax_kreisregion.bezeichnung IS 'bezeichnung  CharacterString 1';
COMMENT ON COLUMN ax_kreisregion.einwohnerzahl IS 'einwohnerzahl  Integer 0..1';
COMMENT ON COLUMN ax_kreisregion.historisch IS 'historisch  Boolean 0..1';
COMMENT ON COLUMN ax_kreisregion.istamtsbezirkvon_land IS 'istAmtsbezirkVon|AX_Dienststelle_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_kreisregion.istamtsbezirkvon_stelle IS 'istAmtsbezirkVon|AX_Dienststelle_Schluessel|stelle  CharacterString 1';
COMMENT ON COLUMN ax_kreisregion.regionalsprache IS 'regionalsprache  CharacterString 0..*';
COMMENT ON COLUMN ax_kreisregion.kreis IS 'schluessel|AX_Kreis_Schluessel|kreis  CharacterString 1';
COMMENT ON COLUMN ax_kreisregion.land IS 'schluessel|AX_Kreis_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_kreisregion.regierungsbezirk IS 'schluessel|AX_Kreis_Schluessel|regierungsbezirk  CharacterString 0..1';
COMMENT ON COLUMN ax_kreisregion.schluesselgesamt IS 'schluesselGesamt  CharacterString 1';
COMMENT ON COLUMN ax_kreisregion.zweitname IS 'zweitname  CharacterString 0..*';
CREATE TABLE ax_fortfuehrungsfallgrundbuch (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  bemerkung character varying,
  bezeichnungbauraumoderbodenordnungsrecht character varying,
  fortfuehrungsfallnummer integer NOT NULL,
  gemarkungsnummer character varying,
  land character varying,
  laufendenummer character varying,
  ordnungsnummer character varying[],
  ueberschriftimfortfuehrungsnachweis character varying[] NOT NULL,
  zeigtaufaltesflurstueckgrundbuch character varying[],
  zeigtaufneuesflurstueckgrundbuch character varying[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_fortfuehrungsfallgrundbuch_gml ON ax_fortfuehrungsfallgrundbuch USING btree (gml_id,beginnt);
CREATE INDEX ax_fortfuehrungsfallgrundbuch_endet ON ax_fortfuehrungsfallgrundbuch USING btree (endet);
CREATE INDEX ax_fortfuehrungsfallgrundbuch_istteilvon ON ax_fortfuehrungsfallgrundbuch USING gin (istteilvon);

COMMENT ON TABLE ax_fortfuehrungsfallgrundbuch IS 'FeatureType: "AX_FortfuehrungsfallGrundbuch"';
COMMENT ON COLUMN ax_fortfuehrungsfallgrundbuch.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_fortfuehrungsfallgrundbuch.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_fortfuehrungsfallgrundbuch.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_fortfuehrungsfallgrundbuch.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_fortfuehrungsfallgrundbuch.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_fortfuehrungsfallgrundbuch.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_fortfuehrungsfallgrundbuch.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_fortfuehrungsfallgrundbuch.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_fortfuehrungsfallgrundbuch.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_fortfuehrungsfallgrundbuch.bemerkung IS 'bemerkung  CharacterString 0..1';
COMMENT ON COLUMN ax_fortfuehrungsfallgrundbuch.bezeichnungbauraumoderbodenordnungsrecht IS 'bezeichnungBauRaumOderBodenordnungsrecht  CharacterString 0..1';
COMMENT ON COLUMN ax_fortfuehrungsfallgrundbuch.fortfuehrungsfallnummer IS 'fortfuehrungsfallnummer  Integer 1';
COMMENT ON COLUMN ax_fortfuehrungsfallgrundbuch.gemarkungsnummer IS 'laufendeNummer|AX_Fortfuehrungsnummer|gemarkungsnummer  CharacterString 1';
COMMENT ON COLUMN ax_fortfuehrungsfallgrundbuch.land IS 'laufendeNummer|AX_Fortfuehrungsnummer|land  CharacterString 1';
COMMENT ON COLUMN ax_fortfuehrungsfallgrundbuch.laufendenummer IS 'laufendeNummer|AX_Fortfuehrungsnummer|laufendeNummer  CharacterString 1';
COMMENT ON COLUMN ax_fortfuehrungsfallgrundbuch.ordnungsnummer IS 'ordnungsnummer  CharacterString 0..*';
COMMENT ON COLUMN ax_fortfuehrungsfallgrundbuch.ueberschriftimfortfuehrungsnachweis IS 'ueberschriftImFortfuehrungsnachweis codelist AA_Anlassart 1..*';
COMMENT ON COLUMN ax_fortfuehrungsfallgrundbuch.zeigtaufaltesflurstueckgrundbuch IS 'zeigtAufAltesFlurstueckGrundbuch  CharacterString 0..*';
COMMENT ON COLUMN ax_fortfuehrungsfallgrundbuch.zeigtaufneuesflurstueckgrundbuch IS 'zeigtAufNeuesFlurstueckGrundbuch  CharacterString 0..*';
CREATE TABLE ax_flurstueckgrundbuch (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  amtlicheflaeche character varying NOT NULL,
  anlassflurstueck character varying,
  anliegervermerk_buchungsart integer[],
  anliegervermerk_flurnummer character varying[],
  anliegervermerk_nenner character varying[],
  anliegervermerk_zaehler character varying[],
  anliegervermerk_gemarkungsnummer character varying[],
  anliegervermerk_land character varying[],
  flurnummer character varying,
  flurstuecksfolge character varying,
  flurstueckskennzeichen character varying NOT NULL,
  nenner character varying,
  zaehler character varying NOT NULL,
  gemarkungsnummer character varying NOT NULL,
  land character varying NOT NULL,
  gemeindezugehoerigkeit_gemeinde character varying NOT NULL,
  gemeindezugehoerigkeit_gemeindeteil character varying,
  gemeindezugehoerigkeit_kreis character varying NOT NULL,
  gemeindezugehoerigkeit_land character varying NOT NULL,
  gemeindezugehoerigkeit_regierungsbezirk character varying,
  lagebezeichnung character varying[] NOT NULL,
  lebenszeitintervallflurstueck_beginnt character(20) NOT NULL,
  lebenszeitintervallflurstueck_endet character(20),
  rechtsbehelfsverfahren character varying,
  strittigegrenze character varying,
  wirtschaftsart character varying[] NOT NULL,
  zustaendigestelle_land character varying NOT NULL,
  zustaendigestelle_stelle character varying NOT NULL,
  istteilvon character(16)[],
  istgebucht character(16) NOT NULL,
  isteinverweisaufflurstueck character(16) NOT NULL,
  einbezogenin character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_flurstueckgrundbuch_gml ON ax_flurstueckgrundbuch USING btree (gml_id,beginnt);
CREATE INDEX ax_flurstueckgrundbuch_endet ON ax_flurstueckgrundbuch USING btree (endet);
CREATE INDEX ax_flurstueckgrundbuch_istgebucht ON ax_flurstueckgrundbuch USING btree (istgebucht);
CREATE INDEX ax_flurstueckgrundbuch_isteinverweisaufflurstueck ON ax_flurstueckgrundbuch USING btree (isteinverweisaufflurstueck);
CREATE INDEX ax_flurstueckgrundbuch_einbezogenin ON ax_flurstueckgrundbuch USING gin (einbezogenin);
CREATE INDEX ax_flurstueckgrundbuch_istteilvon ON ax_flurstueckgrundbuch USING gin (istteilvon);

COMMENT ON TABLE ax_flurstueckgrundbuch IS 'FeatureType: "AX_FlurstueckGrundbuch"';
COMMENT ON COLUMN ax_flurstueckgrundbuch.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_flurstueckgrundbuch.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.amtlicheflaeche IS 'amtlicheFlaeche  CharacterString 1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.anlassflurstueck IS 'anlassFlurstueck codelist AA_Anlassart 0..1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.anliegervermerk_buchungsart IS 'anliegervermerk|AX_Anliegervermerk|buchungsart enumeration AX_Buchungsart_Anlieger 1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.anliegervermerk_flurnummer IS 'anliegervermerk|AX_Anliegervermerk|flurnummer  CharacterString 0..1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.anliegervermerk_nenner IS 'anliegervermerk|AX_Anliegervermerk|flurstuecksnummer|AX_Flurstuecksnummer|nenner  CharacterString 0..1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.anliegervermerk_zaehler IS 'anliegervermerk|AX_Anliegervermerk|flurstuecksnummer|AX_Flurstuecksnummer|zaehler  CharacterString 1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.anliegervermerk_gemarkungsnummer IS 'anliegervermerk|AX_Anliegervermerk|gemarkung|AX_Gemarkung_Schluessel|gemarkungsnummer  CharacterString 1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.anliegervermerk_land IS 'anliegervermerk|AX_Anliegervermerk|gemarkung|AX_Gemarkung_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.flurnummer IS 'flurnummer  CharacterString 0..1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.flurstuecksfolge IS 'flurstuecksfolge  CharacterString 0..1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.flurstueckskennzeichen IS 'flurstueckskennzeichen  CharacterString 1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.nenner IS 'flurstuecksnummer|AX_Flurstuecksnummer|nenner  CharacterString 0..1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.zaehler IS 'flurstuecksnummer|AX_Flurstuecksnummer|zaehler  CharacterString 1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.gemarkungsnummer IS 'gemarkung|AX_Gemarkung_Schluessel|gemarkungsnummer  CharacterString 1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.land IS 'gemarkung|AX_Gemarkung_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.gemeindezugehoerigkeit_gemeinde IS 'gemeindezugehoerigkeit|AX_Gemeindekennzeichen|gemeinde  CharacterString 1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.gemeindezugehoerigkeit_gemeindeteil IS 'gemeindezugehoerigkeit|AX_Gemeindekennzeichen|gemeindeteil  CharacterString 0..1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.gemeindezugehoerigkeit_kreis IS 'gemeindezugehoerigkeit|AX_Gemeindekennzeichen|kreis  CharacterString 1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.gemeindezugehoerigkeit_land IS 'gemeindezugehoerigkeit|AX_Gemeindekennzeichen|land  CharacterString 1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.gemeindezugehoerigkeit_regierungsbezirk IS 'gemeindezugehoerigkeit|AX_Gemeindekennzeichen|regierungsbezirk  CharacterString 0..1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.lagebezeichnung IS 'lagebezeichnung  CharacterString 1..*';
COMMENT ON COLUMN ax_flurstueckgrundbuch.lebenszeitintervallflurstueck_beginnt IS 'lebenszeitintervallFlurstueck|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.lebenszeitintervallflurstueck_endet IS 'lebenszeitintervallFlurstueck|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.rechtsbehelfsverfahren IS 'rechtsbehelfsverfahren  Boolean 0..1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.strittigegrenze IS 'strittigeGrenze  CharacterString 0..1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.wirtschaftsart IS 'wirtschaftsart enumeration AX_WirtschaftsartGrundbuch 1..*';
COMMENT ON COLUMN ax_flurstueckgrundbuch.zustaendigestelle_land IS 'zustaendigeStelle|AX_Dienststelle_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.zustaendigestelle_stelle IS 'zustaendigeStelle|AX_Dienststelle_Schluessel|stelle  CharacterString 1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.istgebucht IS 'Assoziation zu: FeatureType AX_Buchungsstelle (ax_buchungsstelle) 1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.isteinverweisaufflurstueck IS 'Assoziation zu: FeatureType AX_Flurstueck (ax_flurstueck) 1';
COMMENT ON COLUMN ax_flurstueckgrundbuch.einbezogenin IS 'Assoziation zu: FeatureType AX_BauRaumOderBodenordnungsrechtGrundbuch (ax_bauraumoderbodenordnungsrechtgrundbuch) 0..*';
CREATE TABLE ax_bauraumoderbodenordnungsrechtgrundbuch (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  anlassbauraumoderbodenordnungsrecht character varying,
  artderfestlegung integer NOT NULL,
  land character varying,
  stelle character varying,
  ausfuehrendestellebezeichnung character varying,
  bezeichnung character varying,
  datumabgabe date,
  datumanordnung date,
  datumbesitzeinweisung date,
  datumrechtskraeftig date,
  lebenszeitintervallbauraumoderbodenordnungsrecht_beginnt character(20) NOT NULL,
  lebenszeitintervallbauraumoderbodenordnungsrecht_endet character(20),
  name character varying,
  istteilvon character(16)[],
  isteinverweisaufbauraumoderbodenordnungsrecht character(16) NOT NULL,
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_bauraumoderbodenordnungsrechtgrundbuch_gml ON ax_bauraumoderbodenordnungsrechtgrundbuch USING btree (gml_id,beginnt);
CREATE INDEX ax_bauraumoderbodenordnungsrechtgrundbuch_endet ON ax_bauraumoderbodenordnungsrechtgrundbuch USING btree (endet);
CREATE INDEX ax_brobg_isteinverweisaufbauraumoderbodenordnungsrecht ON ax_bauraumoderbodenordnungsrechtgrundbuch USING btree (isteinverweisaufbauraumoderbodenordnungsrecht);
CREATE INDEX ax_bauraumoderbodenordnungsrechtgrundbuch_istteilvon ON ax_bauraumoderbodenordnungsrechtgrundbuch USING gin (istteilvon);

COMMENT ON TABLE ax_bauraumoderbodenordnungsrechtgrundbuch IS 'FeatureType: "AX_BauRaumOderBodenordnungsrechtGrundbuch"';
COMMENT ON COLUMN ax_bauraumoderbodenordnungsrechtgrundbuch.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_bauraumoderbodenordnungsrechtgrundbuch.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_bauraumoderbodenordnungsrechtgrundbuch.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_bauraumoderbodenordnungsrechtgrundbuch.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_bauraumoderbodenordnungsrechtgrundbuch.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_bauraumoderbodenordnungsrechtgrundbuch.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_bauraumoderbodenordnungsrechtgrundbuch.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_bauraumoderbodenordnungsrechtgrundbuch.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_bauraumoderbodenordnungsrechtgrundbuch.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_bauraumoderbodenordnungsrechtgrundbuch.anlassbauraumoderbodenordnungsrecht IS 'anlassBauRaumOderBodenordnungsrecht codelist AA_Anlassart 0..1';
COMMENT ON COLUMN ax_bauraumoderbodenordnungsrechtgrundbuch.artderfestlegung IS 'artDerFestlegung enumeration AX_ArtDerFestlegung_BauRaumOderBodenordnungsrecht 1';
COMMENT ON COLUMN ax_bauraumoderbodenordnungsrechtgrundbuch.land IS 'ausfuehrendeStelle|AX_Dienststelle_Schluessel|land  CharacterString 1';
COMMENT ON COLUMN ax_bauraumoderbodenordnungsrechtgrundbuch.stelle IS 'ausfuehrendeStelle|AX_Dienststelle_Schluessel|stelle  CharacterString 1';
COMMENT ON COLUMN ax_bauraumoderbodenordnungsrechtgrundbuch.ausfuehrendestellebezeichnung IS 'ausfuehrendeStelleBezeichnung  CharacterString 0..1';
COMMENT ON COLUMN ax_bauraumoderbodenordnungsrechtgrundbuch.bezeichnung IS 'bezeichnung  CharacterString 0..1';
COMMENT ON COLUMN ax_bauraumoderbodenordnungsrechtgrundbuch.datumabgabe IS 'datumAbgabe  Date 0..1';
COMMENT ON COLUMN ax_bauraumoderbodenordnungsrechtgrundbuch.datumanordnung IS 'datumAnordnung  Date 0..1';
COMMENT ON COLUMN ax_bauraumoderbodenordnungsrechtgrundbuch.datumbesitzeinweisung IS 'datumBesitzeinweisung  Date 0..1';
COMMENT ON COLUMN ax_bauraumoderbodenordnungsrechtgrundbuch.datumrechtskraeftig IS 'datumRechtskraeftig  Date 0..1';
COMMENT ON COLUMN ax_bauraumoderbodenordnungsrechtgrundbuch.lebenszeitintervallbauraumoderbodenordnungsrecht_beginnt IS 'lebenszeitintervallBauRaumOderBodenordnungsrecht|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_bauraumoderbodenordnungsrechtgrundbuch.lebenszeitintervallbauraumoderbodenordnungsrecht_endet IS 'lebenszeitintervallBauRaumOderBodenordnungsrecht|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_bauraumoderbodenordnungsrechtgrundbuch.name IS 'name  CharacterString 0..1';
COMMENT ON COLUMN ax_bauraumoderbodenordnungsrechtgrundbuch.isteinverweisaufbauraumoderbodenordnungsrecht IS 'Assoziation zu: FeatureType AX_BauRaumOderBodenordnungsrecht (ax_bauraumoderbodenordnungsrecht) 1';
CREATE TABLE ap_lpo (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  art character varying,
  darstellungsprioritaet integer,
  signaturnummer character varying,
  hatdirektunten character(16)[],
  istabgeleitetaus character(16)[],
  traegtbeizu character(16)[],
  istteilvon character(16)[],
  dientzurdarstellungvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ap_lpo_gml ON ap_lpo USING btree (gml_id,beginnt);
CREATE INDEX ap_lpo_endet ON ap_lpo USING btree (endet);
SELECT AddGeometryColumn('ap_lpo', 'wkb_geometry', :alkis_epsg, 'GEOMETRY', 2);
CREATE INDEX ap_lpo_wkb_geometry_idx ON ap_lpo USING gist (wkb_geometry);
CREATE INDEX ap_lpo_dientzurdarstellungvon ON ap_lpo USING gin (dientzurdarstellungvon);
CREATE INDEX ap_lpo_hatdirektunten ON ap_lpo USING gin (hatdirektunten);
CREATE INDEX ap_lpo_istabgeleitetaus ON ap_lpo USING gin (istabgeleitetaus);
CREATE INDEX ap_lpo_traegtbeizu ON ap_lpo USING gin (traegtbeizu);
CREATE INDEX ap_lpo_istteilvon ON ap_lpo USING gin (istteilvon);

COMMENT ON TABLE ap_lpo IS 'FeatureType: "AP_LPO"';
COMMENT ON COLUMN ap_lpo.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ap_lpo.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ap_lpo.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ap_lpo.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ap_lpo.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ap_lpo.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ap_lpo.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ap_lpo.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ap_lpo.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ap_lpo.wkb_geometry IS 'wkb_geometry  GM_MultiCurve 0..1';
COMMENT ON COLUMN ap_lpo.art IS 'art  CharacterString 0..1';
COMMENT ON COLUMN ap_lpo.darstellungsprioritaet IS 'darstellungsprioritaet  Integer 0..1';
COMMENT ON COLUMN ap_lpo.signaturnummer IS 'signaturnummer  CharacterString 0..1';
COMMENT ON COLUMN ap_lpo.dientzurdarstellungvon IS 'Assoziation zu: FeatureType AA_Objekt (aa_objekt) 0..*';
CREATE TABLE ax_seilbahnschwebebahn (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  bahnkategorie integer NOT NULL,
  ergebnisderueberpruefung integer,
  name character varying,
  statement character varying,
  processstep_ax_li_processstep_mitdatenerhebung_description character varying[],
  processstep_rationale character varying[],
  processstep_datetime character(20)[],
  processstep_individualname character varying[],
  processstep_organisationname character varying[],
  processstep_positionname character varying[],
  processstep_phone character varying[],
  processstep_address character varying[],
  processstep_onlineresource character varying[],
  processstep_hoursofservice character varying[],
  processstep_contactinstructions character varying[],
  processstep_role character varying[],
  processstep_ax_datenerhebung character varying[],
  processstep_scaledenominator character varying[],
  processstep_sourcereferencesystem character varying[],
  processstep_sourceextent character varying[],
  processstep_sourcestep character varying[],
  herkunft_source_source_ax_datenerhebung character varying[],
  herkunft_source_source_scaledenominator character varying[],
  herkunft_source_source_sourcereferencesystem character varying[],
  herkunft_source_source_sourceextent character varying[],
  herkunft_source_source_sourcestep character varying[],
  hatdirektunten character(16)[],
  istabgeleitetaus character(16)[],
  traegtbeizu character(16)[],
  istteilvon character(16)[],
  hat3d character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_seilbahnschwebebahn_gml ON ax_seilbahnschwebebahn USING btree (gml_id,beginnt);
CREATE INDEX ax_seilbahnschwebebahn_endet ON ax_seilbahnschwebebahn USING btree (endet);
SELECT AddGeometryColumn('ax_seilbahnschwebebahn', 'wkb_geometry', :alkis_epsg, 'GEOMETRY', 2);
CREATE INDEX ax_seilbahnschwebebahn_wkb_geometry_idx ON ax_seilbahnschwebebahn USING gist (wkb_geometry);
CREATE INDEX ax_seilbahnschwebebahn_hat3d ON ax_seilbahnschwebebahn USING gin (hat3d);
CREATE INDEX ax_seilbahnschwebebahn_hatdirektunten ON ax_seilbahnschwebebahn USING gin (hatdirektunten);
CREATE INDEX ax_seilbahnschwebebahn_istabgeleitetaus ON ax_seilbahnschwebebahn USING gin (istabgeleitetaus);
CREATE INDEX ax_seilbahnschwebebahn_traegtbeizu ON ax_seilbahnschwebebahn USING gin (traegtbeizu);
CREATE INDEX ax_seilbahnschwebebahn_istteilvon ON ax_seilbahnschwebebahn USING gin (istteilvon);

COMMENT ON TABLE ax_seilbahnschwebebahn IS 'FeatureType: "AX_SeilbahnSchwebebahn"';
COMMENT ON COLUMN ax_seilbahnschwebebahn.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_seilbahnschwebebahn.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.wkb_geometry IS 'wkb_geometry  GM_MultiCurve 0..1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.bahnkategorie IS 'bahnkategorie enumeration AX_Bahnkategorie_SeilbahnSchwebebahn 1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.ergebnisderueberpruefung IS 'ergebnisDerUeberpruefung enumeration AX_ErgebnisDerUeberpruefung_BauwerkeEinrichtungenUndSonstigeAngaben 0..1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.name IS 'name  CharacterString 0..1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.statement IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|statement|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.processstep_ax_li_processstep_mitdatenerhebung_description IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|description|AX_LI_ProcessStep_MitDatenerhebung_Description enumeration  1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.processstep_rationale IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|rationale|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.processstep_datetime IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|dateTime|DateTime  DateTime 0..1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.processstep_individualname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|individualName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.processstep_organisationname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|organisationName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.processstep_positionname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|positionName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.processstep_phone IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|phone|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.processstep_address IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|address|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.processstep_onlineresource IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|onlineResource|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.processstep_hoursofservice IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|hoursOfService|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.processstep_contactinstructions IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|contactInstructions|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.processstep_role IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|role|CI_RoleCode enumeration CI_RoleCode 1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.processstep_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.processstep_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.processstep_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.processstep_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_seilbahnschwebebahn.processstep_sourcestep IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_seilbahnschwebebahn.herkunft_source_source_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.herkunft_source_source_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.herkunft_source_source_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_seilbahnschwebebahn.herkunft_source_source_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_seilbahnschwebebahn.herkunft_source_source_sourcestep IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_seilbahnschwebebahn.hat3d IS 'Assoziation zu: FeatureType AX_Bauwerk3D (ax_bauwerk3d) 0..*';
CREATE TABLE ax_topographischelinie (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  liniendarstellung integer NOT NULL,
  sonstigeeigenschaft character varying,
  hatdirektunten character(16)[],
  istabgeleitetaus character(16)[],
  traegtbeizu character(16)[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_topographischelinie_gml ON ax_topographischelinie USING btree (gml_id,beginnt);
CREATE INDEX ax_topographischelinie_endet ON ax_topographischelinie USING btree (endet);
SELECT AddGeometryColumn('ax_topographischelinie', 'wkb_geometry', :alkis_epsg, 'GEOMETRY', 2);
CREATE INDEX ax_topographischelinie_wkb_geometry_idx ON ax_topographischelinie USING gist (wkb_geometry);
CREATE INDEX ax_topographischelinie_hatdirektunten ON ax_topographischelinie USING gin (hatdirektunten);
CREATE INDEX ax_topographischelinie_istabgeleitetaus ON ax_topographischelinie USING gin (istabgeleitetaus);
CREATE INDEX ax_topographischelinie_traegtbeizu ON ax_topographischelinie USING gin (traegtbeizu);
CREATE INDEX ax_topographischelinie_istteilvon ON ax_topographischelinie USING gin (istteilvon);

COMMENT ON TABLE ax_topographischelinie IS 'FeatureType: "AX_TopographischeLinie"';
COMMENT ON COLUMN ax_topographischelinie.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_topographischelinie.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_topographischelinie.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_topographischelinie.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_topographischelinie.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_topographischelinie.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_topographischelinie.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_topographischelinie.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_topographischelinie.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_topographischelinie.wkb_geometry IS 'wkb_geometry  GM_MultiCurve 0..1';
COMMENT ON COLUMN ax_topographischelinie.liniendarstellung IS 'liniendarstellung enumeration AX_Liniendarstellung_TopographischeLinie 1';
COMMENT ON COLUMN ax_topographischelinie.sonstigeeigenschaft IS 'sonstigeEigenschaft  CharacterString 0..1';
CREATE TABLE ax_gebaeudeausgestaltung (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  darstellung integer NOT NULL,
  hatdirektunten character(16)[],
  istabgeleitetaus character(16)[],
  traegtbeizu character(16)[],
  istteilvon character(16)[],
  zeigtauf character(16) NOT NULL,
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_gebaeudeausgestaltung_gml ON ax_gebaeudeausgestaltung USING btree (gml_id,beginnt);
CREATE INDEX ax_gebaeudeausgestaltung_endet ON ax_gebaeudeausgestaltung USING btree (endet);
SELECT AddGeometryColumn('ax_gebaeudeausgestaltung', 'wkb_geometry', :alkis_epsg, 'GEOMETRY', 2);
CREATE INDEX ax_gebaeudeausgestaltung_wkb_geometry_idx ON ax_gebaeudeausgestaltung USING gist (wkb_geometry);
CREATE INDEX ax_gebaeudeausgestaltung_zeigtauf ON ax_gebaeudeausgestaltung USING btree (zeigtauf);
CREATE INDEX ax_gebaeudeausgestaltung_hatdirektunten ON ax_gebaeudeausgestaltung USING gin (hatdirektunten);
CREATE INDEX ax_gebaeudeausgestaltung_istabgeleitetaus ON ax_gebaeudeausgestaltung USING gin (istabgeleitetaus);
CREATE INDEX ax_gebaeudeausgestaltung_traegtbeizu ON ax_gebaeudeausgestaltung USING gin (traegtbeizu);
CREATE INDEX ax_gebaeudeausgestaltung_istteilvon ON ax_gebaeudeausgestaltung USING gin (istteilvon);

COMMENT ON TABLE ax_gebaeudeausgestaltung IS 'FeatureType: "AX_Gebaeudeausgestaltung"';
COMMENT ON COLUMN ax_gebaeudeausgestaltung.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_gebaeudeausgestaltung.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_gebaeudeausgestaltung.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_gebaeudeausgestaltung.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_gebaeudeausgestaltung.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_gebaeudeausgestaltung.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_gebaeudeausgestaltung.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_gebaeudeausgestaltung.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_gebaeudeausgestaltung.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_gebaeudeausgestaltung.wkb_geometry IS 'wkb_geometry  GM_MultiCurve 0..1';
COMMENT ON COLUMN ax_gebaeudeausgestaltung.darstellung IS 'darstellung enumeration AX_Darstellung_Gebaeudeausgestaltung 1';
COMMENT ON COLUMN ax_gebaeudeausgestaltung.zeigtauf IS 'Assoziation zu: FeatureType AX_Gebaeude (ax_gebaeude) 1';
CREATE TABLE ax_abgeleitetehoehenlinie (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  aktualisierungsdatum date,
  erfassungsdatum date,
  nameofmeasure character varying[],
  measureidentification character varying,
  measuredescription character varying,
  evaluationmethodtype character varying,
  evaluationmethoddescription character varying,
  evaluationprocedure character varying,
  datetime character(20)[],
  result character varying[],
  hoehe double precision NOT NULL,
  massstabszahl integer,
  verwendeteobjekte integer[],
  hatdirektunten character(16)[],
  istabgeleitetaus character(16)[],
  traegtbeizu character(16)[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_abgeleitetehoehenlinie_gml ON ax_abgeleitetehoehenlinie USING btree (gml_id,beginnt);
CREATE INDEX ax_abgeleitetehoehenlinie_endet ON ax_abgeleitetehoehenlinie USING btree (endet);
SELECT AddGeometryColumn('ax_abgeleitetehoehenlinie', 'wkb_geometry', :alkis_epsg, 'GEOMETRY', 2);
CREATE INDEX ax_abgeleitetehoehenlinie_wkb_geometry_idx ON ax_abgeleitetehoehenlinie USING gist (wkb_geometry);
CREATE INDEX ax_abgeleitetehoehenlinie_hatdirektunten ON ax_abgeleitetehoehenlinie USING gin (hatdirektunten);
CREATE INDEX ax_abgeleitetehoehenlinie_istabgeleitetaus ON ax_abgeleitetehoehenlinie USING gin (istabgeleitetaus);
CREATE INDEX ax_abgeleitetehoehenlinie_traegtbeizu ON ax_abgeleitetehoehenlinie USING gin (traegtbeizu);
CREATE INDEX ax_abgeleitetehoehenlinie_istteilvon ON ax_abgeleitetehoehenlinie USING gin (istteilvon);

COMMENT ON TABLE ax_abgeleitetehoehenlinie IS 'FeatureType: "AX_AbgeleiteteHoehenlinie"';
COMMENT ON COLUMN ax_abgeleitetehoehenlinie.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_abgeleitetehoehenlinie.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_abgeleitetehoehenlinie.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_abgeleitetehoehenlinie.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_abgeleitetehoehenlinie.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_abgeleitetehoehenlinie.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_abgeleitetehoehenlinie.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_abgeleitetehoehenlinie.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_abgeleitetehoehenlinie.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_abgeleitetehoehenlinie.wkb_geometry IS 'wkb_geometry  GM_MultiCurve 0..1';
COMMENT ON COLUMN ax_abgeleitetehoehenlinie.aktualisierungsdatum IS 'aktualisierungsdatum  Date 0..1';
COMMENT ON COLUMN ax_abgeleitetehoehenlinie.erfassungsdatum IS 'erfassungsdatum  Date 0..1';
COMMENT ON COLUMN ax_abgeleitetehoehenlinie.nameofmeasure IS 'genauigkeit|DQ_AbsoluteExternalPositionalAccuracy|nameOfMeasure|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_abgeleitetehoehenlinie.measureidentification IS 'genauigkeit|DQ_AbsoluteExternalPositionalAccuracy|measureIdentification|MD_Identifier  MD_Identifier 0..1';
COMMENT ON COLUMN ax_abgeleitetehoehenlinie.measuredescription IS 'genauigkeit|DQ_AbsoluteExternalPositionalAccuracy|measureDescription|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_abgeleitetehoehenlinie.evaluationmethodtype IS 'genauigkeit|DQ_AbsoluteExternalPositionalAccuracy|evaluationMethodType|DQ_EvaluationMethodTypeCode  DQ_EvaluationMethodTypeCode 0..1';
COMMENT ON COLUMN ax_abgeleitetehoehenlinie.evaluationmethoddescription IS 'genauigkeit|DQ_AbsoluteExternalPositionalAccuracy|evaluationMethodDescription|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_abgeleitetehoehenlinie.evaluationprocedure IS 'genauigkeit|DQ_AbsoluteExternalPositionalAccuracy|evaluationProcedure|CI_Citation  CI_Citation 0..1';
COMMENT ON COLUMN ax_abgeleitetehoehenlinie.datetime IS 'genauigkeit|DQ_AbsoluteExternalPositionalAccuracy|dateTime|DateTime  DateTime 0..*';
COMMENT ON COLUMN ax_abgeleitetehoehenlinie.result IS 'genauigkeit|DQ_AbsoluteExternalPositionalAccuracy|result|DQ_Result  DQ_Result 1..*';
COMMENT ON COLUMN ax_abgeleitetehoehenlinie.hoehe IS 'hoehe  Length 1';
COMMENT ON COLUMN ax_abgeleitetehoehenlinie.massstabszahl IS 'massstabszahl  Integer 0..1';
COMMENT ON COLUMN ax_abgeleitetehoehenlinie.verwendeteobjekte IS 'verwendeteObjekte enumeration AX_VerwendeteObjekte_AbgeleiteteHoehenlinie 0..*';
CREATE TABLE ax_hoehenlinie (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  hoehevonhoehenlinie double precision NOT NULL,
  statement character varying,
  processstep_ax_li_processstep_mitdatenerhebung_description character varying[],
  processstep_rationale character varying[],
  processstep_datetime character(20)[],
  processstep_individualname character varying[],
  processstep_organisationname character varying[],
  processstep_positionname character varying[],
  processstep_phone character varying[],
  processstep_address character varying[],
  processstep_onlineresource character varying[],
  processstep_hoursofservice character varying[],
  processstep_contactinstructions character varying[],
  processstep_role character varying[],
  processstep_ax_datenerhebung character varying[],
  processstep_scaledenominator character varying[],
  processstep_sourcereferencesystem character varying[],
  processstep_sourceextent character varying[],
  processstep_sourcestep character varying[],
  herkunft_source_source_ax_datenerhebung character varying[],
  herkunft_source_source_scaledenominator character varying[],
  herkunft_source_source_sourcereferencesystem character varying[],
  herkunft_source_source_sourceextent character varying[],
  herkunft_source_source_sourcestep character varying[],
  hatdirektunten character(16)[],
  istabgeleitetaus character(16)[],
  traegtbeizu character(16)[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_hoehenlinie_gml ON ax_hoehenlinie USING btree (gml_id,beginnt);
CREATE INDEX ax_hoehenlinie_endet ON ax_hoehenlinie USING btree (endet);
SELECT AddGeometryColumn('ax_hoehenlinie', 'wkb_geometry', :alkis_epsg, 'GEOMETRY', 2);
CREATE INDEX ax_hoehenlinie_wkb_geometry_idx ON ax_hoehenlinie USING gist (wkb_geometry);
CREATE INDEX ax_hoehenlinie_hatdirektunten ON ax_hoehenlinie USING gin (hatdirektunten);
CREATE INDEX ax_hoehenlinie_istabgeleitetaus ON ax_hoehenlinie USING gin (istabgeleitetaus);
CREATE INDEX ax_hoehenlinie_traegtbeizu ON ax_hoehenlinie USING gin (traegtbeizu);
CREATE INDEX ax_hoehenlinie_istteilvon ON ax_hoehenlinie USING gin (istteilvon);

COMMENT ON TABLE ax_hoehenlinie IS 'FeatureType: "AX_Hoehenlinie"';
COMMENT ON COLUMN ax_hoehenlinie.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_hoehenlinie.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_hoehenlinie.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_hoehenlinie.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_hoehenlinie.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_hoehenlinie.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_hoehenlinie.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_hoehenlinie.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_hoehenlinie.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_hoehenlinie.wkb_geometry IS 'wkb_geometry  GM_MultiCurve 0..1';
COMMENT ON COLUMN ax_hoehenlinie.hoehevonhoehenlinie IS 'hoeheVonHoehenlinie  Length 1';
COMMENT ON COLUMN ax_hoehenlinie.statement IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|statement|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_hoehenlinie.processstep_ax_li_processstep_mitdatenerhebung_description IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|description|AX_LI_ProcessStep_MitDatenerhebung_Description enumeration  1';
COMMENT ON COLUMN ax_hoehenlinie.processstep_rationale IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|rationale|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_hoehenlinie.processstep_datetime IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|dateTime|DateTime  DateTime 0..1';
COMMENT ON COLUMN ax_hoehenlinie.processstep_individualname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|individualName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_hoehenlinie.processstep_organisationname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|organisationName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_hoehenlinie.processstep_positionname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|positionName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_hoehenlinie.processstep_phone IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|phone|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_hoehenlinie.processstep_address IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|address|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_hoehenlinie.processstep_onlineresource IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|onlineResource|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_hoehenlinie.processstep_hoursofservice IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|hoursOfService|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_hoehenlinie.processstep_contactinstructions IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|contactInstructions|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_hoehenlinie.processstep_role IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|role|CI_RoleCode enumeration CI_RoleCode 1';
COMMENT ON COLUMN ax_hoehenlinie.processstep_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_hoehenlinie.processstep_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_hoehenlinie.processstep_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_hoehenlinie.processstep_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_hoehenlinie.processstep_sourcestep IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_hoehenlinie.herkunft_source_source_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_hoehenlinie.herkunft_source_source_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_hoehenlinie.herkunft_source_source_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_hoehenlinie.herkunft_source_source_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_hoehenlinie.herkunft_source_source_sourcestep IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
CREATE TABLE ax_einschnitt (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  funktion integer,
  tiefevoneinschnitt double precision,
  hatdirektunten character(16)[],
  istabgeleitetaus character(16)[],
  traegtbeizu character(16)[],
  istteilvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_einschnitt_gml ON ax_einschnitt USING btree (gml_id,beginnt);
CREATE INDEX ax_einschnitt_endet ON ax_einschnitt USING btree (endet);
SELECT AddGeometryColumn('ax_einschnitt', 'wkb_geometry', :alkis_epsg, 'GEOMETRY', 2);
CREATE INDEX ax_einschnitt_wkb_geometry_idx ON ax_einschnitt USING gist (wkb_geometry);
CREATE INDEX ax_einschnitt_hatdirektunten ON ax_einschnitt USING gin (hatdirektunten);
CREATE INDEX ax_einschnitt_istabgeleitetaus ON ax_einschnitt USING gin (istabgeleitetaus);
CREATE INDEX ax_einschnitt_traegtbeizu ON ax_einschnitt USING gin (traegtbeizu);
CREATE INDEX ax_einschnitt_istteilvon ON ax_einschnitt USING gin (istteilvon);

COMMENT ON TABLE ax_einschnitt IS 'FeatureType: "AX_Einschnitt"';
COMMENT ON COLUMN ax_einschnitt.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_einschnitt.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_einschnitt.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_einschnitt.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_einschnitt.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_einschnitt.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_einschnitt.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_einschnitt.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_einschnitt.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_einschnitt.wkb_geometry IS 'wkb_geometry  GM_MultiCurve 0..1';
COMMENT ON COLUMN ax_einschnitt.funktion IS 'funktion enumeration AX_Funktion_Einschnitt 0..1';
COMMENT ON COLUMN ax_einschnitt.tiefevoneinschnitt IS 'tiefeVonEinschnitt  Length 0..1';
CREATE TABLE ap_ppo (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  art character varying,
  darstellungsprioritaet integer,
  drehwinkel double precision,
  signaturnummer character varying,
  skalierung double precision,
  hatdirektunten character(16)[],
  istabgeleitetaus character(16)[],
  traegtbeizu character(16)[],
  istteilvon character(16)[],
  dientzurdarstellungvon character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ap_ppo_gml ON ap_ppo USING btree (gml_id,beginnt);
CREATE INDEX ap_ppo_endet ON ap_ppo USING btree (endet);
SELECT AddGeometryColumn('ap_ppo', 'wkb_geometry', :alkis_epsg, 'GEOMETRY', 2);
CREATE INDEX ap_ppo_wkb_geometry_idx ON ap_ppo USING gist (wkb_geometry);
CREATE INDEX ap_ppo_dientzurdarstellungvon ON ap_ppo USING gin (dientzurdarstellungvon);
CREATE INDEX ap_ppo_hatdirektunten ON ap_ppo USING gin (hatdirektunten);
CREATE INDEX ap_ppo_istabgeleitetaus ON ap_ppo USING gin (istabgeleitetaus);
CREATE INDEX ap_ppo_traegtbeizu ON ap_ppo USING gin (traegtbeizu);
CREATE INDEX ap_ppo_istteilvon ON ap_ppo USING gin (istteilvon);

COMMENT ON TABLE ap_ppo IS 'FeatureType: "AP_PPO"';
COMMENT ON COLUMN ap_ppo.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ap_ppo.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ap_ppo.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ap_ppo.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ap_ppo.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ap_ppo.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ap_ppo.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ap_ppo.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ap_ppo.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ap_ppo.wkb_geometry IS 'wkb_geometry  GM_MultiPoint 0..1';
COMMENT ON COLUMN ap_ppo.art IS 'art  CharacterString 0..1';
COMMENT ON COLUMN ap_ppo.darstellungsprioritaet IS 'darstellungsprioritaet  Integer 0..1';
COMMENT ON COLUMN ap_ppo.drehwinkel IS 'drehwinkel  Angle 0..1';
COMMENT ON COLUMN ap_ppo.signaturnummer IS 'signaturnummer  CharacterString 0..1';
COMMENT ON COLUMN ap_ppo.skalierung IS 'skalierung  Real 0..1';
COMMENT ON COLUMN ap_ppo.dientzurdarstellungvon IS 'Assoziation zu: FeatureType AA_Objekt (aa_objekt) 0..*';
CREATE TABLE ap_lto (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  art character varying,
  darstellungsprioritaet integer,
  fontsperrung double precision NOT NULL,
  horizontaleausrichtung character varying NOT NULL,
  schriftinhalt character varying,
  signaturnummer character varying,
  skalierung double precision NOT NULL,
  vertikaleausrichtung character varying NOT NULL,
  hatdirektunten character(16)[],
  istabgeleitetaus character(16)[],
  traegtbeizu character(16)[],
  istteilvon character(16)[],
  dientzurdarstellungvon character(16)[],
  hat character(16),
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ap_lto_gml ON ap_lto USING btree (gml_id,beginnt);
CREATE INDEX ap_lto_endet ON ap_lto USING btree (endet);
SELECT AddGeometryColumn('ap_lto', 'wkb_geometry', :alkis_epsg, 'GEOMETRY', 2);
CREATE INDEX ap_lto_wkb_geometry_idx ON ap_lto USING gist (wkb_geometry);
CREATE INDEX ap_lto_dientzurdarstellungvon ON ap_lto USING gin (dientzurdarstellungvon);
CREATE INDEX ap_lto_hat ON ap_lto USING btree (hat);
CREATE INDEX ap_lto_hatdirektunten ON ap_lto USING gin (hatdirektunten);
CREATE INDEX ap_lto_istabgeleitetaus ON ap_lto USING gin (istabgeleitetaus);
CREATE INDEX ap_lto_traegtbeizu ON ap_lto USING gin (traegtbeizu);
CREATE INDEX ap_lto_istteilvon ON ap_lto USING gin (istteilvon);

COMMENT ON TABLE ap_lto IS 'FeatureType: "AP_LTO"';
COMMENT ON COLUMN ap_lto.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ap_lto.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ap_lto.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ap_lto.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ap_lto.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ap_lto.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ap_lto.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ap_lto.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ap_lto.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ap_lto.wkb_geometry IS 'wkb_geometry  GM_Curve 0..1';
COMMENT ON COLUMN ap_lto.art IS 'art  CharacterString 0..1';
COMMENT ON COLUMN ap_lto.darstellungsprioritaet IS 'darstellungsprioritaet  Integer 0..1';
COMMENT ON COLUMN ap_lto.fontsperrung IS 'fontSperrung  Real 1';
COMMENT ON COLUMN ap_lto.horizontaleausrichtung IS 'horizontaleAusrichtung enumeration AP_HorizontaleAusrichtung 1';
COMMENT ON COLUMN ap_lto.schriftinhalt IS 'schriftinhalt  CharacterString 0..1';
COMMENT ON COLUMN ap_lto.signaturnummer IS 'signaturnummer  CharacterString 0..1';
COMMENT ON COLUMN ap_lto.skalierung IS 'skalierung  Real 1';
COMMENT ON COLUMN ap_lto.vertikaleausrichtung IS 'vertikaleAusrichtung enumeration AP_VertikaleAusrichtung 1';
COMMENT ON COLUMN ap_lto.dientzurdarstellungvon IS 'Assoziation zu: FeatureType AA_Objekt (aa_objekt) 0..*';
COMMENT ON COLUMN ap_lto.hat IS 'Assoziation zu: FeatureType AP_LPO (ap_lpo) 0..1';
CREATE TABLE ax_abschnitt (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  bezeichnung character varying NOT NULL,
  ergebnisderueberpruefung integer,
  statement character varying,
  processstep_ax_li_processstep_mitdatenerhebung_description character varying[],
  processstep_rationale character varying[],
  processstep_datetime character(20)[],
  processstep_individualname character varying[],
  processstep_organisationname character varying[],
  processstep_positionname character varying[],
  processstep_phone character varying[],
  processstep_address character varying[],
  processstep_onlineresource character varying[],
  processstep_hoursofservice character varying[],
  processstep_contactinstructions character varying[],
  processstep_role character varying[],
  processstep_ax_datenerhebung character varying[],
  processstep_scaledenominator character varying[],
  processstep_sourcereferencesystem character varying[],
  processstep_sourceextent character varying[],
  processstep_sourcestep character varying[],
  herkunft_source_source_ax_datenerhebung character varying[],
  herkunft_source_source_scaledenominator character varying[],
  herkunft_source_source_sourcereferencesystem character varying[],
  herkunft_source_source_sourceextent character varying[],
  herkunft_source_source_sourcestep character varying[],
  hatdirektunten character(16)[],
  istabgeleitetaus character(16)[],
  traegtbeizu character(16)[],
  istteilvon character(16)[],
  hat3d character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_abschnitt_gml ON ax_abschnitt USING btree (gml_id,beginnt);
CREATE INDEX ax_abschnitt_endet ON ax_abschnitt USING btree (endet);
SELECT AddGeometryColumn('ax_abschnitt', 'wkb_geometry', :alkis_epsg, 'GEOMETRY', 2);
CREATE INDEX ax_abschnitt_wkb_geometry_idx ON ax_abschnitt USING gist (wkb_geometry);
CREATE INDEX ax_abschnitt_hat3d ON ax_abschnitt USING gin (hat3d);
CREATE INDEX ax_abschnitt_hatdirektunten ON ax_abschnitt USING gin (hatdirektunten);
CREATE INDEX ax_abschnitt_istabgeleitetaus ON ax_abschnitt USING gin (istabgeleitetaus);
CREATE INDEX ax_abschnitt_traegtbeizu ON ax_abschnitt USING gin (traegtbeizu);
CREATE INDEX ax_abschnitt_istteilvon ON ax_abschnitt USING gin (istteilvon);

COMMENT ON TABLE ax_abschnitt IS 'FeatureType: "AX_Abschnitt"';
COMMENT ON COLUMN ax_abschnitt.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_abschnitt.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_abschnitt.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_abschnitt.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_abschnitt.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_abschnitt.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_abschnitt.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_abschnitt.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_abschnitt.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_abschnitt.wkb_geometry IS 'wkb_geometry  GM_Curve 0..1';
COMMENT ON COLUMN ax_abschnitt.bezeichnung IS 'bezeichnung  CharacterString 1';
COMMENT ON COLUMN ax_abschnitt.ergebnisderueberpruefung IS 'ergebnisDerUeberpruefung enumeration AX_ErgebnisDerUeberpruefung_BauwerkeEinrichtungenUndSonstigeAngaben 0..1';
COMMENT ON COLUMN ax_abschnitt.statement IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|statement|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_abschnitt.processstep_ax_li_processstep_mitdatenerhebung_description IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|description|AX_LI_ProcessStep_MitDatenerhebung_Description enumeration  1';
COMMENT ON COLUMN ax_abschnitt.processstep_rationale IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|rationale|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_abschnitt.processstep_datetime IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|dateTime|DateTime  DateTime 0..1';
COMMENT ON COLUMN ax_abschnitt.processstep_individualname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|individualName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_abschnitt.processstep_organisationname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|organisationName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_abschnitt.processstep_positionname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|positionName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_abschnitt.processstep_phone IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|phone|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_abschnitt.processstep_address IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|address|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_abschnitt.processstep_onlineresource IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|onlineResource|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_abschnitt.processstep_hoursofservice IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|hoursOfService|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_abschnitt.processstep_contactinstructions IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|contactInstructions|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_abschnitt.processstep_role IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|role|CI_RoleCode enumeration CI_RoleCode 1';
COMMENT ON COLUMN ax_abschnitt.processstep_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_abschnitt.processstep_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_abschnitt.processstep_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_abschnitt.processstep_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_abschnitt.processstep_sourcestep IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_abschnitt.herkunft_source_source_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_abschnitt.herkunft_source_source_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_abschnitt.herkunft_source_source_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_abschnitt.herkunft_source_source_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_abschnitt.herkunft_source_source_sourcestep IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_abschnitt.hat3d IS 'Assoziation zu: FeatureType AX_Bauwerk3D (ax_bauwerk3d) 0..*';
CREATE TABLE ax_ast (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  bezeichnung character varying NOT NULL,
  ergebnisderueberpruefung integer,
  statement character varying,
  processstep_ax_li_processstep_mitdatenerhebung_description character varying[],
  processstep_rationale character varying[],
  processstep_datetime character(20)[],
  processstep_individualname character varying[],
  processstep_organisationname character varying[],
  processstep_positionname character varying[],
  processstep_phone character varying[],
  processstep_address character varying[],
  processstep_onlineresource character varying[],
  processstep_hoursofservice character varying[],
  processstep_contactinstructions character varying[],
  processstep_role character varying[],
  processstep_ax_datenerhebung character varying[],
  processstep_scaledenominator character varying[],
  processstep_sourcereferencesystem character varying[],
  processstep_sourceextent character varying[],
  processstep_sourcestep character varying[],
  herkunft_source_source_ax_datenerhebung character varying[],
  herkunft_source_source_scaledenominator character varying[],
  herkunft_source_source_sourcereferencesystem character varying[],
  herkunft_source_source_sourceextent character varying[],
  herkunft_source_source_sourcestep character varying[],
  hatdirektunten character(16)[],
  istabgeleitetaus character(16)[],
  traegtbeizu character(16)[],
  istteilvon character(16)[],
  hat3d character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_ast_gml ON ax_ast USING btree (gml_id,beginnt);
CREATE INDEX ax_ast_endet ON ax_ast USING btree (endet);
SELECT AddGeometryColumn('ax_ast', 'wkb_geometry', :alkis_epsg, 'GEOMETRY', 2);
CREATE INDEX ax_ast_wkb_geometry_idx ON ax_ast USING gist (wkb_geometry);
CREATE INDEX ax_ast_hat3d ON ax_ast USING gin (hat3d);
CREATE INDEX ax_ast_hatdirektunten ON ax_ast USING gin (hatdirektunten);
CREATE INDEX ax_ast_istabgeleitetaus ON ax_ast USING gin (istabgeleitetaus);
CREATE INDEX ax_ast_traegtbeizu ON ax_ast USING gin (traegtbeizu);
CREATE INDEX ax_ast_istteilvon ON ax_ast USING gin (istteilvon);

COMMENT ON TABLE ax_ast IS 'FeatureType: "AX_Ast"';
COMMENT ON COLUMN ax_ast.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_ast.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_ast.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_ast.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_ast.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_ast.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_ast.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_ast.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_ast.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_ast.wkb_geometry IS 'wkb_geometry  GM_Curve 0..1';
COMMENT ON COLUMN ax_ast.bezeichnung IS 'bezeichnung  CharacterString 1';
COMMENT ON COLUMN ax_ast.ergebnisderueberpruefung IS 'ergebnisDerUeberpruefung enumeration AX_ErgebnisDerUeberpruefung_BauwerkeEinrichtungenUndSonstigeAngaben 0..1';
COMMENT ON COLUMN ax_ast.statement IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|statement|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_ast.processstep_ax_li_processstep_mitdatenerhebung_description IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|description|AX_LI_ProcessStep_MitDatenerhebung_Description enumeration  1';
COMMENT ON COLUMN ax_ast.processstep_rationale IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|rationale|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_ast.processstep_datetime IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|dateTime|DateTime  DateTime 0..1';
COMMENT ON COLUMN ax_ast.processstep_individualname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|individualName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_ast.processstep_organisationname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|organisationName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_ast.processstep_positionname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|positionName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_ast.processstep_phone IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|phone|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_ast.processstep_address IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|address|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_ast.processstep_onlineresource IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|onlineResource|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_ast.processstep_hoursofservice IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|hoursOfService|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_ast.processstep_contactinstructions IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|contactInstructions|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_ast.processstep_role IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|role|CI_RoleCode enumeration CI_RoleCode 1';
COMMENT ON COLUMN ax_ast.processstep_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_ast.processstep_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_ast.processstep_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_ast.processstep_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_ast.processstep_sourcestep IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_ast.herkunft_source_source_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_ast.herkunft_source_source_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_ast.herkunft_source_source_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_ast.herkunft_source_source_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_ast.herkunft_source_source_sourcestep IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_ast.hat3d IS 'Assoziation zu: FeatureType AX_Bauwerk3D (ax_bauwerk3d) 0..*';
CREATE TABLE ax_leitung (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  bauwerksfunktion integer NOT NULL,
  ergebnisderueberpruefung integer,
  name character varying,
  statement character varying,
  processstep_ax_li_processstep_mitdatenerhebung_description character varying[],
  processstep_rationale character varying[],
  processstep_datetime character(20)[],
  processstep_individualname character varying[],
  processstep_organisationname character varying[],
  processstep_positionname character varying[],
  processstep_phone character varying[],
  processstep_address character varying[],
  processstep_onlineresource character varying[],
  processstep_hoursofservice character varying[],
  processstep_contactinstructions character varying[],
  processstep_role character varying[],
  processstep_ax_datenerhebung character varying[],
  processstep_scaledenominator character varying[],
  processstep_sourcereferencesystem character varying[],
  processstep_sourceextent character varying[],
  processstep_sourcestep character varying[],
  herkunft_source_source_ax_datenerhebung character varying[],
  herkunft_source_source_scaledenominator character varying[],
  herkunft_source_source_sourcereferencesystem character varying[],
  herkunft_source_source_sourceextent character varying[],
  herkunft_source_source_sourcestep character varying[],
  spannungsebene character varying,
  hatdirektunten character(16)[],
  istabgeleitetaus character(16)[],
  traegtbeizu character(16)[],
  istteilvon character(16)[],
  hat3d character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_leitung_gml ON ax_leitung USING btree (gml_id,beginnt);
CREATE INDEX ax_leitung_endet ON ax_leitung USING btree (endet);
SELECT AddGeometryColumn('ax_leitung', 'wkb_geometry', :alkis_epsg, 'GEOMETRY', 2);
CREATE INDEX ax_leitung_wkb_geometry_idx ON ax_leitung USING gist (wkb_geometry);
CREATE INDEX ax_leitung_hat3d ON ax_leitung USING gin (hat3d);
CREATE INDEX ax_leitung_hatdirektunten ON ax_leitung USING gin (hatdirektunten);
CREATE INDEX ax_leitung_istabgeleitetaus ON ax_leitung USING gin (istabgeleitetaus);
CREATE INDEX ax_leitung_traegtbeizu ON ax_leitung USING gin (traegtbeizu);
CREATE INDEX ax_leitung_istteilvon ON ax_leitung USING gin (istteilvon);

COMMENT ON TABLE ax_leitung IS 'FeatureType: "AX_Leitung"';
COMMENT ON COLUMN ax_leitung.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_leitung.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_leitung.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_leitung.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_leitung.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_leitung.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_leitung.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_leitung.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_leitung.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_leitung.wkb_geometry IS 'wkb_geometry  GM_Curve 0..1';
COMMENT ON COLUMN ax_leitung.bauwerksfunktion IS 'bauwerksfunktion enumeration AX_Bauwerksfunktion_Leitung 1';
COMMENT ON COLUMN ax_leitung.ergebnisderueberpruefung IS 'ergebnisDerUeberpruefung enumeration AX_ErgebnisDerUeberpruefung_BauwerkeEinrichtungenUndSonstigeAngaben 0..1';
COMMENT ON COLUMN ax_leitung.name IS 'name  CharacterString 0..1';
COMMENT ON COLUMN ax_leitung.statement IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|statement|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_leitung.processstep_ax_li_processstep_mitdatenerhebung_description IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|description|AX_LI_ProcessStep_MitDatenerhebung_Description enumeration  1';
COMMENT ON COLUMN ax_leitung.processstep_rationale IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|rationale|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_leitung.processstep_datetime IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|dateTime|DateTime  DateTime 0..1';
COMMENT ON COLUMN ax_leitung.processstep_individualname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|individualName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_leitung.processstep_organisationname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|organisationName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_leitung.processstep_positionname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|positionName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_leitung.processstep_phone IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|phone|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_leitung.processstep_address IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|address|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_leitung.processstep_onlineresource IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|onlineResource|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_leitung.processstep_hoursofservice IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|hoursOfService|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_leitung.processstep_contactinstructions IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|contactInstructions|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_leitung.processstep_role IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|role|CI_RoleCode enumeration CI_RoleCode 1';
COMMENT ON COLUMN ax_leitung.processstep_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_leitung.processstep_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_leitung.processstep_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_leitung.processstep_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_leitung.processstep_sourcestep IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_leitung.herkunft_source_source_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_leitung.herkunft_source_source_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_leitung.herkunft_source_source_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_leitung.herkunft_source_source_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_leitung.herkunft_source_source_sourcestep IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_leitung.spannungsebene IS 'spannungsebene  Measure 0..1';
COMMENT ON COLUMN ax_leitung.hat3d IS 'Assoziation zu: FeatureType AX_Bauwerk3D (ax_bauwerk3d) 0..*';
CREATE TABLE ax_wegpfadsteig (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  art integer,
  befestigung integer,
  bezeichnung character varying,
  breitedesverkehrsweges integer,
  ergebnisderueberpruefung integer,
  markierung integer[],
  name character varying,
  statement character varying,
  processstep_ax_li_processstep_mitdatenerhebung_description character varying[],
  processstep_rationale character varying[],
  processstep_datetime character(20)[],
  processstep_individualname character varying[],
  processstep_organisationname character varying[],
  processstep_positionname character varying[],
  processstep_phone character varying[],
  processstep_address character varying[],
  processstep_onlineresource character varying[],
  processstep_hoursofservice character varying[],
  processstep_contactinstructions character varying[],
  processstep_role character varying[],
  processstep_ax_datenerhebung character varying[],
  processstep_scaledenominator character varying[],
  processstep_sourcereferencesystem character varying[],
  processstep_sourceextent character varying[],
  processstep_sourcestep character varying[],
  herkunft_source_source_ax_datenerhebung character varying[],
  herkunft_source_source_scaledenominator character varying[],
  herkunft_source_source_sourcereferencesystem character varying[],
  herkunft_source_source_sourceextent character varying[],
  herkunft_source_source_sourcestep character varying[],
  regionalsprache character varying[],
  strassenschluessel character varying,
  zweitname character varying[],
  hatdirektunten character(16)[],
  istabgeleitetaus character(16)[],
  traegtbeizu character(16)[],
  istteilvon character(16)[],
  hat3d character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_wegpfadsteig_gml ON ax_wegpfadsteig USING btree (gml_id,beginnt);
CREATE INDEX ax_wegpfadsteig_endet ON ax_wegpfadsteig USING btree (endet);
SELECT AddGeometryColumn('ax_wegpfadsteig', 'wkb_geometry', :alkis_epsg, 'GEOMETRY', 2);
CREATE INDEX ax_wegpfadsteig_wkb_geometry_idx ON ax_wegpfadsteig USING gist (wkb_geometry);
CREATE INDEX ax_wegpfadsteig_hat3d ON ax_wegpfadsteig USING gin (hat3d);
CREATE INDEX ax_wegpfadsteig_hatdirektunten ON ax_wegpfadsteig USING gin (hatdirektunten);
CREATE INDEX ax_wegpfadsteig_istabgeleitetaus ON ax_wegpfadsteig USING gin (istabgeleitetaus);
CREATE INDEX ax_wegpfadsteig_traegtbeizu ON ax_wegpfadsteig USING gin (traegtbeizu);
CREATE INDEX ax_wegpfadsteig_istteilvon ON ax_wegpfadsteig USING gin (istteilvon);

COMMENT ON TABLE ax_wegpfadsteig IS 'FeatureType: "AX_WegPfadSteig"';
COMMENT ON COLUMN ax_wegpfadsteig.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_wegpfadsteig.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_wegpfadsteig.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_wegpfadsteig.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.wkb_geometry IS 'wkb_geometry  GM_Object 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.art IS 'art enumeration AX_Art_WegPfadSteig 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.befestigung IS 'befestigung enumeration AX_Befestigung_WegPfadSteig 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.bezeichnung IS 'bezeichnung  CharacterString 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.breitedesverkehrsweges IS 'breiteDesVerkehrsweges  Integer 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.ergebnisderueberpruefung IS 'ergebnisDerUeberpruefung enumeration AX_ErgebnisDerUeberpruefung_BauwerkeEinrichtungenUndSonstigeAngaben 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.markierung IS 'markierung enumeration AX_Markierung_WegPfadSteig 0..*';
COMMENT ON COLUMN ax_wegpfadsteig.name IS 'name  CharacterString 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.statement IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|statement|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.processstep_ax_li_processstep_mitdatenerhebung_description IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|description|AX_LI_ProcessStep_MitDatenerhebung_Description enumeration  1';
COMMENT ON COLUMN ax_wegpfadsteig.processstep_rationale IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|rationale|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.processstep_datetime IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|dateTime|DateTime  DateTime 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.processstep_individualname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|individualName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.processstep_organisationname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|organisationName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.processstep_positionname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|positionName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.processstep_phone IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|phone|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.processstep_address IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|address|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.processstep_onlineresource IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|onlineResource|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.processstep_hoursofservice IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|hoursOfService|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.processstep_contactinstructions IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|contactInstructions|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.processstep_role IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|role|CI_RoleCode enumeration CI_RoleCode 1';
COMMENT ON COLUMN ax_wegpfadsteig.processstep_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.processstep_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.processstep_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.processstep_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_wegpfadsteig.processstep_sourcestep IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_wegpfadsteig.herkunft_source_source_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.herkunft_source_source_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.herkunft_source_source_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.herkunft_source_source_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_wegpfadsteig.herkunft_source_source_sourcestep IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_wegpfadsteig.regionalsprache IS 'regionalsprache  CharacterString 0..*';
COMMENT ON COLUMN ax_wegpfadsteig.strassenschluessel IS 'strassenschluessel  CharacterString 0..1';
COMMENT ON COLUMN ax_wegpfadsteig.zweitname IS 'zweitname  CharacterString 0..*';
COMMENT ON COLUMN ax_wegpfadsteig.hat3d IS 'Assoziation zu: FeatureType AX_Bauwerk3D (ax_bauwerk3d) 0..*';
CREATE TABLE ax_flugverkehrsanlage (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  art integer NOT NULL,
  bezeichnung character varying,
  breitedesobjekts double precision,
  ergebnisderueberpruefung integer,
  name character varying,
  oberflaechenmaterial integer,
  statement character varying,
  processstep_ax_li_processstep_mitdatenerhebung_description character varying[],
  processstep_rationale character varying[],
  processstep_datetime character(20)[],
  processstep_individualname character varying[],
  processstep_organisationname character varying[],
  processstep_positionname character varying[],
  processstep_phone character varying[],
  processstep_address character varying[],
  processstep_onlineresource character varying[],
  processstep_hoursofservice character varying[],
  processstep_contactinstructions character varying[],
  processstep_role character varying[],
  processstep_ax_datenerhebung character varying[],
  processstep_scaledenominator character varying[],
  processstep_sourcereferencesystem character varying[],
  processstep_sourceextent character varying[],
  processstep_sourcestep character varying[],
  herkunft_source_source_ax_datenerhebung character varying[],
  herkunft_source_source_scaledenominator character varying[],
  herkunft_source_source_sourcereferencesystem character varying[],
  herkunft_source_source_sourceextent character varying[],
  herkunft_source_source_sourcestep character varying[],
  zustand integer,
  zweitname character varying[],
  hatdirektunten character(16)[],
  istabgeleitetaus character(16)[],
  traegtbeizu character(16)[],
  istteilvon character(16)[],
  hat3d character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_flugverkehrsanlage_gml ON ax_flugverkehrsanlage USING btree (gml_id,beginnt);
CREATE INDEX ax_flugverkehrsanlage_endet ON ax_flugverkehrsanlage USING btree (endet);
SELECT AddGeometryColumn('ax_flugverkehrsanlage', 'wkb_geometry', :alkis_epsg, 'GEOMETRY', 2);
CREATE INDEX ax_flugverkehrsanlage_wkb_geometry_idx ON ax_flugverkehrsanlage USING gist (wkb_geometry);
CREATE INDEX ax_flugverkehrsanlage_hat3d ON ax_flugverkehrsanlage USING gin (hat3d);
CREATE INDEX ax_flugverkehrsanlage_hatdirektunten ON ax_flugverkehrsanlage USING gin (hatdirektunten);
CREATE INDEX ax_flugverkehrsanlage_istabgeleitetaus ON ax_flugverkehrsanlage USING gin (istabgeleitetaus);
CREATE INDEX ax_flugverkehrsanlage_traegtbeizu ON ax_flugverkehrsanlage USING gin (traegtbeizu);
CREATE INDEX ax_flugverkehrsanlage_istteilvon ON ax_flugverkehrsanlage USING gin (istteilvon);

COMMENT ON TABLE ax_flugverkehrsanlage IS 'FeatureType: "AX_Flugverkehrsanlage"';
COMMENT ON COLUMN ax_flugverkehrsanlage.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_flugverkehrsanlage.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_flugverkehrsanlage.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_flugverkehrsanlage.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.wkb_geometry IS 'wkb_geometry  GM_Object 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.art IS 'art enumeration AX_Art_Flugverkehrsanlage 1';
COMMENT ON COLUMN ax_flugverkehrsanlage.bezeichnung IS 'bezeichnung  CharacterString 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.breitedesobjekts IS 'breiteDesObjekts  Length 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.ergebnisderueberpruefung IS 'ergebnisDerUeberpruefung enumeration AX_ErgebnisDerUeberpruefung_BauwerkeEinrichtungenUndSonstigeAngaben 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.name IS 'name  CharacterString 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.oberflaechenmaterial IS 'oberflaechenmaterial enumeration AX_Oberflaechenmaterial_Flugverkehrsanlage 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.statement IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|statement|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.processstep_ax_li_processstep_mitdatenerhebung_description IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|description|AX_LI_ProcessStep_MitDatenerhebung_Description enumeration  1';
COMMENT ON COLUMN ax_flugverkehrsanlage.processstep_rationale IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|rationale|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.processstep_datetime IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|dateTime|DateTime  DateTime 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.processstep_individualname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|individualName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.processstep_organisationname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|organisationName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.processstep_positionname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|positionName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.processstep_phone IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|phone|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.processstep_address IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|address|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.processstep_onlineresource IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|onlineResource|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.processstep_hoursofservice IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|hoursOfService|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.processstep_contactinstructions IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|contactInstructions|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.processstep_role IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|role|CI_RoleCode enumeration CI_RoleCode 1';
COMMENT ON COLUMN ax_flugverkehrsanlage.processstep_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.processstep_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.processstep_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.processstep_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_flugverkehrsanlage.processstep_sourcestep IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_flugverkehrsanlage.herkunft_source_source_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.herkunft_source_source_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.herkunft_source_source_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.herkunft_source_source_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_flugverkehrsanlage.herkunft_source_source_sourcestep IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_flugverkehrsanlage.zustand IS 'zustand enumeration AX_Zustand_Flugverkehrsanlage 0..1';
COMMENT ON COLUMN ax_flugverkehrsanlage.zweitname IS 'zweitname  CharacterString 0..*';
COMMENT ON COLUMN ax_flugverkehrsanlage.hat3d IS 'Assoziation zu: FeatureType AX_Bauwerk3D (ax_bauwerk3d) 0..*';
CREATE TABLE ax_gleis (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  art integer,
  bahnkategorie integer[],
  ergebnisderueberpruefung integer,
  lagezuroberflaeche integer,
  name character varying,
  statement character varying,
  processstep_ax_li_processstep_mitdatenerhebung_description character varying[],
  processstep_rationale character varying[],
  processstep_datetime character(20)[],
  processstep_individualname character varying[],
  processstep_organisationname character varying[],
  processstep_positionname character varying[],
  processstep_phone character varying[],
  processstep_address character varying[],
  processstep_onlineresource character varying[],
  processstep_hoursofservice character varying[],
  processstep_contactinstructions character varying[],
  processstep_role character varying[],
  processstep_ax_datenerhebung character varying[],
  processstep_scaledenominator character varying[],
  processstep_sourcereferencesystem character varying[],
  processstep_sourceextent character varying[],
  processstep_sourcestep character varying[],
  herkunft_source_source_ax_datenerhebung character varying[],
  herkunft_source_source_scaledenominator character varying[],
  herkunft_source_source_sourcereferencesystem character varying[],
  herkunft_source_source_sourceextent character varying[],
  herkunft_source_source_sourcestep character varying[],
  hatdirektunten character(16)[],
  istabgeleitetaus character(16)[],
  traegtbeizu character(16)[],
  istteilvon character(16)[],
  hat3d character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_gleis_gml ON ax_gleis USING btree (gml_id,beginnt);
CREATE INDEX ax_gleis_endet ON ax_gleis USING btree (endet);
SELECT AddGeometryColumn('ax_gleis', 'wkb_geometry', :alkis_epsg, 'GEOMETRY', 2);
CREATE INDEX ax_gleis_wkb_geometry_idx ON ax_gleis USING gist (wkb_geometry);
CREATE INDEX ax_gleis_hat3d ON ax_gleis USING gin (hat3d);
CREATE INDEX ax_gleis_hatdirektunten ON ax_gleis USING gin (hatdirektunten);
CREATE INDEX ax_gleis_istabgeleitetaus ON ax_gleis USING gin (istabgeleitetaus);
CREATE INDEX ax_gleis_traegtbeizu ON ax_gleis USING gin (traegtbeizu);
CREATE INDEX ax_gleis_istteilvon ON ax_gleis USING gin (istteilvon);

COMMENT ON TABLE ax_gleis IS 'FeatureType: "AX_Gleis"';
COMMENT ON COLUMN ax_gleis.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_gleis.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_gleis.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_gleis.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_gleis.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_gleis.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_gleis.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_gleis.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_gleis.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_gleis.wkb_geometry IS 'wkb_geometry  GM_Object 0..1';
COMMENT ON COLUMN ax_gleis.art IS 'art enumeration AX_Art_Gleis 0..1';
COMMENT ON COLUMN ax_gleis.bahnkategorie IS 'bahnkategorie enumeration AX_Bahnkategorie_Gleis 0..*';
COMMENT ON COLUMN ax_gleis.ergebnisderueberpruefung IS 'ergebnisDerUeberpruefung enumeration AX_ErgebnisDerUeberpruefung_BauwerkeEinrichtungenUndSonstigeAngaben 0..1';
COMMENT ON COLUMN ax_gleis.lagezuroberflaeche IS 'lageZurOberflaeche enumeration AX_LageZurOberflaeche_Gleis 0..1';
COMMENT ON COLUMN ax_gleis.name IS 'name  CharacterString 0..1';
COMMENT ON COLUMN ax_gleis.statement IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|statement|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_gleis.processstep_ax_li_processstep_mitdatenerhebung_description IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|description|AX_LI_ProcessStep_MitDatenerhebung_Description enumeration  1';
COMMENT ON COLUMN ax_gleis.processstep_rationale IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|rationale|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_gleis.processstep_datetime IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|dateTime|DateTime  DateTime 0..1';
COMMENT ON COLUMN ax_gleis.processstep_individualname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|individualName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_gleis.processstep_organisationname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|organisationName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_gleis.processstep_positionname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|positionName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_gleis.processstep_phone IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|phone|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_gleis.processstep_address IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|address|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_gleis.processstep_onlineresource IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|onlineResource|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_gleis.processstep_hoursofservice IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|hoursOfService|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_gleis.processstep_contactinstructions IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|contactInstructions|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_gleis.processstep_role IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|role|CI_RoleCode enumeration CI_RoleCode 1';
COMMENT ON COLUMN ax_gleis.processstep_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_gleis.processstep_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_gleis.processstep_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_gleis.processstep_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_gleis.processstep_sourcestep IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_gleis.herkunft_source_source_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_gleis.herkunft_source_source_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_gleis.herkunft_source_source_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_gleis.herkunft_source_source_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_gleis.herkunft_source_source_sourcestep IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_gleis.hat3d IS 'Assoziation zu: FeatureType AX_Bauwerk3D (ax_bauwerk3d) 0..*';
CREATE TABLE ax_strassenverkehrsanlage (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  art integer NOT NULL,
  bezeichnung character varying[],
  ergebnisderueberpruefung integer,
  name character varying,
  statement character varying,
  processstep_ax_li_processstep_mitdatenerhebung_description character varying[],
  processstep_rationale character varying[],
  processstep_datetime character(20)[],
  processstep_individualname character varying[],
  processstep_organisationname character varying[],
  processstep_positionname character varying[],
  processstep_phone character varying[],
  processstep_address character varying[],
  processstep_onlineresource character varying[],
  processstep_hoursofservice character varying[],
  processstep_contactinstructions character varying[],
  processstep_role character varying[],
  processstep_ax_datenerhebung character varying[],
  processstep_scaledenominator character varying[],
  processstep_sourcereferencesystem character varying[],
  processstep_sourceextent character varying[],
  processstep_sourcestep character varying[],
  herkunft_source_source_ax_datenerhebung character varying[],
  herkunft_source_source_scaledenominator character varying[],
  herkunft_source_source_sourcereferencesystem character varying[],
  herkunft_source_source_sourceextent character varying[],
  herkunft_source_source_sourcestep character varying[],
  strassenschluessel character varying,
  zweitname character varying[],
  hatdirektunten character(16)[],
  istabgeleitetaus character(16)[],
  traegtbeizu character(16)[],
  istteilvon character(16)[],
  hat3d character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_strassenverkehrsanlage_gml ON ax_strassenverkehrsanlage USING btree (gml_id,beginnt);
CREATE INDEX ax_strassenverkehrsanlage_endet ON ax_strassenverkehrsanlage USING btree (endet);
SELECT AddGeometryColumn('ax_strassenverkehrsanlage', 'wkb_geometry', :alkis_epsg, 'GEOMETRY', 2);
CREATE INDEX ax_strassenverkehrsanlage_wkb_geometry_idx ON ax_strassenverkehrsanlage USING gist (wkb_geometry);
CREATE INDEX ax_strassenverkehrsanlage_hat3d ON ax_strassenverkehrsanlage USING gin (hat3d);
CREATE INDEX ax_strassenverkehrsanlage_hatdirektunten ON ax_strassenverkehrsanlage USING gin (hatdirektunten);
CREATE INDEX ax_strassenverkehrsanlage_istabgeleitetaus ON ax_strassenverkehrsanlage USING gin (istabgeleitetaus);
CREATE INDEX ax_strassenverkehrsanlage_traegtbeizu ON ax_strassenverkehrsanlage USING gin (traegtbeizu);
CREATE INDEX ax_strassenverkehrsanlage_istteilvon ON ax_strassenverkehrsanlage USING gin (istteilvon);

COMMENT ON TABLE ax_strassenverkehrsanlage IS 'FeatureType: "AX_Strassenverkehrsanlage"';
COMMENT ON COLUMN ax_strassenverkehrsanlage.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_strassenverkehrsanlage.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.wkb_geometry IS 'wkb_geometry  GM_Object 0..1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.art IS 'art enumeration AX_Art_Strassenverkehrsanlage 1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.bezeichnung IS 'bezeichnung  CharacterString 0..*';
COMMENT ON COLUMN ax_strassenverkehrsanlage.ergebnisderueberpruefung IS 'ergebnisDerUeberpruefung enumeration AX_ErgebnisDerUeberpruefung_BauwerkeEinrichtungenUndSonstigeAngaben 0..1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.name IS 'name  CharacterString 0..1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.statement IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|statement|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.processstep_ax_li_processstep_mitdatenerhebung_description IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|description|AX_LI_ProcessStep_MitDatenerhebung_Description enumeration  1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.processstep_rationale IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|rationale|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.processstep_datetime IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|dateTime|DateTime  DateTime 0..1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.processstep_individualname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|individualName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.processstep_organisationname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|organisationName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.processstep_positionname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|positionName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.processstep_phone IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|phone|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.processstep_address IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|address|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.processstep_onlineresource IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|onlineResource|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.processstep_hoursofservice IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|hoursOfService|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.processstep_contactinstructions IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|contactInstructions|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.processstep_role IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|role|CI_RoleCode enumeration CI_RoleCode 1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.processstep_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.processstep_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.processstep_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.processstep_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_strassenverkehrsanlage.processstep_sourcestep IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_strassenverkehrsanlage.herkunft_source_source_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.herkunft_source_source_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.herkunft_source_source_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.herkunft_source_source_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_strassenverkehrsanlage.herkunft_source_source_sourcestep IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_strassenverkehrsanlage.strassenschluessel IS 'strassenschluessel  CharacterString 0..1';
COMMENT ON COLUMN ax_strassenverkehrsanlage.zweitname IS 'zweitname  CharacterString 0..*';
COMMENT ON COLUMN ax_strassenverkehrsanlage.hat3d IS 'Assoziation zu: FeatureType AX_Bauwerk3D (ax_bauwerk3d) 0..*';
CREATE TABLE ax_bahnverkehrsanlage (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  bahnhofskategorie integer NOT NULL,
  bahnkategorie integer[],
  bezeichnung character varying,
  ergebnisderueberpruefung integer,
  name character varying,
  statement character varying,
  processstep_ax_li_processstep_mitdatenerhebung_description character varying[],
  processstep_rationale character varying[],
  processstep_datetime character(20)[],
  processstep_individualname character varying[],
  processstep_organisationname character varying[],
  processstep_positionname character varying[],
  processstep_phone character varying[],
  processstep_address character varying[],
  processstep_onlineresource character varying[],
  processstep_hoursofservice character varying[],
  processstep_contactinstructions character varying[],
  processstep_role character varying[],
  processstep_ax_datenerhebung character varying[],
  processstep_scaledenominator character varying[],
  processstep_sourcereferencesystem character varying[],
  processstep_sourceextent character varying[],
  processstep_sourcestep character varying[],
  herkunft_source_source_ax_datenerhebung character varying[],
  herkunft_source_source_scaledenominator character varying[],
  herkunft_source_source_sourcereferencesystem character varying[],
  herkunft_source_source_sourceextent character varying[],
  herkunft_source_source_sourcestep character varying[],
  verkehrsdienst integer,
  zustand integer,
  hatdirektunten character(16)[],
  istabgeleitetaus character(16)[],
  traegtbeizu character(16)[],
  istteilvon character(16)[],
  hat3d character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_bahnverkehrsanlage_gml ON ax_bahnverkehrsanlage USING btree (gml_id,beginnt);
CREATE INDEX ax_bahnverkehrsanlage_endet ON ax_bahnverkehrsanlage USING btree (endet);
SELECT AddGeometryColumn('ax_bahnverkehrsanlage', 'wkb_geometry', :alkis_epsg, 'GEOMETRY', 2);
CREATE INDEX ax_bahnverkehrsanlage_wkb_geometry_idx ON ax_bahnverkehrsanlage USING gist (wkb_geometry);
CREATE INDEX ax_bahnverkehrsanlage_hat3d ON ax_bahnverkehrsanlage USING gin (hat3d);
CREATE INDEX ax_bahnverkehrsanlage_hatdirektunten ON ax_bahnverkehrsanlage USING gin (hatdirektunten);
CREATE INDEX ax_bahnverkehrsanlage_istabgeleitetaus ON ax_bahnverkehrsanlage USING gin (istabgeleitetaus);
CREATE INDEX ax_bahnverkehrsanlage_traegtbeizu ON ax_bahnverkehrsanlage USING gin (traegtbeizu);
CREATE INDEX ax_bahnverkehrsanlage_istteilvon ON ax_bahnverkehrsanlage USING gin (istteilvon);

COMMENT ON TABLE ax_bahnverkehrsanlage IS 'FeatureType: "AX_Bahnverkehrsanlage"';
COMMENT ON COLUMN ax_bahnverkehrsanlage.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_bahnverkehrsanlage.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.wkb_geometry IS 'wkb_geometry  GM_Object 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.bahnhofskategorie IS 'bahnhofskategorie enumeration AX_Bahnhofskategorie_Bahnverkehrsanlage 1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.bahnkategorie IS 'bahnkategorie enumeration AX_Bahnkategorie_Bahnverkehrsanlage 0..*';
COMMENT ON COLUMN ax_bahnverkehrsanlage.bezeichnung IS 'bezeichnung  CharacterString 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.ergebnisderueberpruefung IS 'ergebnisDerUeberpruefung enumeration AX_ErgebnisDerUeberpruefung_BauwerkeEinrichtungenUndSonstigeAngaben 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.name IS 'name  CharacterString 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.statement IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|statement|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.processstep_ax_li_processstep_mitdatenerhebung_description IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|description|AX_LI_ProcessStep_MitDatenerhebung_Description enumeration  1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.processstep_rationale IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|rationale|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.processstep_datetime IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|dateTime|DateTime  DateTime 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.processstep_individualname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|individualName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.processstep_organisationname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|organisationName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.processstep_positionname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|positionName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.processstep_phone IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|phone|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.processstep_address IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|address|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.processstep_onlineresource IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|onlineResource|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.processstep_hoursofservice IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|hoursOfService|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.processstep_contactinstructions IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|contactInstructions|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.processstep_role IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|role|CI_RoleCode enumeration CI_RoleCode 1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.processstep_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.processstep_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.processstep_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.processstep_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_bahnverkehrsanlage.processstep_sourcestep IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_bahnverkehrsanlage.herkunft_source_source_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.herkunft_source_source_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.herkunft_source_source_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.herkunft_source_source_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceExtent|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_bahnverkehrsanlage.herkunft_source_source_sourcestep IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|source|LI_Source|sourceStep|CharacterString  CharacterString 0..*';
COMMENT ON COLUMN ax_bahnverkehrsanlage.verkehrsdienst IS 'verkehrsdienst enumeration AX_Verkehrsdienst_Bahnverkehrsanlage 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.zustand IS 'zustand enumeration AX_Zustand_Bahnverkehrsanlage 0..1';
COMMENT ON COLUMN ax_bahnverkehrsanlage.hat3d IS 'Assoziation zu: FeatureType AX_Bauwerk3D (ax_bauwerk3d) 0..*';
CREATE TABLE ax_einrichtungenfuerdenschiffsverkehr (
  ogc_fid serial NOT NULL,
  gml_id character(16) NOT NULL,
  anlass character varying[],
  beginnt character(20) NOT NULL,
  endet character(20),
  advstandardmodell character varying[],
  sonstigesmodell character varying[],
  quellobjektid character varying,
  zeigtaufexternes_art character varying[],
  zeigtaufexternes_name character varying[],
  zeigtaufexternes_uri character varying[],
  art integer NOT NULL,
  bezeichnung character varying,
  ergebnisderueberpruefung integer,
  kilometerangabe double precision,
  name character varying,
  statement character varying,
  processstep_ax_li_processstep_mitdatenerhebung_description character varying[],
  processstep_rationale character varying[],
  processstep_datetime character(20)[],
  processstep_individualname character varying[],
  processstep_organisationname character varying[],
  processstep_positionname character varying[],
  processstep_phone character varying[],
  processstep_address character varying[],
  processstep_onlineresource character varying[],
  processstep_hoursofservice character varying[],
  processstep_contactinstructions character varying[],
  processstep_role character varying[],
  processstep_ax_datenerhebung character varying[],
  processstep_scaledenominator character varying[],
  processstep_sourcereferencesystem character varying[],
  processstep_sourceextent character varying[],
  processstep_sourcestep character varying[],
  herkunft_source_source_ax_datenerhebung character varying[],
  herkunft_source_source_scaledenominator character varying[],
  herkunft_source_source_sourcereferencesystem character varying[],
  herkunft_source_source_sourceextent character varying[],
  herkunft_source_source_sourcestep character varying[],
  zustand integer,
  hatdirektunten character(16)[],
  istabgeleitetaus character(16)[],
  traegtbeizu character(16)[],
  istteilvon character(16)[],
  hat3d character(16)[],
  PRIMARY KEY (ogc_fid)
);

CREATE UNIQUE INDEX ax_einrichtungenfuerdenschiffsverkehr_gml ON ax_einrichtungenfuerdenschiffsverkehr USING btree (gml_id,beginnt);
CREATE INDEX ax_einrichtungenfuerdenschiffsverkehr_endet ON ax_einrichtungenfuerdenschiffsverkehr USING btree (endet);
SELECT AddGeometryColumn('ax_einrichtungenfuerdenschiffsverkehr', 'wkb_geometry', :alkis_epsg, 'GEOMETRY', 2);
CREATE INDEX ax_einrichtungenfuerdenschiffsverkehr_wkb_geometry_idx ON ax_einrichtungenfuerdenschiffsverkehr USING gist (wkb_geometry);
CREATE INDEX ax_einrichtungenfuerdenschiffsverkehr_hat3d ON ax_einrichtungenfuerdenschiffsverkehr USING gin (hat3d);
CREATE INDEX ax_einrichtungenfuerdenschiffsverkehr_hatdirektunten ON ax_einrichtungenfuerdenschiffsverkehr USING gin (hatdirektunten);
CREATE INDEX ax_einrichtungenfuerdenschiffsverkehr_istabgeleitetaus ON ax_einrichtungenfuerdenschiffsverkehr USING gin (istabgeleitetaus);
CREATE INDEX ax_einrichtungenfuerdenschiffsverkehr_traegtbeizu ON ax_einrichtungenfuerdenschiffsverkehr USING gin (traegtbeizu);
CREATE INDEX ax_einrichtungenfuerdenschiffsverkehr_istteilvon ON ax_einrichtungenfuerdenschiffsverkehr USING gin (istteilvon);

COMMENT ON TABLE ax_einrichtungenfuerdenschiffsverkehr IS 'FeatureType: "AX_EinrichtungenFuerDenSchiffsverkehr"';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.anlass IS 'anlass codelist AA_Anlassart 0..*';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.beginnt IS 'lebenszeitintervall|AA_Lebenszeitintervall|beginnt  DateTime 1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.endet IS 'lebenszeitintervall|AA_Lebenszeitintervall|endet  DateTime 0..1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.advstandardmodell IS 'modellart|AA_Modellart|advStandardModell enumeration AA_AdVStandardModell 0..1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.sonstigesmodell IS 'modellart|AA_Modellart|sonstigesModell codelist AA_WeitereModellart 0..1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.quellobjektid IS 'quellobjektID  CharacterString 0..1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.zeigtaufexternes_art IS 'zeigtAufExternes|AA_Fachdatenverbindung|art  URI 1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.zeigtaufexternes_name IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|name  CharacterString 0..1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.zeigtaufexternes_uri IS 'zeigtAufExternes|AA_Fachdatenverbindung|fachdatenobjekt|AA_Fachdatenobjekt|uri  URI 0..1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.wkb_geometry IS 'wkb_geometry  GM_Object 0..1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.art IS 'art enumeration AX_Art_EinrichtungenFuerDenSchiffsverkehr 1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.bezeichnung IS 'bezeichnung  CharacterString 0..1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.ergebnisderueberpruefung IS 'ergebnisDerUeberpruefung enumeration AX_ErgebnisDerUeberpruefung_BauwerkeEinrichtungenUndSonstigeAngaben 0..1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.kilometerangabe IS 'kilometerangabe  Length 0..1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.name IS 'name  CharacterString 0..1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.statement IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|statement|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.processstep_ax_li_processstep_mitdatenerhebung_description IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|description|AX_LI_ProcessStep_MitDatenerhebung_Description enumeration  1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.processstep_rationale IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|rationale|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.processstep_datetime IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|dateTime|DateTime  DateTime 0..1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.processstep_individualname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|individualName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.processstep_organisationname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|organisationName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.processstep_positionname IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|positionName|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.processstep_phone IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|phone|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.processstep_address IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|address|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.processstep_onlineresource IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|onlineResource|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.processstep_hoursofservice IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|hoursOfService|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.processstep_contactinstructions IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|contactInfo|CI_Contact|contactInstructions|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.processstep_role IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|processor|CI_ResponsibleParty|role|CI_RoleCode enumeration CI_RoleCode 1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.processstep_ax_datenerhebung IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|description|AX_Datenerhebung  CharacterString 0..1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.processstep_scaledenominator IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|scaleDenominator|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.processstep_sourcereferencesystem IS 'qualitaetsangaben|AX_DQMitDatenerhebung|herkunft|LI_Lineage|processStep|LI_ProcessStep|source|LI_Source|sourceReferenceSystem|CharacterString  CharacterString 0..1';
COMMENT ON COLUMN ax_einrichtungenfuerdenschiffsverkehr.processstep_sourceextent IS 'qualitaetsangaben|AX_DQMitDatenerhebung|her