---
name: r3.in.bin
description: Imports a binary raster file into a GRASS 3D raster map.
keywords: [ raster3d, import, voxel ]
---

# r3.in.bin

Imports a binary raster file into a GRASS 3D raster map.

=== "Command line"

    **r3.in.bin**
    [**-rdis**]
    **input**=*name*
    **output**=*name*
    **bytes**=*integer*
    [**order**=*string*]
    **north**=*float*
    **south**=*float*
    **east**=*float*
    **west**=*float*
    **bottom**=*float*
    **top**=*float*
    **rows**=*integer*
    **cols**=*integer*
    **depths**=*integer*
    [**null**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r3.in.bin input=name output=name bytes=0 north=0.0 south=0.0 east=0.0 west=0.0 bottom=0.0 top=0.0 rows=0 cols=0 depths=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r3.in.bin***",
        **input**,
        **output**,
        **bytes**,
        **order**=*"native"*,
        **north**,
        **south**,
        **east**,
        **west**,
        **bottom**,
        **top**,
        **rows**,
        **cols**,
        **depths**,
        **null**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r3.in.bin", input="name", output="name", bytes=0, north=0.0, south=0.0, east=0.0, west=0.0, bottom=0.0, top=0.0, rows=0, cols=0, depths=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r3_in_bin*(**input**,
        **output**,
        **bytes**,
        **order**=*"native"*,
        **north**,
        **south**,
        **east**,
        **west**,
        **bottom**,
        **top**,
        **rows**,
        **cols**,
        **depths**,
        **null**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r3_in_bin(input="name", output="name", bytes=0, north=0.0, south=0.0, east=0.0, west=0.0, bottom=0.0, top=0.0, rows=0, cols=0, depths=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of binary 3D raster file to be imported  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    **bytes**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of bytes per cell in binary file  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1, 2, 4, 8*  
    **order**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Byte order in binary file  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *big, little, native, swap*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *native*  
    **north**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Northern limit of geographic region (outer edge)  
    **south**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Southern limit of geographic region (outer edge)  
    **east**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Eastern limit of geographic region (outer edge)  
    **west**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Western limit of geographic region (outer edge)  
    **bottom**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Bottom limit of geographic region (outer edge)  
    **top**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Top limit of geographic region (outer edge)  
    **rows**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of rows  
    **cols**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of columns  
    **depths**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of depths  
    **null**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set Value to NULL  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Switch the row order in output from north-&gt;south to south-&gt;north  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Switch the depth order in output from bottom-&gt;top to top-&gt;bottom  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Binary data is of type integer  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Signed data (two's complement)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of binary 3D raster file to be imported  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **bytes** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of bytes per cell in binary file  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1, 2, 4, 8*  
    **order** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Byte order in binary file  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *big, little, native, swap*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *native*  
    **north** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Northern limit of geographic region (outer edge)  
    **south** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Southern limit of geographic region (outer edge)  
    **east** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Eastern limit of geographic region (outer edge)  
    **west** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Western limit of geographic region (outer edge)  
    **bottom** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Bottom limit of geographic region (outer edge)  
    **top** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Top limit of geographic region (outer edge)  
    **rows** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of rows  
    **cols** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of columns  
    **depths** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of depths  
    **null** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set Value to NULL  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *d*, *i*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switch the row order in output from north-&gt;south to south-&gt;north  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switch the depth order in output from bottom-&gt;top to top-&gt;bottom  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Binary data is of type integer  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Signed data (two's complement)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of binary 3D raster file to be imported  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **bytes** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of bytes per cell in binary file  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1, 2, 4, 8*  
    **order** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Byte order in binary file  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *big, little, native, swap*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *native*  
    **north** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Northern limit of geographic region (outer edge)  
    **south** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Southern limit of geographic region (outer edge)  
    **east** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Eastern limit of geographic region (outer edge)  
    **west** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Western limit of geographic region (outer edge)  
    **bottom** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Bottom limit of geographic region (outer edge)  
    **top** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Top limit of geographic region (outer edge)  
    **rows** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of rows  
    **cols** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of columns  
    **depths** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of depths  
    **null** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set Value to NULL  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *d*, *i*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switch the row order in output from north-&gt;south to south-&gt;north  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switch the depth order in output from bottom-&gt;top to top-&gt;bottom  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Binary data is of type integer  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Signed data (two's complement)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r3.in.bin* allows a user to create a GRASS 3D raster map from a variety
of binary 3D raster data formats.

The top, bottom, north, south, east, and west field values entered are
the coordinates of the edges of the geographic region. The depths, rows
and cols field values entered describe the dimensions of the matrix of
data to follow. If the bytes field is entered incorrectly an error will
be generated suggesting a closer bytes value.

## NOTES

The write order of the rows (north-\>south to south-\>north) and the
write order of the depths (bottom-\>top to top-\>bottom) can be
switched.

Have a look at [r3.out.ascii](r3.out.ascii.md) to manual page that
describes the internal layout of the 3D raster maps and the supported
row and depth switch options.

Import of little and big endian byte order as well as signed and
unsigned integer data types is supported.

## EXAMPLES

First we create a specific region and a 3D raster map that we will
export with [r3.out.bin](r3.out.bin.md) and import again.

```sh
g.region w=0 e=180 s=0 n=90 b=0 t=100 res3=10
r3.mapcalc expr="test_out_bin_float = float(if(row() == 2, null(), row()))"

r3.out.bin input=test_out_bin_float byte=4 null=-9999 \
    output=test_out_bin_float_native_b4.bin order=native

r3.in.bin output=test_in_bin_float byte=4 null=-9999 \
    input=test_out_bin_float_native_b4.bin order=native \
    bottom=0 top=100 west=0 east=180 south=0 north=90 \
    cols=18 rows=9 depths=10
```

## SEE ALSO

*[r3.out.bin](r3.out.bin.md), [r3.in.ascii](r3.in.ascii.md),
[r3.out.ascii](r3.out.ascii.md)*

## AUTHORS

Soren Gebbert, based on r.in.bin from Jacques Bouchard and Bob Covill

## SOURCE CODE

Available at: [r3.in.bin source code](https://github.com/OSGeo/grass/tree/main/raster3d/r3.in.bin)
([history](https://github.com/OSGeo/grass/commits/main/raster3d/r3.in.bin))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
