---
name: t.support.py
description: Modifies the metadata of a space time dataset.
keywords: [ temporal, metadata, time ]
---

# t.support.py

Modifies the metadata of a space time dataset.

=== "Command line"

    **t.support.py**
    [**-mu**]
    **input**=*name*
    [**semantictype**=*string*]
    [**type**=*name*]
    [**title**=*string*]
    [**description**=*string*]
    [**aggr_type**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.support.py input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***t.support.py***",
        **input**,
        **semantictype**=*"mean"*,
        **type**=*"strds"*,
        **title**=*None*,
        **description**=*None*,
        **aggr_type**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("t.support.py", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_support_py*(**input**,
        **semantictype**=*"mean"*,
        **type**=*"strds"*,
        **title**=*None*,
        **description**=*None*,
        **aggr_type**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_support_py(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time dataset  
    **semantictype**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Semantic type of the space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *min, max, sum, mean*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mean*  
    **type**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of the input space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *strds, stvds, str3ds*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *strds*  
    **title**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title of the space time dataset  
    **description**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Description of the space time dataset  
    **aggr_type**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Aggregation type of the space time raster or 3D raster dataset  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Update the metadata information and spatial extent of registered maps from the GRASS spatial database  
    &nbsp;&nbsp;&nbsp;&nbsp;Check for removed maps and delete them from the temporal database and all effected space time datasets  
    **-u**  
    &nbsp;&nbsp;&nbsp;&nbsp;Update metadata information, temporal and spatial extent from registered maps based on database entries.  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, stds, *name*  
    **semantictype** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Semantic type of the space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *min, max, sum, mean*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mean*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of the input space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *strds, stvds, str3ds*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *strds*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title of the space time dataset  
    **description** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Description of the space time dataset  
    **aggr_type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Aggregation type of the space time raster or 3D raster dataset  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m*, *u*  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Update the metadata information and spatial extent of registered maps from the GRASS spatial database  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Check for removed maps and delete them from the temporal database and all effected space time datasets  
    &nbsp;&nbsp;&nbsp;&nbsp;**u**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Update metadata information, temporal and spatial extent from registered maps based on database entries.  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, stds, *name*  
    **semantictype** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Semantic type of the space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *min, max, sum, mean*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mean*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of the input space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *strds, stvds, str3ds*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *strds*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title of the space time dataset  
    **description** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Description of the space time dataset  
    **aggr_type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Aggregation type of the space time raster or 3D raster dataset  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m*, *u*  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Update the metadata information and spatial extent of registered maps from the GRASS spatial database  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Check for removed maps and delete them from the temporal database and all effected space time datasets  
    &nbsp;&nbsp;&nbsp;&nbsp;**u**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Update metadata information, temporal and spatial extent from registered maps based on database entries.  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The *t.support* module is dedicated to modify and update the metadata of
a space time dataset.

The title, description and the semantic type can be modified.

The flag *-u* allows updating the STDS metadata from registered map
layers. This is useful in case the map layers have been modified without
using temporal commands.

The flag *-m* will update the metadata from registered maps, but also
checks if the registered map layers have been removed from the spatial
database. It deletes missing map layers from the space time dataset
register table and the temporal database.

## EXAMPLES

Modification of title and description of space time raster dataset *A*.

```sh
t.support type=strds input=tempmean_monthly title="Monthly temperature for North Carolina" \
          description="Dataset with monthly temperature for North Carolina"
```

Update the metadata of space time raster dataset *A* and check for
removed map layers.

```sh
t.support -m type=strds input=tempmean_monthly
```

## SEE ALSO

*[t.create](t.create.md), [t.info](t.info.md)*

## AUTHOR

Sören Gebbert, Thünen Institute of Climate-Smart Agriculture

## SOURCE CODE

Available at: [t.support source code](https://github.com/OSGeo/grass/tree/main/temporal/t.support)
([history](https://github.com/OSGeo/grass/commits/main/temporal/t.support))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
