<style>
.img-list {
    margin: 0;
    padding: 0;
    list-style-type: none;
}

.img-list li {
    padding: 5px;
    overflow: auto;
}

.img-list li:hover {
    background-color: #eee;
}

.img-list li a {
    color: initial;
    text-decoration: none;
    display: block;
}

.img-list li img {
    width: 10%;
    float: left;
    margin: 0 15px 0 0;
    background: white;
    object-fit: scale-down;
}

.img-list li img.default-img {
    max-height: 5ex;
    background-color: var(--gs-primary-color);
    padding: 5px;
}

.img-list li .desc {
    margin: 0px;
}

.img-list li .name {
    margin: 5px;
    display: block;
    color: #409940;
    font-weight: bold;
    font-style: italic;
}
</style>
Go to <a href="temporalintro.html">temporal introduction</a> | <a href="topics.html">topics</a> <p>
# Temporal tools
<ul class="img-list"><li><a href="t.connect.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.connect.html"><span class="name">t.connect</span> <span class="desc">Prints/sets general temporal GIS database connection for current mapset.</span></a></li><li><a href="t.copy.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.copy.html"><span class="name">t.copy</span> <span class="desc">Creates a copy of a space time raster dataset.</span></a></li><li><a href="t.create.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.create.html"><span class="name">t.create</span> <span class="desc">Creates a space time dataset.</span></a></li><li><a href="t.info.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.info.html"><span class="name">t.info</span> <span class="desc">Lists information about space time datasets and maps.</span></a></li><li><a href="t.list.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.list.html"><span class="name">t.list</span> <span class="desc">Lists space time datasets and maps registered in the temporal database.</span></a></li><li><a href="t.merge.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.merge.html"><span class="name">t.merge</span> <span class="desc">Merges several space time datasets into a single space time dataset.</span></a></li><li><a href="t.rast.accdetect.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.rast.accdetect.html"><span class="name">t.rast.accdetect</span> <span class="desc">Detects accumulation patterns in temporally accumulated space time raster datasets created by t.rast.accumulate.</span></a></li><li><a href="t.rast.accumulate.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.rast.accumulate.html"><span class="name">t.rast.accumulate</span> <span class="desc">Computes cyclic accumulations of a space time raster dataset.</span></a></li><li><a href="t.rast.aggregate.ds.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.rast.aggregate.ds.html"><span class="name">t.rast.aggregate.ds</span> <span class="desc">Aggregates data of an existing space time raster dataset using the time intervals of a second space time dataset.</span></a></li><li><a href="t.rast.aggregate.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.rast.aggregate.html"><span class="name">t.rast.aggregate</span> <span class="desc">Aggregates temporally the maps of a space time raster dataset by a user defined granularity.</span></a></li><li><a href="t.rast.algebra.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.rast.algebra.html"><span class="name">t.rast.algebra</span> <span class="desc">Apply temporal and spatial operations on space time raster datasets using temporal raster algebra.</span></a></li><li><a href="t.rast.colors.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.rast.colors.html"><span class="name">t.rast.colors</span> <span class="desc">Creates/modifies the color table associated with each raster map of the space time raster dataset.</span></a></li><li><a href="t.rast.contour.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.rast.contour.html"><span class="name">t.rast.contour</span> <span class="desc">Produces a space time vector dataset of specified contours from a space time raster dataset.</span></a></li><li><a href="t.rast.export.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.rast.export.html"><span class="name">t.rast.export</span> <span class="desc">Exports space time raster dataset.</span></a></li><li><a href="t.rast.extract.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.rast.extract.html"><span class="name">t.rast.extract</span> <span class="desc">Extracts a subset of a space time raster datasets.</span></a></li><li><a href="t.rast.gapfill.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.rast.gapfill.html"><span class="name">t.rast.gapfill</span> <span class="desc">Replaces gaps in a space time raster dataset with interpolated raster maps.</span></a></li><li><a href="t.rast.import.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.rast.import.html"><span class="name">t.rast.import</span> <span class="desc">Imports space time raster dataset.</span></a></li><li><a href="t.rast.list.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.rast.list.html"><span class="name">t.rast.list</span> <span class="desc">Lists registered maps of a space time raster dataset.</span></a></li><li><a href="t.rast.mapcalc.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.rast.mapcalc.html"><span class="name">t.rast.mapcalc</span> <span class="desc">Performs spatio-temporal mapcalc expressions on temporally sampled maps of space time raster datasets.</span></a></li><li><a href="t.rast.neighbors.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.rast.neighbors.html"><span class="name">t.rast.neighbors</span> <span class="desc">Performs a neighborhood analysis for each map in a space time raster dataset.</span></a></li><li><a href="t.rast.out.vtk.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.rast.out.vtk.html"><span class="name">t.rast.out.vtk</span> <span class="desc">Exports space time raster dataset as VTK time series.</span></a></li><li><a href="t.rast.series.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.rast.series.html"><span class="name">t.rast.series</span> <span class="desc">Performs different aggregation algorithms from r.series on all or a subset of raster maps in a space time raster dataset.</span></a></li><li><a href="t.rast.to.rast3.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.rast.to.rast3.html"><span class="name">t.rast.to.rast3</span> <span class="desc">Converts a space time raster dataset into a 3D raster map.</span></a></li><li><a href="t.rast.to.vect.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.rast.to.vect.html"><span class="name">t.rast.to.vect</span> <span class="desc">Converts a space time raster dataset into a space time vector dataset</span></a></li><li><a href="t.rast.univar.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.rast.univar.html"><span class="name">t.rast.univar</span> <span class="desc">Calculates univariate statistics from the non-null cells for each registered raster map of a space time raster dataset.</span></a></li><li><a href="t.rast.what.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.rast.what.html"><span class="name">t.rast.what</span> <span class="desc">Sample a space time raster dataset at specific vector point coordinates and write the output to stdout using different layouts</span></a></li><li><a href="t.rast3d.algebra.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.rast3d.algebra.html"><span class="name">t.rast3d.algebra</span> <span class="desc">Apply temporal and spatial operations on space time 3D raster datasets using temporal 3D raster algebra.</span></a></li><li><a href="t.rast3d.extract.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.rast3d.extract.html"><span class="name">t.rast3d.extract</span> <span class="desc">Extracts a subset of a space time 3D raster dataset.</span></a></li><li><a href="t.rast3d.list.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.rast3d.list.html"><span class="name">t.rast3d.list</span> <span class="desc">Lists registered maps of a space time raster3d dataset.</span></a></li><li><a href="t.rast3d.mapcalc.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.rast3d.mapcalc.html"><span class="name">t.rast3d.mapcalc</span> <span class="desc">Performs r3.mapcalc expressions on maps of sampled space time 3D raster datasets.</span></a></li><li><a href="t.rast3d.univar.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.rast3d.univar.html"><span class="name">t.rast3d.univar</span> <span class="desc">Calculates univariate statistics from the non-null cells for each registered 3D raster map of a space time 3D raster dataset.</span></a></li><li><a href="t.register.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.register.html"><span class="name">t.register</span> <span class="desc">Assigns timestamps and registers raster, vector and raster3d maps in a space time dataset.</span></a></li><li><a href="t.remove.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.remove.html"><span class="name">t.remove</span> <span class="desc">Removes space time datasets from temporal database.</span></a></li><li><a href="t.rename.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.rename.html"><span class="name">t.rename</span> <span class="desc">Renames a space time dataset</span></a></li><li><a href="t.sample.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.sample.html"><span class="name">t.sample</span> <span class="desc">Samples the input space time dataset(s) with a sample space time dataset and print the result to stdout.</span></a></li><li><a href="t.select.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.select.html"><span class="name">t.select</span> <span class="desc">Select maps from space time datasets by topological relationships to other space time datasets using temporal algebra.</span></a></li><li><a href="t.shift.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.shift.html"><span class="name">t.shift</span> <span class="desc">Shifts temporally the maps of a space time dataset.</span></a></li><li><a href="t.snap.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.snap.html"><span class="name">t.snap</span> <span class="desc">Snaps temporally the maps of a space time dataset.</span></a></li><li><a href="t.support.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.support.html"><span class="name">t.support</span> <span class="desc">Modifies the metadata of a space time dataset.</span></a></li><li><a href="t.topology.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.topology.html"><span class="name">t.topology</span> <span class="desc">Lists temporal topology of a space time dataset.</span></a></li><li><a href="t.unregister.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.unregister.html"><span class="name">t.unregister</span> <span class="desc">Unregisters raster, vector and raster3d maps from the temporal database or a specific space time dataset.</span></a></li><li><a href="t.upgrade.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.upgrade.html"><span class="name">t.upgrade</span> <span class="desc">Upgrades the version of the temporal database.</span></a></li><li><a href="t.vect.algebra.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.vect.algebra.html"><span class="name">t.vect.algebra</span> <span class="desc">Apply temporal and spatial operations on space time vector datasets using temporal vector algebra.</span></a></li><li><a href="t.vect.db.select.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.vect.db.select.html"><span class="name">t.vect.db.select</span> <span class="desc">Prints attributes of vector maps registered in a space time vector dataset.</span></a></li><li><a href="t.vect.export.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.vect.export.html"><span class="name">t.vect.export</span> <span class="desc">Exports a space time vector dataset as GRASS specific archive file.</span></a></li><li><a href="t.vect.extract.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.vect.extract.html"><span class="name">t.vect.extract</span> <span class="desc">Extracts a subset of a space time vector dataset.</span></a></li><li><a href="t.vect.import.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.vect.import.html"><span class="name">t.vect.import</span> <span class="desc">Imports a space time vector dataset from a GRASS specific archive file.</span></a></li><li><a href="t.vect.list.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.vect.list.html"><span class="name">t.vect.list</span> <span class="desc">Lists registered maps of a space time vector dataset.</span></a></li><li><a href="t.vect.observe.strds.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.vect.observe.strds.html"><span class="name">t.vect.observe.strds</span> <span class="desc">Observes specific locations in a space time raster dataset over a period of time using vector points.</span></a></li><li><a href="t.vect.univar.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.vect.univar.html"><span class="name">t.vect.univar</span> <span class="desc">Calculates univariate statistics of attributes for each registered vector map of a space time vector dataset</span></a></li><li><a href="t.vect.what.strds.html"><img class="default-img" src="grass_logo.svg"></a><a href="t.vect.what.strds.html"><span class="name">t.vect.what.strds</span> <span class="desc">Stores raster map values at spatial and temporal positions of vector points as vector attributes.</span></a></li></ul>