---
name: v.out.lidar
description: Exports vector points as LAS point cloud Converts LAS LiDAR point clouds to a GRASS vector map with libLAS
keywords: [ vector, export, output, LIDAR, points ]
---

# v.out.lidar

Exports vector points as LAS point cloud

Converts LAS LiDAR point clouds to a GRASS vector map with libLAS

=== "Command line"

    **v.out.lidar**
    [**-rw**]
    **input**=*name*
    [**layer**=*string*]
    **output**=*name*
    [**cats**=*range*]
    [**where**=*sql_query*]
    [**id_layer**=*string*]
    [**return_layer**=*string*]
    [**class_layer**=*string*]
    [**rgb_layer**=*string*]
    [**return_column**=*name*]
    [**n_returns_column**=*name*]
    [**class_column**=*name*]
    [**rgb_column**=*name*]
    [**red_column**=*name*]
    [**green_column**=*name*]
    [**blue_column**=*name*]
    **las_xyscale**=*float*
    **las_zscale**=*float*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.out.lidar input=name output=name las_xyscale=0.01 las_zscale=0.01
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.out.lidar***",
        **input**,
        **layer**=*"-1"*,
        **output**,
        **cats**=*None*,
        **where**=*None*,
        **id_layer**=*None*,
        **return_layer**=*None*,
        **class_layer**=*None*,
        **rgb_layer**=*None*,
        **return_column**=*None*,
        **n_returns_column**=*None*,
        **class_column**=*None*,
        **rgb_column**=*None*,
        **red_column**=*None*,
        **green_column**=*None*,
        **blue_column**=*None*,
        **las_xyscale**=*0.01*,
        **las_zscale**=*0.01*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.out.lidar", input="name", output="name", las_xyscale=0.01, las_zscale=0.01)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_out_lidar*(**input**,
        **layer**=*"-1"*,
        **output**,
        **cats**=*None*,
        **where**=*None*,
        **id_layer**=*None*,
        **return_layer**=*None*,
        **class_layer**=*None*,
        **rgb_layer**=*None*,
        **return_column**=*None*,
        **n_returns_column**=*None*,
        **class_column**=*None*,
        **rgb_column**=*None*,
        **red_column**=*None*,
        **green_column**=*None*,
        **blue_column**=*None*,
        **las_xyscale**=*0.01*,
        **las_zscale**=*0.01*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_out_lidar(input="name", output="name", las_xyscale=0.01, las_zscale=0.01)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    **cats**=*range*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **id_layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number to store generated point ID as category  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    **return_layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number to store return number as category  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    **class_layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number to store class number as category  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    **rgb_layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number where RGB color is stored as category  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    **return_column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with return number  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    **n_returns_column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with return number  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    **class_column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with return number  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    **rgb_column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;RGB color definition column  
    &nbsp;&nbsp;&nbsp;&nbsp;Color definition in R:G:B form  
    **red_column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with red color  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    **green_column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with green color  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    **blue_column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with blue color  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    **las_xyscale**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Internal scale to apply to X and Y values  
    &nbsp;&nbsp;&nbsp;&nbsp;This scale does not change the values itself but only how precisely they are stored, for example 0.01 will preserve two decimal places  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.01*  
    **las_zscale**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Internal scale to apply to z values  
    &nbsp;&nbsp;&nbsp;&nbsp;This scale does not change the values itself but only how precisely they are stored, for example 0.01 will preserve two decimal places  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.01*  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Limit export to the current region  
    **-w**  
    &nbsp;&nbsp;&nbsp;&nbsp;Ignore color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Ignore color table even when set and not other options are present  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **id_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number to store generated point ID as category  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    **return_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number to store return number as category  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    **class_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number to store class number as category  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    **rgb_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number where RGB color is stored as category  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    **return_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with return number  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **n_returns_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with return number  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **class_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with return number  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **rgb_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;RGB color definition column  
    &nbsp;&nbsp;&nbsp;&nbsp;Color definition in R:G:B form  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **red_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with red color  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **green_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with green color  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **blue_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with blue color  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **las_xyscale** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Internal scale to apply to X and Y values  
    &nbsp;&nbsp;&nbsp;&nbsp;This scale does not change the values itself but only how precisely they are stored, for example 0.01 will preserve two decimal places  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.01*  
    **las_zscale** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Internal scale to apply to z values  
    &nbsp;&nbsp;&nbsp;&nbsp;This scale does not change the values itself but only how precisely they are stored, for example 0.01 will preserve two decimal places  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.01*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *w*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Limit export to the current region  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ignore color table  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ignore color table even when set and not other options are present  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **id_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number to store generated point ID as category  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    **return_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number to store return number as category  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    **class_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number to store class number as category  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    **rgb_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number where RGB color is stored as category  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    **return_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with return number  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **n_returns_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with return number  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **class_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with return number  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **rgb_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;RGB color definition column  
    &nbsp;&nbsp;&nbsp;&nbsp;Color definition in R:G:B form  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **red_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with red color  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **green_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with green color  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **blue_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with blue color  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **las_xyscale** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Internal scale to apply to X and Y values  
    &nbsp;&nbsp;&nbsp;&nbsp;This scale does not change the values itself but only how precisely they are stored, for example 0.01 will preserve two decimal places  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.01*  
    **las_zscale** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Internal scale to apply to z values  
    &nbsp;&nbsp;&nbsp;&nbsp;This scale does not change the values itself but only how precisely they are stored, for example 0.01 will preserve two decimal places  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.01*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *w*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Limit export to the current region  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ignore color table  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ignore color table even when set and not other options are present  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.out.lidar* converts GRASS vector map to a LiDAR point clouds in LAS
format using the [libLAS](https://liblas.org) library.

The **-r** flag limits the export to the current computational region
extent (see *[g.region](g.region.md)*). The **where** option limits the
export by attributes (applied only when the columns are used for
export).

LAS format stores the coordinates as integers rounding the decimal
places. Before that a scale is applied to preserve a certain number of
decimal places. This scale can be set using **las_xyscale** and
**las_xscale** options. For example, the scale value 0.01 will preserve
two decimal places while the value 1.0 will preserve none.

## NOTES

The typical file extensions for the LAS format are .las and .laz
(compressed). The compressed LAS (.laz) format can be exported only if
libLAS has been compiled with [LASzip](https://laszip.org/) support. It
is also good when libLAS was compiled with GDAL. This is needed when
working with projections.

## EXAMPLE

Generate fractal surface and export is as point in LAS format:

```sh
g.region raster=elevation res=100
r.surf.fractal output=fractals
r.to.vect input=fractals output=fractals type=point -z
v.out.lidar input=fractals output=fractals.las
```

## REFERENCES

[ASPRS LAS
format](https://www.asprs.org/committee-general/laser-las-file-format-exchange-activities.html)  
[LAS library](https://liblas.org/)  

## SEE ALSO

*[v.out.ogr](v.out.ogr.md)*

## AUTHOR

Vaclav Petras

## SOURCE CODE

Available at: [v.out.lidar source code](https://github.com/OSGeo/grass/tree/main/vector/v.out.lidar)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.out.lidar))  
Latest change: Thursday Nov 06 22:27:54 2025 in commit [298b386](https://github.com/OSGeo/grass/commit/298b38614712934179355ea767403d6bfea8f5f9)
