---
name: v.what.rast3
description: Uploads 3D raster values at positions of vector points to the table.
keywords: [ vector, sampling, raster, position, querying, attribute table, surface information ]
---

# v.what.rast3

Uploads 3D raster values at positions of vector points to the table.

=== "Command line"

    **v.what.rast3**
    **map**=*name*
    [**layer**=*string*]
    **raster_3d**=*name*
    **column**=*name*
    [**where**=*sql_query*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.what.rast3 map=name raster_3d=name column=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.what.rast3***",
        **map**,
        **layer**=*"1"*,
        **raster_3d**,
        **column**,
        **where**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.what.rast3", map="name", raster_3d="name", column="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_what_rast3*(**map**,
        **layer**=*"1"*,
        **raster_3d**,
        **column**,
        **where**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_what_rast3(map="name", raster_3d="name", column="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector points map for which to edit attributes  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **raster_3d**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of existing 3D raster map to be queried  
    **column**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column to be updated with the query result  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector points map for which to edit attributes  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **raster_3d** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of existing 3D raster map to be queried  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column to be updated with the query result  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector points map for which to edit attributes  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **raster_3d** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of existing 3D raster map to be queried  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column to be updated with the query result  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.what.rast3* reads 3D raster value for each point in the vector and
updates **col** column in vector attribute table by this value. The
column should be type double. This module is based on
[v.what.rast](v.what.rast.md).  
If more points have the same category, attribute value is set to NULL.
If 3D raster values is NULL, attribute value is set to NULL.

## NOTES

## EXAMPLES

A\) Reading values from 3D raster map at position of vector points,
writing these values into a column of the attribute table connected to
the vector map:  

```sh
v.what.rast3 map=pnts raster3d=plume column=concentration
```

B\) In case of a vector map without attached attribute table, first add
a new attribute table. This table is then populated with values queried
from the raster map:  

```sh
# create new random 3d vector points map
v.random -z output=pnts npoints=100 zmin=0  zmax=50

# add new table, link to map
v.db.addtable map=pnts column="concentration double precision"

# query raster map and upload values to vector table into specified column
g.region raster3d=plume -p
v.what.rast3 map=pnts raster3d=plume column=concentration

# verify new attribute table:
v.db.select map=pnts

# verify statistics of uploaded values:
v.univar map=pnts column=concentration type=point
```

## SEE ALSO

*[v.db.addtable](v.db.addtable.md), [v.db.select](v.db.select.md),
[v.what.rast](v.what.rast.md), [v.what.vect](v.what.vect.md),
[v.univar](v.univar.md)*

## AUTHOR

Soeren Gebbert, heavily based on v.what.rast by Radim Blazek

## SOURCE CODE

Available at: [v.what.rast3 source code](https://github.com/OSGeo/grass/tree/main/vector/v.what.rast3)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.what.rast3))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
