---
authors:
    - Corey T. White
    - GRASS Development Team
title: Getting Started
---

## What is GRASS?

[GRASS](https://grass.osgeo.org/) is a geospatial processing engine for
advance analysis and visualization of geospatial data. GRASS is a free and open source
software, released under the [GNU GPL](https://www.gnu.org/licenses/gpl.html).

<!-- markdownlint-disable-next-line MD013 -->
[:material-download: Download GRASS](https://grass.osgeo.org/download/){ .md-button }[Grow GRASS :octicons-heart-fill-24:](https://opencollective.com/grass/contribute){ .md-button .gs-support-button}

## Tools

GRASS provides a wide range of tools for geospatial processing, modeling,
analysis, and visualization, with detailed documentation to guide users
through processing raster, vector, 3D raster, and temporal data.

<!-- markdownlint-disable-next-line line-length -->
[Explore tools :material-arrow-right-bold:](full_index.md){ .md-button }

## Interfaces

GRASS provides a number of [interfaces](interfaces_overview.md) for interacting with
the tools and developing computational workflows. The most common interfaces are:

- [Command line](interfaces_overview.md#command-line), also know as terminal or shell
- [Python](interfaces_overview.md#python)
- [Jupyter Notebooks](interfaces_overview.md#jupyter-notebooks)
- [Graphical user interface](helptext.md)

<!-- markdownlint-disable-next-line line-length -->
[Explore interfaces :material-arrow-right-bold:](interfaces_overview.md){ .md-button }

## Key concepts

New to geospatial processing or familiar with different geospatial software?
Discover how GRASS approaches geospatial modeling.

<!-- markdownlint-disable-next-line line-length -->
[Explore key concepts :material-arrow-right-bold:](grass_projects.md){ .md-button }

## Development

GRASS is an open source project and welcomes contributions from the community.
The GRASS Development documentation provides information on how to get started
developing for GRASS, how to contribute to the project, and how to get involved
with the GRASS community.

<!-- markdownlint-disable-next-line line-length -->
[Start developing :material-arrow-right-bold:](development_intro.md){ .md-button }
