---
name: r.quantile
description: Compute quantiles using two passes.
keywords: [ raster, algebra, statistics, percentile, quantile ]
---

# r.quantile

Compute quantiles using two passes.

=== "Command line"

    **r.quantile**
    [**-r**]
    **input**=*name*
    [**quantiles**=*integer*]
    [**percentiles**=*float* [,*float*,...]]
    [**bins**=*integer*]
    [**file**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.quantile input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.quantile***",
        **input**,
        **quantiles**=*4*,
        **percentiles**=*None*,
        **bins**=*1000000*,
        **file**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.quantile", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_quantile*(**input**,
        **quantiles**=*4*,
        **percentiles**=*None*,
        **bins**=*1000000*,
        **file**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_quantile(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **quantiles**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of quantiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **percentiles**=*float* [,*float*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;List of percentiles  
    **bins**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of bins to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1000000*  
    **file**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (if omitted or "-" output to stdout)  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Generate recode rules based on quantile-defined intervals  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **quantiles** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of quantiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **percentiles** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of percentiles  
    **bins** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of bins to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1000000*  
    **file** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (if omitted or "-" output to stdout)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate recode rules based on quantile-defined intervals  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **quantiles** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of quantiles  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **percentiles** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of percentiles  
    **bins** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of bins to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1000000*  
    **file** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file (if omitted or "-" output to stdout)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate recode rules based on quantile-defined intervals  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.quantile* computes quantiles in a manner suitable for use with large
amounts of data. It is using two passes.

## NOTES

Quantiles are calculated following algorithm 7 from Hyndman and Fan
(1996), which is also the default in R and numpy.

## EXAMPLE

Calculation of elevation quantiles (printed to standard-out):

```sh
g.region raster=elevation -p
r.quantile input=elevation percentiles=0.1,1,10,25,50,75,90,99,99.9
```

The output of *r.quantile* can be used for quantile classification:

```sh
g.region raster=elevation -p
r.quantile elevation quantiles=5 -r --quiet | r.recode elevation \
           out=elev_quant5 rules=-
```

## REFERENCES

- Hyndman and Fan (1996) *Sample Quantiles in Statistical Packages*,
  **American Statistician**. American Statistical Association. 50 (4):
  361-365. DOI:
  [10.2307/2684934](https://doi.org/10.2307/2684934%3E10.2307/2684934)
- [*Engineering Statistics Handbook:
  Percentile*](https://www.itl.nist.gov/div898/handbook/prc/section2/prc262.htm),
  NIST

## SEE ALSO

*[r.mode](r.mode.md), [r.quant](r.quant.md), [r.recode](r.recode.md),
[r.series](r.series.md), [r.stats](r.stats.md),
[r.stats.quantile](r.stats.quantile.md),
[r.stats.zonal](r.stats.zonal.md), [r.statistics](r.statistics.md),
[r.univar](r.univar.md), [v.rast.stats](v.rast.stats.md)*

## AUTHORS

Glynn Clements  
Markus Metz

## SOURCE CODE

Available at: [r.quantile source code](https://github.com/OSGeo/grass/tree/main/raster/r.quantile)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.quantile))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
