---
name: t.rast3d.mapcalc.py
description: Performs r3.mapcalc expressions on maps of sampled space time 3D raster datasets.
keywords: [ temporal, algebra, raster3d, voxel, time ]
---

# t.rast3d.mapcalc.py

Performs r3.mapcalc expressions on maps of sampled space time 3D raster datasets.

=== "Command line"

    **t.rast3d.mapcalc.py**
    [**-ns**]
    **inputs**=*name* [,*name*,...]
    **expression**=*string*
    [**method**=*name* [,*name*,...]]
    **output**=*name*
    **basename**=*string*
    [**nprocs**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.rast3d.mapcalc.py inputs=name expression=string output=name basename=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***t.rast3d.mapcalc.py***",
        **inputs**,
        **expression**,
        **method**=*"during,overlap,contain,equal"*,
        **output**,
        **basename**,
        **nprocs**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("t.rast3d.mapcalc.py", inputs="name", expression="string", output="name", basename="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_rast3d_mapcalc_py*(**inputs**,
        **expression**,
        **method**=*"during,overlap,contain,equal"*,
        **output**,
        **basename**,
        **nprocs**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_rast3d_mapcalc_py(inputs="name", expression="string", output="name", basename="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **inputs**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster3d datasets  
    **expression**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;r3.mapcalc expression applied to each time step of the sampled data  
    **method**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;The method to be used for sampling the input dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *start, during, overlap, contain, equal, follows, precedes*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *during,overlap,contain,equal*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time raster3d dataset  
    **basename**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename of the new generated output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;A numerical suffix separated by an underscore will be attached to create a unique identifier  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r3.mapcalc processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Register Null maps  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Check the spatial topology of temporally related maps and process only spatially related maps  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **inputs** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster3d datasets  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, str3ds, *name*  
    **expression** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;r3.mapcalc expression applied to each time step of the sampled data  
    **method** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The method to be used for sampling the input dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *start, during, overlap, contain, equal, follows, precedes*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *during,overlap,contain,equal*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time raster3d dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, str3ds, *name*  
    **basename** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename of the new generated output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;A numerical suffix separated by an underscore will be attached to create a unique identifier  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r3.mapcalc processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Register Null maps  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Check the spatial topology of temporally related maps and process only spatially related maps  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **inputs** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster3d datasets  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, str3ds, *name*  
    **expression** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;r3.mapcalc expression applied to each time step of the sampled data  
    **method** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The method to be used for sampling the input dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *start, during, overlap, contain, equal, follows, precedes*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *during,overlap,contain,equal*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time raster3d dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, str3ds, *name*  
    **basename** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename of the new generated output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;A numerical suffix separated by an underscore will be attached to create a unique identifier  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r3.mapcalc processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Register Null maps  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Check the spatial topology of temporally related maps and process only spatially related maps  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*t.rast3d.mapcalc* provides exact the same functionality as
*t.rast.mapcalc*, but for space time 3D raster datasets. Please refer to
[t.rast.mapcalc](t.rast.mapcalc.md) for documentation.

It is a simple wrapper for [r3.mapcalc](r3.mapcalc.md) enhanced with
temporal functions.

## SEE ALSO

*[t.rast.mapcalc](t.rast.mapcalc.md),
[t.rast3d.algebra](t.rast3d.algebra.md), [r3.mapcalc](r3.mapcalc.md)*

## AUTHOR

Sören Gebbert, Thünen Institute of Climate-Smart Agriculture

## SOURCE CODE

Available at: [t.rast3d.mapcalc source code](https://github.com/OSGeo/grass/tree/main/temporal/t.rast3d.mapcalc)
([history](https://github.com/OSGeo/grass/commits/main/temporal/t.rast3d.mapcalc))  
Latest change: Wednesday Apr 02 17:48:37 2025 in commit [571253a](https://github.com/OSGeo/grass/commit/571253a5e75ae2ff6ba7adf14fbc859ba7acd92c)
