---
name: v.centroids.py
description: Adds missing centroids to closed boundaries.
keywords: [ vector, centroid, area ]
---

# v.centroids.py

Adds missing centroids to closed boundaries.

=== "Command line"

    **v.centroids.py**
    **input**=*name*
    **output**=*name*
    [**option**=*string*]
    [**layer**=*string*]
    [**cat**=*integer*]
    [**step**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.centroids.py input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.centroids.py***",
        **input**,
        **output**,
        **option**=*"add"*,
        **layer**=*"1"*,
        **cat**=*1*,
        **step**=*1*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.centroids.py", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_centroids_py*(**input**,
        **output**,
        **option**=*"add"*,
        **layer**=*"1"*,
        **cat**=*1*,
        **step**=*1*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_centroids_py(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **option**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Action to be taken  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *add*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *add*  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **cat**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category number starting value  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **step**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category increment  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **option** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Action to be taken  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *add*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *add*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **cat** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category number starting value  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **step** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category increment  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **option** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Action to be taken  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *add*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *add*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **cat** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category number starting value  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **step** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category increment  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

In GRASS, a centroid is a point within a closed ring of boundaries.
A vector area is defined as composite entity consisting of a set of
closed boundaries and a centroid. The attribute information associated
with this area is linked to the centroid. The *v.centroids* module adds
centroids to closed boundaries in the **input** file and assigns a
category number to them. The starting value as well as the increment
size may be set using optional parameters.

Multiple attributes may be linked to a single vector entity through
numbered fields referred to as layers. Refer to *v.category* for more
details, as *v.centroids* is simply a frontend to that module.

The boundary itself is often stored without any category reference as it
can mark the border between two adjacent areas. Thus it would be
ambiguous as to which feature the attribute would belong. In some cases
it may, for example, represent a road between two parcels of land. In
this case it is entirely appropriate for the boundary to contain
category information.

## EXAMPLES

Create an area from a closed line using North Carolina sample dataset:

```sh
v.type input=busroute11 output=busroute11_boundary from_type=line to_type=boundary
v.centroids input=busroute11_boundary output=busroute11_area
```

![v.centroids example](v_centroids.png)  
*Figure: Creating area from closed line*

## SEE ALSO

*[v.category](v.category.md)*

## AUTHORS

module: M. Hamish Bowman, Dept. Marine Science, Otago University, New
Zealand  
help page: Trevor Wiens

## SOURCE CODE

Available at: [v.centroids source code](https://github.com/OSGeo/grass/tree/main/scripts/v.centroids)
([history](https://github.com/OSGeo/grass/commits/main/scripts/v.centroids))  
Latest change: Friday Aug 08 09:39:19 2025 in commit [ed72c71](https://github.com/OSGeo/grass/commit/ed72c71d8580e872cd6fd345c84a15c324764465)
