---
name: v.db.dropcolumn.py
description: Drops a column from the attribute table connected to a given vector map.
keywords: [ vector, attribute table, database ]
---

# v.db.dropcolumn.py

Drops a column from the attribute table connected to a given vector map.

=== "Command line"

    **v.db.dropcolumn.py**
    **map**=*name*
    [**layer**=*string*]
    **columns**=*name* [,*name*,...]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.db.dropcolumn.py map=name columns=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.db.dropcolumn.py***",
        **map**,
        **layer**=*"1"*,
        **columns**,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.db.dropcolumn.py", map="name", columns="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_db_dropcolumn_py*(**map**,
        **layer**=*"1"*,
        **columns**,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_db_dropcolumn_py(map="name", columns="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **columns**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column(s) to drop  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **columns** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column(s) to drop  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **columns** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column(s) to drop  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.db.dropcolumn* drops a column from the attribute table connected to a
given vector map. It automatically checks the connection for the
specified layer. *v.db.dropcolumn* omits to delete the 'cat' column
which is relevant to keep the connection between vector map and table.

## NOTES

*v.db.dropcolumn* is a front-end to *db.execute* to allow easier usage.

The existing database connection(s) can be verified with *v.db.connect*.

## EXAMPLES

Dropping a column:  

```sh
g.copy vect=roadsmajor,myroads
v.info -c myroads
v.db.dropcolumn myroads column=SHAPE_LEN
v.info -c myroads
```

## SEE ALSO

*[db.connect](db.connect.md), [db.dropcolumn](db.dropcolumn.md),
[db.execute](db.execute.md), [v.db.addcolumn](v.db.addcolumn.md),
[v.db.connect](v.db.connect.md), [v.db.droptable](v.db.droptable.md),
[v.db.select](v.db.select.md), [v.db.update](v.db.update.md)*

*[GRASS SQL interface](sql.md)*

## AUTHOR

Markus Neteler

## SOURCE CODE

Available at: [v.db.dropcolumn source code](https://github.com/OSGeo/grass/tree/main/scripts/v.db.dropcolumn)
([history](https://github.com/OSGeo/grass/commits/main/scripts/v.db.dropcolumn))  
Latest change: Monday Feb 10 14:42:02 2025 in commit [5fe1b99](https://github.com/OSGeo/grass/commit/5fe1b99fd164594d032568b67f0543be3bd67766)
