---
name: v.support
description: Updates vector map metadata.
keywords: [ vector, metadata ]
---

# v.support

Updates vector map metadata.

=== "Command line"

    **v.support**
    [**-rh**]
    **map**=*name*
    [**organization**=*phrase*]
    [**date**=*datestring*]
    [**person**=*phrase*]
    [**map_name**=*phrase*]
    [**map_date**=*datestring*]
    [**scale**=*integer*]
    [**zone**=*integer*]
    [**threshold**=*float*]
    [**comment**=*phrase*]
    [**cmdhist**=*command*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.support map=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.support***",
        **map**,
        **organization**=*None*,
        **date**=*None*,
        **person**=*None*,
        **map_name**=*None*,
        **map_date**=*None*,
        **scale**=*None*,
        **zone**=*None*,
        **threshold**=*None*,
        **comment**=*None*,
        **cmdhist**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.support", map="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_support*(**map**,
        **organization**=*None*,
        **date**=*None*,
        **person**=*None*,
        **map_name**=*None*,
        **map_date**=*None*,
        **scale**=*None*,
        **zone**=*None*,
        **threshold**=*None*,
        **comment**=*None*,
        **cmdhist**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_support(map="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **organization**=*phrase*  
    &nbsp;&nbsp;&nbsp;&nbsp;Organization where vector map was created  
    **date**=*datestring*  
    &nbsp;&nbsp;&nbsp;&nbsp;Date of vector map digitization (e.g., "15 Mar 2007")  
    **person**=*phrase*  
    &nbsp;&nbsp;&nbsp;&nbsp;Person who created vector map  
    **map_name**=*phrase*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map title  
    **map_date**=*datestring*  
    &nbsp;&nbsp;&nbsp;&nbsp;Date when the source map was originally produced  
    **scale**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map scale number (e.g., 24000)  
    **zone**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map projection zone  
    **threshold**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map digitizing threshold number (e.g., 0.5)  
    **comment**=*phrase*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to append to the comment line of the map's metadata file  
    **cmdhist**=*command*  
    &nbsp;&nbsp;&nbsp;&nbsp;Command line to store into vector map history file (used for vector scripts)  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Replace comment instead of appending it  
    **-h**  
    &nbsp;&nbsp;&nbsp;&nbsp;Replace command line instead of appending it  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **organization** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Organization where vector map was created  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **date** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Date of vector map digitization (e.g., "15 Mar 2007")  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *datestring*  
    **person** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Person who created vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **map_name** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map title  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **map_date** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Date when the source map was originally produced  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *datestring*  
    **scale** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map scale number (e.g., 24000)  
    **zone** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map projection zone  
    **threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map digitizing threshold number (e.g., 0.5)  
    **comment** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to append to the comment line of the map's metadata file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **cmdhist** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Command line to store into vector map history file (used for vector scripts)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *command*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *h*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Replace comment instead of appending it  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Replace command line instead of appending it  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **organization** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Organization where vector map was created  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **date** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Date of vector map digitization (e.g., "15 Mar 2007")  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *datestring*  
    **person** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Person who created vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **map_name** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map title  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **map_date** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Date when the source map was originally produced  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *datestring*  
    **scale** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map scale number (e.g., 24000)  
    **zone** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map projection zone  
    **threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map digitizing threshold number (e.g., 0.5)  
    **comment** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to append to the comment line of the map's metadata file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **cmdhist** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Command line to store into vector map history file (used for vector scripts)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *command*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *h*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Replace comment instead of appending it  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Replace command line instead of appending it  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.support* is used to set/update vector map metadata. While GRASS
typically generates these metadata entries automatically, *v.support*
allows users to manually edit them when necessary.

## EXAMPLE

```sh
# update scale to 1:24000
v.support myvectmap scale=24000

# update organization
v.support myvectmap organization="OSGeo labs"
v.info myvectmap
```

## SEE ALSO

*[v.build](v.build.md), [v.info](v.info.md)*

## AUTHOR

Markus Neteler, Trento

## SOURCE CODE

Available at: [v.support source code](https://github.com/OSGeo/grass/tree/main/vector/v.support)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.support))  
Latest change: Friday Aug 08 09:39:19 2025 in commit [ed72c71](https://github.com/OSGeo/grass/commit/ed72c71d8580e872cd6fd345c84a15c324764465)
