/***************************************************************************
  qgsspacerwidgetwrapper.h - QgsSpacerWidgetWrapper

 ---------------------
 begin                : 16.1.2023
 copyright            : (C) 2023 by Alessandro Pasotti
 email                : elpaso at itopen dot it
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef QGSSPACERWIDGETWRAPPER_H
#define QGSSPACERWIDGETWRAPPER_H

#include "qgis_gui.h"
#include "qgswidgetwrapper.h"

/**
 * \ingroup gui
 * \brief Wraps a spacer widget.
 * \since QGIS 3.30
 */
class GUI_EXPORT QgsSpacerWidgetWrapper : public QgsWidgetWrapper
{
    Q_OBJECT
  public:

    /**
     * Create a new widget wrapper
     *
     * \param layer     The vector layer of the form the widget belongs to.
     * \param editor    An editor widget. Can be NULLPTR if one should be autogenerated.
     * \param parent    A parent widget for this widget wrapper and the created widget.
     */
    explicit QgsSpacerWidgetWrapper( QgsVectorLayer *layer, QWidget *editor = nullptr, QWidget *parent = nullptr );

    bool valid() const override;

    /**
     * Returns TRUE if the spacer element will contain an horizontal line.
     */
    bool drawLine() const;

    /**
     * Sets a flag to define if the spacer element will contain an horizontal line.
     * \param drawLine flag status
     */
    void setDrawLine( bool drawLine );

  protected:
    QWidget *createWidget( QWidget *parent ) override;

  public slots:
    void setFeature( const QgsFeature &feature ) override;

  private:
    bool mDrawLine = false;
};

#endif // QGSSPACERWIDGETWRAPPER_H
