---
name: db.test.py
description: Test database driver, database must exist and set by db.connect.
keywords: [ database, attribute table ]
---

# db.test.py

Test database driver, database must exist and set by db.connect.

=== "Command line"

    **db.test.py**
    **test**=*string*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    db.test.py test=test1
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***db.test.py***",
        **test**,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("db.test.py", test="test1")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.db_test_py*(**test**,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.db_test_py(test="test1")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **test**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Test name  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *test1*  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **test** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Test name  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *test1*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **test** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Test name  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *test1*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*db.test* tests database driver and database server running set of SQL
queries. Database must exist and connection must be set by *db.connect*.

## EXAMPLE

Test current SQL backend driver:

```sh
db.connect -p
db.test test=test1
```

## SEE ALSO

*[GRASS SQL interface](sql.md), [db.connect](db.connect.md),
[db.describe](db.describe.md), [db.drivers](db.drivers.md)*

## AUTHOR

Radim Blazek

## SOURCE CODE

Available at: [db.test source code](https://github.com/OSGeo/grass/tree/main/scripts/db.test)
([history](https://github.com/OSGeo/grass/commits/main/scripts/db.test))  
Latest change: Friday Oct 10 10:16:04 2025 in commit [85fa0b4](https://github.com/OSGeo/grass/commit/85fa0b484faeb8ae27841cfbee90231c704a5272)
