---
name: g.download.location.py
description: Download GRASS project (location) from the web Get GRASS project from an URL or file path
keywords: [ general, data, download, import ]
---

# g.download.location.py

Download GRASS project (location) from the web

Get GRASS project from an URL or file path

=== "Command line"

    **g.download.location.py**
    **url**=*string*
    [**name**=*name*]
    [**path**=*path*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.download.location.py url=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***g.download.location.py***",
        **url**,
        **name**=*None*,
        **path**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("g.download.location.py", url="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_download_location_py*(**url**,
        **name**=*None*,
        **path**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_download_location_py(url="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **url**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of the archive with a project to be downloaded  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of ZIP, TAR.GZ, or other similar archive  
    **name**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Project (location) name  
    &nbsp;&nbsp;&nbsp;&nbsp;Project name (not path to project)  
    **path**=*path*  
    &nbsp;&nbsp;&nbsp;&nbsp;GRASS database directory  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: path to the current GRASS database  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **url** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of the archive with a project to be downloaded  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of ZIP, TAR.GZ, or other similar archive  
    **name** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Project (location) name  
    &nbsp;&nbsp;&nbsp;&nbsp;Project name (not path to project)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, location, *name*  
    **path** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;GRASS database directory  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: path to the current GRASS database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbase, *path*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **url** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of the archive with a project to be downloaded  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of ZIP, TAR.GZ, or other similar archive  
    **name** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Project (location) name  
    &nbsp;&nbsp;&nbsp;&nbsp;Project name (not path to project)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, location, *name*  
    **path** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;GRASS database directory  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: path to the current GRASS database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbase, *path*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*g.download.location* has been renamed to
[g.download.project](g.download.project.md) and exists for backwards
compatibility reasons. It will be removed in the next major version.

## SEE ALSO

*[g.download.project](g.download.project.md)*

## AUTHOR

Vaclav Petras, [NCSU GeoForAll
Lab](http://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [g.download.location source code](https://github.com/OSGeo/grass/tree/main/scripts/g.download.location)
([history](https://github.com/OSGeo/grass/commits/main/scripts/g.download.location))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
