---
name: r.to.rast3
description: Converts 2D raster map slices to one 3D raster volume map.
keywords: [ raster, conversion, voxel ]
---

# r.to.rast3

Converts 2D raster map slices to one 3D raster volume map.

=== "Command line"

    **r.to.rast3**
    [**-m**]
    **input**=*name* [,*name*,...]
    **output**=*name*
    [**tilesize**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.to.rast3 input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.to.rast3***",
        **input**,
        **output**,
        **tilesize**=*32*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.to.rast3", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_to_rast3*(**input**,
        **output**,
        **tilesize**=*32*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_to_rast3(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;2D raster maps which represent the slices  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    **tilesize**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;The maximum tile size in kilo bytes. Default is 32KB.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *32*  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use 3D raster mask (if exists) with output map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;2D raster maps which represent the slices  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **tilesize** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The maximum tile size in kilo bytes. Default is 32KB.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *32*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use 3D raster mask (if exists) with output map  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;2D raster maps which represent the slices  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **tilesize** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The maximum tile size in kilo bytes. Default is 32KB.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *32*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use 3D raster mask (if exists) with output map  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.to.rast3* converts 2D raster map(s) into one raster3D map. It is
important to properly set the 3D region settings, especially number or
layers and depth of layers. If the 2D and 3D region settings are
different, the 2D resolution will be adjusted to the 3D resolution.

![How r.to.rast3 works](r.to.rast3.png)  
*How r.to.rast3 works*

## NOTES

Every 2D raster map is copied as one slice to the raster3D map. Slices
are counted from bottom to the top, so the bottom slice has to be number
1.  
  
If less number of 2D raster maps are provided than defined depths, the
last given 2D map is used to fill up the remaining raster3D slices to
the top.

## EXAMPLES

### EXAMPLE 1

This example shows how to convert 6 maps into one 3D map with 6
layers.  

```sh
# Mapset data in dataset slovakia3d
g.region raster=prec_1,prec_2,prec_3,prec_4,prec_5,prec_6 -p
g.region b=0 t=600 tbres=100 res3=100 -p3
r.to.rast3 input=prec_1,prec_2,prec_3,prec_4,prec_5,prec_6 output=new_3dmap
```

### EXAMPLE 2

This example shows how to convert 3 maps into one 3D map with 6
layers.  

```sh
# Mapset data in dataset slovakia3d
g.region b=0 t=600 tbres=100 res3=100 -p3
r.to.rast3 input=prec_1,prec_2,prec_3 output=new_3dmap
```

## SEE ALSO

*[g.region](g.region.md), [r3.to.rast](r3.to.rast.md),
[r.to.rast3elev](r.to.rast3elev.md)*

## AUTHOR

Soeren Gebbert

## SOURCE CODE

Available at: [r.to.rast3 source code](https://github.com/OSGeo/grass/tree/main/raster/r.to.rast3)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.to.rast3))  
Latest change: Tuesday Feb 18 17:20:26 2025 in commit [688e625](https://github.com/OSGeo/grass/commit/688e625e7db3be9a465ce99ba25f36d2ebdd5aeb)
