---
name: t.rast.import.py
description: Imports space time raster dataset.
keywords: [ temporal, import, raster, time, create project ]
---

# t.rast.import.py

Imports space time raster dataset.

=== "Command line"

    **t.rast.import.py**
    [**-rleoc**]
    **input**=*name*
    **output**=*name*
    [**basename**=*string*]
    **directory**=*name*
    [**title**=*string*]
    [**description**=*string*]
    [**project**=*string*]
    [**memory**=*memory in MB*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.rast.import.py input=name output=name directory=/tmp
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***t.rast.import.py***",
        **input**,
        **output**,
        **basename**=*None*,
        **directory**=*"/tmp"*,
        **title**=*None*,
        **description**=*None*,
        **project**=*None*,
        **memory**=*300*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("t.rast.import.py", input="name", output="name", directory="/tmp")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_rast_import_py*(**input**,
        **output**,
        **basename**=*None*,
        **directory**=*"/tmp"*,
        **title**=*None*,
        **description**=*None*,
        **project**=*None*,
        **memory**=*300*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_rast_import_py(input="name", output="name", directory="/tmp")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time raster dataset  
    **basename**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename of the new generated output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;A numerical suffix separated by an underscore will be attached to create a unique identifier  
    **directory**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to the extraction directory  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: */tmp*  
    **title**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title of the new space time dataset  
    **description**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Description of the new space time dataset  
    **project**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Create a new project and import the data into it. Do not run this module in parallel or interrupt it when a new project should be created  
    **memory**=*memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the current region from the last map that was imported  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Link the raster files using r.external  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Extend project extents based on new dataset  
    **-o**  
    &nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current projects's CRS)  
    &nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has same coordinate reference system as the current location  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create the project specified by the "project" parameter and exit. Do not import the space time raster datasets.  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, strds, *name*  
    **basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename of the new generated output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;A numerical suffix separated by an underscore will be attached to create a unique identifier  
    **directory** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to the extraction directory  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: */tmp*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title of the new space time dataset  
    **description** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Description of the new space time dataset  
    **project** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Create a new project and import the data into it. Do not run this module in parallel or interrupt it when a new project should be created  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *l*, *e*, *o*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set the current region from the last map that was imported  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Link the raster files using r.external  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Extend project extents based on new dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current projects's CRS)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has same coordinate reference system as the current location  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create the project specified by the "project" parameter and exit. Do not import the space time raster datasets.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, strds, *name*  
    **basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename of the new generated output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;A numerical suffix separated by an underscore will be attached to create a unique identifier  
    **directory** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to the extraction directory  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dir, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: */tmp*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title of the new space time dataset  
    **description** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Description of the new space time dataset  
    **project** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Create a new project and import the data into it. Do not run this module in parallel or interrupt it when a new project should be created  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *l*, *e*, *o*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set the current region from the last map that was imported  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Link the raster files using r.external  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Extend project extents based on new dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current projects's CRS)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has same coordinate reference system as the current location  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create the project specified by the "project" parameter and exit. Do not import the space time raster datasets.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*t.rast.import* imports a space time raster dataset archive that was
exported with [t.rast.export](t.rast.export.md).

## NOTES

Optionally a base map name can be provided to avoid that existing raster
maps are overwritten by the map names that are used in the STRDS
archive.

The **directory** is used as work directory in case of import but can
also be used as a data directory when using GeoTIFF for the data
exchange.

## EXAMPLE

The North Carolina space time dataset contains a data package called
*lst_daily.tar.bzip2* with daily data from MODIS LST. Import it by
running:

```sh
t.rast.import input=lst_daily.tar.bzip2 output=lst_daily \
              basename=lst directory=/tmp
```

## SEE ALSO

*[t.rast.export](t.rast.export.md), [t.create](t.create.md),
[t.info](t.info.md), [r.in.gdal](r.in.gdal.md), [r.unpack](r.unpack.md),
[t.vect.import](t.vect.import.md)*

## AUTHOR

Sören Gebbert, Thünen Institute of Climate-Smart Agriculture

## SOURCE CODE

Available at: [t.rast.import source code](https://github.com/OSGeo/grass/tree/main/temporal/t.rast.import)
([history](https://github.com/OSGeo/grass/commits/main/temporal/t.rast.import))  
Latest change: Wednesday Apr 02 17:48:37 2025 in commit [571253a](https://github.com/OSGeo/grass/commit/571253a5e75ae2ff6ba7adf14fbc859ba7acd92c)
