---
name: v.buffer
description: Creates a buffer around vector features of given type.
keywords: [ vector, buffer, area, circle, geometry, line, grow, shrink ]
---

# v.buffer

Creates a buffer around vector features of given type.

=== "Command line"

    **v.buffer**
    [**-sct**]
    **input**=*name*
    [**layer**=*string*]
    [**cats**=*range*]
    [**where**=*sql_query*]
    [**type**=*string* [,*string*,...]]
    **output**=*name*
    [**distance**=*float*]
    [**minordistance**=*float*]
    [**angle**=*float*]
    [**column**=*name*]
    [**scale**=*float*]
    [**tolerance**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.buffer input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.buffer***",
        **input**,
        **layer**=*"-1"*,
        **cats**=*None*,
        **where**=*None*,
        **type**=*"point,line,area"*,
        **output**,
        **distance**=*None*,
        **minordistance**=*None*,
        **angle**=*0*,
        **column**=*None*,
        **scale**=*1.0*,
        **tolerance**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.buffer", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_buffer*(**input**,
        **layer**=*"-1"*,
        **cats**=*None*,
        **where**=*None*,
        **type**=*"point,line,area"*,
        **output**,
        **distance**=*None*,
        **minordistance**=*None*,
        **angle**=*0*,
        **column**=*None*,
        **scale**=*1.0*,
        **tolerance**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_buffer(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **cats**=*range*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **distance**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Buffer distance along major axis in map units  
    **minordistance**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Buffer distance along minor axis in map units  
    **angle**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Angle of major axis in degrees  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column to use for buffer distances  
    **scale**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor for attribute column values  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **tolerance**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance between theoretical arc and polygon segments as multiple of buffer (default 0.01)  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Make outside corners straight  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not make caps at the ends of polylines  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Transfer categories and attributes  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **distance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Buffer distance along major axis in map units  
    **minordistance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Buffer distance along minor axis in map units  
    **angle** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Angle of major axis in degrees  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column to use for buffer distances  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor for attribute column values  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **tolerance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance between theoretical arc and polygon segments as multiple of buffer (default 0.01)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *c*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Make outside corners straight  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not make caps at the ends of polylines  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Transfer categories and attributes  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **distance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Buffer distance along major axis in map units  
    **minordistance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Buffer distance along minor axis in map units  
    **angle** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Angle of major axis in degrees  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column to use for buffer distances  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor for attribute column values  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **tolerance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance between theoretical arc and polygon segments as multiple of buffer (default 0.01)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *c*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Make outside corners straight  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not make caps at the ends of polylines  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Transfer categories and attributes  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.buffer* creates a buffer around features of given **type**, which
have a category in the given **layer**. The **tolerance** controls the
number of vector segments being generated (the smaller the value, the
more vector segments are generated).

## NOTES

Internal buffers for areas can be generated with negative distance
values ("inward buffer" or "negative buffer" or "shrinking").

*v.buffer* fusions the geometries of buffers by default. Categories and
attribute table will not be transferred (this would not make sense as
one buffer geometry can be the result of many different input
geometries). To transfer the categories and attributes the user can set
the **-t** flag. This will result in buffers being cut up where buffers
of individual input geometries overlap. Each part that is the result of
overlapping buffers of multiple geometries will have multiple categories
corresponding to those geometries, and multiple buffer areas can have
the same category. The buffer for the input feature with category X can
thus be retrieved by selecting all buffer areas with category X (see
example below).

Buffers for lines and areas are generated using the algorithms from the
GEOS library.

*For advanced users:* the built-in buffer algorithm is no longer used,
as we use GEOS instead. If GRASS was not compiled with GEOS support or
the [environmental variable](variables.md) `GRASS_VECTOR_BUFFER` is
defined, then GRASS generates buffers using the built-in buffering
algorithm (which is still buggy for some input data).

The options **minordistance**, **angle**, **tolerance** are kept for
backward compatibility and have no effect with GEOS buffering.

### Corner settings

The following vector line related corners (also called "cap") exist:

- no cap:       ![line buffer: no cap](v_buffer_no_cap.png)
- rounded cap: ![line buffer: rounded cap](v_buffer_rounded_cap.png)
- square cap: ![line buffer: square cap](v_buffer_square_cap.png)

By default *v.buffer* creates rounded buffers (blue color on figure
below):

![v_buffer_line](v_buffer_line.png)

Straight corners with caps are created using the **-s** flag (red color
on the figure below), while the **-c** flag doesn't make caps at the
ends of polylines (green color on the figure below):

![v_buffer_line_s](v_buffer_line_s.png)

With a point vector map as input data, square buffers are created
instead of round buffers by using the **-s** flag.

![v_buffer_point_s](v_buffer_point_s.png)

## EXAMPLES

All examples are based on the North Carolina sample dataset.

### Buffer around input lines

```sh
v.buffer input=roadsmajor output=roadsmajor_buffer type=line distance=100
```

![Buffer of 100m along the roadsmajor lines](v_buffer_lines.png)  
*Buffer of 100m along the "roadsmajor" lines (map subset, original center
line shown in black)*

### Circles around input points

```sh
v.buffer input=hospitals output=hospitals_circled type=point distance=2000
```

![Buffer of 2000m around the hospitals points](v_buffer_points.png)  
*Buffer of 2000m around the "hospitals" points (map subset, original
points shown in black, new area centroids in red)*

### Circles around input points with attribute transfer

```sh
v.buffer input=hospitals output=hospitals_circled type=point distance=1000 -t

# display buffer around hospital with category 36,
# this buffer is composed of several areas:
d.vect map=hospitals_circled type=area layer=1 cats=36
# extract this buffer, dissolving boundaries
v.extract in=hospitals_circled output=hospital_36_circled layer=1 cats=36 -d
```

### Buffer around input areas

```sh
v.buffer input=lakes output=lakes_buffer type=area distance=100
```

![Buffer of 100m around the "lakes" polygons](v_buffer_areas.png)  
*Buffer of 100m around the "lakes" polygons (map subset, original areas
shown in black)*

### Buffer inside input areas

In this example, an internal buffer ("inward buffer" or "negative
buffer") is generated using a negative **distance** value:

```sh
v.buffer input=lakes output=lakes_buffer type=area distance=-50
```

![Internal buffer of 50m inside the lakes polygons](v_buffer_areas_int.png)  
*Internal buffer of 50m inside the "lakes" polygons (map subset, original
areas shown in black)*

Not all features are buffered, only the polygons that allow creation
inside a topological cleaned polygon.

## REFERENCES

- [GEOS Library](https://trac.osgeo.org/geos)

## SEE ALSO

*[r.buffer](r.buffer.md), [v.parallel](v.parallel.md),
[v.extract](v.extract.md), [v.type](v.type.md), [v.patch](v.patch.md),
[v.db.connect](v.db.connect.md)*

## AUTHORS

Radim Blazek  
Rewritten by Rosen Matev (with support through the Google Summer of Code
program 2008)  
Rewritten by Markus Metz (2011, 2012)

## SOURCE CODE

Available at: [v.buffer source code](https://github.com/OSGeo/grass/tree/main/vector/v.buffer)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.buffer))  
Latest change: Thursday Feb 20 12:48:50 2025 in commit [1633be4](https://github.com/OSGeo/grass/commit/1633be4dc57dd1819a0f6ccd8ea4bc2b8bbec864)
