---
name: v.clean
description: Toolset for cleaning topology of vector map.
keywords: [ vector, topology, geometry, snapping ]
---

# v.clean

Toolset for cleaning topology of vector map.

=== "Command line"

    **v.clean**
    [**-bc**]
    **input**=*name*
    [**layer**=*string*]
    [**type**=*string* [,*string*,...]]
    **output**=*name*
    [**error**=*name*]
    **tool**=*string* [,*string*,...]
    [**threshold**=*float* [,*float*,...]]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.clean input=name output=name tool=break
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.clean***",
        **input**,
        **layer**=*"-1"*,
        **type**=*"point,line,boundary,centroid,area,face,kernel"*,
        **output**,
        **error**=*None*,
        **tool**,
        **threshold**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.clean", input="name", output="name", tool="break")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_clean*(**input**,
        **layer**=*"-1"*,
        **type**=*"point,line,boundary,centroid,area,face,kernel"*,
        **output**,
        **error**=*None*,
        **tool**,
        **threshold**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_clean(input="name", output="name", tool="break")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area, face, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid,area,face,kernel*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **error**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output map where errors are written  
    **tool**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Cleaning tool  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *break, snap, rmdangle, chdangle, rmbridge, chbridge, rmdupl, rmdac, bpol, prune, rmarea, rmline, rmsa*  
    &nbsp;&nbsp;&nbsp;&nbsp;**break**: break lines at each intersection  
    &nbsp;&nbsp;&nbsp;&nbsp;**snap**: snap lines to vertex in threshold  
    &nbsp;&nbsp;&nbsp;&nbsp;**rmdangle**: remove dangles, threshold ignored if &lt; 0  
    &nbsp;&nbsp;&nbsp;&nbsp;**chdangle**: change the type of boundary dangle to line, threshold ignored if &lt; 0, input line type is ignored  
    &nbsp;&nbsp;&nbsp;&nbsp;**rmbridge**: remove bridges connecting area and island or 2 islands  
    &nbsp;&nbsp;&nbsp;&nbsp;**chbridge**: change the type of bridges connecting area and island or 2 islands from boundary to line  
    &nbsp;&nbsp;&nbsp;&nbsp;**rmdupl**: remove duplicate geometry features (pay attention to categories!)  
    &nbsp;&nbsp;&nbsp;&nbsp;**rmdac**: remove duplicate area centroids ('type' option ignored)  
    &nbsp;&nbsp;&nbsp;&nbsp;**bpol**: break (topologically clean) polygons (imported from non topological format, like ShapeFile). Boundaries are broken on each point shared between 2 and more polygons where angles of segments are different  
    &nbsp;&nbsp;&nbsp;&nbsp;**prune**: remove vertices in threshold from lines and boundaries, boundary is pruned only if topology is not damaged (new intersection, changed attachment of centroid), first and last segment of the boundary is never changed  
    &nbsp;&nbsp;&nbsp;&nbsp;**rmarea**: remove small areas, the longest boundary with adjacent area is removed  
    &nbsp;&nbsp;&nbsp;&nbsp;**rmline**: remove all lines or boundaries of zero length, threshold is ignored  
    &nbsp;&nbsp;&nbsp;&nbsp;**rmsa**: remove small angles between lines at nodes  
    **threshold**=*float* [,*float*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;One value for each tool; for threshold units, see each tool  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: 0.0[,0.0,...])  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not build topology for the output vector  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Combine tools with recommended follow-up tools  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area, face, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid,area,face,kernel*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **error** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output map where errors are written  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **tool** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cleaning tool  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *break, snap, rmdangle, chdangle, rmbridge, chbridge, rmdupl, rmdac, bpol, prune, rmarea, rmline, rmsa*  
    &nbsp;&nbsp;&nbsp;&nbsp;**break**: break lines at each intersection  
    &nbsp;&nbsp;&nbsp;&nbsp;**snap**: snap lines to vertex in threshold  
    &nbsp;&nbsp;&nbsp;&nbsp;**rmdangle**: remove dangles, threshold ignored if &lt; 0  
    &nbsp;&nbsp;&nbsp;&nbsp;**chdangle**: change the type of boundary dangle to line, threshold ignored if &lt; 0, input line type is ignored  
    &nbsp;&nbsp;&nbsp;&nbsp;**rmbridge**: remove bridges connecting area and island or 2 islands  
    &nbsp;&nbsp;&nbsp;&nbsp;**chbridge**: change the type of bridges connecting area and island or 2 islands from boundary to line  
    &nbsp;&nbsp;&nbsp;&nbsp;**rmdupl**: remove duplicate geometry features (pay attention to categories!)  
    &nbsp;&nbsp;&nbsp;&nbsp;**rmdac**: remove duplicate area centroids ('type' option ignored)  
    &nbsp;&nbsp;&nbsp;&nbsp;**bpol**: break (topologically clean) polygons (imported from non topological format, like ShapeFile). Boundaries are broken on each point shared between 2 and more polygons where angles of segments are different  
    &nbsp;&nbsp;&nbsp;&nbsp;**prune**: remove vertices in threshold from lines and boundaries, boundary is pruned only if topology is not damaged (new intersection, changed attachment of centroid), first and last segment of the boundary is never changed  
    &nbsp;&nbsp;&nbsp;&nbsp;**rmarea**: remove small areas, the longest boundary with adjacent area is removed  
    &nbsp;&nbsp;&nbsp;&nbsp;**rmline**: remove all lines or boundaries of zero length, threshold is ignored  
    &nbsp;&nbsp;&nbsp;&nbsp;**rmsa**: remove small angles between lines at nodes  
    **threshold** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;One value for each tool; for threshold units, see each tool  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: 0.0[,0.0,...])  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *b*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not build topology for the output vector  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Combine tools with recommended follow-up tools  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area, face, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid,area,face,kernel*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **error** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output map where errors are written  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **tool** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cleaning tool  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *break, snap, rmdangle, chdangle, rmbridge, chbridge, rmdupl, rmdac, bpol, prune, rmarea, rmline, rmsa*  
    &nbsp;&nbsp;&nbsp;&nbsp;**break**: break lines at each intersection  
    &nbsp;&nbsp;&nbsp;&nbsp;**snap**: snap lines to vertex in threshold  
    &nbsp;&nbsp;&nbsp;&nbsp;**rmdangle**: remove dangles, threshold ignored if &lt; 0  
    &nbsp;&nbsp;&nbsp;&nbsp;**chdangle**: change the type of boundary dangle to line, threshold ignored if &lt; 0, input line type is ignored  
    &nbsp;&nbsp;&nbsp;&nbsp;**rmbridge**: remove bridges connecting area and island or 2 islands  
    &nbsp;&nbsp;&nbsp;&nbsp;**chbridge**: change the type of bridges connecting area and island or 2 islands from boundary to line  
    &nbsp;&nbsp;&nbsp;&nbsp;**rmdupl**: remove duplicate geometry features (pay attention to categories!)  
    &nbsp;&nbsp;&nbsp;&nbsp;**rmdac**: remove duplicate area centroids ('type' option ignored)  
    &nbsp;&nbsp;&nbsp;&nbsp;**bpol**: break (topologically clean) polygons (imported from non topological format, like ShapeFile). Boundaries are broken on each point shared between 2 and more polygons where angles of segments are different  
    &nbsp;&nbsp;&nbsp;&nbsp;**prune**: remove vertices in threshold from lines and boundaries, boundary is pruned only if topology is not damaged (new intersection, changed attachment of centroid), first and last segment of the boundary is never changed  
    &nbsp;&nbsp;&nbsp;&nbsp;**rmarea**: remove small areas, the longest boundary with adjacent area is removed  
    &nbsp;&nbsp;&nbsp;&nbsp;**rmline**: remove all lines or boundaries of zero length, threshold is ignored  
    &nbsp;&nbsp;&nbsp;&nbsp;**rmsa**: remove small angles between lines at nodes  
    **threshold** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;One value for each tool; for threshold units, see each tool  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: 0.0[,0.0,...])  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *b*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not build topology for the output vector  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Combine tools with recommended follow-up tools  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.clean* allows the user to automatically fix topology of vector maps.
Several tools may be listed to be executed sequentially. In this case,
also the threshold parameter requires several values to be listed
accordingly. An error map is optionally written which stores the
erroneous geometries.

### Break lines/boundaries

Setting *tool=break* breaks lines/boundaries at intersections and it also
breaks lines/boundaries forming a collapsed loop. For example,
0.0;1.0;0.0 is broken at 1.0.

Threshold does not apply (it is ignored), use an arbitrary value (e.g.,
0) if *v.clean* is run with several tools.

Hint: Breaking lines should be followed by removing duplicates, e.g.
*v.clean ... tool=break,rmdupl*. If the *-c* flag is used with *v.clean
... tool=break*, duplicates are automatically removed.

### Remove duplicate geometry features

Setting *tool=rmdupl* removes geometry features with identical coordinates.
Categories are merged. If a point and a centroid have identical
coordinates, one of them will be removed if both points and centroids
are selected with *v.clean ... type=point,centroid*. The same applies
for lines and boundaries.

Threshold does not apply (it is ignored), use an arbitrary value (e.g.,
0) if *v.clean* is run with several tools.

The *rmdupl* tool should be used after breaking lines and breaking
polygons.

### Remove dangles or change boundary dangles to type line

A line/boundary is considered to be a dangle if no other line of given
*type* is on at least one end node. If a dangle is formed by several
lines, such a string of lines is taken as one dangle and line lengths
are summarized. Setting *tool=rmdangle* deletes a dangle if the (combined)
length is shorter than *thresh* or *thresh* \< 0. If the combined length
is larger than *thresh*, nothing is deleted.

Threshold has to be given as maximum line/boundary length in map units;
for latitude-longitude projects in degrees. Dangles shorter than
*thresh* are removed sequentially. All dangles will be removed if
*thresh* \< 0.

With *thresh* \< 0, only closed loops and lines connecting loops will
remain. This is useful to remove all incorrect boundaries after other
cleaning operations with *thres* is \< 0. Areas can then be successfully
built.

To preferentially remove shortest dangles first, a first pass with a
small *thresh* value can be followed by subsequent passes with higher
*thresh* values. This can be done as one *v.clean* job by listing the
tool several times and by defining a list of increasing *thresh* values.

Setting *tool=chdangle* is similar to the *rmdangle* tool, but works only on
boundaries and changes dangling boundaries to lines instead of removing
them.

### Remove or change bridges connecting an area and an island or two islands

A bridge is an area type connection of an island (polygon in a polygon)
to the outer polygon. This is topologically incorrect (but OGC Simple
Features allow it). Setting *tool=rmbridge* removes bridges and setting
*tool=chbridge* changes bridges to type line:

```sh
    +-------------+             +-------------+   +-------------+
    |            P|  P: polygon |            P|   |            P|
    |    +---+    |  I: island  |    +---+    |   |    +---+    |
    |    | I |    |  B: bridge  |    | I |    |   |    | I |    |
    |    |   |    |  L: line    |    |   |    |   |    |   |    |
    |    +-+-+    |             |    +---+    |   |    +-.-+    |
    |      |      |             |             |   |      .      |
    |      | B    |             |             |   |      . L    |
    |      |      |             |             |   |      .      |
    +------+------+             +-------------+   +-------------+
```

Islands and areas must be already clean, i.e. without dangles or small
angles, e.g. *v.clean ... type=boundary
tool=rmdangle,rmsa,break,rmdupl,rmbridge thresh=-1,0,0,0,0*.

Threshold does not apply (it is ignored), use an arbitrary value (e.g.,
0) if *v.clean* is run with several tools.

### Snap lines to vertex in threshold

Setting *tool=snap* snaps vertices to another vertex not farther away than
*thresh*. If there is no other vertex within *thresh*, no snapping will
be done. The *type* option can have a strong influence on the result. A
too large threshold and *type=boundary* can severely damage area
topology, beyond repair.

Threshold gives maximum distance to another vertex in map units, for
latitude-longitude projects in degrees.

Snapped boundaries may need to be cleaned with *break,rmdupl,rmsa*. If
the *-c* flag is used with *v.clean tool=snap*, the sequence of
*break,rmdupl,rmsa* is automatically repeated after snapping until no
more small angles a left. Additional cleaning with e.g.
*tool=rmdangle*may be necessary.

### Remove duplicate area centroids

Setting *tool=rmdac* removes duplicate area centroids that can result from
deleting boundaries.

Threshold does not apply (it is ignored), use an arbitrary value (e.g.,
0) if *v.clean* is run with several tools.

### Break (topologically clean) areas (imported from a non topological format)

Setting *tool=bpol* breaks boundaries on each point shared between 2 and
more areas where angles of boundary segments are different and on all
boundary nodes (start and end points of each boundary). The *bpol* tool
behaves similar to *break* for boundaries, but does not break collapsed
loops. The *bpol* tool is faster than the *break* tool but needs more
memory.

Threshold does not apply (it is ignored), use an arbitrary value (e.g.,
0) if *v.clean* is run with several tools.

The *bpol* tool should be followed by *rmdupl*. If the *-c* flag is used
with *v.clean ... tool=bpol*, duplicates are automatically removed.

### Remove vertices in threshold from lines and boundaries

Setting *tool=prune* simplifies lines and boundaries by removing vertices
according to threshold. This tool preserves area topology, areas are
never deleted and centroid attachment is never changed.
*[v.generalize](v.generalize.md)* offers much more functionality for
line simplification but does not preserve area topology.

### Remove small areas

Setting *tool=rmarea* removes all areas \<= *thresh*. The longest boundary
with an adjacent area is removed or all boundaries if there is no
adjacent area. Area categories are not combined when a small area is
merged with a larger area.

Threshold must always be in square meters, also for latitude-longitude
projects or projects with units other than meters.

### Remove all lines or boundaries of zero length

Setting *tool=rmline* removes all lines or boundaries of zero length that
may have resulted from other cleaning operations. Zero length boundaries
are redundant and do not influence area topology.

Threshold does not apply (it is ignored), use an arbitrary value (e.g.,
0) if *v.clean* is run with several tools.

### Remove small angles between lines at nodes

Setting *tool=rmsa* only concerns angles which are so small that the
calculated angle is 0. The following figure should help demonstrate what
the tool does.

Threshold does not apply, use dummy value if *v.clean* is run with
several tools.

![v_clean_rmsa](v_clean_rmsa.png)  
*tool=rmsa*

The *rmsa* tool should be followed by *break,rmdupl*. The *rmsa* tool
followed by *break,rmdupl* may need to be run more than once to remove
all small angles. If the *-c* flag is used with *v.clean ... tool=rmsa*,
the sequence of *rmsa,break,rmdupl* is automatically repeated until no
more small angles a left.

## NOTES

The user does **not** have to run *[v.build](v.build.md)* on the
*output* vector, unless the *-b* flag was used. The *-b* flag affects
**only** the *output* vector - topology is always built for *error*
vector.

## EXAMPLES

### Snapping lines to vertex in threshold

```sh
v.clean input=testmap output=cleanmap tool=snap threshold=1
```

### Inspecting the topological errors visually

Both *[v.build](v.build.md)* and *v.clean* can collect the topological
errors into a vector map:

```sh
v.build -e map=imported error=build_errors
v.clean -c input=imported output=clean error=cleaning_errors tool=snap,rmdangle,rmbridge,chbridge,bpol,prune threshold=5
```

The vector maps can be visualized together with the original data by the
following set of display commands:

```sh
d.vect map=imported color=26:26:26 fill_color=77:77:77 width=5
d.vect map=build_errors color=255:33:36 fill_color=none width=5 icon=basic/point size=30
d.vect map=cleaning_errors color=255:33:36 fill_color=none width=5 icon=basic/point size=30
```

![topological errors](v_clean.png)  
*Figure: Topological errors detected in the original data (left) and
cleaned data (right)*

### Cleaning OGR imported data (Simple Feature data) such as SHAPE file

The import of areas with *[v.in.ogr](v.in.ogr.md) -c* (no cleaning)
requires a subsequent run of *v.clean* to update the map to a
topologically valid structure (removal of duplicate collinear lines
etc). The tools used for that are *bpol* and *rmdupl*:

```sh
v.clean input=areamap output=areamap_clean tool=bpol,rmdupl type=boundary
```

### Extracting intersection points of vector lines

```sh
v.clean input=lines1 output=lines2 err=points tool=break type=line
```

Intersection points are written to 'points' map.

### Break lines

*v.clean* will break the lines where they cross, creating new node if
needed. Example:

```sh
v.in.ascii -n out=crossed_lines format=standard << EOF
L 2
 0 5
 10 5
L 2
 5 0
 5 10
EOF

v.clean in=crossed_lines out=crossed_lines_brk \
        error=intersection tool=break type=line
```

### Remove all lines of zero length

```sh
v.out.ascii zero format=standard
L  2 1
 -819832.09065589 -987825.2187231
 -806227.28362601 -971104.80702988
 1     1
L  2 1
 -799165.24638913 -972974.16982788
 -799165.24638913 -972974.16982788
 1     2

v.clean input=zero output=zero_clean tool=rmline type=line

v.out.ascii zero_clean format=standard
L  2 1
 -819832.09065589 -987825.2187231
 -806227.28362601 -971104.80702988
 1     1
```

v.clean type=boundary would remove nothing.

### Repeatedly remove dangling lines up to 50m length

```sh
v.clean input=testmap output=cleanmap type=line \
        tool=rmdangle,rmdangle,rmdangle,rmdangle threshold=5,10,20,50
```

## SEE ALSO

*[v.info](v.info.md), [v.build](v.build.md),
[g.gui.vdigit](g.gui.vdigit.md), [v.edit](v.edit.md),
[v.fill.holes](v.fill.holes.md), [v.generalize](v.generalize.md)*

## AUTHORS

David Gerdes, U.S. Army Construction Engineering Research Laboratory  
Radim Blazek, ITC-irst, Trento, Italy  
Martin Landa, FBK-irst (formerly ITC-irst), Trento, Italy

## SOURCE CODE

Available at: [v.clean source code](https://github.com/OSGeo/grass/tree/main/vector/v.clean)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.clean))  
Latest change: Sunday Jul 27 05:53:30 2025 in commit [da40958](https://github.com/OSGeo/grass/commit/da409580ef15011f3bac379c76d41101c9e36347)
