---
name: v.db.reconnect.all.py
description: Reconnects attribute tables for all vector maps from the current mapset to a new database.
keywords: [ vector, attribute table, database, DBF, SQLite ]
---

# v.db.reconnect.all.py

Reconnects attribute tables for all vector maps from the current mapset to a new database.

=== "Command line"

    **v.db.reconnect.all.py**
    [**-cd**]
    [**old_database**=*name*]
    [**old_schema**=*name*]
    [**new_driver**=*string*]
    [**new_database**=*name*]
    [**new_schema**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.db.reconnect.all.py
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.db.reconnect.all.py***",
        **old_database**=*None*,
        **old_schema**=*None*,
        **new_driver**=*None*,
        **new_database**=*None*,
        **new_schema**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.db.reconnect.all.py")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_db_reconnect_all_py*(**old_database**=*None*,
        **old_schema**=*None*,
        **new_driver**=*None*,
        **new_database**=*None*,
        **new_schema**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_db_reconnect_all_py()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **old_database**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of source database  
    **old_schema**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of source database schema  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not use this option if schemas are not supported by driver/database server  
    **new_driver**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for target driver  
    **new_database**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for target database  
    **new_schema**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for target database schema  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not use this option if schemas are not supported by driver/database server  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Copy attribute tables to the target database if not exist  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Delete attribute tables from the source database  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **old_database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of source database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    **old_schema** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of source database schema  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not use this option if schemas are not supported by driver/database server  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **new_driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for target driver  
    **new_database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for target database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    **new_schema** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for target database schema  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not use this option if schemas are not supported by driver/database server  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Copy attribute tables to the target database if not exist  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Delete attribute tables from the source database  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **old_database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of source database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    **old_schema** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of source database schema  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not use this option if schemas are not supported by driver/database server  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **new_driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for target driver  
    **new_database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for target database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    **new_schema** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for target database schema  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not use this option if schemas are not supported by driver/database server  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Copy attribute tables to the target database if not exist  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Delete attribute tables from the source database  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.db.reconnect.all* changes database connection of all layers of all
vector maps in the current mapset from the source (**old_database**) to
the target (**new_database**) database. If a link does not match the
**old_database** it is left untouched.

If no new database is given, the default datase of the mapset is used as
printed by `db.connect -g`. If no old database is given, all layers
without a link in the new database will be liniked to the new database.
If an old database is given, only links in the old database will be
changed.

Optionally attribute tables in **new_database** can be created if not
exist by **-c** flag. In this case *v.db.reconnect.all* also tries to
create an index on key column (usually "cat" column).

## NOTES

The value of the **old_database** option needs to be the exact string
which appears as the fourth field printed by `v.db.connect -g`.

```sh
v.db.connect -g map=census
1/census|census|cat|/home/user/grassdata/nc_spm_base/PERMANENT/dbf/|dbf
```

*v.db.reconnect.all* respect also variables to be substituted. In the
example above, database
`/home/user/grassdata/nc_spm_base/PERMANENT/dbf/` can be also defined as
`'$GISDBASE/$LOCATION_NAME/$MAPSET/dbf/'` (see examples).

Attribute tables from **old_database** are after reconnecting left
untouched. *v.db.reconnect.all* deletes those tables automatically only
when **-d** flag is given.

Also note that *v.db.reconnect.all* doesn't change default database
driver or database (`db.connect -p`). Default database connection
settings for newly created attribute data can be defined by
*[db.connect](db.connect.md)*.

## EXAMPLES

In the examples below are assumed, that attribute tables are linked to
the vector maps through [DBF](grass-dbf.md) database driver.

### Reconnect DBF attribute tables to SQLite database

Reconnect [DBF](grass-dbf.md) attribute tables linked to the vector maps
in the current mapset to [SQLite](grass-sqlite.md) database:

```sh
v.db.reconnect.all old_database='$GISDBASE/$LOCATION_NAME/$MAPSET/dbf/' \
 new_driver=sqlite new_database='$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db'
```

If attribute table doesn't exist in the target database
(**new_database**) then the module prints an error message.

### Convert DBF attribute tables to SQLite database

For coping DBF tables to SQLite database and reconnecting them for all
vector maps in the current mapset must be defined also **-c** flag.

```sh
v.db.reconnect.all -c old_database='$GISDBASE/$LOCATION_NAME/$MAPSET/dbf/' \
 new_driver=sqlite new_database='$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db'
```

or alternatively

```sh
# set default connection (sqlite)
db.connect -d
# verify default connection
db.connect -g
# reconnect
v.db.reconnect.all -c old_database='$GISDBASE/$LOCATION_NAME/$MAPSET/dbf/'
```

To automatically remove original DBF attribute tables after reconnecting
the vector maps use **-d** flag. Note that attribute tables will be
deleted *permanently* from the source database. This option should be
used very carefully!

### Convert GRASS 6 vector map to GRASS 7

To become usable in GRASS 7, all vector maps in a mapset need to be
updated:

```sh
# first rebuild topology for all vector maps
v.build.all

# set new default db connection (to SQLite default)
db.connect -d

# copy attribute tables from old DB to new SQLite DB, delete old tables in DBF format
v.db.reconnect.all -cd
```

## SEE ALSO

*[v.db.connect](v.db.connect.md), [db.connect](db.connect.md),
[db.copy](db.copy.md), [db.createdb](db.createdb.md),
[db.droptable](db.droptable.md)*

*[GRASS SQL interface](sql.md)*

## AUTHORS

Radim Blazek  
Major update by Martin Landa, Czech Technical University in Prague,
Czech Republic

## SOURCE CODE

Available at: [v.db.reconnect.all source code](https://github.com/OSGeo/grass/tree/main/scripts/v.db.reconnect.all)
([history](https://github.com/OSGeo/grass/commits/main/scripts/v.db.reconnect.all))  
Latest change: Wednesday Nov 12 08:25:04 2025 in commit [631d74b](https://github.com/OSGeo/grass/commit/631d74bc6dbc09177e9c50eaf5debf9b107f7401)
