---
name: v.in.db
description: Creates new vector (points) map from database table containing coordinates.
keywords: [ vector, import, database, points ]
---

# v.in.db

Creates new vector (points) map from database table containing coordinates.

=== "Command line"

    **v.in.db**
    [**-t**]
    **table**=*name*
    [**driver**=*name*]
    [**database**=*name*]
    **x**=*name*
    **y**=*name*
    [**z**=*name*]
    [**key**=*name*]
    [**where**=*sql_query*]
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.in.db table=name x=name y=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.in.db***",
        **table**,
        **driver**=*"sqlite"*,
        **database**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db"*,
        **x**,
        **y**,
        **z**=*None*,
        **key**=*None*,
        **where**=*None*,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.in.db", table="name", x="name", y="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_in_db*(**table**,
        **driver**=*"sqlite"*,
        **database**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db"*,
        **x**,
        **y**,
        **z**=*None*,
        **key**=*None*,
        **where**=*None*,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_in_db(table="name", x="name", y="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **table**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input table name  
    **driver**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, pg, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **x**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column containing x coordinate  
    **y**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column containing y coordinate  
    **z**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column containing z coordinate  
    **key**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column containing category number  
    &nbsp;&nbsp;&nbsp;&nbsp;Must refer to an integer column  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use imported table as attribute table for new map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **table** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input table name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbtable, *name*  
    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, pg, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **x** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column containing x coordinate  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **y** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column containing y coordinate  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **z** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column containing z coordinate  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **key** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column containing category number  
    &nbsp;&nbsp;&nbsp;&nbsp;Must refer to an integer column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use imported table as attribute table for new map  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **table** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input table name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbtable, *name*  
    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, pg, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **x** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column containing x coordinate  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **y** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column containing y coordinate  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **z** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column containing z coordinate  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **key** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column containing category number  
    &nbsp;&nbsp;&nbsp;&nbsp;Must refer to an integer column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use imported table as attribute table for new map  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.in.db* creates a new vector point map from database table or file
containing coordinates.

## NOTES

If GRASS comes with [OGR](grass-ogr.md) support than *v.in.db* allows
importing data from different input files, eg. CSV or MS Excel (assuming
that GDAL/OGR library is compiled with this support).

*v.in.db* creates key column "cat" automatically when **key** option is
not given. Note that this operation is possible to perform only when
**-t** flag is not given. Currently, automated creation of key column is
supported only when default DB driver for output vector map is [SQLite
driver](grass-sqlite.md) otherwise **key** option must be specified by
the user. Default DB driver is defined by *[db.connect](db.connect.md)*.

## EXAMPLES

### Creating a map from PostgreSQL table

```sh
v.in.db driver=pg database="host=myserver.itc.it,dbname=mydb" \
        table=pat_stazioni x=east y=north z=quota key=id output=pat_stazioni
```

If an ID column is not present in the PostgreSQL table, a new column
should be added. See [PostgreSQL DB driver](grass-pg.md) page for
details.

### Creating a map from PostGIS

To extract coordinate values from PostGIS, functions have to be used:

```sh
v.in.db driver=pg database="host=myserver.itc.it,dbname=mydb" \
        table=station x="x(geom)" y="y(geom)" z="z(geom)" key=id out=meteostations
```

If an ID column is not present in the PostgreSQL table, a new column
should be added. See [PostgreSQL DB driver](grass-pg.md) page for
details.

Alternatively a vector point map can be imported from PostGIS database
using *[v.in.ogr](v.in.ogr.md)*.

### Creating a map from Open Document spreadsheet (ODS) file

A new vector point map is created from given sheet in ODS file. The
**database** option points to the ODS file. Option **table** is the name
of selected spreadsheet list, the **key** option is the identifier
column:

```sh
# preview table structure with OGR tool (table name is "Layer name" here):
ogrinfo -al -so meteodata.ods

# import sheet from ODS into map
v.in.db key=ID table=mysheet x=long y=lat z=height output=meteodata \
         driver=ogr database=meteodata.ods
```

### Creating a map from MS Excel file

A new vector point map is created from given sheet in MS Excel file. The
**database** option points to the file in MS Excel format. Option
**table** is name of the selected spreadsheet "List1":

```sh
v.in.db table=List1 x=long y=lat z=height output=meteodata \
         driver=ogr database=meteodata.xls
```

Note that in this example the **key** option is omitted. In this case
*v.in.db* tries to add key column automatically. This requires
[SQLite](grass-sqlite.md) to be a default DB driver.

### Creating a map from DBF table

A new 3D point vector map is created from DBF table. Column 'idcol'
contains unique row IDs. The **database** option is the directory where
the DBF file is stored.

```sh
v.in.db driver=dbf database=/home/user/tables/ table=pointsfile x=x y=y z=z \
        key=idcol out=dtmpoints
```

To check result:

```sh
v.info dtmpoints
v.info -c dtmpoints
```

If DB driver for output vector map is different from SQLite driver and
an ID column is missing in the DBF file, it has to be added beforehand,
e.g. with OpenOffice. Alternatively, import the table with
*[db.in.ogr](db.in.ogr.md)* into GRASS and then with *v.in.db* from the
imported table (*[db.in.ogr](db.in.ogr.md)* optionally adds an unique ID
column).

### Creating a point map from DBF table for selected records only

The user can import only selected vector points from a table using the
**where** parameter (see above for general DBF handling):

```sh
v.in.db driver=dbf  database=/home/user/tables/ table=pointsfile x=x y=y z=z \
        key=idcol out=dtmpoints where="x NOT NULL and z > 100"
```

### Creating a map from SQLite table

A new vector point map is created from table in SQLite database file.
Column 'idcol' contains unique row IDs. The **database** option is the
the SQLite database file.

```sh
v.in.db driver=sqlite database=/home/user/tables/mysqlite.db table=pointsfile x=x y=y z=z \
        key=idcol out=dtmpoints
```

## SEE ALSO

*[db.execute](db.execute.md), [db.in.ogr](db.in.ogr.md),
[v.info](v.info.md), [v.in.geonames](v.in.geonames.md),
[v.in.ogr](v.in.ogr.md), [v.to.db](v.to.db.md)*

[SQL support in GRASS](sql.md)

## AUTHORS

Radim Blazek  
Various updates for GRASS 7 by Martin Landa, Czech Technical University
in Prague, Czech Republic

## SOURCE CODE

Available at: [v.in.db source code](https://github.com/OSGeo/grass/tree/main/vector/v.in.db)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.in.db))  
Latest change: Friday Sep 05 13:38:35 2025 in commit [ba8bacf](https://github.com/OSGeo/grass/commit/ba8bacf1885bf46c06623094659497cf6adf3fcb)
