#############################################################################
#
# MODULE:   	Grass Compilation
# AUTHOR(S):	Original author unknown - probably CERL
#		Markus Neteler - Germany/Italy - neteler@itc.it
#   	    	Justin Hickey - Thailand - jhickey@hpcc.nectec.or.th
#   	    	Huidae Cho - Korea - grass4u@gmail.com
#   	    	Eric G. Miller - egm2@jps.net
# PURPOSE:  	The source file for this Makefile is in src/CMD/head/head.in.
#		It is the top part of a file called make.rules which is used
#		for compiling all GRASS modules. This part of the file provides
#		make variables that are dependent on the results of the
#		configure script.
# COPYRIGHT:    (C) 2000 by the GRASS Development Team
#
#               This program is free software under the GNU General Public
#   	    	License (>=v2). Read the file COPYING that comes with GRASS
#   	    	for details.
#
#############################################################################

############################## Make Variables ###############################

CC                  = x86_64-w64-mingw32-gcc
CXX                 = x86_64-w64-mingw32-g++
LEX                 = flex
YACC                = bison -y
PERL                = /usr/bin/perl
AR                  = ar
RANLIB              = ranlib
MKDIR               = mkdir -p
CHMOD               = chmod
INSTALL             = /usr/bin/install -c
INSTALL_DATA        = ${INSTALL} -m 644

prefix              = /C/src/osgeo4w/src/GRASS-~1/osgeo4w/osgeo4w/apps/grass
exec_prefix         = ${prefix}
ARCH                = x86_64-w64-mingw32
UNIX_BIN            = /C/src/osgeo4w/src/GRASS-~1/osgeo4w/osgeo4w/bin
INST_DIR            = ${prefix}/grass85

GRASS_HOME          = /C/src/osgeo4w/src/GRASS-~1/osgeo4w/osgeo4w/apps/grass/grass85
RUN_GISBASE         = C:/src/osgeo4w/src/grass-dev/grass/dist.x86_64-w64-mingw32

GRASS_VERSION_MAJOR = 8
GRASS_VERSION_MINOR = 5
GRASS_VERSION_RELEASE = 0dev
GRASS_VERSION_DATE  = 2025
GRASS_VERSION_GIT   = d8716dcc0

STRIPFLAG           = 
LD_SEARCH_FLAGS     = 
LD_LIBRARY_PATH_VAR = PATH

#generate static (ST) or shared (SH)
GRASS_LIBRARY_TYPE  = shlib

#static libs:
STLIB_LD            = ${AR} cr
STLIB_PREFIX        = lib
STLIB_SUFFIX        = .a

#shared libs
SHLIB_PREFIX        = lib
SHLIB_LD            = x86_64-w64-mingw32-gcc -shared
SHLIB_LDX           = x86_64-w64-mingw32-g++ -shared
SHLIB_LDFLAGS       = 
SHLIB_CFLAGS        = 
SHLIB_SUFFIX        = .dll
EXE                 = .exe

DEFAULT_DATABASE    =
DEFAULT_LOCATION    =

CPPFLAGS            =   -I/C/src/osgeo4w/src/GRASS-~1/osgeo4w/osgeo4w/include
CFLAGS              =  -pipe 
CXXFLAGS            =  -pipe
INCLUDE_DIRS        =  -I/C/src/osgeo4w/src/GRASS-~1/osgeo4w/osgeo4w/include
LINK_FLAGS          =   -Wl,--export-dynamic,--enable-runtime-pseudo-reloc  -L/C/src/osgeo4w/src/GRASS-~1/osgeo4w/osgeo4w/lib -L/C/src/osgeo4w/src/GRASS-~1/osgeo4w/osgeo4w/bin

DLLIB               = 
XCFLAGS             = 
XLIBPATH            = 
XLIB                =  
XEXTRALIBS          = 
USE_X11             = 

MATHLIB             = 
ICONVLIB            = -liconv
INTLLIB             = -lintl
SOCKLIB             = 

#ZLIB:
ZLIB                =  -lz 
ZLIBINCPATH         = 
ZLIBLIBPATH         = 

#BZIP2:
BZIP2LIB            =  -lbz2 
BZIP2INCPATH        = 
BZIP2LIBPATH        = 

#ZSTD:
ZSTDLIB             =  -lzstd 
ZSTDINCPATH         = 
ZSTDLIBPATH         = 

DBMIEXTRALIB        = 

#readline
READLINEINCPATH     = 
READLINELIBPATH     = 
READLINELIB         =  -lreadline 
HISTORYLIB          =  -lhistory 

#PostgreSQL:
PQINCPATH           =  -I/C/src/osgeo4w/src/GRASS-~1/osgeo4w/osgeo4w/include
PQLIBPATH           =  -L/c/src/osgeo4w/src/grass-dev/grass/mswindows/osgeo4w/lib
PQLIB               =  -lpq 
USE_POSTGRES        = 1

#MySQL:
MYSQLINCPATH        = 
MYSQLLIBPATH        = 
MYSQLLIB            = 
MYSQLDLIB           = 

#SQLite:
SQLITEINCPATH       =  -I/C/src/osgeo4w/src/GRASS-~1/osgeo4w/osgeo4w/include
SQLITELIBPATH       =  -L/C/src/osgeo4w/src/GRASS-~1/osgeo4w/osgeo4w/lib
SQLITELIB           =  -lsqlite3 

#ODBC:
ODBCINC             = 
ODBCLIB             =  -lodbc32 

#Image formats:
PNGINC              = -I/C/src/osgeo4w/src/GRASS-~1/osgeo4w/osgeo4w/include/libpng16
PNGLIB              = -L/C/src/osgeo4w/src/GRASS-~1/osgeo4w/osgeo4w/lib -lpng16 -lm -lz
USE_PNG             = 1

TIFFINCPATH         = 
TIFFLIBPATH         = 
TIFFLIB             =  -ltiff 

#openGL files for NVIZ/r3.showdspf
OPENGLINC           = 
OPENGLLIB           =   -lopengl32 
OPENGLULIB          =   -lglu32 
OPENGL_X11          = 
OPENGL_AQUA         = 
OPENGL_WINDOWS      = 1
USE_OPENGL          = 1

#FFTW:
FFTWINC             = 
FFTWLIB             =  -lfftw3 

#LAPACK/BLAS stuff for gmath lib:
BLASLIB             = -LC:/src/osgeo4w/src/grass-dev/osgeo4w/msys64/mingw64/bin/../lib -lopenblas
BLASINC             = -IC:/src/osgeo4w/src/grass-dev/osgeo4w/msys64/mingw64/bin/../include/openblas -fopenmp
LAPACKLIB           = -LC:/src/osgeo4w/src/grass-dev/osgeo4w/msys64/mingw64/bin/../lib -lopenblas
LAPACKINC           = -IC:/src/osgeo4w/src/grass-dev/osgeo4w/msys64/mingw64/bin/../include/openblas -fopenmp

#LIBSVM
LIBSVM_LIB          = 
LIBSVM_INC          = 
USE_LIBSVM          = 

#GDAL/OGR
GDALLIBS            = /C/src/osgeo4w/src/GRASS-~1/osgeo4w/osgeo4w/lib/gdal_i.lib
GDALCFLAGS          = -I/C/src/osgeo4w/src/GRASS-~1/osgeo4w/osgeo4w/include

#NetCDF
NETCDFLIBS          = -L/C/src/osgeo4w/src/grass-dev/osgeo4w/osgeo4w/lib -lnetcdf
NETCDFCFLAGS        = -I/C/src/osgeo4w/src/grass-dev/osgeo4w/osgeo4w/include
USE_NETCDF          = 1

#LAS LiDAR through libLAS
LASLIBS             = /C/src/osgeo4w/src/GRASS-~1/osgeo4w/osgeo4w/lib/liblas_c.lib
LASCFLAGS           = 
LASINC              = -I/C/src/osgeo4w/src/GRASS-~1/osgeo4w/osgeo4w/include
USE_LIBLAS          = 1

#LAS LiDAR through PDAL
PDALLIBS             = 
PDALINC              = 
USE_PDAL             = 

#GEOS
GEOSLIBS            = /C/src/osgeo4w/src/GRASS-~1/osgeo4w/osgeo4w/lib/geos_c.lib -lgeos_c 
GEOSCFLAGS          = -I/C/src/osgeo4w/src/GRASS-~1/osgeo4w/osgeo4w/include
USE_GEOS            = 1

#FreeType:
FTINC               =  -I/C/src/osgeo4w/src/GRASS-~1/osgeo4w/osgeo4w/include/freetype2
FTLIB               =  -lfreetype 

#PROJ.4:
PROJINC             =  -I/C/src/osgeo4w/src/GRASS-~1/osgeo4w/osgeo4w/include
PROJLIB             =  -L/C/src/osgeo4w/src/GRASS-~1/osgeo4w/osgeo4w/lib -lproj 
PROJSHARE           = /C/src/osgeo4w/src/GRASS-~1/osgeo4w/osgeo4w/share/proj

#cairo
CAIROINC                  =  -I/C/src/osgeo4w/src/GRASS-~1/osgeo4w/osgeo4w/include
CAIROLIB                  =  -L/C/src/osgeo4w/src/GRASS-~1/osgeo4w/osgeo4w/lib -L/c/src/osgeo4w/src/grass-dev/grass/mswindows/osgeo4w/lib -lcairo 
USE_CAIRO                 = 1
CAIRO_HAS_XRENDER         = 
CAIRO_HAS_XRENDER_SURFACE = 

#Python
PYTHON              = python3

#regex
REGEXINCPATH        = 
REGEXLIBPATH        = 
REGEXLIB            =  -lregex 
USE_REGEX           = 1

#pthreads
PTHREADINCPATH      = 
PTHREADLIBPATH      = 
PTHREADLIB          = 
USE_PTHREAD         = 

#OpenMP
OPENMP_INCPATH      = 
OPENMP_LIBPATH      = 
OPENMP_LIB          =  -lgomp 
OPENMP_CFLAGS       = -fopenmp
USE_OPENMP          = 1

#OpenCL
OCLINCPATH          = 
OCLLIBPATH          = 
OCLLIB              = 
USE_OPENCL          = 

#i18N
HAVE_NLS            = 1

#Large File Support (LFS)
USE_LARGEFILES      = @USE_LARGEFILES@
LFS_CFLAGS          = -D_FILE_OFFSET_BITS=64

#BSD sockets
HAVE_SOCKET         = 

MINGW		    = yes
WINDRES		    = windres
MACOSX_APP	    = 
MACOSX_ARCHS        = 
MACOSX_SDK          = 

# Cross compilation
CROSS_COMPILING     = 
